/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.StringWriter;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SlimeOutputStream
extends Stream {
    private final StringWriter stringWriter;
    final Function f;
    private static final Primitive MAKE_SLIME_OUTPUT_STREAM = new Primitive("make-slime-output-stream", Lisp.PACKAGE_EXT, true, "function"){

        @Override
        public LispObject execute(LispObject arg) {
            Function fun = arg instanceof Symbol ? (Function)arg.getSymbolFunction() : (Function)arg;
            return new SlimeOutputStream(fun);
        }
    };

    SlimeOutputStream(Function f) {
        super(Symbol.SLIME_OUTPUT_STREAM);
        this.elementType = Symbol.CHARACTER;
        this.isInputStream = false;
        this.isOutputStream = true;
        this.isCharacterStream = true;
        this.isBinaryStream = false;
        this.eolStyle = Stream.EolStyle.LF;
        this.stringWriter = new StringWriter();
        this.setWriter(this.stringWriter);
        this.f = f;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.SLIME_OUTPUT_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SLIME_OUTPUT_STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SLIME_OUTPUT_STREAM) {
            return Lisp.T;
        }
        if (type == Symbol.STRING_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SLIME_OUTPUT_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRING_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public void _writeChar(char c) {
        if (this.elementType == Lisp.NIL) {
            this.writeError();
        }
        super._writeChar(c);
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        if (this.elementType == Lisp.NIL) {
            this.writeError();
        }
        super._writeChars(chars, start, end);
    }

    @Override
    public void _writeString(String s) {
        if (this.elementType == Lisp.NIL) {
            this.writeError();
        }
        super._writeString(s);
    }

    @Override
    public void _writeLine(String s) {
        if (this.elementType == Lisp.NIL) {
            this.writeError();
        }
        super._writeLine(s);
    }

    private void writeError() {
        Lisp.error(new TypeError("Attempt to write to a string output stream of element type NIL."));
    }

    @Override
    protected long _getFilePosition() {
        if (this.elementType == Lisp.NIL) {
            return 0L;
        }
        return this.stringWriter.toString().length();
    }

    @Override
    public void _finishOutput() {
        super._finishOutput();
        if (this.stringWriter.getBuffer().length() > 0) {
            String s = this.stringWriter.toString();
            this.stringWriter.getBuffer().setLength(0);
            LispThread.currentThread().execute((LispObject)this.f, new SimpleString(s));
        }
    }
}

