/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.ObdDecoder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class CastelProtocolDecoder
extends BaseProtocolDecoder {
    private static final Map<Integer, Integer> PID_LENGTH_MAP = new HashMap<Integer, Integer>();
    public static final short MSG_SC_LOGIN = 4097;
    public static final short MSG_SC_LOGIN_RESPONSE = -28671;
    public static final short MSG_SC_LOGOUT = 4098;
    public static final short MSG_SC_HEARTBEAT = 4099;
    public static final short MSG_SC_HEARTBEAT_RESPONSE = -28669;
    public static final short MSG_SC_GPS = 16385;
    public static final short MSG_SC_PID_DATA = 16386;
    public static final short MSG_SC_G_SENSOR = 16387;
    public static final short MSG_SC_SUPPORTED_PID = 16388;
    public static final short MSG_SC_OBD_DATA = 16389;
    public static final short MSG_SC_DTCS_PASSENGER = 16390;
    public static final short MSG_SC_DTCS_COMMERCIAL = 16395;
    public static final short MSG_SC_ALARM = 16391;
    public static final short MSG_SC_CELL = 16392;
    public static final short MSG_SC_GPS_SLEEP = 16393;
    public static final short MSG_SC_FUEL = 16398;
    public static final short MSG_SC_AGPS_REQUEST = 20737;
    public static final short MSG_SC_QUERY_RESPONSE = -24574;
    public static final short MSG_SC_CURRENT_LOCATION = -20479;
    public static final short MSG_CC_LOGIN = 16385;
    public static final short MSG_CC_LOGIN_RESPONSE = -32767;
    public static final short MSG_CC_HEARTBEAT = 16902;
    public static final short MSG_CC_PETROL_CONTROL = 17795;
    public static final short MSG_CC_HEARTBEAT_RESPONSE = -32250;

    public CastelProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position readPosition(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        double lat = (double)buf.readUnsignedIntLE() / 3600000.0;
        double lon = (double)buf.readUnsignedIntLE() / 3600000.0;
        position.setSpeed(UnitsConverter.knotsFromCps(buf.readUnsignedShortLE()));
        position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
        short flags = buf.readUnsignedByte();
        if ((flags & 2) == 0) {
            lat = -lat;
        }
        if ((flags & 1) == 0) {
            lon = -lon;
        }
        position.setLatitude(lat);
        position.setLongitude(lon);
        position.setValid((flags & 0xC) > 0);
        position.set("sat", flags >> 4);
        return position;
    }

    private Position createPosition(DeviceSession deviceSession) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        return position;
    }

    private void decodeObd(Position position, ByteBuf buf, boolean groups) {
        int i;
        int count = buf.readUnsignedByte();
        int[] pids = new int[count];
        for (i = 0; i < count; ++i) {
            pids[i] = buf.readUnsignedShortLE() & 0xFF;
        }
        if (groups) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
        }
        for (i = 0; i < count; ++i) {
            int value;
            switch (PID_LENGTH_MAP.get(pids[i])) {
                case 1: {
                    value = buf.readUnsignedByte();
                    break;
                }
                case 2: {
                    value = buf.readUnsignedShortLE();
                    break;
                }
                case 4: {
                    value = buf.readIntLE();
                    break;
                }
                default: {
                    value = 0;
                }
            }
            position.add(ObdDecoder.decodeData(pids[i], value, false));
        }
    }

    private void decodeStat(Position position, ByteBuf buf) {
        buf.readUnsignedIntLE();
        buf.readUnsignedIntLE();
        position.set("odometer", buf.readUnsignedIntLE());
        position.set("tripOdometer", buf.readUnsignedIntLE());
        position.set("fuelConsumption", buf.readUnsignedIntLE());
        buf.readUnsignedShortLE();
        long state = buf.readUnsignedIntLE();
        position.set("alarm", BitUtil.check(state, 4) ? "hardAcceleration" : null);
        position.set("alarm", BitUtil.check(state, 5) ? "hardBraking" : null);
        position.set("alarm", BitUtil.check(state, 6) ? "idle" : null);
        position.set("ignition", BitUtil.check(state, 18));
        position.set("status", state);
        buf.skipBytes(8);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int version, ByteBuf id, short type, ByteBuf content) {
        if (channel != null) {
            int length = 5 + id.readableBytes() + 2 + 2 + 2;
            if (content != null) {
                length += content.readableBytes();
            }
            ByteBuf response = Unpooled.buffer((int)length);
            response.writeByte(64);
            response.writeByte(64);
            response.writeShortLE(length);
            response.writeByte(version);
            response.writeBytes(id);
            response.writeShort((int)type);
            if (content != null) {
                response.writeBytes(content);
                content.release();
            }
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_X25, response.nioBuffer(0, response.writerIndex())));
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, ByteBuf id, short type) {
        if (channel != null) {
            int length = 4 + id.readableBytes() + 2 + 4 + 8 + 2 + 2;
            ByteBuf response = Unpooled.buffer((int)length);
            response.writeByte(64);
            response.writeByte(64);
            response.writeShortLE(length);
            response.writeBytes(id);
            response.writeShort((int)type);
            response.writeIntLE(0);
            for (int i = 0; i < 8; ++i) {
                response.writeByte(255);
            }
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_X25, response.nioBuffer(0, response.writerIndex())));
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void decodeAlarm(Position position, int alarm) {
        switch (alarm) {
            case 1: {
                position.set("alarm", "overspeed");
                break;
            }
            case 2: {
                position.set("alarm", "lowPower");
                break;
            }
            case 3: {
                position.set("alarm", "temperature");
                break;
            }
            case 4: {
                position.set("alarm", "hardAcceleration");
                break;
            }
            case 5: {
                position.set("alarm", "hardBraking");
                break;
            }
            case 6: {
                position.set("alarm", "idle");
                break;
            }
            case 7: {
                position.set("alarm", "tow");
                break;
            }
            case 8: {
                position.set("alarm", "highRpm");
                break;
            }
            case 9: {
                position.set("alarm", "powerOn");
                break;
            }
            case 11: {
                position.set("alarm", "laneChange");
                break;
            }
            case 12: {
                position.set("alarm", "hardCornering");
                break;
            }
            case 14: {
                position.set("alarm", "powerOff");
                break;
            }
            case 22: {
                position.set("ignition", true);
                break;
            }
            case 23: {
                position.set("ignition", false);
                break;
            }
        }
    }

    private Object decodeSc(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int version, ByteBuf id, short type, DeviceSession deviceSession) {
        switch (type) {
            case 4099: {
                this.sendResponse(channel, remoteAddress, version, id, (short)-28669, null);
                return null;
            }
            case -20479: 
            case 4097: 
            case 4098: 
            case 16385: 
            case 16391: 
            case 16398: {
                if (type == 4097) {
                    ByteBuf response = Unpooled.buffer((int)10);
                    response.writeIntLE(-1);
                    response.writeShortLE(0);
                    response.writeIntLE((int)(System.currentTimeMillis() / 1000L));
                    this.sendResponse(channel, remoteAddress, version, id, (short)-28671, response);
                }
                if (type == 16385) {
                    buf.readUnsignedByte();
                } else if (type == 16391) {
                    buf.readUnsignedIntLE();
                } else if (type == -20479) {
                    buf.readUnsignedShortLE();
                }
                buf.readUnsignedIntLE();
                buf.readUnsignedIntLE();
                long odometer = buf.readUnsignedIntLE();
                long tripOdometer = buf.readUnsignedIntLE();
                long fuelConsumption = buf.readUnsignedIntLE();
                buf.readUnsignedShortLE();
                long status = buf.readUnsignedIntLE();
                buf.skipBytes(8);
                int count = buf.readUnsignedByte();
                LinkedList<Position> positions = new LinkedList<Position>();
                for (int i = 0; i < count; ++i) {
                    Position position = this.readPosition(deviceSession, buf);
                    position.set("odometer", odometer);
                    position.set("tripOdometer", tripOdometer);
                    position.set("fuelConsumption", fuelConsumption);
                    position.set("status", status);
                    positions.add(position);
                }
                if (type == 16391) {
                    int alarmCount = buf.readUnsignedByte();
                    for (int i = 0; i < alarmCount; ++i) {
                        if (buf.readUnsignedByte() == 0) continue;
                        short alarm = buf.readUnsignedByte();
                        for (Position p : positions) {
                            this.decodeAlarm(p, alarm);
                        }
                        buf.readUnsignedShortLE();
                        buf.readUnsignedShortLE();
                    }
                } else if (type == 16398) {
                    for (Position p : positions) {
                        p.set("adc1", buf.readUnsignedShortLE());
                    }
                }
                return positions.isEmpty() ? null : positions;
            }
            case 16393: {
                buf.readUnsignedIntLE();
                return this.readPosition(deviceSession, buf);
            }
            case 20737: {
                return this.readPosition(deviceSession, buf);
            }
            case 16386: {
                Position position = this.createPosition(deviceSession);
                this.decodeStat(position, buf);
                buf.readUnsignedShortLE();
                this.decodeObd(position, buf, true);
                return position;
            }
            case 16387: {
                Position position = this.createPosition(deviceSession);
                this.decodeStat(position, buf);
                buf.readUnsignedShortLE();
                int count = buf.readUnsignedByte();
                StringBuilder data = new StringBuilder("[");
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        data.append(",");
                    }
                    data.append("[");
                    data.append((double)buf.readShortLE() * 0.015625);
                    data.append(",");
                    data.append((double)buf.readShortLE() * 0.015625);
                    data.append(",");
                    data.append((double)buf.readShortLE() * 0.015625);
                    data.append("]");
                }
                data.append("]");
                position.set("gSensor", data.toString());
                return position;
            }
            case 16390: {
                Position position = this.createPosition(deviceSession);
                this.decodeStat(position, buf);
                buf.readUnsignedByte();
                position.add(ObdDecoder.decodeCodes(ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)buf.readUnsignedByte()))));
                return position;
            }
            case 16389: {
                Position position = this.createPosition(deviceSession);
                this.decodeStat(position, buf);
                buf.readUnsignedByte();
                this.decodeObd(position, buf, false);
                return position;
            }
            case 16392: {
                Position position = this.createPosition(deviceSession);
                this.decodeStat(position, buf);
                position.setNetwork(new Network(CellTower.fromLacCid(buf.readUnsignedShortLE(), buf.readUnsignedShortLE())));
                return position;
            }
            case -24574: {
                Position position = this.createPosition(deviceSession);
                buf.readUnsignedShortLE();
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                int failureCount = buf.readUnsignedByte();
                for (int i = 0; i < failureCount; ++i) {
                    buf.readUnsignedShortLE();
                }
                int successCount = buf.readUnsignedByte();
                for (int i = 0; i < successCount; ++i) {
                    buf.readUnsignedShortLE();
                    position.set("result", buf.readSlice(buf.readUnsignedShortLE()).toString(StandardCharsets.US_ASCII));
                }
                return position;
            }
        }
        return null;
    }

    private Object decodeCc(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int version, ByteBuf id, short type, DeviceSession deviceSession) {
        if (type == 16902) {
            this.sendResponse(channel, remoteAddress, version, id, (short)-32250, null);
            buf.readUnsignedByte();
            int count = buf.readUnsignedByte();
            LinkedList<Position> positions = new LinkedList<Position>();
            for (int i = 0; i < count; ++i) {
                Position position = this.readPosition(deviceSession, buf);
                position.set("status", buf.readUnsignedIntLE());
                position.set("battery", buf.readUnsignedByte());
                position.set("odometer", buf.readUnsignedIntLE());
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                position.setNetwork(new Network(CellTower.fromLacCid(buf.readUnsignedShortLE(), buf.readUnsignedShortLE())));
                positions.add(position);
            }
            return positions;
        }
        if (type == 16385) {
            this.sendResponse(channel, remoteAddress, version, id, (short)-32767, null);
            Position position = this.readPosition(deviceSession, buf);
            position.set("status", buf.readUnsignedIntLE());
            position.set("battery", buf.readUnsignedByte());
            position.set("odometer", buf.readUnsignedIntLE());
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            return position;
        }
        return null;
    }

    private Object decodeMpip(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int version, ByteBuf id, short type, DeviceSession deviceSession) {
        if (type == 16385) {
            this.sendResponse(channel, remoteAddress, version, id, type, null);
            return this.readPosition(deviceSession, buf);
        }
        if (type == 8193) {
            this.sendResponse(channel, remoteAddress, id, (short)4097);
            buf.readUnsignedIntLE();
            buf.readUnsignedIntLE();
            buf.readUnsignedByte();
            return this.readPosition(deviceSession, buf);
        }
        if (type == 16897 || type == 16898 || type == 16902) {
            return this.readPosition(deviceSession, buf);
        }
        if (type == 16900) {
            LinkedList<Position> positions = new LinkedList<Position>();
            for (int i = 0; i < 8; ++i) {
                Position position = this.readPosition(deviceSession, buf);
                buf.skipBytes(31);
                positions.add(position);
            }
            return positions;
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int header = buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        int version = -1;
        if (header == 16448) {
            version = buf.readUnsignedByte();
        }
        ByteBuf id = buf.readSlice(20);
        short type = buf.readShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id.toString(StandardCharsets.US_ASCII).trim());
        if (deviceSession == null) {
            return null;
        }
        switch (version) {
            case -1: {
                return this.decodeMpip(channel, remoteAddress, buf, version, id, type, deviceSession);
            }
            case 3: 
            case 4: {
                return this.decodeSc(channel, remoteAddress, buf, version, id, type, deviceSession);
            }
        }
        return this.decodeCc(channel, remoteAddress, buf, version, id, type, deviceSession);
    }

    static {
        int[] l1 = new int[]{4, 5, 6, 7, 8, 9, 11, 13, 14, 15, 17, 18, 19, 28, 29, 30, 44, 45, 46, 47, 48, 51, 67, 69, 70, 71, 72, 73, 74, 75, 76, 81, 82, 90};
        int[] l2 = new int[]{2, 3, 10, 12, 16, 20, 21, 22, 23, 24, 25, 26, 27, 31, 33, 34, 35, 49, 50, 60, 61, 62, 63, 66, 68, 77, 78, 80, 83, 84, 85, 86, 87, 88, 89};
        int[] l4 = new int[]{0, 1, 32, 36, 37, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 56, 57, 58, 59, 64, 65, 79};
        for (int i : l1) {
            PID_LENGTH_MAP.put(i, 1);
        }
        for (int i : l2) {
            PID_LENGTH_MAP.put(i, 2);
        }
        for (int i : l4) {
            PID_LENGTH_MAP.put(i, 4);
        }
    }
}

