/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notificators.Notificator;

public class NotificatorPushover
extends Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorPushover.class);
    private final String url;
    private final String token = Context.getConfig().getString(Keys.NOTIFICATOR_PUSHOVER_TOKEN);
    private final String user = Context.getConfig().getString(Keys.NOTIFICATOR_PUSHOVER_USER);

    public NotificatorPushover() {
        this.url = "https://api.pushover.net/1/messages.json";
    }

    @Override
    public void sendSync(long userId, Event event, Position position) {
        User user = Context.getPermissionsManager().getUser(userId);
        String device = "";
        if (user.getAttributes().containsKey("notificator.pushover.device")) {
            device = user.getString("notificator.pushover.device").replaceAll(" *, *", ",");
        }
        if (this.token == null) {
            LOGGER.warn("Pushover token not found");
            return;
        }
        if (this.user == null) {
            LOGGER.warn("Pushover user not found");
            return;
        }
        Message message = new Message();
        message.token = this.token;
        message.user = this.user;
        message.device = device;
        message.message = NotificationFormatter.formatShortMessage(userId, event, position);
        Context.getClient().target(this.url).request().async().post(Entity.json((Object)message), (InvocationCallback)new InvocationCallback<Object>(){

            public void completed(Object o) {
            }

            public void failed(Throwable throwable) {
                LOGGER.warn("Pushover API error", throwable);
            }
        });
    }

    @Override
    public void sendAsync(long userId, Event event, Position position) {
        this.sendSync(userId, event, position);
    }

    public static class Message {
        @JsonProperty(value="token")
        private String token;
        @JsonProperty(value="user")
        private String user;
        @JsonProperty(value="device")
        private String device;
        @JsonProperty(value="message")
        private String message;
    }
}

