/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.filter.Filter;
import net.fortuna.ical4j.filter.PeriodRule;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.traccar.database.QueryIgnore;
import org.traccar.model.ExtendedModel;

public class Calendar
extends ExtendedModel {
    private String name;
    private byte[] data;
    private net.fortuna.ical4j.model.Calendar calendar;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public void setData(byte[] data) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        this.calendar = builder.build(new ByteArrayInputStream(data));
        this.data = (byte[])data.clone();
    }

    @QueryIgnore
    @JsonIgnore
    public net.fortuna.ical4j.model.Calendar getCalendar() {
        return this.calendar;
    }

    public boolean checkMoment(Date date) {
        if (this.calendar != null) {
            Period period = new Period(new DateTime(date), Duration.ZERO);
            Filter filter = new Filter(new PeriodRule(period));
            Collection events = filter.filter(this.calendar.getComponents("VEVENT"));
            return events != null && !events.isEmpty();
        }
        return false;
    }
}

