/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.layer;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.parser.cert.CleanRecordByteSeperator;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.compressor.RecordDecompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Decryptor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.crypto.RecordDecryptor;
import de.rub.nds.tlsattacker.core.record.crypto.RecordEncryptor;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayer;
import de.rub.nds.tlsattacker.core.record.parser.BlobRecordParser;
import de.rub.nds.tlsattacker.core.record.preparator.AbstractRecordPreparator;
import de.rub.nds.tlsattacker.core.record.serializer.AbstractRecordSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlobRecordLayer
extends RecordLayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext context;
    private RecordCipher cipher;
    private final Encryptor encryptor;
    private final Decryptor decryptor;
    private RecordCompressor compressor;
    private RecordDecompressor decompressor;

    public BlobRecordLayer(TlsContext context) {
        this.context = context;
        this.cipher = new RecordNullCipher(context);
        this.encryptor = new RecordEncryptor(this.cipher, context);
        this.decryptor = new RecordDecryptor(this.cipher, context);
        this.compressor = new RecordCompressor(context);
        this.decompressor = new RecordDecompressor(context);
    }

    @Override
    public void updateCompressor() {
        this.compressor.setMethod(this.context.getChooser().getSelectedCompressionMethod());
    }

    @Override
    public void updateDecompressor() {
        this.decompressor.setMethod(this.context.getChooser().getSelectedCompressionMethod());
    }

    @Override
    public List<AbstractRecord> parseRecords(byte[] rawBytes) {
        LinkedList<AbstractRecord> list = new LinkedList<AbstractRecord>();
        BlobRecordParser parser = new BlobRecordParser(0, rawBytes, this.context.getChooser().getSelectedProtocolVersion());
        list.add(parser.parse());
        return list;
    }

    @Override
    public List<AbstractRecord> parseRecordsSoftly(byte[] rawBytes) {
        return this.parseRecords(rawBytes);
    }

    @Override
    public void decryptAndDecompressRecord(AbstractRecord record) {
        this.decryptor.decrypt(record);
        this.decompressor.decompress(record);
    }

    @Override
    public byte[] prepareRecords(byte[] data, ProtocolMessageType contentType, List<AbstractRecord> records) {
        CleanRecordByteSeperator seperator = new CleanRecordByteSeperator((List<AbstractRecord>)records, this.context.getConfig().getDefaultMaxRecordData(), 0, data);
        records = seperator.parse();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            AbstractRecord record = (AbstractRecord)iterator.next();
            AbstractRecordPreparator preparator = record.getRecordPreparator(this.context.getChooser(), this.encryptor, this.compressor, contentType);
            preparator.prepare();
            AbstractRecordSerializer serializer = record.getRecordSerializer();
            try {
                byte[] recordBytes = serializer.serialize();
                record.setCompleteRecordBytes(recordBytes);
                stream.write((byte[])record.getCompleteRecordBytes().getValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not write Record bytes to ByteArrayStream", ex);
            }
        }
        return stream.toByteArray();
    }

    @Override
    public void setRecordCipher(RecordCipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public void updateEncryptionCipher() {
        this.encryptor.addNewRecordCipher(this.cipher);
    }

    @Override
    public void updateDecryptionCipher() {
        this.decryptor.addNewRecordCipher(this.cipher);
    }

    @Override
    public AbstractRecord getFreshRecord() {
        return new BlobRecord(this.context.getConfig());
    }

    @Override
    public RecordCipher getEncryptorCipher() {
        return this.encryptor.getRecordMostRecentCipher();
    }

    @Override
    public RecordCipher getDecryptorCipher() {
        return this.decryptor.getRecordMostRecentCipher();
    }
}

