/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.ComparisonBoolFunction;

public class SolrComparisonBoolFunction
extends ComparisonBoolFunction {
    private final Compare cmp;

    public SolrComparisonBoolFunction(ValueSource lhs, ValueSource rhs, String name, Compare cmp) {
        super(lhs, rhs, name);
        this.cmp = cmp;
    }

    public boolean compare(int doc, FunctionValues lhs, FunctionValues rhs) throws IOException {
        boolean rhsAnInt;
        boolean lhsAnInt = lhs instanceof LongDocValues || lhs instanceof IntDocValues;
        boolean bl = rhsAnInt = rhs instanceof LongDocValues || rhs instanceof IntDocValues;
        if (lhsAnInt && rhsAnInt) {
            return this.cmp.compare(Long.compare(lhs.longVal(doc), rhs.longVal(doc)));
        }
        return this.cmp.compare(Double.compare(lhs.doubleVal(doc), rhs.doubleVal(doc)));
    }

    public static interface Compare {
        public boolean compare(int var1);
    }
}

