/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.solr.client.solrj.io.stream.ParallelListStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MaxMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MeanMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.io.stream.metrics.MinMetric;
import org.apache.solr.client.solrj.io.stream.metrics.SumMetric;
import org.apache.solr.client.solrj.io.stream.metrics.WeightedSumMetric;

public interface ParallelMetricsRollup {
    public TupleStream[] parallelize(List<String> var1) throws IOException;

    public TupleStream getSortedRollupStream(ParallelListStream var1, Metric[] var2) throws IOException;

    default public Optional<TupleStream> openParallelStream(StreamContext context, List<String> partitions, Metric[] metrics) throws IOException {
        Optional<Metric[]> maybeRollupMetrics = this.getRollupMetrics(metrics);
        if (!maybeRollupMetrics.isPresent()) {
            return Optional.empty();
        }
        TupleStream parallelStream = this.getSortedRollupStream(new ParallelListStream(this.parallelize(partitions)), maybeRollupMetrics.get());
        parallelStream.setStreamContext(context);
        parallelStream.open();
        return Optional.of(parallelStream);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Optional<Metric[]> getRollupMetrics(Metric[] metrics) {
        Metric[] rollup = new Metric[metrics.length];
        CountMetric count = null;
        for (int m = 0; m < rollup.length; ++m) {
            void var5_5;
            Metric next = metrics[m];
            if (next instanceof SumMetric) {
                SumMetric sumMetric = new SumMetric(next.getIdentifier());
            } else if (next instanceof MinMetric) {
                MinMetric minMetric = new MinMetric(next.getIdentifier());
            } else if (next instanceof MaxMetric) {
                MaxMetric maxMetric = new MaxMetric(next.getIdentifier());
            } else if (next instanceof CountMetric) {
                SumMetric sumMetric = new SumMetric(next.getIdentifier());
                count = (CountMetric)next;
            } else {
                if (!(next instanceof MeanMetric)) return Optional.empty();
                if (count == null) {
                    for (int n = m + 1; n < metrics.length; ++n) {
                        if (!(metrics[n] instanceof CountMetric)) continue;
                        count = (CountMetric)metrics[n];
                        break;
                    }
                }
                if (count == null) return Optional.empty();
                WeightedSumMetric weightedSumMetric = new WeightedSumMetric(next.getIdentifier(), count.getIdentifier());
            }
            rollup[m] = var5_5;
        }
        return Optional.of(rollup);
    }
}

