/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CONTENTS;

    public VkSubpassBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassBeginInfo.npNext(this.address());
    }

    @NativeType(value="VkSubpassContents")
    public int contents() {
        return VkSubpassBeginInfo.ncontents(this.address());
    }

    public VkSubpassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkSubpassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfo contents(@NativeType(value="VkSubpassContents") int value) {
        VkSubpassBeginInfo.ncontents(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfo set(int sType, long pNext, int contents) {
        this.sType(sType);
        this.pNext(pNext);
        this.contents(contents);
        return this;
    }

    public VkSubpassBeginInfo set(VkSubpassBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassBeginInfo malloc() {
        return (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassBeginInfo calloc() {
        return (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassBeginInfo create(long address) {
        return (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)address);
    }

    @Nullable
    public static VkSubpassBeginInfo createSafe(long address) {
        return address == 0L ? null : (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassBeginInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubpassBeginInfo mallocStack() {
        return VkSubpassBeginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfo callocStack() {
        return VkSubpassBeginInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfo mallocStack(MemoryStack stack) {
        return (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassBeginInfo callocStack(MemoryStack stack) {
        return (VkSubpassBeginInfo)VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassBeginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassBeginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassBeginInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ncontents(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONTENTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ncontents(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONTENTS, value);
    }

    static {
        Struct.Layout layout = VkSubpassBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkSubpassBeginInfo.__member((int)4), VkSubpassBeginInfo.__member((int)POINTER_SIZE), VkSubpassBeginInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CONTENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassBeginInfo, Buffer>
    implements NativeResource {
        private static final VkSubpassBeginInfo ELEMENT_FACTORY = VkSubpassBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassBeginInfo.npNext(this.address());
        }

        @NativeType(value="VkSubpassContents")
        public int contents() {
            return VkSubpassBeginInfo.ncontents(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer contents(@NativeType(value="VkSubpassContents") int value) {
            VkSubpassBeginInfo.ncontents(this.address(), value);
            return this;
        }
    }
}

