/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bullet.B3VisualShapeData;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3VisualShapeInformation")
public class B3VisualShapeInformation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NUMVISUALSHAPES;
    public static final int M_VISUALSHAPEDATA;

    public B3VisualShapeInformation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3VisualShapeInformation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_numVisualShapes() {
        return B3VisualShapeInformation.nm_numVisualShapes(this.address());
    }

    @NativeType(value="struct b3VisualShapeData *")
    public B3VisualShapeData.Buffer m_visualShapeData() {
        return B3VisualShapeInformation.nm_visualShapeData(this.address());
    }

    public B3VisualShapeInformation m_visualShapeData(@NativeType(value="struct b3VisualShapeData *") B3VisualShapeData.Buffer value) {
        B3VisualShapeInformation.nm_visualShapeData(this.address(), value);
        return this;
    }

    public B3VisualShapeInformation set(B3VisualShapeInformation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3VisualShapeInformation malloc() {
        return (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3VisualShapeInformation calloc() {
        return (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3VisualShapeInformation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3VisualShapeInformation create(long address) {
        return (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)address);
    }

    @Nullable
    public static B3VisualShapeInformation createSafe(long address) {
        return address == 0L ? null : (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3VisualShapeInformation.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3VisualShapeInformation.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3VisualShapeInformation mallocStack() {
        return B3VisualShapeInformation.mallocStack(MemoryStack.stackGet());
    }

    public static B3VisualShapeInformation callocStack() {
        return B3VisualShapeInformation.callocStack(MemoryStack.stackGet());
    }

    public static B3VisualShapeInformation mallocStack(MemoryStack stack) {
        return (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3VisualShapeInformation callocStack(MemoryStack stack) {
        return (B3VisualShapeInformation)B3VisualShapeInformation.wrap(B3VisualShapeInformation.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3VisualShapeInformation.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3VisualShapeInformation.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3VisualShapeInformation.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_numVisualShapes(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NUMVISUALSHAPES);
    }

    public static B3VisualShapeData.Buffer nm_visualShapeData(long struct) {
        return B3VisualShapeData.create(MemoryUtil.memGetAddress((long)(struct + (long)M_VISUALSHAPEDATA)), B3VisualShapeInformation.nm_numVisualShapes(struct));
    }

    public static void nm_numVisualShapes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NUMVISUALSHAPES, value);
    }

    public static void nm_visualShapeData(long struct, B3VisualShapeData.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_VISUALSHAPEDATA), (long)value.address());
        B3VisualShapeInformation.nm_numVisualShapes(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_VISUALSHAPEDATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            B3VisualShapeInformation.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = B3VisualShapeInformation.__struct((Struct.Member[])new Struct.Member[]{B3VisualShapeInformation.__member((int)4), B3VisualShapeInformation.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NUMVISUALSHAPES = layout.offsetof(0);
        M_VISUALSHAPEDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<B3VisualShapeInformation, Buffer>
    implements NativeResource {
        private static final B3VisualShapeInformation ELEMENT_FACTORY = B3VisualShapeInformation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3VisualShapeInformation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_numVisualShapes() {
            return B3VisualShapeInformation.nm_numVisualShapes(this.address());
        }

        @NativeType(value="struct b3VisualShapeData *")
        public B3VisualShapeData.Buffer m_visualShapeData() {
            return B3VisualShapeInformation.nm_visualShapeData(this.address());
        }

        public Buffer m_visualShapeData(@NativeType(value="struct b3VisualShapeData *") B3VisualShapeData.Buffer value) {
            B3VisualShapeInformation.nm_visualShapeData(this.address(), value);
            return this;
        }
    }
}

