/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.reseed.Reseeder;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class ReseedChecker {
    private final RouterContext _context;
    private final Log _log;
    private final AtomicBoolean _inProgress = new AtomicBoolean();
    private volatile String _lastStatus = "";
    private volatile String _lastError = "";
    private volatile boolean _networkLogged;
    private volatile boolean _alreadyRun;
    public static final int MINIMUM = 50;
    private static final long STATUS_CLEAN_TIME = 1200000L;
    private static final long RESEED_MIN_DOWNTIME = 5184000000L;

    public ReseedChecker(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ReseedChecker.class);
    }

    public boolean checkReseed(int count) {
        if (this._alreadyRun) {
            if (count >= 50) {
                return false;
            }
        } else {
            this._alreadyRun = true;
            if (count >= 50 && this._context.getEstimatedDowntime() < 5184000000L) {
                return false;
            }
        }
        if (this._context.getBooleanProperty("router.reseedDisable") || this._context.getBooleanProperty("i2p.vmCommSystem")) {
            int x = count - 1;
            String s = x > 0 ? "Only " + x + " peers remaining but reseed disabled by configuration" : "No peers remaining but reseed disabled by configuration";
            if (!s.equals(this._lastError)) {
                this._lastError = s;
                this._log.logAlways(30, s);
            }
            return false;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            int x = count - 1;
            String s = x > 0 ? "Only " + x + " peers remaining but reseed disabled by shutdown in progress" : "No peers remaining but reseed disabled by shutdown in progress";
            if (!s.equals(this._lastError)) {
                this._lastError = s;
                this._log.logAlways(30, s);
            }
            return false;
        }
        File noReseedFile = new File(new File(System.getProperty("user.home")), ".i2pnoreseed");
        File noReseedFileAlt1 = new File(new File(System.getProperty("user.home")), "noreseed.i2p");
        File noReseedFileAlt2 = new File(this._context.getConfigDir(), ".i2pnoreseed");
        File noReseedFileAlt3 = new File(this._context.getConfigDir(), "noreseed.i2p");
        if (!(noReseedFile.exists() || noReseedFileAlt1.exists() || noReseedFileAlt2.exists() || noReseedFileAlt3.exists())) {
            if (!Addresses.isConnected()) {
                if (!this._networkLogged) {
                    this._log.logAlways(30, "Cannot reseed, no network connection");
                    this._networkLogged = true;
                }
                return false;
            }
            this._networkLogged = false;
            if (count <= 1) {
                this._log.logAlways(20, "Downloading peer router information for a new I2P installation");
            } else {
                this._log.logAlways(30, "Very few known peers remaining - reseeding now");
            }
            return this.requestReseed();
        }
        int x = count - 1;
        String s = x > 0 ? "Only " + x + " peers remaining but reseed disabled by config file" : "No peers remaining but reseed disabled by config file";
        if (!s.equals(this._lastError)) {
            this._lastError = s;
            this._log.logAlways(30, s);
        }
        return false;
    }

    public boolean requestReseed() {
        if (this._inProgress.compareAndSet(false, true)) {
            this._alreadyRun = true;
            try {
                Reseeder reseeder = new Reseeder(this._context, this);
                reseeder.requestReseed();
                return true;
            }
            catch (Throwable t) {
                this._log.error("Reseed failed to start", t);
                this.done();
                return false;
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Reseed already in progress");
        }
        return false;
    }

    public boolean requestReseed(URI url) throws IllegalArgumentException {
        if (this._inProgress.compareAndSet(false, true)) {
            Reseeder reseeder = new Reseeder(this._context, this);
            try {
                reseeder.requestReseed(url);
                return true;
            }
            catch (IllegalArgumentException iae) {
                if (iae.getMessage() != null) {
                    this.setError(DataHelper.escapeHTML(iae.getMessage()));
                }
                this.done();
                throw iae;
            }
            catch (Throwable t) {
                this._log.error("Reseed failed to start", t);
                this.done();
                return false;
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Reseed already in progress");
        }
        return false;
    }

    public int requestReseed(InputStream in) throws IOException {
        if (this._inProgress.compareAndSet(false, true)) {
            try {
                Reseeder reseeder = new Reseeder(this._context, this);
                int n = reseeder.requestReseed(in);
                return n;
            }
            catch (IOException ioe) {
                if (ioe.getMessage() != null) {
                    this.setError(DataHelper.escapeHTML(ioe.getMessage()));
                }
                throw ioe;
            }
            finally {
                this.done();
            }
        }
        throw new IOException("Reseed already in progress");
    }

    public boolean inProgress() {
        return this._inProgress.get();
    }

    void done() {
        this._inProgress.set(false);
        this._context.simpleTimer2().addEvent(new StatusCleaner(this._lastStatus, this._lastError), 1200000L);
    }

    public String getStatus() {
        return this._lastStatus;
    }

    void setStatus(String s) {
        this._lastStatus = s;
    }

    public String getError() {
        return this._lastError;
    }

    void setError(String s) {
        this._lastError = s;
    }

    private class StatusCleaner
    implements SimpleTimer.TimedEvent {
        private final String _status;
        private final String _error;

        public StatusCleaner(String status, String error) {
            this._status = status;
            this._error = error;
        }

        @Override
        public void timeReached() {
            if (this._status.equals(ReseedChecker.this.getStatus())) {
                ReseedChecker.this.setStatus("");
            }
            if (this._error.equals(ReseedChecker.this.getError())) {
                ReseedChecker.this.setError("");
            }
        }
    }
}

