/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomUtils;

public class IndianSettlement
extends Settlement
implements TradeLocation {
    private static final Logger logger = Logger.getLogger(IndianSettlement.class.getName());
    private final Comparator<Goods> exportGoodsComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods goods1, Goods goods2) {
            GoodsType t1 = goods1.getType();
            GoodsType t2 = goods2.getType();
            int cmp = (t2.isNewWorldGoodsType() ? 1 : 0) - (t1.isNewWorldGoodsType() ? 1 : 0);
            if (cmp == 0) {
                int a1 = Math.min(goods2.getAmount(), 100);
                int a2 = Math.min(goods1.getAmount(), 100);
                cmp = IndianSettlement.this.getPriceToSell(t2, a2) - IndianSettlement.this.getPriceToSell(t1, a1);
                if (cmp == 0) {
                    cmp = a2 - a1;
                }
            }
            return cmp;
        }
    };
    public static final double NATIVE_PRODUCTION_EFFICIENCY = 0.67;
    public static final int WANTED_GOODS_COUNT = 3;
    public static final int TALES_RADIUS = 6;
    public static final int TRADE_MINIMUM_SIZE = 20;
    public static final int TRADE_MINIMUM_PRICE = 3;
    public static final int GOODS_BASE_PRICE = 12;
    public static final int KEEP_RAW_MATERIAL = 50;
    public static final int GIFT_THRESHOLD = 25;
    public static final int GIFT_MINIMUM = 10;
    public static final int GIFT_MAXIMUM = 80;
    protected UnitType learnableSkill = null;
    protected GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
    protected final Map<Player, ContactLevel> contactLevels = new HashMap<Player, ContactLevel>();
    protected final List<Unit> ownedUnits = new ArrayList<Unit>();
    protected Unit missionary = null;
    protected int convertProgress = 0;
    protected int lastTribute = 0;
    protected Player mostHated = null;
    protected final Map<Player, Tension> alarm = new HashMap<Player, Tension>();
    private static final String ALARM_TAG = "alarm";
    private static final String CONTACT_LEVEL_TAG = "contactLevel";
    private static final String CONVERT_PROGRESS_TAG = "convertProgress";
    private static final String IS_VISITED_TAG = "isVisited";
    private static final String LAST_TRIBUTE_TAG = "lastTribute";
    private static final String LEVEL_TAG = "level";
    private static final String MISSIONARY_TAG = "missionary";
    private static final String MOST_HATED_TAG = "mostHated";
    private static final String NAME_TAG = "name";
    private static final String OWNED_UNITS_TAG = "ownedUnits";
    private static final String PLAYER_TAG = "player";
    public static final String LEARNABLE_SKILL_TAG = "learnableSkill";
    public static final String WANTED_GOODS_TAG = "wantedGoods";
    public static final String OLD_UNITS_TAG = "units";

    protected IndianSettlement(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public IndianSettlement(Game game, String id) {
        super(game, id);
    }

    public void addOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        if (!this.ownedUnits.contains(unit)) {
            this.ownedUnits.add(unit);
        }
    }

    public List<Unit> getOwnedUnits() {
        return new ArrayList<Unit>(this.ownedUnits);
    }

    public Iterator<Unit> getOwnedUnitsIterator() {
        return this.ownedUnits.iterator();
    }

    public boolean removeOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        return this.ownedUnits.remove(unit);
    }

    public int getLastTribute() {
        return this.lastTribute;
    }

    public void setLastTribute(int lastTribute) {
        this.lastTribute = lastTribute;
    }

    public UnitType getLearnableSkill() {
        return this.learnableSkill;
    }

    public void setLearnableSkill(UnitType skill) {
        this.learnableSkill = skill;
    }

    public StringTemplate getLearnableSkillLabel(boolean visited) {
        return StringTemplate.key(visited ? (this.learnableSkill == null ? "model.indianSettlement.skillNone" : this.learnableSkill.getNameKey()) : "model.indianSettlement.skillUnknown");
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public boolean hasMissionary() {
        return this.missionary != null;
    }

    public boolean hasMissionary(Player player) {
        return this.missionary != null && player != null && player.owns(this.missionary);
    }

    public void setMissionary(Unit missionary) {
        this.missionary = missionary;
    }

    public int getMissionaryLineOfSight() {
        boolean enhanced = this.getSpecification().getBoolean("model.option.enhancedMissionaries");
        return enhanced ? this.getLineOfSight() : 1;
    }

    public int getConvertProgress() {
        return this.convertProgress;
    }

    public void setConvertProgress(int progress) {
        this.convertProgress = progress;
    }

    public GoodsType[] getWantedGoods() {
        return this.wantedGoods;
    }

    public void setWantedGoods(GoodsType[] wantedGoods) {
        this.wantedGoods = wantedGoods;
    }

    public void setWantedGoods(int index, GoodsType type) {
        if (0 <= index && index < this.wantedGoods.length) {
            this.wantedGoods[index] = type;
        }
    }

    public int getWantedGoodsAmount() {
        int n = 0;
        for (GoodsType gt : this.wantedGoods) {
            if (gt == null) continue;
            ++n;
        }
        return n;
    }

    public StringTemplate getWantedGoodsLabel(int index, Player player) {
        StringTemplate ret;
        if (this.hasVisited(player) && 0 <= index && index < this.wantedGoods.length) {
            if (this.wantedGoods[index] == null) {
                ret = StringTemplate.key("model.indianSettlement.wantedGoodsNone");
            } else {
                ret = StringTemplate.label("").add(Messages.nameKey(this.wantedGoods[index]));
                String sale = player.getLastSaleString(this, this.wantedGoods[index]);
                if (sale != null) {
                    ret.addName(" " + sale);
                }
            }
        } else {
            ret = StringTemplate.key("model.indianSettlement.wantedGoodsUnknown");
        }
        return ret;
    }

    public Player getMostHated() {
        return this.mostHated;
    }

    public void setMostHated(Player mostHated) {
        this.mostHated = mostHated;
    }

    public StringTemplate getMostHatedLabel(boolean contacted) {
        return contacted ? (this.mostHated == null ? StringTemplate.key("model.indianSettlement.mostHatedNone") : this.mostHated.getCountryLabel()) : StringTemplate.key("model.indianSettlement.mostHatedUnknown");
    }

    public ContactLevel getContactLevel(Player player) {
        ContactLevel cl = this.contactLevels.get(player);
        return cl == null ? ContactLevel.UNCONTACTED : cl;
    }

    public boolean setContacted(Player player) {
        if (!this.hasContacted(player)) {
            this.contactLevels.put(player, ContactLevel.CONTACTED);
            this.initializeAlarm(player);
            return true;
        }
        return false;
    }

    public boolean hasVisited(Player player) {
        return this.getContactLevel(player).ordinal() >= ContactLevel.VISITED.ordinal();
    }

    public boolean setVisited(Player player) {
        if (!this.hasVisited(player)) {
            if (!this.hasContacted(player)) {
                this.initializeAlarm(player);
            }
            this.contactLevels.put(player, ContactLevel.VISITED);
            return true;
        }
        return false;
    }

    public boolean hasScouted(Player player) {
        return this.getContactLevel(player) == ContactLevel.SCOUTED;
    }

    public boolean setScouted(Player player) {
        if (!this.hasScouted(player)) {
            if (!this.hasContacted(player)) {
                this.initializeAlarm(player);
            }
            this.contactLevels.put(player, ContactLevel.SCOUTED);
            return true;
        }
        return false;
    }

    public boolean hasAnyScouted() {
        return CollectionUtils.any(this.contactLevels.keySet(), p -> this.hasScouted((Player)p));
    }

    public boolean worthScouting(Player player) {
        ContactLevel cl = this.getContactLevel(player);
        switch (cl) {
            case CONTACTED: {
                return true;
            }
            case VISITED: {
                return !this.getSpecification().getBoolean("model.option.settlementActionsContactChief");
            }
        }
        return false;
    }

    public Tension getAlarm(Player player) {
        return this.alarm.get(player);
    }

    public void setAlarm(Player player, Tension newAlarm) {
        this.alarm.put(player, newAlarm);
    }

    protected void initializeAlarm(Player player) {
        Tension tension = this.owner.getTension(player);
        this.setAlarm(player, new Tension(tension.getValue()));
    }

    public String getAlarmLevelKey(Player player) {
        return !player.hasContacted(this.owner) ? "model.indianSettlement.tension.wary" : (!this.hasContacted(player) ? "model.indianSettlement.tension.unknown" : this.getAlarm(player).getNameKey());
    }

    public boolean allowContact(Unit unit) {
        return unit.getOwner().hasContacted(this.owner) || !unit.isNaval() || unit.hasGoodsCargo();
    }

    public int getPriceToBuy(Goods goods) {
        return this.getPriceToBuy(goods.getType(), goods.getAmount());
    }

    public int getPriceToBuy(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int price = 0;
        if (type.isMilitaryGoods()) {
            price = this.getMilitaryGoodsPriceToBuy(type, amount);
        }
        if (price == 0) {
            price = this.getNormalGoodsPriceToBuy(type, amount);
        }
        int wantedBase = 100;
        int wantedBonus = type == this.wantedGoods[0] ? 150 : (type == this.wantedGoods[1] ? 125 : (type == this.wantedGoods[2] ? 110 : 100));
        price = wantedBonus * price / 100;
        logger.finest("Full price(" + amount + " " + type + ")" + " -> " + price);
        return price;
    }

    private int getNormalGoodsPriceToBuy(GoodsType type, int amount) {
        int tradeGoodsAdd = 20;
        int capacity = this.getGoodsCapacity();
        int current = this.getGoodsCount(type);
        GoodsType rawType = type.getInputType();
        if (rawType != null) {
            int rawProduction = this.getMaximumProduction(rawType);
            int add = rawProduction < 5 ? 10 * rawProduction : (rawProduction < 10 ? 5 * rawProduction + 25 : (rawProduction < 20 ? 2 * rawProduction + 55 : 100));
            add = add * Math.max(0, capacity - current) / capacity;
            current += add;
        } else if (type.isTradeGoods()) {
            current += 20;
        }
        int retain = Math.min(this.getWantedGoodsAmount(type), capacity);
        int valued = retain <= current ? 0 : Math.min(amount, retain - current);
        int unitPrice = (12 + this.getType().getTradeBonus()) * Math.max(0, capacity - current) / capacity;
        if (type.isFarmed() || type.isRawBuildingMaterial()) {
            unitPrice /= 2;
        }
        return unitPrice < 0 ? 0 : valued * unitPrice;
    }

    protected int getWantedGoodsAmount(GoodsType type) {
        if (this.getUnitCount() <= 0) {
            return 0;
        }
        Specification spec = this.getSpecification();
        UnitType unitType = this.getFirstUnit().getType();
        List<Role> militaryRoles = Role.getAvailableRoles(this.getOwner(), unitType, spec.getMilitaryRoles());
        if (type.isMilitaryGoods()) {
            return this.ownedUnits.stream().filter(u -> !militaryRoles.contains(u.getRole())).mapToInt(u -> AbstractGoods.getCount(type, u.getGoodsDifference((Role)militaryRoles.get(0), 1))).sum();
        }
        int consumption = this.getConsumptionOf(type);
        if (type == spec.getPrimaryFoodType()) {
            return Math.max(40, consumption * 3);
        }
        if (type.isTradeGoods() || type.isNewWorldLuxuryType() || type.isRefined()) {
            return Math.max(80, consumption * 20);
        }
        return 2 * this.getUnitCount();
    }

    private int getMilitaryGoodsPriceToBuy(GoodsType type, int amount) {
        int full = 12 + this.getType().getTradeBonus();
        int required = this.getWantedGoodsAmount(type);
        if (required == 0) {
            return 0;
        }
        int valued = Math.max(0, required - this.getGoodsCount(type));
        int price = valued > amount / 2 ? full * amount : valued * full + this.getNormalGoodsPriceToBuy(type, amount - valued);
        logger.finest("Military price(" + amount + " " + type + ")" + " valued=" + valued + " -> " + price);
        return price;
    }

    public int getPriceToSell(Goods goods) {
        return this.getPriceToSell(goods.getType(), goods.getAmount());
    }

    public int getPriceToSell(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int full = 12 + this.getType().getTradeBonus();
        int price = amount + Math.max(0, 11 * this.getPriceToBuy(type, amount) / 10);
        if (type.isMilitaryGoods()) {
            price = Math.max(price, amount * full * 2);
        } else if (type.isTradeGoods()) {
            price = Math.max(price, 150 * amount * full / 100);
        }
        return price;
    }

    public boolean willSell(GoodsType type) {
        return !type.isTradeGoods();
    }

    public List<Goods> getSellGoods(int limit, Unit unit) {
        ArrayList<Goods> result = new ArrayList<Goods>();
        List<Goods> settlementGoods = this.getCompactGoods();
        Collections.sort(settlementGoods, this.exportGoodsComparator);
        int count = 0;
        for (Goods goods : settlementGoods) {
            if (!this.willSell(goods.getType())) continue;
            int amount = goods.getAmount();
            int retain = this.getWantedGoodsAmount(goods.getType());
            if (retain >= amount) continue;
            if ((amount -= retain) > 100) {
                amount = 100;
            }
            if (unit != null) {
                amount = Math.round(IndianSettlement.applyModifiers(amount, this.getGame().getTurn(), unit.getModifiers("model.modifier.tradeVolumePenalty")));
            }
            if (amount < 20) continue;
            result.add(new Goods(this.getGame(), this, goods.getType(), amount));
            if (++count < limit) continue;
            break;
        }
        return result;
    }

    public void tradeGoodsWithSettlement(IndianSettlement settlement) {
        GoodsType armsType = this.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType horsesType = this.getSpecification().getGoodsType("model.goods.horses");
        ArrayList<GoodsType> goodsToTrade = new ArrayList<GoodsType>();
        goodsToTrade.add(armsType);
        goodsToTrade.add(horsesType);
        for (GoodsType goods : goodsToTrade) {
            int goodsInStock = this.getGoodsCount(goods);
            if (goodsInStock <= 50) continue;
            int goodsTraded = goodsInStock / 2;
            settlement.addGoods(goods, goodsTraded);
            this.removeGoods(goods, goodsTraded);
        }
    }

    public int getMaximumProduction(GoodsType goodsType) {
        return this.getTile().getSurroundingTiles(0, this.getRadius()).stream().filter(t -> t.getOwningSettlement() == null || t.getOwningSettlement() == this).mapToInt(t -> t.getPotentialProduction(goodsType, null)).sum();
    }

    public void updateWantedGoods() {
        Specification spec = this.getSpecification();
        HashMap<GoodsType, Integer> prices = new HashMap<GoodsType, Integer>();
        for (GoodsType gt : spec.getGoodsTypeList()) {
            if (gt.isMilitaryGoods() || !gt.isStorable()) continue;
            prices.put(gt, this.getNormalGoodsPriceToBuy(gt, 100));
        }
        int wantedIndex = 0;
        for (Map.Entry e : CollectionUtils.mapEntriesByValue(prices, CollectionUtils.descendingIntegerComparator)) {
            GoodsType goodsType = (GoodsType)e.getKey();
            if (e.getValue() <= 300 || wantedIndex >= this.wantedGoods.length) break;
            this.wantedGoods[wantedIndex] = goodsType;
            ++wantedIndex;
        }
        while (wantedIndex < this.wantedGoods.length) {
            this.wantedGoods[wantedIndex] = null;
            ++wantedIndex;
        }
    }

    private GoodsType goodsToMake() {
        GoodsType wantGoods = null;
        int wantAmount = -1;
        for (GoodsType g : this.getSpecification().getGoodsTypeList()) {
            int diff;
            GoodsType produced;
            if (!g.isRawMaterial() || (produced = g.getOutputType()) == null || produced.isBreedable() || !produced.isStorable() || this.getGoodsCount(g) <= this.getWantedGoodsAmount(g) || (diff = this.getWantedGoodsAmount(produced) - this.getGoodsCount(produced)) <= wantAmount) continue;
            wantGoods = produced;
            wantAmount = diff;
        }
        return wantGoods;
    }

    public Goods getRandomGift(Random random) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsType type : this.getSpecification().getNewWorldGoodsTypeList()) {
            int n = this.getGoodsCount(type) - 50;
            if (n < 25) continue;
            Goods goods = new Goods(this.getGame(), this, type, Math.min(RandomUtils.randomInt(logger, "Gift amount", random, n -= 10) + 10, 80));
            goodsList.add(goods);
        }
        return goodsList.isEmpty() ? null : (Goods)RandomUtils.getRandomMember(logger, "Gift type", goodsList, random);
    }

    public void addRandomGoods(Random random) {
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>();
        for (Tile t : this.getOwnedTiles()) {
            for (AbstractGoods abstractGoods : t.getSortedPotential()) {
                GoodsType type = abstractGoods.getType().getStoredAs();
                Integer i = (Integer)goodsMap.get(type);
                int value = i == null ? 0 : i;
                goodsMap.put(type, value + abstractGoods.getAmount());
            }
        }
        double d = (double)RandomUtils.randomInt(logger, "Goods at " + this.getName(), random, 10) * 0.1 + 1.0;
        for (Map.Entry entry : goodsMap.entrySet()) {
            int i = (Integer)entry.getValue();
            if (!((GoodsType)entry.getKey()).isFoodType()) {
                i = (int)Math.round(d * (double)((Integer)entry.getValue()).intValue());
            }
            if ((i = Math.min(i, 100)) <= 0) continue;
            this.addGoods((GoodsType)entry.getKey(), i);
        }
    }

    public int getRequiredDefenders() {
        return this.getType().getMinimumSize() - 1;
    }

    @Override
    public void disposeResources() {
        while (!this.ownedUnits.isEmpty()) {
            this.ownedUnits.remove(0).setHomeIndianSettlement(null);
        }
        super.disposeResources();
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.hasContacted(player) ? StringTemplate.name(this.getName()) : StringTemplate.key("model.indianSettlement.nameUnknown");
    }

    @Override
    public boolean add(Locatable locatable) {
        Unit indian;
        boolean result = super.add(locatable);
        if (result && locatable instanceof Unit && (indian = (Unit)locatable).getHomeIndianSettlement() == null) {
            indian.setHomeIndianSettlement(this);
        }
        return result;
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public String toShortString() {
        return this.getName();
    }

    @Override
    public int getGoodsCapacity() {
        return this.getType().getWarehouseCapacity();
    }

    @Override
    public String getImageKey() {
        String key = this.getType().getId();
        if (this.hasMissionary()) {
            key = key + ".mission";
        }
        return "image.tileitem." + key;
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        Unit defender = null;
        double defencePower = -1.0;
        for (Unit nextUnit : this.getUnitList()) {
            double unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = attacker.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        return defender;
    }

    @Override
    public double getDefenceRatio() {
        return (double)this.getUnitCount() * 2.0 / (double)(this.getType().getMinimumSize() + this.getType().getMaximumSize());
    }

    @Override
    public boolean isBadlyDefended() {
        return this.getUnitCount() < this.getRequiredDefenders();
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        return this.getType().getPlunderRange(attacker);
    }

    @Override
    public int getSoL() {
        return 0;
    }

    @Override
    public int getUpkeep() {
        return 0;
    }

    @Override
    public int getTotalProductionOf(GoodsType type) {
        if (type.isRefined()) {
            if (type != this.goodsToMake()) {
                return 0;
            }
            return this.getUnitCount();
        }
        int tiles = 0;
        int potential = 0;
        for (Tile workTile : this.getOwnedTiles()) {
            if (workTile == this.getTile() || workTile.isOccupied()) continue;
            potential += workTile.getPotentialProduction(type, null);
            ++tiles;
        }
        if (tiles > this.getUnitCount()) {
            potential = (int)((float)potential * ((float)this.getUnitCount() / (float)tiles));
        }
        if (!type.isFoodType()) {
            potential = (int)Math.round((double)potential * 0.67);
        }
        return potential += this.getTile().getPotentialProduction(type, null);
    }

    @Override
    public boolean hasContacted(Player player) {
        return player != null && (player.isIndian() || this.getContactLevel(player) != ContactLevel.UNCONTACTED);
    }

    @Override
    public StringTemplate getAlarmLevelLabel(Player player) {
        String key = !player.hasContacted(this.owner) ? "model.indianSettlement.tension.wary" : (!this.hasContacted(player) ? "model.indianSettlement.tension.unknown" : "model.indianSettlement." + this.getAlarm(player).getKey());
        return StringTemplate.template(key).addStringTemplate("%nation%", this.getOwner().getNationLabel());
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        int present = Math.max(0, this.getGoodsCount(goodsType) + turns * this.getTotalProductionOf(goodsType));
        int wanted = this.getWantedGoodsAmount(goodsType);
        return present - wanted;
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        if (goodsType.limitIgnored()) {
            return Integer.MAX_VALUE;
        }
        int present = Math.max(0, this.getGoodsCount(goodsType) - turns * this.getTotalProductionOf(goodsType));
        int capacity = this.getWarehouseCapacity();
        return capacity - present;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        return super.checkIntegrity(fix);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        Player hated = this.getMostHated();
        if (this.getName() != null) {
            xw.writeAttribute(NAME_TAG, this.getName());
        }
        if (xw.validFor(this.getOwner())) {
            xw.writeAttribute(LAST_TRIBUTE_TAG, this.lastTribute);
            xw.writeAttribute(CONVERT_PROGRESS_TAG, this.convertProgress);
        }
        if (this.learnableSkill != null) {
            xw.writeAttribute(LEARNABLE_SKILL_TAG, this.learnableSkill);
        }
        for (int i = 0; i < this.wantedGoods.length; ++i) {
            if (this.wantedGoods[i] == null) continue;
            xw.writeAttribute(WANTED_GOODS_TAG + i, this.wantedGoods[i]);
        }
        if (hated != null) {
            xw.writeAttribute(MOST_HATED_TAG, hated);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.missionary != null) {
            xw.writeStartElement(MISSIONARY_TAG);
            this.missionary.toXML(xw);
            xw.writeEndElement();
        }
        if (xw.validFor(this.getOwner())) {
            for (Player p : IndianSettlement.getSortedCopy(this.contactLevels.keySet())) {
                xw.writeStartElement(CONTACT_LEVEL_TAG);
                xw.writeAttribute(LEVEL_TAG, this.contactLevels.get(p));
                xw.writeAttribute(PLAYER_TAG, p);
                xw.writeEndElement();
            }
            for (Player p : IndianSettlement.getSortedCopy(this.alarm.keySet())) {
                xw.writeStartElement(ALARM_TAG);
                xw.writeAttribute(PLAYER_TAG, p);
                xw.writeAttribute("value", this.alarm.get(p).getValue());
                xw.writeEndElement();
            }
            for (Unit unit : IndianSettlement.getSortedCopy(this.ownedUnits)) {
                xw.writeStartElement(OWNED_UNITS_TAG);
                xw.writeAttribute("id", unit);
                xw.writeEndElement();
            }
        } else {
            Tension alarm;
            Player client = xw.getClientPlayer();
            ContactLevel cl = this.contactLevels.get(client);
            if (cl != null) {
                xw.writeStartElement(CONTACT_LEVEL_TAG);
                xw.writeAttribute(LEVEL_TAG, cl);
                xw.writeAttribute(PLAYER_TAG, client);
                xw.writeEndElement();
            }
            if ((alarm = this.getAlarm(client)) != null) {
                xw.writeStartElement(ALARM_TAG);
                xw.writeAttribute(PLAYER_TAG, client);
                xw.writeAttribute("value", alarm.getValue());
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.lastTribute = xr.getAttribute(LAST_TRIBUTE_TAG, 0);
        this.convertProgress = xr.getAttribute(CONVERT_PROGRESS_TAG, 0);
        this.learnableSkill = xr.getType(spec, LEARNABLE_SKILL_TAG, UnitType.class, null);
        this.mostHated = xr.findFreeColGameObject(this.getGame(), MOST_HATED_TAG, Player.class, null, false);
        for (int i = 0; i < this.wantedGoods.length; ++i) {
            this.wantedGoods[i] = xr.getType(spec, WANTED_GOODS_TAG + i, GoodsType.class, null);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.contactLevels.clear();
        this.alarm.clear();
        this.missionary = null;
        this.ownedUnits.clear();
        super.readChildren(xr);
        for (Unit u : this.getUnitList()) {
            if (u.getLocation() == this) continue;
            u.setLocationNoUpdate(this);
            logger.warning("Fixing unit location from " + u.getLocation() + " to " + this.getId());
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (ALARM_TAG.equals(tag)) {
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            if (this.getName() != null) {
                this.setContacted(player);
            }
            this.alarm.put(player, new Tension(xr.getAttribute("value", 0)));
            xr.closeTag(ALARM_TAG);
        } else if (CONTACT_LEVEL_TAG.equals(tag)) {
            ContactLevel cl = xr.getAttribute(LEVEL_TAG, ContactLevel.class, ContactLevel.UNCONTACTED);
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            this.contactLevels.put(player, cl);
            xr.closeTag(CONTACT_LEVEL_TAG);
        } else if (IS_VISITED_TAG.equals(tag)) {
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            this.setScouted(player);
            xr.closeTag(IS_VISITED_TAG);
        } else if (MISSIONARY_TAG.equals(tag)) {
            xr.nextTag();
            this.missionary = xr.readFreeColGameObject(game, Unit.class);
            this.missionary.setLocationNoUpdate(this);
            xr.closeTag(MISSIONARY_TAG);
        } else if (OLD_UNITS_TAG.equals(tag)) {
            while (xr.nextTag() != 2) {
                super.readChild(xr);
            }
        } else if (OWNED_UNITS_TAG.equals(tag)) {
            Unit unit = xr.makeFreeColGameObject(game, "id", Unit.class, true);
            this.addOwnedUnit(unit);
            xr.closeTag(OWNED_UNITS_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getName()).append(" at (").append(this.tile.getX()).append(",").append(this.tile.getY()).append(")");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return IndianSettlement.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "indianSettlement";
    }

    public static enum ContactLevel {
        UNCONTACTED,
        CONTACTED,
        VISITED,
        SCOUTED;

    }
}

