/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.ketch.KetchConstants;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchText;
import org.eclipse.jgit.internal.ketch.LogIndex;
import org.eclipse.jgit.internal.ketch.Proposal;
import org.eclipse.jgit.internal.ketch.Round;
import org.eclipse.jgit.internal.ketch.StageBuilder;
import org.eclipse.jgit.internal.ketch.TimeIsUncertainException;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.time.ProposedTimestamp;

class ProposalRound
extends Round {
    private final List<Proposal> todo;
    private RefTree queuedTree;

    ProposalRound(KetchLeader leader, LogIndex head, List<Proposal> todo, @Nullable RefTree tree) {
        super(leader, head);
        this.todo = todo;
        if (tree != null && ProposalRound.canCombine(todo)) {
            this.queuedTree = tree;
        } else {
            leader.roundHoldsReferenceToRefTree = false;
        }
    }

    private static boolean canCombine(List<Proposal> todo) {
        Proposal first = todo.get(0);
        for (int i = 1; i < todo.size(); ++i) {
            if (ProposalRound.canCombine(first, todo.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean canCombine(Proposal a, Proposal b) {
        String bMsg;
        String aMsg = ProposalRound.nullToEmpty(a.getMessage());
        return aMsg.equals(bMsg = ProposalRound.nullToEmpty(b.getMessage())) && ProposalRound.canCombine(a.getAuthor(), b.getAuthor());
    }

    private static String nullToEmpty(@Nullable String str2) {
        return str2 != null ? str2 : "";
    }

    private static boolean canCombine(@Nullable PersonIdent a, @Nullable PersonIdent b) {
        if (a != null && b != null) {
            return a.getName().equals(b.getName()) && a.getEmailAddress().equals(b.getEmailAddress());
        }
        return a == null && b == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void start() throws IOException {
        for (Proposal p : this.todo) {
            p.notifyState(Proposal.State.RUNNING);
        }
        try {
            ObjectId id;
            try (Repository git = this.leader.openRepository();
                 ProposedTimestamp ts = this.getSystem().getClock().propose();){
                id = this.insertProposals(git, ts);
                this.blockUntil(ts);
            }
            this.runAsync(id);
        }
        catch (NoOp e2) {
            for (Proposal p : this.todo) {
                p.success();
            }
            this.leader.lock.lock();
            try {
                this.leader.nextRound();
            }
            finally {
                this.leader.lock.unlock();
            }
        }
        catch (IOException e3) {
            this.abort();
            throw e3;
        }
    }

    private ObjectId insertProposals(Repository git, ProposedTimestamp ts) throws IOException, NoOp {
        ObjectId id;
        try (ObjectInserter inserter = git.newObjectInserter();){
            id = this.queuedTree != null ? this.insertSingleProposal(git, ts, inserter) : this.insertMultiProposal(git, ts, inserter);
            this.stageCommands = this.makeStageList(git, inserter);
            inserter.flush();
        }
        return id;
    }

    private ObjectId insertSingleProposal(Repository git, ProposedTimestamp ts, ObjectInserter inserter) throws IOException, NoOp {
        ObjectId treeId = this.queuedTree.writeTree(inserter);
        this.queuedTree = null;
        this.leader.roundHoldsReferenceToRefTree = false;
        if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
            try (RevWalk rw = new RevWalk(git);){
                RevCommit c = rw.parseCommit(this.acceptedOldIndex);
                if (treeId.equals(c.getTree())) {
                    throw new NoOp();
                }
            }
        }
        Proposal p = this.todo.get(0);
        CommitBuilder b = new CommitBuilder();
        b.setTreeId(treeId);
        if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
            b.setParentId(this.acceptedOldIndex);
        }
        b.setCommitter(this.leader.getSystem().newCommitter(ts));
        b.setAuthor(p.getAuthor() != null ? p.getAuthor() : b.getCommitter());
        b.setMessage(this.message(p));
        return inserter.insert(b);
    }

    private ObjectId insertMultiProposal(Repository git, ProposedTimestamp ts, ObjectInserter inserter) throws IOException, NoOp {
        RefTree tree;
        ObjectId oldTreeId;
        ObjectId lastIndex = this.acceptedOldIndex;
        if (ObjectId.zeroId().equals(lastIndex)) {
            oldTreeId = ObjectId.zeroId();
            tree = RefTree.newEmptyTree();
        } else {
            RevWalk rw = new RevWalk(git);
            Object object = null;
            try {
                RevCommit c = rw.parseCommit(lastIndex);
                oldTreeId = c.getTree();
                tree = RefTree.read(rw.getObjectReader(), c.getTree());
            }
            catch (Throwable c) {
                object = c;
                throw c;
            }
            finally {
                ProposalRound.$closeResource((Throwable)object, rw);
            }
        }
        PersonIdent committer = this.leader.getSystem().newCommitter(ts);
        for (Proposal p : this.todo) {
            if (!tree.apply(p.getCommands())) {
                throw new IOException(KetchText.get().queuedProposalFailedToApply);
            }
            ObjectId treeId = tree.writeTree(inserter);
            if (treeId.equals(oldTreeId)) continue;
            CommitBuilder b = new CommitBuilder();
            b.setTreeId(treeId);
            if (!ObjectId.zeroId().equals(lastIndex)) {
                b.setParentId(lastIndex);
            }
            b.setAuthor(p.getAuthor() != null ? p.getAuthor() : committer);
            b.setCommitter(committer);
            b.setMessage(this.message(p));
            lastIndex = inserter.insert(b);
        }
        if (lastIndex.equals(this.acceptedOldIndex)) {
            throw new NoOp();
        }
        return lastIndex;
    }

    private String message(Proposal p) {
        StringBuilder m = new StringBuilder();
        String msg = p.getMessage();
        if (msg != null && !msg.isEmpty()) {
            m.append(msg);
            while (m.length() < 2 || m.charAt(m.length() - 2) != '\n' || m.charAt(m.length() - 1) != '\n') {
                m.append('\n');
            }
        }
        m.append(KetchConstants.TERM.getName()).append(": ").append(this.leader.getTerm());
        return m.toString();
    }

    void abort() {
        for (Proposal p : this.todo) {
            p.abort();
        }
    }

    @Override
    void success() {
        for (Proposal p : this.todo) {
            p.success();
        }
    }

    private List<ReceiveCommand> makeStageList(Repository git, ObjectInserter inserter) throws IOException {
        HashMap<String, ObjectId> byRef = new HashMap<String, ObjectId>();
        for (Proposal p : this.todo) {
            for (Command c : p.getCommands()) {
                Ref n = c.getNewRef();
                if (n == null || n.isSymbolic()) continue;
                byRef.put(n.getName(), n.getObjectId());
            }
        }
        if (byRef.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ObjectId> newObjs = new HashSet<ObjectId>(byRef.values());
        StageBuilder b = new StageBuilder(this.leader.getSystem().getTxnStage(), this.acceptedNewIndex);
        return b.makeStageList(newObjs, git, inserter);
    }

    private void blockUntil(ProposedTimestamp ts) throws TimeIsUncertainException {
        List times = this.todo.stream().flatMap(p -> p.getProposedTimestamps().stream()).collect(Collectors.toCollection(ArrayList::new));
        times.add(ts);
        try {
            Duration maxWait = this.getSystem().getMaxWaitForMonotonicClock();
            ProposedTimestamp.blockUntil(times, maxWait);
        }
        catch (InterruptedException | TimeoutException e2) {
            throw new TimeIsUncertainException(e2);
        }
    }

    private static class NoOp
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoOp() {
        }
    }
}

