/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.io.Serializable;

@Beta
public final class DataStoreCredentialRefreshListener
implements CredentialRefreshListener {
    private final DataStore<StoredCredential> credentialDataStore;
    private final String userId;

    public DataStoreCredentialRefreshListener(String userId, DataStoreFactory dataStoreFactory) throws IOException {
        this(userId, StoredCredential.getDefaultDataStore(dataStoreFactory));
    }

    public DataStoreCredentialRefreshListener(String userId, DataStore<StoredCredential> credentialDataStore) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId);
        this.credentialDataStore = (DataStore)Preconditions.checkNotNull(credentialDataStore);
    }

    @Override
    public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
        this.makePersistent(credential);
    }

    @Override
    public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
        this.makePersistent(credential);
    }

    public DataStore<StoredCredential> getCredentialDataStore() {
        return this.credentialDataStore;
    }

    public void makePersistent(Credential credential) throws IOException {
        this.credentialDataStore.set(this.userId, (Serializable)new StoredCredential(credential));
    }
}

