/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressForbidden(reason="We need to use log4J2 classes directly to check that the ErrorLogMuter is working")
public final class ErrorLogMuter
implements Closeable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final LoggerContext CTX = LoggerContext.getContext((boolean)false);
    private static final AtomicInteger ID_GEN = new AtomicInteger(0);
    private final String name;
    private final CountingFilter rootFilter;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private static String createName(String type) {
        return MethodHandles.lookup().lookupClass().getSimpleName() + "-" + type + "-" + ID_GEN.incrementAndGet();
    }

    public static ErrorLogMuter substring(String substr) {
        String name = ErrorLogMuter.createName("substring");
        log.info("Creating {} for ERROR logs containing the substring: {}", (Object)name, (Object)substr);
        return new ErrorLogMuter(name, str -> str.contains(substr));
    }

    public static ErrorLogMuter regex(String regex) {
        return ErrorLogMuter.regex(Pattern.compile(regex));
    }

    public static ErrorLogMuter regex(Pattern pat) {
        String name = ErrorLogMuter.createName("regex");
        log.info("Creating {} for ERROR logs matching regex: {}", (Object)name, (Object)pat);
        return new ErrorLogMuter(name, str -> pat.matcher((CharSequence)str).find());
    }

    private ErrorLogMuter(String name, Predicate<String> predicate) {
        assert (null != name);
        assert (null != predicate);
        LoggerConfig rootLoggerConfig = CTX.getConfiguration().getRootLogger();
        this.name = name;
        this.rootFilter = new StringPredicateErrorOrThrowableFilter(predicate);
        rootLoggerConfig.addFilter((Filter)this.rootFilter);
        CTX.updateLoggers();
    }

    public int getCount() {
        return this.rootFilter.getCount();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            CTX.getConfiguration().getRootLogger().removeFilter((Filter)this.rootFilter);
            CTX.updateLoggers();
            if (log.isInfoEnabled()) {
                log.info("Closing {} after mutting {} log messages", (Object)this.name, (Object)this.getCount());
            }
        }
    }

    @SuppressForbidden(reason="We need to use log4J2 classes directly to check that the ErrorLogMuter is working")
    private static final class StringPredicateErrorOrThrowableFilter
    extends AbstractFilter
    implements CountingFilter {
        final Predicate<String> predicate;
        final AtomicInteger count = new AtomicInteger(0);

        public StringPredicateErrorOrThrowableFilter(Predicate<String> predicate) {
            super(Filter.Result.DENY, Filter.Result.NEUTRAL);
            assert (null != predicate);
            this.predicate = predicate;
        }

        @Override
        public int getCount() {
            return this.count.get();
        }

        private Filter.Result doFilter(Level level, String msg, Throwable throwable) {
            if (level.isMoreSpecificThan(Level.ERROR)) {
                if (null != msg && this.predicate.test(msg)) {
                    return this.matchAndCount();
                }
                for (Throwable t = throwable; null != t; t = t.getCause()) {
                    if (!this.predicate.test(t.toString())) continue;
                    return this.matchAndCount();
                }
            }
            return this.getOnMismatch();
        }

        private Filter.Result matchAndCount() {
            this.count.incrementAndGet();
            return this.getOnMatch();
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return this.doFilter(level, msg, null);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.doFilter(level, null == msg ? null : msg.toString(), t);
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.doFilter(level, msg.getFormattedMessage(), t);
        }

        public Filter.Result filter(LogEvent event) {
            return this.doFilter(event.getLevel(), event.getMessage().getFormattedMessage(), event.getThrown());
        }
    }

    @SuppressForbidden(reason="We need to use log4J2 classes directly to check that the ErrorLogMuter is working")
    private static interface CountingFilter
    extends Filter {
        public int getCount();
    }
}

