# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2020 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ApplianceManagement(VapiStruct):
    """
    ``ApplianceManagement`` class This structure contains the Spec required for
    Appliance Management configurations.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 software_update_policy=None,
                 backup_schedules=None,
                 ssh=None,
                 dcui=None,
                 console_cli=None,
                 shell=None,
                 time_zone=None,
                 time_sync=None,
                 ntp=None,
                 syslog=None,
                 local_accounts_policy=None,
                 root_local_account=None,
                 smtp=None,
                 network=None,
                ):
        """
        :type  software_update_policy: :class:`SoftwareUpdatePolicy` or ``None``
        :param software_update_policy: Policy to update vCenter.
            Only :class:`set` if the SoftwareUpdatePolicy is set inside
            vCenter.
        :type  backup_schedules: :class:`list` of :class:`BackupSchedule` or ``None``
        :param backup_schedules: Backup schedule of vCenter.
            Only :class:`set` if the Backup is schedule for vCenter
        :type  ssh: :class:`Ssh`
        :param ssh: Get/Set enabled state of SSH-based controlled CLI. ``Ssh`` class
            provides methods
        :type  dcui: :class:`Dcui`
        :param dcui: Get/Set enabled of Direct Console User Interface (DCUI TTY2).
            ``Dcui`` class provides methods
        :type  console_cli: :class:`Consolecli`
        :param console_cli: Get/Set enabled state of the console-based controlled CLI.
            ``Consolecli`` class provides methods
        :type  shell: :class:`Shell`
        :param shell: Get/Set enabled state of BASH. ``Shell`` class provides methods
        :type  time_zone: :class:`Timezone` or ``None``
        :param time_zone: The ``Timezone`` class provides methods to get and set the
            appliance timezone.
            Only :class:`set` if the Timezone is set in vCenter
        :type  time_sync: :class:`Timesync` or ``None``
        :param time_sync: ``Timesync`` class provides methods Performs time synchronization
            configuration.
            Only :class:`set` if the time sync mode is set in vCenter
        :type  ntp: :class:`Ntp` or ``None``
        :param ntp: ``Ntp`` class provides methods Gets NTP configuration status and
            tests connection to ntp servers.
            Only :class:`set` if the ntp server are set in vCenter.
        :type  syslog: :class:`list` of :class:`LogForwarding` or ``None``
        :param syslog: The ``syslog`` class provides methods to manage forwarding of log
            messages to remote logging servers.
            Only :class:`set` if log forwarding to remote server are set in
            vCenter.
        :type  local_accounts_policy: :class:`LocalAccountsPolicy` or ``None``
        :param local_accounts_policy: The ``localAccountsPolicy`` class provides methods to manage local
            user accounts.
            Only :class:`set` if Password Policy is set to manage local user
            accounts.
        :type  root_local_account: :class:`LocalAccounts` or ``None``
        :param root_local_account: The ``LocalAccounts`` class provides methods to manage local user
            account.
        :type  smtp: :class:`Smtp` or ``None``
        :param smtp: The ``LocalAccounts`` class provides methods to manage local user
            account.
        :type  network: :class:`ApplianceNetwork` or ``None``
        :param network: Network configurations to be applied.
            Only :class:`set` if the network configurations are set in vCenter.
        """
        self.software_update_policy = software_update_policy
        self.backup_schedules = backup_schedules
        self.ssh = ssh
        self.dcui = dcui
        self.console_cli = console_cli
        self.shell = shell
        self.time_zone = time_zone
        self.time_sync = time_sync
        self.ntp = ntp
        self.syslog = syslog
        self.local_accounts_policy = local_accounts_policy
        self.root_local_account = root_local_account
        self.smtp = smtp
        self.network = network
        VapiStruct.__init__(self)


ApplianceManagement._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.appliance_management', {
        'software_update_policy': type.OptionalType(type.ReferenceType(__name__, 'SoftwareUpdatePolicy')),
        'backup_schedules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupSchedule'))),
        'ssh': type.ReferenceType(__name__, 'Ssh'),
        'dcui': type.ReferenceType(__name__, 'Dcui'),
        'console_cli': type.ReferenceType(__name__, 'Consolecli'),
        'shell': type.ReferenceType(__name__, 'Shell'),
        'time_zone': type.OptionalType(type.ReferenceType(__name__, 'Timezone')),
        'time_sync': type.OptionalType(type.ReferenceType(__name__, 'Timesync')),
        'ntp': type.OptionalType(type.ReferenceType(__name__, 'Ntp')),
        'syslog': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LogForwarding'))),
        'local_accounts_policy': type.OptionalType(type.ReferenceType(__name__, 'LocalAccountsPolicy')),
        'root_local_account': type.OptionalType(type.ReferenceType(__name__, 'LocalAccounts')),
        'smtp': type.OptionalType(type.ReferenceType(__name__, 'Smtp')),
        'network': type.OptionalType(type.ReferenceType(__name__, 'ApplianceNetwork')),
    },
    ApplianceManagement,
    False,
    None))



class SoftwareUpdatePolicy(VapiStruct):
    """
    This ``SoftwareUpdatePolicy`` class to set/get background check for the new
    updates.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'custom_URL': 'custom_url',
                            'default_URL': 'default_url',
                            }

    def __init__(self,
                 custom_url=None,
                 default_url=None,
                 auto_stage=None,
                 check_schedule=None,
                 username=None,
                 password=None,
                 certificate_check=None,
                ):
        """
        :type  custom_url: :class:`str` or ``None``
        :param custom_url: Current appliance update repository URL. Enter "default" to reset
            the url to the default url.
            Only :class:`set` if custom URL required
        :type  default_url: :class:`str` or ``None``
        :param default_url: Default appliance update repository URL.
            Only :class:`set` if default URL required
        :type  auto_stage: :class:`SoftwareUpdatePolicy.AutoUpdateNotification`
        :param auto_stage: Check for update at the pre-configured repository URL.
        :type  check_schedule: :class:`Time` or ``None``
        :param check_schedule: The ``Time`` class defines day and time the automatic check for new
            updates will be run.
            Only :class:`set` if Time required.
        :type  username: :class:`str` or ``None``
        :param username: Username for the url update repository
            Only :class:`set` if SoftwareUpdatePolicy requires username.
        :type  password: :class:`str` or ``None``
        :param password: Password for the url update repository
            Only :class:`set` if SoftwareUpdatePolicy requires password.
        :type  certificate_check: :class:`bool`
        :param certificate_check: Indicates whether certificates will be checked during patching. 
            
            Warning: If this attribute is set to false, an insecure connection
            is made to the update repository which can potentially put the
            appliance security at risk.
        """
        self.custom_url = custom_url
        self.default_url = default_url
        self.auto_stage = auto_stage
        self.check_schedule = check_schedule
        self.username = username
        self.password = password
        self.certificate_check = certificate_check
        VapiStruct.__init__(self)


    class AutoUpdateNotification(Enum):
        """
        Defines state for automatic update notification.
        ``SoftwareUpdatePolicy.AutoUpdateNotification`` class

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        DISABLED = None
        """
        Automatic update notification is disabled. Disable periodically query the
        configured url for updates.

        """
        ENABLED = None
        """
        Automatic update notification is enabled. Enable periodically query the
        configured url for updates.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`AutoUpdateNotification` instance.
            """
            Enum.__init__(string)

    AutoUpdateNotification._set_values([
        AutoUpdateNotification('DISABLED'),
        AutoUpdateNotification('ENABLED'),
    ])
    AutoUpdateNotification._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.software_update_policy.auto_update_notification',
        AutoUpdateNotification))

SoftwareUpdatePolicy._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.software_update_policy', {
        'custom_URL': type.OptionalType(type.StringType()),
        'default_URL': type.OptionalType(type.StringType()),
        'auto_stage': type.ReferenceType(__name__, 'SoftwareUpdatePolicy.AutoUpdateNotification'),
        'check_schedule': type.OptionalType(type.ReferenceType(__name__, 'Time')),
        'username': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.SecretType()),
        'certificate_check': type.BooleanType(),
    },
    SoftwareUpdatePolicy,
    False,
    None))



class Time(VapiStruct):
    """
    The ``Time`` class defines weekday and time the automatic check for new
    updates will be run

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 hour=None,
                 minute=None,
                 day=None,
                ):
        """
        :type  hour: :class:`str` or ``None``
        :param hour: Time to query for updates Format: HH:MM:SS Military (24 hour) Time
            Format
            Only :class:`set` if hour is present in SoftwareUpdatePolicy
        :type  minute: :class:`str` or ``None``
        :param minute: Time to query for updates Format: HH:MM:SS Military (24 hour) Time
            Format
            Only :class:`set` if minute is present in SoftwareUpdatePolicy
        :type  day: :class:`Time.UpdateDay` or ``None``
        :param day: Day to query for updates
            Only :class:`set` if minute is present in SoftwareUpdatePolicy
        """
        self.hour = hour
        self.minute = minute
        self.day = day
        VapiStruct.__init__(self)


    class UpdateDay(Enum):
        """
        ``Time.UpdateDay`` class Defines days to query for updates.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        MONDAY = None
        """
        Query for updates on Monday.

        """
        TUESDAY = None
        """
        Query for updates on Tuesday.

        """
        FRIDAY = None
        """
        Query for updates on Friday.

        """
        WEDNESDAY = None
        """
        Query for updates on Wednesday.

        """
        THURSDAY = None
        """
        Query for updates on Thursday.

        """
        SATURDAY = None
        """
        Query for updates on Saturday.

        """
        SUNDAY = None
        """
        Query for updates on Sunday.

        """
        EVERYDAY = None
        """
        Query for updates everyday.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`UpdateDay` instance.
            """
            Enum.__init__(string)

    UpdateDay._set_values([
        UpdateDay('MONDAY'),
        UpdateDay('TUESDAY'),
        UpdateDay('FRIDAY'),
        UpdateDay('WEDNESDAY'),
        UpdateDay('THURSDAY'),
        UpdateDay('SATURDAY'),
        UpdateDay('SUNDAY'),
        UpdateDay('EVERYDAY'),
    ])
    UpdateDay._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.time.update_day',
        UpdateDay))

Time._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.time', {
        'hour': type.OptionalType(type.StringType()),
        'minute': type.OptionalType(type.StringType()),
        'day': type.OptionalType(type.ReferenceType(__name__, 'Time.UpdateDay')),
    },
    Time,
    False,
    None))



class RetentionInfo(VapiStruct):
    """
    The ``RetentionInfo`` class contains retention information associated with
    a schedule.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 max_count=None,
                ):
        """
        :type  max_count: :class:`long`
        :param max_count: Number of backups which should be retained. If retention is not
            set, all the backups will be retained forever.
        """
        self.max_count = max_count
        VapiStruct.__init__(self)


RetentionInfo._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.retention_info', {
        'max_count': type.IntegerType(),
    },
    RetentionInfo,
    False,
    None))



class RecurrenceInfo(VapiStruct):
    """
    The ``RecurrenceInfo`` class contains the recurrence information associated
    with a schedule.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 minute=None,
                 hour=None,
                 days=None,
                ):
        """
        :type  minute: :class:`long`
        :param minute: Minute when backup should run.
        :type  hour: :class:`long`
        :param hour: Hour when backup should run. The hour should be specified in
            24-hour clock format.
        :type  days: :class:`list` of :class:`RecurrenceInfo.DayOfWeek` or ``None``
        :param days: Day of week when the backup should be run. Days can be specified as
            list of days.
            If None the backup will be run everyday.
        """
        self.minute = minute
        self.hour = hour
        self.days = days
        VapiStruct.__init__(self)


    class DayOfWeek(Enum):
        """
        The ``RecurrenceInfo.DayOfWeek`` class defines the set of days when backup
        can be scheduled. The days can be specified as a list of individual days.
        You specify the days when you set the recurrence for a schedule. See
        :attr:`RecurrenceInfo.days`.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        MONDAY = None
        """
        Monday

        """
        TUESDAY = None
        """
        Tuesday

        """
        WEDNESDAY = None
        """
        Wednesday

        """
        THURSDAY = None
        """
        Thursday

        """
        FRIDAY = None
        """
        Friday

        """
        SATURDAY = None
        """
        Saturday

        """
        SUNDAY = None
        """
        Sunday

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`DayOfWeek` instance.
            """
            Enum.__init__(string)

    DayOfWeek._set_values([
        DayOfWeek('MONDAY'),
        DayOfWeek('TUESDAY'),
        DayOfWeek('WEDNESDAY'),
        DayOfWeek('THURSDAY'),
        DayOfWeek('FRIDAY'),
        DayOfWeek('SATURDAY'),
        DayOfWeek('SUNDAY'),
    ])
    DayOfWeek._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.recurrence_info.day_of_week',
        DayOfWeek))

RecurrenceInfo._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.recurrence_info', {
        'minute': type.IntegerType(),
        'hour': type.IntegerType(),
        'days': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RecurrenceInfo.DayOfWeek'))),
    },
    RecurrenceInfo,
    False,
    None))



class BackupSchedule(VapiStruct):
    """
    The ``BackupSchedule`` class contains fields to be specified for creating a
    new schedule. The structure includes parts, location information,
    encryption password and enable flag.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 parts=None,
                 backup_password=None,
                 location=None,
                 location_user=None,
                 location_password=None,
                 enable=None,
                 recurrence_info=None,
                 retention_info=None,
                 schedule_id=None,
                ):
        """
        :type  parts: :class:`list` of :class:`str` or ``None``
        :param parts: List of optional parts to be backed up. Use the
            com.vmware.appliance.recovery.backup.Parts#list method to get
            information about the supported parts.
            If None all the optional parts will not be backed up.
        :type  backup_password: :class:`str` or ``None``
        :param backup_password: Password for a backup piece. The backupPassword must adhere to the
            following password requirements: At least 8 characters, cannot be
            more than 20 characters in length. At least 1 uppercase letter. At
            least 1 lowercase letter. At least 1 numeric digit. At least 1
            special character (i.e. any character not in [0-9,a-z,A-Z]). Only
            visible ASCII characters (for example, no space).
            If None the backup piece will not be encrypted.
        :type  location: :class:`str`
        :param location: URL of the backup location.
        :type  location_user: :class:`str` or ``None``
        :param location_user: Username for the given location.
            If None authentication will not be used for the specified location.
        :type  location_password: :class:`str` or ``None``
        :param location_password: Password for the given location.
            If None authentication will not be used for the specified location.
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable a schedule.
            If None the schedule will be enabled.
        :type  recurrence_info: :class:`RecurrenceInfo` or ``None``
        :param recurrence_info: Recurrence information for the schedule.
            If None backup job will not be scheduled. See
            :class:`RecurrenceInfo`
        :type  retention_info: :class:`RetentionInfo` or ``None``
        :param retention_info: Retention information for the schedule.
            If None all the completed backup jobs will be retained forever. See
            :class:`RetentionInfo`
        :type  schedule_id: :class:`str`
        :param schedule_id: Identifier of the schedule.
        """
        self.parts = parts
        self.backup_password = backup_password
        self.location = location
        self.location_user = location_user
        self.location_password = location_password
        self.enable = enable
        self.recurrence_info = recurrence_info
        self.retention_info = retention_info
        self.schedule_id = schedule_id
        VapiStruct.__init__(self)


BackupSchedule._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.backup_schedule', {
        'parts': type.OptionalType(type.ListType(type.StringType())),
        'backup_password': type.OptionalType(type.SecretType()),
        'location': type.URIType(),
        'location_user': type.OptionalType(type.StringType()),
        'location_password': type.OptionalType(type.SecretType()),
        'enable': type.OptionalType(type.BooleanType()),
        'recurrence_info': type.OptionalType(type.ReferenceType(__name__, 'RecurrenceInfo')),
        'retention_info': type.OptionalType(type.ReferenceType(__name__, 'RetentionInfo')),
        'schedule_id': type.StringType(),
    },
    BackupSchedule,
    False,
    None))



class Ssh(VapiStruct):
    """
    ``Ssh`` class provides methods to Get/Set enabled state of SSH-based
    controlled CLI.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 enabled=None,
                ):
        """
        :type  enabled: :class:`bool`
        :param enabled: Set enabled state of the SSH-based controlled CLI.
        """
        self.enabled = enabled
        VapiStruct.__init__(self)


Ssh._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.ssh', {
        'enabled': type.BooleanType(),
    },
    Ssh,
    False,
    None))



class Consolecli(VapiStruct):
    """
    Get/Set of the console-based controlled CLI. ``Consolecli`` class provides
    methods

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 enabled=None,
                ):
        """
        :type  enabled: :class:`bool`
        :param enabled: Set enabled state of the console-based controlled CLI (TTY1).
        """
        self.enabled = enabled
        VapiStruct.__init__(self)


Consolecli._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.consolecli', {
        'enabled': type.BooleanType(),
    },
    Consolecli,
    False,
    None))



class Dcui(VapiStruct):
    """
    Get/Set enabled state of Direct Console User Interface (DCUI TTY2).
    ``Dcui`` class provides methods

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 enabled=None,
                ):
        """
        :type  enabled: :class:`bool`
        :param enabled: Set enabled state of Direct Console User Interface (DCUI).
        """
        self.enabled = enabled
        VapiStruct.__init__(self)


Dcui._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.dcui', {
        'enabled': type.BooleanType(),
    },
    Dcui,
    False,
    None))



class Shell(VapiStruct):
    """
    Get/Set enabled state of BASH, that is, access to BASH from within the
    controlled CLI. ``Shell`` class provides methods.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 enabled=None,
                 timeout=None,
                ):
        """
        :type  enabled: :class:`bool`
        :param enabled: Enabled can be set to true or false
        :type  timeout: :class:`long`
        :param timeout: The timeout (in seconds) specifies how long you enable the Shell
            access. The maximum timeout is 86400 seconds(1 day).
        """
        self.enabled = enabled
        self.timeout = timeout
        VapiStruct.__init__(self)


Shell._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.shell', {
        'enabled': type.BooleanType(),
        'timeout': type.IntegerType(),
    },
    Shell,
    False,
    None))



class Timezone(VapiStruct):
    """
    The ``Timezone`` class provides methods to get and set the appliance
    timezone.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 name=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Set time zone.
        """
        self.name = name
        VapiStruct.__init__(self)


Timezone._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.timezone', {
        'name': type.OptionalType(type.StringType()),
    },
    Timezone,
    False,
    None))



class Timesync(VapiStruct):
    """
    ``Timesync`` class provides methods Performs time synchronization
    configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 mode=None,
                ):
        """
        :type  mode: :class:`Timesync.TimeSyncMode`
        :param mode: 
        """
        self.mode = mode
        VapiStruct.__init__(self)


    class TimeSyncMode(Enum):
        """
        The ``Timesync.TimeSyncMode`` class defines time synchronization modes

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        DISABLED = None
        """
        Time synchronization is disabled.

        """
        NTP = None
        """
        NTP-based time synchronization.

        """
        HOST = None
        """
        VMware Tool-based time synchronization.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`TimeSyncMode` instance.
            """
            Enum.__init__(string)

    TimeSyncMode._set_values([
        TimeSyncMode('DISABLED'),
        TimeSyncMode('NTP'),
        TimeSyncMode('HOST'),
    ])
    TimeSyncMode._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.timesync.time_sync_mode',
        TimeSyncMode))

Timesync._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.timesync', {
        'mode': type.ReferenceType(__name__, 'Timesync.TimeSyncMode'),
    },
    Timesync,
    False,
    None))



class Ntp(VapiStruct):
    """
    ``Ntp`` class provides methods Get/Set NTP configuration status and tests
    connection to ntp servers.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 servers=None,
                ):
        """
        :type  servers: :class:`list` of :class:`str`
        :param servers: Set NTP servers. This variable updates old NTP servers from
            configuration and sets the input NTP servers in the configuration.
        """
        self.servers = servers
        VapiStruct.__init__(self)


Ntp._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.ntp', {
        'servers': type.ListType(type.StringType()),
    },
    Ntp,
    False,
    None))



class LogForwarding(VapiStruct):
    """
    The ``LogForwarding`` class provides methods to manage forwarding of log
    messages to remote logging servers.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 hostname=None,
                 port=None,
                 protocol=None,
                ):
        """
        :type  hostname: :class:`str`
        :param hostname: FQDN or IP address of the logging server to which messages are
            forwarded.
        :type  port: :class:`long`
        :param port: The port on which the remote logging server is listening for
            forwarded log messages.
        :type  protocol: :class:`LogForwarding.Protocol`
        :param protocol: Transport protocol used to forward log messages.
        """
        self.hostname = hostname
        self.port = port
        self.protocol = protocol
        VapiStruct.__init__(self)


    class Protocol(Enum):
        """
        The ``LogForwarding.Protocol`` class defines transport protocols for
        outbound log messages.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        TLS = None
        """
        Log messages will be forwarded to the remote host by using the TLS
        protocol.

        """
        UDP = None
        """
        Log messages will be forwarded to the remote host using the UDP protocol.

        """
        TCP = None
        """
        Log messages will be forwarded to the remote host using the TCP protocol.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Protocol` instance.
            """
            Enum.__init__(string)

    Protocol._set_values([
        Protocol('TLS'),
        Protocol('UDP'),
        Protocol('TCP'),
    ])
    Protocol._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.log_forwarding.protocol',
        Protocol))

LogForwarding._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.log_forwarding', {
        'hostname': type.StringType(),
        'port': type.IntegerType(),
        'protocol': type.ReferenceType(__name__, 'LogForwarding.Protocol'),
    },
    LogForwarding,
    False,
    None))



class LocalAccountsPolicy(VapiStruct):
    """
    The ``LocalAccountsPolicy`` class provides methods to manage local user
    accounts password lifecycle.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 max_days=None,
                 min_days=None,
                 warn_days=None,
                ):
        """
        :type  max_days: :class:`long` or ``None``
        :param max_days: Maximum number of days a password may be used. If the password is
            older than this, a password change will be forced.
            If None then the restriction will be ignored.
        :type  min_days: :class:`long` or ``None``
        :param min_days: Minimum number of days allowed between password changes. Any
            password changes attempted sooner than this will be rejected.
            If None then the restriction will be ignored.
        :type  warn_days: :class:`long` or ``None``
        :param warn_days: Number of days warning given before a password expires. A zero
            means warning is given only upon the day of expiration.
            If None then no warning will be provided.
        """
        self.max_days = max_days
        self.min_days = min_days
        self.warn_days = warn_days
        VapiStruct.__init__(self)


LocalAccountsPolicy._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.local_accounts_policy', {
        'max_days': type.OptionalType(type.IntegerType()),
        'min_days': type.OptionalType(type.IntegerType()),
        'warn_days': type.OptionalType(type.IntegerType()),
    },
    LocalAccountsPolicy,
    False,
    None))



class LocalAccounts(VapiStruct):
    """
    The ``LocalAccounts`` class provides methods to manage local user account.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 fullname=None,
                 roles=None,
                 enabled=None,
                 has_password=None,
                 last_password_change=None,
                 password_expires_at=None,
                 min_days_between_password_change=None,
                 max_days_between_password_change=None,
                 warn_days_before_password_expiration=None,
                 password=None,
                 email=None,
                ):
        """
        :type  fullname: :class:`str` or ``None``
        :param fullname: Full name of the user
            If None, the value was never set.
        :type  roles: :class:`list` of :class:`str` or ``None``
        :param roles: User roles
        :type  enabled: :class:`bool`
        :param enabled: Flag indicating if the account is enabled
        :type  has_password: :class:`bool`
        :param has_password: Is the user password set.
        :type  last_password_change: :class:`datetime.datetime` or ``None``
        :param last_password_change: Date and time password was changed.
            If None, the password was never set.
        :type  password_expires_at: :class:`datetime.datetime` or ``None``
        :param password_expires_at: Date when the account's password will expire
            If None, the password never expires.
        :type  min_days_between_password_change: :class:`long` or ``None``
        :param min_days_between_password_change: Minimum number of days between password change
            If None, pasword can be changed any time.
        :type  max_days_between_password_change: :class:`long` or ``None``
        :param max_days_between_password_change: Maximum number of days between password change
            If None, password never expires.
        :type  warn_days_before_password_expiration: :class:`long` or ``None``
        :param warn_days_before_password_expiration: Number of days of warning before password expires
            If None, a user is never warned.
        :type  password: :class:`str` or ``None``
        :param password: Password
            If None, value will not be changed
        :type  email: :class:`str` or ``None``
        :param email: Email address of the local account
            If None, value will not be changed
        """
        self.fullname = fullname
        self.roles = roles
        self.enabled = enabled
        self.has_password = has_password
        self.last_password_change = last_password_change
        self.password_expires_at = password_expires_at
        self.min_days_between_password_change = min_days_between_password_change
        self.max_days_between_password_change = max_days_between_password_change
        self.warn_days_before_password_expiration = warn_days_before_password_expiration
        self.password = password
        self.email = email
        VapiStruct.__init__(self)


LocalAccounts._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.local_accounts', {
        'fullname': type.OptionalType(type.StringType()),
        'roles': type.OptionalType(type.ListType(type.StringType())),
        'enabled': type.BooleanType(),
        'has_password': type.BooleanType(),
        'last_password_change': type.OptionalType(type.DateTimeType()),
        'password_expires_at': type.OptionalType(type.DateTimeType()),
        'min_days_between_password_change': type.OptionalType(type.IntegerType()),
        'max_days_between_password_change': type.OptionalType(type.IntegerType()),
        'warn_days_before_password_expiration': type.OptionalType(type.IntegerType()),
        'password': type.OptionalType(type.SecretType()),
        'email': type.OptionalType(type.StringType()),
    },
    LocalAccounts,
    False,
    None))



class Smtp(VapiStruct):
    """
    The ``Smtp`` class provides methods to manage send mail configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 mail_server=None,
                 relay_port=None,
                ):
        """
        :type  mail_server: :class:`str` or ``None``
        :param mail_server: Mail server IP address.
            If None then the value will be ignored.
        :type  relay_port: :class:`str` or ``None``
        :param relay_port: Relay port number.
            If None then the value will be ignored.
        """
        self.mail_server = mail_server
        self.relay_port = relay_port
        VapiStruct.__init__(self)


Smtp._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.smtp', {
        'mail_server': type.OptionalType(type.StringType()),
        'relay_port': type.OptionalType(type.StringType()),
    },
    Smtp,
    False,
    None))



class ApplianceNetwork(VapiStruct):
    """
    ``ApplianceNetwork`` class This structure contains the Spec required for
    Appliance Network configurations.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 firewall_rule_policies=None,
                 dns_server_configuration=None,
                 proxy_configuration=None,
                ):
        """
        :type  firewall_rule_policies: :class:`list` of :class:`FirewallRulePolicy` or ``None``
        :param firewall_rule_policies: List of Firewall Rules to be applied.
            Only :class:`set` if the FirewallRulePolicy is set in vCenter.
        :type  dns_server_configuration: :class:`DnsServerConfiguration` or ``None``
        :param dns_server_configuration: DNS configuration to be applied.
            Only :class:`set` if the DnsServerConfiguration is set in vCenter.
        :type  proxy_configuration: :class:`list` of :class:`ProxyConfiguration` or ``None``
        :param proxy_configuration: Proxy configuration to be applied.
            Only :class:`set` if the Proxy server configuration is set in
            vCenter.
        """
        self.firewall_rule_policies = firewall_rule_policies
        self.dns_server_configuration = dns_server_configuration
        self.proxy_configuration = proxy_configuration
        VapiStruct.__init__(self)


ApplianceNetwork._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.appliance_network', {
        'firewall_rule_policies': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'FirewallRulePolicy'))),
        'dns_server_configuration': type.OptionalType(type.ReferenceType(__name__, 'DnsServerConfiguration')),
        'proxy_configuration': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProxyConfiguration'))),
    },
    ApplianceNetwork,
    False,
    None))



class DnsServerConfiguration(VapiStruct):
    """
    ``DnsServerConfiguration`` class This structure represents the
    configuration state used to determine DNS servers.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 mode=None,
                 servers=None,
                ):
        """
        :type  mode: :class:`DnsServerConfiguration.DNSServerMode`
        :param mode: Define how to determine the DNS servers. Leave the servers argument
            empty if the mode argument is "DHCP". Set the servers argument to a
            comma-separated list of DNS servers if the mode argument is
            "static". The DNS server are assigned from the specified list.
        :type  servers: :class:`list` of :class:`str`
        :param servers: List of the currently used DNS servers. DNS server configuration.
        """
        self.mode = mode
        self.servers = servers
        VapiStruct.__init__(self)


    class DNSServerMode(Enum):
        """
        ``DnsServerConfiguration.DNSServerMode`` class Describes DNS Server source
        (DHCP,static).

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        DHCP = None
        """
        DNS address is automatically assigned by a DHCP server.

        """
        STATIC = None
        """
        DNS address is static.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`DNSServerMode` instance.
            """
            Enum.__init__(string)

    DNSServerMode._set_values([
        DNSServerMode('DHCP'),
        DNSServerMode('STATIC'),
    ])
    DNSServerMode._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.dns_server_configuration.DNS_server_mode',
        DNSServerMode))

DnsServerConfiguration._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.dns_server_configuration', {
        'mode': type.ReferenceType(__name__, 'DnsServerConfiguration.DNSServerMode'),
        'servers': type.ListType(type.StringType()),
    },
    DnsServerConfiguration,
    False,
    None))



class FirewallRulePolicy(VapiStruct):
    """
    ``FirewallRulePolicy`` class Structure that defines a single address-based
    firewall rule.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 address=None,
                 prefix=None,
                 policy=None,
                 interface_name=None,
                ):
        """
        :type  address: :class:`str`
        :param address: IPv4 or IPv6 address.
        :type  prefix: :class:`long`
        :param prefix: CIDR prefix used to mask address. For example, an IPv4 prefix of 24
            ignores the low-order 8 bits of address.
        :type  policy: :class:`FirewallRulePolicy.Policy`
        :param policy: The allow or deny policy of this rule.
        :type  interface_name: :class:`str` or ``None``
        :param interface_name: The interface to which this rule applies. An empty string indicates
            that the rule applies to all interfaces.
            Only :class:`set` if interface name required
        """
        self.address = address
        self.prefix = prefix
        self.policy = policy
        self.interface_name = interface_name
        VapiStruct.__init__(self)


    class Policy(Enum):
        """
        ``FirewallRulePolicy.Policy`` class Defines firewall rule policies.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        IGNORE = None
        """
        Drop packet with correpsonding address.

        """
        ACCEPT = None
        """
        Allow packet with corresponding address.

        """
        REJECT = None
        """
        Drop packet with corresponding address sending destination is not
        reachable.

        """
        RETURN = None
        """
        Apply default or port-specific rules to packet with corresponding address.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Policy` instance.
            """
            Enum.__init__(string)

    Policy._set_values([
        Policy('IGNORE'),
        Policy('ACCEPT'),
        Policy('REJECT'),
        Policy('RETURN'),
    ])
    Policy._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.firewall_rule_policy.policy',
        Policy))

FirewallRulePolicy._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.firewall_rule_policy', {
        'address': type.StringType(),
        'prefix': type.IntegerType(),
        'policy': type.ReferenceType(__name__, 'FirewallRulePolicy.Policy'),
        'interface_name': type.OptionalType(type.StringType()),
    },
    FirewallRulePolicy,
    False,
    None))



class ProxyConfiguration(VapiStruct):
    """
    The ``ProxyConfiguration`` class defines proxy configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 protocol=None,
                 server=None,
                 port=None,
                 username=None,
                 password=None,
                 enabled=None,
                ):
        """
        :type  protocol: :class:`ProxyConfiguration.Protocol`
        :param protocol: The protocol for which proxy should be set.
        :type  server: :class:`str`
        :param server: URL of the proxy server
        :type  port: :class:`long`
        :param port: Port to connect to the proxy server. In a 'get' call, indicates the
            port connected to the proxy server. In a 'set' call, specifies the
            port to connect to the proxy server. A value of -1 indicates the
            default port.
        :type  username: :class:`str` or ``None``
        :param username: Username for proxy server.
            Only :class:`set` if proxy requires username.
        :type  password: :class:`str` or ``None``
        :param password: Password for proxy server.
            Only :class:`set` if proxy requires password.
        :type  enabled: :class:`bool`
        :param enabled: In the result of the ``#get`` and ``#list`` methods this attribute
            indicates whether proxying is enabled for a particular protocol. In
            the input to the ``test`` and ``set`` methods this attribute
            specifies whether proxying should be enabled for a particular
            protocol.
        """
        self.protocol = protocol
        self.server = server
        self.port = port
        self.username = username
        self.password = password
        self.enabled = enabled
        VapiStruct.__init__(self)


    class Protocol(Enum):
        """
        ``ProxyConfiguration.Protocol`` class defines the protocols for which
        proxying is supported.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        HTTP = None
        """
        Proxy configuration for http.

        """
        HTTPS = None
        """
        Proxy configuration for https.

        """
        FTP = None
        """
        Proxy configuration for ftp.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Protocol` instance.
            """
            Enum.__init__(string)

    Protocol._set_values([
        Protocol('HTTP'),
        Protocol('HTTPS'),
        Protocol('FTP'),
    ])
    Protocol._set_binding_type(type.EnumType(
        'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.proxy_configuration.protocol',
        Protocol))

ProxyConfiguration._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.applmgmt.proxy_configuration', {
        'protocol': type.ReferenceType(__name__, 'ProxyConfiguration.Protocol'),
        'server': type.StringType(),
        'port': type.IntegerType(),
        'username': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.SecretType()),
        'enabled': type.BooleanType(),
    },
    ProxyConfiguration,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

