/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  var cache = {};

  var normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    var alias = aliases[name]
    if (alias != null)
      return alias;

    var trailing = name.length > 0 && name[name.lenght-1] === "/";
    var index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  var require = function(name) {
    var mod = cache[name];
    if (!mod) {
      var id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          var err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  var main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (var name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (var name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (var name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    var plugin = require(plugin_entry);

    for (var name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(t,_,n,o,r){o();t(1).__exportStar(t(2),n)},
function _(t,e,n,r,o){r();var a=function(t,e){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)};n.__extends=function(t,e){function n(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{u(r.next(t))}catch(t){a(t)}}function c(t){try{u(r.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,c)}u((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},n.__createBinding=Object.create?function(t,e,n,r){void 0===r&&(r=n),Object.defineProperty(t,r,{enumerable:!0,get:function(){return e[n]}})}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]},n.__exportStar=function(t,e){for(var r in t)"default"===r||Object.prototype.hasOwnProperty.call(e,r)||n.__createBinding(e,t,r)},n.__values=i,n.__read=c,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)r[o]=a[i];return r},n.__await=u,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},i("next"),i("throw"),i("return"),r[Symbol.asyncIterator]=function(){return this},r;function i(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof u?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:u(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=i(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var r in t)"default"!==r&&Object.prototype.hasOwnProperty.call(t,r)&&n.__createBinding(e,t,r);return f(e,t),e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(e,t,o,s,l){s();const n=e(1);l("version",e(3).version),l("index",e(4).index),o.embed=n.__importStar(e(4)),o.protocol=n.__importStar(e(404)),o._testing=n.__importStar(e(405));var r=e(19);l("logger",r.logger),l("set_log_level",r.set_log_level),l("settings",e(28).settings),l("Models",e(7).Models),l("documents",e(5).documents),l("safely",e(406).safely)},
function _(n,i,o,c,e){c(),o.version="2.3.0"},
function _(e,o,t,n,s){n();const d=e(5),r=e(19),_=e(34),c=e(13),i=e(8),a=e(16),u=e(395),l=e(397),m=e(396);var f=e(395);s("add_document_standalone",f.add_document_standalone),s("index",f.index),s("add_document_from_session",e(397).add_document_from_session);var g=e(402);async function w(e,o,t,n){i.isString(e)&&(e=JSON.parse(_.unescape(e)));const s={};for(const[o,t]of c.entries(e))s[o]=d.Document.from_json(t);const a=[];for(const e of o){const o=m._resolve_element(e),d=m._resolve_root_elements(e);if(null!=e.docid)a.push(await u.add_document_standalone(s[e.docid],o,d,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const s=l._get_ws_url(t,n);r.logger.debug(`embed: computed ws url: ${s}`);try{a.push(await l.add_document_from_session(s,e.token,o,d,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){console.log("Error rendering Bokeh items:",e)}}}}return a}s("embed_items_notebook",g.embed_items_notebook),s("kernels",g.kernels),s("BOKEH_ROOT",e(396).BOKEH_ROOT),t.embed_item=async function(e,o){const t={},n=_.uuid4();t[n]=e.doc,null==o&&(o=e.target_id);const s=document.getElementById(o);null!=s&&s.classList.add(m.BOKEH_ROOT);const d={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:n};await a.defer();const[r]=await w(t,[d]);return r},t.embed_items=async function(e,o,t,n){return await a.defer(),w(e,o,t,n)}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(6),o),a.__exportStar(t(35),o)},
function _(e,t,s,o,n){o();const i=e(1),r=e(7),a=e(3),_=e(19),l=e(264),c=e(14),d=e(30),h=e(15),f=e(17),u=e(31),m=e(9),g=e(13),w=i.__importStar(e(132)),p=e(26),v=e(8),b=e(319),y=e(130),k=e(53),j=e(394),M=e(35);class S{constructor(e){this.document=e,this.session=null,this.subscribed_models=new Set}send_event(e){const t=new M.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=S,S.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class E{constructor(){s.documents.push(this),this._init_timestamp=Date.now(),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new S(this),this.idle=new h.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}get layoutables(){return this._roots.filter((e=>e instanceof b.LayoutDOM))}get is_idle(){for(const e of this.layoutables)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.set(e,!0),this.is_idle&&(_.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new l.DocumentReady),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new l.LODStart)),this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&this._interactive_plot.trigger_event(new l.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=m.copy(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error(`Somehow we didn't detach ${e}`);if(0!=this._all_models.size)throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){_.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=w.union(e,t.references());const t=new Set(this._all_models.values()),s=w.difference(t,e),o=w.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this);this._all_models=n}roots(){return this._roots}add_root(e,t){if(_.logger.debug(`Adding root: ${e}`),!m.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new M.RootAddedEvent(this,e,t))}}remove_root(e,t){const s=this._roots.indexOf(e);if(!(s<0)){this._push_all_models_freeze();try{this._roots.splice(s,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new M.RootRemovedEvent(this,e,t))}}title(){return this._title}set_title(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new M.TitleChangedEvent(this,e,t)))}get_model_by_id(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof k.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){var s;null===(s=this._message_callbacks.get(e))||void 0===s||s.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof M.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_notify_change(e,t,s,o,n){this._trigger_on_change(new M.ModelChangedEvent(this,e,t,s,o,null==n?void 0:n.setter_id,null==n?void 0:n.hint))}static _instantiate_object(e,t,s){const o=Object.assign(Object.assign({},s),{id:e,__deferred__:!0});return new(r.Models(t))(o)}static _instantiate_references_json(e,t){var s;const o=new Map;for(const n of e){const e=n.id,i=n.type,r=null!==(s=n.attributes)&&void 0!==s?s:{};let a=t.get(e);null==a&&(a=E._instantiate_object(e,i,r),null!=n.subtype&&a.set_subtype(n.subtype)),o.set(a.id,a)}return o}static _resolve_refs(e,t,s,o){function n(e){if(f.is_ref(e)){if(t.has(e.id))return t.get(e.id);if(s.has(e.id))return s.get(e.id);throw new Error(`reference ${JSON.stringify(e)} isn't known (not in Document?)`)}return u.is_NDArray_ref(e)?u.decode_NDArray(e,o):v.isArray(e)?function(e){const t=[];for(const s of e)t.push(n(s));return t}(e):v.isPlainObject(e)?function(e){const t={};for(const[s,o]of g.entries(e))t[s]=n(o);return t}(e):e}return n(e)}static _initialize_references_json(e,t,s,o){const n=new Map;for(const{id:i,attributes:r}of e){const e=!t.has(i),a=e?s.get(i):t.get(i),_=E._resolve_refs(r,t,s,o);a.setv(_,{silent:!0}),n.set(i,{instance:a,is_new:e})}const i=[],r=new Set;function a(e){if(e instanceof c.HasProps){if(n.has(e.id)&&!r.has(e.id)){r.add(e.id);const{instance:t,is_new:s}=n.get(e.id),{attributes:o}=t;for(const e of g.values(o))a(e);s&&(t.finalize(),i.push(t))}}else if(v.isArray(e))for(const t of e)a(t);else if(v.isPlainObject(e))for(const t of g.values(e))a(t)}for(const e of n.values())a(e.instance);for(const e of i)e.connect_signals()}static _event_for_attribute_change(e,t,s,o,n){if(o.get_model_by_id(e.id).property(t).syncable){const i={kind:"ModelChanged",model:{id:e.id},attr:t,new:s};return c.HasProps._json_record_references(o,s,n,{recursive:!0}),i}return null}static _events_to_sync_objects(e,t,s,o){const n=Object.keys(e.attributes),i=Object.keys(t.attributes),r=m.difference(n,i),a=m.difference(i,n),l=m.intersection(n,i),c=[];for(const e of r)_.logger.warn(`Server sent key ${e} but we don't seem to have it in our JSON`);for(const n of a){const i=t.attributes[n];c.push(E._event_for_attribute_change(e,n,i,s,o))}for(const n of l){const i=e.attributes[n],r=t.attributes[n];null==i&&null==r||(null==i||null==r?c.push(E._event_for_attribute_change(e,n,r,s,o)):p.is_equal(i,r)||c.push(E._event_for_attribute_change(e,n,r,s,o)))}return c.filter((e=>null!=e))}static _compute_patch_since_json(e,t){const s=t.to_json(!1);function o(e){const t=new Map;for(const s of e.roots.references)t.set(s.id,s);return t}const n=o(e),i=new Map,r=[];for(const t of e.roots.root_ids)i.set(t,n.get(t)),r.push(t);const a=o(s),_=new Map,l=[];for(const e of s.roots.root_ids)_.set(e,a.get(e)),l.push(e);if(r.sort(),l.sort(),m.difference(r,l).length>0||m.difference(l,r).length>0)throw new Error("Not implemented: computing add/remove of document roots");const c=new Set;let h=[];for(const e of t._all_models.keys())if(n.has(e)){const s=E._events_to_sync_objects(n.get(e),a.get(e),t,c);h=h.concat(s)}const f=new d.Serializer({include_defaults:!1});return f.to_serializable([...c]),{references:[...f.definitions],events:h}}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=new d.Serializer({include_defaults:e}),s=t.to_serializable(this._roots);return{version:a.version,title:this._title,roots:{root_ids:s.map((e=>e.id)),references:[...t.definitions]}}}static from_json_string(e){const t=JSON.parse(e);return E.from_json(t)}static from_json(e){_.logger.debug("Creating Document from JSON");const t=e.version,s=-1!==t.indexOf("+")||-1!==t.indexOf("-"),o=`Library versions: JS (${a.version}) / Python (${t})`;s||a.version.replace(/-(dev|rc)\./,"$1")==t?_.logger.debug(o):(_.logger.warn("JS/Python version mismatch"),_.logger.warn(o)),null!=e.defs&&j.resolve_defs(e.defs);const n=e.roots,i=n.root_ids,r=n.references,l=E._instantiate_references_json(r,new Map);E._initialize_references_json(r,new Map,l,new Map);const c=new E;for(const e of i){const t=l.get(e);null!=t&&c.add_root(t)}return c.set_title(e.title),c}replace_with_json(e){E.from_json(e).destructively_move(this)}create_json_patch_string(e){return JSON.stringify(this.create_json_patch(e))}create_json_patch(e){for(const t of e)if(t.document!=this)throw new Error("Cannot create a patch using events from a different document");const t=new d.Serializer;return{events:t.to_serializable(e),references:[...t.definitions]}}apply_json_patch(e,t=new Map,s){const o=e.references,n=e.events,i=E._instantiate_references_json(o,this._all_models);t instanceof Map||(t=new Map(t));for(const e of n)switch(e.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":{const t=e.model.id,s=this._all_models.get(t);if(null!=s)i.set(t,s);else if(!i.has(t))throw _.logger.warn(`Got an event for unknown model ${e.model}"`),new Error("event model wasn't known");break}}const r=new Map,a=new Map;for(const[e,t]of i)this._all_models.has(e)?r.set(e,t):a.set(e,t);E._initialize_references_json(o,r,a,t);for(const e of n)switch(e.kind){case"MessageSent":{const{msg_type:s,msg_data:o}=e;let n;if(void 0===o){if(1!=t.size)throw new Error("expected exactly one buffer");{const[[,e]]=t;n=e}}else n=E._resolve_refs(o,r,a,t);this._trigger_on_message(s,n);break}case"ModelChanged":{const o=e.model.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot apply patch to ${o} which is not in the document`);const i=e.attr,_=E._resolve_refs(e.new,r,a,t);n.setv({[i]:_},{setter_id:s});break}case"ColumnDataChanged":{const o=e.column_source.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot stream to ${o} which is not in the document`);const i=E._resolve_refs(e.new,new Map,new Map,t);if(null!=e.cols)for(const e in n.data)e in i||(i[e]=n.data[e]);n.setv({data:i},{setter_id:s,check_eq:!1});break}case"ColumnsStreamed":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot stream to ${t} which is not in the document`);if(!(o instanceof y.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");const n=e.data,i=e.rollover;o.stream(n,i,s);break}case"ColumnsPatched":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot patch ${t} which is not in the document`);if(!(o instanceof y.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");const n=e.patches;o.patch(n,s);break}case"RootAdded":{const t=e.model.id,o=i.get(t);this.add_root(o,s);break}case"RootRemoved":{const t=e.model.id,o=i.get(t);this.remove_root(o,s);break}case"TitleChanged":this.set_title(e.title,s);break;default:throw new Error("Unknown patch event "+JSON.stringify(e))}}}s.Document=E,E.__name__="Document"},
function _(e,s,r,o,t){o();const d=e(1),i=e(8),l=e(13),n=e(14);r.overrides={};const a=new Map;r.Models=e=>{const s=r.Models.get(e);if(null!=s)return s;throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`)},r.Models.get=e=>{var s;return null!==(s=r.overrides[e])&&void 0!==s?s:a.get(e)},r.Models.register=(e,s)=>{r.overrides[e]=s},r.Models.unregister=e=>{delete r.overrides[e]},r.Models.register_models=(e,s=!1,r)=>{var o;if(null!=e)for(const t of i.isArray(e)?e:l.values(e))if(o=t,i.isObject(o)&&o.prototype instanceof n.HasProps){const e=t.__qualified__;s||!a.has(e)?a.set(e,t):null!=r?r(e):console.warn(`Model '${e}' was already registered`)}},r.register_models=r.Models.register_models,r.Models.registered_names=()=>[...a.keys()];const g=d.__importStar(e(38));r.register_models(g)},
function _(n,r,t,e,i){e();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const o=n(9),u=Object.prototype.toString;function c(n){return!0===n||!1===n||"[object Boolean]"===u.call(n)}function f(n){return"[object Number]"===u.call(n)}function a(n){return"[object String]"===u.call(n)}function l(n){const r=typeof n;return"function"===r||"object"===r&&!!n}function s(n){return l(n)&&void 0!==n[Symbol.iterator]}t.isBoolean=c,t.isNumber=f,t.isInteger=function(n){return f(n)&&Number.isInteger(n)},t.isString=a,t.isPrimitive=function(n){return null===n||c(n)||f(n)||a(n)},t.isFunction=function(n){return"[object Function]"===u.call(n)},t.isArray=function(n){return Array.isArray(n)},t.isArrayOf=function(n,r){return o.every(n,r)},t.isArrayableOf=function(n,r){for(let t=0,e=n.length;t<e;t++)if(!r(n[t]))return!1;return!0},t.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},t.isObject=l,t.isPlainObject=function(n){return l(n)&&(null==n.constructor||n.constructor===Object)},t.isIterable=s,t.isArrayable=function(n){return s(n)&&"length"in n}},
function _(n,t,e,r,o){r();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const i=n(10),u=n(11),c=n(12);o("map",c.map),o("reduce",c.reduce),o("min",c.min),o("min_by",c.min_by),o("max",c.max),o("max_by",c.max_by),o("sum",c.sum),o("cumsum",c.cumsum),o("every",c.every),o("some",c.some),o("find",c.find),o("find_last",c.find_last),o("find_index",c.find_index),o("find_last_index",c.find_last_index),o("sorted_index",c.sorted_index),o("is_empty",c.is_empty);const f=Array.prototype.slice;function s(n){return f.call(n)}function a(n){return[].concat(...n)}function l(n,t){return-1!==n.indexOf(t)}function m(n,t,e=1){u.assert(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:o,abs:i}=Math,c=n<=t?e:-e,f=r(o(i(t-n)/e),0),s=new Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=s,e.concat=a,e.includes=l,e.contains=l,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=c.min(n.map((n=>n.length))),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=c.min(n.map((n=>n.length))),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=m,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return c.min_by(m(n.length),(t=>n[t]))},e.argmax=function(n){return c.max_by(m(n.length),(t=>n[t]))},e.sort_by=function(n,t){const e=n.map(((n,e)=>({value:n,index:e,key:t(n)})));return e.sort(((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r||void 0===e)return 1;if(e<r||void 0===r)return-1}return n.index-t.index})),e.map((n=>n.value))},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);l(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return[...t]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!l(e,r)){for(const n of t)if(!l(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=a(t);return n.filter((n=>!l(e,n)))},e.remove_at=function(n,t){const e=s(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++){const t=i.randomIn(0,r);t!==r&&(e[r]=e[t]),e[t]=n[r]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,r,t,e,o){e();const{PI:u}=Math;function a(n){if(0==n)return 0;for(;n<=0;)n+=2*u;for(;n>2*u;)n-=2*u;return n}function c(n,r){return a(n-r)}function f(){return Math.random()}function i(n){switch(n){case"deg":return u/180;case"rad":return 1;case"grad":return u/200;case"turn":return 2*u}}t.angle_norm=a,t.angle_dist=c,t.angle_between=function(n,r,t,e=!1){const o=c(r,t);if(0==o)return!1;if(o==2*u)return!0;const f=a(n),i=c(r,f)<=o&&c(f,t)<=o;return e?!i:i},t.random=f,t.randomIn=function(n,r){return null==r&&(r=n,n=0),n+Math.floor(Math.random()*(r-n+1))},t.atan2=function(n,r){return Math.atan2(r[1]-n[1],r[0]-n[0])},t.radians=function(n){return n*(u/180)},t.degrees=function(n){return n/(u/180)},t.resolve_angle=function(n,r){return-i(r)*n},t.to_radians_coeff=i,t.rnorm=function(n,r){let t,e;for(;t=f(),e=f(),e=(2*e-1)*Math.sqrt(1/Math.E*2),!(-4*t*t*Math.log(t)>=e*e););let o=e/t;return o=n+r*o,o},t.clamp=function(n,r,t){return n<r?r:n>t?t:n},t.log=function(n,r=Math.E){return Math.log(n)/Math.log(r)}},
function _(r,n,e,o,s){o();class t extends Error{}e.AssertionError=t,t.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new t(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(n,t,e,r,o){r();const i=n(10);function l(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,l=new n.constructor(i);let u=0;for(;u<t;u++)l[u]=n[u];for(const n of r)l[u++]=n;for(let r=t+e;r<o;r++)l[u++]=n[r];return l}function u(n,t){return l(n,t,n.length-t)}function c(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function f(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function s(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function h(n,t){let e=0,r=n.length;for(;e<r;){const o=Math.floor((e+r)/2);n[o]<t?e=o+1:r=o}return e}function a(n,t,e,r,o){const i=(o-e)/(r-t);let l=i*(n-t)+e;return isFinite(l)||(l=i*(n-r)+o,isFinite(l)||e!=o||(l=e)),l}function g(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.is_empty=function(n){return 0==n.length},e.copy=function(n){return Array.isArray(n)?n.slice():new n.constructor(n)},e.splice=l,e.head=u,e.insert=function(n,t,e){return l(n,e,0,t)},e.append=function(n,t){return l(n,n.length,0,t)},e.prepend=function(n,t){return l(n,0,0,t)},e.indexOf=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.mul=function(n,t,e){const r=n.length,o=null!=e?e:new n.constructor(r);for(let e=0;e<r;e++)o[e]=n[e]*t;return o},e.map=c,e.inplace_map=function(n,t,e){const r=n.length,o=null!=e?e:n;for(let e=0;e<r;e++)o[e]=t(n[e],e)},e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return u(r,o)},e.reduce=f,e.min=function(n){let t,e=1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t<e&&(e=t);return e},e.max=function(n){let t,e=-1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t>e&&(e=t);return e},e.minmax=function(n){let t,e=1/0,r=-1/0;for(let o=0,i=n.length;o<i;o++)t=n[o],isNaN(t)||(t<e&&(e=t),t>r&&(r=t));return[e,r]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],l=t(i);l<r&&(e=i,r=l)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],l=t(i);l>r&&(e=i,r=l)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return f(n,((n,e,r)=>t[r]=n+e),0),t},e.every=function(n,t){for(let e=0,r=n.length;e<r;e++)if(!t(n[e]))return!1;return!0},e.some=function(n,t){for(let e=0,r=n.length;e<r;e++)if(t(n[e]))return!0;return!1},e.index_of=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.find_index=s(1),e.find_last_index=s(-1),e.find=function(n,t){const r=e.find_index(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=e.find_last_index(n,t);return-1==r?void 0:n[r]},e.sorted_index=h,e.bin_counts=function(n,t){const e=t.length-1,r=Array(e).fill(0);for(let o=0;o<n.length;o++){const l=h(t,n[o]);r[i.clamp(l-1,0,e-1)]+=1}return r},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)){o[i]=r;continue}const l=g(r,t);if(-1==l)o[i]=e[0];else if(l==t.length)o[i]=e[e.length-1];else if(l==t.length-1||t[l]==r)o[i]=e[l];else{const n=t[l],u=e[l],c=t[l+1],f=e[l+1];o[i]=a(r,n,u,c,f)}}return o},e.left_edge_index=g,e.norm=function(n,t,e){const r=e-t;return c(n,(n=>(n-t)/r))}},
function _(t,e,n,c,o){c();const s=t(9),{hasOwnProperty:r}=Object.prototype;function u(t){return Object.keys(t).length}n.keys=Object.keys,n.values=Object.values,n.entries=Object.entries,n.extend=Object.assign,n.clone=function(t){return Object.assign({},t)},n.merge=function(t,e){const n=Object.create(Object.prototype),c=s.concat([Object.keys(t),Object.keys(e)]);for(const o of c){const c=r.call(t,o)?t[o]:[],u=r.call(e,o)?e[o]:[];n[o]=s.union(c,u)}return n},n.size=u,n.isEmpty=function(t){return 0==u(t)},n.to_object=function(t){const e={};for(const[n,c]of t)e[n]=c;return e}},
function _(t,e,s,n,r){n();const i=t(1),o=t(15),c=t(17),a=i.__importStar(t(18)),_=i.__importStar(t(21)),h=t(34),u=t(13),l=t(8),f=t(26),p=t(30),d=t(35),g=t(26),y=t(36),v=t(37),m=i.__importStar(t(21));class b extends(o.Signalable()){constructor(t={}){var e,s;super(),this._subtype=void 0,this.document=null,this.destroyed=new o.Signal0(this,"destroyed"),this.change=new o.Signal0(this,"change"),this.transformchange=new o.Signal0(this,"transformchange"),this.exprchange=new o.Signal0(this,"exprchange"),this.properties={},this._pending=!1,this._changing=!1;const n=t instanceof Map?t.get.bind(t):e=>t[e];this.id=null!==(e=n("id"))&&void 0!==e?e:h.uniqueId();for(const[t,{type:e,default_value:s,options:r}]of u.entries(this._props)){let i;e instanceof a.PropertyAlias?Object.defineProperty(this.properties,t,{get:()=>this.properties[e.attr],configurable:!1,enumerable:!1}):(i=e instanceof _.Kind?new a.PrimitiveProperty(this,t,e,s,n(t),r):new e(this,t,_.Any,s,n(t),r),this.properties[t]=i)}null!==(s=n("__deferred__"))&&void 0!==s&&s||(this.finalize(),this.connect_signals())}get is_syncable(){return!0}set type(t){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=t}get type(){return this.constructor.__qualified__}static get __qualified__(){const{__module__:t,__name__:e}=this;return null!=t?`${t}.${e}`:e}static get[Symbol.toStringTag](){return this.__name__}static init_HasProps(){this.prototype._props={},this.prototype._mixins=[]}static _fix_default(t,e){if(void 0===t||l.isFunction(t))return t;if(l.isPrimitive(t))return()=>t;{const e=new v.Cloner;return()=>e.clone(t)}}static define(t){for(const[e,s]of u.entries(l.isFunction(t)?t(m):t)){if(null!=this.prototype._props[e])throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(null!=this.prototype[e])throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.properties[e].get_value()},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[t,n,r={}]=s,i={type:t,default_value:this._fix_default(n,e),options:r},o=Object.assign({},this.prototype._props);o[e]=i,this.prototype._props=o}}static internal(t){const e={};for(const[s,n]of u.entries(l.isFunction(t)?t(m):t)){const[t,r,i={}]=n;e[s]=[t,r,Object.assign(Object.assign({},i),{internal:!0})]}this.define(e)}static mixins(t){function e(t,e){const s={};for(const[n,r]of u.entries(e))s[t+n]=r;return s}const s={},n=[];for(const r of l.isArray(t)?t:[t])if(l.isArray(r)){const[t,i]=r;u.extend(s,e(t,i)),n.push([t,i])}else{const t=r;u.extend(s,t),n.push(["",t])}this.define(s),this.prototype._mixins=[...this.prototype._mixins,...n]}static override(t){for(const[e,s]of u.entries(t)){const t=this._fix_default(s,e),n=this.prototype._props[e];if(null==n)throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const r=Object.assign({},this.prototype._props);r[e]=Object.assign(Object.assign({},n),{default_value:t}),this.prototype._props=r}}toString(){return`${this.type}(${this.id})`}property(t){const e=this.properties[t];if(null!=e)return e;throw new Error(`unknown property ${this.type}.${t}`)}get attributes(){const t={};for(const e of this)t[e.attr]=e.get_value();return t}[v.clone](t){const e=new Map;for(const s of this)s.dirty&&e.set(s.attr,t.clone(s.get_value()));return new this.constructor(e)}[g.equals](t,e){for(const s of this){const n=t.property(s.attr);if(e.eq(s.get_value(),n.get_value()))return!1}return!0}[y.pretty](t){const e=t.token,s=[];for(const n of this)if(n.dirty){const r=n.get_value();s.push(`${n.attr}${e(":")} ${t.to_string(r)}`)}return`${this.constructor.__qualified__}${e("(")}${e("{")}${s.join(`${e(",")} `)}${e("}")}${e(")")}`}[p.serialize](t){const e=this.ref();t.add_ref(this,e);const s=this.struct();for(const e of this)e.syncable&&(t.include_defaults||e.dirty)&&(s.attributes[e.attr]=t.to_serializable(e.get_value()));return t.add_def(this,s),e}finalize(){for(const t of this){if(!(t instanceof a.VectorSpec||t instanceof a.ScalarSpec))continue;const e=t.get_value();if(null!=e){const{transform:t,expr:s}=e;null!=t&&this.connect(t.change,(()=>this.transformchange.emit())),null!=s&&this.connect(s.change,(()=>this.exprchange.emit()))}}this.initialize()}initialize(){}connect_signals(){}disconnect_signals(){o.Signal.disconnectReceiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return(new v.Cloner).clone(this)}_setv(t,e){const s=e.check_eq,n=[],r=this._changing;this._changing=!0;for(const[e,r]of t)!1!==s&&f.is_equal(e.get_value(),r)||(e.set_value(r),n.push(e));n.length>0&&(this._pending=!0);for(const t of n)t.change.emit();if(!r){if(!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}}setv(t,e={}){const s=u.entries(t);if(0==s.length)return;if(!0===e.silent){for(const[t,e]of s)this.properties[t].set_value(e);return}const n=new Map,r=new Map;for(const[t,e]of s){const s=this.properties[t];n.set(s,e),r.set(s,s.get_value())}this._setv(n,e);const{document:i}=this;if(null!=i){const t=[];for(const[e,s]of r)t.push([e,s,e.get_value()]);for(const[,e,s]of t)if(this._needs_invalidate(e,s)){i._invalidate_all_models();break}this._push_changes(t,e)}}getv(t){return this.property(t).get_value()}ref(){return{id:this.id}}struct(){const t={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(t.subtype=this._subtype),t}set_subtype(t){this._subtype=t}*[Symbol.iterator](){yield*u.values(this.properties)}*syncable_properties(){for(const t of this)t.syncable&&(yield t)}serializable_attributes(){const t={};for(const e of this.syncable_properties())t[e.attr]=e.get_value();return t}static _json_record_references(t,e,s,n){const{recursive:r}=n;if(c.is_ref(e)){const n=t.get_model_by_id(e.id);null==n||s.has(n)||b._value_record_references(n,s,{recursive:r})}else if(l.isArray(e))for(const n of e)b._json_record_references(t,n,s,{recursive:r});else if(l.isPlainObject(e))for(const n of u.values(e))b._json_record_references(t,n,s,{recursive:r})}static _value_record_references(t,e,s){const{recursive:n}=s;if(t instanceof b){if(!e.has(t)&&(e.add(t),n))for(const s of t.syncable_properties()){const t=s.get_value();b._value_record_references(t,e,{recursive:n})}}else if(l.isArray(t))for(const s of t)b._value_record_references(s,e,{recursive:n});else if(l.isPlainObject(t))for(const s of u.values(t))b._value_record_references(s,e,{recursive:n})}references(){const t=new Set;return b._value_record_references(this,t,{recursive:!0}),t}_doc_attached(){}_doc_detached(){}attach_document(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(t,e){const s=new Set;b._value_record_references(e,s,{recursive:!1});const n=new Set;b._value_record_references(t,n,{recursive:!1});for(const t of s)if(!n.has(t))return!0;for(const t of n)if(!s.has(t))return!0;return!1}_push_changes(t,e={}){if(!this.is_syncable)return;const{document:s}=this;if(null==s)return;const{setter_id:n}=e,r=[];for(const[e,i,o]of t)e.syncable&&r.push(new d.ModelChangedEvent(s,this,e.attr,i,o,n));if(0!=r.length){let t;1==r.length?[t]=r:t=new d.DocumentEventBatch(s,r,n),s._trigger_on_change(t)}}on_change(t,e){for(const s of l.isArray(t)?t:[t])this.connect(s.change,e)}}s.HasProps=b,b.init_HasProps()},
function _(n,t,e,l,s){l();const i=n(16),o=n(9);class c{constructor(n,t){this.sender=n,this.name=t}connect(n,t=null){u.has(this.sender)||u.set(this.sender,[]);const e=u.get(this.sender);if(null!=g(e,this,n,t))return!1;const l=null!=t?t:n;a.has(l)||a.set(l,[]);const s=a.get(l),i={signal:this,slot:n,context:t};return e.push(i),s.push(i),!0}disconnect(n,t=null){const e=u.get(this.sender);if(null==e||0===e.length)return!1;const l=g(e,this,n,t);if(null==l)return!1;const s=null!=t?t:n,i=a.get(s);return l.signal=null,d(e),d(i),!0}emit(n){var t;const e=null!==(t=u.get(this.sender))&&void 0!==t?t:[];for(const{signal:t,slot:l,context:s}of e)t===this&&l.call(s,n,this.sender)}}e.Signal=c,c.__name__="Signal";class r extends c{emit(){super.emit(void 0)}}e.Signal0=r,r.__name__="Signal0",function(n){function t(n,t){const e=u.get(n);if(null==e||0===e.length)return;const l=a.get(t);if(null!=l&&0!==l.length){for(const t of l){if(null==t.signal)return;t.signal.sender===n&&(t.signal=null)}d(e),d(l)}}function e(n){var t;const e=u.get(n);if(null!=e&&0!==e.length){for(const n of e){if(null==n.signal)return;const e=null!==(t=n.context)&&void 0!==t?t:n.slot;n.signal=null,d(a.get(e))}d(e)}}function l(n,t,e){const l=a.get(n);if(null!=l&&0!==l.length){for(const n of l){if(null==n.signal)return;if(null!=t&&n.slot!=t)continue;const l=n.signal.sender;null!=e&&e.has(l)||(n.signal=null,d(u.get(l)))}d(l)}}function s(n){const t=u.get(n);if(null!=t&&0!==t.length){for(const n of t)n.signal=null;d(t)}const e=a.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;d(e)}}n.disconnect_between=t,n.disconnect_sender=e,n.disconnect_receiver=l,n.disconnect_all=s,n.disconnectBetween=t,n.disconnectSender=e,n.disconnectReceiver=l,n.disconnectAll=s}(c||(e.Signal=c={})),e.Signalable=function(){return class{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}};const u=new WeakMap,a=new WeakMap;function g(n,t,e,l){return o.find(n,(n=>n.signal===t&&n.slot===e&&n.context===l))}const f=new Set;function d(n){0===f.size&&(async()=>{await i.defer(),function(){for(const n of f)o.remove_by(n,(n=>null==n.signal));f.clear()}()})(),f.add(n)}},
function _(e,n,t,s,o){s();const a=new MessageChannel,l=new Map;a.port1.onmessage=e=>{const n=e.data,t=l.get(n);if(null!=t)try{t()}finally{l.delete(n)}};let r=1;t.defer=function(){return new Promise((e=>{const n=r++;l.set(n,e),a.port2.postMessage(n)}))}},
function _(n,t,i,e,c){e();const r=n(8),s=n(13);i.is_ref=function(n){if(r.isPlainObject(n)){const t=s.keys(n);return 1==t.length&&"id"==t[0]}return!1}},
function _(e,t,n,a,r){a(),n.YCoordinateSeqSeqSeqSpec=n.XCoordinateSeqSeqSeqSpec=n.YCoordinateSeqSpec=n.XCoordinateSeqSpec=n.YCoordinateSpec=n.XCoordinateSpec=n.CoordinateSeqSeqSeqSpec=n.CoordinateSeqSpec=n.CoordinateSpec=n.BaseCoordinateSpec=n.NumberUnitsSpec=n.UnitsSpec=n.DataSpec=n.VectorSpec=n.TextBaselineScalar=n.TextAlignScalar=n.FontStyleScalar=n.FontSizeScalar=n.FontScalar=n.LineDashScalar=n.LineCapScalar=n.LineJoinScalar=n.ArrayScalar=n.NullStringScalar=n.StringScalar=n.NumberScalar=n.ColorScalar=n.AnyScalar=n.ScalarSpec=n.VerticalAlign=n.UpdateMode=n.TooltipAttachment=n.TickLabelOrientation=n.TextureRepetition=n.TextBaseline=n.TextAlign=n.TapBehavior=n.StepMode=n.StartEnd=n.SpatialUnits=n.Sort=n.SizingMode=n.Side=n.RoundingFunction=n.ResetPolicy=n.RenderMode=n.RenderLevel=n.RadiusDimension=n.PointPolicy=n.Place=void 0,n.TextBaselineSpec=n.TextAlignSpec=n.FontStyleSpec=n.FontSizeSpec=n.FontSpec=n.LineDashSpec=n.LineCapSpec=n.LineJoinSpec=n.MarkerSpec=n.ArraySpec=n.NullStringSpec=n.StringSpec=n.AnySpec=n.NDArraySpec=n.ColorSpec=n.NumberSpec=n.BooleanSpec=n.ScreenDistanceSpec=n.NullDistanceSpec=n.DistanceSpec=n.AngleSpec=void 0;const i=e(1),s=e(15),l=e(19),o=i.__importStar(e(20)),c=e(24),_=e(9),u=e(12),d=e(10),S=e(22),p=e(27),m=e(8),h=e(28),v=e(29),y=e(33);function x(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function g(e){return m.isPlainObject(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}r("Uniform",y.Uniform),r("UniformScalar",y.UniformScalar),r("UniformVector",y.UniformVector),n.isSpec=g;class f{constructor(e,t,n,a,r,i={}){var l;let o;if(this.obj=e,this.attr=t,this.kind=n,this.default_value=a,this._dirty=!1,this.change=new s.Signal0(this.obj,"change"),this.internal=null!==(l=i.internal)&&void 0!==l&&l,this.on_update=i.on_update,void 0!==r)o=r,this._dirty=!0;else{const t=this._default_override();if(void 0!==t)o=t;else{if(void 0===a)return void(this.spec={value:null});o=a(e)}}this._update(o)}get is_value(){return void 0!==this.spec.value}get syncable(){return!this.internal}get_value(){return this.spec.value}set_value(e){this._update(e),this._dirty=!0}_default_override(){}get dirty(){return this._dirty}_update(e){var t;this.validate(e),this.spec={value:e},null===(t=this.on_update)||void 0===t||t.call(this,e,this.obj)}toString(){return`Prop(${this.obj}.${this.attr}, spec: ${x(this.spec)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj}.${this.attr} given invalid value: ${x(e)}`)}valid(e){return this.kind.valid(e)}_value(e=!0){if(!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");let t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(t=this.spec.transform.compute(t)),t}}n.Property=f,f.__name__="Property";class A{constructor(e){this.attr=e}}n.PropertyAlias=A,A.__name__="PropertyAlias",n.Alias=function(e){return new A(e)};class C extends f{}n.PrimitiveProperty=C,C.__name__="PrimitiveProperty";class L extends f{}n.Any=L,L.__name__="Any";class T extends f{valid(e){return m.isArray(e)||m.isTypedArray(e)}}n.Array=T,T.__name__="Array";class P extends f{valid(e){return m.isBoolean(e)}}n.Boolean=P,P.__name__="Boolean";class b extends f{valid(e){return S.is_Color(e)}}n.Color=b,b.__name__="Color";class w extends f{}n.Instance=w,w.__name__="Instance";class q extends f{valid(e){return m.isNumber(e)}}n.Number=q,q.__name__="Number";class N extends q{valid(e){return m.isNumber(e)&&(0|e)==e}}n.Int=N,N.__name__="Int";class B extends q{}n.Angle=B,B.__name__="Angle";class D extends q{valid(e){return m.isNumber(e)&&0<=e&&e<=1}}n.Percent=D,D.__name__="Percent";class F extends f{valid(e){return m.isString(e)}}n.String=F,F.__name__="String";class z extends f{valid(e){return null===e||m.isString(e)}}n.NullString=z,z.__name__="NullString";class U extends F{}n.FontSize=U,U.__name__="FontSize";class M extends F{_default_override(){return h.settings.dev?"Bokeh":void 0}}n.Font=M,M.__name__="Font";class R extends f{valid(e){return m.isString(e)&&_.includes(this.enum_values,e)}}function k(e){return class extends R{get enum_values(){return[...e]}}}n.EnumProperty=R,R.__name__="EnumProperty",n.Enum=k;class O extends R{get enum_values(){return[...o.Direction]}normalize(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)switch(e[n]){case"clock":t[n]=0;break;case"anticlock":t[n]=1}return t}}n.Direction=O,O.__name__="Direction",n.Anchor=k(o.Anchor),n.AngleUnits=k(o.AngleUnits),n.BoxOrigin=k(o.BoxOrigin),n.ButtonType=k(o.ButtonType),n.CalendarPosition=k(o.CalendarPosition),n.Dimension=k(o.Dimension),n.Dimensions=k(o.Dimensions),n.Distribution=k(o.Distribution),n.FontStyle=k(o.FontStyle),n.HatchPatternType=k(o.HatchPatternType),n.HTTPMethod=k(o.HTTPMethod),n.HexTileOrientation=k(o.HexTileOrientation),n.HoverMode=k(o.HoverMode),n.LatLon=k(o.LatLon),n.LegendClickPolicy=k(o.LegendClickPolicy),n.LegendLocation=k(o.LegendLocation),n.LineCap=k(o.LineCap),n.LineJoin=k(o.LineJoin),n.LinePolicy=k(o.LinePolicy),n.Location=k(o.Location),n.Logo=k(o.Logo),n.MarkerType=k(o.MarkerType),n.MutedPolicy=k(o.MutedPolicy),n.Orientation=k(o.Orientation),n.OutputBackend=k(o.OutputBackend),n.PaddingUnits=k(o.PaddingUnits),n.Place=k(o.Place),n.PointPolicy=k(o.PointPolicy),n.RadiusDimension=k(o.RadiusDimension),n.RenderLevel=k(o.RenderLevel),n.RenderMode=k(o.RenderMode),n.ResetPolicy=k(o.ResetPolicy),n.RoundingFunction=k(o.RoundingFunction),n.Side=k(o.Side),n.SizingMode=k(o.SizingMode),n.Sort=k(o.Sort),n.SpatialUnits=k(o.SpatialUnits),n.StartEnd=k(o.StartEnd),n.StepMode=k(o.StepMode),n.TapBehavior=k(o.TapBehavior),n.TextAlign=k(o.TextAlign),n.TextBaseline=k(o.TextBaseline),n.TextureRepetition=k(o.TextureRepetition),n.TickLabelOrientation=k(o.TickLabelOrientation),n.TooltipAttachment=k(o.TooltipAttachment),n.UpdateMode=k(o.UpdateMode),n.VerticalAlign=k(o.VerticalAlign);class E extends f{get_value(){const{value:e,expr:t,transform:n}=this.spec;return null!=t||null!=n?this.spec:e}_update(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}materialize(e){return e}scalar(e,t){return new y.UniformScalar(e,t)}uniform(e){var t;const{expr:n,value:a,transform:r}=this.spec,i=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=n){let t=n.compute(e);return null!=r&&(t=r.compute(t)),t=this.materialize(t),this.scalar(t,i)}{let e=a;return null!=r&&(e=r.compute(e)),e=this.materialize(e),this.scalar(e,i)}}}n.ScalarSpec=E,E.__name__="ScalarSpec";class V extends E{}n.AnyScalar=V,V.__name__="AnyScalar";class $ extends E{}n.ColorScalar=$,$.__name__="ColorScalar";class J extends E{}n.NumberScalar=J,J.__name__="NumberScalar";class X extends E{}n.StringScalar=X,X.__name__="StringScalar";class Y extends E{}n.NullStringScalar=Y,Y.__name__="NullStringScalar";class H extends E{}n.ArrayScalar=H,H.__name__="ArrayScalar";class j extends E{}n.LineJoinScalar=j,j.__name__="LineJoinScalar";class G extends E{}n.LineCapScalar=G,G.__name__="LineCapScalar";class I extends E{}n.LineDashScalar=I,I.__name__="LineDashScalar";class K extends E{_default_override(){return h.settings.dev?"Bokeh":void 0}}n.FontScalar=K,K.__name__="FontScalar";class Q extends E{}n.FontSizeScalar=Q,Q.__name__="FontSizeScalar";class W extends E{}n.FontStyleScalar=W,W.__name__="FontStyleScalar";class Z extends E{}n.TextAlignScalar=Z,Z.__name__="TextAlignScalar";class ee extends E{}n.TextBaselineScalar=ee,ee.__name__="TextBaselineScalar";class te extends f{get_value(){return null===this.spec.value?null:this.spec}_update(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}materialize(e){return e}v_materialize(e){return e}scalar(e,t){return new y.UniformScalar(e,t)}vector(e){return new y.UniformVector(e)}uniform(e){var t;const{field:n,expr:a,value:r,transform:i}=this.spec,s=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=n){let t=e.get_column(n);return null!=t?(null!=i&&(t=i.v_compute(t)),t=this.v_materialize(t),this.vector(t)):(l.logger.warn(`attempted to retrieve property array for nonexistent field '${n}'`),this.scalar(null,s))}if(null!=a){let t=a.v_compute(e);return null!=i&&(t=i.v_compute(t)),t=this.v_materialize(t),this.vector(t)}{let e=r;return null!=i&&(e=i.compute(e)),e=this.materialize(e),this.scalar(e,s)}}array(e){var t;let n;const a=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=this.spec.field){const t=e.get_column(this.spec.field);if(null!=t)n=this.normalize(t);else{l.logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);const e=new Float64Array(a);e.fill(NaN),n=e}}else if(null!=this.spec.expr)n=this.normalize(this.spec.expr.v_compute(e));else{const e=this._value(!1);if(m.isNumber(e)){const t=new Float64Array(a);t.fill(e),n=t}else n=_.repeat(e,a)}return null!=this.spec.transform&&(n=this.spec.transform.v_compute(n)),n}}n.VectorSpec=te,te.__name__="VectorSpec";class ne extends te{}n.DataSpec=ne,ne.__name__="DataSpec";class ae extends te{_update(e){super._update(e);const{units:t}=this.spec;if(null!=t&&!_.includes(this.valid_units,t))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${t}`)}get units(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:this.default_units}set units(e){e!=this.default_units?this.spec.units=e:delete this.spec.units}}n.UnitsSpec=ae,ae.__name__="UnitsSpec";class re extends ae{array(e){return new Float64Array(super.array(e))}}n.NumberUnitsSpec=re,re.__name__="NumberUnitsSpec";class ie extends ne{}n.BaseCoordinateSpec=ie,ie.__name__="BaseCoordinateSpec";class se extends ie{}n.CoordinateSpec=se,se.__name__="CoordinateSpec";class le extends ie{}n.CoordinateSeqSpec=le,le.__name__="CoordinateSeqSpec";class oe extends ie{}n.CoordinateSeqSeqSeqSpec=oe,oe.__name__="CoordinateSeqSeqSeqSpec";class ce extends se{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSpec=ce,ce.__name__="XCoordinateSpec";class _e extends se{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSpec=_e,_e.__name__="YCoordinateSpec";class ue extends le{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSpec=ue,ue.__name__="XCoordinateSeqSpec";class de extends le{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSpec=de,de.__name__="YCoordinateSeqSpec";class Se extends oe{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSeqSeqSpec=Se,Se.__name__="XCoordinateSeqSeqSeqSpec";class pe extends oe{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSeqSeqSpec=pe,pe.__name__="YCoordinateSeqSeqSeqSpec";class me extends re{get default_units(){return"rad"}get valid_units(){return[...o.AngleUnits]}materialize(e){return e*-d.to_radians_coeff(this.units)}v_materialize(e){const t=-d.to_radians_coeff(this.units),n=new Float32Array(e.length);return u.mul(e,t,n),n}array(e){throw new Error("not supported")}}n.AngleSpec=me,me.__name__="AngleSpec";class he extends re{get default_units(){return"data"}get valid_units(){return[...o.SpatialUnits]}}n.DistanceSpec=he,he.__name__="DistanceSpec";class ve extends he{materialize(e){return null!=e?e:NaN}}n.NullDistanceSpec=ve,ve.__name__="NullDistanceSpec";class ye extends he{get default_units(){return"screen"}}n.ScreenDistanceSpec=ye,ye.__name__="ScreenDistanceSpec";class xe extends ne{v_materialize(e){return new Uint8Array(e)}array(e){return new Uint8Array(super.array(e))}}n.BooleanSpec=xe,xe.__name__="BooleanSpec";class ge extends ne{v_materialize(e){return m.isTypedArray(e)?e:new Float64Array(e)}array(e){return new Float64Array(super.array(e))}}n.NumberSpec=ge,ge.__name__="NumberSpec";class fe extends ne{materialize(e){return S.encode_rgba(S.color2rgba(e))}v_materialize(e){if(!v.is_NDArray(e)){const t=e.length,n=new c.RGBAArray(4*t);let a=0;for(const t of e){const[e,r,i,s]=S.color2rgba(t);n[a++]=e,n[a++]=r,n[a++]=i,n[a++]=s}return new c.ColorArray(n.buffer)}if("uint32"==e.dtype&&1==e.dimension)return p.to_big_endian(e);if("uint8"==e.dtype&&1==e.dimension){const[t]=e.shape,n=new c.RGBAArray(4*t);let a=0;for(const t of e)n[a++]=t,n[a++]=t,n[a++]=t,n[a++]=255;return new c.ColorArray(n.buffer)}if("uint8"==e.dtype&&2==e.dimension){const[t,n]=e.shape;if(4==n)return new c.ColorArray(e.buffer);if(3==n){const a=new c.RGBAArray(4*t);for(let r=0,i=0;r<n*t;)a[i++]=e[r++],a[i++]=e[r++],a[i++]=e[r++],a[i++]=255;return new c.ColorArray(a.buffer)}}else if(("float32"==e.dtype||"float64"==e.dtype)&&2==e.dimension){const[t,n]=e.shape;if(3==n||4==n){const a=new c.RGBAArray(4*t);for(let r=0,i=0;r<n*t;)a[i++]=255*e[r++],a[i++]=255*e[r++],a[i++]=255*e[r++],a[i++]=255*(3==n?1:e[r++]);return new c.ColorArray(a.buffer)}}throw new Error("invalid color array")}vector(e){return new y.ColorUniformVector(e)}}n.ColorSpec=fe,fe.__name__="ColorSpec";class Ae extends ne{}n.NDArraySpec=Ae,Ae.__name__="NDArraySpec";class Ce extends ne{}n.AnySpec=Ce,Ce.__name__="AnySpec";class Le extends ne{}n.StringSpec=Le,Le.__name__="StringSpec";class Te extends ne{}n.NullStringSpec=Te,Te.__name__="NullStringSpec";class Pe extends ne{}n.ArraySpec=Pe,Pe.__name__="ArraySpec";class be extends ne{}n.MarkerSpec=be,be.__name__="MarkerSpec";class we extends ne{}n.LineJoinSpec=we,we.__name__="LineJoinSpec";class qe extends ne{}n.LineCapSpec=qe,qe.__name__="LineCapSpec";class Ne extends ne{}n.LineDashSpec=Ne,Ne.__name__="LineDashSpec";class Be extends ne{_default_override(){return h.settings.dev?"Bokeh":void 0}}n.FontSpec=Be,Be.__name__="FontSpec";class De extends ne{}n.FontSizeSpec=De,De.__name__="FontSizeSpec";class Fe extends ne{}n.FontStyleSpec=Fe,Fe.__name__="FontStyleSpec";class ze extends ne{}n.TextAlignSpec=ze,ze.__name__="TextAlignSpec";class Ue extends ne{}n.TextBaselineSpec=Ue,Ue.__name__="TextBaselineSpec"},
function _(e,l,o,n,t){n();const s=e(8),g=e(13),r={};class i{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=i,i.__name__="LogLevel";class v{constructor(e,l=v.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(v.log_levels)}static get(e,l=v.INFO){if(e.length>0){let o=r[e];return null==o&&(r[e]=o=new v(e,l)),o}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof i)this._log_level=e;else{if(!s.isString(e)||null==v.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=v.log_levels[e]}const l=`[${this._name}]`;for(const[e,o]of g.entries(v.log_levels))o.level<this._log_level.level||this._log_level.level===v.OFF.level?this[e]=function(){}:this[e]=_(e,l)}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function _(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function c(e){const l=o.logger.level;return s.isString(e)&&null==v.log_levels[e]?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log(`[bokeh] valid log levels are: ${v.levels.join(", ")}`)):(console.log(`[bokeh] setting log level to: '${s.isString(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=v,v.__name__="Logger",v.TRACE=new i("trace",0),v.DEBUG=new i("debug",1),v.INFO=new i("info",2),v.WARN=new i("warn",6),v.ERROR=new i("error",7),v.FATAL=new i("fatal",8),v.OFF=new i("off",9),v.log_levels={trace:v.TRACE,debug:v.DEBUG,info:v.INFO,warn:v.WARN,error:v.ERROR,fatal:v.FATAL,off:v.OFF},o.logger=v.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){const o=c(e);try{l()}finally{c(o)}}},
function _(e,n,t,o,i){o(),t.VerticalAlign=void 0;const a=e(21);t.Align=a.Enum("start","center","end"),t.Anchor=a.Enum("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),t.AngleUnits=a.Enum("deg","rad","grad","turn"),t.BoxOrigin=a.Enum("corner","center"),t.ButtonType=a.Enum("default","primary","success","warning","danger","light"),t.CalendarPosition=a.Enum("auto","above","below"),t.Dimension=a.Enum("width","height"),t.Dimensions=a.Enum("width","height","both"),t.Direction=a.Enum("clock","anticlock"),t.Distribution=a.Enum("uniform","normal"),t.FontStyle=a.Enum("normal","italic","bold","bold italic"),t.HatchPatternType=a.Enum("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=a.Enum("POST","GET"),t.HexTileOrientation=a.Enum("pointytop","flattop"),t.HoverMode=a.Enum("mouse","hline","vline"),t.LatLon=a.Enum("lat","lon"),t.LegendClickPolicy=a.Enum("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=a.Enum("butt","round","square"),t.LineJoin=a.Enum("miter","round","bevel"),t.LineDash=a.Enum("solid","dashed","dotted","dotdash","dashdot"),t.LinePolicy=a.Enum("prev","next","nearest","interp","none"),t.Location=a.Enum("above","below","left","right"),t.Logo=a.Enum("normal","grey"),t.MarkerType=a.Enum("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=a.Enum("show","ignore"),t.Orientation=a.Enum("vertical","horizontal"),t.OutputBackend=a.Enum("canvas","svg","webgl"),t.PaddingUnits=a.Enum("percent","absolute"),t.Place=a.Enum("above","below","left","right","center"),t.PointPolicy=a.Enum("snap_to_data","follow_mouse","none"),t.RadiusDimension=a.Enum("x","y","max","min"),t.RenderLevel=a.Enum("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=a.Enum("canvas","css"),t.ResetPolicy=a.Enum("standard","event_only"),t.RoundingFunction=a.Enum("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=a.Enum("replace","append","intersect","subtract"),t.Side=a.Enum("above","below","left","right"),t.SizingMode=a.Enum("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=a.Enum("ascending","descending"),t.SpatialUnits=a.Enum("screen","data"),t.StartEnd=a.Enum("start","end"),t.StepMode=a.Enum("after","before","center"),t.TapBehavior=a.Enum("select","inspect"),t.TextAlign=a.Enum("left","right","center"),t.TextBaseline=a.Enum("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=a.Enum("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=a.Enum("vertical","horizontal","parallel","normal"),t.TooltipAttachment=a.Enum("horizontal","vertical","left","right","above","below"),t.UpdateMode=a.Enum("replace","append"),t.VerticalAlign=a.Enum("top","middle","bottom")},
function _(e,n,t,s,r){s();const i=e(1).__importStar(e(8)),a=e(22),l=e(13),_=window.Map,{hasOwnProperty:u}=Object.prototype;class d{}t.Kind=d,d.__name__="Kind",function(e){class n extends d{valid(e){return!0}}n.__name__="Any",e.Any=n;class t extends d{valid(e){return!0}}t.__name__="Unknown",e.Unknown=t;class s extends d{valid(e){return i.isBoolean(e)}}s.__name__="Boolean",e.Boolean=s;class r extends d{constructor(e){super(),this.obj_type=e}valid(e){return!0}}r.__name__="Ref",e.Ref=r;class c extends d{valid(e){return!0}}c.__name__="AnyRef",e.AnyRef=c;class o extends d{valid(e){return i.isNumber(e)}}o.__name__="Number",e.Number=o;class p extends o{valid(e){return super.valid(e)&&i.isInteger(e)}}p.__name__="Int",e.Int=p;class y extends o{valid(e){return super.valid(e)&&0<=e&&e<=1}}y.__name__="Percent",e.Percent=y;class m extends d{constructor(e){super(),this.types=e,this.types=e}valid(e){return this.types.some((n=>n.valid(e)))}}m.__name__="Or",e.Or=m;class v extends d{constructor(e){super(),this.types=e,this.types=e}valid(e){if(!i.isArray(e))return!1;for(let n=0;n<this.types.length;n++){const t=this.types[n],s=e[n];if(!t.valid(s))return!1}return!0}}v.__name__="Tuple",e.Tuple=v;class w extends d{constructor(e){super(),this.struct_type=e}valid(e){if(!i.isPlainObject(e))return!1;const{struct_type:n}=this;if(l.size(n)!=l.size(e))return!1;for(const t in n)if(u.call(n,t)){if(!u.call(e,t))return!1;const s=n[t],r=e[t];if(!s.valid(r))return!1}return!0}}w.__name__="Struct",e.Struct=w;class h extends d{valid(e){return i.isArray(e)||i.isTypedArray(e)}}h.__name__="Arrayable",e.Arrayable=h;class f extends d{constructor(e){super(),this.item_type=e}valid(e){return i.isArray(e)&&e.every((e=>this.item_type.valid(e)))}}f.__name__="Array",e.Array=f;class K extends d{valid(e){return null===e}}K.__name__="Null",e.Null=K;class b extends d{constructor(e){super(),this.base_type=e}valid(e){return null===e||this.base_type.valid(e)}}b.__name__="Nullable",e.Nullable=b;class A extends d{constructor(e){super(),this.base_type=e}valid(e){return void 0===e||this.base_type.valid(e)}}A.__name__="Opt",e.Opt=A;class x extends d{valid(e){return i.isString(e)}}x.__name__="String",e.String=x;class S extends d{constructor(e){super(),this.values=new Set(e)}valid(e){return this.values.has(e)}*[Symbol.iterator](){yield*this.values}}S.__name__="Enum",e.Enum=S;class N extends d{constructor(e){super(),this.item_type=e}valid(e){if(!i.isPlainObject(e))return!1;for(const n in e)if(u.call(e,n)){const t=e[n];if(!this.item_type.valid(t))return!1}return!0}}N.__name__="Dict",e.Dict=N;class O extends d{constructor(e,n){super(),this.key_type=e,this.item_type=n}valid(e){if(!(e instanceof _))return!1;for(const[n,t]of e.entries())if(!this.key_type.valid(n)||!this.item_type.valid(t))return!1;return!0}}O.__name__="Map",e.Map=O;class g extends d{valid(e){return a.is_Color(e)}}g.__name__="Color",e.Color=g;class P extends d{valid(e){return i.isFunction(e)}}P.__name__="Function",e.Function=P}(t.Kinds||(t.Kinds={})),t.Any=new t.Kinds.Any,t.Unknown=new t.Kinds.Unknown,t.Boolean=new t.Kinds.Boolean,t.Number=new t.Kinds.Number,t.Int=new t.Kinds.Int,t.String=new t.Kinds.String,t.Null=new t.Kinds.Null;t.Nullable=e=>new t.Kinds.Nullable(e);t.Opt=e=>new t.Kinds.Opt(e);t.Or=(...e)=>new t.Kinds.Or(e);t.Tuple=(...e)=>new t.Kinds.Tuple(e);t.Struct=e=>new t.Kinds.Struct(e),t.Arrayable=new t.Kinds.Arrayable;t.Array=e=>new t.Kinds.Array(e);t.Dict=e=>new t.Kinds.Dict(e);t.Map=(e,n)=>new t.Kinds.Map(e,n);t.Enum=(...e)=>new t.Kinds.Enum(e);t.Ref=e=>new t.Kinds.Ref(e);t.AnyRef=()=>new t.Kinds.AnyRef;t.Function=()=>new t.Kinds.Function,t.Percent=new t.Kinds.Percent,t.Alpha=t.Percent,t.Color=new t.Kinds.Color,t.Auto=t.Enum("auto"),t.FontSize=t.String,t.Font=t.String,t.Angle=t.Number},
function _(n,t,r,e,s){e();const u=n(23),l=n(10),c=n(8),{round:i}=Math;function o(n){return l.clamp(i(n),0,255)}function a(){return[0,0,0,0]}function f(n){return[n>>24&255,n>>16&255,n>>8&255,255&n]}function d(n,t){var r;let e,s,u,l;return null==n?[e,s,u,l]=[0,0,0,0]:c.isInteger(n)?[e,s,u,l]=f(n):c.isString(n)?[e,s,u,l]=null!==(r=_(n))&&void 0!==r?r:[0,0,0,0]:([e,s,u,l=1]=n,l=o(255*l)),255==l&&null!=t&&(l=o(255*t)),[e,s,u,l]}r.transparent=a,r.encode_rgba=function([n,t,r,e]){return n<<24|t<<16|r<<8|e},r.decode_rgba=f,r.compose_alpha=function(n,t){return 255==(255&n)?4294967040&n|o(255*t):n},r.color2rgba=d;const h={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function g(n){return h[n>>4]+h[15&n]}r.color2css=function(n,t){const[r,e,s,u]=d(n,t);return`rgba(${r}, ${e}, ${s}, ${u/255})`},r.color2hex=function(n,t){const[r,e,s,u]=d(n,t),l=`#${g(r)}${g(e)}${g(s)}`;return 255==u?l:`${l}${g(u)}`};const b=/^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/,m=/^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/,$=(()=>{const n=document.createElement("canvas");n.width=1,n.height=1;const t=n.getContext("2d"),r=t.createLinearGradient(0,0,1,1);return n=>{t.fillStyle=r,t.fillStyle=n;const e=t.fillStyle;return e!=r?e:null}})();function _(n){var t;if(!(n=n.trim().toLowerCase()))return null;if("transparent"==n)return[0,0,0,0];if(u.is_named_color(n))return f(u.named_colors[n]);if("#"==n[0]){const t=Number("0x"+n.substr(1));if(isNaN(t))return null;switch(n.length-1){case 3:{const n=t>>8&15,r=t>>4&15,e=t>>0&15;return[n<<4|n,r<<4|r,e<<4|e,255]}case 4:{const n=t>>12&15,r=t>>8&15,e=t>>4&15,s=t>>0&15;return[n<<4|n,r<<4|r,e<<4|e,s<<4|s]}case 6:return[t>>16&255,t>>8&255,t>>0&255,255];case 8:return[t>>24&255,t>>16&255,t>>8&255,t>>0&255]}}else if(n.startsWith("rgb")){const r=null!==(t=n.match(b))&&void 0!==t?t:n.match(m);if(null!=r){let[,n,t,e,s="1"]=r;const u=n.endsWith("%"),l=t.endsWith("%"),c=e.endsWith("%"),i=s.endsWith("%");if(!(u&&l&&c)&&(u||l||c))return null;u&&(n=n.slice(0,-1)),l&&(t=t.slice(0,-1)),c&&(e=e.slice(0,-1)),i&&(s=s.slice(0,-1));let a=Number(n),f=Number(t),d=Number(e),h=Number(s);return isNaN(a+f+d+h)?null:(u&&(a=a/100*255),l&&(f=f/100*255),c&&(d=d/100*255),h=255*(i?h/100:h),a=o(a),f=o(f),d=o(d),h=o(h),[a,f,d,h])}}else{const t=$(n);if(null!=t)return _(t)}return null}r.css4_parse=_,r.is_Color=function(n){return!!c.isInteger(n)||(!(!c.isString(n)||null==_(n))||!(!c.isArray(n)||3!=n.length&&4!=n.length))},r.is_dark=function([n,t,r]){return 1-(.299*n+.587*t+.114*r)/255>=.6}},
function _(e,r,l,a,i){a();l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199},l.is_named_color=function(e){return e in l.named_colors}},
function _(r,t,n,a,o){a(),n.GeneratorFunction=Object.getPrototypeOf((function*(){})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.infer_type=function(r,t){return r instanceof Float64Array||r instanceof Array||t instanceof Float64Array||t instanceof Array?Float64Array:Float32Array},n.ScreenArray=Float32Array,n.to_screen=function(r){return r instanceof Float32Array?r:new Float32Array(r)},o("Indices",r(25).BitSet)},
function _(t,s,r,e,i){e();const n=t(26),o=t(11);class a{constructor(t,s=0){this.size=t,this[Symbol.toStringTag]="BitSet",this._count=null,this._nwords=Math.ceil(t/32),0==s||1==s?(this._array=new Uint32Array(this._nwords),1==s&&this._array.fill(4294967295)):(o.assert(s.length==this._nwords,"Initializer size mismatch"),this._array=s)}clone(){return new a(this.size,new Uint32Array(this._array))}[n.equals](t,s){if(!s.eq(this.size,t.size))return!1;const{_nwords:r}=this,e=this.size%r,i=0==e?r:r-1;for(let s=0;s<i;s++)if(this._array[s]!=t._array[s])return!1;if(0==e)return!0;{const s=1<<e-1,r=s-1^s;return(this._array[i]&r)==(t._array[i]&r)}}static all_set(t){return new a(t,1)}static all_unset(t){return new a(t,0)}static from_indices(t,s){const r=new a(t);for(const t of s)r.set(t);return r}static from_booleans(t,s){const r=new a(t),e=Math.min(t,s.length);for(let t=0;t<e;t++)s[t]&&r.set(t);return r}_check_bounds(t){o.assert(0<=t&&t<this.size,`Out of bounds: 0 <= ${t} < ${this.size}`)}get(t){this._check_bounds(t);const s=t>>>5,r=31&t;return!!(this._array[s]>>r&1)}set(t,s=!0){this._check_bounds(t),this._count=null;const r=t>>>5,e=31&t;s?this._array[r]|=1<<e:this._array[r]&=~(1<<e)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:s,size:r}=this;let e=0;for(let i=0,n=0;n<s;n++){const s=t[n];if(0==s)i+=32;else for(let t=0;t<32&&i<r;t++,i++)s>>>t&1&&(e+=1)}return e}*ones(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(0!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1&&(yield e);else e+=32}}*zeros(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(4294967295!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1||(yield e);else e+=32}}_check_size(t){o.assert(this.size==t.size,"Size mismatch")}add(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]|=t._array[s]}intersect(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]&=t._array[s]}subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++){const r=this._array[s],e=t._array[s];this._array[s]=(r^e)&r}}union(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]|=t._array[r];return s}intersection(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]&=t._array[r];return s}difference(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++){const e=this._array[r],i=t._array[r];s._array[r]=(e^i)&e}return s}select(t){o.assert(this.size<=t.length,"Size mismatch");const s=this.count,r=new t.constructor(s);let e=0;for(const s of this)r[e++]=t[s];return r}}r.BitSet=a,a.__name__="BitSet"},
function _(t,e,r,n,s){n();const o=t(8),{hasOwnProperty:c}=Object.prototype;function a(t){return o.isObject(t)&&void 0!==t[r.equals]}r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const i=Object.prototype.toString;class u{constructor(){this.a_stack=[],this.b_stack=[]}eq(t,e){if(Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const n=i.call(t);if(n!=i.call(e))return!1;switch(n){case"[object Number]":return this.numbers(t,e);case"[object RegExp]":case"[object String]":return`${t}`==`${e}`;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:s,b_stack:o}=this;let c=s.length;for(;c--;)if(s[c]===t)return o[c]===e;s.push(t),o.push(e);const u=(()=>{if(a(t)&&a(e))return t[r.equals](e,this);switch(n){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(`${t}`,`${e}`)}if(t instanceof Node)return this.nodes(t,e);throw Error(`can't compare objects of type ${n}`)})();return s.pop(),o.pop(),u}numbers(t,e){return Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let n=0;n<r;n++)if(!this.eq(t[n],e[n]))return!1;return!0}iterables(t,e){const r=t[Symbol.iterator](),n=e[Symbol.iterator]();for(;;){const t=r.next(),e=n.next();if(t.done&&e.done)return!0;if(t.done||e.done)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;for(const[r,n]of t)if(!e.has(r)||!this.eq(n,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const n of r)if(!c.call(e,n)||!this.eq(t[n],e[n]))return!1;return!0}nodes(t,e){return t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes))}}r.Comparator=u,u.__name__="Comparator";const{abs:l}=Math;class b extends u{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||l(t-e)<this.tolerance}}function f(t,e){return(new u).eq(t,e)}r.SimilarComparator=b,b.__name__="SimilarComparator",r.is_equal=f,r.is_similar=function(t,e,r){return new b(r).eq(t,e)},r.isEqual=f},
function _(n,i,e,t,r){t(),e.is_windows=navigator.appVersion.includes("Windows"),e.is_ie=(()=>{const n=navigator.userAgent;return n.includes("MSIE")||n.includes("Trident")||n.includes("Edge")})(),e.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),e.is_little_endian=(()=>{const n=new ArrayBuffer(4),i=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let e=!0;return 10==i[4]&&11==i[5]&&12==i[6]&&13==i[7]&&(e=!1),e})(),e.BYTE_ORDER=e.is_little_endian?"little":"big",e.to_big_endian=function(n){if(e.is_little_endian){const i=new Uint32Array(n.length),e=new DataView(i.buffer);let t=0;for(const i of n)e.setUint32(t,i),t+=4;return i}return n}},
function _(e,t,r,i,s){i();class _{constructor(){this._dev=!1,this._wireframe=!1}set dev(e){this._dev=e}get dev(){return this._dev}set wireframe(e){this._wireframe=e}get wireframe(){return this._wireframe}}r.Settings=_,_.__name__="Settings",r.settings=new _},
function _(t,e,s,r,n){var a,i,h,u,l,c,o,y;r();const p=t(8),_=t(11),A=t(26),d=t(30),D=t(31),N=Symbol("__ndarray__");class f extends Uint8Array{constructor(t,e){super(t),this[a]=!0,this.dtype="uint8",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(a=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Uint8NDArray=f,f.__name__="Uint8NDArray";class m extends Int8Array{constructor(t,e){super(t),this[i]=!0,this.dtype="int8",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(i=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Int8NDArray=m,m.__name__="Int8NDArray";class g extends Uint16Array{constructor(t,e){super(t),this[h]=!0,this.dtype="uint16",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(h=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Uint16NDArray=g,g.__name__="Uint16NDArray";class q extends Int16Array{constructor(t,e){super(t),this[u]=!0,this.dtype="int16",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(u=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Int16NDArray=q,q.__name__="Int16NDArray";class I extends Uint32Array{constructor(t,e){super(t),this[l]=!0,this.dtype="uint32",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(l=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Uint32NDArray=I,I.__name__="Uint32NDArray";class U extends Int32Array{constructor(t,e){super(t),this[c]=!0,this.dtype="int32",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(c=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Int32NDArray=U,U.__name__="Int32NDArray";class w extends Float32Array{constructor(t,e){super(t),this[o]=!0,this.dtype="float32",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(o=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}s.Float32NDArray=w,w.__name__="Float32NDArray";class x extends Float64Array{constructor(t,e){super(t),this[y]=!0,this.dtype="float64",this.shape=null!=e?e:z(t)?t.shape:[this.length],this.dimension=this.shape.length}[(y=N,A.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[d.serialize](t){return D.encode_NDArray(this)}}function z(t){return p.isObject(t)&&void 0!==t[N]}s.Float64NDArray=x,x.__name__="Float64NDArray",s.is_NDArray=z,s.ndarray=function(t,e={}){let{dtype:s}=e;null==s&&(s=t instanceof ArrayBuffer||p.isArray(t)?"float64":(()=>{switch(!0){case t instanceof Uint8Array:return"uint8";case t instanceof Int8Array:return"int8";case t instanceof Uint16Array:return"uint16";case t instanceof Int16Array:return"int16";case t instanceof Uint32Array:return"uint32";case t instanceof Int32Array:return"int32";case t instanceof Float32Array:return"float32";case t instanceof Float64Array:return"float64";default:_.unreachable()}})());const{shape:r}=e;switch(s){case"uint8":return new f(t,r);case"int8":return new m(t,r);case"uint16":return new g(t,r);case"int16":return new q(t,r);case"uint32":return new I(t,r);case"int32":return new U(t,r);case"float32":return new w(t,r);case"float64":return new x(t,r)}}},
function _(e,r,t,i,s){i();const n=e(11),a=e(13),l=e(8);t.serialize=Symbol("serialize");class o extends Error{}t.SerializationError=o,o.__name__="SerializationError";class f{constructor(e){var r;this._references=new Map,this._definitions=new Map,this._refmap=new Map,this.include_defaults=null===(r=null==e?void 0:e.include_defaults)||void 0===r||r}get_ref(e){return this._references.get(e)}add_ref(e,r){n.assert(!this._references.has(e)),this._references.set(e,r)}add_def(e,r){const t=this.get_ref(e);n.assert(null!=t),this._definitions.set(e,r),this._refmap.set(t,r)}get objects(){return new Set(this._references.keys())}get references(){return new Set(this._references.values())}get definitions(){return new Set(this._definitions.values())}resolve_ref(e){return this._refmap.get(e)}remove_ref(e){return this._references.delete(e)}remove_def(e){return this._definitions.delete(e)}to_serializable(e){const r=this.get_ref(e);if(null!=r)return r;if(function(e){return l.isObject(e)&&void 0!==e[t.serialize]}(e))return e[t.serialize](this);if(l.isArray(e)||l.isTypedArray(e)){const r=e.length,t=new Array(r);for(let i=0;i<r;i++){const r=e[i];t[i]=this.to_serializable(r)}return t}if(l.isPlainObject(e)){const r={};for(const[t,i]of a.entries(e))r[t]=this.to_serializable(i);return r}if(null===e||l.isBoolean(e)||l.isNumber(e)||l.isString(e))return e;throw new o(`${Object.prototype.toString.call(e)} is not serializable`)}}t.Serializer=f,f.__name__="Serializer"},
function _(r,e,n,t,_){t();const a=r(1),f=r(8),u=a.__importStar(r(29)),s=r(27),i=r(32);n.is_NDArray_ref=function(r){return f.isPlainObject(r)&&("__buffer__"in r||"__ndarray__"in r)},n.decode_NDArray=function(r,e){const{shape:n,dtype:t,order:_}=r;let a;if("__buffer__"in r){const n=e.get(r.__buffer__);if(null==n)throw new Error(`buffer for ${r.__buffer__} not found`);a=n}else a=i.base64_to_buffer(r.__ndarray__);const f=(()=>{switch(t){case"uint8":return new u.Uint8NDArray(a,n);case"int8":return new u.Int8NDArray(a,n);case"uint16":return new u.Uint16NDArray(a,n);case"int16":return new u.Int16NDArray(a,n);case"uint32":return new u.Uint32NDArray(a,n);case"int32":return new u.Int32NDArray(a,n);case"float32":return new u.Float32NDArray(a,n);case"float64":return new u.Float64NDArray(a,n)}})();return _!==s.BYTE_ORDER&&i.swap(f),f},n.encode_NDArray=function(r,e){const n={order:s.BYTE_ORDER,dtype:r.dtype,shape:r.shape};if(null!=e){const t=`${e.size}`;return e.set(t,r.buffer),Object.assign({__buffer__:t},n)}{const e=i.buffer_to_base64(r.buffer);return Object.assign({__ndarray__:e},n)}}},
function _(t,e,n,r,f){r(),n.buffer_to_base64=function(t){const e=new Uint8Array(t),n=Array.from(e).map((t=>String.fromCharCode(t)));return btoa(n.join(""))},n.base64_to_buffer=function(t){const e=atob(t),n=e.length,r=new Uint8Array(n);for(let t=0,f=n;t<f;t++)r[t]=e.charCodeAt(t);return r.buffer},n.swap=function(t){switch(t.BYTES_PER_ELEMENT){case 2:!function(t){const e=new Uint8Array(t.buffer,t.byteOffset,2*t.length);for(let t=0,n=e.length;t<n;t+=2){const n=e[t];e[t]=e[t+1],e[t+1]=n}}(t);break;case 4:!function(t){const e=new Uint8Array(t.buffer,t.byteOffset,4*t.length);for(let t=0,n=e.length;t<n;t+=4){let n=e[t];e[t]=e[t+3],e[t+3]=n,n=e[t+1],e[t+1]=e[t+2],e[t+2]=n}}(t);break;case 8:!function(t){const e=new Uint8Array(t.buffer,t.byteOffset,8*t.length);for(let t=0,n=e.length;t<n;t+=8){let n=e[t];e[t]=e[t+7],e[t+7]=n,n=e[t+1],e[t+1]=e[t+6],e[t+6]=n,n=e[t+2],e[t+2]=e[t+5],e[t+5]=n,n=e[t+3],e[t+3]=e[t+4],e[t+4]=n}}(t)}}},
function _(t,r,e,s,a){s();const i=t(26);class n{is_Scalar(){return this.is_scalar}is_Vector(){return!this.is_scalar}}e.Uniform=n,n.__name__="Uniform";class l extends n{constructor(t,r){super(),this.value=t,this.length=r,this.is_scalar=!0}get(t){return this.value}*[Symbol.iterator](){const{length:t,value:r}=this;for(let e=0;e<t;e++)yield r}select(t){return new l(this.value,t.count)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.value,t.value)}}e.UniformScalar=l,l.__name__="UniformScalar";class o extends n{constructor(t){super(),this.array=t,this.is_scalar=!1,this.length=this.array.length}get(t){return this.array[t]}*[Symbol.iterator](){yield*this.array}select(t){const r=t.select(this.array);return new this.constructor(r)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.array,t.array)}}e.UniformVector=o,o.__name__="UniformVector";class h extends o{constructor(t){super(t),this.array=t,this._view=new DataView(t.buffer)}get(t){return this._view.getUint32(4*t)}*[Symbol.iterator](){const t=this.length;for(let r=0;r<t;r++)yield this.get(r)}}e.ColorUniformVector=h,h.__name__="ColorUniformVector"},
function _(t,e,r,n,u){n();const c=t(28);function s(){const t=new Array(32),e="0123456789ABCDEF";for(let r=0;r<32;r++)t[r]=e.substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]=e.substr(3&t[16].charCodeAt(0)|8,1),t.join("")}r.startsWith=function(t,e,r=0){return t.substr(r,e.length)==e},r.uuid4=s;let a=1e3;r.uniqueId=function(t){const e=c.settings.dev?"j"+a++:s();return null!=t?`${t}-${e}`:e},r.escape=function(t){return t.replace(/(?:[&<>"'`])/g,(t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}}))},r.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,((t,e)=>{switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}}))},r.use_strict=function(t){return`'use strict';\n${t}`},r.to_fixed=function(t,e){return t.toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")}},
function _(e,t,s,n,o){n();const i=e(30);class r{constructor(e){this.document=e}}s.DocumentEvent=r,r.__name__="DocumentEvent";class a extends r{constructor(e,t,s){super(e),this.events=t,this.setter_id=s}}s.DocumentEventBatch=a,a.__name__="DocumentEventBatch";class d extends r{}s.DocumentChangedEvent=d,d.__name__="DocumentChangedEvent";class l extends d{constructor(e,t,s){super(e),this.msg_type=t,this.msg_data=s}[i.serialize](e){const t=this.msg_data,s=e.to_serializable(t);return{kind:"MessageSent",msg_type:this.msg_type,msg_data:s}}}s.MessageSentEvent=l,l.__name__="MessageSentEvent";class _ extends d{constructor(e,t,s,n,o,i,r){super(e),this.model=t,this.attr=s,this.old=n,this.new_=o,this.setter_id=i,this.hint=r}[i.serialize](e){if(null!=this.hint)return e.to_serializable(this.hint);const t=this.new_,s=e.to_serializable(t);return this.model!=t&&e.remove_def(this.model),{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:s}}}s.ModelChangedEvent=_,_.__name__="ModelChangedEvent";class c extends d{constructor(e,t,s){super(e),this.column_source=t,this.patches=s}[i.serialize](e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}}}s.ColumnsPatchedEvent=c,c.__name__="ColumnsPatchedEvent";class h extends d{constructor(e,t,s,n){super(e),this.column_source=t,this.data=s,this.rollover=n}[i.serialize](e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}}}s.ColumnsStreamedEvent=h,h.__name__="ColumnsStreamedEvent";class m extends d{constructor(e,t,s){super(e),this.title=t,this.setter_id=s}[i.serialize](e){return{kind:"TitleChanged",title:this.title}}}s.TitleChangedEvent=m,m.__name__="TitleChangedEvent";class u extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}[i.serialize](e){return{kind:"RootAdded",model:e.to_serializable(this.model)}}}s.RootAddedEvent=u,u.__name__="RootAddedEvent";class v extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}[i.serialize](e){return{kind:"RootRemoved",model:this.model.ref()}}}s.RootRemovedEvent=v,v.__name__="RootRemovedEvent"},
function _(t,r,n,i,e){i();const s=t(8),o=t(13);n.pretty=Symbol("pretty");class c{constructor(t){this.precision=null==t?void 0:t.precision}to_string(t){return function(t){return s.isObject(t)&&void 0!==t[n.pretty]}(t)?t[n.pretty](this):s.isBoolean(t)?this.boolean(t):s.isNumber(t)?this.number(t):s.isString(t)?this.string(t):s.isArray(t)?this.array(t):s.isIterable(t)?this.iterable(t):s.isPlainObject(t)?this.object(t):`${t}`}token(t){return t}boolean(t){return`${t}`}number(t){return null!=this.precision?t.toFixed(this.precision):`${t}`}string(t){return`"${t.replace(/'/g,"\\'")}"`}array(t){const r=this.token,n=[];for(const r of t)n.push(this.to_string(r));return`${r("[")}${n.join(`${r(",")} `)}${r("]")}`}iterable(t){var r;const n=this.token,i=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",e=this.array(t);return`${i}${n("(")}${e}${n(")")}`}object(t){const r=this.token,n=[];for(const[i,e]of o.entries(t))n.push(`${i}${r(":")} ${this.to_string(e)}`);return`${r("{")}${n.join(`${r(",")} `)}${r("}")}`}}n.Printer=c,c.__name__="Printer",n.to_string=function(t,r){return new c(r).to_string(t)}},
function _(n,o,r,e,t){e();const l=n(13),i=n(8);function c(n){return i.isObject(n)&&void 0!==n[r.clone]}r.clone=Symbol("clone"),r.is_Cloneable=c;class s extends Error{}r.CloningError=s,s.__name__="CloningError";class a{constructor(){}clone(n){if(c(n))return n[r.clone](this);if(i.isArray(n)){const o=n.length,r=new Array(o);for(let e=0;e<o;e++){const o=n[e];r[e]=this.clone(o)}return r}if(i.isPlainObject(n)){const o={};for(const[r,e]of l.entries(n))o[r]=this.clone(e);return o}if(null===n||i.isBoolean(n)||i.isNumber(n)||i.isString(n))return n;throw new s(`${Object.prototype.toString.call(n)} is not cloneable`)}}r.Cloner=a,a.__name__="Cloner"},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(39),r),e.__exportStar(t(162),r),e.__exportStar(t(257),r),e.__exportStar(t(261),r),e.__exportStar(t(266),r),e.__exportStar(t(272),r),e.__exportStar(t(205),r),e.__exportStar(t(277),r),e.__exportStar(t(313),r),e.__exportStar(t(315),r),e.__exportStar(t(317),r),e.__exportStar(t(209),r),e.__exportStar(t(147),r),e.__exportStar(t(330),r),e.__exportStar(t(338),r),e.__exportStar(t(220),r),e.__exportStar(t(339),r),e.__exportStar(t(217),r),e.__exportStar(t(340),r),e.__exportStar(t(341),r),e.__exportStar(t(198),r),e.__exportStar(t(346),r),e.__exportStar(t(356),r),e.__exportStar(t(360),r)},
function _(e,o,n,a,t){a(),t("Annotation",e(40).Annotation),t("Arrow",e(55).Arrow),t("ArrowHead",e(133).ArrowHead),t("OpenHead",e(133).OpenHead),t("NormalHead",e(133).NormalHead),t("TeeHead",e(133).TeeHead),t("VeeHead",e(133).VeeHead),t("Band",e(134).Band),t("BoxAnnotation",e(136).BoxAnnotation),t("ColorBar",e(137).ColorBar),t("Label",e(226).Label),t("LabelSet",e(227).LabelSet),t("Legend",e(228).Legend),t("LegendItem",e(229).LegendItem),t("PolyAnnotation",e(231).PolyAnnotation),t("Slope",e(232).Slope),t("Span",e(233).Span),t("TextAnnotation",e(139).TextAnnotation),t("Title",e(138).Title),t("ToolbarPanel",e(234).ToolbarPanel),t("Tooltip",e(254).Tooltip),t("Whisker",e(256).Whisker)},
function _(t,e,i,n,s){n();const o=t(41);class a extends o.RendererView{get_size(){if(this.model.visible){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,(()=>{null!=this.layout&&(this.layout.visible=this.model.visible,this.plot_view.request_layout())}))}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}i.AnnotationView=a,a.__name__="AnnotationView";class l extends o.Renderer{constructor(t){super(t)}static init_Annotation(){this.override({level:"annotation"})}}i.Annotation=l,l.__name__="Annotation",l.init_Annotation()},
function _(e,i,t,n,s){n();const r=e(1),a=e(42),_=r.__importStar(e(45)),o=e(20),l=e(53),d=e(54);class h extends a.View{get coordinates(){const{_coordinates:e}=this;return null!=e?e:this._coordinates=this._initialize_coordinates()}initialize(){super.initialize(),this.visuals=new _.Visuals(this),this.needs_webgl_blit=!1}connect_signals(){super.connect_signals();const{x_range_name:e,y_range_name:i}=this.model.properties;this.on_change([e,i],(()=>this._initialize_coordinates()))}_initialize_coordinates(){const{x_range_name:e,y_range_name:i}=this.model,{frame:t}=this.plot_view,n=t.x_scales.get(e),s=t.y_scales.get(i);return new d.CoordinateTransform(n,s)}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:i}=this.canvas;return"overlay"==this.model.level?e:i}get canvas(){return this.plot_view.canvas_view}request_render(){this.request_paint()}request_paint(){this.plot_view.request_paint(this)}notify_finished(){this.plot_view.notify_finished()}get needs_clip(){return!1}get has_webgl(){return!1}render(){this.model.visible&&this._render(),this._has_finished=!0}renderer_view(e){}}t.RendererView=h,h.__name__="RendererView";class c extends l.Model{constructor(e){super(e)}static init_Renderer(){this.define((({Boolean:e,String:i})=>({level:[o.RenderLevel,"image"],visible:[e,!0],x_range_name:[i,"default"],y_range_name:[i,"default"]})))}}t.Renderer=c,c.__name__="Renderer",c.init_Renderer()},
function _(t,e,s,i,n){i();const r=t(1),o=t(15),h=t(43),l=t(8),a=r.__importDefault(t(44));class _{constructor(t){this.removed=new o.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap;const{model:e,parent:s}=t;this.model=e,this.parent=s,this.root=null==s?this:s.root,this.removed.emit()}get ready(){return this._ready}connect(t,e){let s=this._slots.get(e);return null==s&&(s=(t,s)=>{const i=Promise.resolve(e.call(this,t,s));this._ready=this._ready.then((()=>i))},this._slots.set(e,s)),t.connect(s,this)}disconnect(t,e){return t.disconnect(e,this)}initialize(){this._has_finished=!1,this.is_root&&(this._stylesheet=h.stylesheet);for(const t of this.styles())this.stylesheet.append(t)}async lazy_initialize(){}remove(){this.disconnect_signals(),this.removed.emit()}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get is_root(){return null==this.parent}assert_root(){if(!this.is_root)throw new Error(`${this.toString()} is not a root layout`)}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){o.Signal.disconnect_receiver(this)}on_change(t,e){for(const s of l.isArray(t)?t:[t])this.connect(s.change,e)}cursor(t,e){return null}get stylesheet(){return this.is_root?this._stylesheet:this.root.stylesheet}styles(){return[a.default]}}s.View=_,_.__name__="View"},
function _(t,e,n,i,o){i();const s=t(8),l=t(13),r=t=>(e={},...n)=>{const i=document.createElement(t);i.classList.add("bk");for(let[t,n]of l.entries(e))if(null!=n&&(!s.isBoolean(n)||n))if("class"===t&&(s.isString(n)&&(n=n.split(/\s+/)),s.isArray(n)))for(const t of n)null!=t&&i.classList.add(t);else if("style"===t&&s.isPlainObject(n))for(const[t,e]of l.entries(n))i.style[t]=e;else if("data"===t&&s.isPlainObject(n))for(const[t,e]of l.entries(n))i.dataset[t]=e;else i.setAttribute(t,n);function o(t){if(s.isString(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if(s.isArray(t))for(const e of t)o(e);else o(t);return i};function a(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function c(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)}function d(t,e){var n,i,o;const s=Element.prototype;return(null!==(o=null!==(i=null!==(n=s.matches)&&void 0!==n?n:s.webkitMatchesSelector)&&void 0!==i?i:s.mozMatchesSelector)&&void 0!==o?o:s.msMatchesSelector).call(t,e)}function h(t){return parseFloat(t)||0}function u(t){const e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function f(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return r(t)(e,...n)},n.div=r("div"),n.span=r("span"),n.canvas=r("canvas"),n.link=r("link"),n.style=r("style"),n.a=r("a"),n.p=r("p"),n.i=r("i"),n.pre=r("pre"),n.button=r("button"),n.label=r("label"),n.input=r("input"),n.select=r("select"),n.option=r("option"),n.optgroup=r("optgroup"),n.textarea=r("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=a,n.removeElement=a,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=c,n.empty=function(t,e=!1){let n;for(;n=t.firstChild;)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){const e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=d,n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(d(n,e))return n;return null},n.extents=u,n.size=f,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=u(t),{width:s,height:l}=f(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=u(t);let o=0,s=0;for(const l of t.children){const t=l.getBoundingClientRect();o=Math.max(o,Math.ceil(t.left-e-i.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-i.top+t.height))}return{width:o,height:s}},n.position=function(t,e,n){const{style:i}=t;if(i.left=`${e.x}px`,i.top=`${e.y}px`,i.width=`${e.width}px`,i.height=`${e.height}px`,null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}},n.children=function(t){return Array.from(t.children)};class p{constructor(t){this.el=t,this.classList=t.classList}get values(){const t=[];for(let e=0;e<this.classList.length;e++){const n=this.classList.item(e);null!=n&&t.push(n)}return t}has(t){return this.classList.contains(t)}add(...t){for(const e of t)this.classList.add(e);return this}remove(...t){for(const e of t)this.classList.remove(e);return this}clear(){for(const t of this.values)"bk"!=t&&this.classList.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var g;function m(t,e,n){const{width:i,height:o,position:s,display:l}=t.style;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?`${e.width}px`:"auto",t.style.height=null!=e.height&&e.height!=1/0?`${e.height}px`:"auto";try{return n()}finally{t.style.position=s,t.style.display=l,t.style.width=i,t.style.height=o}}n.ClassList=p,p.__name__="ClassList",n.classes=function(t){return new p(t)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(g=n.Keys||(n.Keys={}))[g.Backspace=8]="Backspace",g[g.Tab=9]="Tab",g[g.Enter=13]="Enter",g[g.Esc=27]="Esc",g[g.PageUp=33]="PageUp",g[g.PageDown=34]="PageDown",g[g.Left=37]="Left",g[g.Up=38]="Up",g[g.Right=39]="Right",g[g.Down=40]="Down",g[g.Delete=46]="Delete",n.undisplayed=function(t,e){const{display:n}=t.style;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return m(t,{},e)},n.sized=m;class y{constructor(t){this.root=t,this.known=new Set,this.style=n.style({type:"text/css"}),c(t,this.style)}append(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))}}n.StyleSheet=y,y.__name__="StyleSheet",n.stylesheet=new y(document.head),n.dom_ready=async function(){if("loading"==document.readyState)return new Promise(((t,e)=>{document.addEventListener("DOMContentLoaded",(()=>t()),{once:!0})}))}},
function _(o,i,t,e,r){e(),t.root="bk-root",t.default=".bk-root{position:relative;width:auto;height:auto;z-index:0;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}"},
function _(e,t,r,a,c){a();const l=e(1),n=e(46);c("Line",n.Line),c("LineScalar",n.LineScalar),c("LineVector",n.LineVector);const i=e(49);c("Fill",i.Fill),c("FillScalar",i.FillScalar),c("FillVector",i.FillVector);const s=e(50);c("Text",s.Text),c("TextScalar",s.TextScalar),c("TextVector",s.TextVector);const o=e(51);c("Hatch",o.Hatch),c("HatchScalar",o.HatchScalar),c("HatchVector",o.HatchVector);const u=l.__importStar(e(48)),V=e(47);c("VisualProperties",V.VisualProperties),c("VisualUniforms",V.VisualUniforms);class h{constructor(e){this._visuals=[];for(const[t,r]of e.model._mixins){const a=(()=>{switch(r){case u.Line:return new n.Line(e,t);case u.LineScalar:return new n.LineScalar(e,t);case u.LineVector:return new n.LineVector(e,t);case u.Fill:return new i.Fill(e,t);case u.FillScalar:return new i.FillScalar(e,t);case u.FillVector:return new i.FillVector(e,t);case u.Text:return new s.Text(e,t);case u.TextScalar:return new s.TextScalar(e,t);case u.TextVector:return new s.TextVector(e,t);case u.Hatch:return new o.Hatch(e,t);case u.HatchScalar:return new o.HatchScalar(e,t);case u.HatchVector:return new o.HatchVector(e,t);default:throw new Error("unknown visual")}})();this._visuals.push(a),Object.defineProperty(this,t+a.type,{get:()=>a,configurable:!1,enumerable:!0})}}*[Symbol.iterator](){yield*this._visuals}}r.Visuals=h,h.__name__="Visuals"},
function _(e,t,i,l,s){l();const n=e(1),a=e(47),o=n.__importStar(e(48)),r=e(22),_=e(8);function h(e){if(_.isArray(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(_.isInteger)}}i.resolve_line_dash=h;class c extends a.VisualProperties{get doit(){const e=this.line_color.get_value(),t=this.line_alpha.get_value(),i=this.line_width.get_value();return!(null==e||0==t||0==i)}set_value(e){const t=this.line_color.get_value(),i=this.line_alpha.get_value();e.strokeStyle=r.color2css(t,i),e.lineWidth=this.line_width.get_value(),e.lineJoin=this.line_join.get_value(),e.lineCap=this.line_cap.get_value(),e.lineDash=h(this.line_dash.get_value()),e.lineDashOffset=this.line_dash_offset.get_value()}}i.Line=c,c.__name__="Line";class u extends a.VisualUniforms{get doit(){const e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)}set_value(e){const t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=r.color2css(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.lineDash=h(this.line_dash.value),e.lineDashOffset=this.line_dash_offset.value}}i.LineScalar=u,u.__name__="LineScalar";class d extends a.VisualUniforms{get doit(){const{line_color:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{line_alpha:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{line_width:i}=this;return!i.is_Scalar()||0!=i.value}set_vectorize(e,t){const i=this.line_color.get(t),l=this.line_alpha.get(t),s=this.line_width.get(t),n=this.line_join.get(t),a=this.line_cap.get(t),o=this.line_dash.get(t),_=this.line_dash_offset.get(t);e.strokeStyle=r.color2css(i,l),e.lineWidth=s,e.lineJoin=n,e.lineCap=a,e.lineDash=h(o),e.lineDashOffset=_}}i.LineVector=d,d.__name__="LineVector",c.prototype.type="line",c.prototype.attrs=Object.keys(o.Line),u.prototype.type="line",u.prototype.attrs=Object.keys(o.LineScalar),d.prototype.type="line",d.prototype.attrs=Object.keys(o.LineVector)},
function _(t,s,o,i,r){i();class e{constructor(t,s=""){this.obj=t,this.prefix=s;const o=this;this._props=[];for(const i of this.attrs){const r=t.model.properties[s+i];r.change.connect((()=>this.update())),o[i]=r,this._props.push(r)}this.update()}*[Symbol.iterator](){yield*this._props}update(){}}o.VisualProperties=e,e.__name__="VisualProperties";class p{constructor(t,s=""){this.obj=t,this.prefix=s;for(const o of this.attrs)Object.defineProperty(this,o,{get:()=>t[s+o]})}*[Symbol.iterator](){for(const t of this.attrs)yield this.obj.model.properties[this.prefix+t]}update(){}}o.VisualUniforms=p,p.__name__="VisualUniforms"},
function _(e,l,t,a,c){a();const r=e(1),o=r.__importStar(e(18)),n=e(20),i=r.__importStar(e(21)),_=e(13);t.Line={line_color:[i.Nullable(i.Color),"black"],line_alpha:[i.Alpha,1],line_width:[i.Number,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[i.Or(n.LineDash,i.Array(i.Number)),[]],line_dash_offset:[i.Number,0]},t.Fill={fill_color:[i.Nullable(i.Color),"gray"],fill_alpha:[i.Alpha,1]},t.Hatch={hatch_color:[i.Nullable(i.Color),"black"],hatch_alpha:[i.Alpha,1],hatch_scale:[i.Number,12],hatch_pattern:[i.Nullable(i.Or(n.HatchPatternType,i.String)),null],hatch_weight:[i.Number,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},t.Text={text_color:[i.Nullable(i.Color),"#444444"],text_alpha:[i.Alpha,1],text_font:[o.Font,"helvetica"],text_font_size:[i.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]},t.LineScalar={line_color:[o.ColorScalar,"black"],line_alpha:[o.NumberScalar,1],line_width:[o.NumberScalar,1],line_join:[o.LineJoinScalar,"bevel"],line_cap:[o.LineCapScalar,"butt"],line_dash:[o.LineDashScalar,[]],line_dash_offset:[o.NumberScalar,0]},t.FillScalar={fill_color:[o.ColorScalar,"gray"],fill_alpha:[o.NumberScalar,1]},t.HatchScalar={hatch_color:[o.ColorScalar,"black"],hatch_alpha:[o.NumberScalar,1],hatch_scale:[o.NumberScalar,12],hatch_pattern:[o.NullStringScalar,null],hatch_weight:[o.NumberScalar,1],hatch_extra:[o.AnyScalar,{}]},t.TextScalar={text_color:[o.ColorScalar,"#444444"],text_alpha:[o.NumberScalar,1],text_font:[o.FontScalar,"helvetica"],text_font_size:[o.FontSizeScalar,"16px"],text_font_style:[o.FontStyleScalar,"normal"],text_align:[o.TextAlignScalar,"left"],text_baseline:[o.TextBaselineScalar,"bottom"],text_line_height:[o.NumberScalar,1.2]},t.LineVector={line_color:[o.ColorSpec,"black"],line_alpha:[o.NumberSpec,1],line_width:[o.NumberSpec,1],line_join:[o.LineJoinSpec,"bevel"],line_cap:[o.LineCapSpec,"butt"],line_dash:[o.LineDashSpec,[]],line_dash_offset:[o.NumberSpec,0]},t.FillVector={fill_color:[o.ColorSpec,"gray"],fill_alpha:[o.NumberSpec,1]},t.HatchVector={hatch_color:[o.ColorSpec,"black"],hatch_alpha:[o.NumberSpec,1],hatch_scale:[o.NumberSpec,12],hatch_pattern:[o.NullStringSpec,null],hatch_weight:[o.NumberSpec,1],hatch_extra:[o.AnyScalar,{}]},t.TextVector={text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_font:[o.FontSpec,"helvetica"],text_font_size:[o.FontSizeSpec,"16px"],text_font_style:[o.FontStyleSpec,"normal"],text_align:[o.TextAlignSpec,"left"],text_baseline:[o.TextBaselineSpec,"bottom"],text_line_height:[o.NumberSpec,1.2]},t.attrs_of=function(e,l,t,a=!1){const c={};for(const r of _.keys(t)){const t=`${l}${r}`,o=e[t];c[a?t:r]=o}return c}},
function _(l,t,e,i,s){i();const o=l(1),a=l(47),r=o.__importStar(l(48)),c=l(22);class _ extends a.VisualProperties{get doit(){const l=this.fill_color.get_value(),t=this.fill_alpha.get_value();return!(null==l||0==t)}set_value(l){const t=this.fill_color.get_value(),e=this.fill_alpha.get_value();l.fillStyle=c.color2css(t,e)}}e.Fill=_,_.__name__="Fill";class n extends a.VisualUniforms{get doit(){const l=this.fill_color.value,t=this.fill_alpha.value;return!(0==l||0==t)}set_value(l){const t=this.fill_color.value,e=this.fill_alpha.value;l.fillStyle=c.color2css(t,e)}}e.FillScalar=n,n.__name__="FillScalar";class p extends a.VisualUniforms{get doit(){const{fill_color:l}=this;if(l.is_Scalar()&&0==l.value)return!1;const{fill_alpha:t}=this;return!t.is_Scalar()||0!=t.value}set_vectorize(l,t){const e=this.fill_color.get(t),i=this.fill_alpha.get(t);l.fillStyle=c.color2css(e,i)}}e.FillVector=p,p.__name__="FillVector",_.prototype.type="fill",_.prototype.attrs=Object.keys(r.Fill),n.prototype.type="fill",n.prototype.attrs=Object.keys(r.FillScalar),p.prototype.type="fill",p.prototype.attrs=Object.keys(r.FillVector)},
function _(t,e,s,l,a){l();const o=t(1),_=t(47),i=o.__importStar(t(48)),n=t(22);class x extends _.VisualProperties{get doit(){const t=this.text_color.get_value(),e=this.text_alpha.get_value();return!(null==t||0==e)}set_value(t){const e=this.text_color.get_value(),s=this.text_alpha.get_value();t.fillStyle=n.color2css(e,s),t.font=this.font_value(),t.textAlign=this.text_align.get_value(),t.textBaseline=this.text_baseline.get_value()}font_value(){return`${this.text_font_style.get_value()} ${this.text_font_size.get_value()} ${this.text_font.get_value()}`}}s.Text=x,x.__name__="Text";class r extends _.VisualUniforms{get doit(){const t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)}set_value(t){const e=this.text_color.value,s=this.text_alpha.value,l=this.font_value(),a=this.text_align.value,o=this.text_baseline.value;t.fillStyle=n.color2css(e,s),t.font=l,t.textAlign=a,t.textBaseline=o}font_value(){return`${this.text_font_style.value} ${this.text_font_size.value} ${this.text_font.value}`}}s.TextScalar=r,r.__name__="TextScalar";class u extends _.VisualUniforms{get doit(){const{text_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{text_alpha:e}=this;return!e.is_Scalar()||0!=e.value}set_vectorize(t,e){const s=this.text_color.get(e),l=this.text_alpha.get(e),a=this.font_value(e),o=this.text_align.get(e),_=this.text_baseline.get(e);t.fillStyle=n.color2css(s,l),t.font=a,t.textAlign=o,t.textBaseline=_}font_value(t){return`${this.text_font_style.get(t)} ${this.text_font_size.get(t)} ${this.text_font.get(t)}`}}s.TextVector=u,u.__name__="TextVector",x.prototype.type="text",x.prototype.attrs=Object.keys(i.Text),r.prototype.type="text",r.prototype.attrs=Object.keys(i.TextScalar),u.prototype.type="text",u.prototype.attrs=Object.keys(i.TextVector)},
function _(t,e,a,h,r){h();const i=t(1),s=t(47),c=t(52),n=i.__importStar(t(18)),_=i.__importStar(t(48));class l extends s.VisualProperties{constructor(){super(...arguments),this._update_iteration=0}update(){if(this._update_iteration++,this._hatch_image=null,!this.doit)return;const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_scale.get_value(),h=this.hatch_pattern.get_value(),r=this.hatch_weight.get_value(),i=t=>{this._hatch_image=t},s=this.hatch_extra.get_value()[h];if(null!=s){const h=s.get_pattern(t,e,a,r);if(h instanceof Promise){const{_update_iteration:t}=this;h.then((e=>{this._update_iteration==t&&(i(e),this.obj.request_render())}))}else i(h)}else{const s=this.obj.canvas.create_layer(),n=c.get_pattern(s,h,t,e,a,r);i(n)}}get doit(){const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_pattern.get_value();return!(null==t||0==e||" "==a||"blank"==a||null==a)}set_value(t){const e=this.pattern(t);t.fillStyle=null!=e?e:"transparent"}pattern(t){const e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.get_value(),e=this.hatch_extra.get_value()[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.Hatch=l,l.__name__="Hatch";class o extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(null==t||0==e||" "==a||"blank"==a||null==a)}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new n.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=this.hatch_color.value,a=this.hatch_alpha.value,h=this.hatch_scale.value,r=this.hatch_pattern.value,i=this.hatch_weight.value,s=e=>{this._hatch_image=new n.UniformScalar(e,t)},_=this.hatch_extra.value[r];if(null!=_){const t=_.get_pattern(e,a,h,i);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(s(t),this.obj.request_render())}))}else s(t)}else{const t=this.obj.canvas.create_layer(),n=c.get_pattern(t,r,e,a,h,i);s(n)}}get doit(){return this._static_doit}set_value(t){var e;t.fillStyle=null!==(e=this.pattern(t))&&void 0!==e?e:"transparent"}pattern(t){const e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.value,e=this.hatch_extra.value[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.HatchScalar=o,o.__name__="HatchScalar";class u extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const{hatch_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{hatch_alpha:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{hatch_pattern:a}=this;if(a.is_Scalar()){const t=a.value;if(" "==t||"blank"==t||null==t)return!1}return!0}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new n.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=(t,e,a,h,r,i)=>{const s=this.hatch_extra.value[t];if(null!=s){const t=s.get_pattern(e,a,h,r);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(i(t),this.obj.request_render())}))}else i(t)}else{const s=this.obj.canvas.create_layer(),n=c.get_pattern(s,t,e,a,h,r);i(n)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){const a=this.hatch_color.value,h=this.hatch_alpha.value,r=this.hatch_scale.value;e(this.hatch_pattern.value,a,h,r,this.hatch_weight.value,(e=>{this._hatch_image=new n.UniformScalar(e,t)}))}else{const a=new Array(t);a.fill(null),this._hatch_image=new n.UniformVector(a);for(let h=0;h<t;h++){const t=this.hatch_color.get(h),r=this.hatch_alpha.get(h),i=this.hatch_scale.get(h);e(this.hatch_pattern.get(h),t,r,i,this.hatch_weight.get(h),(t=>{a[h]=t}))}}}get doit(){return this._static_doit}set_vectorize(t,e){var a;t.fillStyle=null!==(a=this.pattern(t,e))&&void 0!==a?a:"transparent"}pattern(t,e){const a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))}repetition(t){const e=this.hatch_pattern.get(t),a=this.hatch_extra.value[e];if(null==a)return"repeat";switch(a.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.HatchVector=u,u.__name__="HatchVector",l.prototype.type="hatch",l.prototype.attrs=Object.keys(_.Hatch),o.prototype.type="hatch",o.prototype.attrs=Object.keys(_.HatchScalar),u.prototype.type="hatch",u.prototype.attrs=Object.keys(_.HatchVector)},
function _(e,o,a,s,r){s();const i=e(22);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function n(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function t(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"},a.get_pattern=function(e,o,s,r,c,k){return e.resize(c,c),e.prepare(),function(e,o,s,r,c,k){var _;const T=c,v=T/2,h=v/2,d=i.color2css(s,r);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=k,null!==(_=a.hatch_aliases[o])&&void 0!==_?_:o){case"blank":break;case"dot":e.arc(v,v,v/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(v,v,v/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,T,v);break;case"vertical_line":n(e,T,v);break;case"cross":l(e,T,v),n(e,T,v);break;case"horizontal_dash":l(e,v,v);break;case"vertical_dash":n(e,v,v);break;case"spiral":{const o=T/30;e.moveTo(v,v);for(let a=0;a<360;a++){const s=.1*a,r=v+o*s*Math.cos(s),i=v+o*s*Math.sin(s);e.lineTo(r,i)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-h,T),e.lineTo(h+.5,0),e.stroke(),e.moveTo(h+.5,T),e.lineTo(3*h+.5,0),e.stroke(),e.moveTo(3*h+.5,T),e.lineTo(5*h+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(h+.5,T),e.lineTo(.5-h,0),e.stroke(),e.moveTo(3*h+.5,T),e.lineTo(h+.5,0),e.stroke(),e.moveTo(5*h+.5,T),e.lineTo(3*h+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":t(e,T);break;case"right_diagonal_dash":e.moveTo(h+.5,3*h+.5),e.lineTo(3*h+.5,h+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(h+.5,h+.5),e.lineTo(3*h+.5,3*h+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,h),e.lineTo(v,3*h),e.lineTo(T,h),e.stroke();break;case"vertical_wave":e.moveTo(h,0),e.lineTo(3*h,v),e.lineTo(h,T),e.stroke();break;case"criss_cross":t(e,T),l(e,T,v),n(e,T,v)}}(e.ctx,o,s,r,c,k),e.canvas}},
function _(e,t,s,n,c){n();const a=e(14),i=e(8),r=e(13),l=e(19);class o extends a.HasProps{constructor(e){super(e)}get is_syncable(){return this.syncable}static init_Model(){this.define((({Any:e,Unknown:t,Boolean:s,String:n,Array:c,Dict:a,Nullable:i})=>({tags:[c(t),[]],name:[i(n),null],js_property_callbacks:[a(c(e)),{}],js_event_callbacks:[a(c(e)),{}],subscribed_events:[c(n),[]],syncable:[s,!0]})))}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(()=>this._update_property_callbacks())),this.connect(this.properties.js_event_callbacks.change,(()=>this._update_event_callbacks())),this.connect(this.properties.subscribed_events.change,(()=>this._update_event_callbacks()))}_process_event(e){var t;for(const s of null!==(t=this.js_event_callbacks[e.event_name])&&void 0!==t?t:[])s.execute(e);null!=this.document&&this.subscribed_events.some((t=>t==e.event_name))&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):l.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of r.entries(this.js_property_callbacks)){const n=s.map((e=>()=>e.execute(this)));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){r.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if(i.isString(e))return[...this.references()].filter((t=>t instanceof o&&t.name===e));if(e.prototype instanceof a.HasProps)return[...this.references()].filter((t=>t instanceof e));throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}}s.Model=o,o.__name__="Model",o.init_Model()},
function _(s,e,_,t,a){t();class r{constructor(s,e){this.x_scale=s,this.y_scale=e,this.x_range=this.x_scale.source_range,this.y_range=this.y_scale.source_range,this.ranges=[this.x_range,this.y_range],this.scales=[this.x_scale,this.y_scale]}map_to_screen(s,e){return[this.x_scale.v_compute(s),this.y_scale.v_compute(e)]}map_from_screen(s,e){return[this.x_scale.v_invert(s),this.y_scale.v_invert(e)]}}_.CoordinateTransform=r,r.__name__="CoordinateTransform"},
function _(t,e,s,a,i){a();const n=t(1),_=t(56),r=t(133),o=t(48),l=t(20),d=t(24),h=t(122),c=n.__importStar(t(18)),u=t(10);class v extends _.DataAnnotationView{async lazy_initialize(){await super.lazy_initialize();const{start:t,end:e}=this.model;null!=t&&(this.start=await h.build_view(t,{parent:this})),null!=e&&(this.end=await h.build_view(e,{parent:this}))}set_data(t){var e,s;super.set_data(t),null===(e=this.start)||void 0===e||e.set_data(t),null===(s=this.end)||void 0===s||s.set_data(t)}remove(){var t,e;null===(t=this.start)||void 0===t||t.remove(),null===(e=this.end)||void 0===e||e.remove(),super.remove()}map_data(){const{frame:t}=this.plot_view;"data"==this.model.start_units?(this._sx_start=this.coordinates.x_scale.v_compute(this._x_start),this._sy_start=this.coordinates.y_scale.v_compute(this._y_start)):(this._sx_start=t.bbox.xview.v_compute(this._x_start),this._sy_start=t.bbox.yview.v_compute(this._y_start)),"data"==this.model.end_units?(this._sx_end=this.coordinates.x_scale.v_compute(this._x_end),this._sy_end=this.coordinates.y_scale.v_compute(this._y_end)):(this._sx_end=t.bbox.xview.v_compute(this._x_end),this._sy_end=t.bbox.yview.v_compute(this._y_end));const{_sx_start:e,_sy_start:s,_sx_end:a,_sy_end:i}=this,n=e.length,_=this._angles=new d.ScreenArray(n);for(let t=0;t<n;t++)_[t]=Math.PI/2+u.atan2([e[t],s[t]],[a[t],i[t]])}paint(t){const{start:e,end:s}=this,{_sx_start:a,_sy_start:i,_sx_end:n,_sy_end:_,_angles:r}=this,{x:o,y:l,width:d,height:h}=this.plot_view.frame.bbox;for(let c=0,u=a.length;c<u;c++)null!=s&&(t.save(),t.translate(n[c],_[c]),t.rotate(r[c]),s.render(t,c),t.restore()),null!=e&&(t.save(),t.translate(a[c],i[c]),t.rotate(r[c]+Math.PI),e.render(t,c),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(o,l,d,h),null!=s&&(t.save(),t.translate(n[c],_[c]),t.rotate(r[c]),s.clip(t,c),t.restore()),null!=e&&(t.save(),t.translate(a[c],i[c]),t.rotate(r[c]+Math.PI),e.clip(t,c),t.restore()),t.closePath(),t.clip()),this.visuals.line.set_vectorize(t,c),t.beginPath(),t.moveTo(a[c],i[c]),t.lineTo(n[c],_[c]),t.stroke(),t.restore())}}s.ArrowView=v,v.__name__="ArrowView";class p extends _.DataAnnotation{constructor(t){super(t)}static init_Arrow(){this.prototype.default_view=v,this.mixins(o.LineVector),this.define((({Ref:t,Nullable:e})=>({x_start:[c.XCoordinateSpec,{field:"x_start"}],y_start:[c.YCoordinateSpec,{field:"y_start"}],start_units:[l.SpatialUnits,"data"],start:[e(t(r.ArrowHead)),null],x_end:[c.XCoordinateSpec,{field:"x_end"}],y_end:[c.YCoordinateSpec,{field:"y_end"}],end_units:[l.SpatialUnits,"data"],end:[e(t(r.ArrowHead)),()=>new r.OpenHead]})))}}s.Arrow=p,p.__name__="Arrow",p.init_Arrow()},
function _(t,n,s,a,e){a();const i=t(1),o=t(40),c=t(57),_=t(130),r=t(65),l=i.__importStar(t(18));class h extends o.AnnotationView{constructor(){super(...arguments),this._initial_set_data=!1}connect_signals(){super.connect_signals();const t=()=>{this.set_data(this.model.source),this.request_render()};this.connect(this.model.change,t),this.connect(this.model.source.streaming,t),this.connect(this.model.source.patching,t),this.connect(this.model.source.change,t)}set_data(t){const n=this;for(const s of this.model)if(s instanceof l.VectorSpec||s instanceof l.ScalarSpec)if(s instanceof l.BaseCoordinateSpec){const a=s.array(t);n[`_${s.attr}`]=a}else{const a=s.uniform(t);n[`${s.attr}`]=a}this.plot_model.use_map&&(null!=n._x&&r.inplace.project_xy(n._x,n._y),null!=n._xs&&r.inplace.project_xsys(n._xs,n._ys));for(const t of this.visuals)t.update()}_render(){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this.paint(this.layer.ctx)}}s.DataAnnotationView=h,h.__name__="DataAnnotationView";class u extends o.Annotation{constructor(t){super(t)}static init_DataAnnotation(){this.define((({Ref:t})=>({source:[t(c.ColumnarDataSource),()=>new _.ColumnDataSource]})))}}s.DataAnnotation=u,u.__name__="DataAnnotation",u.init_DataAnnotation()},
function _(t,e,n,a,i){a();const s=t(58),r=t(15),l=t(19),o=t(60),c=t(8),u=t(9),h=t(13),g=t(59),d=t(129),_=t(29);class m extends s.DataSource{constructor(t){super(t)}get_array(t){let e=this.data[t];return null==e?this.data[t]=e=[]:c.isArray(e)||(this.data[t]=e=Array.from(e)),e}static init_ColumnarDataSource(){this.define((({Ref:t})=>({selection_policy:[t(d.SelectionPolicy),()=>new d.UnionRenderers]}))),this.internal((({AnyRef:t})=>({selection_manager:[t(),t=>new o.SelectionManager({source:t})],inspected:[t(),()=>new g.Selection]})))}initialize(){super.initialize(),this._select=new r.Signal0(this,"select"),this.inspect=new r.Signal(this,"inspect"),this.streaming=new r.Signal0(this,"streaming"),this.patching=new r.Signal(this,"patching")}get_column(t){const e=this.data[t];return null!=e?e:null}columns(){return h.keys(this.data)}get_length(t=!0){const e=u.uniq(h.values(this.data).map((t=>_.is_NDArray(t)?t.shape[0]:t.length)));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return l.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0}clear(){const t={};for(const e of this.columns())t[e]=new this.data[e].constructor(0);this.data=t}}n.ColumnarDataSource=m,m.__name__="ColumnarDataSource",m.init_ColumnarDataSource()},
function _(e,t,c,n,a){n();const o=e(53),i=e(59);class s extends o.Model{constructor(e){super(e)}static init_DataSource(){this.define((({Ref:e})=>({selected:[e(i.Selection),()=>new i.Selection]})))}}c.DataSource=s,s.__name__="DataSource",s.init_DataSource()},
function _(i,e,s,t,n){t();const l=i(53),c=i(9),h=i(13);class d extends l.Model{constructor(i){super(i)}get_view(){return this.view}static init_Selection(){this.define((({Int:i,Array:e,Dict:s})=>({indices:[e(i),[]],line_indices:[e(i),[]],multiline_indices:[s(e(i)),{}]}))),this.internal((({Int:i,Array:e,AnyRef:s,Struct:t,Nullable:n})=>({selected_glyphs:[e(s()),[]],view:[n(s()),null],image_indices:[e(t({index:i,dim1:i,dim2:i,flat_index:i})),[]]})))}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.view=i.view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}}clear(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.view=null,this.selected_glyphs=[]}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=c.union(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=c.intersection(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=c.difference(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}}s.Selection=d,d.__name__="Selection",d.init_Selection()},
function _(e,t,s,n,i){n();const o=e(14),c=e(59),r=e(61),l=e(123);class p extends o.HasProps{constructor(e){super(e),this.inspectors=new Map}static init_SelectionManager(){this.internal((({AnyRef:e})=>({source:[e()]})))}select(e,t,s,n="replace"){const i=[],o=[];for(const t of e)t instanceof r.GlyphRendererView?i.push(t):t instanceof l.GraphRendererView&&o.push(t);let c=!1;for(const e of o){const i=e.model.selection_policy.hit_test(t,e);c=c||e.model.selection_policy.do_selection(i,e.model,s,n)}if(i.length>0){const e=this.source.selection_policy.hit_test(t,i);c=c||this.source.selection_policy.do_selection(e,this.source,s,n)}return c}inspect(e,t){let s=!1;if(e instanceof r.GlyphRendererView){const n=e.hit_test(t);if(null!=n){s=!n.is_empty();const i=this.get_or_create_inspector(e.model);i.update(n,!0,"replace"),this.source.setv({inspected:i},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(e instanceof l.GraphRendererView){const n=e.model.inspection_policy.hit_test(t,e);s=s||e.model.inspection_policy.do_inspection(n,t,e,!1,"replace")}return s}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new c.Selection,this.inspectors.set(e,t)),t}}s.SelectionManager=p,p.__name__="SelectionManager",p.init_SelectionManager()},
function _(e,t,i,s,l){s();const h=e(62),n=e(63),o=e(116),a=e(117),c=e(119),d=e(98),_=e(57),r=e(120),p=e(24),g=e(12),u=e(9),y=e(13),m=e(122),v=e(104),f={fill:{},line:{}},w={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},b={fill:{fill_alpha:.2},line:{}};class V extends h.DataRendererView{get glyph_view(){return this.glyph}async lazy_initialize(){var e,t;await super.lazy_initialize();const i=this.model.glyph;this.glyph=await this.build_glyph_view(i);const s="fill"in this.glyph.visuals,l="line"in this.glyph.visuals,h=Object.assign({},i.attributes);function n(e){const t=y.clone(h);return s&&y.extend(t,e.fill),l&&y.extend(t,e.line),new i.constructor(t)}delete h.id;let{selection_glyph:o}=this.model;null==o?o=n({fill:{},line:{}}):"auto"==o&&(o=n(f)),this.selection_glyph=await this.build_glyph_view(o);let{nonselection_glyph:a}=this.model;null==a?a=n({fill:{},line:{}}):"auto"==a&&(a=n(b)),this.nonselection_glyph=await this.build_glyph_view(a);const{hover_glyph:c}=this.model;null!=c&&(this.hover_glyph=await this.build_glyph_view(c));const{muted_glyph:d}=this.model;null!=d&&(this.muted_glyph=await this.build_glyph_view(d));const _=n(w);this.decimated_glyph=await this.build_glyph_view(_),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),null===(e=this.hover_glyph)||void 0===e||e.set_base(this.glyph),null===(t=this.muted_glyph)||void 0===t||t.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),this.set_data()}async build_glyph_view(e){return m.build_view(e,{parent:this})}remove(){var e,t;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(e=this.hover_glyph)||void 0===e||e.remove(),null===(t=this.muted_glyph)||void 0===t||t.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals();const e=()=>this.request_render(),t=()=>this.update_data();this.connect(this.model.change,e),this.connect(this.glyph.model.change,t),this.connect(this.selection_glyph.model.change,t),this.connect(this.nonselection_glyph.model.change,t),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,t),null!=this.muted_glyph&&this.connect(this.muted_glyph.model.change,t),this.connect(this.decimated_glyph.model.change,t),this.connect(this.model.data_source.change,t),this.connect(this.model.data_source.streaming,t),this.connect(this.model.data_source.patching,(e=>this.update_data(e))),this.connect(this.model.data_source.selected.change,e),this.connect(this.model.data_source._select,e),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,e),this.connect(this.model.properties.view.change,t),this.connect(this.model.view.properties.indices.change,t),this.connect(this.model.view.properties.masked.change,(()=>this.set_visuals())),this.connect(this.model.properties.visible.change,(()=>this.plot_view.invalidate_dataranges=!0));const{x_ranges:i,y_ranges:s}=this.plot_view.frame;for(const[,e]of i)e instanceof v.FactorRange&&this.connect(e.change,t);for(const[,e]of s)e instanceof v.FactorRange&&this.connect(e.change,t);const{transformchange:l,exprchange:h}=this.model.glyph;this.connect(l,t),this.connect(h,t)}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}update_data(e){this.set_data(e),this.request_render()}set_data(e){const t=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:i}=this;this.glyph.set_data(t,i,e),this.set_visuals(),this._update_masked_indices();const{lod_factor:s}=this.plot_model,l=this.all_indices.count;this.decimated=new p.Indices(l);for(let e=0;e<l;e+=s)this.decimated.set(e);this.plot_view.invalidate_dataranges=!0}set_visuals(){var e,t,i,s;const l=this.model.data_source,{all_indices:h}=this;this.glyph.set_visuals(l,h),this.decimated_glyph.set_visuals(l,h),null===(e=this.selection_glyph)||void 0===e||e.set_visuals(l,h),null===(t=this.nonselection_glyph)||void 0===t||t.set_visuals(l,h),null===(i=this.hover_glyph)||void 0===i||i.set_visuals(l,h),null===(s=this.muted_glyph)||void 0===s||s.set_visuals(l,h)}get has_webgl(){return this.glyph.has_webgl}_render(){const e=this.has_webgl;this.glyph.map_data();const t=[...this.all_indices];let i=[...this._update_masked_indices()];const{ctx:s}=this.layer;s.save();const{selected:l}=this.model.data_source;let h;h=!l||l.is_empty()?[]:this.glyph instanceof n.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(i):l.indices;const{inspected:d}=this.model.data_source,_=new Set((()=>!d||d.is_empty()?[]:d.selected_glyph?this.model.view.convert_indices_from_subset(i):d.indices.length>0?d.indices:Object.keys(d.multiline_indices).map((e=>parseInt(e))))()),r=g.filter(i,(e=>_.has(t[e]))),{lod_threshold:p}=this.plot_model;let y,m,v;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!e&&null!=p&&t.length>p?(i=[...this.decimated],y=this.decimated_glyph,m=this.decimated_glyph,v=this.selection_glyph):(y=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,m=this.nonselection_glyph,v=this.selection_glyph),null!=this.hover_glyph&&r.length&&(i=u.difference(i,r)),h.length){const e={};for(const t of h)e[t]=!0;const l=new Array,o=new Array;if(this.glyph instanceof n.LineView)for(const i of t)null!=e[i]?l.push(i):o.push(i);else for(const s of i)null!=e[t[s]]?l.push(s):o.push(s);m.render(s,o),v.render(s,l),null!=this.hover_glyph&&(this.glyph instanceof n.LineView?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(r)):this.hover_glyph.render(s,r))}else if(this.glyph instanceof n.LineView)this.hover_glyph&&r.length?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(r)):y.render(s,t);else if(this.glyph instanceof o.PatchView||this.glyph instanceof a.HAreaView||this.glyph instanceof c.VAreaView)if(0==d.selected_glyphs.length||null==this.hover_glyph)y.render(s,t);else for(const e of d.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(s,t);else y.render(s,i),this.hover_glyph&&r.length&&this.hover_glyph.render(s,r);s.restore()}draw_legend(e,t,i,s,l,h,n,o){0!=this.glyph.data_size&&(null==o&&(o=this.model.get_reference_point(h,n)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o))}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=V,V.__name__="GlyphRendererView";class x extends h.DataRenderer{constructor(e){super(e)}static init_GlyphRenderer(){this.prototype.default_view=V,this.define((({Boolean:e,Auto:t,Or:i,Ref:s,Null:l,Nullable:h})=>({data_source:[s(_.ColumnarDataSource)],view:[s(r.CDSView),e=>new r.CDSView({source:e.data_source})],glyph:[s(d.Glyph)],hover_glyph:[h(s(d.Glyph)),null],nonselection_glyph:[i(s(d.Glyph),t,l),"auto"],selection_glyph:[i(s(d.Glyph),t,l),"auto"],muted_glyph:[h(s(d.Glyph)),null],muted:[e,!1]})))}initialize(){super.initialize(),this.view.source!=this.data_source&&(this.view.source=this.data_source,this.view.compute_indices())}get_reference_point(e,t){let i=0;if(null!=e){const s=this.data_source.get_column(e);if(null!=s)if(null==this.view){const e=g.indexOf(s,t);-1!=e&&(i=e)}else for(const[e,l]of Object.entries(this.view.indices_map))if(s[parseInt(e)]==t){i=l;break}}return i}get_selection_manager(){return this.data_source.selection_manager}}i.GlyphRenderer=x,x.__name__="GlyphRenderer",x.init_GlyphRenderer()},
function _(e,r,t,a,n){a();const s=e(41);class i extends s.RendererView{get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}}t.DataRendererView=i,i.__name__="DataRendererView";class _ extends s.Renderer{constructor(e){super(e)}static init_DataRenderer(){this.override({level:"glyph"})}get selection_manager(){return this.get_selection_manager()}}t.DataRenderer=_,_.__name__="DataRenderer",_.init_DataRenderer()},
function _(e,i,t,s,n){s();const l=e(1),_=e(64),r=e(106),o=e(108),h=l.__importStar(e(48)),a=l.__importStar(e(107)),c=e(59);class d extends _.XYGlyphView{initialize(){super.initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;null!=e&&(this.glglyph=new o.LineGL(e.gl,this))}_render(e,i,t){const{sx:s,sy:n}=null!=t?t:this;let l=!1,_=null;this.visuals.line.set_value(e);for(const t of i){const i=s[t],r=n[t];if(l){if(!isFinite(i+r)){e.stroke(),e.beginPath(),l=!1,_=t;continue}null!=_&&t-_>1&&(e.stroke(),l=!1)}l?e.lineTo(i,r):(e.beginPath(),e.moveTo(i,r),l=!0),_=t}l&&e.stroke()}_hit_point(e){const i=new c.Selection,t={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.line_width.value/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},_={x:this.sx[e+1],y:this.sy[e+1]},r=a.dist_to_segment(t,l,_);r<n&&r<s&&(s=r,i.add_to_selected_glyphs(this.model),i.view=this,i.line_indices=[e])}return i}_hit_span(e){const{sx:i,sy:t}=e,s=new c.Selection;let n,l;"v"==e.direction?(n=this.renderer.yscale.invert(t),l=this._y):(n=this.renderer.xscale.invert(i),l=this._x);for(let e=0,i=l.length-1;e<i;e++)(l[e]<=n&&n<=l[e+1]||l[e+1]<=n&&n<=l[e])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(e));return s}get_interpolation_hit(e,i){const[t,s,n,l]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return r.line_interpolation(this.renderer,i,t,s,n,l)}draw_legend_for_index(e,i,t){r.generic_line_scalar_legend(this.visuals,e,i)}}t.LineView=d,d.__name__="LineView";class u extends _.XYGlyph{constructor(e){super(e)}static init_Line(){this.prototype.default_view=d,this.mixins(h.LineScalar)}}t.Line=u,u.__name__="Line",u.init_Line()},
function _(t,e,i,s,_){s();const n=t(1),a=t(65),p=n.__importStar(t(18)),y=t(98);class c extends y.GlyphView{_project_data(){a.inplace.project_xy(this._x,this._y)}_index_data(t){const{_x:e,_y:i,data_size:s}=this;for(let _=0;_<s;_++){const s=e[_],n=i[_];isNaN(s+n)||!isFinite(s+n)?t.add_empty():t.add(s,n,s,n)}}scenterxy(t){return[this.sx[t],this.sy[t]]}}i.XYGlyphView=c,c.__name__="XYGlyphView";class d extends y.Glyph{constructor(t){super(t)}static init_XYGlyph(){this.define((({})=>({x:[p.XCoordinateSpec,{field:"x"}],y:[p.YCoordinateSpec,{field:"y"}]})))}}i.XYGlyph=d,d.__name__="XYGlyph",d.init_XYGlyph()},
function _(n,t,e,o,r){o();const c=n(1),l=c.__importDefault(n(66)),i=c.__importDefault(n(67)),u=n(24),a=new i.default("GOOGLE"),s=new i.default("WGS84"),f=l.default(s,a);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?f.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?f.inverse([n,t]):[NaN,NaN]};const _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},{min:g,max:h}=Math;function m(n,t){const o=g(n.length,t.length),r=u.infer_type(n,t),c=new r(o),l=new r(o);return e.inplace.project_xy(n,t,c,l),[c,l]}e.clip_mercator=function(n,t,e){const[o,r]=_[e];return[h(n,o),g(t,r)]},e.in_bounds=function(n,t){const[e,o]=p[t];return e<n&&n<o},function(n){function t(n,t,o,r){const c=g(n.length,t.length);o=null!=o?o:n,r=null!=r?r:t;for(let l=0;l<c;l++){const c=n[l],i=t[l],[u,a]=e.wgs84_mercator.compute(c,i);o[l]=u,r[l]=a}}n.project_xy=t,n.project_xsys=function(n,e,o,r){const c=g(n.length,e.length);o=null!=o?o:n,r=null!=r?r:e;for(let l=0;l<c;l++)t(n[l],e[l],o[l],r[l])}}(e.inplace||(e.inplace={})),e.project_xy=m,e.project_xsys=function(n,t){const e=g(n.length,t.length),o=new Array(e),r=new Array(e);for(let c=0;c<e;c++){const[e,l]=m(n[c],t[c]);o[c]=e,r[c]=l}return[o,r]}},
function _(e,n,t,r,o){r();const a=e(1),i=a.__importDefault(e(67)),c=a.__importDefault(e(92));var u=i.default("WGS84");function f(e,n,t){var r,o,a;return Array.isArray(t)?(r=c.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=c.default(e,n,t),2===(a=Object.keys(t)).length||a.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:i.default(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t){return f(e,n,t)},inverse:function(t){return f(n,e,t)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();const u=t(1),l=u.__importDefault(t(68)),o=u.__importDefault(t(79)),r=u.__importDefault(t(80)),f=t(88),p=u.__importDefault(t(90)),d=u.__importDefault(t(91)),m=u.__importDefault(t(75));function n(t,e){if(!(this instanceof n))return new n(t);e=e||function(t){if(t)throw t};var a=l.default(t);if("object"==typeof a){var s=n.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=m.default(p.default,a.datumCode);i&&(a.datum_params=i.towgs84?i.towgs84.split(","):null,a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var u=f.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),r=f.eccentricity(u.a,u.b,u.rf,a.R_A),h=a.datum||d.default(a.datumCode,a.datum_params,u.a,u.b,r.es,r.ep2);o.default(this,a),o.default(this,s),this.a=u.a,this.b=u.b,this.rf=u.rf,this.sphere=u.sphere,this.es=r.es,this.e=r.e,this.ep2=r.ep2,this.datum=h,this.init(),e(null,this)}else e(t)}else e(t)}n.projections=r.default,n.projections.start(),a.default=n},
function _(t,r,n,u,e){u();const f=t(1),i=f.__importDefault(t(69)),a=f.__importDefault(t(76)),o=f.__importDefault(t(71)),l=f.__importDefault(t(75));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];n.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=a.default(t);if(function(t){var r=l.default(t,"authority");if(r){var n=l.default(r,"epsg");return n&&d.indexOf(n)>-1}}(r))return i.default["EPSG:3857"];var n=function(t){var r=l.default(t,"extension");if(r)return l.default(r,"proj4")}(r);return n?o.default(n):r}return function(t){return"+"===t[0]}(t)?o.default(t):void 0}},
function _(t,r,i,e,n){e();const f=t(1),a=f.__importDefault(t(70)),l=f.__importDefault(t(71)),u=f.__importDefault(t(76));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=l.default(arguments[1]):o[t]=u.default(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}a.default(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();const e=t(1),r=t(72),i=e.__importDefault(t(73)),f=e.__importDefault(t(74)),l=e.__importDefault(t(75));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=l.default(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=l.default(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(P,A,_,D,I){D(),_.PJD_3PARAM=1,_.PJD_7PARAM=2,_.PJD_WGS84=4,_.PJD_NODATUM=5,_.SEC_TO_RAD=484813681109536e-20,_.HALF_PI=Math.PI/2,_.SIXTH=.16666666666666666,_.RA4=.04722222222222222,_.RA6=.022156084656084655,_.EPSLN=1e-10,_.D2R=.017453292519943295,_.R2D=57.29577951308232,_.FORTPI=Math.PI/4,_.TWO_PI=2*Math.PI,_.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,t,a,o,d){o();const r=e(1);const n=r.__importDefault(e(77)),l=e(78);function i(e){return.017453292519943295*e}a.default=function(e){var t=n.default(e),a=t.shift(),o=t.shift();t.unshift(["name",o]),t.unshift(["type",a]);var d={};return l.sExpr(t,d),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var t="",a=0,o=e.AXIS.length;a<o;++a){var d=e.AXIS[a][0].toLowerCase();-1!==d.indexOf("north")?t+="n":-1!==d.indexOf("south")?t+="s":-1!==d.indexOf("east")?t+="e":-1!==d.indexOf("west")&&(t+="w")}2===t.length&&(t+="u"),3===t.length&&(e.axis=t)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function n(t){return t*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",n],["y0","false_northing",n],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(t){return a=e,d=(o=t)[0],r=o[1],void(!(d in a)&&r in a&&(a[d]=a[r],3===o.length&&(a[d]=o[2](a[d]))));var a,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(d),d}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,o,a,e,n){e();const r=t(1),f=r.__importDefault(t(81)),u=r.__importDefault(t(87));var i=[f.default,u.default],c={},d=[];function s(t,o){var a=d.length;return t.names?(d[a]=t,t.names.forEach((function(t){c[t.toLowerCase()]=a})),this):(console.log(o),!0)}function l(t){if(!t)return!1;var o=t.toLowerCase();return void 0!==c[o]&&d[c[o]]?d[c[o]]:void 0}function v(){i.forEach(s)}a.add=s,a.get=l,a.start=v,a.default={start:v,add:s,get:l}},
function _(t,i,s,h,a){h();const e=t(1),r=e.__importDefault(t(82)),n=e.__importDefault(t(83)),l=e.__importDefault(t(85)),u=e.__importDefault(t(86)),o=t(72);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=r.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=l.default(this.e,a,e);i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=u.default(this.e,e)))return null}return i=n.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,n,u,a,f){a();const e=t(1),o=t(72),_=e.__importDefault(t(84));u.default=function(t){return Math.abs(t)<=o.SPI?t:t-_.default(t)*o.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,n,a,o,u){o();const c=t(72);a.default=function(t,n,a){var o=t*a,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(c.HALF_PI-n))/o}},
function _(t,a,n,r,f){r();const h=t(72);n.default=function(t,a){for(var n,r,f=.5*t,o=h.HALF_PI-2*Math.atan(a),u=0;u<=15;u++)if(n=t*Math.sin(o),o+=r=h.HALF_PI-2*Math.atan(a*Math.pow((1-n)/(1+n),f))-o,Math.abs(r)<=1e-10)return o;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(t,r,e,a,n){a();const f=t(1),i=t(72),u=f.__importStar(t(89)),c=f.__importDefault(t(75));e.eccentricity=function(t,r,e,a){var n=t*t,f=r*r,u=(n-f)/n,c=0;return a?(n=(t*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*t,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(n-f)/f}},e.sphere=function(t,r,e,a,n){if(!t){var f=c.default(u.default,a);f||(f=u.WGS84),t=f.a,r=f.b,e=f.rf}return e&&!r&&(r=(1-1/e)*t),(0===e||Math.abs(t-r)<i.EPSLN)&&(n=!0,r=t),{a:t,b:r,rf:e,sphere:n}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();const p=a(72);_.default=function(a,m,_,t,u,d){var r={};return r.datum_type=void 0===a||"none"===a?p.PJD_NODATUM:p.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=p.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=p.PJD_7PARAM,r.datum_params[3]*=p.SEC_TO_RAD,r.datum_params[4]*=p.SEC_TO_RAD,r.datum_params[5]*=p.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=t,r.es=u,r.ep2=d,r}},
function _(t,e,a,r,u){r();const m=t(1),_=t(72),o=m.__importDefault(t(93)),d=m.__importDefault(t(95)),f=m.__importDefault(t(67)),n=m.__importDefault(t(96)),i=m.__importDefault(t(97));a.default=function t(e,a,r){var u;if(Array.isArray(r)&&(r=n.default(r)),i.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,u=new f.default("WGS84"),r),e=u),"enu"!==e.axis&&(r=d.default(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;return e.from_greenwich&&(r.x+=e.from_greenwich),r=o.default(e.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?d.default(a,!0,r):r}},
function _(t,e,a,u,c){u();const m=t(72),o=t(94);function _(t){return t===m.PJD_3PARAM||t===m.PJD_7PARAM}a.default=function(t,e,a){return o.compareDatums(t,e)||t.datum_type===m.PJD_NODATUM||e.datum_type===m.PJD_NODATUM?a:t.es!==e.es||t.a!==e.a||_(t.datum_type)||_(e.datum_type)?(a=o.geodeticToGeocentric(a,t.es,t.a),_(t.datum_type)&&(a=o.geocentricToWgs84(a,t.datum_type,t.datum_params)),_(e.datum_type)&&(a=o.geocentricFromWgs84(a,e.datum_type,e.datum_params)),o.geocentricToGeodetic(a,e.es,e.a,e.b)):a}},
function _(a,t,r,m,s){m();const u=a(72);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===u.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==u.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,s,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-u.HALF_PI&&d>-1.001*u.HALF_PI)d=-u.HALF_PI;else if(d>u.HALF_PI&&d<1.001*u.HALF_PI)d=u.HALF_PI;else{if(d<-u.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>u.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),s=Math.sin(d),e=Math.cos(d),_=s*s,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*s}},r.geocentricToGeodetic=function(a,t,r,m){var s,_,e,n,d,i,p,P,y,z,M,o,A,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(s=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),s/r<h){if(c=0,_/r<h)return u.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=s/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=s*P+F*y-p*(1-t*y*y))),o=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(o*o>1e-24&&A<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-s)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,r,s){r(),i.default=function(e,a,i){var r,s,n,c=i.x,d=i.y,f=i.z||0,u={};for(n=0;n<3;n++)if(!a||2!==n||void 0!==i.z)switch(0===n?(r=c,s=-1!=="ew".indexOf(e.axis[n])?"x":"y"):1===n?(r=d,s=-1!=="ns".indexOf(e.axis[n])?"y":"x"):(r=f,s="z"),e.axis[n]){case"e":u[s]=r;break;case"w":u[s]=-r;break;case"n":u[s]=r;break;case"s":u[s]=-r;break;case"u":void 0!==i[s]&&(u.z=r);break;case"d":void 0!==i[s]&&(u.z=-r);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,t,s,i,n){i();const r=e(1),a=r.__importStar(e(18)),o=r.__importStar(e(99)),_=r.__importStar(e(45)),l=e(42),c=e(53),h=e(19),d=e(24),u=e(8),f=e(100),p=e(12),g=e(26),y=e(101),x=e(104),v=e(59),{abs:b,ceil:m}=Math;class w extends l.View{constructor(){super(...arguments),this._index=null,this._data_size=null,this._nohit_warned=new Set}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}get index(){const{_index:e}=this;if(null!=e)return e;throw new Error(`${this}.index_data() wasn't called`)}get data_size(){const{_data_size:e}=this;if(null!=e)return e;throw new Error(`${this}.set_data() wasn't called`)}initialize(){super.initialize(),this.visuals=new _.Visuals(this)}request_render(){this.parent.request_render()}get canvas(){return this.renderer.parent.canvas_view}render(e,t,s){var i;null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,null!==(i=this.base)&&void 0!==i?i:this),this.renderer.needs_webgl_blit)||(e.beginPath(),this._render(e,t,null!=s?s:this.base))}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(e){return e}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const{x0:e,x1:t}=this.index.bounds(o.positive_x()),{y0:s,y1:i}=this.index.bounds(o.positive_y());return this._bounds({x0:e,y0:s,x1:t,y1:i})}get_anchor_point(e,t,[s,i]){switch(e){case"center":case"center_center":{const[e,n]=this.scenterxy(t,s,i);return{x:e,y:n}}default:return null}}scenterx(e,t,s){return this.scenterxy(e,t,s)[0]}scentery(e,t,s){return this.scenterxy(e,t,s)[1]}sdist(e,t,s,i="edge",n=!1){const r=t.length,a=new d.ScreenArray(r),o=e.s_compute;if("center"==i)for(let e=0;e<r;e++){const i=t[e],n=s.get(e)/2,r=o(i-n),_=o(i+n);a[e]=b(_-r)}else for(let e=0;e<r;e++){const i=t[e],n=o(i),r=o(i+s.get(e));a[e]=b(r-n)}return n&&p.inplace_map(a,(e=>m(e))),a}draw_legend_for_index(e,t,s){}hit_test(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(h.logger.debug(`'${e.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(e.type)),null}_hit_rect_against_index(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[r,a]=this.renderer.coordinates.x_scale.r_invert(t,s),[o,_]=this.renderer.coordinates.y_scale.r_invert(i,n),l=[...this.index.indices({x0:r,x1:a,y0:o,y1:_})];return new v.Selection({indices:l})}_project_data(){}*_iter_visuals(){for(const e of this.visuals)for(const t of e)(t instanceof a.VectorSpec||t instanceof a.ScalarSpec)&&(yield t)}set_base(e){e!=this&&e instanceof this.constructor&&(this.base=e)}_configure(e,t){Object.defineProperty(this,u.isString(e)?e:e.attr,Object.assign({configurable:!0,enumerable:!0},t))}set_visuals(e,t){var s;for(const s of this._iter_visuals()){const{base:i}=this;if(null!=i){const e=i.model.properties[s.attr];if(null!=e&&g.is_equal(s.get_value(),e.get_value())){this._configure(s,{get:()=>i[`${s.attr}`]});continue}}const n=s.uniform(e).select(t);this._configure(s,{value:n})}for(const e of this.visuals)e.update();null===(s=this.glglyph)||void 0===s||s.set_visuals_changed()}set_data(e,t,s){var i;const{x_range:n,y_range:r}=this.renderer.coordinates,o=new Set(this._iter_visuals());this._data_size=t.count;for(const s of this.model)if((s instanceof a.VectorSpec||s instanceof a.ScalarSpec)&&!o.has(s))if(s instanceof a.BaseCoordinateSpec){const i=s.array(e);let o=t.select(i);const _="x"==s.dimension?n:r;if(_ instanceof x.FactorRange)if(s instanceof a.CoordinateSpec)o=_.v_synthetic(o);else if(s instanceof a.CoordinateSeqSpec)for(let e=0;e<o.length;e++)o[e]=_.v_synthetic(o[e]);let l;l=s instanceof a.CoordinateSeqSpec?f.RaggedArray.from(o,Float64Array):o,this._configure(`_${s.attr}`,{value:l})}else{const i=s.uniform(e).select(t);if(this._configure(s,{value:i}),s instanceof a.DistanceSpec){const e=i.is_Scalar()?i.value:p.max(i.array);this._configure(`max_${s.attr}`,{value:e})}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(null!=s?s:null),null===(i=this.glglyph)||void 0===i||i.set_data_changed(),this.index_data()}_set_data(e){}get _index_size(){return this.data_size}index_data(){const e=new y.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e}mask_data(){return null==this._mask_data?d.Indices.all_set(this.data_size):this._mask_data()}map_data(){var e;const t=this,{x_scale:s,y_scale:i}=this.renderer.coordinates;for(const e of this.model)if(e instanceof a.BaseCoordinateSpec){const n="x"==e.dimension?s:i;let r=t[`_${e.attr}`];if(r instanceof f.RaggedArray){const e=n.v_compute(r.array);r=new f.RaggedArray(r.offsets,e)}else r=n.v_compute(r);this[`s${e.attr}`]=r}this._map_data(),null===(e=this.glglyph)||void 0===e||e.set_data_changed()}_map_data(){}}s.GlyphView=w,w.__name__="GlyphView";class S extends c.Model{constructor(e){super(e)}}s.Glyph=S,S.__name__="Glyph"},
function _(t,i,e,h,s){h();const r=t(24),n=t(26),{min:x,max:y}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:x(t.x0,i.x0),x1:y(t.x1,i.x1),y0:x(t.y0,i.y0),y1:y(t.y1,i.y1)}};class o{constructor(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:s}=t;if(!(i<=h&&e<=s))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${s}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=s}else if("x"in t){const{x:i,y:e,width:h,height:s}=t;if(!(h>=0&&s>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${s}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+s}else{let i,e,h,s;if("width"in t)if("left"in t)i=t.left,e=i+t.width;else if("right"in t)e=t.right,i=e-t.width;else{const h=t.width/2;i=t.hcenter-h,e=t.hcenter+h}else i=t.left,e=t.right;if("height"in t)if("top"in t)h=t.top,s=h+t.height;else if("bottom"in t)s=t.bottom,h=s-t.height;else{const i=t.height/2;h=t.vcenter-i,s=t.vcenter+i}else h=t.top,s=t.bottom;if(!(i<=e&&h<=s))throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${e}, bottom: ${s}}`);this.x0=i,this.y0=h,this.x1=e,this.y1=s}}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}[n.equals](t,i){return i.eq(this.x0,t.x0)&&i.eq(this.y0,t.y0)&&i.eq(this.x1,t.x1)&&i.eq(this.y1,t.y1)}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get size(){return{width:this.width,height:this.height}}get rect(){const{x0:t,y0:i,x1:e,y1:h}=this;return{p0:{x:t,y:i},p1:{x:e,y:i},p2:{x:e,y:h},p3:{x:t,y:h}}}get box(){const{x:t,y:i,width:e,height:h}=this;return{x:t,y:i,width:e,height:h}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}get area(){return this.width*this.height}relative(){const{width:t,height:i}=this;return new o({x:0,y:0,width:t,height:i})}translate(t,i){const{x:e,y:h,width:s,height:r}=this;return new o({x:t+e,y:i+h,width:s,height:r})}relativize(t,i){return[t-this.x,i-this.y]}contains(t,i){return this.x0<=t&&t<=this.x1&&this.y0<=i&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}grow_by(t){return new o({left:this.left-t,right:this.right+t,top:this.top-t,bottom:this.bottom+t})}shrink_by(t){return new o({left:this.left+t,right:this.right-t,top:this.top+t,bottom:this.bottom-t})}union(t){return new o({x0:x(this.x0,t.x0),y0:x(this.y0,t.y0),x1:y(this.x1,t.x1),y1:y(this.y1,t.y1)})}intersection(t){return this.intersects(t)?new o({x0:y(this.x0,t.x0),y0:y(this.y0,t.y0),x1:x(this.x1,t.x1),y1:x(this.y1,t.y1)}):null}intersects(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new r.ScreenArray(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new r.ScreenArray(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=o,o.__name__="BBox"},
function _(t,s,r,e,n){e();const a=t(26),o=t(11);class h{constructor(t,s){this.offsets=t,this.array=s}[a.equals](t,s){return s.arrays(this.offsets,t.offsets)&&s.arrays(this.array,t.array)}get length(){return this.offsets.length}clone(){return new h(this.offsets.slice(),this.array.slice())}static from(t,s){const r=t.length;let e=0;const n=(()=>{const s=new Uint32Array(r);for(let n=0;n<r;n++){const r=t[n].length;s[n]=e,e+=r}return e<256?new Uint8Array(s):e<65536?new Uint16Array(s):s})(),a=new s(e);for(let s=0;s<r;s++)a.set(t[s],n[s]);return new h(n,a)}*[Symbol.iterator](){const{offsets:t,length:s}=this;for(let r=0;r<s;r++)yield this.array.subarray(t[r],t[r+1])}_check_bounds(t){o.assert(0<=t&&t<this.length,`Out of bounds: 0 <= ${t} < ${this.length}`)}get(t){this._check_bounds(t);const{offsets:s}=this;return this.array.subarray(s[t],s[t+1])}set(t,s){this._check_bounds(t),this.array.set(s,this.offsets[t])}}r.RaggedArray=h,h.__name__="RaggedArray",h[Symbol.toStringTag]="RaggedArray"},
function _(n,i,t,e,s){e();const o=n(1).__importDefault(n(102)),d=n(24),x=n(99);function h(n,i){let t=0,e=i.length-1;for(;t<e;){const s=t+e>>1;i[s]>n?e=s:t=s+1}return i[t]}class r extends o.default{search_indices(n,i,t,e){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let s=this._boxes.length-4;const o=[],x=new d.Indices(this.numItems);for(;void 0!==s;){const d=Math.min(s+4*this.nodeSize,h(s,this._levelBounds));for(let h=s;h<d;h+=4){const d=0|this._indices[h>>2];t<this._boxes[h+0]||(e<this._boxes[h+1]||n>this._boxes[h+2]||i>this._boxes[h+3]||(s<4*this.numItems?x.set(d):o.push(d)))}s=o.pop()}return x}}r.__name__="_FlatBush";class l{constructor(n){this.index=null,n>0&&(this.index=new r(n))}add(n,i,t,e){var s;null===(s=this.index)||void 0===s||s.add(n,i,t,e)}add_empty(){var n;null===(n=this.index)||void 0===n||n.add(1/0,1/0,-1/0,-1/0)}finish(){var n;null===(n=this.index)||void 0===n||n.finish()}_normalize(n){let{x0:i,y0:t,x1:e,y1:s}=n;return i>e&&([i,e]=[e,i]),t>s&&([t,s]=[s,t]),{x0:i,y0:t,x1:e,y1:s}}get bbox(){if(null==this.index)return x.empty();{const{minX:n,minY:i,maxX:t,maxY:e}=this.index;return{x0:n,y0:i,x1:t,y1:e}}}indices(n){if(null==this.index)return new d.Indices(0);{const{x0:i,y0:t,x1:e,y1:s}=this._normalize(n);return this.index.search_indices(i,t,e,s)}}bounds(n){const i=x.empty();for(const t of this.indices(n)){const n=this.index._boxes,e=n[4*t+0],s=n[4*t+1],o=n[4*t+2],d=n[4*t+3];o<i.x0&&(i.x0=o),e>i.x1&&(i.x1=e),d<i.y0&&(i.y0=d),s>i.y1&&(i.y1=s)}return i}}t.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,s,i,e,h){e();const n=t(1).__importDefault(t(103)),o=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class r{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[s,i]=new Uint8Array(t,0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");if(i>>4!=3)throw new Error(`Got v${i>>4} data when expected v3.`);const[e]=new Uint16Array(t,2,1),[h]=new Uint32Array(t,4,1);return new r(h,e,o[15&i],t)}constructor(t,s=16,i=Float64Array,e){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535);let h=t,r=h;this._levelBounds=[4*h];do{h=Math.ceil(h/this.nodeSize),r+=h,this._levelBounds.push(4*r)}while(1!==h);this.ArrayType=i||Float64Array,this.IndexArrayType=r<16384?Uint16Array:Uint32Array;const a=o.indexOf(this.ArrayType),_=4*r*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error(`Unexpected typed array class: ${i}.`);e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=4*r,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+r*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=s,new Uint32Array(this.data,4,1)[0]=t),this._queue=new n.default}add(t,s,i,e){const h=this._pos>>2;return this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),h}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);const t=this.maxX-this.minX,s=this.maxY-this.minY,i=new Uint32Array(this.numItems);for(let e=0;e<this.numItems;e++){let h=4*e;const n=this._boxes[h++],o=this._boxes[h++],r=this._boxes[h++],a=this._boxes[h++],_=Math.floor(65535*((n+r)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/s);i[e]=m(_,x)}x(i,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(let t=0,s=0;t<this._levelBounds.length-1;t++){const i=this._levelBounds[t];for(;s<i;){const t=s;let e=1/0,h=1/0,n=-1/0,o=-1/0;for(let t=0;t<this.nodeSize&&s<i;t++)e=Math.min(e,this._boxes[s++]),h=Math.min(h,this._boxes[s++]),n=Math.max(n,this._boxes[s++]),o=Math.max(o,this._boxes[s++]);this._indices[this._pos>>2]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=h,this._boxes[this._pos++]=n,this._boxes[this._pos++]=o}}}search(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=[],r=[];for(;void 0!==n;){const a=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let _=n;_<a;_+=4){const a=0|this._indices[_>>2];i<this._boxes[_]||(e<this._boxes[_+1]||t>this._boxes[_+2]||s>this._boxes[_+3]||(n<4*this.numItems?(void 0===h||h(a))&&r.push(a):o.push(a)))}n=o.pop()}return r}neighbors(t,s,i=1/0,e=1/0,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=this._queue,r=[],x=e*e;for(;void 0!==n;){const e=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let i=n;i<e;i+=4){const e=0|this._indices[i>>2],r=a(t,this._boxes[i],this._boxes[i+2]),_=a(s,this._boxes[i+1],this._boxes[i+3]),x=r*r+_*_;n<4*this.numItems?(void 0===h||h(e))&&o.push(-e-1,x):o.push(e,x)}for(;o.length&&o.peek()<0;){if(o.peekValue()>x)return o.clear(),r;if(r.push(-o.pop()-1),r.length===i)return o.clear(),r}n=o.pop()}return o.clear(),r}}function a(t,s,i){return t<s?s-t:t<=i?0:t-i}function _(t,s){let i=0,e=s.length-1;for(;i<e;){const h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function x(t,s,i,e,h,n){if(Math.floor(e/n)>=Math.floor(h/n))return;const o=t[e+h>>1];let r=e-1,a=h+1;for(;;){do{r++}while(t[r]<o);do{a--}while(t[a]>o);if(r>=a)break;d(t,s,i,r,a)}x(t,s,i,e,a,n),x(t,s,i,a+1,h,n)}function d(t,s,i,e,h){const n=t[e];t[e]=t[h],t[h]=n;const o=4*e,r=4*h,a=s[o],_=s[o+1],x=s[o+2],d=s[o+3];s[o]=s[r],s[o+1]=s[r+1],s[o+2]=s[r+2],s[o+3]=s[r+3],s[r]=a,s[r+1]=_,s[r+2]=x,s[r+3]=d;const m=i[e];i[e]=i[h],i[h]=m}function m(t,s){let i=t^s,e=65535^i,h=65535^(t|s),n=t&(65535^s),o=i|e>>1,r=i>>1^i,a=h>>1^e&n>>1^h,_=i&h>>1^n>>1^n;i=o,e=r,h=a,n=_,o=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&h>>2^e&n>>2,_^=e&h>>2^(i^e)&n>>2,i=o,e=r,h=a,n=_,o=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&h>>4^e&n>>4,_^=e&h>>4^(i^e)&n>>4,i=o,e=r,h=a,n=_,a^=i&h>>8^e&n>>8,_^=e&h>>8^(i^e)&n>>8,i=a^a>>1,e=_^_>>1;let x=t^s,d=e|65535^(x|i);return x=16711935&(x|x<<8),x=252645135&(x|x<<4),x=858993459&(x|x<<2),x=1431655765&(x|x<<1),d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),(d<<1|x)>>>0}i.default=r},
function _(s,t,i,h,e){h();i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(this.ids[i]=s,this.values[i]=t;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}}},
function _(t,n,e,i,s){i();const r=t(105),a=t(20),o=t(21),g=t(24),p=t(9),c=t(8),l=t(11);function u(t,n,e=0){const i=new Map;for(let s=0;s<t.length;s++){const r=t[s];if(i.has(r))throw new Error(`duplicate factor or subfactor: ${r}`);i.set(r,{value:.5+s*(1+n)+e})}return[i,(t.length-1)*n]}function h(t,n,e,i=0){var s;const r=new Map,a=new Map;for(const[n,e]of t){const t=null!==(s=a.get(n))&&void 0!==s?s:[];a.set(n,[...t,e])}let o=i,g=0;for(const[t,i]of a){const s=i.length,[a,c]=u(i,e,o);g+=c;const l=p.sum(i.map((t=>a.get(t).value)));r.set(t,{value:l/s,mapping:a}),o+=s+n+c}return[r,(a.size-1)*n+g]}function d(t,n,e,i,s=0){var r;const a=new Map,o=new Map;for(const[n,e,i]of t){const t=null!==(r=o.get(n))&&void 0!==r?r:[];o.set(n,[...t,[e,i]])}let g=s,c=0;for(const[t,s]of o){const r=s.length,[o,l]=h(s,e,i,g);c+=l;const u=p.sum(s.map((([t])=>o.get(t).value)));a.set(t,{value:u/r,mapping:o}),g+=r+n+l}return[a,(o.size-1)*n+c]}e.Factor=o.Or(o.String,o.Tuple(o.String,o.String),o.Tuple(o.String,o.String,o.String)),e.FactorSeq=o.Or(o.Array(o.String),o.Array(o.Tuple(o.String,o.String)),o.Array(o.Tuple(o.String,o.String,o.String))),e.map_one_level=u,e.map_two_levels=h,e.map_three_levels=d;class _ extends r.Range{constructor(t){super(t)}static init_FactorRange(){this.define((({Number:t})=>({factors:[e.FactorSeq,[]],factor_padding:[t,0],subgroup_padding:[t,.8],group_padding:[t,1.4],range_padding:[t,0],range_padding_units:[a.PaddingUnits,"percent"],start:[t],end:[t]}))),this.internal((({Number:t,String:n,Array:e,Tuple:i,Nullable:s})=>({levels:[t],mids:[s(e(i(n,n))),null],tops:[s(e(n)),null]})))}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,(()=>this.reset())),this.connect(this.properties.factor_padding.change,(()=>this.reset())),this.connect(this.properties.group_padding.change,(()=>this.reset())),this.connect(this.properties.subgroup_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding_units.change,(()=>this.reset()))}reset(){this._init(!1),this.change.emit()}_lookup(t){switch(t.length){case 1:{const[n]=t,e=this._mapping.get(n);return null!=e?e.value:NaN}case 2:{const[n,e]=t,i=this._mapping.get(n);if(null!=i){const t=i.mapping.get(e);if(null!=t)return t.value}return NaN}case 3:{const[n,e,i]=t,s=this._mapping.get(n);if(null!=s){const t=s.mapping.get(e);if(null!=t){const n=t.mapping.get(i);if(null!=n)return n.value}}return NaN}default:l.unreachable()}}synthetic(t){if(c.isNumber(t))return t;if(c.isString(t))return this._lookup([t]);let n=0;const e=t[t.length-1];return c.isNumber(e)&&(n=e,t=t.slice(0,-1)),this._lookup(t)+n}v_synthetic(t){const n=t.length,e=new g.ScreenArray(n);for(let i=0;i<n;i++)e[i]=this.synthetic(t[i]);return e}_init(t){const{levels:n,mapping:e,tops:i,mids:s,inside_padding:r}=(()=>{if(p.every(this.factors,c.isString)){const t=this.factors,[n,e]=u(t,this.factor_padding);return{levels:1,mapping:n,tops:null,mids:null,inside_padding:e}}if(p.every(this.factors,(t=>c.isArray(t)&&2==t.length&&c.isString(t[0])&&c.isString(t[1])))){const t=this.factors,[n,e]=h(t,this.group_padding,this.factor_padding),i=[...n.keys()];return{levels:2,mapping:n,tops:i,mids:null,inside_padding:e}}if(p.every(this.factors,(t=>c.isArray(t)&&3==t.length&&c.isString(t[0])&&c.isString(t[1])&&c.isString(t[2])))){const t=this.factors,[n,e]=d(t,this.group_padding,this.subgroup_padding,this.factor_padding),i=[...n.keys()],s=[];for(const[t,e]of n)for(const n of e.mapping.keys())s.push([t,n]);return{levels:3,mapping:n,tops:i,mids:s,inside_padding:e}}l.unreachable()})();this._mapping=e,this.tops=i,this.mids=s;let a=0,o=this.factors.length+r;if("percent"==this.range_padding_units){const t=(o-a)*this.range_padding/2;a-=t,o+=t}else a-=this.range_padding,o+=this.range_padding;this.setv({start:a,end:o,levels:n},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[a,o]},{silent:!0})}}e.FactorRange=_,_.__name__="FactorRange",_.init_FactorRange()},
function _(e,t,i,n,s){n();const a=e(53);class l extends a.Model{constructor(e){super(e),this.have_updated_interactively=!1}static init_Range(){this.define((({Number:e,Tuple:t,Or:i,Auto:n,Nullable:s})=>({bounds:[s(i(t(s(e),s(e)),n)),null],min_interval:[s(e),null],max_interval:[s(e),null]}))),this.internal((({Array:e,AnyRef:t})=>({plots:[e(t()),[]]})))}get is_reversed(){return this.start>this.end}get is_valid(){return isFinite(this.min)&&isFinite(this.max)}}i.Range=l,l.__name__="Range",l.init_Range()},
function _(e,t,i,n,l){n();const o=e(1).__importStar(e(107));function a(e,t,{x0:i,x1:n,y0:l,y1:o},a){t.save(),t.beginPath(),t.moveTo(i,(l+o)/2),t.lineTo(n,(l+o)/2),e.line.doit&&(e.line.set_vectorize(t,a),t.stroke()),t.restore()}function r(e,t,{x0:i,x1:n,y0:l,y1:o},a){var r,c;const s=.1*Math.abs(n-i),_=.1*Math.abs(o-l),v=i+s,d=n-s,h=l+_,g=o-_;t.beginPath(),t.rect(v,h,d-v,g-h),e.fill.doit&&(e.fill.set_vectorize(t,a),t.fill()),(null===(r=e.hatch)||void 0===r?void 0:r.doit)&&(e.hatch.set_vectorize(t,a),t.fill()),(null===(c=e.line)||void 0===c?void 0:c.doit)&&(e.line.set_vectorize(t,a),t.stroke())}i.generic_line_scalar_legend=function(e,t,{x0:i,x1:n,y0:l,y1:o}){t.save(),t.beginPath(),t.moveTo(i,(l+o)/2),t.lineTo(n,(l+o)/2),e.line.doit&&(e.line.set_value(t),t.stroke()),t.restore()},i.generic_line_vector_legend=a,i.generic_line_legend=a,i.generic_area_scalar_legend=function(e,t,{x0:i,x1:n,y0:l,y1:o}){var a,r;const c=.1*Math.abs(n-i),s=.1*Math.abs(o-l),_=i+c,v=n-c,d=l+s,h=o-s;t.beginPath(),t.rect(_,d,v-_,h-d),e.fill.doit&&(e.fill.set_value(t),t.fill()),(null===(a=e.hatch)||void 0===a?void 0:a.doit)&&(e.hatch.set_value(t),t.fill()),(null===(r=e.line)||void 0===r?void 0:r.doit)&&(e.line.set_value(t),t.stroke())},i.generic_area_vector_legend=r,i.generic_area_legend=r,i.line_interpolation=function(e,t,i,n,l,a){const{sx:r,sy:c}=t;let s,_,v,d;"point"==t.type?([v,d]=e.yscale.r_invert(c-1,c+1),[s,_]=e.xscale.r_invert(r-1,r+1)):"v"==t.direction?([v,d]=e.yscale.r_invert(c,c),[s,_]=[Math.min(i-1,l-1),Math.max(i+1,l+1)]):([s,_]=e.xscale.r_invert(r,r),[v,d]=[Math.min(n-1,a-1),Math.max(n+1,a+1)]);const{x:h,y:g}=o.check_2_segments_intersect(s,v,_,d,i,n,l,a);return[h,g]}},
function _(t,n,e,i,r){function s(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function o(t,n,e){const i=s(n,e);if(0==i)return s(t,n);const r=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/i;if(r<0)return s(t,n);if(r>1)return s(t,e);return s(t,{x:n.x+r*(e.x-n.x),y:n.y+r*(e.y-n.y)})}i(),e.point_in_poly=function(t,n,e,i){let r=!1,s=e[e.length-1],o=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];o<n!=_<n&&s+(n-o)/(_-o)*(c-s)<t&&(r=!r),s=c,o=_}return r},e.point_in_ellipse=function(t,n,e,i,r,s,o){return((Math.cos(e)/r)**2+(Math.sin(e)/i)**2)*(t-s)**2+2*Math.cos(e)*Math.sin(e)*((1/r)**2-(1/i)**2)*(t-s)*(n-o)+((Math.cos(e)/i)**2+(Math.sin(e)/r)**2)*(n-o)**2<=1},e.dist_2_pts=s,e.dist_to_segment_squared=o,e.dist_to_segment=function(t,n,e){return Math.sqrt(o(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,r,s,o,u){const c=(u-s)*(e-t)-(o-r)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-s,h=t-r;const l=(e-t)*_-(i-n)*h;_=((o-r)*_-(u-s)*h)/c,h=l/c;return{hit:_>0&&_<1&&h>0&&h<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(t,e,s,i,a){i();const o=t(1),n=t(109),_=t(113),r=o.__importDefault(t(114)),h=o.__importDefault(t(115)),l=t(22),g=t(46);class u{constructor(t){this._atlas=new Map,this._width=256,this._height=256,this.tex=new n.Texture2d(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._width,this._height],t.RGBA),this.tex.set_data([0,0],[this._width,this._height],new Uint8Array(4*this._width*this._height)),this.get_atlas_data([1])}get_atlas_data(t){const e=t.join("-");let s=this._atlas.get(e);if(null==s){const[i,a]=this.make_pattern(t),o=this._atlas.size;this.tex.set_data([0,o],[this._width,1],new Uint8Array(i.map((t=>t+10)))),s=[o/this._height,a],this._atlas.set(e,s)}return s}make_pattern(t){t.length>1&&t.length%2&&(t=t.concat(t));let e=0;for(const s of t)e+=s;const s=[];let i=0;for(let e=0,a=t.length+2;e<a;e+=2){const a=Math.max(1e-4,t[e%t.length]),o=Math.max(1e-4,t[(e+1)%t.length]);s.push(i,i+a),i+=a+o}const a=this._width,o=new Float32Array(4*a);for(let t=0,i=a;t<i;t++){let i,n,_;const r=e*t/(a-1);let h=0,l=1e16;for(let t=0,e=s.length;t<e;t++){const e=Math.abs(s[t]-r);e<l&&(h=t,l=e)}h%2==0?(_=r<=s[h]?1:0,n=s[h],i=s[h+1]):(_=r>s[h]?-1:0,n=s[h-1],i=s[h]),o[4*t+0]=s[h],o[4*t+1]=_,o[4*t+2]=n,o[4*t+3]=i}return[o,e]}}u.__name__="DashAtlas";const f={miter:0,round:1,bevel:2},c={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5};class d extends _.BaseGLGlyph{constructor(t,e){super(t,e),this.glyph=e,this._scale_aspect=0;const s=r.default,i=h.default;this.prog=new n.Program(t),this.prog.set_shaders(s,i),this.index_buffer=new n.IndexBuffer(t),this.vbo_position=new n.VertexBuffer(t),this.vbo_tangents=new n.VertexBuffer(t),this.vbo_segment=new n.VertexBuffer(t),this.vbo_angles=new n.VertexBuffer(t),this.vbo_texcoord=new n.VertexBuffer(t),this.dash_atlas=new u(t)}draw(t,e,s){const i=e.glglyph;if(i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),i._update_scale(1,1),this._scale_aspect=1,this.prog.set_attribute("a_position","vec2",i.vbo_position),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents),this.prog.set_attribute("a_segment","vec2",i.vbo_segment),this.prog.set_attribute("a_angles","vec2",i.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord),this.prog.set_uniform("u_length","float",[i.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_scale_aspect","vec2",[1,1]),this.prog.set_uniform("u_scale_length","float",[Math.sqrt(2)]),this.I_triangles=i.I_triangles,this.I_triangles.length<65535)this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);else{t=Array.from(this.I_triangles);const e=this.I_triangles.length,s=64008,a=[];for(let t=0,i=Math.ceil(e/s);t<i;t++)a.push([]);for(let e=0,i=t.length;e<i;e++){const i=t[e]%s;a[Math.floor(t[e]/s)].push(i)}for(let t=0,e=a.length;t<e;t++){const e=new Uint16Array(a[t]),o=t*s*4;0!==e.length&&(this.prog.set_attribute("a_position","vec2",i.vbo_position,0,2*o),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents,0,4*o),this.prog.set_attribute("a_segment","vec2",i.vbo_segment,0,2*o),this.prog.set_attribute("a_angles","vec2",i.vbo_angles,0,2*o),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord,0,2*o),this.index_buffer.set_size(2*e.length),this.index_buffer.set_data(0,e),this.prog.draw(this.gl.TRIANGLES,this.index_buffer))}}}_set_data(){this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)}_set_visuals(){const{line_color:t,line_alpha:e,line_width:s,line_cap:i,line_join:a,line_dash:o,line_dash_offset:n}=this.glyph.visuals.line,[_,r,h,u]=l.color2rgba(t.value,e.value),d=s.value,p=c[i.value],v=f[a.value];this.prog.set_uniform("u_color","vec4",[_/255,r/255,h/255,u/255]),this.prog.set_uniform("u_linewidth","float",[d]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[p,p]),this.prog.set_uniform("u_linejoin","float",[v]),this.prog.set_uniform("u_miter_limit","float",[10]);const b=g.resolve_line_dash(o.value);let m=0,w=1;b.length&&([m,w]=this.dash_atlas.get_atlas_data(b)),this.prog.set_uniform("u_dash_index","float",[m]),this.prog.set_uniform("u_dash_phase","float",[n.value]),this.prog.set_uniform("u_dash_period","float",[w]),this.prog.set_uniform("u_dash_caps","vec2",[p,p]),this.prog.set_uniform("u_closed","float",[0])}_bake(){let t,e,s,i,a,o,n,_;const r=this.nvertices,h=this.glyph.sx,l=this.glyph.sy,g=n=new Float32Array(2*r),u=new Float32Array(2*r),f=_=new Float32Array(4*r);for(let t=0,e=r;t<e;t++)g[2*t+0]=isFinite(h[t])?h[t]:0,g[2*t+1]=isFinite(l[t])?l[t]:0;this.tangents=e=new Float32Array(2*r-2);for(let t=0,s=r-1;t<s;t++)e[2*t+0]=n[2*(t+1)+0]-n[2*t+0],e[2*t+1]=n[2*(t+1)+1]-n[2*t+1];for(let t=0,s=r-1;t<s;t++)f[4*(t+1)+0]=e[2*t+0],f[4*(t+1)+1]=e[2*t+1],f[4*t+2]=e[2*t+0],f[4*t+3]=e[2*t+1];f[0]=e[0],f[1]=e[1],f[4*(r-1)+2]=e[2*(r-2)+0],f[4*(r-1)+3]=e[2*(r-2)+1];const c=new Float32Array(r);for(let t=0,e=r;t<e;t++)c[t]=Math.atan2(_[4*t+0]*_[4*t+3]-_[4*t+1]*_[4*t+2],_[4*t+0]*_[4*t+2]+_[4*t+1]*_[4*t+3]);for(let t=0,e=r-1;t<e;t++)u[2*t+0]=c[t],u[2*t+1]=c[t+1];for(let t=0,e=r;t<e;t++)isFinite(h[t])||(g[2*t+0]=h[t]),isFinite(l[t])||(g[2*t+1]=l[t]);const d=4*r-4;this.V_position=i=new Float32Array(2*d),this.V_angles=s=new Float32Array(2*d),this.V_tangents=a=new Float32Array(4*d),this.V_texcoord=o=new Float32Array(2*d);for(let t=0,e=r;t<e;t++)for(let e=0;e<4;e++){for(let a=0;a<2;a++)i[2*(4*t+e-2)+a]=g[2*t+a],s[2*(4*t+e)+a]=u[2*t+a];for(let s=0;s<4;s++)a[4*(4*t+e-2)+s]=f[4*t+s]}for(let t=0,e=r;t<e;t++)o[2*(4*t+0)+0]=-1,o[2*(4*t+1)+0]=-1,o[2*(4*t+2)+0]=1,o[2*(4*t+3)+0]=1,o[2*(4*t+0)+1]=-1,o[2*(4*t+1)+1]=1,o[2*(4*t+2)+1]=-1,o[2*(4*t+3)+1]=1;const p=6*(r-1);this.I_triangles=t=new Uint32Array(p);for(let e=0,s=r;e<s;e++)t[6*e+0]=0+4*e,t[6*e+1]=1+4*e,t[6*e+2]=3+4*e,t[6*e+3]=2+4*e,t[6*e+4]=0+4*e,t[6*e+5]=3+4*e}_update_scale(t,e){let s;const i=this.nvertices,a=4*i-4,o=this.tangents,n=new Float32Array(i-1),_=new Float32Array(2*i);this.V_segment=s=new Float32Array(2*a);for(let s=0,a=i-1;s<a;s++)n[s]=Math.sqrt((o[2*s+0]*t)**2+(o[2*s+1]*e)**2);let r=0;for(let t=0,e=i-1;t<e;t++)r+=n[t],_[2*(t+1)+0]=r,_[2*t+1]=r;for(let t=0,e=i;t<e;t++)for(let e=0;e<4;e++)for(let i=0;i<2;i++)s[2*(4*t+e)+i]=_[2*t+i];this.cumsum=r,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)}}s.LineGL=d,d.__name__="LineGL"},
function _(e,r,f,u,x){u(),x("Program",e(110).Program),x("Texture2d",e(112).Texture2d);var t=e(111);x("IndexBuffer",t.IndexBuffer),x("VertexBuffer",t.VertexBuffer)},
function _(t,e,i,s,a){s();const r=t(111);class n{constructor(t){this.gl=t,this.UTYPEMAP={float:"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv",int:"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},this.ATYPEMAP={float:"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},this.ATYPEINFO={float:[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126],vec4_uint8:[4,5121]},this._linked=!1,this._validated=!1,this._unset_variables=new Set,this._known_invalid=new Set,this._locations=new Map,this._samplers=new Map,this._attributes=new Map,this.handle=this.gl.createProgram()}delete(){this.gl.deleteProgram(this.handle)}activate(){this.gl.useProgram(this.handle)}deactivate(){this.gl.useProgram(0)}set_shaders(t,e){const i=this.gl;this._linked=!1;const s=i.createShader(i.VERTEX_SHADER),a=i.createShader(i.FRAGMENT_SHADER),r=[[t,s,"vertex"],[e,a,"fragment"]];for(const[t,e,s]of r){i.shaderSource(e,t),i.compileShader(e);if(!i.getShaderParameter(e,i.COMPILE_STATUS)){const t=i.getShaderInfoLog(e);throw new Error(`errors in ${s} shader:\n${t}`)}}if(i.attachShader(this.handle,s),i.attachShader(this.handle,a),i.linkProgram(this.handle),!i.getProgramParameter(this.handle,i.LINK_STATUS)){const t=i.getProgramInfoLog(this.handle);throw new Error(`Program link error:\n${t}`)}this._unset_variables=this._get_active_attributes_and_uniforms(),i.detachShader(this.handle,s),i.detachShader(this.handle,a),i.deleteShader(s),i.deleteShader(a),this._known_invalid.clear(),this._linked=!0}_get_active_attributes_and_uniforms(){const t=this.gl;this._locations.clear();const e=new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),i=t.getProgramParameter(this.handle,t.ACTIVE_UNIFORMS),s=[],a=[],r=[[s,t.getProgramParameter(this.handle,t.ACTIVE_ATTRIBUTES),t.getActiveAttrib,t.getAttribLocation],[a,i,t.getActiveUniform,t.getUniformLocation]];for(const[i,s,a,n]of r)for(let r=0;r<s;r+=1){const s=a.call(t,this.handle,r),o=s.name,h=o.match(e);if(null!=h){const t=h[1];for(let e=0;e<s.size;e+=1)i.push([`${t}[${e}]`,s.type])}else i.push([o,s.type]);this._locations.set(o,n.call(t,this.handle,o))}const n=new Set;for(const[t]of s)n.add(t);for(const[t]of a)n.add(t);return n}set_texture(t,e){var i;if(!this._linked)throw new Error("Cannot set uniform when program has no code");const s=null!==(i=this._locations.get(t))&&void 0!==i?i:-1;if(s<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log(`"Variable ${t} is not an active texture`));else{this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate();{let i=this._samplers.size;this._samplers.has(t)&&(i=this._samplers.get(t)[2]),this._samplers.set(t,[e._target,e.handle,i]),this.gl.uniform1i(s,i)}}}set_uniform(t,e,i){var s;if(!this._linked)throw new Error("Cannot set uniform when program has no code");const a=null!==(s=this._locations.get(t))&&void 0!==s?s:-1;if(a<0)return void(this._known_invalid.has(t)||(this._known_invalid.add(t),console.log(`Variable ${t} is not an active uniform`)));this._unset_variables.has(t)&&this._unset_variables.delete(t);let r=1;if(!e.startsWith("mat")){const t="int"==e||"bool"==e?"float":e.replace(/^ib/,"");r=Math.floor(i.length/this.ATYPEINFO[t][0])}if(r>1)for(let e=0;e<r;e+=1)if(this._unset_variables.has(`${t}[${e}]`)){const i=`${t}[${e}]`;this._unset_variables.has(i)&&this._unset_variables.delete(i)}const n=this.UTYPEMAP[e];this.activate(),e.startsWith("mat")?this.gl[n](a,!1,i):this.gl[n](a,i)}set_attribute(t,e,i,s=0,a=0,n=!1){var o;if(!this._linked)throw new Error("Cannot set attribute when program has no code");const h=null!==(o=this._locations.get(t))&&void 0!==o?o:-1;if(h<0)this._known_invalid.has(t)||(this._known_invalid.add(t),i instanceof r.VertexBuffer&&a>0||console.log(`Variable ${t} is not an active attribute`));else if(this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate(),i instanceof r.VertexBuffer){const[r,o]=this.ATYPEINFO[e],l="vertexAttribPointer",_=[r,o,n,s,a];this._attributes.set(t,[i.handle,h,l,_])}else{const s=this.ATYPEMAP[e];this._attributes.set(t,[null,h,s,i])}}_pre_draw(){this.activate();for(const[t,e,i]of this._samplers.values())this.gl.activeTexture(this.gl.TEXTURE0+i),this.gl.bindTexture(t,e);for(const[t,e,i,s]of this._attributes.values())null!=t?(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,t),this.gl.enableVertexAttribArray(e),this.gl[i].apply(this.gl,[e,...s])):(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,null),this.gl.disableVertexAttribArray(e),this.gl[i].apply(this.gl,[e,...s]));this._validated||(this._validated=!0,this._validate())}_validate(){if(this._unset_variables.size&&console.log(`Program has unset variables: ${this._unset_variables}`),this.gl.validateProgram(this.handle),!this.gl.getProgramParameter(this.handle,this.gl.VALIDATE_STATUS))throw console.log(this.gl.getProgramInfoLog(this.handle)),new Error("Program validation error")}draw(t,e){if(!this._linked)throw new Error("Cannot draw program if code has not been set");if(e instanceof r.IndexBuffer){this._pre_draw(),e.activate();const i=e.buffer_size/2,s=this.gl.UNSIGNED_SHORT;this.gl.drawElements(t,i,s,0),e.deactivate()}else{const[i,s]=e;0!=s&&(this._pre_draw(),this.gl.drawArrays(t,i,s))}}}i.Program=n,n.__name__="Program"},
function _(t,e,s,i,a){i();class r{constructor(t){this.gl=t,this._usage=35048,this.buffer_size=0,this.handle=this.gl.createBuffer()}delete(){this.gl.deleteBuffer(this.handle)}activate(){this.gl.bindBuffer(this._target,this.handle)}deactivate(){this.gl.bindBuffer(this._target,null)}set_size(t){t!=this.buffer_size&&(this.activate(),this.gl.bufferData(this._target,t,this._usage),this.buffer_size=t)}set_data(t,e){this.activate(),this.gl.bufferSubData(this._target,t,e)}}s.Buffer=r,r.__name__="Buffer";class f extends r{constructor(){super(...arguments),this._target=34962}}s.VertexBuffer=f,f.__name__="VertexBuffer";class h extends r{constructor(){super(...arguments),this._target=34963}}s.IndexBuffer=h,h.__name__="IndexBuffer"},
function _(t,e,i,a,r){a();const s=t(11);class h{constructor(t){this.gl=t,this._target=3553,this._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},this.handle=this.gl.createTexture()}delete(){this.gl.deleteTexture(this.handle)}activate(){this.gl.bindTexture(this._target,this.handle)}deactivate(){this.gl.bindTexture(this._target,0)}_get_alignment(t){const e=[4,8,2,1];for(const i of e)if(t%i==0)return i;s.unreachable()}set_wrapping(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_S,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_T,e)}set_interpolation(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_MIN_FILTER,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_MAG_FILTER,e)}set_size([t,e],i){var a,r,s;t==(null===(a=this._shape_format)||void 0===a?void 0:a.width)&&e==(null===(r=this._shape_format)||void 0===r?void 0:r.height)&&i==(null===(s=this._shape_format)||void 0===s?void 0:s.format)||(this._shape_format={width:t,height:e,format:i},this.activate(),this.gl.texImage2D(this._target,0,i,t,e,0,i,this.gl.UNSIGNED_BYTE,null))}set_data(t,[e,i],a){this.activate();const{format:r}=this._shape_format,[s,h]=t,l=this._types[a.constructor.name];if(null==l)throw new Error(`Type ${a.constructor.name} not allowed for texture`);const _=this._get_alignment(e);4!=_&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,_),this.gl.texSubImage2D(this._target,0,s,h,e,i,r,l,a),4!=_&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,4)}}i.Texture2d=h,h.__name__="Texture2d"},
function _(e,t,s,i,h){i();class a{constructor(e,t){this.gl=e,this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1}set_data_changed(){const{data_size:e}=this.glyph;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0}set_visuals_changed(){this.visuals_changed=!0}render(e,t,s){if(0==t.length)return!0;const{width:i,height:h}=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:i,height:h};return this.draw(t,s,a),!0}}s.BaseGLGlyph=a,a.__name__="BaseGLGlyph"},
function _(n,e,t,a,i){a();t.default="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = a_position;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n"},
function _(n,t,e,s,a){s();e.default="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n"},
function _(i,t,s,e,l){e();const a=i(1),n=i(64),_=i(106),o=a.__importStar(i(107)),h=a.__importStar(i(48)),c=i(59);class r extends n.XYGlyphView{_inner_loop(i,t,s,e,l){for(const a of t){const t=s[a],n=e[a];0!=a?isNaN(t+n)?(i.closePath(),l.apply(i),i.beginPath()):i.lineTo(t,n):(i.beginPath(),i.moveTo(t,n))}i.closePath(),l.call(i)}_render(i,t,s){const{sx:e,sy:l}=null!=s?s:this;this.visuals.fill.doit&&(this.visuals.fill.set_value(i),this._inner_loop(i,t,e,l,i.fill)),this.visuals.hatch.doit&&(this.visuals.hatch.set_value(i),this._inner_loop(i,t,e,l,i.fill)),this.visuals.line.doit&&(this.visuals.line.set_value(i),this._inner_loop(i,t,e,l,i.stroke))}draw_legend_for_index(i,t,s){_.generic_area_scalar_legend(this.visuals,i,t)}_hit_point(i){const t=new c.Selection;return o.point_in_poly(i.sx,i.sy,this.sx,this.sy)&&(t.add_to_selected_glyphs(this.model),t.view=this),t}}s.PatchView=r,r.__name__="PatchView";class p extends n.XYGlyph{constructor(i){super(i)}static init_Patch(){this.prototype.default_view=r,this.mixins([h.LineScalar,h.FillScalar,h.HatchScalar])}}s.Patch=p,p.__name__="Patch",p.init_Patch()},
function _(t,e,s,i,n){i();const a=t(1),r=t(24),h=t(118),_=a.__importStar(t(107)),l=a.__importStar(t(18)),o=t(59);class c extends h.AreaView{_index_data(t){const{min:e,max:s}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x1[n],a=this._x2[n],r=this._y[n];isNaN(i+a+r)||!isFinite(i+a+r)?t.add_empty():t.add(e(i,a),r,s(i,a),r)}}_inner(t,e,s,i,n){t.beginPath();for(let s=0,n=e.length;s<n;s++)t.lineTo(e[s],i[s]);for(let e=s.length-1;e>=0;e--)t.lineTo(s[e],i[e]);t.closePath(),n.call(t)}_render(t,e,s){const{sx1:i,sx2:n,sy:a}=null!=s?s:this;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,i,n,a,t.fill)),this.visuals.hatch.doit&&(this.visuals.hatch.set_value(t),this._inner(t,i,n,a,t.fill))}_hit_point(t){const e=this.sy.length,s=new r.ScreenArray(2*e),i=new r.ScreenArray(2*e);for(let t=0,n=e;t<n;t++)s[t]=this.sx1[t],i[t]=this.sy[t],s[e+t]=this.sx2[e-t-1],i[e+t]=this.sy[e-t-1];const n=new o.Selection;return _.point_in_poly(t.sx,t.sy,s,i)&&(n.add_to_selected_glyphs(this.model),n.view=this),n}scenterxy(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}s.HAreaView=c,c.__name__="HAreaView";class d extends h.Area{constructor(t){super(t)}static init_HArea(){this.prototype.default_view=c,this.define((({})=>({x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}]})))}}s.HArea=d,d.__name__="HArea",d.init_HArea()},
function _(e,a,_,i,r){i();const s=e(1),n=e(98),t=e(106),c=s.__importStar(e(48));class l extends n.GlyphView{draw_legend_for_index(e,a,_){t.generic_area_scalar_legend(this.visuals,e,a)}}_.AreaView=l,l.__name__="AreaView";class d extends n.Glyph{constructor(e){super(e)}static init_Area(){this.mixins([c.FillScalar,c.HatchScalar])}}_.Area=d,d.__name__="Area",d.init_Area()},
function _(t,e,s,i,n){i();const a=t(1),r=t(24),h=t(118),_=a.__importStar(t(107)),l=a.__importStar(t(18)),o=t(59);class c extends h.AreaView{_index_data(t){const{min:e,max:s}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x[n],a=this._y1[n],r=this._y2[n];isNaN(i+a+r)||!isFinite(i+a+r)?t.add_empty():t.add(i,e(a,r),i,s(a,r))}}_inner(t,e,s,i,n){t.beginPath();for(let i=0,n=s.length;i<n;i++)t.lineTo(e[i],s[i]);for(let s=i.length-1;s>=0;s--)t.lineTo(e[s],i[s]);t.closePath(),n.call(t)}_render(t,e,s){const{sx:i,sy1:n,sy2:a}=null!=s?s:this;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,i,n,a,t.fill)),this.visuals.hatch.doit&&(this.visuals.hatch.set_value(t),this._inner(t,i,n,a,t.fill))}scenterxy(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]}_hit_point(t){const e=this.sx.length,s=new r.ScreenArray(2*e),i=new r.ScreenArray(2*e);for(let t=0,n=e;t<n;t++)s[t]=this.sx[t],i[t]=this.sy1[t],s[e+t]=this.sx[e-t-1],i[e+t]=this.sy2[e-t-1];const n=new o.Selection;return _.point_in_poly(t.sx,t.sy,s,i)&&(n.add_to_selected_glyphs(this.model),n.view=this),n}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}s.VAreaView=c,c.__name__="VAreaView";class d extends h.Area{constructor(t){super(t)}static init_VArea(){this.prototype.default_view=c,this.define((({})=>({x:[l.XCoordinateSpec,{field:"x"}],y1:[l.YCoordinateSpec,{field:"y1"}],y2:[l.YCoordinateSpec,{field:"y2"}]})))}}s.VArea=d,d.__name__="VArea",d.init_VArea()},
function _(i,e,s,t,n){t();const c=i(53),o=i(59),r=i(24),a=i(121),u=i(57);class _ extends c.Model{constructor(i){super(i)}static init_CDSView(){this.define((({Array:i,Ref:e})=>({filters:[i(e(a.Filter)),[]],source:[e(u.ColumnarDataSource)]}))),this.internal((({Int:i,Dict:e,Ref:s,Nullable:t})=>({indices:[s(r.Indices)],indices_map:[e(i),{}],masked:[t(s(r.Indices)),null]})))}initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals(),this.connect(this.properties.filters.change,(()=>this.compute_indices()));const i=()=>{const i=()=>this.compute_indices();null!=this.source&&(this.connect(this.source.change,i),this.source instanceof u.ColumnarDataSource&&(this.connect(this.source.streaming,i),this.connect(this.source.patching,i)))};let e=null!=this.source;e?i():this.connect(this.properties.source.change,(()=>{e||(i(),e=!0)}))}compute_indices(){var i;const{source:e}=this;if(null==e)return;const s=null!==(i=e.get_length())&&void 0!==i?i:1,t=r.Indices.all_set(s);for(const i of this.filters)t.intersect(i.compute_indices(e));this.indices=t,this._indices=[...t],this.indices_map_to_subset()}indices_map_to_subset(){this.indices_map={};for(let i=0;i<this._indices.length;i++)this.indices_map[this._indices[i]]=i}convert_selection_from_subset(i){const e=i.indices.map((i=>this._indices[i]));return new o.Selection(Object.assign(Object.assign({},i.attributes),{indices:e}))}convert_selection_to_subset(i){const e=i.indices.map((i=>this.indices_map[i]));return new o.Selection(Object.assign(Object.assign({},i.attributes),{indices:e}))}convert_indices_from_subset(i){return i.map((i=>this._indices[i]))}}s.CDSView=_,_.__name__="CDSView",_.init_CDSView()},
function _(e,t,n,s,c){s();const o=e(53);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(n,e,t,i,o){i();const s=n(9);async function c(n,e,t){const i=new n(Object.assign(Object.assign({},t),{model:e}));return i.initialize(),await i.lazy_initialize(),i}t.build_view=async function(n,e={parent:null},t=(n=>n.default_view)){const i=await c(t(n),n,e);return i.connect_signals(),i},t.build_views=async function(n,e,t={parent:null},i=(n=>n.default_view)){const o=s.difference([...n.keys()],e);for(const e of o)n.get(e).remove(),n.delete(e);const a=[],f=e.filter((e=>!n.has(e)));for(const e of f){const o=await c(i(e),e,t);n.set(e,o),a.push(o)}for(const n of a)n.connect_signals();return a},t.remove_views=function(n){for(const[e,t]of n)t.remove(),n.delete(e)}},
function _(e,r,n,t,i){t();const s=e(62),o=e(61),l=e(124),d=e(125),a=e(126),p=e(122),_=e(64),h=e(127),c=e(128),u=e(11);class y extends s.DataRendererView{get glyph_view(){return this.node_view.glyph}async lazy_initialize(){await super.lazy_initialize();const e=this.model;let r=null,n=null;const t=new class extends l.Expression{_v_compute(n){u.assert(null==r);const[t]=r=e.layout_provider.get_edge_coordinates(n);return t}},i=new class extends l.Expression{_v_compute(e){u.assert(null!=r);const[,n]=r;return r=null,n}},s=new class extends l.Expression{_v_compute(r){u.assert(null==n);const[t]=n=e.layout_provider.get_node_coordinates(r);return t}},o=new class extends l.Expression{_v_compute(e){u.assert(null!=n);const[,r]=n;return n=null,r}},{edge_renderer:d,node_renderer:a}=this.model;if(!(d.glyph instanceof h.MultiLine||d.glyph instanceof c.Patches))throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);if(!(a.glyph instanceof _.XYGlyph))throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);d.glyph.properties.xs.internal=!0,d.glyph.properties.ys.internal=!0,a.glyph.properties.x.internal=!0,a.glyph.properties.y.internal=!0,d.glyph.xs={expr:t},d.glyph.ys={expr:i},a.glyph.x={expr:s},a.glyph.y={expr:o};const{parent:y}=this;this.edge_view=await p.build_view(d,{parent:y}),this.node_view=await p.build_view(a,{parent:y})}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,(()=>{this.edge_view.set_data(),this.node_view.set_data(),this.request_render()}))}remove(){this.edge_view.remove(),this.node_view.remove(),super.remove()}_render(){this.edge_view.render(),this.node_view.render()}renderer_view(e){if(e instanceof o.GlyphRenderer){if(e==this.edge_view.model)return this.edge_view;if(e==this.node_view.model)return this.node_view}return super.renderer_view(e)}}n.GraphRendererView=y,y.__name__="GraphRendererView";class g extends s.DataRenderer{constructor(e){super(e)}static init_GraphRenderer(){this.prototype.default_view=y,this.define((({Ref:e})=>({layout_provider:[e(d.LayoutProvider)],node_renderer:[e(o.GlyphRenderer)],edge_renderer:[e(o.GlyphRenderer)],selection_policy:[e(a.GraphHitTestPolicy),()=>new a.NodesOnly],inspection_policy:[e(a.GraphHitTestPolicy),()=>new a.NodesOnly]})))}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}n.GraphRenderer=g,g.__name__="GraphRenderer",g.init_GraphRenderer()},
function _(e,t,s,n,i){n();const c=e(53);class l extends c.Model{constructor(e){super(e)}initialize(){super.initialize(),this._connected=new Set,this._result=new Map}v_compute(e){this._connected.has(e)||(this.connect(e.change,(()=>this._result.delete(e))),this.connect(e.patching,(()=>this._result.delete(e))),this.connect(e.streaming,(()=>this._result.delete(e))),this._connected.add(e));let t=this._result.get(e);return null==t&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=l,l.__name__="Expression";class h extends c.Model{constructor(e){super(e)}initialize(){super.initialize(),this._connected=new Set,this._result=new Map}compute(e){this._connected.has(e)||(this.connect(e.change,(()=>this._result.delete(e))),this.connect(e.patching,(()=>this._result.delete(e))),this.connect(e.streaming,(()=>this._result.delete(e))),this._connected.add(e));let t=this._result.get(e);return null==t&&(t=this._compute(e),this._result.set(e,t)),t}}s.ScalarExpression=h,h.__name__="ScalarExpression"},
function _(o,e,r,t,n){t();const s=o(53);class c extends s.Model{constructor(o){super(o)}}r.LayoutProvider=c,c.__name__="LayoutProvider"},
function _(e,t,d,n,s){n();const o=e(53),r=e(12),_=e(9),i=e(59);class c extends o.Model{constructor(e){super(e)}_hit_test(e,t,d){if(!t.model.visible)return null;const n=d.glyph.hit_test(e);return null==n?null:d.model.view.convert_selection_from_subset(n)}}d.GraphHitTestPolicy=c,c.__name__="GraphHitTestPolicy";class a extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}do_selection(e,t,d,n){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;return s.update(e,d,n),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const{edge_renderer:o}=d.model,r=o.get_selection_manager().get_or_create_inspector(d.edge_view.model);return r.update(e,n,s),d.edge_view.model.data_source.setv({inspected:r},{silent:!0}),d.edge_view.model.data_source.inspect.emit([d.edge_view.model,{geometry:t}]),!r.is_empty()}}d.EdgesOnly=a,a.__name__="EdgesOnly";class l extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const{node_renderer:o}=d.model,r=o.get_selection_manager().get_or_create_inspector(d.node_view.model);return r.update(e,n,s),d.node_view.model.data_source.setv({inspected:r},{silent:!0}),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!r.is_empty()}}d.NodesOnly=l,l.__name__="NodesOnly";class u extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}get_linked_edges(e,t,d){let n=[];"selection"==d?n=e.selected.indices.map((t=>e.data.index[t])):"inspection"==d&&(n=e.inspected.indices.map((t=>e.data.index[t])));const s=[];for(let e=0;e<t.data.start.length;e++)(_.contains(n,t.data.start[e])||_.contains(n,t.data.end[e]))&&s.push(e);const o=new i.Selection;for(const e of s)o.multiline_indices[e]=[0];return o.indices=s,o}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,d,n);const o=t.edge_renderer.data_source.selected,r=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model);o.update(e,n,s),d.node_view.model.data_source.setv({inspected:o},{silent:!0});const r=d.edge_view.model.data_source.selection_manager.get_or_create_inspector(d.edge_view.model),_=this.get_linked_edges(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.update(_,n,s),d.edge_view.model.data_source.setv({inspected:r},{silent:!0}),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!o.is_empty()}}d.NodesAndLinkedEdges=u,u.__name__="NodesAndLinkedEdges";class m extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}get_linked_nodes(e,t,d){let n=[];"selection"==d?n=t.selected.indices:"inspection"==d&&(n=t.inspected.indices);const s=[];for(const e of n)s.push(t.data.start[e]),s.push(t.data.end[e]);const o=_.uniq(s).map((t=>r.indexOf(e.data.index,t)));return new i.Selection({indices:o})}do_selection(e,t,d,n){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,d,n);const o=t.node_renderer.data_source.selected,r=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,d,n),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.edge_view.model.data_source.selection_manager.get_or_create_inspector(d.edge_view.model);o.update(e,n,s),d.edge_view.model.data_source.setv({inspected:o},{silent:!0});const r=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model),_=this.get_linked_nodes(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.update(_,n,s),d.node_view.model.data_source.setv({inspected:r},{silent:!0}),d.edge_view.model.data_source.inspect.emit([d.edge_view.model,{geometry:t}]),!o.is_empty()}}d.EdgesAndLinkedNodes=m,m.__name__="EdgesAndLinkedNodes"},
function _(t,e,i,s,n){s();const o=t(1),r=t(65),l=t(48),_=o.__importStar(t(107)),c=o.__importStar(t(18)),h=t(12),a=t(13),d=t(98),x=t(106),y=t(59);class g extends d.GlyphView{_project_data(){r.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(t){const{data_size:e}=this;for(let i=0;i<e;i++){const e=this._xs.get(i);if(0==e.length){t.add_empty();continue}const s=this._ys.get(i);if(0==s.length){t.add_empty();continue}const[n,o]=h.minmax(e),[r,l]=h.minmax(s);t.add(n,r,o,l)}}_render(t,e,i){const{sxs:s,sys:n}=null!=i?i:this;for(const i of e){const e=s.get(i),o=n.get(i);this.visuals.line.set_vectorize(t,i);for(let i=0,s=e.length;i<s;i++){const s=e[i],n=o[i];0!=i?isNaN(s+n)?(t.stroke(),t.beginPath()):t.lineTo(s,n):(t.beginPath(),t.moveTo(s,n))}t.stroke()}}_hit_point(t){const e={x:t.sx,y:t.sy};let i=9999;const s=new Map;for(let t=0,n=this.sxs.length;t<n;t++){const n=Math.max(2,this.line_width.get(t)/2),o=this.sxs.get(t),r=this.sys.get(t);let l=null;for(let t=0,s=o.length-1;t<s;t++){const s={x:o[t],y:r[t]},c={x:o[t+1],y:r[t+1]},h=_.dist_to_segment(e,s,c);h<n&&h<i&&(i=h,l=[t])}null!=l&&s.set(t,l)}return new y.Selection({indices:[...s.keys()],multiline_indices:a.to_object(s)})}_hit_span(t){const{sx:e,sy:i}=t;let s,n;"v"==t.direction?(s=this.renderer.yscale.invert(i),n=this._ys):(s=this.renderer.xscale.invert(e),n=this._xs);const o=new Map;for(let t=0,e=n.length;t<e;t++){const e=n.get(t),i=[];for(let t=0,n=e.length-1;t<n;t++)e[t]<=s&&s<=e[t+1]&&i.push(t);i.length>0&&o.set(t,i)}return new y.Selection({indices:[...o.keys()],multiline_indices:a.to_object(o)})}get_interpolation_hit(t,e,i){const s=this._xs.get(t),n=this._ys.get(t),o=s[e],r=n[e],l=s[e+1],_=n[e+1];return x.line_interpolation(this.renderer,i,o,r,l,_)}draw_legend_for_index(t,e,i){x.generic_line_vector_legend(this.visuals,t,e,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.MultiLineView=g,g.__name__="MultiLineView";class u extends d.Glyph{constructor(t){super(t)}static init_MultiLine(){this.prototype.default_view=g,this.define((({})=>({xs:[c.XCoordinateSeqSpec,{field:"xs"}],ys:[c.YCoordinateSeqSpec,{field:"ys"}]}))),this.mixins(l.LineVector)}}i.MultiLine=u,u.__name__="MultiLine",u.init_MultiLine()},
function _(e,t,s,i,n){i();const r=e(1),o=e(98),a=e(106),_=e(12),c=e(48),l=r.__importStar(e(107)),h=r.__importStar(e(18)),d=e(59),y=e(11),p=e(65);class x extends o.GlyphView{_project_data(){p.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s);if(0==t.length)e.add_empty();else{const[s,n]=_.minmax(t),[r,o]=_.minmax(i);e.add(s,r,n,o)}}}_mask_data(){const{x_range:e,y_range:t}=this.renderer.plot_view.frame;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_inner_loop(e,t,s,i){for(let n=0,r=t.length;n<r;n++)0!=n?isNaN(t[n]+s[n])?(e.closePath(),i.apply(e),e.beginPath()):e.lineTo(t[n],s[n]):(e.beginPath(),e.moveTo(t[n],s[n]));e.closePath(),i.call(e)}_render(e,t,s){const{sxs:i,sys:n}=null!=s?s:this;for(const s of t){const t=i.get(s),r=n.get(s);this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,s),this._inner_loop(e,t,r,e.fill)),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(e,s),this._inner_loop(e,t,r,e.fill)),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,s),this._inner_loop(e,t,r,e.stroke))}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,r=[t,s,s,t],o=[i,i,n,n],[a,_]=this.renderer.xscale.r_invert(t,s),[c,h]=this.renderer.yscale.r_invert(i,n),y=this.index.indices({x0:a,x1:_,y0:c,y1:h}),p=[];for(const e of y){const t=this.sxs.get(e),s=this.sys.get(e);let i=!0;for(let e=0,n=t.length;e<n;e++){const n=t[e],a=s[e];if(!l.point_in_poly(n,a,r,o)){i=!1;break}}i&&p.push(e)}return new d.Selection({indices:p})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let a=0,_=0;;_++){if(isNaN(i[_])||_==r){const r=i.subarray(a,_),c=n.subarray(a,_);if(l.point_in_poly(t,s,r,c)){o.push(e);break}a=_+1}if(_==r)break}}return new d.Selection({indices:o})}_get_snap_coord(e){return _.sum(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let o=!1;for(let e=0,a=0;;a++){const _=isNaN(i[a]);if(o=o||_,a==r&&!o){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(_||a==r){const r=i.subarray(e,a),o=n.subarray(e,a);if(l.point_in_poly(t,s,r,o)){return[this._get_snap_coord(r),this._get_snap_coord(o)]}e=a+1}if(a==r)break}y.unreachable()}draw_legend_for_index(e,t,s){a.generic_area_vector_legend(this.visuals,e,t,s)}}s.PatchesView=x,x.__name__="PatchesView";class f extends o.Glyph{constructor(e){super(e)}static init_Patches(){this.prototype.default_view=x,this.define((({})=>({xs:[h.XCoordinateSeqSpec,{field:"xs"}],ys:[h.YCoordinateSeqSpec,{field:"ys"}]}))),this.mixins([c.LineVector,c.FillVector,c.HatchVector])}}s.Patches=f,f.__name__="Patches",f.init_Patches()},
function _(e,t,n,s,o){s();const r=e(53);class c extends r.Model{do_selection(e,t,n,s){return null!=e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=c,c.__name__="SelectionPolicy";class l extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=l,l.__name__="IntersectRenderers";class _ extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=_,_.__name__="UnionRenderers"},
function _(t,n,e,s,o){s();const r=t(1),i=t(57),l=t(8),c=t(13),a=r.__importStar(t(131)),u=t(132),h=t(35);function d(t,n,e){if(l.isArray(t)){const s=t.concat(n);return null!=e&&s.length>e?s.slice(-e):s}if(l.isTypedArray(t)){const s=t.length+n.length;if(null!=e&&s>e){const o=s-e,r=t.length;let i;t.length<e?(i=new t.constructor(e),i.set(t,0)):i=t;for(let t=o,n=r;t<n;t++)i[t-o]=i[t];for(let t=0,e=n.length;t<e;t++)i[t+(r-o)]=n[t];return i}{const e=new t.constructor(n);return a.concat(t,e)}}throw new Error("unsupported array types")}function f(t,n){let e,s,o;return l.isNumber(t)?(e=t,o=t+1,s=1):(e=null!=t.start?t.start:0,o=null!=t.stop?t.stop:n,s=null!=t.step?t.step:1),[e,o,s]}function m(t,n){const e=new Set;let s=!1;for(const[o,r]of n){let n,i,c,a;if(l.isArray(o)){const[s]=o;e.add(s),n=t[s].shape,i=t[s],a=r,2===o.length?(n=[1,n[0]],c=[o[0],0,o[1]]):c=o}else l.isNumber(o)?(a=[r],e.add(o)):(a=r,s=!0),c=[0,0,o],n=[1,t.length],i=t;let u=0;const[h,d,m]=f(c[1],n[0]),[_,p,g]=f(c[2],n[1]);for(let t=h;t<d;t+=m)for(let o=_;o<p;o+=g)s&&e.add(o),i[t*n[1]+o]=a[u],u++}return e}e.stream_to_column=d,e.slice=f,e.patch_to_column=m;class _ extends i.ColumnarDataSource{constructor(t){super(t)}static init_ColumnDataSource(){this.define((({Dict:t,Any:n})=>({data:[t(n),{}]})))}stream(t,n,e){const{data:s}=this;for(const[e,o]of c.entries(t))s[e]=d(s[e],o,n);if(this.setv({data:s},{silent:!0}),this.streaming.emit(),null!=this.document){const s=new h.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}}patch(t,n){const{data:e}=this;let s=new Set;for(const[n,o]of c.entries(t))s=u.union(s,m(e[n],o));if(this.setv({data:e},{silent:!0}),this.patching.emit([...s]),null!=this.document){const e=new h.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:e})}}}e.ColumnDataSource=_,_.__name__="ColumnDataSource",_.init_ColumnDataSource()},
function _(t,n,o,e,c){e(),o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(n,o,t,e,f){function c(...n){const o=new Set;for(const t of n)for(const n of t)o.add(n);return o}e(),t.union=c,t.intersection=function(n,...o){const t=new Set;n:for(const e of n){for(const n of o)if(!n.has(e))continue n;t.add(e)}return t},t.difference=function(n,...o){const t=new Set(n);for(const n of c(...o))t.delete(n);return t}},
function _(e,i,t,s,o){s();const n=e(1),a=e(53),l=e(42),r=n.__importStar(e(45)),_=e(48),c=n.__importStar(e(18));class d extends l.View{initialize(){super.initialize(),this.visuals=new r.Visuals(this)}request_render(){this.parent.request_render()}get canvas(){return this.parent.canvas}set_data(e){const i=this;for(const t of this.model){if(!(t instanceof c.VectorSpec||t instanceof c.ScalarSpec))continue;const s=t.uniform(e);i[`${t.attr}`]=s}}}t.ArrowHeadView=d,d.__name__="ArrowHeadView";class h extends a.Model{constructor(e){super(e)}static init_ArrowHead(){this.define((()=>({size:[c.NumberSpec,25]})))}}t.ArrowHead=h,h.__name__="ArrowHead",h.init_ArrowHead();class v extends d{clip(e,i){this.visuals.line.set_vectorize(e,i);const t=this.size.get(i);e.moveTo(.5*t,t),e.lineTo(.5*t,-2),e.lineTo(-.5*t,-2),e.lineTo(-.5*t,t),e.lineTo(0,0),e.lineTo(.5*t,t)}render(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);const t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,t),e.lineTo(0,0),e.lineTo(-.5*t,t),e.stroke()}}}t.OpenHeadView=v,v.__name__="OpenHeadView";class u extends h{constructor(e){super(e)}static init_OpenHead(){this.prototype.default_view=v,this.mixins(_.LineVector)}}t.OpenHead=u,u.__name__="OpenHead",u.init_OpenHead();class m extends d{clip(e,i){this.visuals.line.set_vectorize(e,i);const t=this.size.get(i);e.moveTo(.5*t,t),e.lineTo(.5*t,-2),e.lineTo(-.5*t,-2),e.lineTo(-.5*t,t),e.lineTo(.5*t,t)}render(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._normal(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._normal(e,i),e.stroke())}_normal(e,i){const t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,t),e.lineTo(0,0),e.lineTo(-.5*t,t),e.closePath()}}t.NormalHeadView=m,m.__name__="NormalHeadView";class T extends h{constructor(e){super(e)}static init_NormalHead(){this.prototype.default_view=m,this.mixins([_.LineVector,_.FillVector]),this.override({fill_color:"black"})}}t.NormalHead=T,T.__name__="NormalHead",T.init_NormalHead();class p extends d{clip(e,i){this.visuals.line.set_vectorize(e,i);const t=this.size.get(i);e.moveTo(.5*t,t),e.lineTo(.5*t,-2),e.lineTo(-.5*t,-2),e.lineTo(-.5*t,t),e.lineTo(0,.5*t),e.lineTo(.5*t,t)}render(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._vee(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._vee(e,i),e.stroke())}_vee(e,i){const t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,t),e.lineTo(0,0),e.lineTo(-.5*t,t),e.lineTo(0,.5*t),e.closePath()}}t.VeeHeadView=p,p.__name__="VeeHeadView";class H extends h{constructor(e){super(e)}static init_VeeHead(){this.prototype.default_view=p,this.mixins([_.LineVector,_.FillVector]),this.override({fill_color:"black"})}}t.VeeHead=H,H.__name__="VeeHead",H.init_VeeHead();class V extends d{render(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);const t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,0),e.lineTo(-.5*t,0),e.stroke()}}clip(e,i){}}t.TeeHeadView=V,V.__name__="TeeHeadView";class f extends h{constructor(e){super(e)}static init_TeeHead(){this.prototype.default_view=V,this.mixins(_.LineVector)}}t.TeeHead=f,f.__name__="TeeHead",f.init_TeeHead()},
function _(s,e,i,t,l){t();const _=s(1),o=s(135),r=_.__importStar(s(48));class h extends o.UpperLowerView{paint(s){s.beginPath(),s.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let e=0,i=this._lower_sx.length;e<i;e++)s.lineTo(this._lower_sx[e],this._lower_sy[e]);for(let e=this._upper_sx.length-1;e>=0;e--)s.lineTo(this._upper_sx[e],this._upper_sy[e]);s.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(s),s.fill()),s.beginPath(),s.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let e=0,i=this._lower_sx.length;e<i;e++)s.lineTo(this._lower_sx[e],this._lower_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(s),s.stroke()),s.beginPath(),s.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let e=0,i=this._upper_sx.length;e<i;e++)s.lineTo(this._upper_sx[e],this._upper_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(s),s.stroke())}}i.BandView=h,h.__name__="BandView";class n extends o.UpperLower{constructor(s){super(s)}static init_Band(){this.prototype.default_view=h,this.mixins([r.Line,r.Fill]),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}}i.Band=n,n.__name__="Band",n.init_Band()},
function _(e,t,i,s,o){s();const r=e(1),p=e(56),n=e(20),_=r.__importStar(e(18));class a extends p.DataAnnotationView{map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,i=this.coordinates.x_scale,s=this.coordinates.y_scale,o="height"==t?s:i,r="height"==t?i:s,p="height"==t?e.bbox.yview:e.bbox.xview,n="height"==t?e.bbox.xview:e.bbox.yview;let _,a,h;_="data"==this.model.properties.lower.units?o.v_compute(this._lower):p.v_compute(this._lower),a="data"==this.model.properties.upper.units?o.v_compute(this._upper):p.v_compute(this._upper),h="data"==this.model.properties.base.units?r.v_compute(this._base):n.v_compute(this._base);const[d,c]="height"==t?[1,0]:[0,1],u=[_,h],l=[a,h];this._lower_sx=u[d],this._lower_sy=u[c],this._upper_sx=l[d],this._upper_sy=l[c]}}i.UpperLowerView=a,a.__name__="UpperLowerView";class h extends _.CoordinateSpec{get dimension(){return"width"==this.obj.dimension?"x":"y"}get units(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:"data"}}i.XOrYCoordinateSpec=h,h.__name__="XOrYCoordinateSpec";class d extends p.DataAnnotation{constructor(e){super(e)}static init_UpperLower(){this.define((()=>({dimension:[n.Dimension,"height"],lower:[h,{field:"lower"}],upper:[h,{field:"upper"}],base:[h,{field:"base"}]})))}}i.UpperLower=d,d.__name__="UpperLower",d.init_UpperLower()},
function _(t,i,o,n,e){n();const s=t(1),l=t(40),a=s.__importStar(t(48)),r=t(20),h=t(99);o.EDGE_TOLERANCE=2.5;class u extends l.AnnotationView{constructor(){super(...arguments),this.bbox=new h.BBox}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{left:t,right:i,top:o,bottom:n}=this.model;if(null==t&&null==i&&null==o&&null==n)return;const{frame:e}=this.plot_view,s=this.coordinates.x_scale,l=this.coordinates.y_scale,a=(t,i,o,n,e)=>{let s;return s=null!=t?this.model.screen?t:"data"==i?o.compute(t):n.compute(t):e,s};this.bbox=new h.BBox({left:a(t,this.model.left_units,s,e.bbox.xview,e.bbox.left),right:a(i,this.model.right_units,s,e.bbox.xview,e.bbox.right),top:a(o,this.model.top_units,l,e.bbox.yview,e.bbox.top),bottom:a(n,this.model.bottom_units,l,e.bbox.yview,e.bbox.bottom)}),this._paint_box()}_paint_box(){const{ctx:t}=this.layer;t.save();const{left:i,top:o,width:n,height:e}=this.bbox;t.beginPath(),t.rect(i,o,n,e),this.visuals.fill.doit&&(this.visuals.fill.set_value(t),t.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_value(t),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke()),t.restore()}interactive_bbox(){const t=this.model.line_width+o.EDGE_TOLERANCE;return this.bbox.grow_by(t)}interactive_hit(t,i){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,i)}cursor(t,i){const{left:o,right:n,bottom:e,top:s}=this.bbox;return Math.abs(t-o)<3||Math.abs(t-n)<3?this.model.ew_cursor:Math.abs(i-e)<3||Math.abs(i-s)<3?this.model.ns_cursor:this.bbox.contains(t,i)?this.model.in_cursor:null}}o.BoxAnnotationView=u,u.__name__="BoxAnnotationView";class c extends l.Annotation{constructor(t){super(t)}static init_BoxAnnotation(){this.prototype.default_view=u,this.mixins([a.Line,a.Fill,a.Hatch]),this.define((({Number:t,Nullable:i})=>({top:[i(t),null],top_units:[r.SpatialUnits,"data"],bottom:[i(t),null],bottom_units:[r.SpatialUnits,"data"],left:[i(t),null],left_units:[r.SpatialUnits,"data"],right:[i(t),null],right_units:[r.SpatialUnits,"data"],render_mode:[r.RenderMode,"canvas"]}))),this.internal((({Boolean:t,String:i,Nullable:o})=>({screen:[t,!1],ew_cursor:[o(i),null],ns_cursor:[o(i),null],in_cursor:[o(i),null]}))),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}update({left:t,right:i,top:o,bottom:n}){this.setv({left:t,right:i,top:o,bottom:n,screen:!0})}}o.BoxAnnotation=c,c.__name__="BoxAnnotation",c.init_BoxAnnotation()},
function _(t,e,i,a,n){a();const o=t(1),r=t(40),s=t(138),l=t(144),_=t(162),c=t(165),h=t(198),u=t(166),p=t(205),m=t(169),g=t(203),d=t(202),f=t(209),w=t(217),b=t(220),v=t(20),y=o.__importStar(t(48)),k=t(9),x=t(221),C=t(222),j=t(225),z=t(140),L=t(11),S=t(122),M=t(8);class T extends r.AnnotationView{get orientation(){return this._orientation}initialize(){super.initialize();const{ticker:t,formatter:e,color_mapper:i}=this.model;this._ticker="auto"!=t?t:(()=>{switch(!0){case i instanceof f.LogColorMapper:return new h.LogTicker;case i instanceof f.ScanningColorMapper:return new h.BinnedTicker({mapper:i});case i instanceof f.CategoricalColorMapper:return new h.CategoricalTicker;default:return new h.BasicTicker}})(),this._formatter="auto"!=e?e:(()=>{switch(!0){case this._ticker instanceof h.LogTicker:return new p.LogTickFormatter;case i instanceof f.CategoricalColorMapper:return new p.CategoricalTickFormatter;default:return new p.BasicTickFormatter}})(),this._major_range=(()=>{if(i instanceof f.CategoricalColorMapper){const{factors:t}=i;return new b.FactorRange({factors:t})}if(i instanceof d.ContinuousColorMapper){const{min:t,max:e}=i.metrics;return new b.Range1d({start:t,end:e})}L.unreachable()})(),this._major_scale=(()=>{if(i instanceof f.LinearColorMapper)return new w.LinearScale;if(i instanceof f.LogColorMapper)return new w.LogScale;if(i instanceof f.ScanningColorMapper){const{binning:t}=i.metrics;return new w.LinearInterpolationScale({binning:t})}if(i instanceof f.CategoricalColorMapper)return new w.CategoricalScale;L.unreachable()})(),this._minor_range=new b.Range1d({start:0,end:1}),this._minor_scale=new w.LinearScale;const a=y.attrs_of(this.model,"major_label_",y.Text,!0),n=y.attrs_of(this.model,"major_tick_",y.Line,!0),o=y.attrs_of(this.model,"minor_tick_",y.Line,!0),r=y.attrs_of(this.model,"title_",y.Text),l=i instanceof f.CategoricalColorMapper?_.CategoricalAxis:i instanceof f.LogColorMapper?_.LogAxis:_.LinearAxis;this._axis=new l(Object.assign(Object.assign(Object.assign({ticker:this._ticker,formatter:this._formatter,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_standoff:this.model.label_standoff,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,axis_line_color:null},a),n),o));const{title:c}=this.model;c&&(this._title=new s.Title(Object.assign({text:c,standoff:this.model.title_standoff},r)))}async lazy_initialize(){await super.lazy_initialize();const t=this,e={get parent(){return t.parent},get root(){return t.root},get frame(){return t._frame},get canvas_view(){return t.parent.canvas_view},request_layout(){t.parent.request_layout()}};this._axis_view=await S.build_view(this._axis,{parent:e}),null!=this._title&&(this._title_view=await S.build_view(this._title,{parent:e}))}remove(){var t;null===(t=this._title_view)||void 0===t||t.remove(),this._axis_view.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this._ticker.change,(()=>this.request_render())),this.connect(this._formatter.change,(()=>this.request_render())),this.connect(this.model.color_mapper.metrics_change,(()=>{const t=this._major_range,e=this._major_scale,{color_mapper:i}=this.model;if(i instanceof d.ContinuousColorMapper&&t instanceof b.Range1d){const{min:e,max:a}=i.metrics;t.setv({start:e,end:a})}if(i instanceof f.ScanningColorMapper&&e instanceof w.LinearInterpolationScale){const{binning:t}=i.metrics;e.binning=t}this._set_canvas_image(),this.plot_view.request_layout()}))}_set_canvas_image(){const{orientation:t}=this,e=(()=>{const{palette:e}=this.model.color_mapper;return"vertical"==t?k.reversed(e):e})(),[i,a]="vertical"==t?[1,e.length]:[e.length,1],n=this._image=document.createElement("canvas");n.width=i,n.height=a;const o=n.getContext("2d"),r=o.getImageData(0,0,i,a),s=new f.LinearColorMapper({palette:e}).rgba_mapper.v_compute(k.range(0,e.length));r.data.set(s),o.putImageData(r,0,0)}update_layout(){const{location:t,width:e,height:i,padding:a,margin:n}=this.model,[o,r]=(()=>{if(!M.isString(t))return["end","start"];switch(t){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}})(),s=this._orientation=(()=>{const{orientation:t}=this.model;return"auto"==t?null!=this.panel?this.panel.is_horizontal?"horizontal":"vertical":"start"==r||"end"==r||"center"==r&&"center"==o?"vertical":"horizontal":t})(),_=new C.NodeLayout,c=new C.VStack,h=new C.VStack,u=new C.HStack,p=new C.HStack;_.absolute=!0,c.absolute=!0,h.absolute=!0,u.absolute=!0,p.absolute=!0;const[m,g,d,f]=(()=>"horizontal"==s?[this._major_scale,this._minor_scale,this._major_range,this._minor_range]:[this._minor_scale,this._major_scale,this._minor_range,this._major_range])();this._frame=new l.CartesianFrame(m,g,d,f),_.on_resize((t=>this._frame.set_geometry(t)));const w=new j.BorderLayout;this._inner_layout=w,w.absolute=!0,w.center_panel=_,w.top_panel=c,w.bottom_panel=h,w.left_panel=u,w.right_panel=p;const b={left:a,right:a,top:a,bottom:a},v=(()=>{if(null==this.panel){if(M.isString(t))return{left:n,right:n,top:n,bottom:n};{const[e,i]=t;return{left:e,right:n,top:n,bottom:i}}}if(!M.isString(t)){const[e,i]=t;return{left:e,right:0,top:0,bottom:i}}})();let y,k,L,S;if(w.padding=b,null!=this.panel?(y="max",k=void 0,L=void 0,S=void 0):"auto"==("horizontal"==s?e:i)?(y="fixed",k=25*this.model.color_mapper.palette.length,L={percent:.3},S={percent:.8}):(y="fit",k=void 0),"horizontal"==s){const t="auto"==e?void 0:e,a="auto"==i?25:i;w.set_sizing({width_policy:y,height_policy:"min",width:k,min_width:L,max_width:S,halign:r,valign:o,margin:v}),w.center_panel.set_sizing({width_policy:"auto"==e?"fit":"fixed",height_policy:"fixed",width:t,height:a})}else{const t="auto"==e?25:e,a="auto"==i?void 0:i;w.set_sizing({width_policy:"min",height_policy:y,height:k,min_height:L,max_height:S,halign:r,valign:o,margin:v}),w.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==i?"fit":"fixed",width:t,height:a})}c.set_sizing({width_policy:"fit",height_policy:"min"}),h.set_sizing({width_policy:"fit",height_policy:"min"}),u.set_sizing({width_policy:"min",height_policy:"fit"}),p.set_sizing({width_policy:"min",height_policy:"fit"});const{_title_view:T}=this;null!=T&&("horizontal"==s?(T.panel=new z.Panel("above"),T.update_layout(),c.children.push(T.layout)):(T.panel=new z.Panel("left"),T.update_layout(),u.children.push(T.layout)));const{panel:B}=this,A=null!=B&&s==B.orientation?B.side:"horizontal"==s?"below":"right",O=(()=>{switch(A){case"above":return c;case"below":return h;case"left":return u;case"right":return p}})(),{_axis_view:R}=this;if(R.panel=new z.Panel(A),R.update_layout(),O.children.push(R.layout),null!=this.panel){const t=new x.Grid([{layout:w,row:0,col:0}]);t.absolute=!0,"horizontal"==s?t.set_sizing({width_policy:"max",height_policy:"min"}):t.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=t}else this.layout=this._inner_layout;const{visible:F}=this.model;this.layout.sizing.visible=F,this._set_canvas_image()}_render(){var t;const{ctx:e}=this.layer;e.save(),this._paint_bbox(e,this._inner_layout.bbox),this._paint_image(e,this._inner_layout.center_panel.bbox),null===(t=this._title_view)||void 0===t||t.render(),this._axis_view.render(),e.restore()}_paint_bbox(t,e){const{x:i,y:a}=e;let{width:n,height:o}=e;i+n>=this.parent.canvas_view.bbox.width&&(n-=1),a+o>=this.parent.canvas_view.bbox.height&&(o-=1),t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(i,a,n,o)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(i,a,n,o)),t.restore()}_paint_image(t,e){const{x:i,y:a,width:n,height:o}=e;t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this._image,i,a,n,o),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(i,a,n,o)),t.restore()}serializable_state(){const t=super.serializable_state(),{children:e=[]}=t,i=o.__rest(t,["children"]);return null!=this._title_view&&e.push(this._title_view.serializable_state()),e.push(this._axis_view.serializable_state()),Object.assign(Object.assign({},i),{children:e})}}i.ColorBarView=T,T.__name__="ColorBarView";class B extends r.Annotation{constructor(t){super(t)}static init_ColorBar(){this.prototype.default_view=T,this.mixins([["major_label_",y.Text],["title_",y.Text],["major_tick_",y.Line],["minor_tick_",y.Line],["border_",y.Line],["bar_",y.Line],["background_",y.Fill]]),this.define((({Alpha:t,Number:e,String:i,Tuple:a,Dict:n,Or:o,Ref:r,Auto:s,Nullable:l})=>({location:[o(v.Anchor,a(e,e)),"top_right"],orientation:[o(v.Orientation,s),"auto"],title:[l(i),null],title_standoff:[e,2],width:[o(e,s),"auto"],height:[o(e,s),"auto"],scale_alpha:[t,1],ticker:[o(r(c.Ticker),s),"auto"],formatter:[o(r(u.TickFormatter),s),"auto"],major_label_overrides:[n(i),{}],major_label_policy:[r(m.LabelingPolicy),()=>new m.NoOverlap],color_mapper:[r(g.ColorMapper)],label_standoff:[e,5],margin:[e,30],padding:[e,10],major_tick_in:[e,5],major_tick_out:[e,0],minor_tick_in:[e,0],minor_tick_out:[e,0]}))),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})}}i.ColorBar=B,B.__name__="ColorBar",B.init_ColorBar()},
function _(t,e,i,s,l){s();const o=t(1),a=t(139),n=t(20),r=t(143),c=o.__importStar(t(48));class h extends a.TextAnnotationView{_get_location(){const t=this.model.offset,e=this.model.standoff/2;let i,s;const{bbox:l}=this.layout;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":s=l.top+e;break;case"middle":s=l.vcenter;break;case"bottom":s=l.bottom-e}switch(this.model.align){case"left":i=l.left+t;break;case"center":i=l.hcenter;break;case"right":i=l.right-t}break;case"left":switch(this.model.vertical_align){case"top":i=l.left+e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.right-e}switch(this.model.align){case"left":s=l.bottom-t;break;case"center":s=l.vcenter;break;case"right":s=l.top+t}break;case"right":switch(this.model.vertical_align){case"top":i=l.right-e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.left+e}switch(this.model.align){case"left":s=l.top+t;break;case"center":s=l.vcenter;break;case"right":s=l.bottom-t}}return[i,s]}_render(){const{text:t}=this.model;if(null==t||0==t.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[e,i]=this._get_location(),s=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,e,i,s)}_get_size(){const{text:t}=this.model;if(null==t||0==t.length)return{width:0,height:0};{const{ctx:e}=this.layer;this.visuals.text.set_value(e);const{width:i}=this.layer.ctx.measureText(t),{height:s}=r.font_metrics(e.font);return{width:i,height:2+s*this.model.text_line_height+this.model.standoff}}}}i.TitleView=h,h.__name__="TitleView";class _ extends a.TextAnnotation{constructor(t){super(t)}static init_Title(){this.prototype.default_view=h,this.mixins([c.Text,["border_",c.Line],["background_",c.Fill]]),this.define((({Number:t,String:e})=>({text:[e,""],vertical_align:[n.VerticalAlign,"bottom"],align:[n.TextAlign,"left"],offset:[t,0],standoff:[t,10]}))),this.prototype._props.text_align.options.internal=!0,this.prototype._props.text_baseline.options.internal=!0,this.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,border_line_color:null})}}i.Title=_,_.__name__="Title",_.init_Title()},
function _(e,t,s,i,n){i();const l=e(40),a=e(43),o=e(20),r=e(140),d=e(143),c=e(11);class _ extends l.AnnotationView{update_layout(){const{panel:e}=this;this.layout=null!=e?new r.SideLayout(e,(()=>this.get_size()),!0):void 0}initialize(){super.initialize(),"css"==this.model.render_mode&&(this.el=a.div(),this.plot_view.canvas_view.add_overlay(this.el))}remove(){null!=this.el&&a.remove(this.el),super.remove()}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?this.connect(this.model.change,(()=>this.render())):this.connect(this.model.change,(()=>this.request_render()))}render(){this.model.visible||"css"!=this.model.render_mode||a.undisplay(this.el),super.render()}_calculate_text_dimensions(e,t){const{width:s}=e.measureText(t),{height:i}=d.font_metrics(this.visuals.text.font_value());return[s,i]}_calculate_bounding_box_dimensions(e,t){const[s,i]=this._calculate_text_dimensions(e,t);let n,l;switch(e.textAlign){case"left":n=0;break;case"center":n=-s/2;break;case"right":n=-s;break;default:c.unreachable()}switch(e.textBaseline){case"top":l=0;break;case"middle":l=-.5*i;break;case"bottom":l=-1*i;break;case"alphabetic":l=-.8*i;break;case"hanging":l=-.17*i;break;case"ideographic":l=-.83*i;break;default:c.unreachable()}return[n,l,s,i]}_canvas_text(e,t,s,i,n){this.visuals.text.set_value(e);const l=this._calculate_bounding_box_dimensions(e,t);e.save(),e.beginPath(),e.translate(s,i),n&&e.rotate(n),e.rect(l[0],l[1],l[2],l[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(e),e.fillText(t,0,0)),e.restore()}_css_text(e,t,s,i,n){const{el:l}=this;c.assert(null!=l),a.undisplay(l),this.visuals.text.set_value(e);const[o,r]=this._calculate_bounding_box_dimensions(e,t);l.style.position="absolute",l.style.left=`${s+o}px`,l.style.top=`${i+r}px`,l.style.color=e.fillStyle,l.style.font=e.font,l.style.lineHeight="normal",n&&(l.style.transform=`rotate(${n}rad)`),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),l.style.backgroundColor=e.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),l.style.borderStyle=e.lineDash.length<2?"solid":"dashed",l.style.borderWidth=`${e.lineWidth}px`,l.style.borderColor=e.strokeStyle),l.textContent=t,a.display(l)}}s.TextAnnotationView=_,_.__name__="TextAnnotationView";class u extends l.Annotation{constructor(e){super(e)}static init_TextAnnotation(){this.define((()=>({render_mode:[o.RenderMode,"canvas"]})))}}s.TextAnnotation=u,u.__name__="TextAnnotation",u.init_TextAnnotation()},
function _(t,e,i,l,r){l();const a=t(141),o=t(142),n=t(8),h=Math.PI/2,s={above:{parallel:0,normal:-h,horizontal:0,vertical:-h},below:{parallel:0,normal:h,horizontal:0,vertical:h},left:{parallel:-h,normal:0,horizontal:0,vertical:-h},right:{parallel:h,normal:0,horizontal:0,vertical:h}},c={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},g={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},_={above:"right",below:"left",left:"right",right:"left"},b={above:"left",below:"right",left:"right",right:"left"};class z{constructor(t){this.side=t}get dimension(){return"above"==this.side||"below"==this.side?0:1}get normals(){switch(this.side){case"above":return[0,-1];case"below":return[0,1];case"left":return[-1,0];case"right":return[1,0]}}get orientation(){return this.is_horizontal?"horizontal":"vertical"}get is_horizontal(){return 0==this.dimension}get is_vertical(){return 1==this.dimension}get_label_text_heuristics(t){const{side:e}=this;return n.isString(t)?{vertical_align:c[e][t],align:g[e][t]}:{vertical_align:"center",align:(t<0?_:b)[e]}}get_label_angle_heuristic(t){return n.isString(t)?s[this.side][t]:-t}}i.Panel=z,z.__name__="Panel";class m extends o.ContentLayoutable{constructor(t,e,i=!1){super(),this.panel=t,this.get_size=e,this.rotate=i,this.panel.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){const{width:t,height:e}=this.get_size();return!this.rotate||this.panel.is_horizontal?new a.Sizeable({width:t,height:e}):new a.Sizeable({width:e,height:t})}has_size_changed(){const{width:t,height:e}=this._content_size();return this.panel.is_horizontal?this.bbox.height!=e:this.bbox.width!=t}}i.SideLayout=m,m.__name__="SideLayout"},
function _(h,t,i,e,w){e();const n=h(21),{min:d,max:s}=Math;class g{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new g({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new g({width:h!=1/0?s(this.width,h):this.width,height:t!=1/0?s(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=s(this.width,h),this.height=s(this.height,t)}narrowed_to({width:h,height:t}){return new g({width:d(this.width,h),height:d(this.height,t)})}narrow_to({width:h,height:t}){this.width=d(this.width,h),this.height=d(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,n=this.height+i+e;return new g({width:w,height:n})}shrink_by({left:h,right:t,top:i,bottom:e}){const w=s(this.width-h-t,0),n=s(this.height-i-e,0);return new g({width:w,height:n})}map(h,t){return new g({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=g,g.__name__="Sizeable",i.SizingPolicy=n.Enum("fixed","fit","min","max")},
function _(i,t,h,e,n){e();const s=i(141),r=i(99),g=i(8),{min:l,max:a,round:_}=Math;class o{constructor(){this.absolute=!1,this._bbox=new r.BBox,this._inner_bbox=new r.BBox,this._dirty=!1,this._handlers=[]}*[Symbol.iterator](){}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set visible(i){this._sizing.visible=i,this._dirty=!0}set_sizing(i){var t,h,e,n,s;const r=null!==(t=i.width_policy)&&void 0!==t?t:"fit",g=i.width,l=i.min_width,a=i.max_width,_=null!==(h=i.height_policy)&&void 0!==h?h:"fit",o=i.height,d=i.min_height,u=i.max_height,c=i.aspect,w=null!==(e=i.margin)&&void 0!==e?e:{top:0,right:0,bottom:0,left:0},m=!1!==i.visible,x=null!==(n=i.halign)&&void 0!==n?n:"start",b=null!==(s=i.valign)&&void 0!==s?s:"start";this._sizing={width_policy:r,min_width:l,width:g,max_width:a,height_policy:_,min_height:d,height:o,max_height:u,aspect:c,margin:w,visible:m,halign:x,valign:b,size:{width:g,height:o}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){this._set_geometry(i,null!=t?t:i);for(const i of this._handlers)i(this._bbox,this._inner_bbox)}on_resize(i){this._handlers.push(i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:n,height_policy:s}=this.sizing,r=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=n&&"fixed"!=s)if(n==s){const n=t,s=_(t/e),r=_(h*e),g=h;Math.abs(i.width-n)+Math.abs(i.height-s)<=Math.abs(i.width-r)+Math.abs(i.height-g)?(t=n,h=s):(t=r,h=g)}else r(n,s)?h=_(t/e):t=_(h*e);else"fixed"==n?h=_(t/e):"fixed"==s&&(t=_(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=new s.Sizeable(i).shrink_by(this.sizing.margin).map((i=>i==1/0&&"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i),(i=>i==1/0&&"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i)),h=this._measure(t),e=this.clip_size(h,t),n=this.apply_aspect(t,e);return Object.assign(Object.assign({},h),n)}compute(i={}){const t={width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0},h=this.measure(t),{width:e,height:n}=h,s=new r.BBox({left:0,top:0,width:e,height:n});let g;if(null!=h.inner){const{left:i,top:t,right:s,bottom:l}=h.inner;g=new r.BBox({left:i,top:t,right:e-s,bottom:n-l})}this.set_geometry(s,g)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_size(i,t){function h(i,t,h,e){return null==h?h=0:g.isNumber(h)||(h=Math.round(h.percent*t)),null==e?e=1/0:g.isNumber(e)||(e=Math.round(e.percent*t)),a(h,l(i,e))}return{width:h(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:h(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}}has_size_changed(){const{_dirty:i}=this;return this._dirty=!1,i}}h.Layoutable=o,o.__name__="Layoutable";class d extends o{_measure(i){const{width_policy:t,height_policy:h}=this.sizing;return{width:(()=>{const{width:h}=this.sizing;if(i.width==1/0)return null!=h?h:0;switch(t){case"fixed":return null!=h?h:0;case"min":return null!=h?l(i.width,h):0;case"fit":return null!=h?l(i.width,h):i.width;case"max":return null!=h?a(i.width,h):i.width}})(),height:(()=>{const{height:t}=this.sizing;if(i.height==1/0)return null!=t?t:0;switch(h){case"fixed":return null!=t?t:0;case"min":return null!=t?l(i.height,t):0;case"fit":return null!=t?l(i.height,t):i.height;case"max":return null!=t?a(i.height,t):i.height}})()}}}h.LayoutItem=d,d.__name__="LayoutItem";class u extends o{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height)}})()}}}h.ContentLayoutable=u,u.__name__="ContentLayoutable"},
function _(t,e,n,r,a){r();const l=t(11),c=(()=>{try{return"undefined"!=typeof OffscreenCanvas&&null!=new OffscreenCanvas(0,0).getContext("2d")}catch(t){return!1}})()?(t,e)=>new OffscreenCanvas(t,e):(t,e)=>{const n=document.createElement("canvas");return n.width=t,n.height=e,n},o=(()=>{const t=c(0,0).getContext("2d");return e=>{t.font=e;const n=t.measureText("M"),r=t.measureText("x"),a=t.measureText("ÅŚg|"),c=a.fontBoundingBoxAscent,o=a.fontBoundingBoxDescent;if(null!=c&&null!=o)return{height:c+o,ascent:c,descent:o,cap_height:n.actualBoundingBoxAscent,x_height:r.actualBoundingBoxAscent};const s=a.actualBoundingBoxAscent,u=a.actualBoundingBoxDescent;if(null!=s&&null!=u)return{height:s+u,ascent:s,descent:u,cap_height:n.actualBoundingBoxAscent,x_height:r.actualBoundingBoxAscent};l.unreachable()}})(),s=(()=>{const t=c(0,0).getContext("2d");return(e,n)=>{t.font=n;const r=t.measureText(e),a=r.actualBoundingBoxAscent,c=r.actualBoundingBoxDescent;if(null!=a&&null!=c)return{width:r.width,height:a+c,ascent:a,descent:c};l.unreachable()}})(),u=(()=>{const t=document.createElement("canvas"),e=t.getContext("2d");let n=-1,r=-1;return(a,l=1)=>{e.font=a;const{width:c}=e.measureText("M"),o=c*l,s=Math.ceil(o),u=Math.ceil(2*o),i=Math.ceil(1.5*o);n<s&&(n=s,t.width=s),r<u&&(r=u,t.height=u),e.save(),e.scale(l,l),e.fillStyle="#f00",e.fillRect(0,0,s,u);const f=t=>{let e=0;for(let n=0;n<=i;n++)for(let r=0;r<s;r++,e+=4)if(255!=t[e])return i-n;return 0};e.font=a,e.fillStyle="#000";for(const t of"xa")e.fillText(t,0,i/l);const{data:h}=e.getImageData(0,0,s,u),g=f(h)/l;for(const t of"ASQ")e.fillText(t,0,i/l);const{data:d}=e.getImageData(0,0,s,u),x=f(d)/l;for(const t of"ÅŚgy")e.fillText(t,0,i/l);const{data:m}=e.getImageData(0,0,s,u),B=f(m)/l,w=(t=>{let e=t.length-4;for(let n=u;n>=i;n--)for(let r=0;r<s;r++,e-=4)if(255!=t[e])return n-i;return 0})(m)/l;return e.restore(),{height:B+w,ascent:B,cap_height:x,x_height:g,descent:w}}})(),i=(()=>{const t=document.createElement("canvas"),e=t.getContext("2d");let n=-1,r=-1;return(a,l,c=1)=>{e.font=l;const{width:o}=e.measureText("M"),s=o*c,u=Math.ceil(s),i=Math.ceil(2*s),f=Math.ceil(1.5*s);(n<u||r<i)&&(n=u,t.width=u,r=i,t.height=i),e.save(),e.scale(c,c),e.fillStyle="#f00",e.fillRect(0,0,u,i);e.font=l,e.fillStyle="#000",e.fillText(a,0,f/c);const h=e.measureText(a),{data:g}=e.getImageData(0,0,u,i),d=(t=>{let e=0;for(let n=0;n<=f;n++)for(let r=0;r<u;r++,e+=4)if(255!=t[e])return f-n;return 0})(g)/c,x=(t=>{let e=t.length-4;for(let n=i;n>=f;n--)for(let r=0;r<u;r++,e-=4)if(255!=t[e])return n-f;return 0})(g)/c;return e.restore(),{width:h.width,height:d+x,ascent:d,descent:x}}})(),f=(()=>{try{return o("normal 10px sans-serif"),o}catch(t){return u}})(),h=(()=>{try{return s("A","normal 10px sans-serif"),s}catch(t){return i}})(),g=new Map;function d(t){let e=g.get(t);return null==e&&(e={font:f(t),glyphs:new Map},g.set(t,e)),e.font}n.font_metrics=d,n.glyph_metrics=function(t,e){let n=g.get(e);null==n&&(d(e),n=g.get(e));let r=n.glyphs.get(t);return null==r&&(r=h(t,e),n.glyphs.set(t,r)),r}},
function _(e,t,s,_,a){_();const r=e(145),n=e(157),g=e(156),i=e(159),c=e(104),h=e(99),o=e(13),l=e(11);class x{constructor(e,t,s,_,a={},r={}){this.in_x_scale=e,this.in_y_scale=t,this.x_range=s,this.y_range=_,this.extra_x_ranges=a,this.extra_y_ranges=r,this._bbox=new h.BBox,l.assert(null==e.source_range&&null==e.target_range),l.assert(null==t.source_range&&null==t.target_range),this._configure_scales()}get bbox(){return this._bbox}_get_ranges(e,t){return new Map(o.entries(Object.assign(Object.assign({},t),{default:e})))}_get_scales(e,t,s){const _=new Map;for(const[a,g]of t){if(g instanceof c.FactorRange!=e instanceof r.CategoricalScale)throw new Error(`Range ${g.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&g instanceof i.DataRange1d&&(g.scale_hint="log");const t=e.clone();t.setv({source_range:g,target_range:s}),_.set(a,t)}return _}_configure_frame_ranges(){const{bbox:e}=this;this._x_target=new g.Range1d({start:e.left,end:e.right}),this._y_target=new g.Range1d({start:e.bottom,end:e.top})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this._y_ranges,this._y_target)}_update_scales(){this._configure_frame_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}set_geometry(e){this._bbox=e,this._update_scales()}get x_target(){return this._x_target}get y_target(){return this._y_target}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get x_scale(){return this._x_scales.get("default")}get y_scale(){return this._y_scales.get("default")}get xscales(){return o.to_object(this.x_scales)}get yscales(){return o.to_object(this.y_scales)}}s.CartesianFrame=x,x.__name__="CartesianFrame"},
function _(e,t,r,n,_){n();const c=e(146);class s extends c.Scale{constructor(e){super(e)}get s_compute(){const[e,t]=this._linear_compute_state(),r=this.source_range;return n=>e*r.synthetic(n)+t}compute(e){return super._linear_compute(this.source_range.synthetic(e))}v_compute(e){return super._linear_v_compute(this.source_range.v_synthetic(e))}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}r.CategoricalScale=s,s.__name__="CategoricalScale"},
function _(t,e,r,n,s){n();const i=t(147),_=t(105),a=t(156),c=t(24);class o extends i.Transform{constructor(t){super(t)}static init_Scale(){this.internal((({Ref:t})=>({source_range:[t(_.Range)],target_range:[t(a.Range1d)]})))}r_compute(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]}r_invert(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]}_linear_compute(t){const[e,r]=this._linear_compute_state();return e*t+r}_linear_v_compute(t){const[e,r]=this._linear_compute_state(),n=new c.ScreenArray(t.length);for(let s=0;s<t.length;s++)n[s]=e*t[s]+r;return n}_linear_invert(t){const[e,r]=this._linear_compute_state();return(t-r)/e}_linear_v_invert(t){const[e,r]=this._linear_compute_state(),n=new Float64Array(t.length);for(let s=0;s<t.length;s++)n[s]=(t[s]-r)/e;return n}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]}}r.Scale=o,o.__name__="Scale",o.init_Scale()},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(148).CustomJSTransform),n("Dodge",r(150).Dodge),n("Interpolator",r(152).Interpolator),n("Jitter",r(153).Jitter),n("LinearInterpolator",r(154).LinearInterpolator),n("StepInterpolator",r(155).StepInterpolator),n("Transform",r(149).Transform)},
function _(t,r,s,n,e){n();const a=t(149),o=t(13),u=t(34);class m extends a.Transform{constructor(t){super(t)}static init_CustomJSTransform(){this.define((({Unknown:t,String:r,Dict:s})=>({args:[s(t),{}],func:[r,""],v_func:[r,""]})))}get names(){return o.keys(this.args)}get values(){return o.values(this.args)}_make_transform(t,r){return new Function(...this.names,t,u.use_strict(r))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(t){return this.scalar_transform(...this.values,t)}v_compute(t){return this.vector_transform(...this.values,t)}}s.CustomJSTransform=m,m.__name__="CustomJSTransform",m.init_CustomJSTransform()},
function _(n,s,o,r,c){r();const e=n(53);class t extends e.Model{constructor(n){super(n)}}o.Transform=t,t.__name__="Transform"},
function _(e,t,n,o,s){o();const i=e(151);class r extends i.RangeTransform{constructor(e){super(e)}static init_Dodge(){this.define((({Number:e})=>({value:[e,0]})))}_compute(e){return e+this.value}}n.Dodge=r,r.__name__="Dodge",r.init_Dodge()},
function _(e,n,t,r,s){r();const a=e(149),i=e(105),o=e(104),c=e(24),f=e(8);class u extends a.Transform{constructor(e){super(e)}static init_RangeTransform(){this.define((({Ref:e,Nullable:n})=>({range:[n(e(i.Range)),null]})))}v_compute(e){let n;if(this.range instanceof o.FactorRange)n=this.range.v_synthetic(e);else{if(!f.isArrayableOf(e,f.isNumber))throw new Error("unexpected");n=e}const t=new(c.infer_type(n))(n.length);for(let e=0;e<n.length;e++){const r=n[e];t[e]=this._compute(r)}return t}compute(e){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(e));if(f.isNumber(e))return this._compute(e);throw new Error("unexpected")}}t.RangeTransform=u,u.__name__="RangeTransform",u.init_RangeTransform()},
function _(t,e,r,n,o){n();const s=t(149),i=t(57),a=t(24),h=t(9),l=t(8);class d extends s.Transform{constructor(t){super(t),this._sorted_dirty=!0}static init_Interpolator(){this.define((({Boolean:t,Number:e,String:r,Ref:n,Array:o,Or:s,Nullable:a})=>({x:[s(r,o(e))],y:[s(r,o(e))],data:[a(n(i.ColumnarDataSource)),null],clip:[t,!0]})))}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._sorted_dirty=!0))}v_compute(t){const e=new(a.infer_type(t))(t.length);for(let r=0;r<t.length;r++){const n=t[r];e[r]=this.compute(n)}return e}sort(t=!1){if(!this._sorted_dirty)return;let e,r;if(l.isString(this.x)&&l.isString(this.y)&&null!=this.data){const t=this.data.columns();if(!h.includes(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!h.includes(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),r=this.data.get_column(this.y)}else{if(!l.isArray(this.x)||!l.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,r=this.y}if(e.length!==r.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");const n=e.length,o=new Uint32Array(n);for(let t=0;t<n;t++)o[t]=t;const s=t?-1:1;o.sort(((t,r)=>s*(e[t]-e[r]))),this._x_sorted=new(a.infer_type(e))(n),this._y_sorted=new(a.infer_type(r))(n);for(let t=0;t<n;t++)this._x_sorted[t]=e[o[t]],this._y_sorted[t]=r[o[t]];this._sorted_dirty=!1}}r.Interpolator=d,d.__name__="Interpolator",d.init_Interpolator()},
function _(t,i,e,s,r){s();const n=t(1),u=t(151),o=t(20),a=n.__importStar(t(10));class h extends u.RangeTransform{constructor(t){super(t)}static init_Jitter(){this.define((({Number:t})=>({mean:[t,0],width:[t,1],distribution:[o.Distribution,"uniform"]})))}v_compute(t){return null!=this.previous_values&&this.previous_values.length==t.length||(this.previous_values=super.v_compute(t)),this.previous_values}_compute(t){switch(this.distribution){case"uniform":return t+this.mean+(a.random()-.5)*this.width;case"normal":return t+a.rnorm(this.mean,this.width)}}}e.Jitter=h,h.__name__="Jitter",h.init_Jitter()},
function _(t,s,_,r,e){r();const i=t(9),o=t(152);class n extends o.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=i.find_last_index(this._x_sorted,(s=>s<t)),_=this._x_sorted[s],r=this._x_sorted[s+1],e=this._y_sorted[s],o=this._y_sorted[s+1];return e+(t-_)/(r-_)*(o-e)}}_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,s,r,o){r();const i=t(152),_=t(20),n=t(9);class d extends i.Interpolator{constructor(t){super(t)}static init_StepInterpolator(){this.define((()=>({mode:[_.StepMode,"after"]})))}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=n.find_last_index(this._x_sorted,(e=>t>=e));break;case"before":e=n.find_index(this._x_sorted,(e=>t<=e));break;case"center":{const s=n.map(this._x_sorted,(e=>Math.abs(e-t))),r=n.min(s);e=n.find_index(s,(t=>r===t));break}default:throw new Error(`unknown mode: ${this.mode}`)}return-1!=e?this._y_sorted[e]:NaN}}s.StepInterpolator=d,d.__name__="StepInterpolator",d.init_StepInterpolator()},
function _(t,e,s,n,i){n();const a=t(105);class r extends a.Range{constructor(t){super(t)}static init_Range1d(){this.define((({Number:t,Nullable:e})=>({start:[t,0],end:[t,1],reset_start:[e(t),null,{on_update(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[e(t),null,{on_update(t,e){e._reset_end=null!=t?t:e.end}}]})))}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}}initialize(){super.initialize(),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds();const{_reset_start:t,_reset_end:e}=this;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()}map(t){return new r({start:t(this.start),end:t(this.end)})}widen(t){let{start:e,end:s}=this;return this.is_reversed?(e+=t,s-=t):(e-=t,s+=t),new r({start:e,end:s})}}s.Range1d=r,r.__name__="Range1d",r.init_Range1d()},
function _(t,e,o,n,s){n();const a=t(158),r=t(24);class c extends a.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e,o,n]=this._compute_state();return s=>{if(0==o)return 0;{const a=(Math.log(s)-n)/o;return isFinite(a)?a*t+e:NaN}}}compute(t){const[e,o,n,s]=this._compute_state();let a;if(0==n)a=0;else{const r=(Math.log(t)-s)/n;a=isFinite(r)?r*e+o:NaN}return a}v_compute(t){const[e,o,n,s]=this._compute_state(),a=new r.ScreenArray(t.length);if(0==n)for(let e=0;e<t.length;e++)a[e]=0;else for(let r=0;r<t.length;r++){const c=(Math.log(t[r])-s)/n;let l;l=isFinite(c)?c*e+o:NaN,a[r]=l}return a}invert(t){const[e,o,n,s]=this._compute_state(),a=(t-o)/e;return Math.exp(n*a+s)}v_invert(t){const[e,o,n,s]=this._compute_state(),a=new Float64Array(t.length);for(let r=0;r<t.length;r++){const c=(t[r]-o)/e;a[r]=Math.exp(n*c+s)}return a}_get_safe_factor(t,e){let o=t<0?0:t,n=e<0?0:e;if(o==n)if(0==o)[o,n]=[1,10];else{const t=Math.log(o)/Math.log(10);o=10**Math.floor(t),n=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[o,n]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,o=this.target_range.start,n=this.target_range.end-o,[s,a]=this._get_safe_factor(t,e);let r,c;0==s?(r=Math.log(a),c=0):(r=Math.log(a)-Math.log(s),c=Math.log(s));return[n,o,r,c]}}o.LogScale=c,c.__name__="LogScale"},
function _(n,c,o,s,e){s();const t=n(146);class u extends t.Scale{constructor(n){super(n)}}o.ContinuousScale=u,u.__name__="ContinuousScale"},
function _(t,i,n,a,e){a();const s=t(1),l=t(160),_=t(20),o=t(9),h=t(19),r=s.__importStar(t(99)),d=t(161);class u extends l.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}static init_DataRange1d(){this.define((({Boolean:t,Number:i,Nullable:n})=>({start:[i],end:[i],range_padding:[i,.1],range_padding_units:[_.PaddingUnits,"percent"],flipped:[t,!1],follow:[n(_.StartEnd),null],follow_interval:[n(i),null],default_span:[i,2],only_visible:[t,!1]}))),this.internal((({Enum:t})=>({scale_hint:[t("log","auto"),"auto"]})))}initialize(){super.initialize(),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const{renderers:t,names:i}=this,n=o.concat(this.plots.map((t=>t.data_renderers)));return d.compute_renderers(0==t.length?"auto":t,n,i)}_compute_plot_bounds(t,i){let n=r.empty();for(const a of t){const t=i.get(a);null==t||!a.visible&&this.only_visible||(n=r.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=r.empty();let a=t.x1-t.x0;a<=0&&(a=1);let e=t.y1-t.y0;e<=0&&(e=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=s+.5*a,n.x0=s-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n}_compute_min_max(t,i){let n,a,e=r.empty();for(const i of t)e=r.union(e,i);return[n,a]=0==i?[e.x0,e.x1]:[e.y0,e.y1],[n,a]}_compute_range(t,i){const n=this.range_padding;let a,e;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,l;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,h.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${t}`)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,h.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${i}`)),i==t)l=this.default_span+.001,s=Math.log(t)/Math.log(10);else{let a,e;"percent"==this.range_padding_units?(a=Math.log(t)/Math.log(10),e=Math.log(i)/Math.log(10),l=(e-a)*(1+n)):(a=Math.log(t-n)/Math.log(10),e=Math.log(i+n)/Math.log(10),l=e-a),s=(a+e)/2}a=10**(s-l/2),e=10**(s+l/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;a=l-s/2,e=l+s/2}let s=1;this.flipped&&([a,e]=[e,a],s=-1);const l=this.follow_interval;return null!=l&&Math.abs(a-e)>l&&("start"==this.follow?e=a+s*l:"end"==this.follow&&(a=e-s*l)),[a,e]}update(t,i,n,a){if(this.have_updated_interactively)return;const e=this.computed_renderers();let s=this._compute_plot_bounds(e,t);null!=a&&(s=this.adjust_bounds_for_aspect(s,a)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.values(),i);let[o,h]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);let r=!1;"auto"==this.bounds&&(this.setv({bounds:[o,h]},{silent:!0}),r=!0);const[d,u]=[this.start,this.end];if(o!=d||h!=u){const t={};o!=d&&(t.start=o),h!=u&&(t.end=h),this.setv(t),r=!1}r&&this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=u,u.__name__="DataRange1d",u.init_DataRange1d()},
function _(a,e,n,t,r){t();const s=a(105),i=a(62);class R extends s.Range{constructor(a){super(a)}static init_DataRange(){this.define((({String:a,Array:e,Ref:n})=>({names:[e(a),[]],renderers:[e(n(i.DataRenderer)),[]]})))}}n.DataRange=R,R.__name__="DataRange",R.init_DataRange()},
function _(n,e,t,r,u){r();const l=n(9);t.compute_renderers=function(n,e,t){if(null==n)return[];let r="auto"==n?e:n;return t.length>0&&(r=r.filter((n=>l.includes(t,n.name)))),r}},
function _(i,s,x,A,o){A(),o("Axis",i(163).Axis),o("CategoricalAxis",i(170).CategoricalAxis),o("ContinuousAxis",i(173).ContinuousAxis),o("DatetimeAxis",i(174).DatetimeAxis),o("LinearAxis",i(175).LinearAxis),o("LogAxis",i(192).LogAxis),o("MercatorAxis",i(195).MercatorAxis)},
function _(t,e,i,s,o){s();const n=t(1),a=t(164),l=t(165),r=t(166),_=t(169),c=n.__importStar(t(48)),h=t(20),b=t(24),m=t(140),d=t(9),u=t(8),x=t(167),g=t(104),{abs:f}=Math;class p extends a.GuideRendererView{update_layout(){this.layout=new m.SideLayout(this.panel,(()=>this.get_size()),!0)}get_size(){const{visible:t,fixed_location:e}=this.model;if(t&&null==e&&this.is_renderable){const{extents:t}=this;return{width:0,height:Math.round(t.tick+t.tick_label+t.axis_label)}}return{width:0,height:0}}get is_renderable(){const[t,e]=this.ranges;return t.is_valid&&e.is_valid}_render(){var t;if(!this.is_renderable)return;const{tick_coords:e,extents:i}=this,s=this.layer.ctx;s.save(),this._draw_rule(s,i),this._draw_major_ticks(s,i,e),this._draw_minor_ticks(s,i,e),this._draw_major_labels(s,i,e),this._draw_axis_label(s,i,e),null===(t=this._paint)||void 0===t||t.call(this,s,i,e),s.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.plot_view.request_layout()))}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[o,n]=this.coordinates.map_to_screen(i,s),[a,l]=this.normals,[r,_]=this.offsets;this.visuals.axis_line.set_value(t),t.beginPath();for(let e=0;e<o.length;e++){const i=Math.round(o[e]+a*r),s=Math.round(n[e]+l*_);t.lineTo(i,s)}t.stroke()}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,o=this.model.major_tick_out,n=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,o,n)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,o=this.model.minor_tick_out,n=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,o,n)}_draw_major_labels(t,e,i){const s=i.major,o=this.compute_labels(s[this.dimension]),n=this.model.major_label_orientation,a=e.tick+this.model.major_label_standoff,l=this.visuals.major_label_text;this._draw_oriented_labels(t,o,s,n,this.panel.side,a,l)}_axis_label_extent(){const t=this.model.axis_label;if(!t)return 0;const e=new x.TextBox({text:t});e.angle=this.panel.get_label_angle_heuristic("parallel"),e.visuals=this.visuals.axis_label_text;const i=e.size(),s=0==this.dimension?i.height:i.width,o=this.model.axis_label_standoff;return s>0?o+s+3:0}_draw_axis_label(t,e,i){const s=this.model.axis_label;if(!s||null!=this.model.fixed_location)return;const o=new x.TextBox({text:s});o.angle=this.panel.get_label_angle_heuristic("parallel"),o.visuals=this.visuals.axis_label_text;const[n,a]=(()=>{const{bbox:t}=this.layout;switch(this.panel.side){case"above":return[t.hcenter,t.bottom];case"below":return[t.hcenter,t.top];case"left":return[t.right,t.vcenter];case"right":return[t.left,t.vcenter]}})(),[l,r]=this.normals,_=e.tick+e.tick_label+this.model.axis_label_standoff,{vertical_align:c,align:h}=this.panel.get_label_text_heuristics("parallel");o.position={sx:n+l*_,sy:a+r*_,x_anchor:h,y_anchor:c},o.align=h,o.paint(t)}_draw_ticks(t,e,i,s,o){if(!o.doit)return;const[n,a]=e,[l,r]=this.coordinates.map_to_screen(n,a),[_,c]=this.normals,[h,b]=this.offsets,[m,d]=[_*(h-i),c*(b-i)],[u,x]=[_*(h+s),c*(b+s)];o.set_value(t),t.beginPath();for(let e=0;e<l.length;e++){const i=Math.round(l[e]+u),s=Math.round(r[e]+x),o=Math.round(l[e]+m),n=Math.round(r[e]+d);t.moveTo(i,s),t.lineTo(o,n)}t.stroke()}_draw_oriented_labels(t,e,i,s,o,n,a){if(!a.doit||0==e.length)return;const[l,r]=i,[_,c]=this.coordinates.map_to_screen(l,r),[h,m]=this.offsets,[d,u]=this.normals,g=d*(h+n),f=u*(m+n),{vertical_align:p,align:k}=this.panel.get_label_text_heuristics(s),w=this.panel.get_label_angle_heuristic(s);e.visuals=a,e.angle=w;for(let t=0;t<e.length;t++){const i=e.items[t];i.position={sx:_[t]+g,sy:c[t]+f,x_anchor:k,y_anchor:p},i instanceof x.TextBox&&(i.align=k)}const j=e.length,v=b.Indices.all_set(j),{items:y}=e,T=y.map((t=>t.bbox())),O=(()=>{const[t]=this.ranges;return t.is_reversed?0==this.dimension?(t,e)=>T[t].left-T[e].right:(t,e)=>T[e].top-T[t].bottom:0==this.dimension?(t,e)=>T[e].left-T[t].right:(t,e)=>T[t].top-T[e].bottom})(),{major_label_policy:A}=this.model,M=A.filter(v,T,O),z=[...M.ones()];if(0!=z.length){const t=this.parent.canvas_view.bbox,e=e=>{const i=T[e];if(i.left<0){const t=-i.left,{position:s}=y[e];y[e].position=Object.assign(Object.assign({},s),{sx:s.sx+t})}else if(i.right>t.width){const s=i.right-t.width,{position:o}=y[e];y[e].position=Object.assign(Object.assign({},o),{sx:o.sx-s})}},i=e=>{const i=T[e];if(i.top<0){const t=-i.top,{position:s}=y[e];y[e].position=Object.assign(Object.assign({},s),{sy:s.sy+t})}else if(i.bottom>t.height){const s=i.bottom-t.height,{position:o}=y[e];y[e].position=Object.assign(Object.assign({},o),{sy:o.sy-s})}},s=z[0],o=z[z.length-1];0==this.dimension?(e(s),e(o)):(i(s),i(o))}for(const e of M){y[e].paint(t)}}_tick_extent(){return this.model.major_tick_out}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,o=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,s,o)]}get extents(){const t=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:t,tick_label:d.sum(t),axis_label:this._axis_label_extent()}}_oriented_labels_extent(t,e,i,s){if(0==t.length)return 0;const o=this.panel.get_label_angle_heuristic(e);t.visuals=s,t.angle=o;const n=t.max_size(),a=0==this.dimension?n.height:n.width;return a>0?i+a+3:0}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.format_graphics(t,this),{major_label_overrides:i}=this.model;for(let s=0;s<t.length;s++){const o=i[t[s]];null!=o&&(e[s]=new x.TextBox({text:o}))}return new x.GraphicsBoxes(e)}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:t}=this.plot_view;let[e,i]=[0,0];switch(this.panel.side){case"below":i=f(this.layout.bbox.top-t.bbox.bottom);break;case"above":i=f(this.layout.bbox.bottom-t.bbox.top);break;case"right":e=f(this.layout.bbox.left-t.bbox.right);break;case"left":e=f(this.layout.bbox.right-t.bbox.left)}return[e,i]}get ranges(){const t=this.dimension,e=(t+1)%2,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[o,n]=e,[a,l]=i,{min:r,max:_}=Math;return f(o-n)>f(a-l)?(t=_(r(o,n),a),s=r(_(o,n),l)):(t=r(o,n),s=_(o,n)),[t,s]}}get rule_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,o]=this.computed_bounds,n=[new Array(2),new Array(2)];return n[t][0]=Math.max(s,i.min),n[t][1]=Math.min(o,i.max),n[t][0]>n[t][1]&&(n[t][0]=n[t][1]=NaN),n[e][0]=this.loc,n[e][1]=this.loc,n}get tick_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,o]=this.computed_bounds,n=this.model.ticker.get_ticks(s,o,i,this.loc),a=n.major,l=n.minor,r=[[],[]],_=[[],[]],[c,h]=[i.min,i.max];for(let i=0;i<a.length;i++)a[i]<c||a[i]>h||(r[t].push(a[i]),r[e].push(this.loc));for(let i=0;i<l.length;i++)l[i]<c||l[i]>h||(_[t].push(l[i]),_[e].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if(u.isNumber(t))return t;const[,e]=this.ranges;if(e instanceof g.FactorRange)return e.synthetic(t);throw new Error("unexpected")}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}}i.AxisView=p,p.__name__="AxisView";class k extends a.GuideRenderer{constructor(t){super(t)}static init_Axis(){this.prototype.default_view=p,this.mixins([["axis_",c.Line],["major_tick_",c.Line],["minor_tick_",c.Line],["major_label_",c.Text],["axis_label_",c.Text]]),this.define((({Any:t,Int:e,Number:i,String:s,Ref:o,Dict:n,Tuple:a,Or:c,Nullable:b,Auto:m})=>({bounds:[c(a(i,i),m),"auto"],ticker:[o(l.Ticker)],formatter:[o(r.TickFormatter)],axis_label:[b(s),""],axis_label_standoff:[e,5],major_label_standoff:[e,5],major_label_orientation:[c(h.TickLabelOrientation,i),"horizontal"],major_label_overrides:[n(s),{}],major_label_policy:[o(_.LabelingPolicy),()=>new _.AllLabels],major_tick_in:[i,2],major_tick_out:[i,6],minor_tick_in:[i,0],minor_tick_out:[i,4],fixed_location:[b(c(i,t)),null]}))),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})}}i.Axis=k,k.__name__="Axis",k.init_Axis()},
function _(e,r,d,i,n){i();const s=e(41);class t extends s.RendererView{}d.GuideRendererView=t,t.__name__="GuideRendererView";class _ extends s.Renderer{constructor(e){super(e)}static init_GuideRenderer(){this.override({level:"guide"})}}d.GuideRenderer=_,_.__name__="GuideRenderer",_.init_GuideRenderer()},
function _(c,e,n,s,o){s();const r=c(53);class t extends r.Model{constructor(c){super(c)}}n.Ticker=t,t.__name__="Ticker"},
function _(t,o,r,e,c){e();const n=t(53),a=t(167);class m extends n.Model{constructor(t){super(t)}format_graphics(t,o){return this.doFormat(t,o).map((t=>new a.TextBox({text:t})))}compute(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]}v_compute(t,o){return this.doFormat(t,null!=o?o:{loc:0})}}r.TickFormatter=m,m.__name__="TickFormatter"},
function _(t,e,s,i,n){i();const h=t(99),o=t(143),r=t(9),a=t(8),c=t(168),_=t(22);s.text_width=(()=>{const t=document.createElement("canvas").getContext("2d");let e="";return(s,i)=>(i!=e&&(e=i,t.font=i),t.measureText(s).width)})();class l{constructor(){this._position={sx:0,sy:0},this.font_size_scale=1}set position(t){this._position=t}get position(){return this._position}infer_text_height(){return"ascent_descent"}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),o=Math.min(t.y,e.y,s.y,i.y),r=Math.max(t.x,e.x,s.x,i.x),a=Math.max(t.y,e.y,s.y,i.y);return new h.BBox({left:n,right:r,top:o,bottom:a})}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(s){const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}return{width:t,height:e}}rect(){const t=this._rect(),{angle:e}=this;if(e){const{sx:s,sy:i}=this.position,n=new c.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}return t}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}}s.GraphicsBox=l,l.__name__="GraphicsBox";class x extends l{constructor({text:t}){super(),this.align="left",this.text=t}set visuals(t){const e=t.text_color.get_value(),s=t.text_alpha.get_value(),i=t.text_font_style.get_value();let n=t.text_font_size.get_value();const h=t.text_font.get_value(),{font_size_scale:o}=this;if(1!=o){const t=n.match(/^\s*(\d+(\.\d+)?)px\s*$/);if(null!=t){const[,e]=t,s=Number(e);isNaN(s)||(n=s*o+"px")}}const r=`${i} ${n} ${h}`;this.font=r,this.color=_.color2css(e,s),this.line_height=t.text_line_height.get_value()}infer_text_height(){if(this.text.includes("\n"))return"ascent_descent";return function(t){for(const e of new Set(t))if(!("0"<=e&&e<="9"))switch(e){case",":case".":case"+":case"-":case"−":case"e":continue;default:return!1}return!0}(this.text)?"cap":"ascent_descent"}_text_line(t){var e;const s=null!==(e=this.text_height_metric)&&void 0!==e?e:this.infer_text_height(),i=(()=>{switch(s){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}})(),n=(()=>{switch(s){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}})();return{height:i+n,ascent:i,descent:n}}get nlines(){return this.text.split("\n").length}_size(){var t,e;const{font:i}=this,n=o.font_metrics(i),h=(this.line_height-1)*n.height,a=""==this.text,c=this.text.split("\n"),_=c.length,l=c.map((t=>s.text_width(t,i))),x=this._text_line(n).height*_,u="%"==(null===(t=this.width)||void 0===t?void 0:t.unit)?this.width.value:1,p="%"==(null===(e=this.height)||void 0===e?void 0:e.unit)?this.height.value:1;return{width:r.max(l)*u,height:a?0:(x+h*(_-1))*p,metrics:n}}_computed_position(t,e,s){const{width:i,height:n}=t,{sx:h,sy:o,x_anchor:r="left",y_anchor:c="center"}=this.position;return{x:h-(()=>{if(a.isNumber(r))return r*i;switch(r){case"left":return 0;case"center":return.5*i;case"right":return i}})(),y:o-(()=>{var t;if(a.isNumber(c))return c*n;switch(c){case"top":return 0;case"center":return.5*n;case"bottom":return n;case"baseline":if(1!=s)return.5*n;switch(null!==(t=this.text_height_metric)&&void 0!==t?t:this.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}})()}}_rect(){const{width:t,height:e,metrics:s}=this._size(),i=this.text.split("\n").length,{x:n,y:o}=this._computed_position({width:t,height:e},s,i);return new h.BBox({x:n,y:o,width:t,height:e}).rect}paint(t){var e,i;const{font:n}=this,h=o.font_metrics(n),a=(this.line_height-1)*h.height,c=this.text.split("\n"),_=c.length,l=c.map((t=>s.text_width(t,n))),x=this._text_line(h),u=x.height*_,p="%"==(null===(e=this.width)||void 0===e?void 0:e.unit)?this.width.value:1,g="%"==(null===(i=this.height)||void 0===i?void 0:i.unit)?this.height.value:1,f=r.max(l)*p,d=(u+a*(_-1))*g;t.save(),t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";const{sx:m,sy:b}=this.position,{align:y}=this,{angle:w}=this;w&&(t.translate(m,b),t.rotate(w),t.translate(-m,-b));let{x:v,y:z}=this._computed_position({width:f,height:d},h,_);if("justify"==y)for(let e=0;e<_;e++){let i=v;const h=c[e].split(" "),o=h.length,_=h.map((t=>s.text_width(t,n))),l=(f-r.sum(_))/(o-1);for(let e=0;e<o;e++)t.fillText(h[e],i,z),i+=_[e]+l;z+=x.height+a}else for(let e=0;e<_;e++){const s=v+(()=>{switch(y){case"left":return 0;case"center":return.5*(f-l[e]);case"right":return f-l[e]}})();t.fillStyle=this.color,t.fillText(c[e],s,z+x.ascent),z+=x.height+a}t.restore()}}s.TextBox=x,x.__name__="TextBox";class u extends l{constructor(t,e){super(),this.base=t,this.expo=e}get children(){return[this.base,this.expo]}set position(t){this._position=t;const e=this.base.size(),s=this.expo.size(),i=this._shift_scale()*e.height,n=Math.max(e.height,i+s.height);this.base.position={sx:0,x_anchor:"left",sy:n,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:i,y_anchor:"bottom"}}get position(){return this._position}set visuals(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t}_shift_scale(){if(this.base instanceof x&&1==this.base.nlines){const{x_height:t,cap_height:e}=o.font_metrics(this.base.font);return t/e}return 2/3}infer_text_height(){return this.base.infer_text_height()}_rect(){const t=this.base.bbox(),e=this.expo.bbox(),s=t.union(e),{x:i,y:n}=this._computed_position();return s.translate(i,n).rect}_size(){const t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}}paint(t){t.save();const{angle:e}=this;if(e){const{sx:s,sy:i}=this.position;t.translate(s,i),t.rotate(e),t.translate(-s,-i)}const{x:s,y:i}=this._computed_position();t.translate(s,i),this.base.paint(t),this.expo.paint(t),t.restore()}paint_bbox(t){super.paint_bbox(t);const{x:e,y:s}=this._computed_position();t.save(),t.translate(e,s);for(const e of this.children)e.paint_bbox(t);t.restore()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n="left",y_anchor:h="center"}=this.position;return{x:s-(()=>{if(a.isNumber(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if(a.isNumber(h))return h*e;switch(h){case"top":return 0;case"center":return.5*e;case"bottom":return e;case"baseline":return.5*e}})()}}}s.BaseExpo=u,u.__name__="BaseExpo";class p{constructor(t){this.items=t}get length(){return this.items.length}set visuals(t){for(const e of this.items)e.visuals=t;const e={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},s=r.max_by(this.items.map((t=>t.infer_text_height())),(t=>e[t]));for(const t of this.items)t.text_height_metric=s}set angle(t){for(const e of this.items)e.angle=t}max_size(){let t=0,e=0;for(const s of this.items){const i=s.size();t=Math.max(t,i.width),e=Math.max(e,i.height)}return{width:t,height:e}}}s.GraphicsBoxes=p,p.__name__="GraphicsBoxes"},
function _(t,s,r,n,i){n();const{sin:e,cos:a}=Math;class h{constructor(t=1,s=0,r=0,n=1,i=0,e=0){this.a=t,this.b=s,this.c=r,this.d=n,this.e=i,this.f=e}toString(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return`matrix(${t}, ${s}, ${r}, ${n}, ${i}, ${e})`}clone(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return new h(t,s,r,n,i,e)}get is_identity(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return 1==t&&0==s&&0==r&&1==n&&0==i&&0==e}apply_point(t){const[s,r]=this.apply(t.x,t.y);return{x:s,y:r}}apply_rect(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}}apply(t,s){const{a:r,b:n,c:i,d:e,e:a,f:h}=this;return[r*t+i*s+a,n*t+e*s+h]}iv_apply(t,s){const{a:r,b:n,c:i,d:e,e:a,f:h}=this,p=t.length;for(let o=0;o<p;o++){const p=t[o],c=s[o];t[o]=r*p+i*c+a,s[o]=n*p+e*c+h}}transform(t,s,r,n,i,e){const{a,b:h,c:p,d:o,e:c,f:l}=this;return this.a=a*t+p*s,this.c=a*r+p*n,this.e=a*i+p*e+c,this.b=h*t+o*s,this.d=h*r+o*n,this.f=h*i+o*e+l,this}translate(t,s){return this.transform(1,0,0,1,t,s)}scale(t,s){return this.transform(t,0,0,s,0,0)}skew(t,s){return this.transform(1,s,t,1,0,0)}rotate(t){const s=e(t),r=a(t);return this.transform(r,s,-s,r,0,0)}rotate_ccw(t){return this.rotate(-t)}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}}r.AffineTransform=h,h.__name__="AffineTransform"},
function _(e,n,s,t,i){t();const l=e(53),c=e(13),o=e(34),r=e(8),a=e(24);class u extends l.Model{constructor(e){super(e)}}s.LabelingPolicy=u,u.__name__="LabelingPolicy";class _ extends u{constructor(e){super(e)}filter(e,n,s){return e}}s.AllLabels=_,_.__name__="AllLabels";class d extends u{constructor(e){super(e)}static init_NoOverlap(){this.define((({Number:e})=>({min_distance:[e,5]})))}filter(e,n,s){const{min_distance:t}=this;let i=null;for(const n of e)null!=i&&s(i,n)<t?e.unset(n):i=n;return e}}s.NoOverlap=d,d.__name__="NoOverlap",d.init_NoOverlap();class m extends u{constructor(e){super(e)}static init_CustomLabelingPolicy(){this.define((({Unknown:e,String:n,Dict:s})=>({args:[s(e),{}],code:[n,""]})))}get names(){return c.keys(this.args)}get values(){return c.values(this.args)}get func(){const e=o.use_strict(this.code);return new a.GeneratorFunction("indices","bboxes","distance",...this.names,e)}filter(e,n,s){const t=Object.create(null),i=this.func.call(t,e,n,s,...this.values);let l=i.next();if(l.done&&void 0!==l.value){const{value:n}=l;return n instanceof a.Indices?n:void 0===n?e:r.isIterable(n)?a.Indices.from_indices(e.size,n):a.Indices.all_unset(e.size)}{const n=[];do{n.push(l.value),l=i.next()}while(!l.done);return a.Indices.from_indices(e.size,n)}}}s.CustomLabelingPolicy=m,m.__name__="CustomLabelingPolicy",m.init_CustomLabelingPolicy()},
function _(t,s,e,o,i){o();const a=t(1),r=t(163),l=t(171),_=t(172),n=a.__importStar(t(48)),c=t(20),p=t(167),h=t(8);class m extends r.AxisView{_paint(t,s,e){this._draw_group_separators(t,s,e)}_draw_group_separators(t,s,e){const[o]=this.ranges,[i,a]=this.computed_bounds;if(!o.tops||o.tops.length<2||!this.visuals.separator_line.doit)return;const r=this.dimension,l=(r+1)%2,_=[[],[]];let n=0;for(let t=0;t<o.tops.length-1;t++){let s,e;for(let i=n;i<o.factors.length;i++)if(o.factors[i][0]==o.tops[t+1]){[s,e]=[o.factors[i-1],o.factors[i]],n=i;break}const c=(o.synthetic(s)+o.synthetic(e))/2;c>i&&c<a&&(_[r].push(c),_[l].push(this.loc))}const c=this.extents.tick_label;this._draw_ticks(t,_,-3,c-6,this.visuals.separator_line)}_draw_major_labels(t,s,e){const o=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let e=0;e<o.length;e++){const[a,r,l,_]=o[e];this._draw_oriented_labels(t,a,r,l,this.panel.side,i,_),i+=s.tick_labels[e]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[e,,o,i]of t){const t=this._oriented_labels_extent(e,o,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,e]=this.computed_bounds,o=this.loc,i=this.model.ticker.get_ticks(s,e,t,o),a=this.tick_coords,r=[],l=t=>new p.GraphicsBoxes(t.map((t=>h.isString(t)?new p.TextBox({text:t}):t))),_=t=>l(this.model.formatter.doFormat(t,this));if(1==t.levels){const t=_(i.major);r.push([t,a.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=_(i.major.map((t=>t[1])));r.push([t,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),r.push([l(i.tops),a.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=_(i.major.map((t=>t[2]))),s=i.mids.map((t=>t[1]));r.push([t,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),r.push([l(s),a.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),r.push([l(i.tops),a.tops,this.model.group_label_orientation,this.visuals.group_text])}return r}get tick_coords(){const t=this.dimension,s=(t+1)%2,[e]=this.ranges,[o,i]=this.computed_bounds,a=this.model.ticker.get_ticks(o,i,e,this.loc),r={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return r.major[t]=a.major,r.major[s]=a.major.map((()=>this.loc)),3==e.levels&&(r.mids[t]=a.mids,r.mids[s]=a.mids.map((()=>this.loc))),e.levels>1&&(r.tops[t]=a.tops,r.tops[s]=a.tops.map((()=>this.loc))),r}}e.CategoricalAxisView=m,m.__name__="CategoricalAxisView";class u extends r.Axis{constructor(t){super(t)}static init_CategoricalAxis(){this.prototype.default_view=m,this.mixins([["separator_",n.Line],["group_",n.Text],["subgroup_",n.Text]]),this.define((({Number:t,Or:s})=>({group_label_orientation:[s(c.TickLabelOrientation,t),"parallel"],subgroup_label_orientation:[s(c.TickLabelOrientation,t),"parallel"]}))),this.override({ticker:()=>new l.CategoricalTicker,formatter:()=>new _.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})}}e.CategoricalAxis=u,u.__name__="CategoricalAxis",u.init_CategoricalAxis()},
function _(t,c,o,s,e){s();const r=t(165);class i extends r.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s){var e,r;return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(null!==(e=o.tops)&&void 0!==e?e:[],o,t,c),mids:this._collect(null!==(r=o.mids)&&void 0!==r?r:[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,c,a){c();const e=t(166),n=t(9);class i extends e.TickFormatter{constructor(t){super(t)}doFormat(t,r){return n.copy(t)}}o.CategoricalTickFormatter=i,i.__name__="CategoricalTickFormatter"},
function _(s,n,i,o,u){o();const e=s(163);class t extends e.AxisView{}i.ContinuousAxisView=t,t.__name__="ContinuousAxisView";class _ extends e.Axis{constructor(s){super(s)}}i.ContinuousAxis=_,_.__name__="ContinuousAxis"},
function _(e,t,i,s,a){s();const n=e(175),r=e(180),m=e(185);class _ extends n.LinearAxisView{}i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";class c extends n.LinearAxis{constructor(e){super(e)}static init_DatetimeAxis(){this.prototype.default_view=_,this.override({ticker:()=>new m.DatetimeTicker,formatter:()=>new r.DatetimeTickFormatter})}}i.DatetimeAxis=c,c.__name__="DatetimeAxis",c.init_DatetimeAxis()},
function _(i,e,s,n,t){n();const r=i(173),a=i(176),o=i(177);class c extends r.ContinuousAxisView{}s.LinearAxisView=c,c.__name__="LinearAxisView";class _ extends r.ContinuousAxis{constructor(i){super(i)}static init_LinearAxis(){this.prototype.default_view=c,this.override({ticker:()=>new o.BasicTicker,formatter:()=>new a.BasicTickFormatter})}}s.LinearAxis=_,_.__name__="LinearAxis",_.init_LinearAxis()},
function _(i,t,e,n,o){n();const s=i(166),r=i(34);function c(i){let t="";for(const e of i)t+="-"==e?"−":e;return t}e.unicode_replace=c;class _ extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}static init_BasicTickFormatter(){this.define((({Boolean:i,Int:t,Auto:e,Or:n})=>({precision:[n(t,e),"auto"],use_scientific:[i,!0],power_limit_high:[t,5],power_limit_low:[t,-3]})))}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,n=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const o of i){const i=Math.abs(o);if(!(i<=n)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){return t?i.map((i=>c(i.toExponential(e)))):i.map((i=>c(r.to_fixed(i,e))))}_auto_precision(i,t){const e=new Array(i.length),n=this.last_precision<=15;i:for(let o=this.last_precision;n?o<=15:o>=1;n?o++:o--){if(t){e[0]=i[0].toExponential(o);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=o;break}e[0]=r.to_fixed(i[0],o);for(let t=1;t<i.length;t++)if(e[t]=r.to_fixed(i[t],o),e[t]==e[t-1])continue i;this.last_precision=o;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),n="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,n)}}e.BasicTickFormatter=_,_.__name__="BasicTickFormatter",_.init_BasicTickFormatter()},
function _(c,e,s,i,n){i();const r=c(178);class t extends r.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=t,t.__name__="BasicTicker"},
function _(t,i,a,e,s){e();const n=t(179),r=t(9),_=t(10);class l extends n.ContinuousTicker{constructor(t){super(t)}static init_AdaptiveTicker(){this.define((({Number:t,Array:i,Nullable:a})=>({base:[t,10],mantissas:[i(t),[1,2,5]],min_interval:[t,0],max_interval:[a(t),null]})))}get_min_interval(){return this.min_interval}get_max_interval(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0}initialize(){super.initialize();const t=r.nth(this.mantissas,-1)/this.base,i=r.nth(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,a){const e=i-t,s=this.get_ideal_interval(t,i,a),n=Math.floor(_.log(s/this.base_factor,this.base)),l=this.base**n*this.base_factor,h=this.extended_mantissas,m=h.map((t=>Math.abs(a-e/(t*l)))),v=h[r.argmin(m)]*l;return _.clamp(v,this.get_min_interval(),this.get_max_interval())}}a.AdaptiveTicker=l,l.__name__="AdaptiveTicker",l.init_AdaptiveTicker()},
function _(t,i,n,s,e){s();const o=t(165),r=t(9);class c extends o.Ticker{constructor(t){super(t)}static init_ContinuousTicker(){this.define((({Int:t})=>({num_minor_ticks:[t,5],desired_num_ticks:[t,6]})))}get_ticks(t,i,n,s){return this.get_ticks_no_defaults(t,i,s,this.desired_num_ticks)}get_ticks_no_defaults(t,i,n,s){const e=this.get_interval(t,i,s),o=Math.floor(t/e),c=Math.ceil(i/e);let _;_=isFinite(o)&&isFinite(c)?r.range(o,c+1):[];const u=_.map((t=>t*e)).filter((n=>t<=n&&n<=i)),a=this.num_minor_ticks,f=[];if(a>0&&u.length>0){const n=e/a,s=r.range(0,a).map((t=>t*n));for(const n of s.slice(1)){const s=u[0]-n;t<=s&&s<=i&&f.push(s)}for(const n of u)for(const e of s){const s=n+e;t<=s&&s<=i&&f.push(s)}}return{major:u,minor:f}}get_ideal_interval(t,i,n){return(i-t)/n}}n.ContinuousTicker=c,c.__name__="ContinuousTicker",c.init_ContinuousTicker()},
function _(t,s,e,i,n){i();const r=t(1).__importDefault(t(181)),o=t(166),a=t(19),c=t(182),m=t(9),u=t(8);function h(t){return r.default(t,"%Y %m %d %H %M %S").split(/\s+/).map((t=>parseInt(t,10)))}function d(t,s){if(u.isFunction(s))return s(t);{const e=c.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(s=s.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?s:r.default(t,s)}}const l=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"];class f extends o.TickFormatter{constructor(t){super(t),this.strip_leading_zeros=!0}static init_DatetimeTickFormatter(){this.define((({String:t,Array:s})=>({microseconds:[s(t),["%fus"]],milliseconds:[s(t),["%3Nms","%S.%3Ns"]],seconds:[s(t),["%Ss"]],minsec:[s(t),[":%M:%S"]],minutes:[s(t),[":%M","%Mm"]],hourmin:[s(t),["%H:%M"]],hours:[s(t),["%Hh","%H:%M"]],days:[s(t),["%m/%d","%a%d"]],months:[s(t),["%m/%Y","%b %Y"]],years:[s(t),["%Y"]]})))}initialize(){super.initialize(),this._update_width_formats()}_update_width_formats(){const t=+r.default(new Date),s=function(s){const e=s.map((s=>d(t,s).length)),i=m.sort_by(m.zip(e,s),(([t])=>t));return m.unzip(i)};this._width_formats={microseconds:s(this.microseconds),milliseconds:s(this.milliseconds),seconds:s(this.seconds),minsec:s(this.minsec),minutes:s(this.minutes),hourmin:s(this.hourmin),hours:s(this.hours),days:s(this.days),months:s(this.months),years:s(this.years)}}_get_resolution_str(t,s){const e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return s>=60?"minsec":"seconds";case!(e<3600):return s>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}}doFormat(t,s){if(0==t.length)return[];const e=Math.abs(t[t.length-1]-t[0])/1e3,i=e/(t.length-1),n=this._get_resolution_str(i,e),[,[r]]=this._width_formats[n],o=[],c=l.indexOf(n),m={};for(const t of l)m[t]=0;m.seconds=5,m.minsec=4,m.minutes=4,m.hourmin=3,m.hours=3;for(const s of t){let t,e;try{e=h(s),t=d(s,r)}catch(t){a.logger.warn(`unable to format tick for timestamp value ${s}`),a.logger.warn(` - ${t}`),o.push("ERR");continue}let i=!1,u=c;for(;0==e[m[l[u]]];){let r;if(u+=1,u==l.length)break;if(("minsec"==n||"hourmin"==n)&&!i){if("minsec"==n&&0==e[4]&&0!=e[5]||"hourmin"==n&&0==e[3]&&0!=e[4]){r=this._width_formats[l[c-1]][1][0],t=d(s,r);break}i=!0}r=this._width_formats[l[u]][1][0],t=d(s,r)}if(this.strip_leading_zeros){let s=t.replace(/^0+/g,"");s!=t&&isNaN(parseInt(s))&&(s=`0${s}`),o.push(s)}else o.push(t)}return o}}e.DatetimeTickFormatter=f,f.__name__="DatetimeTickFormatter",f.init_DatetimeTickFormatter()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,t,n,e,i){e();const u=r(1),a=u.__importStar(r(183)),f=r(184),o=u.__importDefault(r(181)),l=r(21),s=r(8);function c(r,...t){return f.sprintf(r,...t)}function m(r,t,n){if(s.isNumber(r)){return c((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return`${r}`}function p(r,t,e){if(null==t)return m;if(null!=e&&r in e){const t=e[r];if(s.isString(t)){if(t in n.DEFAULT_FORMATTERS)return n.DEFAULT_FORMATTERS[t];throw new Error(`Unknown tooltip field formatter type '${t}'`)}return function(r,n,e){return t.format(r,n,e)}}return n.DEFAULT_FORMATTERS.numeral}function d(r,t,n,e){if("$"==r[0]){return function(r,t){if(r in t)return t[r];throw new Error(`Unknown special variable '$${r}'`)}(r.substring(1),e)}return function(r,t,n){const e=t.get_column(r);if(null==e)return null;if(s.isNumber(n))return e[n];const i=e[n.index];if(s.isTypedArray(i)||s.isArray(i))return s.isArray(i[0])?i[n.dim2][n.dim1]:i[n.flat_index];return i}(r.substring(1).replace(/[{}]/g,""),t,n)}n.FormatterType=l.Enum("numeral","printf","datetime"),n.DEFAULT_FORMATTERS={numeral:(r,t,n)=>a.format(r,t),datetime:(r,t,n)=>o.default(r,t),printf:(r,t,n)=>c(t,r)},n.sprintf=c,n.basic_formatter=m,n.get_formatter=p,n.get_value=d,n.replace_placeholders=function(r,t,n,e,i={},u){let a,f;if(s.isString(r)?(a=r,f=!1):(a=r.html,f=!0),a=a.replace(/@\$name/g,(r=>`@{${i.name}}`)),a=a.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,((r,a,o)=>{const l=d(a,t,n,i);if(null==l)return u?u("???"):"???";if("safe"==o)return f=!0,`${l}`;const s=`${p(a,o,e)(l,o,i)}`;return u?u(s):s})),f){return[...(new DOMParser).parseFromString(a,"text/html").body.childNodes]}return a}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t)}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,i,n,t,a){t();const s=e(9),r=e(178),c=e(186),m=e(187),_=e(190),k=e(191),o=e(189);class T extends c.CompositeTicker{constructor(e){super(e)}static init_DatetimeTicker(){this.override({num_minor_ticks:0,tickers:()=>[new r.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*o.ONE_MILLI,num_minor_ticks:0}),new r.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:o.ONE_SECOND,max_interval:30*o.ONE_MINUTE,num_minor_ticks:0}),new r.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:o.ONE_HOUR,max_interval:12*o.ONE_HOUR,num_minor_ticks:0}),new m.DaysTicker({days:s.range(1,32)}),new m.DaysTicker({days:s.range(1,31,3)}),new m.DaysTicker({days:[1,8,15,22]}),new m.DaysTicker({days:[1,15]}),new _.MonthsTicker({months:s.range(0,12,1)}),new _.MonthsTicker({months:s.range(0,12,2)}),new _.MonthsTicker({months:s.range(0,12,4)}),new _.MonthsTicker({months:s.range(0,12,6)}),new k.YearsTicker({})]})}}n.DatetimeTicker=T,T.__name__="DatetimeTicker",T.init_DatetimeTicker()},
function _(t,e,i,s,r){s();const n=t(179),_=t(9);class a extends n.ContinuousTicker{constructor(t){super(t)}static init_CompositeTicker(){this.define((({Array:t,Ref:e})=>({tickers:[t(e(n.ContinuousTicker)),[]]})))}get min_intervals(){return this.tickers.map((t=>t.get_min_interval()))}get max_intervals(){return this.tickers.map((t=>t.get_max_interval()))}get_min_interval(){return this.min_intervals[0]}get_max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const s=e-t,r=this.get_ideal_interval(t,e,i),n=[_.sorted_index(this.min_intervals,r)-1,_.sorted_index(this.max_intervals,r)],a=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map((t=>Math.abs(i-s/t)));let c;if(_.is_empty(a.filter((t=>!isNaN(t)))))c=this.tickers[0];else{const t=n[_.argmin(a)];c=this.tickers[t]}return c}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,s){return this.get_best_ticker(t,e,s).get_ticks_no_defaults(t,e,i,s)}}i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,e,n,i,s){i();const a=t(188),o=t(189),r=t(9);class c extends a.SingleIntervalTicker{constructor(t){super(t)}static init_DaysTicker(){this.define((({Int:t,Array:e})=>({days:[e(t),[]]}))),this.override({num_minor_ticks:0})}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*o.ONE_DAY:this.interval=31*o.ONE_DAY}get_ticks_no_defaults(t,e,n,i){const s=function(t,e){const n=o.last_month_no_later_than(new Date(t)),i=o.last_month_no_later_than(new Date(e));i.setUTCMonth(i.getUTCMonth()+1);const s=[],a=n;for(;s.push(o.copy_date(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>i););return s}(t,e),a=this.days,c=this.interval;return{major:r.concat(s.map((t=>((t,e)=>{const n=t.getUTCMonth(),i=[];for(const s of a){const a=o.copy_date(t);a.setUTCDate(s),new Date(a.getTime()+e/2).getUTCMonth()==n&&i.push(a)}return i})(t,c)))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.DaysTicker=c,c.__name__="DaysTicker",c.init_DaysTicker()},
function _(e,t,n,i,r){i();const l=e(179);class a extends l.ContinuousTicker{constructor(e){super(e)}static init_SingleIntervalTicker(){this.define((({Number:e})=>({interval:[e]})))}get_interval(e,t,n){return this.interval}get_min_interval(){return this.interval}get_max_interval(){return this.interval}}n.SingleIntervalTicker=a,a.__name__="SingleIntervalTicker",a.init_SingleIntervalTicker()},
function _(t,n,e,_,E){function N(t){return new Date(t.getTime())}function O(t){const n=N(t);return n.setUTCDate(1),n.setUTCHours(0),n.setUTCMinutes(0),n.setUTCSeconds(0),n.setUTCMilliseconds(0),n}_(),e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY,e.copy_date=N,e.last_month_no_later_than=O,e.last_year_no_later_than=function(t){const n=O(t);return n.setUTCMonth(0),n}},
function _(t,e,n,i,s){i();const r=t(188),a=t(189),o=t(9);class c extends r.SingleIntervalTicker{constructor(t){super(t)}static init_MonthsTicker(){this.define((({Int:t,Array:e})=>({months:[e(t),[]]})))}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*a.ONE_MONTH:this.interval=12*a.ONE_MONTH}get_ticks_no_defaults(t,e,n,i){const s=function(t,e){const n=a.last_year_no_later_than(new Date(t)),i=a.last_year_no_later_than(new Date(e));i.setUTCFullYear(i.getUTCFullYear()+1);const s=[],r=n;for(;s.push(a.copy_date(r)),r.setUTCFullYear(r.getUTCFullYear()+1),!(r>i););return s}(t,e),r=this.months;return{major:o.concat(s.map((t=>r.map((e=>{const n=a.copy_date(t);return n.setUTCMonth(e),n}))))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.MonthsTicker=c,c.__name__="MonthsTicker",c.init_MonthsTicker()},
function _(e,t,a,i,r){i();const n=e(177),_=e(188),s=e(189);class c extends _.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=s.ONE_YEAR,this.basic_ticker=new n.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=s.last_year_no_later_than(new Date(e)).getUTCFullYear(),n=s.last_year_no_later_than(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,n,a,i).major.map((e=>Date.UTC(e,0,1))).filter((a=>e<=a&&a<=t)),minor:[]}}}a.YearsTicker=c,c.__name__="YearsTicker"},
function _(i,s,t,e,o){e();const n=i(173),r=i(193),_=i(194);class c extends n.ContinuousAxisView{}t.LogAxisView=c,c.__name__="LogAxisView";class x extends n.ContinuousAxis{constructor(i){super(i)}static init_LogAxis(){this.prototype.default_view=c,this.override({ticker:()=>new _.LogTicker,formatter:()=>new r.LogTickFormatter})}}t.LogAxis=x,x.__name__="LogAxis",x.init_LogAxis()},
function _(t,e,r,i,n){i();const o=t(166),a=t(176),s=t(194),c=t(167),{log:l,round:u}=Math;class _ extends o.TickFormatter{constructor(t){super(t)}static init_LogTickFormatter(){this.define((({Ref:t,Nullable:e})=>({ticker:[e(t(s.LogTicker)),null]})))}initialize(){super.initialize(),this.basic_formatter=new a.BasicTickFormatter}format_graphics(t,e){var r,i;if(0==t.length)return[];const n=null!==(i=null===(r=this.ticker)||void 0===r?void 0:r.base)&&void 0!==i?i:10,o=this._exponents(t,n);return null==o?this.basic_formatter.format_graphics(t,e):o.map((t=>{const e=new c.TextBox({text:a.unicode_replace(`${n}`)}),r=new c.TextBox({text:a.unicode_replace(`${t}`)});return new c.BaseExpo(e,r)}))}_exponents(t,e){let r=null;const i=[];for(const n of t){const t=u(l(n)/l(e));if(r==t)return null;r=t,i.push(t)}return i}doFormat(t,e){var r,i;if(0==t.length)return[];const n=null!==(i=null===(r=this.ticker)||void 0===r?void 0:r.base)&&void 0!==i?i:10,o=this._exponents(t,n);return null==o?this.basic_formatter.doFormat(t,e):o.map((t=>a.unicode_replace(`${n}^${t}`)))}}r.LogTickFormatter=_,_.__name__="LogTickFormatter",_.init_LogTickFormatter()},
function _(t,o,e,i,s){i();const n=t(178),r=t(9);class c extends n.AdaptiveTicker{constructor(t){super(t)}static init_LogTicker(){this.override({mantissas:[1,5]})}get_ticks_no_defaults(t,o,e,i){const s=this.num_minor_ticks,n=[],c=this.base,a=Math.log(t)/Math.log(c),f=Math.log(o)/Math.log(c),l=f-a;let h;if(isFinite(l))if(l<2){const e=this.get_interval(t,o,i),c=Math.floor(t/e),a=Math.ceil(o/e);if(h=r.range(c,a+1).filter((t=>0!=t)).map((t=>t*e)).filter((e=>t<=e&&e<=o)),s>0&&h.length>0){const t=e/s,o=r.range(0,s).map((o=>o*t));for(const t of o.slice(1))n.push(h[0]-t);for(const t of h)for(const e of o)n.push(t+e)}}else{const t=Math.ceil(.999999*a),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=r.range(t-1,o+1,e).map((t=>c**t)),s>0&&h.length>0){const t=c**e/s,o=r.range(1,s+1).map((o=>o*t));for(const t of o)n.push(h[0]/t);n.push(h[0]);for(const t of h)for(const e of o)n.push(t*e)}}else h=[];return{major:h.filter((e=>t<=e&&e<=o)),minor:n.filter((e=>t<=e&&e<=o))}}}e.LogTicker=c,c.__name__="LogTicker",c.init_LogTicker()},
function _(e,t,i,r,s){r();const a=e(163),o=e(175),c=e(196),n=e(197);class _ extends a.AxisView{}i.MercatorAxisView=_,_.__name__="MercatorAxisView";class x extends o.LinearAxis{constructor(e){super(e)}static init_MercatorAxis(){this.prototype.default_view=_,this.override({ticker:()=>new n.MercatorTicker({dimension:"lat"}),formatter:()=>new c.MercatorTickFormatter({dimension:"lat"})})}}i.MercatorAxis=x,x.__name__="MercatorAxis",x.init_MercatorAxis()},
function _(r,t,e,o,n){o();const i=r(176),c=r(20),a=r(65);class s extends i.BasicTickFormatter{constructor(r){super(r)}static init_MercatorTickFormatter(){this.define((({Nullable:r})=>({dimension:[r(c.LatLon),null]})))}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=a.wgs84_mercator.invert(r[n],t.loc);o[n]=e}else for(let n=0;n<e;n++){const[,e]=a.wgs84_mercator.invert(t.loc,r[n]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=s,s.__name__="MercatorTickFormatter",s.init_MercatorTickFormatter()},
function _(t,o,n,r,s){r();const i=t(177),e=t(20),c=t(65);class _ extends i.BasicTicker{constructor(t){super(t)}static init_MercatorTicker(){this.define((({Nullable:t})=>({dimension:[t(e.LatLon),null]})))}get_ticks_no_defaults(t,o,n,r){if(null==this.dimension)throw new Error(`${this}.dimension wasn't configured`);return[t,o]=c.clip_mercator(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,n,r):this._get_ticks_lat(t,o,n,r)}_get_ticks_lon(t,o,n,r){const[s]=c.wgs84_mercator.invert(t,n),[i,e]=c.wgs84_mercator.invert(o,n),_=super.get_ticks_no_defaults(s,i,n,r),a=[];for(const t of _.major)if(c.in_bounds(t,"lon")){const[o]=c.wgs84_mercator.compute(t,e);a.push(o)}const m=[];for(const t of _.minor)if(c.in_bounds(t,"lon")){const[o]=c.wgs84_mercator.compute(t,e);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,n,r){const[,s]=c.wgs84_mercator.invert(n,t),[i,e]=c.wgs84_mercator.invert(n,o),_=super.get_ticks_no_defaults(s,e,n,r),a=[];for(const t of _.major)if(c.in_bounds(t,"lat")){const[,o]=c.wgs84_mercator.compute(i,t);a.push(o)}const m=[];for(const t of _.minor)if(c.in_bounds(t,"lat")){const[,o]=c.wgs84_mercator.compute(i,t);m.push(o)}return{major:a,minor:m}}}n.MercatorTicker=_,_.__name__="MercatorTicker",_.init_MercatorTicker()},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(178).AdaptiveTicker),k("BasicTicker",e(177).BasicTicker),k("CategoricalTicker",e(171).CategoricalTicker),k("CompositeTicker",e(186).CompositeTicker),k("ContinuousTicker",e(179).ContinuousTicker),k("DatetimeTicker",e(185).DatetimeTicker),k("DaysTicker",e(187).DaysTicker),k("FixedTicker",e(199).FixedTicker),k("LogTicker",e(194).LogTicker),k("MercatorTicker",e(197).MercatorTicker),k("MonthsTicker",e(190).MonthsTicker),k("SingleIntervalTicker",e(188).SingleIntervalTicker),k("Ticker",e(165).Ticker),k("YearsTicker",e(191).YearsTicker),k("BinnedTicker",e(200).BinnedTicker)},
function _(i,t,e,r,n){r();const s=i(179);class _ extends s.ContinuousTicker{constructor(i){super(i)}static init_FixedTicker(){this.define((({Number:i,Array:t})=>({ticks:[t(i),[]],minor_ticks:[t(i),[]]})))}get_ticks_no_defaults(i,t,e,r){return{major:this.ticks,minor:this.minor_ticks}}get_interval(i,t,e){return 0}get_min_interval(){return 0}get_max_interval(){return 0}}e.FixedTicker=_,_.__name__="FixedTicker",_.init_FixedTicker()},
function _(e,n,t,i,r){i();const c=e(165),o=e(201),s=e(12);class a extends c.Ticker{constructor(e){super(e)}static init_BinnedTicker(){this.define((({Number:e,Ref:n,Or:t,Auto:i})=>({mapper:[n(o.ScanningColorMapper)],num_major_ticks:[t(e,i),8]})))}get_ticks(e,n,t,i){const{binning:r}=this.mapper.metrics,c=Math.max(0,s.left_edge_index(e,r)),o=Math.min(s.left_edge_index(n,r)+1,r.length-1),a=[];for(let e=c;e<=o;e++)a.push(r[e]);const{num_major_ticks:_}=this,m=[],h="auto"==_?a.length:_,l=Math.max(1,Math.floor(a.length/h));for(let e=0;e<a.length;e+=l)m.push(a[e]);return{major:m,minor:[]}}}t.BinnedTicker=a,a.__name__="BinnedTicker",a.init_BinnedTicker()},
function _(n,e,i,r,o){r();const t=n(202),a=n(12);class c extends t.ContinuousColorMapper{constructor(n){super(n)}cmap(n,e,i,r,o){if(n<o.binning[0])return i;if(n>o.binning[o.binning.length-1])return r;return e[a.left_edge_index(n,o.binning)]}}i.ScanningColorMapper=c,c.__name__="ScanningColorMapper"},
function _(t,o,e,n,s){n();const l=t(203),i=t(61),c=t(9),a=t(8);class r extends l.ColorMapper{constructor(t){super(t),this._scan_data=null}static init_ContinuousColorMapper(){this.define((({Number:t,String:o,Ref:e,Color:n,Or:s,Tuple:l,Array:c,Nullable:a})=>({high:[a(t),null],low:[a(t),null],high_color:[a(n),null],low_color:[a(n),null],domain:[c(l(e(i.GlyphRenderer),s(o,c(o)))),[]]})))}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,(()=>this.update_data())),this.connect(t.data_source.selected.change,(()=>this.update_data()))};this.connect(this.properties.domain.change,(()=>t())),t()}update_data(){const{domain:t,palette:o}=this,e=[...this._collect(t)];this._scan_data=this.scan(e,o.length),this.metrics_change.emit(),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[o,e]of t)for(const t of a.isArray(e)?e:[e]){let e=o.data_source.get_column(t);e=o.view.indices.select(e);const n=o.view.masked,s=o.data_source.selected.indices;let l;if(null!=n&&s.length>0?l=c.intersection([...n],s):null!=n?l=[...n]:s.length>0&&(l=s),null!=l&&(e=c.map(l,(t=>e[t]))),e.length>0&&!a.isNumber(e[0]))for(const t of e)yield*t;else yield*e}}_v_compute(t,o,e,n){const{nan_color:s}=n;let{low_color:l,high_color:i}=n;null==l&&(l=e[0]),null==i&&(i=e[e.length-1]);const{domain:a}=this,r=c.is_empty(a)?t:[...this._collect(a)];this._scan_data=this.scan(r,e.length),this.metrics_change.emit();for(let n=0,c=t.length;n<c;n++){const c=t[n];isNaN(c)?o[n]=s:o[n]=this.cmap(c,e,l,i,this._scan_data)}}_colors(t){return Object.assign(Object.assign({},super._colors(t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})}}e.ContinuousColorMapper=r,r.__name__="ContinuousColorMapper",r.init_ContinuousColorMapper()},
function _(t,r,e,n,o){n();const i=t(204),a=t(15),c=t(24),_=t(22),l=t(27);function s(t){return _.encode_rgba(_.color2rgba(t))}function p(t){const r=new Uint32Array(t.length);for(let e=0,n=t.length;e<n;e++)r[e]=s(t[e]);return r}e._convert_color=s,e._convert_palette=p;class u extends i.Mapper{constructor(t){super(t)}initialize(){super.initialize(),this.metrics_change=new a.Signal0(this,"metrics_change")}static init_ColorMapper(){this.define((({Color:t,Array:r})=>({palette:[r(t)],nan_color:[t,"gray"]})))}v_compute(t){const r=new Array(t.length);return this._v_compute(t,r,this.palette,this._colors((t=>t))),r}get rgba_mapper(){const t=this,r=p(this.palette),e=this._colors(s);return{v_compute(n){const o=new c.ColorArray(n.length);return t._v_compute(n,o,r,e),new Uint8ClampedArray(l.to_big_endian(o).buffer)}}}_colors(t){return{nan_color:t(this.nan_color)}}}e.ColorMapper=u,u.__name__="ColorMapper",u.init_ColorMapper()},
function _(r,e,n,s,o){s();const p=r(149);class t extends p.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=t,t.__name__="Mapper"},
function _(t,r,a,e,c){e(),c("BasicTickFormatter",t(176).BasicTickFormatter),c("CategoricalTickFormatter",t(172).CategoricalTickFormatter),c("DatetimeTickFormatter",t(180).DatetimeTickFormatter),c("FuncTickFormatter",t(206).FuncTickFormatter),c("LogTickFormatter",t(193).LogTickFormatter),c("MercatorTickFormatter",t(196).MercatorTickFormatter),c("NumeralTickFormatter",t(207).NumeralTickFormatter),c("PrintfTickFormatter",t(208).PrintfTickFormatter),c("TickFormatter",t(166).TickFormatter)},
function _(t,n,e,s,i){s();const r=t(166),c=t(13),a=t(34);class u extends r.TickFormatter{constructor(t){super(t)}static init_FuncTickFormatter(){this.define((({Unknown:t,String:n,Dict:e})=>({args:[e(t),{}],code:[n,""]})))}get names(){return c.keys(this.args)}get values(){return c.values(this.args)}_make_func(){const t=a.use_strict(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,n){const e=this._make_func().bind({});return t.map(((t,n,s)=>e(t,n,s,...this.values)))}}e.FuncTickFormatter=u,u.__name__="FuncTickFormatter",u.init_FuncTickFormatter()},
function _(r,t,n,e,a){e();const o=r(1).__importStar(r(183)),i=r(166),u=r(20);class c extends i.TickFormatter{constructor(r){super(r)}static init_NumeralTickFormatter(){this.define((({String:r})=>({format:[r,"0,0"],language:[r,"en"],rounding:[u.RoundingFunction,"round"]})))}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,t){const{format:n,language:e,_rounding_fn:a}=this;return r.map((r=>o.format(r,n,e,a)))}}n.NumeralTickFormatter=c,c.__name__="NumeralTickFormatter",c.init_NumeralTickFormatter()},
function _(t,r,i,n,o){n();const a=t(166),e=t(182);class c extends a.TickFormatter{constructor(t){super(t)}static init_PrintfTickFormatter(){this.define((({String:t})=>({format:[t,"%s"]})))}doFormat(t,r){return t.map((t=>e.sprintf(this.format,t)))}}i.PrintfTickFormatter=c,c.__name__="PrintfTickFormatter",c.init_PrintfTickFormatter()},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(210).CategoricalColorMapper),e("CategoricalMarkerMapper",r(212).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(213).CategoricalPatternMapper),e("ContinuousColorMapper",r(202).ContinuousColorMapper),e("ColorMapper",r(203).ColorMapper),e("LinearColorMapper",r(214).LinearColorMapper),e("LogColorMapper",r(215).LogColorMapper),e("ScanningColorMapper",r(201).ScanningColorMapper),e("EqHistColorMapper",r(216).EqHistColorMapper)},
function _(t,o,a,r,e){r();const c=t(211),l=t(203),i=t(104);class s extends l.ColorMapper{constructor(t){super(t)}static init_CategoricalColorMapper(){this.define((({Number:t,Nullable:o})=>({factors:[i.FactorSeq],start:[t,0],end:[o(t),null]})))}_v_compute(t,o,a,{nan_color:r}){c.cat_v_compute(t,this.factors,a,o,this.start,this.end,r)}}a.CategoricalColorMapper=s,s.__name__="CategoricalColorMapper",s.init_CategoricalColorMapper()},
function _(n,t,e,l,i){l();const c=n(12),u=n(8);function f(n,t){if(n.length!=t.length)return!1;for(let e=0,l=n.length;e<l;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=f,e.cat_v_compute=function(n,t,e,l,i,o,r){const _=n.length;for(let g=0;g<_;g++){let _,s,h=n[g];u.isString(h)?_=c.index_of(t,h):(null!=i?h=null!=o?h.slice(i,o):h.slice(i):null!=o&&(h=h.slice(0,o)),_=1==h.length?c.index_of(t,h[0]):c.find_index(t,(n=>f(n,h)))),s=_<0||_>=e.length?r:e[_],l[g]=s}}},
function _(r,e,a,t,s){t();const c=r(211),i=r(104),l=r(204),n=r(20);class p extends l.Mapper{constructor(r){super(r)}static init_CategoricalMarkerMapper(){this.define((({Number:r,Array:e,Nullable:a})=>({factors:[i.FactorSeq],markers:[e(n.MarkerType)],start:[r,0],end:[a(r),null],default_value:[n.MarkerType,"circle"]})))}v_compute(r){const e=new Array(r.length);return c.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e}}a.CategoricalMarkerMapper=p,p.__name__="CategoricalMarkerMapper",p.init_CategoricalMarkerMapper()},
function _(t,a,e,r,n){r();const s=t(211),c=t(104),i=t(204),p=t(20);class l extends i.Mapper{constructor(t){super(t)}static init_CategoricalPatternMapper(){this.define((({Number:t,Array:a,Nullable:e})=>({factors:[c.FactorSeq],patterns:[a(p.HatchPatternType)],start:[t,0],end:[e(t),null],default_value:[p.HatchPatternType," "]})))}v_compute(t){const a=new Array(t.length);return s.cat_v_compute(t,this.factors,this.patterns,a,this.start,this.end,this.default_value),a}}e.CategoricalPatternMapper=l,l.__name__="CategoricalPatternMapper",l.init_CategoricalPatternMapper()},
function _(n,r,o,t,a){t();const e=n(202),i=n(12);class s extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:i.min(n),t=null!=this.high?this.high:i.max(n);return{max:t,min:o,norm_factor:1/(t-o),normed_interval:1/r}}cmap(n,r,o,t,a){const e=r.length-1;if(n==a.max)return r[e];const i=(n-a.min)*a.norm_factor,s=Math.floor(i/a.normed_interval);return s<0?o:s>e?t:r[s]}}o.LinearColorMapper=s,s.__name__="LinearColorMapper"},
function _(o,t,n,r,l){r();const a=o(202),s=o(12);class e extends a.ContinuousColorMapper{constructor(o){super(o)}scan(o,t){const n=null!=this.low?this.low:s.min(o),r=null!=this.high?this.high:s.max(o);return{max:r,min:n,scale:t/(Math.log(r)-Math.log(n))}}cmap(o,t,n,r,l){const a=t.length-1;if(o>l.max)return r;if(o==l.max)return t[a];if(o<l.min)return n;const s=Math.log(o)-Math.log(l.min);let e=Math.floor(s*l.scale);return e>a&&(e=a),t[e]}}n.LogColorMapper=e,e.__name__="LogColorMapper"},
function _(n,t,i,e,o){e();const s=n(201),r=n(12),a=n(9),l=n(19);class c extends s.ScanningColorMapper{constructor(n){super(n)}static init_EqHistColorMapper(){this.define((({Int:n})=>({bins:[n,65536]})))}scan(n,t){const i=null!=this.low?this.low:r.min(n),e=null!=this.high?this.high:r.max(n),o=this.bins,s=a.linspace(i,e,o+1),c=r.bin_counts(n,s),h=new Array(o);for(let n=0,t=s.length;n<t-1;n++){const t=s[n],i=s[n+1];h[n]=(t+i)/2}const p=a.cumsum(c),g=p[p.length-1],u=r.map(p,(n=>n/g));let m=t-1,M=[],_=0,f=2*t;for(;m!=t&&_<4&&0!=m;){const n=f/m;if(n>1e3)break;f=Math.round(Math.max(t*n,t));const i=a.range(0,f),e=r.map(u,(n=>n*(f-1)));M=r.interpolate(i,e,h);m=a.uniq(M).length-1,_++}if(0==m){M=[i,e];for(let n=0;n<t-1;n++)M.push(e)}else M=M.slice(M.length-t-1),m!=t&&l.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return M[0]=i,M[M.length-1]=e,{min:i,max:e,binning:M}}}i.EqHistColorMapper=c,c.__name__="EqHistColorMapper",c.init_EqHistColorMapper()},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(145).CategoricalScale),n("ContinuousScale",a(158).ContinuousScale),n("LinearScale",a(218).LinearScale),n("LinearInterpolationScale",a(219).LinearInterpolationScale),n("LogScale",a(157).LogScale),n("Scale",a(146).Scale)},
function _(e,t,n,r,_){r();const i=e(158);class u extends i.ContinuousScale{constructor(e){super(e)}get s_compute(){const[e,t]=this._linear_compute_state();return n=>e*n+t}compute(e){return this._linear_compute(e)}v_compute(e){return this._linear_v_compute(e)}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}n.LinearScale=u,u.__name__="LinearScale"},
function _(n,e,t,r,i){r();const a=n(146),o=n(12);class c extends a.Scale{constructor(n){super(n)}static init_LinearInterpolationScale(){this.internal((({Arrayable:n})=>({binning:[n]})))}get s_compute(){throw new Error("not implemented")}compute(n){return n}v_compute(n){const{binning:e}=this,{start:t,end:r}=this.source_range,i=t,a=r,c=e.length,l=(r-t)/(c-1),s=new Float64Array(c);for(let n=0;n<c;n++)s[n]=t+n*l;const _=o.map(n,(n=>{if(n<i)return i;if(n>a)return a;const t=o.left_edge_index(n,e),r=e[t],c=(n-r)/(e[t+1]-r),l=s[t];return l+c*(s[t+1]-l)}));return this._linear_v_compute(_)}invert(n){return n}v_invert(n){return new Float64Array(n)}}t.LinearInterpolationScale=c,c.__name__="LinearInterpolationScale",c.init_LinearInterpolationScale()},
function _(a,n,e,g,R){g(),R("DataRange",a(160).DataRange),R("DataRange1d",a(159).DataRange1d),R("FactorRange",a(104).FactorRange),R("Range",a(105).Range),R("Range1d",a(156).Range1d)},
function _(a,o,i,t,e){t();var n=a(141);e("Sizeable",n.Sizeable),e("SizingPolicy",n.SizingPolicy);var c=a(142);e("Layoutable",c.Layoutable),e("LayoutItem",c.LayoutItem);var r=a(222);e("HStack",r.HStack),e("VStack",r.VStack);var l=a(223);e("Grid",l.Grid),e("Row",l.Row),e("Column",l.Column);var S=a(224);e("ContentBox",S.ContentBox),e("VariadicBox",S.VariadicBox)},
function _(t,e,h,i,r){i();const n=t(142),o=t(99);class s extends n.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}}h.Stack=s,s.__name__="Stack";class c extends s{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e+=i.width,h=Math.max(h,i.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const h=this.absolute?t.top:0;let i=this.absolute?t.left:0;const{height:r}=t;for(const t of this.children){const{width:e}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({left:i,width:e,top:h,height:r})),i+=e}}}h.HStack=c,c.__name__="HStack";class a extends s{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e=Math.max(e,i.width),h+=i.height}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const h=this.absolute?t.left:0;let i=this.absolute?t.top:0;const{width:r}=t;for(const t of this.children){const{height:e}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({top:i,height:e,left:h,width:r})),i+=e}}}h.VStack=a,a.__name__="VStack";class l extends n.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}_measure(t){const{width_policy:e,height_policy:h}=this.sizing,{min:i,max:r}=Math;let n=0,o=0;for(const e of this.children){const{width:h,height:i}=e.measure(t);n=r(n,h),o=r(o,i)}return{width:(()=>{const{width:h}=this.sizing;if(t.width==1/0)return"fixed"==e&&null!=h?h:n;switch(e){case"fixed":return null!=h?h:n;case"min":return n;case"fit":return null!=h?i(t.width,h):t.width;case"max":return null!=h?r(t.width,h):t.width}})(),height:(()=>{const{height:e}=this.sizing;if(t.height==1/0)return"fixed"==h&&null!=e?e:o;switch(h){case"fixed":return null!=e?e:o;case"min":return o;case"fit":return null!=e?i(t.height,e):t.height;case"max":return null!=e?r(t.height,e):t.height}})()}}_set_geometry(t,e){super._set_geometry(t,e);const h=this.absolute?t:t.relative(),{left:i,right:r,top:n,bottom:s}=h,c=Math.round(h.vcenter),a=Math.round(h.hcenter);for(const e of this.children){const{margin:h,halign:l,valign:d}=e.sizing,{width:u,height:g,inner:_}=e.measure(t),w=(()=>{switch(`${d}_${l}`){case"start_start":return new o.BBox({left:i+h.left,top:n+h.top,width:u,height:g});case"start_center":return new o.BBox({hcenter:a,top:n+h.top,width:u,height:g});case"start_end":return new o.BBox({right:r-h.right,top:n+h.top,width:u,height:g});case"center_start":return new o.BBox({left:i+h.left,vcenter:c,width:u,height:g});case"center_center":return new o.BBox({hcenter:a,vcenter:c,width:u,height:g});case"center_end":return new o.BBox({right:r-h.right,vcenter:c,width:u,height:g});case"end_start":return new o.BBox({left:i+h.left,bottom:s-h.bottom,width:u,height:g});case"end_center":return new o.BBox({hcenter:a,bottom:s-h.bottom,width:u,height:g});case"end_end":return new o.BBox({right:r-h.right,bottom:s-h.bottom,width:u,height:g})}})(),m=null==_?w:new o.BBox({left:w.left+_.left,top:w.top+_.top,right:w.right-_.right,bottom:w.bottom-_.bottom});e.set_geometry(w,m)}}}h.NodeLayout=l,l.__name__="NodeLayout"},
function _(t,i,s,e,o){e();const n=t(141),l=t(142),r=t(8),h=t(99),c=t(9),{max:a,round:g}=Math;class p{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}p.__name__="DefaultMap";class f{constructor(){this._items=[],this._nrows=0,this._ncols=0}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=a(this._nrows,s+1),this._ncols=a(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter((({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1)).map((({data:t})=>t))}row(t){return this._items.filter((({span:i})=>i.r0<=t&&t<=i.r1)).map((({data:t})=>t))}col(t){return this._items.filter((({span:i})=>i.c0<=t&&t<=i.c1)).map((({data:t})=>t))}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new f;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}f.__name__="Container";class _ extends l.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0}*[Symbol.iterator](){for(const{layout:t}of this.items)yield t}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return c.some(t,(t=>"max"==t.policy))}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return c.some(t,(t=>"max"==t.policy))}_init(){var t,i,s,e;super._init();const o=new f;for(const{layout:t,row:i,col:s,row_span:e,col_span:n}of this.items)if(t.sizing.visible){const l=i,r=s,h=i+(null!=e?e:1)-1,c=s+(null!=n?n:1)-1;o.add({r0:l,c0:r,r1:h,c1:c},t)}const{nrows:n,ncols:l}=o,h=new Array(n);for(let s=0;s<n;s++){const e=(()=>{var t;const i=r.isPlainObject(this.rows)?null!==(t=this.rows[s])&&void 0!==t?t:this.rows["*"]:this.rows;return null==i?{policy:"auto"}:r.isNumber(i)?{policy:"fixed",height:i}:r.isString(i)?{policy:i}:i})(),n=null!==(t=e.align)&&void 0!==t?t:"auto";if("fixed"==e.policy)h[s]={policy:"fixed",height:e.height,align:n};else if("min"==e.policy)h[s]={policy:"min",align:n};else if("fit"==e.policy||"max"==e.policy)h[s]={policy:e.policy,flex:null!==(i=e.flex)&&void 0!==i?i:1,align:n};else{if("auto"!=e.policy)throw new Error("unrechable");c.some(o.row(s),(t=>t.is_height_expanding()))?h[s]={policy:"max",flex:1,align:n}:h[s]={policy:"min",align:n}}}const a=new Array(l);for(let t=0;t<l;t++){const i=(()=>{var i;const s=r.isPlainObject(this.cols)?null!==(i=this.cols[t])&&void 0!==i?i:this.cols["*"]:this.cols;return null==s?{policy:"auto"}:r.isNumber(s)?{policy:"fixed",width:s}:r.isString(s)?{policy:s}:s})(),n=null!==(s=i.align)&&void 0!==s?s:"auto";if("fixed"==i.policy)a[t]={policy:"fixed",width:i.width,align:n};else if("min"==i.policy)a[t]={policy:"min",align:n};else if("fit"==i.policy||"max"==i.policy)a[t]={policy:i.policy,flex:null!==(e=i.flex)&&void 0!==e?e:1,align:n};else{if("auto"!=i.policy)throw new Error("unrechable");c.some(o.col(t),(t=>t.is_width_expanding()))?a[t]={policy:"max",flex:1,align:n}:a[t]={policy:"min",align:n}}}const[g,p]=r.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:o,nrows:n,ncols:l,rows:h,cols:a,rspacing:g,cspacing:p}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:c.sum(t)+(s-1)*o,width:c.sum(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:e,rows:o,cols:l,rspacing:r,cspacing:h}=this._state,c=new Array(s);for(let t=0;t<s;t++){const i=o[t];c[t]="fixed"==i.policy?i.height:0}const p=new Array(e);for(let t=0;t<e;t++){const i=l[t];p[t]="fixed"==i.policy?i.width:0}const _=new f;i.foreach(((i,s)=>{const{r0:e,c0:f,r1:d,c1:u}=i,w=(d-e)*r,m=(u-f)*h;let y=0;for(let i=e;i<=d;i++)y+=t(i,f).height;y+=w;let x=0;for(let i=f;i<=u;i++)x+=t(e,i).width;x+=m;const b=s.measure({width:x,height:y});_.add(i,{layout:s,size_hint:b});const z=new n.Sizeable(b).grow_by(s.sizing.margin);z.height-=w,z.width-=m;const v=[];for(let t=e;t<=d;t++){const i=o[t];"fixed"==i.policy?z.height-=i.height:v.push(t)}if(z.height>0){const t=g(z.height/v.length);for(const i of v)c[i]=a(c[i],t)}const j=[];for(let t=f;t<=u;t++){const i=l[t];"fixed"==i.policy?z.width-=i.width:j.push(t)}if(z.width>0){const t=g(z.width/j.length);for(const i of j)p[i]=a(p[i],t)}}));return{size:this._measure_totals(c,p),row_heights:c,col_widths:p,size_hints:_}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:l}=this._state,r=s=>{let o;o="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:s.size.height;let l=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?l+=i.flex:o-=s.row_heights[t]}if(o-=(i-1)*n,0!=l&&o>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const e=g(o*(i.flex/l));o-=e,s.row_heights[t]=e,l-=i.flex}}else if(o<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let n=-o;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=s.row_heights[o],e=g(n/t);s.row_heights[o]=a(i-e,0),n-=e>i?i:e,t--}}}},h=i=>{let e;e="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:i.size.width;let n=0;for(let t=0;t<s;t++){const s=o[t];"fit"==s.policy||"max"==s.policy?n+=s.flex:e-=i.col_widths[t]}if(e-=(s-1)*l,0!=n&&e>0)for(let t=0;t<s;t++){const s=o[t];if("fit"==s.policy||"max"==s.policy){const o=g(e*(s.flex/n));e-=o,i.col_widths[t]=o,n-=s.flex}}else if(e<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let n=-e;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=i.col_widths[e],o=g(n/t);i.col_widths[e]=a(s-o,0),n-=o>s?s:o,t--}}}},c=this._measure_cells(((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}}));r(c),h(c);const p=this._measure_cells(((t,i)=>({width:c.col_widths[i],height:c.row_heights[t]})));r(p),h(p);const{row_heights:f,col_widths:_}=p;return{size:this._measure_totals(f,_),row_heights:f,col_widths:_}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:l,col_widths:r}=this._measure_grid(t),{size_hints:c}=this._measure_cells(((t,i)=>({width:r[i],height:l[t]}))),f=this._state.rows.map(((t,i)=>Object.assign(Object.assign({},t),{top:0,height:l[i],get bottom(){return this.top+this.height}}))),_=this._state.cols.map(((t,i)=>Object.assign(Object.assign({},t),{left:0,width:r[i],get right(){return this.left+this.width}}))),d=c.map(((t,i)=>Object.assign(Object.assign({},i),{outer:new h.BBox,inner:new h.BBox})));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=f[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=_[i];t.left=s,s+=t.width+n}d.foreach((({r0:t,c0:i,r1:s,c1:e},l)=>{const{layout:r,size_hint:c}=l,{sizing:a}=r,{width:p,height:d}=c,u=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=_[e].width;return s}(i,e),w=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=f[e].height;return s}(t,s),m=i==e&&"auto"!=_[i].align?_[i].align:a.halign,y=t==s&&"auto"!=f[t].align?f[t].align:a.valign;let x=_[i].left;"start"==m?x+=a.margin.left:"center"==m?x+=g((u-p)/2):"end"==m&&(x+=u-a.margin.right-p);let b=f[t].top;"start"==y?b+=a.margin.top:"center"==y?b+=g((w-d)/2):"end"==y&&(b+=w-a.margin.bottom-d),l.outer=new h.BBox({left:x,top:b,width:p,height:d})}));const u=f.map((()=>({start:new p((()=>0)),end:new p((()=>0))}))),w=_.map((()=>({start:new p((()=>0)),end:new p((()=>0))})));d.foreach((({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:l}=o;null!=l&&(u[t].start.apply(n.top,(t=>a(t,l.top))),u[s].end.apply(f[s].bottom-n.bottom,(t=>a(t,l.bottom))),w[i].start.apply(n.left,(t=>a(t,l.left))),w[e].end.apply(_[e].right-n.right,(t=>a(t,l.right))))})),d.foreach((({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:l}=o,r=t=>{const i=this.absolute?l:l.relative(),s=i.left+t.left,e=i.top+t.top,o=i.right-t.right,n=i.bottom-t.bottom;return new h.BBox({left:s,top:e,right:o,bottom:n})};if(null!=n.inner){let h=r(n.inner);if(!1!==n.align){const o=u[t].start.get(l.top),n=u[s].end.get(f[s].bottom-l.bottom),c=w[i].start.get(l.left),a=w[e].end.get(_[e].right-l.right);try{h=r({top:o,bottom:n,left:c,right:a})}catch(t){}}o.inner=h}else o.inner=l})),d.foreach(((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)}))}}s.Grid=_,_.__name__="Grid";class d extends _{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:0,col:i}))),this.rows="fit"}}s.Row=d,d.__name__="Row";class u extends _{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:i,col:0}))),this.cols="fit"}}s.Column=u,u.__name__="Column"},
function _(e,t,s,n,i){n();const a=e(142),c=e(141),o=e(43);class r extends a.ContentLayoutable{constructor(e){super(),this.content_size=o.unsized(e,(()=>new c.Sizeable(o.size(e))))}_content_size(){return this.content_size}}s.ContentBox=r,r.__name__="ContentBox";class _ extends a.Layoutable{constructor(e){super(),this.el=e}_measure(e){const t=new c.Sizeable(e).bounded_to(this.sizing.size);return o.sized(this.el,t,(()=>{const e=new c.Sizeable(o.content_size(this.el)),{border:t,padding:s}=o.extents(this.el);return e.grow_by(t).grow_by(s).map(Math.ceil)}))}}s.VariadicBox=_,_.__name__="VariadicBox";class h extends _{constructor(e){super(e),this._cache=new Map}_measure(e){const{width:t,height:s}=e,n=`${t},${s}`;let i=this._cache.get(n);return null==i&&(i=super._measure(e),this._cache.set(n,i)),i}invalidate_cache(){this._cache.clear()}}s.CachedVariadicBox=h,h.__name__="CachedVariadicBox"},
function _(t,e,i,h,o){h();const s=t(141),r=t(142),n=t(99);class g extends r.Layoutable{constructor(){super(...arguments),this.min_border={left:0,top:0,right:0,bottom:0},this.padding={left:0,top:0,right:0,bottom:0}}*[Symbol.iterator](){yield this.top_panel,yield this.bottom_panel,yield this.left_panel,yield this.right_panel,yield this.center_panel}_measure(t){t=new s.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left)+this.padding.left,h=this.right_panel.measure({width:0,height:t.height}),o=Math.max(h.width,this.min_border.right)+this.padding.right,r=this.top_panel.measure({width:t.width,height:0}),n=Math.max(r.height,this.min_border.top)+this.padding.top,g=this.bottom_panel.measure({width:t.width,height:0}),a=Math.max(g.height,this.min_border.bottom)+this.padding.bottom,d=new s.Sizeable(t).shrink_by({left:i,right:o,top:n,bottom:a}),l=this.center_panel.measure(d);return{width:i+l.width+o,height:n+l.height+a,inner:{left:i,right:o,top:n,bottom:a},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return"fixed"!=t&&"fixed"!=e})()}}_set_geometry(t,e){super._set_geometry(t,e),this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),h=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),s=this.bottom_panel.measure({width:t.width,height:0}),{left:r,top:g,right:a,bottom:d}=e;this.top_panel.set_geometry(new n.BBox({left:r,right:a,bottom:g,height:o.height})),this.bottom_panel.set_geometry(new n.BBox({left:r,right:a,top:d,height:s.height})),this.left_panel.set_geometry(new n.BBox({top:g,bottom:d,right:r,width:i.width})),this.right_panel.set_geometry(new n.BBox({top:g,bottom:d,left:a,width:h.width}))}}i.BorderLayout=g,g.__name__="BorderLayout"},
function _(t,e,i,s,n){s();const o=t(1),l=t(139),a=t(10),_=t(143),d=t(20),h=o.__importStar(t(48));class r extends l.TextAnnotationView{_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_value(t);const{width:e}=t.measureText(this.model.text),{height:i}=_.font_metrics(t.font);return{width:e,height:i}}_render(){const{angle:t,angle_units:e}=this.model,i=a.resolve_angle(t,e),s=null!=this.layout?this.layout:this.plot_view.frame,n=this.coordinates.x_scale,o=this.coordinates.y_scale;let l="data"==this.model.x_units?n.compute(this.model.x):s.bbox.xview.compute(this.model.x),_="data"==this.model.y_units?o.compute(this.model.y):s.bbox.yview.compute(this.model.y);l+=this.model.x_offset,_-=this.model.y_offset;("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,l,_,i)}}i.LabelView=r,r.__name__="LabelView";class c extends l.TextAnnotation{constructor(t){super(t)}static init_Label(){this.prototype.default_view=r,this.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),this.define((({Number:t,String:e,Angle:i})=>({x:[t],x_units:[d.SpatialUnits,"data"],y:[t],y_units:[d.SpatialUnits,"data"],text:[e,""],angle:[i,0],angle_units:[d.AngleUnits,"rad"],x_offset:[t,0],y_offset:[t,0]}))),this.override({background_fill_color:null,border_line_color:null})}}i.Label=c,c.__name__="Label",c.init_Label()},
function _(t,e,s,i,o){i();const l=t(1),n=t(139),a=t(56),r=t(130),_=l.__importStar(t(48)),c=t(20),h=t(43),d=l.__importStar(t(18)),u=t(143);class x extends n.TextAnnotationView{set_data(t){a.DataAnnotationView.prototype.set_data.call(this,t)}initialize(){if(super.initialize(),this.set_data(this.model.source),"css"==this.model.render_mode)for(let t=0,e=this.text.length;t<e;t++){const t=h.div({style:{display:"none"}});this.el.appendChild(t)}}connect_signals(){super.connect_signals();const t=()=>{this.set_data(this.model.source),"css"==this.model.render_mode?this.render():this.request_render()};this.connect(this.model.change,t),this.connect(this.model.source.streaming,t),this.connect(this.model.source.patching,t),this.connect(this.model.source.change,t)}_calculate_text_dimensions(t,e){const{width:s}=t.measureText(e),{height:i}=u.font_metrics(this.visuals.text.font_value(0));return[s,i]}_map_data(){const t=this.coordinates.x_scale,e=this.coordinates.y_scale,s=null!=this.layout?this.layout:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):s.bbox.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):s.bbox.yview.v_compute(this._y)]}_render(){const t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),{ctx:e}=this.layer,[s,i]=this._map_data();for(let o=0,l=this.text.length;o<l;o++)t(e,o,this.text.get(o),s[o]+this.x_offset.get(o),i[o]-this.y_offset.get(o),this.angle.get(o))}_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_vectorize(t,0);const{width:e}=t.measureText(this.text.get(0)),{height:s}=u.font_metrics(t.font);return{width:e,height:s}}_v_canvas_text(t,e,s,i,o,l){this.visuals.text.set_vectorize(t,e);const n=this._calculate_bounding_box_dimensions(t,s);t.save(),t.beginPath(),t.translate(i,o),t.rotate(l),t.rect(n[0],n[1],n[2],n[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(s,0,0)),t.restore()}_v_css_text(t,e,s,i,o,l){const n=this.el.children[e];n.textContent=s,this.visuals.text.set_vectorize(t,e);const[a,r]=this._calculate_bounding_box_dimensions(t,s);n.style.position="absolute",n.style.left=`${i+a}px`,n.style.top=`${o+r}px`,n.style.color=t.fillStyle,n.style.font=t.font,n.style.lineHeight="normal",l&&(n.style.transform=`rotate(${l}rad)`),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),n.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),n.style.borderStyle=t.lineDash.length<2?"solid":"dashed",n.style.borderWidth=`${t.lineWidth}px`,n.style.borderColor=t.strokeStyle),h.display(n)}}s.LabelSetView=x,x.__name__="LabelSetView";class v extends n.TextAnnotation{constructor(t){super(t)}static init_LabelSet(){this.prototype.default_view=x,this.mixins([_.TextVector,["border_",_.LineVector],["background_",_.FillVector]]),this.define((({Ref:t})=>({x:[d.XCoordinateSpec,{field:"x"}],y:[d.YCoordinateSpec,{field:"y"}],x_units:[c.SpatialUnits,"data"],y_units:[c.SpatialUnits,"data"],text:[d.StringSpec,{field:"text"}],angle:[d.AngleSpec,0],x_offset:[d.NumberSpec,{value:0}],y_offset:[d.NumberSpec,{value:0}],source:[t(r.ColumnDataSource),()=>new r.ColumnDataSource]}))),this.override({background_fill_color:null,border_line_color:null})}}s.LabelSet=v,v.__name__="LabelSet",v.init_LabelSet()},
function _(t,e,i,s,l){s();const n=t(1),h=t(40),o=t(229),a=t(20),_=n.__importStar(t(48)),r=t(15),d=t(140),c=t(143),g=t(99),m=t(9),b=t(8),f=t(11);class u extends h.AnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size())):void 0}cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.model.border_line_color?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.item_change,(()=>this.request_render()))}compute_legend_bbox(){const t=this.model.get_legend_names(),{glyph_height:e,glyph_width:i}=this.model,{label_height:s,label_width:l}=this.model;this.max_label_height=m.max([c.font_metrics(this.visuals.label_text.font_value()).height,s,e]);const{ctx:n}=this.layer;n.save(),this.visuals.label_text.set_value(n),this.text_widths=new Map;for(const e of t)this.text_widths.set(e,m.max([n.measureText(e).width,l]));this.visuals.title_text.set_value(n),this.title_height=this.model.title?c.font_metrics(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?n.measureText(this.model.title).width:0,n.restore();const h=Math.max(m.max([...this.text_widths.values()]),0),o=this.model.margin,{legend_padding:a}=this,_=this.model.spacing,{label_standoff:r}=this.model;let d,u;if("vertical"==this.model.orientation)d=t.length*this.max_label_height+Math.max(t.length-1,0)*_+2*a+this.title_height,u=m.max([h+i+r+2*a,this.title_width+2*a]);else{let e=2*a+Math.max(t.length-1,0)*_;for(const[,t]of this.text_widths)e+=m.max([t,l])+i+r;u=m.max([this.title_width+2*a,e]),d=this.max_label_height+this.title_height+2*a}const x=null!=this.layout?this.layout:this.plot_view.frame,[p,w]=x.bbox.ranges,{location:v}=this.model;let y,k;if(b.isString(v))switch(v){case"top_left":y=p.start+o,k=w.start+o;break;case"top":case"top_center":y=(p.end+p.start)/2-u/2,k=w.start+o;break;case"top_right":y=p.end-o-u,k=w.start+o;break;case"bottom_right":y=p.end-o-u,k=w.end-o-d;break;case"bottom":case"bottom_center":y=(p.end+p.start)/2-u/2,k=w.end-o-d;break;case"bottom_left":y=p.start+o,k=w.end-o-d;break;case"left":case"center_left":y=p.start+o,k=(w.end+w.start)/2-d/2;break;case"center":case"center_center":y=(p.end+p.start)/2-u/2,k=(w.end+w.start)/2-d/2;break;case"right":case"center_right":y=p.end-o-u,k=(w.end+w.start)/2-d/2}else if(b.isArray(v)&&2==v.length){const[t,e]=v;y=x.bbox.xview.compute(t),k=x.bbox.yview.compute(e)-d}else f.unreachable();return new g.BBox({left:y,top:k,width:u,height:d})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let o=i=l;const a=this.compute_legend_bbox(),_="vertical"==this.model.orientation;for(const r of this.model.items){const d=r.get_labels_list_from_label_prop();for(const c of d){const d=a.x+o,m=a.y+i+this.title_height;let b,f;[b,f]=_?[a.width-2*l,this.max_label_height]:[this.text_widths.get(c)+s+h,this.max_label_height];if(new g.BBox({left:d,top:m,width:b,height:f}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of r.renderers)t.visible=!t.visible;break;case"mute":for(const t of r.renderers)t.muted=!t.muted}return!0}_?i+=this.max_label_height+n:o+=this.text_widths.get(c)+s+h+n}}return!1}_render(){if(0==this.model.items.length)return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.layer,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let o=l,a=l;const _="vertical"==this.model.orientation;for(const r of this.model.items){const d=r.get_labels_list_from_label_prop(),c=r.get_field_from_label_prop();if(0==d.length)continue;const g=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return m.every(r.renderers,(t=>t.visible));case"mute":return m.every(r.renderers,(t=>!t.muted))}})();for(const m of d){const d=e.x+o,b=e.y+a+this.title_height,f=d+i,u=b+s;_?a+=this.max_label_height+n:o+=this.text_widths.get(m)+i+h+n,this.visuals.label_text.set_value(t),t.fillText(m,f+h,b+this.max_label_height/2);for(const e of r.renderers){const i=this.plot_view.renderer_view(e);null==i||i.draw_legend(t,d,f,b,u,c,m,r.index)}if(!g){let s,n;[s,n]=_?[e.width-2*l,this.max_label_height]:[this.text_widths.get(m)+i+h,this.max_label_height],t.beginPath(),t.rect(d,b,s,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){const{title:i}=this.model;i&&this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(i,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=u,u.__name__="LegendView";class x extends h.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new r.Signal0(this,"item_change")}static init_Legend(){this.prototype.default_view=u,this.mixins([["label_",_.Text],["title_",_.Text],["inactive_",_.Fill],["border_",_.Line],["background_",_.Fill]]),this.define((({Number:t,String:e,Array:i,Tuple:s,Or:l,Ref:n,Nullable:h})=>({orientation:[a.Orientation,"vertical"],location:[l(a.LegendLocation,s(t,t)),"top_right"],title:[h(e),null],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[i(n(o.LegendItem)),[]],click_policy:[a.LegendClickPolicy,"none"]}))),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=x,x.__name__="Legend",x.init_Legend()},
function _(e,r,n,l,t){l();const i=e(1),s=e(53),o=e(61),_=e(57),a=e(230),u=i.__importStar(e(18)),d=e(19),c=e(9);class f extends s.Model{constructor(e){super(e)}static init_LegendItem(){this.define((({Int:e,Array:r,Ref:n,Nullable:l})=>({label:[u.NullStringSpec,null],renderers:[r(n(o.GlyphRenderer)),[]],index:[l(e),null]})))}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;if(null!=e)for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(null!=r&&!c.includes(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,(()=>{var e;return null===(e=this.legend)||void 0===e?void 0:e.item_change.emit()}));this._check_data_sources_on_renderers()||d.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||d.logger.error(`Bad column name on label: ${this.label}`)}get_field_from_label_prop(){const{label:e}=this;return a.isField(e)?e.field:null}get_labels_list_from_label_prop(){if(a.isValue(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if(r=this.renderers[0].data_source,r instanceof _.ColumnarDataSource){const n=r.get_column(e);return null!=n?c.uniq(Array.from(n)):["Invalid field"]}}return[]}}n.LegendItem=f,f.__name__="LegendItem",f.init_LegendItem()},
function _(i,n,e,t,u){t();const c=i(8);e.isValue=function(i){return c.isPlainObject(i)&&"value"in i},e.isField=function(i){return c.isPlainObject(i)&&"field"in i},e.isExpr=function(i){return c.isPlainObject(i)&&"expr"in i}},
function _(t,i,s,n,e){n();const o=t(1),l=t(40),a=o.__importStar(t(48)),c=t(20);class h extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{xs:t,ys:i}=this.model;if(t.length!=i.length)return;const s=t.length;if(s<3)return;const{frame:n}=this.plot_view,{ctx:e}=this.layer,o=this.coordinates.x_scale,l=this.coordinates.y_scale,{screen:a}=this.model;function c(t,i,s,n){return a?t:"data"==i?s.v_compute(t):n.v_compute(t)}const h=c(t,this.model.xs_units,o,n.bbox.xview),r=c(i,this.model.ys_units,l,n.bbox.yview);e.beginPath();for(let t=0;t<s;t++)e.lineTo(h[t],r[t]);e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_value(e),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke())}}s.PolyAnnotationView=h,h.__name__="PolyAnnotationView";class r extends l.Annotation{constructor(t){super(t)}static init_PolyAnnotation(){this.prototype.default_view=h,this.mixins([a.Line,a.Fill,a.Hatch]),this.define((({Number:t,Array:i})=>({xs:[i(t),[]],xs_units:[c.SpatialUnits,"data"],ys:[i(t),[]],ys_units:[c.SpatialUnits,"data"]}))),this.internal((({Boolean:t})=>({screen:[t,!1]}))),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}update({xs:t,ys:i}){this.setv({xs:t,ys:i,screen:!0},{check_eq:!1})}}s.PolyAnnotation=r,r.__name__="PolyAnnotation",r.init_PolyAnnotation()},
function _(e,t,i,n,o){n();const s=e(1),l=e(40),r=s.__importStar(e(48));class c extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{gradient:e,y_intercept:t}=this.model;if(null==e||null==t)return;const{frame:i}=this.plot_view,n=this.coordinates.x_scale,o=this.coordinates.y_scale;let s,l,r,c;if(0==e)s=o.compute(t),l=s,r=i.bbox.left,c=r+i.bbox.width;else{s=i.bbox.top,l=s+i.bbox.height;const a=(o.invert(s)-t)/e,_=(o.invert(l)-t)/e;r=n.compute(a),c=n.compute(_)}const{ctx:a}=this.layer;a.save(),a.beginPath(),this.visuals.line.set_value(a),a.moveTo(r,s),a.lineTo(c,l),a.stroke(),a.restore()}}i.SlopeView=c,c.__name__="SlopeView";class a extends l.Annotation{constructor(e){super(e)}static init_Slope(){this.prototype.default_view=c,this.mixins(r.Line),this.define((({Number:e,Nullable:t})=>({gradient:[t(e),null],y_intercept:[t(e),null]}))),this.override({line_color:"black"})}}i.Slope=a,a.__name__="Slope",a.init_Slope()},
function _(e,i,t,n,o){n();const s=e(1),a=e(40),l=s.__importStar(e(48)),h=e(20);class c extends a.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.plot_view.request_paint(this)))}_render(){const{location:e}=this.model;if(null==e)return;const{frame:i}=this.plot_view,t=this.coordinates.x_scale,n=this.coordinates.y_scale,o=(i,t)=>"data"==this.model.location_units?i.compute(e):this.model.for_hover?e:t.compute(e);let s,a,l,h;"width"==this.model.dimension?(l=o(n,i.bbox.yview),a=i.bbox.left,h=i.bbox.width,s=this.model.line_width):(l=i.bbox.top,a=o(t,i.bbox.xview),h=this.model.line_width,s=i.bbox.height);const{ctx:c}=this.layer;c.save(),c.beginPath(),this.visuals.line.set_value(c),c.moveTo(a,l),"width"==this.model.dimension?c.lineTo(a+h,l):c.lineTo(a,l+s),c.stroke(),c.restore()}}t.SpanView=c,c.__name__="SpanView";class d extends a.Annotation{constructor(e){super(e)}static init_Span(){this.prototype.default_view=c,this.mixins(l.Line),this.define((({Number:e,Nullable:i})=>({render_mode:[h.RenderMode,"canvas"],location:[i(e),null],location_units:[h.SpatialUnits,"data"],dimension:[h.Dimension,"width"]}))),this.internal((({Boolean:e})=>({for_hover:[e,!1]}))),this.override({line_color:"black"})}}t.Span=d,d.__name__="Span",d.init_Span()},
function _(i,e,t,o,l){o();const s=i(40),a=i(235),n=i(122),r=i(43),_=i(140),h=i(99);class b extends s.AnnotationView{constructor(){super(...arguments),this._invalidate_toolbar=!0,this._previous_bbox=new h.BBox}update_layout(){this.layout=new _.SideLayout(this.panel,(()=>this.get_size()),!0)}initialize(){super.initialize(),this.el=r.div(),this.plot_view.canvas_view.add_event(this.el)}async lazy_initialize(){await super.lazy_initialize(),this._toolbar_view=await n.build_view(this.model.toolbar,{parent:this}),this.plot_view.visibility_callbacks.push((i=>this._toolbar_view.set_visibility(i)))}remove(){this._toolbar_view.remove(),r.remove(this.el),super.remove()}render(){this.model.visible||r.undisplay(this.el),super.render()}_render(){const{bbox:i}=this.layout;this._previous_bbox.equals(i)||(r.position(this.el,i),this._previous_bbox=i),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",this._toolbar_view.render(),r.empty(this.el),this.el.appendChild(this._toolbar_view.el),this._invalidate_toolbar=!1),r.display(this.el)}_get_size(){const{tools:i,logo:e}=this.model.toolbar;return{width:30*i.length+(null!=e?25:0),height:30}}}t.ToolbarPanelView=b,b.__name__="ToolbarPanelView";class d extends s.Annotation{constructor(i){super(i)}static init_ToolbarPanel(){this.prototype.default_view=b,this.define((({Ref:i})=>({toolbar:[i(a.Toolbar)]})))}}t.ToolbarPanel=d,d.__name__="ToolbarPanel",d.init_ToolbarPanel()},
function _(t,s,e,i,o){i();const c=t(8),n=t(9),a=t(13),l=t(236),r=t(237),_=t(247),p=t(248);e.Drag=l.Tool,e.Inspection=l.Tool,e.Scroll=l.Tool,e.Tap=l.Tool;const u=t=>{switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},h=t=>"tap"==t||"pan"==t;class v extends p.ToolbarBase{constructor(t){super(t)}static init_Toolbar(){this.prototype.default_view=p.ToolbarBaseView,this.define((({Or:t,Ref:s,Auto:i,Null:o,Nullable:c})=>({active_drag:[t(s(e.Drag),i,o),"auto"],active_inspect:[t(s(e.Inspection),i,o),"auto"],active_scroll:[t(s(e.Scroll),i,o),"auto"],active_tap:[t(s(e.Tap),i,o),"auto"],active_multi:[c(s(r.GestureTool)),null]})))}connect_signals(){super.connect_signals();const{tools:t,active_drag:s,active_inspect:e,active_scroll:i,active_tap:o,active_multi:c}=this.properties;this.on_change([t,s,e,i,o,c],(()=>this._init_tools()))}_init_tools(){if(super._init_tools(),"auto"==this.active_inspect);else if(this.active_inspect instanceof _.InspectTool){let t=!1;for(const s of this.inspectors)s!=this.active_inspect?s.active=!1:t=!0;t||(this.active_inspect=null)}else if(c.isArray(this.active_inspect)){const t=n.intersection(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)n.includes(this.active_inspect,t)||(t.active=!1)}else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of a.values(this.gestures)){t.tools=n.sort_by(t.tools,(t=>t.default_order));for(const s of t.tools)this.connect(s.properties.active.change,(()=>this._active_change(s)))}for(const[s,e]of a.entries(this.gestures)){const i=u(s);if(i){const o=this[i];"auto"==o?0!=e.tools.length&&h(s)&&t(e.tools[0]):null!=o&&(n.includes(this.tools,o)?t(o):this[i]=null)}}}}e.Toolbar=v,v.__name__="Toolbar",v.init_Toolbar()},
function _(t,e,n,i,o){i();const s=t(42),a=t(9),r=t(53);class l extends s.View{get plot_view(){return this.parent}get plot_model(){return this.parent.model}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>{this.model.active?this.activate():this.deactivate()}))}activate(){}deactivate(){}}n.ToolView=l,l.__name__="ToolView";class _ extends r.Model{constructor(t){super(t)}static init_Tool(){this.prototype._known_aliases=new Map,this.define((({String:t,Nullable:e})=>({description:[e(t),null]}))),this.internal((({Boolean:t})=>({active:[t,!1]})))}get synthetic_renderers(){return[]}_get_dim_limits([t,e],[n,i],o,s){const r=o.bbox.h_range;let l;"width"==s||"both"==s?(l=[a.min([t,n]),a.max([t,n])],l=[a.max([l[0],r.start]),a.min([l[1],r.end])]):l=[r.start,r.end];const _=o.bbox.v_range;let c;return"height"==s||"both"==s?(c=[a.min([e,i]),a.max([e,i])],c=[a.max([c[0],_.start]),a.min([c[1],_.end])]):c=[_.start,_.end],[l,c]}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}n.Tool=_,_.__name__="Tool",_.init_Tool()},
function _(e,o,t,s,n){s();const u=e(238),_=e(246);class l extends u.ButtonToolView{}t.GestureToolView=l,l.__name__="GestureToolView";class i extends u.ButtonTool{constructor(e){super(e),this.button_view=_.OnOffButtonView}}t.GestureTool=i,i.__name__="GestureTool"},
function _(t,e,o,i,s){i();const n=t(1),l=n.__importDefault(t(239)),r=t(240),a=t(236),u=t(43),h=t(34),_=t(8),c=t(9),d=n.__importStar(t(241)),m=d,p=n.__importDefault(t(242)),g=n.__importDefault(t(243)),v=t(244);class f extends r.DOMView{initialize(){super.initialize();const t=this.model.menu;if(null!=t){const e=this.parent.model.toolbar_location,o="left"==e||"above"==e,i=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new v.ContextMenu(o?c.reversed(t):t,{orientation:i,prevent_hide:t=>t.target==this.el})}this._hammer=new l.default(this.el,{touchAction:"auto",inputClass:l.default.TouchMouseInput}),this.connect(this.model.change,(()=>this.render())),this._hammer.on("tap",(t=>{var e;(null===(e=this._menu)||void 0===e?void 0:e.is_open)?this._menu.hide():t.target==this.el&&this._clicked()})),this._hammer.on("press",(()=>this._pressed()))}remove(){var t;this._hammer.destroy(),null===(t=this._menu)||void 0===t||t.remove(),super.remove()}styles(){return[...super.styles(),d.default,p.default,g.default]}css_classes(){return super.css_classes().concat(m.toolbar_button)}render(){u.empty(this.el);const t=this.model.computed_icon;_.isString(t)&&(h.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)}_pressed(){var t;const{left:e,top:o,right:i,bottom:s}=this.el.getBoundingClientRect(),n=(()=>{switch(this.parent.model.toolbar_location){case"right":return{right:e,top:o};case"left":return{left:i,top:o};case"above":return{left:e,top:s};case"below":return{left:e,bottom:o}}})();null===(t=this._menu)||void 0===t||t.toggle(n)}}o.ButtonToolButtonView=f,f.__name__="ButtonToolButtonView";class b extends a.ToolView{}o.ButtonToolView=b,b.__name__="ButtonToolView";class B extends a.Tool{constructor(t){super(t)}static init_ButtonTool(){this.internal((({Boolean:t})=>({disabled:[t,!1]})))}_get_dim_tooltip(t){const{description:e,tool_name:o}=this;return null!=e?e:"both"==t?o:`${o} (${"width"==t?"x":"y"}-axis)`}get tooltip(){var t;return null!==(t=this.description)&&void 0!==t?t:this.tool_name}get computed_icon(){return this.icon}get menu(){return null}}o.ButtonTool=B,B.__name__="ButtonTool",B.init_ButtonTool()},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(e,s,t,i,r){i();const n=e(42),a=e(43);class l extends n.View{initialize(){super.initialize(),this.el=this._createElement()}remove(){a.remove(this.el),super.remove()}css_classes(){return[]}render(){}renderTo(e){e.appendChild(this.el),this.render()}_createElement(){return a.createElement(this.tagName,{class:this.css_classes()})}}t.DOMView=l,l.__name__="DOMView",l.prototype.tagName="div"},
function _(o,b,t,r,e){r(),t.root="bk-root",t.toolbar_hidden="bk-toolbar-hidden",t.toolbar="bk-toolbar",t.button_bar="bk-button-bar",t.logo="bk-logo",t.above="bk-above",t.below="bk-below",t.left="bk-left",t.right="bk-right",t.toolbar_button="bk-toolbar-button",t.active="bk-active",t.default='.bk-root .bk-toolbar-hidden{visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-root .bk-toolbar,.bk-root .bk-button-bar{display:flex;display:-webkit-flex;flex-wrap:nowrap;-webkit-flex-wrap:nowrap;align-items:center;-webkit-align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-toolbar .bk-logo{flex-shrink:0;-webkit-flex-shrink:0;}.bk-root .bk-toolbar.bk-above,.bk-root .bk-toolbar.bk-below{flex-direction:row;-webkit-flex-direction:row;justify-content:flex-end;-webkit-justify-content:flex-end;}.bk-root .bk-toolbar.bk-above .bk-button-bar,.bk-root .bk-toolbar.bk-below .bk-button-bar{display:flex;display:-webkit-flex;flex-direction:row;-webkit-flex-direction:row;}.bk-root .bk-toolbar.bk-above .bk-logo,.bk-root .bk-toolbar.bk-below .bk-logo{order:1;-webkit-order:1;margin-left:5px;margin-right:0px;}.bk-root .bk-toolbar.bk-left,.bk-root .bk-toolbar.bk-right{flex-direction:column;-webkit-flex-direction:column;justify-content:flex-start;-webkit-justify-content:flex-start;}.bk-root .bk-toolbar.bk-left .bk-button-bar,.bk-root .bk-toolbar.bk-right .bk-button-bar{display:flex;display:-webkit-flex;flex-direction:column;-webkit-flex-direction:column;}.bk-root .bk-toolbar.bk-left .bk-logo,.bk-root .bk-toolbar.bk-right .bk-logo{order:0;-webkit-order:0;margin-bottom:5px;margin-top:0px;}.bk-root .bk-toolbar-button{width:30px;height:30px;cursor:pointer;background-size:60% 60%;background-origin:border-box;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-toolbar-button:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-root .bk-toolbar-button:focus{outline:none;}.bk-root .bk-toolbar-button::-moz-focus-inner{border:0;}.bk-root .bk-toolbar.bk-above .bk-toolbar-button{border-bottom:2px solid transparent;}.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active{border-bottom-color:#26aae1;}.bk-root .bk-toolbar.bk-below .bk-toolbar-button{border-top:2px solid transparent;}.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active{border-top-color:#26aae1;}.bk-root .bk-toolbar.bk-right .bk-toolbar-button{border-left:2px solid transparent;}.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active{border-left-color:#26aae1;}.bk-root .bk-toolbar.bk-left .bk-toolbar-button{border-right:2px solid transparent;}.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active{border-right-color:#26aae1;}.bk-root .bk-button-bar + .bk-button-bar:before{content:" ";display:inline-block;background-color:lightgray;}.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before{height:10px;width:1px;}.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before{height:1px;width:10px;}'},
function _(A,g,o,C,l){C(),o.root="bk-root",o.tool_icon_copy_to_clipboard="bk-tool-icon-copy-to-clipboard",o.tool_icon_replace_mode="bk-tool-icon-replace-mode",o.tool_icon_append_mode="bk-tool-icon-append-mode",o.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",o.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",o.tool_icon_clear_selection="bk-tool-icon-clear-selection",o.tool_icon_box_select="bk-tool-icon-box-select",o.tool_icon_box_zoom="bk-tool-icon-box-zoom",o.tool_icon_zoom_in="bk-tool-icon-zoom-in",o.tool_icon_zoom_out="bk-tool-icon-zoom-out",o.tool_icon_help="bk-tool-icon-help",o.tool_icon_hover="bk-tool-icon-hover",o.tool_icon_crosshair="bk-tool-icon-crosshair",o.tool_icon_lasso_select="bk-tool-icon-lasso-select",o.tool_icon_pan="bk-tool-icon-pan",o.tool_icon_xpan="bk-tool-icon-xpan",o.tool_icon_ypan="bk-tool-icon-ypan",o.tool_icon_range="bk-tool-icon-range",o.tool_icon_polygon_select="bk-tool-icon-polygon-select",o.tool_icon_redo="bk-tool-icon-redo",o.tool_icon_reset="bk-tool-icon-reset",o.tool_icon_save="bk-tool-icon-save",o.tool_icon_tap_select="bk-tool-icon-tap-select",o.tool_icon_undo="bk-tool-icon-undo",o.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",o.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",o.tool_icon_box_edit="bk-tool-icon-box-edit",o.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",o.tool_icon_poly_draw="bk-tool-icon-poly-draw",o.tool_icon_point_draw="bk-tool-icon-point-draw",o.tool_icon_poly_edit="bk-tool-icon-poly-edit",o.tool_icon_line_edit="bk-tool-icon-line-edit",o.default='.bk-root .bk-tool-icon-copy-to-clipboard{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-replace-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-append-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-intersect-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-subtract-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-clear-selection{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-box-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-box-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-zoom-in{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-zoom-out{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-help{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-crosshair{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-lasso-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-pan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-xpan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-ypan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-range{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-polygon-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-redo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-reset{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-save{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-tap-select{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-undo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-wheel-pan{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-wheel-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-box-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-freehand-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-point-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-line-edit{background-image:url("data:image/png;base64,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");}'},
function _(o,r,e,t,b){t(),e.root="bk-root",e.menu_icon="bk-menu-icon",e.context_menu="bk-context-menu",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.divider="bk-divider",e.active="bk-active",e.menu="bk-menu",e.above="bk-above",e.below="bk-below",e.caret="bk-caret",e.down="bk-down",e.up="bk-up",e.left="bk-left",e.right="bk-right",e.default=".bk-root .bk-menu-icon{width:28px;height:28px;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-context-menu{position:absolute;display:inline-flex;display:-webkit-inline-flex;flex-wrap:nowrap;-webkit-flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-context-menu.bk-horizontal{flex-direction:row;-webkit-flex-direction:row;}.bk-root .bk-context-menu.bk-vertical{flex-direction:column;-webkit-flex-direction:column;}.bk-root .bk-context-menu > .bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-context-menu.bk-horizontal > .bk-divider{width:1px;margin:5px 0;}.bk-root .bk-context-menu.bk-vertical > .bk-divider{height:1px;margin:0 5px;}.bk-root .bk-context-menu > :not(.bk-divider){border:1px solid transparent;}.bk-root .bk-context-menu > :not(.bk-divider).bk-active{border-color:#26aae1;}.bk-root .bk-context-menu > :not(.bk-divider):hover{background-color:#f9f9f9;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child{border-top-left-radius:4px;border-bottom-left-radius:4px;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child{border-top-right-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child{border-top-left-radius:4px;border-top-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child{border-bottom-left-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-menu.bk-above{bottom:100%;}.bk-root .bk-menu.bk-below{top:100%;}.bk-root .bk-menu > .bk-divider{height:1px;margin:7.5px 0;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-menu > :not(.bk-divider){padding:6px 12px;}.bk-root .bk-menu > :not(.bk-divider):hover,.bk-root .bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}.bk-root .bk-caret{display:inline-block;vertical-align:middle;width:0;height:0;margin:0 5px;}.bk-root .bk-caret.bk-down{border-top:4px solid;}.bk-root .bk-caret.bk-up{border-bottom:4px solid;}.bk-root .bk-caret.bk-down,.bk-root .bk-caret.bk-up{border-right:4px solid transparent;border-left:4px solid transparent;}.bk-root .bk-caret.bk-left{border-right:4px solid;}.bk-root .bk-caret.bk-right{border-left:4px solid;}.bk-root .bk-caret.bk-left,.bk-root .bk-caret.bk-right{border-top:4px solid transparent;border-bottom:4px solid transparent;}"},
function _(t,e,i,n,s){n();const o=t(1),l=t(43),h=t(245),d=o.__importStar(t(243));class r{constructor(t,e={}){this.items=t,this.options=e,this.el=l.div(),this._open=!1,this._item_click=t=>{var e;null===(e=this.items[t])||void 0===e||e.handler(),this.hide()},this._on_mousedown=t=>{var e,i;const{target:n}=t;n instanceof Node&&this.el.contains(n)||(null===(i=(e=this.options).prevent_hide)||void 0===i?void 0:i.call(e,t))||this.hide()},this._on_keydown=t=>{t.keyCode==l.Keys.Esc&&this.hide()},this._on_blur=()=>{this.hide()},l.undisplay(this.el)}get is_open(){return this._open}get can_open(){return 0!=this.items.length}remove(){l.remove(this.el),this._unlisten()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=this.el.parentElement;if(null!=e){const i=e.getBoundingClientRect();this.el.style.left=null!=t.left?t.left-i.left+"px":"",this.el.style.top=null!=t.top?t.top-i.top+"px":"",this.el.style.right=null!=t.right?i.right-t.right+"px":"",this.el.style.bottom=null!=t.bottom?i.bottom-t.bottom+"px":""}}render(){var t,e;l.empty(this.el,!0);const i=null!==(t=this.options.orientation)&&void 0!==t?t:"vertical";l.classes(this.el).add("bk-context-menu",`bk-${i}`);for(const[t,i]of h.enumerate(this.items)){let n;if(null==t)n=l.div({class:d.divider});else{if(null!=t.if&&!t.if())continue;{const i=null!=t.icon?l.div({class:["bk-menu-icon",t.icon]}):null;n=l.div({class:(null===(e=t.active)||void 0===e?void 0:e.call(t))?"bk-active":null,title:t.tooltip},i,t.label)}}n.addEventListener("click",(()=>this._item_click(i))),this.el.appendChild(n)}}show(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),l.display(this.el),this._listen(),this._open=!0}}hide(){this._open&&(this._open=!1,this._unlisten(),l.undisplay(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=r,r.__name__="ContextMenu"},
function _(n,e,o,t,r){t();const f=n(9);function*i(n,e){const o=n.length;if(e>o)return;const t=f.range(e);for(yield t.map((e=>n[e]));;){let r;for(const n of f.reversed(f.range(e)))if(t[n]!=n+o-e){r=n;break}if(null==r)return;t[r]+=1;for(const n of f.range(r+1,e))t[n]=t[n-1]+1;yield t.map((e=>n[e]))}}o.enumerate=function*(n){let e=0;for(const o of n)yield[o,e++]},o.combinations=i,o.subsets=function*(n){for(const e of f.range(n.length+1))yield*i(n,e)}},
function _(t,e,i,n,o){n();const s=t(1),c=t(238),l=s.__importStar(t(241)),a=t(43);class _ extends c.ButtonToolButtonView{render(){super.render(),a.classes(this.el).toggle(l.active,this.model.active)}_clicked(){const{active:t}=this.model;this.model.active=!t}}i.OnOffButtonView=_,_.__name__="OnOffButtonView"},
function _(t,e,o,n,s){n();const i=t(238),c=t(246);class l extends i.ButtonToolView{}o.InspectToolView=l,l.__name__="InspectToolView";class _ extends i.ButtonTool{constructor(t){super(t),this.event_type="move"}static init_InspectTool(){this.prototype.button_view=c.OnOffButtonView,this.define((({Boolean:t})=>({toggleable:[t,!0]}))),this.override({active:!0})}}o.InspectTool=_,_.__name__="InspectTool",_.init_InspectTool()},
function _(t,o,e,i,s){i();const l=t(1),n=t(19),a=t(43),r=t(122),c=t(240),_=t(20),u=t(9),h=t(13),v=t(8),p=t(249),d=t(99),b=t(53),g=t(236),f=t(237),m=t(251),w=t(252),y=t(247),T=l.__importStar(t(241)),z=T,B=l.__importStar(t(253)),x=B;class L extends b.Model{constructor(t){super(t)}static init_ToolbarViewModel(){this.define((({Boolean:t,Nullable:o})=>({_visible:[o(t),null],autohide:[t,!1]})))}get visible(){return!this.autohide||null!=this._visible&&this._visible}}e.ToolbarViewModel=L,L.__name__="ToolbarViewModel",L.init_ToolbarViewModel();class M extends c.DOMView{constructor(){super(...arguments),this.layout={bbox:new d.BBox}}initialize(){super.initialize(),this._tool_button_views=new Map,this._toolbar_view_model=new L({autohide:this.model.autohide})}async lazy_initialize(){await super.lazy_initialize(),await this._build_tool_button_views()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,(async()=>{await this._build_tool_button_views(),this.render()})),this.connect(this.model.properties.autohide.change,(()=>{this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(()=>this._on_visible_change()))}styles(){return[...super.styles(),T.default,B.default]}remove(){r.remove_views(this._tool_button_views),super.remove()}async _build_tool_button_views(){const t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;await r.build_views(this._tool_button_views,t,{parent:this},(t=>t.button_view))}set_visibility(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)}_on_visible_change(){const t=this._toolbar_view_model.visible,o=z.toolbar_hidden;this.el.classList.contains(o)&&t?this.el.classList.remove(o):t||this.el.classList.add(o)}render(){if(a.empty(this.el),this.el.classList.add(z.toolbar),this.el.classList.add(z[this.model.toolbar_location]),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){const t="grey"===this.model.logo?x.grey:null,o=a.a({href:"https://bokeh.org/",target:"_blank",class:[x.logo,x.logo_small,t]});this.el.appendChild(o)}for(const[,t]of this._tool_button_views)t.render();const t=[],o=t=>this._tool_button_views.get(t).el,{gestures:e}=this.model;for(const i of h.values(e))t.push(i.tools.map(o));t.push(this.model.actions.map(o)),t.push(this.model.inspectors.filter((t=>t.toggleable)).map(o));for(const o of t)if(0!==o.length){const t=a.div({class:z.button_bar},o);this.el.appendChild(t)}}update_layout(){}update_position(){}after_layout(){this._has_finished=!0}export(t,o=!0){const e="png"==t?"canvas":"svg",i=new p.CanvasLayer(e,o);return i.resize(0,0),i}}function V(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=M,M.__name__="ToolbarBaseView";class S extends b.Model{constructor(t){super(t)}static init_ToolbarBase(){this.prototype.default_view=M,this.define((({Boolean:t,Array:o,Ref:e,Nullable:i})=>({tools:[o(e(g.Tool)),[]],logo:[i(_.Logo),"normal"],autohide:[t,!1]}))),this.internal((({Array:t,Struct:o,Ref:e,Nullable:i})=>{const s=o({tools:t(e(f.GestureTool)),active:i(e(g.Tool))});return{gestures:[o({pan:s,scroll:s,pinch:s,tap:s,doubletap:s,press:s,pressup:s,rotate:s,move:s,multi:s}),V],actions:[t(e(m.ActionTool)),[]],inspectors:[t(e(y.InspectTool)),[]],help:[t(e(w.HelpTool)),[]],toolbar_location:[_.Location,"right"]}}))}initialize(){super.initialize(),this._init_tools()}_init_tools(){const t=function(t,o){if(t.length!=o.length)return!0;const e=new Set(o.map((t=>t.id)));return u.some(t,(t=>!e.has(t.id)))},o=this.tools.filter((t=>t instanceof y.InspectTool));t(this.inspectors,o)&&(this.inspectors=o);const e=this.tools.filter((t=>t instanceof w.HelpTool));t(this.help,e)&&(this.help=e);const i=this.tools.filter((t=>t instanceof m.ActionTool));t(this.actions,i)&&(this.actions=i);const s=(t,o)=>{t in this.gestures||n.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${o}`)},l={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)if(t instanceof f.GestureTool&&t.event_type)if(v.isString(t.event_type))l[t.event_type].tools.push(t),s(t.event_type,t);else{l.multi.tools.push(t);for(const o of t.event_type)s(o,t)}for(const o of Object.keys(l)){const e=this.gestures[o];t(e.tools,l[o].tools)&&(e.tools=l[o].tools),e.active&&u.every(e.tools,(t=>t.id!=e.active.id))&&(e.active=null)}}get horizontal(){return"above"===this.toolbar_location||"below"===this.toolbar_location}get vertical(){return"left"===this.toolbar_location||"right"===this.toolbar_location}_active_change(t){const{event_type:o}=t;if(null==o)return;const e=v.isString(o)?[o]:o;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(n.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,n.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}}e.ToolbarBase=S,S.__name__="ToolbarBase",S.init_ToolbarBase()},
function _(e,t,i,n,s){n();const o=e(250),a=e(99),r=e(43);function h(e){!function(e){void 0===e.lineDash&&Object.defineProperty(e,"lineDash",{get:()=>e.getLineDash(),set:t=>e.setLineDash(t)})}(e),function(e){e.setImageSmoothingEnabled=t=>{e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=()=>{const t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.ellipse||(e.ellipse=function(t,i,n,s,o,a,r,h=!1){const l=.551784;e.translate(t,i),e.rotate(o);let c=n,g=s;h&&(c=-n,g=-s),e.moveTo(-c,0),e.bezierCurveTo(-c,g*l,-c*l,g,0,g),e.bezierCurveTo(c*l,g,c,g*l,c,0),e.bezierCurveTo(c,-g*l,c*l,-g,0,-g),e.bezierCurveTo(-c*l,-g,-c,-g*l,-c,0),e.rotate(-o),e.translate(-t,-i)})}(e)}const l={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class c{constructor(e,t){switch(this.backend=e,this.hidpi=t,this.pixel_ratio=1,this.bbox=new a.BBox,e){case"webgl":case"canvas":{this._el=this._canvas=r.canvas({style:l});const e=this.canvas.getContext("2d");if(null==e)throw new Error("unable to obtain 2D rendering context");this._ctx=e,t&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const e=new o.SVGRenderingContext2D;this._ctx=e,this._canvas=e.get_svg(),this._el=r.div({style:l},this._canvas);break}}h(this._ctx)}get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}resize(e,t){this.bbox=new a.BBox({left:0,top:0,width:e,height:t});const i=this._ctx instanceof o.SVGRenderingContext2D?this._ctx:this.canvas;i.width=e*this.pixel_ratio,i.height=t*this.pixel_ratio}prepare(){const{ctx:e,hidpi:t,pixel_ratio:i}=this;e.save(),t&&(e.scale(i,i),e.translate(.5,.5)),this.clear()}clear(){const{x:e,y:t,width:i,height:n}=this.bbox;this.ctx.clearRect(e,t,i,n)}finish(){this.ctx.restore()}to_blob(){const{_canvas:e}=this;if(e instanceof HTMLCanvasElement)return null!=e.msToBlob?Promise.resolve(e.msToBlob()):new Promise(((t,i)=>{e.toBlob((e=>null!=e?t(e):i()),"image/png")}));{const e=this._ctx.get_serialized_svg(!0),t=new Blob([e],{type:"image/svg+xml"});return Promise.resolve(t)}}}i.CanvasLayer=c,c.__name__="CanvasLayer"},
function _(t,e,i,s,n){s();const r=t(168),a=t(8),o=t(43);function l(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");const e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";let i="";do{i="";for(let t=0;t<12;t++)i+=e[Math.floor(Math.random()*e.length)]}while(t[i]);return i}function h(t){var e;const i={left:"start",right:"end",center:"middle",start:"start",end:"end"};return null!==(e=i[t])&&void 0!==e?e:i.start}function c(t){var e;const i={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return null!==(e=i[t])&&void 0!==e?e:i.alphabetic}const _=function(t,e){const i=new Map,s=t.split(",");e=null!=e?e:10;for(let t=0;t<s.length;t+=2){const n="&"+s[t+1]+";",r=parseInt(s[t],e);i.set(n,"&#"+r+";")}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};class p{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",`${t}`),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,n,r,a]=t;i.setAttribute("stop-color",`rgb(${s},${n},${r})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}p.__name__="CanvasGradient";class d{constructor(t,e){this.__root=t,this.__ctx=e}}d.__name__="CanvasPattern";class m{constructor(t){var e,i,s;this.__currentPosition=null,this._transform=new r.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(i=null==t?void 0:t.width)&&void 0!==i?i:500,this.height=null!==(s=null==t?void 0:t.height)&&void 0!==s?s:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",`${t}`)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",`${t}`)}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const n=Object.keys(e);for(const t of n)s.setAttribute(t,`${e[t]}`);return s}__setDefaultStyles(){const t=Object.keys(u),e=this;for(let i=0;i<t.length;i++){const s=t[i];e[s]=u[s].canvas}}__applyStyleState(t){const e=Object.keys(t),i=this;for(let s=0;s<e.length;s++){const n=e[s];i[n]=t[n]}}__getStyleState(){const t=Object.keys(u),e={};for(let i=0;i<t.length;i++){const s=t[i];e[s]=this[s]}return e}__applyStyleToCurrentElement(t){var e;const i=this.__currentElement,s=Object.keys(u);for(let n=0;n<s.length;n++){const r=u[s[n]],o=this[s[n]];if(null===(e=r.apply)||void 0===e?void 0:e.includes(t))if(o instanceof d){for(const t of[...o.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids[e]=e,this.__defs.appendChild(t)}const t=o.__root.getAttribute("id");i.setAttribute(r.apply,`url(#${t})`)}else if(o instanceof p){const t=o.__root.getAttribute("id");i.setAttribute(r.apply,`url(#${t})`)}else if(r.svg!==o)if("stroke"!==r.svgAttr&&"fill"!==r.svgAttr||!a.isString(o)||-1===o.indexOf("rgba")){let e=r.svgAttr;if("globalAlpha"===s[n]&&(e=t+"-"+r.svgAttr,i.getAttribute(e)))continue;i.setAttribute(e,`${o}`)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(o),[,e,s,n,a]=t;i.setAttribute(r.svgAttr,`rgb(${e},${s},${n})`);let l=parseFloat(a);const h=this.globalAlpha;null!=h&&(l*=h),i.setAttribute(r.svgAttr+"-opacity",`${l}`)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(e)&&(e=e.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(const[t,i]of _){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,n,r){isFinite(t+e+i+s+n+r)&&this._transform.transform(t,e,i,s,n,r)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null;const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return!!this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;"path"!==this.__currentElement.nodeName&&this.beginPath();const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`M ${i} ${s}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,n,r){if(!isFinite(t+e+i+s+n+r))return;const[a,o]=this._transform.apply(n,r),[l,h]=this._transform.apply(t,e),[c,_]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${c} ${_} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[n,r]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(n,r,`Q ${a} ${o} ${n} ${r}`)}arcTo(t,e,i,s,n){if(!isFinite(t+e+i+s+n))return;if(null==this.__currentPosition)return;const r=this.__currentPosition.x,a=this.__currentPosition.y;if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(r===t&&a===e||t===i&&e===s||0===n)return void this.lineTo(t,e);function o([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const l=o([r-t,a-e]),h=o([i-t,s-e]);if(l[0]*h[1]==l[1]*h[0])return void this.lineTo(t,e);const c=l[0]*h[0]+l[1]*h[1],_=Math.acos(Math.abs(c)),u=o([l[0]+h[0],l[1]+h[1]]),p=n/Math.sin(_/2),d=t+p*u[0],m=e+p*u[1],f=[-l[1],l[0]],g=[h[1],-h[0]];function v(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const w=v(f),b=v(g);this.lineTo(d+f[0]*n,m+f[1]*n),this.arc(d,m,n,w,b)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(t){if("path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),"none"!=this.__currentElement.getAttribute("fill")){const t=this.__currentElement.cloneNode(!0);this.__root.appendChild(t),this.__currentElement=t}this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=t&&this.__currentElement.setAttribute("fill-rule",t),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&("path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e))}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){o.empty(this.__defs),o.empty(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const n=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[n,r]=this._transform.apply(t,e),[a,o]=this._transform.apply(i,s),h=this.__createElement("linearGradient",{id:l(this.__ids),x1:`${n}px`,x2:`${a}px`,y1:`${r}px`,y2:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(h),new p(h,this)}createRadialGradient(t,e,i,s,n,r){if(!isFinite(t+e+i+s+n+r))throw new Error("The provided double value is non-finite");const[a,o]=this._transform.apply(t,e),[h,c]=this._transform.apply(s,n),_=this.__createElement("radialGradient",{id:l(this.__ids),cx:`${h}px`,cy:`${c}px`,r:`${r}px`,fx:`${a}px`,fy:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(_),new p(_,this)}__parseFont(){var t,e,i,s,n;const r=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),a={style:null!==(t=r[1])&&void 0!==t?t:"normal",size:null!==(e=r[4])&&void 0!==e?e:"10px",family:null!==(i=r[6])&&void 0!==i?i:"sans-serif",weight:null!==(s=r[3])&&void 0!==s?s:"normal",decoration:null!==(n=r[2])&&void 0!==n?n:"normal"};return"underline"===this.__fontUnderline&&(a.decoration="underline"),null!=this.__fontHref&&(a.href=this.__fontHref),a}__wrapTextLink(t,e){if(t.href){const i=this.__createElement("a");return i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),i.appendChild(e),i}return e}__applyText(t,e,i,s){const n=this.__parseFont(),r=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:e,y:i,"text-anchor":h(this.textAlign),"dominant-baseline":c(this.textBaseline)},!0);r.appendChild(this.__document.createTextNode(t)),this._apply_transform(r),this.__currentElement=r,this.__applyStyleToCurrentElement(s),this.__root.appendChild(this.__wrapTextLink(n,r))}fillText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,n,r=!1){if(!isFinite(t+e+i+s+n))return;if(s===n)return;(s%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(r?-1:1))%(2*Math.PI));const a=t+i*Math.cos(n),o=e+i*Math.sin(n),l=t+i*Math.cos(s),h=e+i*Math.sin(s),c=r?0:1;let _=0,u=n-s;u<0&&(u+=2*Math.PI),_=r?u>Math.PI?0:1:u>Math.PI?1:0,this.lineTo(l,h);const p=i,d=i,[m,f]=this._transform.apply(a,o);this.__addPathCommand(m,f,`A ${p} ${d} 0 ${_} ${c} ${m} ${f}`)}clip(){const t=this.__createElement("clipPath"),e=l(this.__ids);this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path=`url(#${e})`}drawImage(t,...e){let i,s,n,r,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0,l=t.width,h=t.height,n=l,r=h}else if(4==e.length){if([i,s,n,r]=e,!isFinite(i+s+n+r))return;a=0,o=0,l=t.width,h=t.height}else{if(8!==e.length)throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);if([a,o,l,h,i,s,n,r]=e,!isFinite(a+o+l+h+i+s+n+r))return}const c=this.__root,_=this._transform.clone().translate(i,s);if(t instanceof m||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;_.is_identity?i=c:(i=this.__createElement("g"),this._apply_transform(i,_),c.appendChild(i));for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids[t]=t,this.__defs.appendChild(e)}}else i.appendChild(t)}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",`${n}`),e.setAttribute("height",`${r}`),e.setAttribute("preserveAspectRatio","none"),a||o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=n,e.height=r;e.getContext("2d").drawImage(t,a,o,l,h,0,0,n,r),t=e}this._apply_transform(e,_);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",i),c.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",`${n}`),e.setAttribute("height",`${r}`),e.setAttribute("preserveAspectRatio","none");const i=this.__document.createElement("canvas");i.width=n,i.height=r;const s=i.getContext("2d");s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,n,r),t=i,this._apply_transform(e,_),e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.toDataURL()),c.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=l(this.__ids);if(i.setAttribute("id",s),i.setAttribute("width",`${this._to_number(t.width)}`),i.setAttribute("height",`${this._to_number(t.height)}`),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof m){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e);this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e);this.__defs.appendChild(i)}return new d(i,this)}setLineDash(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null}_to_number(t){return a.isNumber(t)?t:t.baseVal.value}}i.SVGRenderingContext2D=m,m.__name__="SVGRenderingContext2D"},
function _(o,t,n,i,e){i();const s=o(238),c=o(15);class l extends s.ButtonToolButtonView{_clicked(){this.model.do.emit(void 0)}}n.ActionToolButtonView=l,l.__name__="ActionToolButtonView";class _ extends s.ButtonToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,(o=>this.doit(o)))}}n.ActionToolView=_,_.__name__="ActionToolView";class d extends s.ButtonTool{constructor(o){super(o),this.button_view=l,this.do=new c.Signal(this,"do")}}n.ActionTool=d,d.__name__="ActionTool"},
function _(o,e,t,i,l){i();const s=o(251),n=o(242);class r extends s.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=r,r.__name__="HelpToolView";class c extends s.ActionTool{constructor(o){super(o),this.tool_name="Help",this.icon=n.tool_icon_help}static init_HelpTool(){this.prototype.default_view=r,this.define((({String:o})=>({redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}))),this.override({description:"Click the question mark to learn more about Bokeh plot tools."}),this.register_alias("help",(()=>new c))}}t.HelpTool=c,c.__name__="HelpTool",c.init_HelpTool()},
function _(o,l,g,A,r){A(),g.root="bk-root",g.logo="bk-logo",g.grey="bk-grey",g.logo_small="bk-logo-small",g.logo_notebook="bk-logo-notebook",g.default=".bk-root .bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-root .bk-logo.bk-grey{filter:url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");filter:gray;-webkit-filter:grayscale(100%);}.bk-root .bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}.bk-root .bk-logo-notebook{display:inline-block;vertical-align:middle;margin-right:5px;}"},
function _(t,e,i,s,l){s();const o=t(1),n=t(40),h=t(20),a=t(43),r=o.__importStar(t(255)),c=r;class d extends n.AnnotationView{initialize(){super.initialize(),this.el=a.div({class:c.tooltip}),a.undisplay(this.el),this.plot_view.canvas_view.add_overlay(this.el)}remove(){a.remove(this.el),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.content.change,(()=>this.render())),this.connect(this.model.properties.position.change,(()=>this._reposition()))}styles(){return[...super.styles(),r.default]}render(){this.model.visible||a.undisplay(this.el),super.render()}_render(){const{content:t}=this.model;null!=t?(a.empty(this.el),a.classes(this.el).toggle("bk-tooltip-custom",this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(c.tooltip_arrow)):a.undisplay(this.el)}_reposition(){const{position:t}=this.model;if(null==t)return void a.undisplay(this.el);const[e,i]=t,s=(()=>{const t=this.parent.layout.bbox.relative(),{attachment:s}=this.model;switch(s){case"horizontal":return e<t.hcenter?"right":"left";case"vertical":return i<t.vcenter?"below":"above";default:return s}})();let l;this.el.classList.remove(c.right),this.el.classList.remove(c.left),this.el.classList.remove(c.above),this.el.classList.remove(c.below),a.display(this.el);let o=null,n=null;switch(s){case"right":this.el.classList.add(c.left),o=e+(this.el.offsetWidth-this.el.clientWidth)+10,l=i-this.el.offsetHeight/2;break;case"left":this.el.classList.add(c.right),n=this.plot_view.layout.bbox.width-e+10,l=i-this.el.offsetHeight/2;break;case"below":this.el.classList.add(c.above),l=i+(this.el.offsetHeight-this.el.clientHeight)+10,o=Math.round(e-this.el.offsetWidth/2);break;case"above":this.el.classList.add(c.below),l=i-this.el.offsetHeight-10,o=Math.round(e-this.el.offsetWidth/2)}this.el.style.top=`${l}px`,this.el.style.left=null!=o?`${o}px`:"auto",this.el.style.right=null!=n?`${n}px`:"auto"}}i.TooltipView=d,d.__name__="TooltipView";class p extends n.Annotation{constructor(t){super(t)}static init_Tooltip(){this.prototype.default_view=d,this.define((({Boolean:t})=>({attachment:[h.TooltipAttachment,"horizontal"],inner_only:[t,!0],show_arrow:[t,!0]}))),this.internal((({Boolean:t,Number:e,Tuple:i,Ref:s,Nullable:l})=>({position:[l(i(e,e)),null],content:[s(HTMLElement),()=>a.div()],custom:[t]}))),this.override({level:"overlay"})}clear(){this.position=null}}i.Tooltip=p,p.__name__="Tooltip",p.init_Tooltip()},
function _(o,t,r,e,l){e(),r.root="bk-root",r.tooltip="bk-tooltip",r.left="bk-left",r.tooltip_arrow="bk-tooltip-arrow",r.right="bk-right",r.above="bk-above",r.below="bk-below",r.tooltip_row_label="bk-tooltip-row-label",r.tooltip_row_value="bk-tooltip-row-value",r.tooltip_color_block="bk-tooltip-color-block",r.default='.bk-root{}.bk-root .bk-tooltip{font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid #e5e5e5;color:#2f2f2f;background-color:white;pointer-events:none;opacity:0.95;z-index:100;}.bk-root .bk-tooltip > div:not(:first-child){margin-top:5px;border-top:#e5e5e5 1px dashed;}.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-left::before{left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-right::after{right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-above::before{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;top:-10px;border-bottom-width:10px;border-bottom-color:#909599;}.bk-root .bk-tooltip.bk-below::after{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;bottom:-10px;border-top-width:10px;border-top-color:#909599;}.bk-root .bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-root .bk-tooltip-row-value{color:default;}.bk-root .bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}'},
function _(e,t,i,s,r){s();const a=e(135),h=e(133),_=e(122),l=e(48);class o extends a.UpperLowerView{async lazy_initialize(){await super.lazy_initialize();const{lower_head:e,upper_head:t}=this.model;null!=e&&(this.lower_head=await _.build_view(e,{parent:this})),null!=t&&(this.upper_head=await _.build_view(t,{parent:this}))}set_data(e){var t,i;super.set_data(e),null===(t=this.lower_head)||void 0===t||t.set_data(e),null===(i=this.upper_head)||void 0===i||i.set_data(e)}paint(e){if(this.visuals.line.doit)for(let t=0,i=this._lower_sx.length;t<i;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(let i=0,s=this._lower_sx.length;i<s;i++)e.save(),e.translate(this._lower_sx[i],this._lower_sy[i]),e.rotate(t+Math.PI),this.lower_head.render(e,i),e.restore();if(null!=this.upper_head)for(let i=0,s=this._upper_sx.length;i<s;i++)e.save(),e.translate(this._upper_sx[i],this._upper_sy[i]),e.rotate(t),this.upper_head.render(e,i),e.restore()}}i.WhiskerView=o,o.__name__="WhiskerView";class n extends a.UpperLower{constructor(e){super(e)}static init_Whisker(){this.prototype.default_view=o,this.mixins(l.LineVector),this.define((({Ref:e,Nullable:t})=>({lower_head:[t(e(h.ArrowHead)),()=>new h.TeeHead({size:10})],upper_head:[t(e(h.ArrowHead)),()=>new h.TeeHead({size:10})]}))),this.override({level:"underlay"})}}i.Whisker=n,n.__name__="Whisker",n.init_Whisker()},
function _(n,o,t,u,e){u(),e("CustomJS",n(258).CustomJS),e("OpenURL",n(260).OpenURL)},
function _(t,s,e,n,c){n();const u=t(259),i=t(13),a=t(34);class r extends u.Callback{constructor(t){super(t)}static init_CustomJS(){this.define((({Unknown:t,String:s,Dict:e})=>({args:[e(t),{}],code:[s,""]})))}get names(){return i.keys(this.args)}get values(){return i.values(this.args)}get func(){const t=a.use_strict(this.code);return new Function(...this.names,"cb_obj","cb_data",t)}execute(t,s={}){return this.func.apply(t,this.values.concat(t,s))}}e.CustomJS=r,r.__name__="CustomJS",r.init_CustomJS()},
function _(c,a,l,n,s){n();const e=c(53);class o extends e.Model{constructor(c){super(c)}}l.Callback=o,o.__name__="Callback"},
function _(e,n,t,o,i){o();const s=e(259),c=e(182),r=e(8);class a extends s.Callback{constructor(e){super(e)}static init_OpenURL(){this.define((({Boolean:e,String:n})=>({url:[n,"http://"],same_tab:[e,!1]})))}execute(e,{source:n}){const t=e=>{const t=c.replace_placeholders(this.url,n,e,void 0,void 0,encodeURIComponent);if(!r.isString(t))throw new Error("HTML output is not supported in this context");this.same_tab?window.location.href=t:window.open(t)},{selected:o}=n;for(const e of o.indices)t(e);for(const e of o.line_indices)t(e)}}t.OpenURL=a,a.__name__="OpenURL",a.init_OpenURL()},
function _(a,n,e,r,s){r(),s("Canvas",a(262).Canvas),s("CartesianFrame",a(144).CartesianFrame)},
function _(e,t,s,i,a){i();const l=e(14),n=e(240),r=e(19),o=e(43),h=e(20),_=e(13),c=e(263),d=e(99),p=e(249),v=(()=>{const e=document.createElement("canvas"),t=e.getContext("webgl",{premultipliedAlpha:!0});return null!=t?{canvas:e,gl:t}:void r.logger.trace("WebGL is not supported")})(),u={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class b extends n.DOMView{constructor(){super(...arguments),this.bbox=new d.BBox}initialize(){super.initialize(),"webgl"==this.model.output_backend&&(this.webgl=v),this.underlays_el=o.div({style:u}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=o.div({style:u}),this.events_el=o.div({class:"bk-canvas-events",style:u});const e=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];_.extend(this.el.style,u),o.append(this.el,...e),this.ui_event_bus=new c.UIEventBus(this)}remove(){this.ui_event_bus.destroy(),super.remove()}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}resize(e,t){this.bbox=new d.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:s,height:i}=this.bbox;t.canvas.width=this.pixel_ratio*s,t.canvas.height=this.pixel_ratio*i;const{gl:a}=t;a.enable(a.SCISSOR_TEST);const[l,n,r,o]=e,{xview:h,yview:_}=this.bbox,c=h.compute(l),d=_.compute(n+o),p=this.pixel_ratio;a.scissor(p*c,p*d,p*r,p*o),a.enable(a.BLEND),a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE_MINUS_DST_ALPHA,a.ONE),this._clear_webgl()}}blit_webgl(e){const{webgl:t}=this;if(null!=t){if(r.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}this._clear_webgl()}}_clear_webgl(){const{webgl:e}=this;if(null!=e){const{gl:t,canvas:s}=e;t.viewport(0,0,s.width,s.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}}compose(){const e=this.create_layer(),{width:t,height:s}=this.bbox;return e.resize(t,s),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e}create_layer(){const{output_backend:e,hidpi:t}=this.model;return new p.CanvasLayer(e,t)}to_blob(){return this.compose().to_blob()}}s.CanvasView=b,b.__name__="CanvasView";class g extends l.HasProps{constructor(e){super(e)}static init_Canvas(){this.prototype.default_view=b,this.internal((({Boolean:e})=>({hidpi:[e,!0],output_backend:[h.OutputBackend,"canvas"]})))}}s.Canvas=g,g.__name__="Canvas",g.init_Canvas()},
function _(t,e,s,n,i){n();const r=t(1),a=r.__importDefault(t(239)),_=t(15),h=t(19),o=t(43),l=r.__importStar(t(264)),c=t(265),p=t(9),u=t(8),v=t(27),d=t(244);class g{constructor(t){this.canvas_view=t,this.pan_start=new _.Signal(this,"pan:start"),this.pan=new _.Signal(this,"pan"),this.pan_end=new _.Signal(this,"pan:end"),this.pinch_start=new _.Signal(this,"pinch:start"),this.pinch=new _.Signal(this,"pinch"),this.pinch_end=new _.Signal(this,"pinch:end"),this.rotate_start=new _.Signal(this,"rotate:start"),this.rotate=new _.Signal(this,"rotate"),this.rotate_end=new _.Signal(this,"rotate:end"),this.tap=new _.Signal(this,"tap"),this.doubletap=new _.Signal(this,"doubletap"),this.press=new _.Signal(this,"press"),this.pressup=new _.Signal(this,"pressup"),this.move_enter=new _.Signal(this,"move:enter"),this.move=new _.Signal(this,"move"),this.move_exit=new _.Signal(this,"move:exit"),this.scroll=new _.Signal(this,"scroll"),this.keydown=new _.Signal(this,"keydown"),this.keyup=new _.Signal(this,"keyup"),this.hammer=new a.default(this.hit_area,{touchAction:"auto",inputClass:a.default.TouchMouseInput}),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(t=>this._mouse_move(t))),this.hit_area.addEventListener("mouseenter",(t=>this._mouse_enter(t))),this.hit_area.addEventListener("mouseleave",(t=>this._mouse_exit(t))),this.hit_area.addEventListener("contextmenu",(t=>this._context_menu(t))),this.hit_area.addEventListener("wheel",(t=>this._mouse_wheel(t))),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new d.ContextMenu([],{prevent_hide:t=>2==t.button&&t.target==this.hit_area}),this.hit_area.appendChild(this.menu.el)}get hit_area(){return this.canvas_view.events_el}destroy(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(t=>this._doubletap(t))),this.hammer.on("tap",(t=>this._tap(t))),this.hammer.on("press",(t=>this._press(t))),this.hammer.on("pressup",(t=>this._pressup(t))),this.hammer.get("pan").set({direction:a.default.DIRECTION_ALL}),this.hammer.on("panstart",(t=>this._pan_start(t))),this.hammer.on("pan",(t=>this._pan(t))),this.hammer.on("panend",(t=>this._pan_end(t))),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(t=>this._pinch_start(t))),this.hammer.on("pinch",(t=>this._pinch(t))),this.hammer.on("pinchend",(t=>this._pinch_end(t))),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(t=>this._rotate_start(t))),this.hammer.on("rotate",(t=>this._rotate(t))),this.hammer.on("rotateend",(t=>this._rotate_end(t)))}register_tool(t){const e=t.model.event_type;null!=e&&(u.isString(e)?this._register_tool(t,e):e.forEach(((e,s)=>this._register_tool(t,e,s<1))))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,r=t=>e=>{e.id==i&&t(e.e)},a=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,r(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,r(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,r(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,r(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,r(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,r(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,r(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,r(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,r(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,r(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,r(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,r(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,r(n._tap.bind(n))),null!=n._doubletap&&n.connect(this.doubletap,r(n._doubletap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,r(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,r(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,r(n._scroll.bind(n)));break;default:throw new Error(`unsupported event_type: ${e}`)}s&&(null!=n._keydown&&n.connect(this.keydown,a(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,a(n._keyup.bind(n))),v.is_mobile&&null!=n._scroll&&"pinch"==e&&(h.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,r(n._scroll.bind(n)))))}_hit_test_renderers(t,e,s){var n;const i=t.get_renderer_views();for(const t of p.reversed(i))if(null===(n=t.interactive_hit)||void 0===n?void 0:n.call(t,e,s))return t;return null}set_cursor(t="default"){this.hit_area.style.cursor=t}_hit_test_frame(t,e,s){return t.frame.bbox.contains(e,s)}_hit_test_canvas(t,e,s){return t.layout.bbox.contains(e,s)}_hit_test_plot(t,e){for(const s of this.canvas_view.plot_views)if(s.layout.bbox.relative().contains(t,e))return s;return null}_trigger(t,e,s){var n;const{sx:i,sy:r}=e,a=this._hit_test_plot(i,r),_=t=>{const[s,n]=[i,r];return Object.assign(Object.assign({},e),{sx:s,sy:n})};if("panstart"==e.type||"pan"==e.type||"panend"==e.type){let n;if("panstart"==e.type&&null!=a?(this._curr_pan={plot_view:a},n=a):"pan"==e.type&&null!=this._curr_pan?n=this._curr_pan.plot_view:"panend"==e.type&&null!=this._curr_pan?(n=this._curr_pan.plot_view,this._curr_pan=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("pinchstart"==e.type||"pinch"==e.type||"pinchend"==e.type){let n;if("pinchstart"==e.type&&null!=a?(this._curr_pinch={plot_view:a},n=a):"pinch"==e.type&&null!=this._curr_pinch?n=this._curr_pinch.plot_view:"pinchend"==e.type&&null!=this._curr_pinch?(n=this._curr_pinch.plot_view,this._curr_pinch=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("rotatestart"==e.type||"rotate"==e.type||"rotateend"==e.type){let n;if("rotatestart"==e.type&&null!=a?(this._curr_rotate={plot_view:a},n=a):"rotate"==e.type&&null!=this._curr_rotate?n=this._curr_rotate.plot_view:"rotateend"==e.type&&null!=this._curr_rotate?(n=this._curr_rotate.plot_view,this._curr_rotate=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("mouseenter"==e.type||"mousemove"==e.type||"mouseleave"==e.type){const h=null===(n=this._prev_move)||void 0===n?void 0:n.plot_view;if(null!=h&&("mouseleave"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(h,this.move_exit,{type:"mouseleave",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&("mouseenter"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(a,this.move_enter,{type:"mouseenter",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&"mousemove"==e.type){const e=_();this.__trigger(a,t,e,s)}this._prev_move={sx:i,sy:r,plot_view:a}}else if(null!=a){const e=_();this.__trigger(a,t,e,s)}}__trigger(t,e,s,n){var i,r;const a=t.model.toolbar.gestures,_=e.name.split(":")[0],h=this._hit_test_renderers(t,s.sx,s.sy),o=this._hit_test_canvas(t,s.sx,s.sy);switch(_){case"move":{const n=a[_].active;null!=n&&this.trigger(e,s,n.id);const r=t.model.toolbar.inspectors.filter((t=>t.active));let l="default";null!=h?(l=null!==(i=h.cursor(s.sx,s.sy))&&void 0!==i?i:l,p.is_empty(r)||(e=this.move_exit)):this._hit_test_frame(t,s.sx,s.sy)&&(p.is_empty(r)||(l="crosshair")),this.set_cursor(l),t.set_toolbar_visibility(o),r.map((t=>this.trigger(e,s,t.id)));break}case"tap":{const{target:t}=n;if(null!=t&&t!=this.hit_area)return;null!=h&&null!=h.on_hit&&h.on_hit(s.sx,s.sy);const i=a[_].active;null!=i&&this.trigger(e,s,i.id);break}case"doubletap":{const t=null!==(r=a.doubletap.active)&&void 0!==r?r:a.tap.active;null!=t&&this.trigger(e,s,t.id);break}case"scroll":{const t=a[v.is_mobile?"pinch":"scroll"].active;null!=t&&(n.preventDefault(),n.stopPropagation(),this.trigger(e,s,t.id));break}case"pan":{const t=a[_].active;null!=t&&(n.preventDefault(),this.trigger(e,s,t.id));break}default:{const t=a[_].active;null!=t&&this.trigger(e,s,t.id)}}this._trigger_bokeh_event(t,s)}trigger(t,e,s=null){t.emit({id:s,e})}_trigger_bokeh_event(t,e){const s=(()=>{const{sx:s,sy:n}=e,i=t.frame.x_scale.invert(s),r=t.frame.y_scale.invert(n);switch(e.type){case"wheel":return new l.MouseWheel(s,n,i,r,e.delta);case"mousemove":return new l.MouseMove(s,n,i,r);case"mouseenter":return new l.MouseEnter(s,n,i,r);case"mouseleave":return new l.MouseLeave(s,n,i,r);case"tap":return new l.Tap(s,n,i,r);case"doubletap":return new l.DoubleTap(s,n,i,r);case"press":return new l.Press(s,n,i,r);case"pressup":return new l.PressUp(s,n,i,r);case"pan":return new l.Pan(s,n,i,r,e.deltaX,e.deltaY);case"panstart":return new l.PanStart(s,n,i,r);case"panend":return new l.PanEnd(s,n,i,r);case"pinch":return new l.Pinch(s,n,i,r,e.scale);case"pinchstart":return new l.PinchStart(s,n,i,r);case"pinchend":return new l.PinchEnd(s,n,i,r);case"rotate":return new l.Rotate(s,n,i,r,e.rotation);case"rotatestart":return new l.RotateStart(s,n,i,r);case"rotateend":return new l.RotateEnd(s,n,i,r);default:return}})();null!=s&&t.model.trigger_event(s)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=o.offset(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_move_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:c.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){this._trigger(this.doubletap,this._tap_event(t),t.srcEvent)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_context_menu(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();const{sx:e,sy:s}=this._get_sxy(t);this.menu.toggle({left:e,top:s})}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEventBus=g,g.__name__="UIEventBus"},
function _(e,t,s,n,_){n();var a=this&&this.__decorate||function(e,t,s,n){var _,a=arguments.length,o=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,n);else for(var c=e.length-1;c>=0;c--)(_=e[c])&&(o=(a<3?_(o):a>3?_(t,s,o):_(t,s))||o);return a>3&&o&&Object.defineProperty(t,s,o),o};function o(e){return function(t){t.prototype.event_name=e}}class c{to_json(){const{event_name:e}=this;return{event_name:e,event_values:this._to_json()}}}s.BokehEvent=c,c.__name__="BokehEvent";class r extends c{constructor(){super(...arguments),this.origin=null}_to_json(){return{model:this.origin}}}s.ModelEvent=r,r.__name__="ModelEvent";let l=class extends c{_to_json(){return{}}};s.DocumentReady=l,l.__name__="DocumentReady",s.DocumentReady=l=a([o("document_ready")],l);let i=class extends r{};s.ButtonClick=i,i.__name__="ButtonClick",s.ButtonClick=i=a([o("button_click")],i);let u=class extends r{constructor(e){super(),this.item=e}_to_json(){const{item:e}=this;return Object.assign(Object.assign({},super._to_json()),{item:e})}};s.MenuItemClick=u,u.__name__="MenuItemClick",s.MenuItemClick=u=a([o("menu_item_click")],u);class d extends r{}s.UIEvent=d,d.__name__="UIEvent";let h=class extends d{};s.LODStart=h,h.__name__="LODStart",s.LODStart=h=a([o("lodstart")],h);let m=class extends d{};s.LODEnd=m,m.__name__="LODEnd",s.LODEnd=m=a([o("lodend")],m);let x=class extends d{constructor(e,t){super(),this.geometry=e,this.final=t}_to_json(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super._to_json()),{geometry:e,final:t})}};s.SelectionGeometry=x,x.__name__="SelectionGeometry",s.SelectionGeometry=x=a([o("selectiongeometry")],x);let p=class extends d{};s.Reset=p,p.__name__="Reset",s.Reset=p=a([o("reset")],p);class j extends d{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}_to_json(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super._to_json()),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=j,j.__name__="PointEvent";let y=class extends j{constructor(e,t,s,n,_,a){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta_x=_,this.delta_y=a}_to_json(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super._to_json()),{delta_x:e,delta_y:t})}};s.Pan=y,y.__name__="Pan",s.Pan=y=a([o("pan")],y);let P=class extends j{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.scale=_}_to_json(){const{scale:e}=this;return Object.assign(Object.assign({},super._to_json()),{scale:e})}};s.Pinch=P,P.__name__="Pinch",s.Pinch=P=a([o("pinch")],P);let v=class extends j{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.rotation=_}_to_json(){const{rotation:e}=this;return Object.assign(Object.assign({},super._to_json()),{rotation:e})}};s.Rotate=v,v.__name__="Rotate",s.Rotate=v=a([o("rotate")],v);let g=class extends j{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta=_}_to_json(){const{delta:e}=this;return Object.assign(Object.assign({},super._to_json()),{delta:e})}};s.MouseWheel=g,g.__name__="MouseWheel",s.MouseWheel=g=a([o("wheel")],g);let E=class extends j{};s.MouseMove=E,E.__name__="MouseMove",s.MouseMove=E=a([o("mousemove")],E);let O=class extends j{};s.MouseEnter=O,O.__name__="MouseEnter",s.MouseEnter=O=a([o("mouseenter")],O);let b=class extends j{};s.MouseLeave=b,b.__name__="MouseLeave",s.MouseLeave=b=a([o("mouseleave")],b);let M=class extends j{};s.Tap=M,M.__name__="Tap",s.Tap=M=a([o("tap")],M);let R=class extends j{};s.DoubleTap=R,R.__name__="DoubleTap",s.DoubleTap=R=a([o("doubletap")],R);let f=class extends j{};s.Press=f,f.__name__="Press",s.Press=f=a([o("press")],f);let S=class extends j{};s.PressUp=S,S.__name__="PressUp",s.PressUp=S=a([o("pressup")],S);let D=class extends j{};s.PanStart=D,D.__name__="PanStart",s.PanStart=D=a([o("panstart")],D);let k=class extends j{};s.PanEnd=k,k.__name__="PanEnd",s.PanEnd=k=a([o("panend")],k);let L=class extends j{};s.PinchStart=L,L.__name__="PinchStart",s.PinchStart=L=a([o("pinchstart")],L);let C=class extends j{};s.PinchEnd=C,C.__name__="PinchEnd",s.PinchEnd=C=a([o("pinchend")],C);let T=class extends j{};s.RotateStart=T,T.__name__="RotateStart",s.RotateStart=T=a([o("rotatestart")],T);let B=class extends j{};s.RotateEnd=B,B.__name__="RotateEnd",s.RotateEnd=B=a([o("rotateend")],B)},
function _(t,e,n,l,o){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function u(t){const e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}l(),n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=(n=t.target,null!==(a=null!==(o=u(null!==(l=n.offsetParent)&&void 0!==l?l:document.body))&&void 0!==o?o:u(n))&&void 0!==a?a:16);break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n,l,o,a;return e}},
function _(m,i,u,s,a){s(),a("Expression",m(124).Expression),a("CustomJSExpr",m(267).CustomJSExpr),a("Stack",m(268).Stack),a("CumSum",m(269).CumSum),a("ScalarExpression",m(124).ScalarExpression),a("Minimum",m(270).Minimum),a("Maximum",m(271).Maximum)},
function _(t,e,s,n,r){n();const i=t(14),o=t(124),a=t(24),c=t(9),u=t(13),l=t(34),h=t(8);class p extends o.Expression{constructor(t){super(t)}static init_CustomJSExpr(){this.define((({Unknown:t,String:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))}connect_signals(){super.connect_signals();for(const t of u.values(this.args))t instanceof i.HasProps&&t.change.connect((()=>{this._result.clear(),this.change.emit()}))}get names(){return u.keys(this.args)}get values(){return u.values(this.args)}get func(){const t=l.use_strict(this.code);return new a.GeneratorFunction(...this.names,t)}_v_compute(t){const e=this.func.apply(t,this.values);let s=e.next();if(s.done&&void 0!==s.value){const{value:e}=s;return h.isArray(e)||h.isTypedArray(e)?e:h.isIterable(e)?[...e]:c.repeat(e,t.length)}{const t=[];do{t.push(s.value),s=e.next()}while(!s.done);return t}}}s.CustomJSExpr=p,p.__name__="CustomJSExpr",p.init_CustomJSExpr()},
function _(t,n,e,i,s){i();const a=t(124);class c extends a.Expression{constructor(t){super(t)}static init_Stack(){this.define((({String:t,Array:n})=>({fields:[n(t),[]]})))}_v_compute(t){var n;const e=null!==(n=t.get_length())&&void 0!==n?n:0,i=new Float64Array(e);for(const n of this.fields){const s=t.data[n];if(null!=s)for(let t=0,n=Math.min(e,s.length);t<n;t++)i[t]+=s[t]}return i}}e.Stack=c,c.__name__="Stack",c.init_Stack()},
function _(e,t,n,i,u){i();const o=e(124);class r extends o.Expression{constructor(e){super(e)}static init_CumSum(){this.define((({Boolean:e,String:t})=>({field:[t],include_zero:[e,!1]})))}_v_compute(e){var t;const n=new Float64Array(null!==(t=e.get_length())&&void 0!==t?t:0),i=e.data[this.field],u=this.include_zero?1:0;n[0]=this.include_zero?0:i[0];for(let e=1;e<n.length;e++)n[e]=n[e-1]+i[e-u];return n}}n.CumSum=r,r.__name__="CumSum",r.init_CumSum()},
function _(i,n,t,l,u){l();const e=i(124),m=i(9);class s extends e.ScalarExpression{constructor(i){super(i)}static init_Minimum(){this.define((({Number:i,String:n,Nullable:t})=>({field:[n],initial:[t(i),null]})))}_compute(i){var n,t;const l=null!==(n=i.data[this.field])&&void 0!==n?n:[];return Math.min(null!==(t=this.initial)&&void 0!==t?t:1/0,m.min(l))}}t.Minimum=s,s.__name__="Minimum",s.init_Minimum()},
function _(i,t,a,n,l){n();const u=i(124),e=i(9);class m extends u.ScalarExpression{constructor(i){super(i)}static init_Maximum(){this.define((({Number:i,String:t,Nullable:a})=>({field:[t],initial:[a(i),null]})))}_compute(i){var t,a;const n=null!==(t=i.data[this.field])&&void 0!==t?t:[];return Math.max(null!==(a=this.initial)&&void 0!==a?a:-1/0,e.max(n))}}a.Maximum=m,m.__name__="Maximum",m.init_Maximum()},
function _(e,t,l,r,i){r(),i("BooleanFilter",e(273).BooleanFilter),i("CustomJSFilter",e(274).CustomJSFilter),i("Filter",e(121).Filter),i("GroupFilter",e(275).GroupFilter),i("IndexFilter",e(276).IndexFilter)},
function _(e,n,l,o,t){o();const i=e(121),s=e(24);class a extends i.Filter{constructor(e){super(e)}static init_BooleanFilter(){this.define((({Boolean:e,Array:n,Nullable:l})=>({booleans:[l(n(e)),null]})))}compute_indices(e){const n=e.length,{booleans:l}=this;return null==l?s.Indices.all_set(n):s.Indices.from_booleans(n,l)}}l.BooleanFilter=a,a.__name__="BooleanFilter",a.init_BooleanFilter()},
function _(e,t,s,n,r){n();const i=e(121),o=e(24),u=e(13),c=e(8),a=e(34);class l extends i.Filter{constructor(e){super(e)}static init_CustomJSFilter(){this.define((({Unknown:e,String:t,Dict:s})=>({args:[s(e),{}],code:[t,""]})))}get names(){return u.keys(this.args)}get values(){return u.values(this.args)}get func(){const e=a.use_strict(this.code);return new Function(...this.names,"source",e)}compute_indices(e){const t=e.length,s=this.func(...this.values,e);if(null==s)return o.Indices.all_set(t);if(c.isArrayOf(s,c.isInteger))return o.Indices.from_indices(t,s);if(c.isArrayOf(s,c.isBoolean))return o.Indices.from_booleans(t,s);throw new Error(`expect an array of integers or booleans, or null, got ${s}`)}}s.CustomJSFilter=l,l.__name__="CustomJSFilter",l.init_CustomJSFilter()},
function _(n,t,e,i,o){i();const r=n(121),u=n(24),s=n(19);class c extends r.Filter{constructor(n){super(n)}static init_GroupFilter(){this.define((({String:n})=>({column_name:[n],group:[n]})))}compute_indices(n){const t=n.get_column(this.column_name);if(null==t)return s.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),new u.Indices(n.length,1);{const e=new u.Indices(n.length);for(let n=0;n<e.size;n++)t[n]===this.group&&e.set(n);return e}}}e.GroupFilter=c,c.__name__="GroupFilter",c.init_GroupFilter()},
function _(e,n,i,t,s){t();const l=e(121),c=e(24);class r extends l.Filter{constructor(e){super(e)}static init_IndexFilter(){this.define((({Int:e,Array:n,Nullable:i})=>({indices:[i(n(e)),null]})))}compute_indices(e){const n=e.length,{indices:i}=this;return null==i?c.Indices.all_set(n):c.Indices.from_indices(n,i)}}i.IndexFilter=r,r.__name__="IndexFilter",r.init_IndexFilter()},
function _(e,a,l,i,t){i(),t("AnnularWedge",e(278).AnnularWedge),t("Annulus",e(279).Annulus),t("Arc",e(280).Arc),t("Bezier",e(281).Bezier),t("Circle",e(282).Circle),t("Ellipse",e(286).Ellipse),t("EllipseOval",e(287).EllipseOval),t("Glyph",e(98).Glyph),t("HArea",e(117).HArea),t("HBar",e(289).HBar),t("HexTile",e(291).HexTile),t("Image",e(292).Image),t("ImageRGBA",e(294).ImageRGBA),t("ImageURL",e(295).ImageURL),t("Line",e(63).Line),t("MultiLine",e(127).MultiLine),t("MultiPolygons",e(297).MultiPolygons),t("Oval",e(298).Oval),t("Patch",e(116).Patch),t("Patches",e(128).Patches),t("Quad",e(299).Quad),t("Quadratic",e(300).Quadratic),t("Ray",e(301).Ray),t("Rect",e(302).Rect),t("Scatter",e(303).Scatter),t("Segment",e(306).Segment),t("Spline",e(307).Spline),t("Step",e(309).Step),t("Text",e(310).Text),t("VArea",e(119).VArea),t("VBar",e(311).VBar),t("Wedge",e(312).Wedge)},
function _(e,t,s,i,r){i();const n=e(1),a=e(64),o=e(106),_=e(48),d=e(24),u=e(20),h=n.__importStar(e(18)),l=e(10),c=e(59);class g extends a.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=d.to_screen(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=d.to_screen(this.outer_radius)}_render(e,t,s){const{sx:i,sy:r,start_angle:n,end_angle:a,sinner_radius:o,souter_radius:_}=null!=s?s:this,d="anticlock"==this.model.direction;for(const s of t){const t=i[s],u=r[s],h=o[s],l=_[s],c=n.get(s),g=a.get(s);if(isNaN(t+u+h+l+c+g))continue;const x=g-c;e.translate(t,u),e.rotate(c),e.beginPath(),e.moveTo(l,0),e.arc(0,0,l,0,x,d),e.rotate(x),e.lineTo(h,0),e.arc(0,0,h,0,-x,!d),e.closePath(),e.rotate(-x-c),e.translate(-t,-u),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,s),e.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(e,s),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,s),e.stroke())}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s);let n,a,o,_;if("data"==this.model.properties.outer_radius.units)n=i-this.max_outer_radius,o=i+this.max_outer_radius,a=r-this.max_outer_radius,_=r+this.max_outer_radius;else{const e=t-this.max_outer_radius,i=t+this.max_outer_radius;[n,o]=this.renderer.xscale.r_invert(e,i);const r=s-this.max_outer_radius,d=s+this.max_outer_radius;[a,_]=this.renderer.yscale.r_invert(r,d)}const d=[];for(const e of this.index.indices({x0:n,x1:o,y0:a,y1:_})){const t=this.souter_radius[e]**2,s=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[o,_]=this.renderer.yscale.r_compute(r,this._y[e]),u=(n-a)**2+(o-_)**2;u<=t&&u>=s&&d.push(e)}const u="anticlock"==this.model.direction,h=[];for(const e of d){const i=Math.atan2(s-this.sy[e],t-this.sx[e]);l.angle_between(-i,-this.start_angle.get(e),-this.end_angle.get(e),u)&&h.push(e)}return new c.Selection({indices:h})}draw_legend_for_index(e,t,s){o.generic_area_vector_legend(this.visuals,e,t,s)}scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,s=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(s),this.sy[e]+t*Math.sin(s)]}}s.AnnularWedgeView=g,g.__name__="AnnularWedgeView";class x extends a.XYGlyph{constructor(e){super(e)}static init_AnnularWedge(){this.prototype.default_view=g,this.mixins([_.LineVector,_.FillVector,_.HatchVector]),this.define((({})=>({direction:[u.Direction,"anticlock"],inner_radius:[h.DistanceSpec,{field:"inner_radius"}],outer_radius:[h.DistanceSpec,{field:"outer_radius"}],start_angle:[h.AngleSpec,{field:"start_angle"}],end_angle:[h.AngleSpec,{field:"end_angle"}]})))}}s.AnnularWedge=x,x.__name__="AnnularWedge",x.init_AnnularWedge()},
function _(s,i,t,e,r){e();const n=s(1),a=s(64),u=s(24),_=s(48),o=n.__importStar(s(18)),h=s(27),d=s(59);class c extends a.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=u.to_screen(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=u.to_screen(this.outer_radius)}_render(s,i,t){const{sx:e,sy:r,sinner_radius:n,souter_radius:a}=null!=t?t:this;for(const t of i){const i=e[t],_=r[t],o=n[t],d=a[t];function u(){if(s.beginPath(),h.is_ie)for(const t of[!1,!0])s.arc(i,_,o,0,Math.PI,t),s.arc(i,_,d,Math.PI,0,!t);else s.arc(i,_,o,0,2*Math.PI,!0),s.arc(i,_,d,2*Math.PI,0,!1)}isNaN(i+_+o+d)||(this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,t),u(),s.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(s,t),u(),s.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,t),s.beginPath(),s.arc(i,_,o,0,2*Math.PI),s.moveTo(i+d,_),s.arc(i,_,d,0,2*Math.PI),s.stroke()))}}_hit_point(s){const{sx:i,sy:t}=s,e=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(t);let n,a,u,_;if("data"==this.model.properties.outer_radius.units)n=e-this.max_outer_radius,u=e+this.max_outer_radius,a=r-this.max_outer_radius,_=r+this.max_outer_radius;else{const s=i-this.max_outer_radius,e=i+this.max_outer_radius;[n,u]=this.renderer.xscale.r_invert(s,e);const r=t-this.max_outer_radius,o=t+this.max_outer_radius;[a,_]=this.renderer.yscale.r_invert(r,o)}const o=[];for(const s of this.index.indices({x0:n,x1:u,y0:a,y1:_})){const i=this.souter_radius[s]**2,t=this.sinner_radius[s]**2,[n,a]=this.renderer.xscale.r_compute(e,this._x[s]),[u,_]=this.renderer.yscale.r_compute(r,this._y[s]),h=(n-a)**2+(u-_)**2;h<=i&&h>=t&&o.push(s)}return new d.Selection({indices:o})}draw_legend_for_index(s,{x0:i,y0:t,x1:e,y1:r},n){const a=n+1,u=new Array(a);u[n]=(i+e)/2;const _=new Array(a);_[n]=(t+r)/2;const o=.5*Math.min(Math.abs(e-i),Math.abs(r-t)),h=new Array(a);h[n]=.4*o;const d=new Array(a);d[n]=.8*o,this._render(s,[n],{sx:u,sy:_,sinner_radius:h,souter_radius:d})}}t.AnnulusView=c,c.__name__="AnnulusView";class l extends a.XYGlyph{constructor(s){super(s)}static init_Annulus(){this.prototype.default_view=c,this.mixins([_.LineVector,_.FillVector,_.HatchVector]),this.define((({})=>({inner_radius:[o.DistanceSpec,{field:"inner_radius"}],outer_radius:[o.DistanceSpec,{field:"outer_radius"}]})))}}t.Annulus=l,l.__name__="Annulus",l.init_Annulus()},
function _(e,i,s,t,n){t();const r=e(1),a=e(64),c=e(106),d=e(48),_=e(24),l=e(20),o=r.__importStar(e(18));class h extends a.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=_.to_screen(this.radius)}_render(e,i,s){if(this.visuals.line.doit){const{sx:t,sy:n,sradius:r,start_angle:a,end_angle:c}=null!=s?s:this,d="anticlock"==this.model.direction;for(const s of i){const i=t[s],_=n[s],l=r[s],o=a.get(s),h=c.get(s);isNaN(i+_+l+o+h)||(e.beginPath(),e.arc(i,_,l,o,h,d),this.visuals.line.set_vectorize(e,s),e.stroke())}}}draw_legend_for_index(e,i,s){c.generic_line_vector_legend(this.visuals,e,i,s)}}s.ArcView=h,h.__name__="ArcView";class u extends a.XYGlyph{constructor(e){super(e)}static init_Arc(){this.prototype.default_view=h,this.mixins(d.LineVector),this.define((({})=>({direction:[l.Direction,"anticlock"],radius:[o.DistanceSpec,{field:"radius"}],start_angle:[o.AngleSpec,{field:"start_angle"}],end_angle:[o.AngleSpec,{field:"end_angle"}]})))}}s.Arc=u,u.__name__="Arc",u.init_Arc()},
function _(e,t,i,s,n){s();const o=e(1),c=e(48),r=e(98),a=e(106),_=e(65),d=o.__importStar(e(18));function l(e,t,i,s,n,o,c,r){const a=[],_=[[],[]];for(let _=0;_<=2;_++){let d,l,x;if(0===_?(l=6*e-12*i+6*n,d=-3*e+9*i-9*n+3*c,x=3*i-3*e):(l=6*t-12*s+6*o,d=-3*t+9*s-9*o+3*r,x=3*s-3*t),Math.abs(d)<1e-12){if(Math.abs(l)<1e-12)continue;const e=-x/l;0<e&&e<1&&a.push(e);continue}const h=l*l-4*x*d,y=Math.sqrt(h);if(h<0)continue;const p=(-l+y)/(2*d);0<p&&p<1&&a.push(p);const f=(-l-y)/(2*d);0<f&&f<1&&a.push(f)}let d=a.length;const l=d;for(;d--;){const l=a[d],x=1-l,h=x*x*x*e+3*x*x*l*i+3*x*l*l*n+l*l*l*c;_[0][d]=h;const y=x*x*x*t+3*x*x*l*s+3*x*l*l*o+l*l*l*r;_[1][d]=y}return _[0][l]=e,_[1][l]=t,_[0][l+1]=c,_[1][l+1]=r,[Math.min(..._[0]),Math.max(..._[1]),Math.max(..._[0]),Math.min(..._[1])]}class x extends r.GlyphView{_project_data(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{data_size:t,_x0:i,_y0:s,_x1:n,_y1:o,_cx0:c,_cy0:r,_cx1:a,_cy1:_}=this;for(let d=0;d<t;d++){const t=i[d],x=s[d],h=n[d],y=o[d],p=c[d],f=r[d],u=a[d],m=_[d];if(isNaN(t+h+x+y+p+f+u+m))e.add_empty();else{const[i,s,n,o]=l(t,x,h,y,p,f,u,m);e.add(i,s,n,o)}}}_render(e,t,i){if(this.visuals.line.doit){const{sx0:s,sy0:n,sx1:o,sy1:c,scx0:r,scy0:a,scx1:_,scy1:d}=null!=i?i:this;for(const i of t){const t=s[i],l=n[i],x=o[i],h=c[i],y=r[i],p=a[i],f=_[i],u=d[i];isNaN(t+l+x+h+y+p+f+u)||(e.beginPath(),e.moveTo(t,l),e.bezierCurveTo(y,p,f,u,x,h),this.visuals.line.set_vectorize(e,i),e.stroke())}}}draw_legend_for_index(e,t,i){a.generic_line_vector_legend(this.visuals,e,t,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.BezierView=x,x.__name__="BezierView";class h extends r.Glyph{constructor(e){super(e)}static init_Bezier(){this.prototype.default_view=x,this.define((({})=>({x0:[d.XCoordinateSpec,{field:"x0"}],y0:[d.YCoordinateSpec,{field:"y0"}],x1:[d.XCoordinateSpec,{field:"x1"}],y1:[d.YCoordinateSpec,{field:"y1"}],cx0:[d.XCoordinateSpec,{field:"cx0"}],cy0:[d.YCoordinateSpec,{field:"cy0"}],cx1:[d.XCoordinateSpec,{field:"cx1"}],cy1:[d.YCoordinateSpec,{field:"cy1"}]}))),this.mixins(c.LineVector)}}i.Bezier=h,h.__name__="Bezier",h.init_Bezier()},
function _(s,i,e,t,r){t();const a=s(1),n=s(64),h=s(283),d=s(48),l=s(24),c=s(20),_=a.__importStar(s(107)),u=a.__importStar(s(18)),o=s(9),x=s(12),m=s(59);class y extends n.XYGlyphView{initialize(){super.initialize();const{webgl:s}=this.renderer.plot_view.canvas_view;null!=s&&(this.glglyph=new h.MarkerGL(s.gl,this,"circle"))}get use_radius(){return!(this.radius.is_Scalar()&&isNaN(this.radius.value))}_map_data(){if(this.use_radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this.radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=x.map(s,((s,e)=>Math.max(s,i[e])));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=x.map(s,((s,e)=>Math.min(s,i[e])));break}}else this.sradius=l.to_screen(this.radius),this._configure("max_size",{value:2*this.max_radius});else{const s=new l.ScreenArray(this.size);this.sradius=x.map(s,(s=>s/2))}}_mask_data(){const{frame:s}=this.renderer.plot_view,i=s.x_target,e=s.y_target;let t,r;return this.use_radius&&"data"==this.model.properties.radius.units?(t=i.map((s=>this.renderer.xscale.invert(s))).widen(this.max_radius),r=e.map((s=>this.renderer.yscale.invert(s))).widen(this.max_radius)):(t=i.widen(this.max_size).map((s=>this.renderer.xscale.invert(s))),r=e.widen(this.max_size).map((s=>this.renderer.yscale.invert(s)))),this.index.indices({x0:t.start,x1:t.end,y0:r.start,y1:r.end})}_render(s,i,e){const{sx:t,sy:r,sradius:a}=null!=e?e:this;for(const e of i){const i=t[e],n=r[e],h=a[e];isNaN(i+n+h)||(s.beginPath(),s.arc(i,n,h,0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,e),s.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(s,e),s.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,e),s.stroke()))}}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e),{hit_dilation:a}=this.model;let n,h,d,l;if(this.use_radius&&"data"==this.model.properties.radius.units)n=t-this.max_radius*a,h=t+this.max_radius*a,d=r-this.max_radius*a,l=r+this.max_radius*a;else{const s=i-this.max_size*a,t=i+this.max_size*a;[n,h]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_size*a,c=e+this.max_size*a;[d,l]=this.renderer.yscale.r_invert(r,c)}const c=this.index.indices({x0:n,x1:h,y0:d,y1:l}),_=[];if(this.use_radius&&"data"==this.model.properties.radius.units)for(const s of c){const i=(this.sradius[s]*a)**2,[e,n]=this.renderer.xscale.r_compute(t,this._x[s]),[h,d]=this.renderer.yscale.r_compute(r,this._y[s]);(e-n)**2+(h-d)**2<=i&&_.push(s)}else for(const s of c){const t=(this.sradius[s]*a)**2;(this.sx[s]-i)**2+(this.sy[s]-e)**2<=t&&_.push(s)}return new m.Selection({indices:_})}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds();let r,a,n,h;if("h"==s.direction){let s,e;if(n=t.y0,h=t.y1,this.use_radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[r,a]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[r,a]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(r=t.x0,a=t.x1,this.use_radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[n,h]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[n,h]=this.renderer.yscale.r_invert(s,i)}}const d=[...this.index.indices({x0:r,x1:a,y0:n,y1:h})];return new m.Selection({indices:d})}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:r}=s,[a,n]=this.renderer.xscale.r_invert(i,e),[h,d]=this.renderer.yscale.r_invert(t,r),l=[...this.index.indices({x0:a,x1:n,y0:h,y1:d})];return new m.Selection({indices:l})}_hit_poly(s){const{sx:i,sy:e}=s,t=o.range(0,this.sx.length),r=[];for(let s=0,a=t.length;s<a;s++){const a=t[s];_.point_in_poly(this.sx[s],this.sy[s],i,e)&&r.push(a)}return new m.Selection({indices:r})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const l=new Array(n);l[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:l})}}e.CircleView=y,y.__name__="CircleView";class p extends n.XYGlyph{constructor(s){super(s)}static init_Circle(){this.prototype.default_view=y,this.mixins([d.LineVector,d.FillVector,d.HatchVector]),this.define((({Number:s})=>({angle:[u.AngleSpec,0],size:[u.ScreenDistanceSpec,{value:4}],radius:[u.NullDistanceSpec,null],radius_dimension:[c.RadiusDimension,"x"],hit_dilation:[s,1]})))}}e.Circle=p,p.__name__="Circle",p.init_Circle()},
function _(t,e,s,i,a){i();const r=t(1),o=t(109),_=t(113),l=r.__importDefault(t(284)),h=r.__importDefault(t(285)),n=t(282),f=t(12),u=t(19),c=t(24),g=t(22),b=t(11);function d(t,e,s,i,a,r,o){if(a.doit)if(r.is_Scalar()&&o.is_Scalar()){e.used=!1;const[i,a,_,l]=g.color2rgba(r.value,o.value);t.set_attribute(s,"vec4",[i/255,a/255,_/255,l/255])}else{let a;if(e.used=!0,r.is_Vector()){const t=new c.ColorArray(r.array);if(a=new c.RGBAArray(t.buffer),!o.is_Scalar()||1!=o.value)for(let t=0;t<i;t++){const e=4*t+3;255==a[e]&&(a[e]=255*o.get(t))}}else if(r.is_Scalar()&&o.is_Vector()){const t=new c.ColorArray(i);t.fill(r.value),a=new c.RGBAArray(t.buffer);for(let t=0;t<i;t++)for(let t=0;t<i;t++){const e=4*t+3;255==a[e]&&(a[e]=255*o.get(t))}}else b.unreachable();e.set_size(4*i),e.set_data(0,a),t.set_attribute(s,"vec4_uint8",e,0,0,!0)}else e.used=!1,t.set_attribute(s,"vec4",[0,0,0,0])}class p extends _.BaseGLGlyph{constructor(t,e,s){super(t,e),this.glyph=e,this.marker_type=s;const i=[`#define USE_${s.toUpperCase()}`],a=l.default,r=`${i.join("\n")}\n\n${h.default}`;this.prog=new o.Program(t),this.prog.set_shaders(a,r),this.vbo_sx=new o.VertexBuffer(t),this.prog.set_attribute("a_sx","float",this.vbo_sx),this.vbo_sy=new o.VertexBuffer(t),this.prog.set_attribute("a_sy","float",this.vbo_sy),this.vbo_s=new o.VertexBuffer(t),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new o.VertexBuffer(t),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new o.VertexBuffer(t),this.vbo_fg_color=new o.VertexBuffer(t),this.vbo_bg_color=new o.VertexBuffer(t),this.index_buffer=new o.IndexBuffer(t)}static is_supported(t){switch(t){case"asterisk":case"circle":case"circle_cross":case"circle_x":case"cross":case"diamond":case"diamond_cross":case"hex":case"inverted_triangle":case"square":case"square_cross":case"square_x":case"star":case"triangle":case"x":return!0;default:return!1}}draw(t,e,s){const i=e.glglyph,{nvertices:a}=i;if(i.data_changed&&(i._set_data(a),this.glyph instanceof n.CircleView&&null!=this.glyph.radius&&this.vbo_s.set_data(0,f.map(this.glyph.sradius,(t=>2*t))),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(a),this.visuals_changed=!1),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_attribute("a_sx","float",i.vbo_sx),this.prog.set_attribute("a_sy","float",i.vbo_sy),this.prog.set_attribute("a_size","float",i.vbo_s),this.prog.set_attribute("a_angle","float",i.vbo_a),0!=t.length)if(t.length===a)this.prog.draw(this.gl.POINTS,[0,a]);else if(a<65535){const e=window.navigator.userAgent;e.indexOf("MSIE ")+e.indexOf("Trident/")+e.indexOf("Edge/")>0&&u.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer)}else{const e=64e3,s=[];for(let t=0,i=Math.ceil(a/e);t<i;t++)s.push([]);for(let i=0,a=t.length;i<a;i++){const a=t[i]%e;s[Math.floor(t[i]/e)].push(a)}for(let t=0,a=s.length;t<a;t++){const a=new Uint16Array(s[t]),r=t*e*4;0!==a.length&&(this.prog.set_attribute("a_sx","float",i.vbo_sx,0,r),this.prog.set_attribute("a_sy","float",i.vbo_sy,0,r),this.prog.set_attribute("a_size","float",i.vbo_s,0,r),this.prog.set_attribute("a_angle","float",i.vbo_a,0,r),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,r),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4_uint8",this.vbo_fg_color,0,4*r,!0),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4_uint8",this.vbo_bg_color,0,4*r,!0),this.index_buffer.set_size(2*a.length),this.index_buffer.set_data(0,a),this.prog.draw(this.gl.POINTS,this.index_buffer))}}}_set_data(t){const e=4*t;this.vbo_sx.set_size(e),this.vbo_sy.set_size(e),this.vbo_a.set_size(e),this.vbo_s.set_size(e),this.vbo_sx.set_data(0,this.glyph.sx),this.vbo_sy.set_data(0,this.glyph.sy),null!=this.glyph.angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph.angle)),this.glyph instanceof n.CircleView&&null!=this.glyph.radius?this.vbo_s.set_data(0,f.map(this.glyph.sradius,(t=>2*t))):this.vbo_s.set_data(0,new Float32Array(this.glyph.size))}_set_visuals(t){const{line:e,fill:s}=this.glyph.visuals;!function(t,e,s,i,a,r){if(a.doit){if(r.is_Scalar())e.used=!1,t.set_attribute(s,"float",[r.value]);else if(r.is_Vector()){e.used=!0;const a=new Float32Array(r.array);e.set_size(4*i),e.set_data(0,a),t.set_attribute(s,"float",e)}}else e.used=!1,t.set_attribute(s,"float",[0])}(this.prog,this.vbo_linewidth,"a_linewidth",t,e,e.line_width),d(this.prog,this.vbo_fg_color,"a_fg_color",t,e,e.line_color,e.line_alpha),d(this.prog,this.vbo_bg_color,"a_bg_color",t,s,s.fill_color,s.fill_alpha),this.prog.set_uniform("u_antialias","float",[.8])}}s.MarkerGL=p,p.__name__="MarkerGL"},
function _(n,i,a,o,_){o();a.default="\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_sx;\nattribute float a_sy;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    vec2 pos = vec2(a_sx, a_sy);  // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}\n"},
function _(n,a,s,e,t){e();s.default='\nprecision mediump float;\n\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n\nconst float IN_ANGLE = 0.6283185307179586; // PI/5. = 36 degrees (star of 5 pikes)\n//const float OUT_ANGLE = PI/2. - IN_ANGLE; // External angle for regular stars\nconst float COS_A = 0.8090169943749475; // cos(IN_ANGLE)\nconst float SIN_A = 0.5877852522924731; // sin(IN_ANGLE)\nconst float COS_B = 0.5877852522924731; // cos(OUT_ANGLE)\nconst float SIN_B = 0.8090169943749475; // sin(OUT_ANGLE)\n\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\n#ifdef USE_ASTERISK\n// asterisk\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}\n#endif\n\n#ifdef USE_CIRCLE\n// circle\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n#endif\n\n#ifdef USE_SQUARE\n// square\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n#endif\n\n#ifdef USE_DIAMOND\n// diamond\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n#endif\n\n#ifdef USE_HEX\n// hex\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n#endif\n\n#ifdef USE_STAR\n// star\n// https://iquilezles.org/www/articles/distfunctions2d/distfunctions2d.htm\nfloat marker(vec2 P, float size)\n{\n    float bn = mod(atan(P.x, -P.y), 2.0*IN_ANGLE) - IN_ANGLE;\n    P = length(P)*vec2(cos(bn), abs(sin(bn)));\n    P -= size*vec2(COS_A, SIN_A)/2.;\n    P += vec2(COS_B, SIN_B)*clamp(-(P.x*COS_B + P.y*SIN_B), 0.0, size*SIN_A/SIN_B/2.);\n\n    return length(P)*sign(P.x);\n}\n#endif\n\n#ifdef USE_TRIANGLE\n// triangle\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n#endif\n\n#ifdef USE_INVERTED_TRIANGLE\n// inverted_triangle\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n#endif\n\n#ifdef USE_CROSS\n// cross\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;   // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}\n#endif\n\n#ifdef USE_CIRCLE_CROSS\n// circle_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_SQUARE_CROSS\n// square_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_DIAMOND_CROSS\n// diamond_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_X\n// x\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}\n#endif\n\n#ifdef USE_CIRCLE_X\n// circle_x\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}\n#endif\n\n#ifdef USE_SQUARE_X\n// square_x\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n}\n'},
function _(e,l,i,s,t){s();const _=e(287);class p extends _.EllipseOvalView{}i.EllipseView=p,p.__name__="EllipseView";class n extends _.EllipseOval{constructor(e){super(e)}static init_Ellipse(){this.prototype.default_view=p}}i.Ellipse=n,n.__name__="Ellipse",n.init_Ellipse()},
function _(t,s,i,e,h){e();const r=t(1),a=t(288),n=r.__importStar(t(107)),l=t(24),o=t(59);class _ extends a.CenterRotatableView{_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"):this.sw=l.to_screen(this.width),"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"):this.sh=l.to_screen(this.height)}_render(t,s,i){const{sx:e,sy:h,sw:r,sh:a,angle:n}=null!=i?i:this;for(const i of s){const s=e[i],l=h[i],o=r[i],_=a[i],d=n.get(i);isNaN(s+l+o+_+d)||(t.beginPath(),t.ellipse(s,l,o/2,_/2,d,0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,i),t.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(t,i),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,i),t.stroke()))}}_hit_point(t){let s,i,e,h,r,a,l,_,d;const{sx:c,sy:x}=t,w=this.renderer.xscale.invert(c),p=this.renderer.yscale.invert(x);"data"==this.model.properties.width.units?(s=w-this.max_width,i=w+this.max_width):(a=c-this.max_width,l=c+this.max_width,[s,i]=this.renderer.xscale.r_invert(a,l)),"data"==this.model.properties.height.units?(e=p-this.max_height,h=p+this.max_height):(_=x-this.max_height,d=x+this.max_height,[e,h]=this.renderer.yscale.r_invert(_,d));const m=this.index.indices({x0:s,x1:i,y0:e,y1:h}),v=[];for(const t of m)r=n.point_in_ellipse(c,x,this.angle.get(t),this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]),r&&v.push(t);return new o.Selection({indices:v})}draw_legend_for_index(t,{x0:s,y0:i,x1:e,y1:h},r){const a=r+1,n=new Array(a);n[r]=(s+e)/2;const l=new Array(a);l[r]=(i+h)/2;const o=this.sw[r]/this.sh[r],_=.8*Math.min(Math.abs(e-s),Math.abs(h-i)),d=new Array(a),c=new Array(a);o>1?(d[r]=_,c[r]=_/o):(d[r]=_*o,c[r]=_),this._render(t,[r],{sx:n,sy:l,sw:d,sh:c,_angle:[0]})}}i.EllipseOvalView=_,_.__name__="EllipseOvalView";class d extends a.CenterRotatable{constructor(t){super(t)}}i.EllipseOval=d,d.__name__="EllipseOval"},
function _(t,e,i,a,n){a();const s=t(1),h=t(64),r=t(48),o=s.__importStar(t(18));class _ extends h.XYGlyphView{get max_w2(){return"data"==this.model.properties.width.units?this.max_width/2:0}get max_h2(){return"data"==this.model.properties.height.units?this.max_height/2:0}_bounds({x0:t,x1:e,y0:i,y1:a}){const{max_w2:n,max_h2:s}=this;return{x0:t-n,x1:e+n,y0:i-s,y1:a+s}}}i.CenterRotatableView=_,_.__name__="CenterRotatableView";class l extends h.XYGlyph{constructor(t){super(t)}static init_CenterRotatable(){this.mixins([r.LineVector,r.FillVector,r.HatchVector]),this.define((({})=>({angle:[o.AngleSpec,0],width:[o.DistanceSpec,{field:"width"}],height:[o.DistanceSpec,{field:"height"}]})))}}i.CenterRotatable=l,l.__name__="CenterRotatable",l.init_CenterRotatable()},
function _(t,e,s,i,h){i();const r=t(1),a=t(290),n=t(24),_=r.__importStar(t(18));class o extends a.BoxView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){const e=this._left[t],s=this._right[t],i=this._y[t],h=this.height.get(t)/2;return[Math.min(e,s),Math.max(e,s),i+h,i-h]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new n.ScreenArray(t),this.sbottom=new n.ScreenArray(t);for(let e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()}}s.HBarView=o,o.__name__="HBarView";class c extends a.Box{constructor(t){super(t)}static init_HBar(){this.prototype.default_view=o,this.define((({})=>({left:[_.XCoordinateSpec,{value:0}],y:[_.YCoordinateSpec,{field:"y"}],height:[_.NumberSpec,{value:1}],right:[_.XCoordinateSpec,{field:"right"}]})))}}s.HBar=c,c.__name__="HBar",c.init_HBar()},
function _(t,e,s,i,r){i();const n=t(48),o=t(98),a=t(106),h=t(59);class c extends o.GlyphView{get_anchor_point(t,e,s){const i=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),o=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:n};case"top":case"top_center":return{x:(i+r)/2,y:n};case"top_right":return{x:r,y:n};case"bottom_left":return{x:i,y:o};case"bottom":case"bottom_center":return{x:(i+r)/2,y:o};case"bottom_right":return{x:r,y:o};case"left":case"center_left":return{x:i,y:(n+o)/2};case"center":case"center_center":return{x:(i+r)/2,y:(n+o)/2};case"right":case"center_right":return{x:r,y:(n+o)/2}}}_index_data(t){const{min:e,max:s}=Math,{data_size:i}=this;for(let r=0;r<i;r++){const[i,n,o,a]=this._lrtb(r);isNaN(i+n+o+a)||!isFinite(i+n+o+a)?t.add_empty():t.add(e(i,n),e(o,a),s(n,i),s(o,a))}}_render(t,e,s){const{sleft:i,sright:r,stop:n,sbottom:o}=null!=s?s:this;for(const s of e){const e=i[s],h=n[s],c=r[s],_=o[s];function a(){t.beginPath(),t.rect(e,h,c-e,_-h)}isNaN(e+h+c+_)||(this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,s),a(),t.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(t,s),a(),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,s),a(),t.stroke()))}}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,s=this.stop.length;for(let i=0;i<s;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:s}=t,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(s),n=[...this.index.indices({x0:i,y0:r,x1:i,y1:r})];return new h.Selection({indices:n})}_hit_span(t){const{sx:e,sy:s}=t;let i;if("v"==t.direction){const t=this.renderer.yscale.invert(s),e=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(e.start,e.end);i=[...this.index.indices({x0:r,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=[...this.index.indices({x0:t,y0:r,x1:t,y1:n})]}return new h.Selection({indices:i})}draw_legend_for_index(t,e,s){a.generic_area_vector_legend(this.visuals,t,e,s)}}s.BoxView=c,c.__name__="BoxView";class _ extends o.Glyph{constructor(t){super(t)}static init_Box(){this.mixins([n.LineVector,n.FillVector,n.HatchVector])}}s.Box=_,_.__name__="Box",_.init_Box()},
function _(e,t,s,i,r){i();const n=e(1),o=e(98),a=n.__importStar(e(107)),c=n.__importStar(e(18)),l=e(48),h=e(20),_=e(65),d=e(106),x=e(59);class p extends o.GlyphView{scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const{orientation:e,size:t,aspect_scale:s}=this.model,{q:i,r}=this,n=this.q.length;this._x=new Float64Array(n),this._y=new Float64Array(n);const{_x:o,_y:a}=this,c=Math.sqrt(3);if("pointytop"==e)for(let e=0;e<n;e++){const n=i.get(e),l=r.get(e)/2;o[e]=t*c*(n+l)/s,a[e]=-3*t*l}else for(let e=0;e<n;e++){const n=i.get(e)/2,l=r.get(e);o[e]=3*t*n,a[e]=-t*c*(l+n)*s}}_project_data(){_.inplace.project_xy(this._x,this._y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y[r];isNaN(i+n)||!isFinite(i+n)?e.add_empty():e.add(i-s,n-t,i+s,n+t)}}map_data(){[this.sx,this.sy]=this.renderer.coordinates.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,o=r/2;return[[0,-n,-n,0,n,n],[r,o,-o,-r,-o,o]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,o=r/2;return[[r,o,-o,-r,-o,o],[0,-n,-n,0,n,n]]}}_render(e,t,s){const{sx:i,sy:r,svx:n,svy:o,scale:a}=null!=s?s:this;for(const s of t){const t=i[s],c=r[s],l=a.get(s);if(!isNaN(t+c+l)){e.translate(t,c),e.beginPath();for(let t=0;t<6;t++)e.lineTo(n[t]*l,o[t]*l);e.closePath(),e.translate(-t,-c),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,s),e.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(e,s),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,s),e.stroke())}}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),o=[];for(const e of n)a.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&o.push(e);return new x.Selection({indices:o})}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=[...this.index.indices({x0:r,y0:e,x1:n,y1:e})]}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=[...this.index.indices({x0:e,y0:r,x1:e,y1:n})]}return new x.Selection({indices:i})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,o]=this.renderer.xscale.r_invert(t,s),[a,c]=this.renderer.yscale.r_invert(i,r),l=[...this.index.indices({x0:n,x1:o,y0:a,y1:c})];return new x.Selection({indices:l})}draw_legend_for_index(e,t,s){d.generic_area_vector_legend(this.visuals,e,t,s)}}s.HexTileView=p,p.__name__="HexTileView";class y extends o.Glyph{constructor(e){super(e)}static init_HexTile(){this.prototype.default_view=p,this.mixins([l.LineVector,l.FillVector,l.HatchVector]),this.define((({Number:e})=>({r:[c.NumberSpec,{field:"r"}],q:[c.NumberSpec,{field:"q"}],scale:[c.NumberSpec,1],size:[e,1],aspect_scale:[e,1],orientation:[h.HexTileOrientation,"pointytop"]}))),this.override({line_color:null})}}s.HexTile=y,y.__name__="HexTile",y.init_HexTile()},
function _(e,a,t,_,s){_();const i=e(293),n=e(203),r=e(214);class o extends i.ImageBaseView{connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}_update_image(){null!=this.image_data&&(this._set_data(null),this.renderer.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}t.ImageView=o,o.__name__="ImageView";class m extends i.ImageBase{constructor(e){super(e)}static init_Image(){this.prototype.default_view=o,this.define((({Ref:e})=>({color_mapper:[e(n.ColorMapper),()=>new r.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})))}}t.Image=m,m.__name__="Image",m.init_Image()},
function _(e,t,i,s,a){s();const h=e(1),n=e(64),r=e(24),_=h.__importStar(e(18)),d=e(59),l=e(9),g=e(29),o=e(11);class c extends n.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}_render(e,t,i){const{image_data:s,sx:a,sy:h,sw:n,sh:r}=null!=i?i:this,_=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(const i of t){const t=s[i],_=a[i],d=h[i],l=n[i],g=r[i];if(null==t||isNaN(_+d+l+g))continue;const o=d;e.translate(0,o),e.scale(1,-1),e.translate(0,-o),e.drawImage(t,0|_,0|d,l,g),e.translate(0,o),e.scale(1,-1),e.translate(0,-o)}e.setImageSmoothingEnabled(_)}_set_data(e){this._set_width_heigh_data();for(let t=0,i=this.image.length;t<i;t++){if(null!=e&&e.indexOf(t)<0)continue;const i=this.image.get(t);let s;g.is_NDArray(i)?(o.assert(2==i.dimension,"expected a 2D array"),s=i,this._height[t]=i.shape[0],this._width[t]=i.shape[1]):(s=l.concat(i),this._height[t]=i.length,this._width[t]=i[0].length);const a=this._flat_img_to_buf8(s);this._set_image_data_from_buffer(t,a)}}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++){const[t,s,a,h]=this._lrtb(i);isNaN(t+s+a+h)||!isFinite(t+s+a+h)?e.add_empty():e.add(t,h,s,a)}}_lrtb(e){const t=this.dw.get(e),i=this.dh.get(e),s=this.renderer.xscale.source_range,a=this._x[e],h=s.is_reversed?a-t:a+t,n=this.renderer.yscale.source_range,r=this._y[e],_=n.is_reversed?r-i:r+i,[d,l]=a<h?[a,h]:[h,a],[g,o]=r<_?[r,_]:[_,r];return[d,l,o,g]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this.image.length||(this.image_data=new Array(this.image.length)),null!=this._width&&this._width.length==this.image.length||(this._width=new Uint32Array(this.image.length)),null!=this._height&&this._height.length==this.image.length||(this._height=new Uint32Array(this.image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const i=this._get_or_create_canvas(e),s=i.getContext("2d"),a=s.getImageData(0,0,this._width[e],this._height[e]);a.data.set(t),s.putImageData(a,0,0),this.image_data[e]=i}_map_data(){"data"==this.model.properties.dw.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.dw,"edge",this.model.dilate):this.sw=r.to_screen(this.dw),"data"==this.model.properties.dh.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.dh,"edge",this.model.dilate):this.sh=r.to_screen(this.dh)}_image_index(e,t,i){const[s,a,h,n]=this._lrtb(e),r=this._width[e],_=this._height[e],d=(a-s)/r,l=(h-n)/_;let g=Math.floor((t-s)/d),o=Math.floor((i-n)/l);return this.renderer.xscale.source_range.is_reversed&&(g=r-g-1),this.renderer.yscale.source_range.is_reversed&&(o=_-o-1),{index:e,dim1:g,dim2:o,flat_index:o*r+g}}_hit_point(e){const{sx:t,sy:i}=e,s=this.renderer.xscale.invert(t),a=this.renderer.yscale.invert(i),h=this.index.indices({x0:s,x1:s,y0:a,y1:a}),n=new d.Selection;for(const e of h)t!=1/0&&i!=1/0&&n.image_indices.push(this._image_index(e,s,a));return n}}i.ImageBaseView=c,c.__name__="ImageBaseView";class m extends n.XYGlyph{constructor(e){super(e)}static init_ImageBase(){this.define((({Boolean:e,Alpha:t})=>({image:[_.NDArraySpec,{field:"image"}],dw:[_.DistanceSpec,{field:"dw"}],dh:[_.DistanceSpec,{field:"dh"}],dilate:[e,!1],global_alpha:[t,1]})))}}i.ImageBase=m,m.__name__="ImageBase",m.init_ImageBase()},
function _(e,a,t,_,i){_();const n=e(293),s=e(8);class r extends n.ImageBaseView{_flat_img_to_buf8(e){let a;return a=s.isArray(e)?new Uint32Array(e):e,new Uint8ClampedArray(a.buffer)}}t.ImageRGBAView=r,r.__name__="ImageRGBAView";class m extends n.ImageBase{constructor(e){super(e)}static init_ImageRGBA(){this.prototype.default_view=r}}t.ImageRGBA=m,m.__name__="ImageRGBA",m.init_ImageRGBA()},
function _(e,t,s,r,a){r();const i=e(1),n=e(64),o=e(24),c=e(20),_=i.__importStar(e(18)),h=e(12),l=e(296);class d extends n.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1,this._set_data_iteration=0}connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++)e.add_empty()}_set_data(){this._set_data_iteration++;const e=this.url.length;this.image=new Array(e);const{retry_attempts:t,retry_timeout:s}=this.model,{_set_data_iteration:r}=this;for(let a=0;a<e;a++){const e=this.url.get(a);e&&new l.ImageLoader(e,{loaded:e=>{this._set_data_iteration==r&&(this.image[a]=e,this.renderer.request_render())},attempts:t+1,timeout:s})}const a="data"==this.model.properties.w.units,i="data"==this.model.properties.h.units,n=this._x.length,c=new o.ScreenArray(a?2*n:n),_=new o.ScreenArray(i?2*n:n),{anchor:d}=this.model;function m(e,t){switch(d){case"top_left":case"bottom_left":case"left":case"center_left":return[e,e+t];case"top":case"top_center":case"bottom":case"bottom_center":case"center":case"center_center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"right":case"center_right":return[e-t,e]}}function g(e,t){switch(d){case"top_left":case"top":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom":case"bottom_center":case"bottom_right":return[e+t,e];case"left":case"center_left":case"center":case"center_center":case"right":case"center_right":return[e+t/2,e-t/2]}}if(a)for(let e=0;e<n;e++)[c[e],c[n+e]]=m(this._x[e],this.w.get(e));else c.set(this._x,0);if(i)for(let e=0;e<n;e++)[_[e],_[n+e]]=g(this._y[e],this.h.get(e));else _.set(this._y,0);const[u,p]=h.minmax(c),[f,b]=h.minmax(_);this._bounds_rect={x0:u,x1:p,y0:f,y1:b}}has_finished(){return super.has_finished()&&1==this._images_rendered}_map_data(){"data"==this.model.properties.w.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.w,"edge",this.model.dilate):this.sw=o.to_screen(this.w),"data"==this.model.properties.h.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.h,"edge",this.model.dilate):this.sh=o.to_screen(this.h)}_render(e,t,s){const{image:r,sx:a,sy:i,sw:n,sh:o,angle:c}=null!=s?s:this,{frame:_}=this.renderer.plot_view;e.rect(_.bbox.left+1,_.bbox.top+1,_.bbox.width-2,_.bbox.height-2),e.clip();let h=!0;for(const s of t){if(isNaN(a[s]+i[s]+c.get(s)))continue;const t=r[s];null!=t?this._render_image(e,s,t,a,i,n,o,c):h=!1}h&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,r,a){switch(e){case"top_left":return[t,s];case"top":case"top_center":return[t-r/2,s];case"top_right":return[t-r,s];case"right":case"center_right":return[t-r,s-a/2];case"bottom_right":return[t-r,s-a];case"bottom":case"bottom_center":return[t-r/2,s-a];case"bottom_left":return[t,s-a];case"left":case"center_left":return[t,s-a/2];case"center":case"center_center":return[t-r/2,s-a/2]}}_render_image(e,t,s,r,a,i,n,o){isNaN(i[t])&&(i[t]=s.width),isNaN(n[t])&&(n[t]=s.height);const c=i[t],_=n[t],{anchor:h}=this.model,[l,d]=this._final_sx_sy(h,r[t],a[t],c,_),m=o.get(t);e.save(),e.globalAlpha=this.model.global_alpha;const g=c/2,u=_/2;m?(e.translate(l,d),e.translate(g,u),e.rotate(m),e.translate(-g,-u),e.drawImage(s,0,0,c,_),e.translate(g,u),e.rotate(-m),e.translate(-g,-u),e.translate(-l,-d)):e.drawImage(s,l,d,c,_),e.restore()}bounds(){return this._bounds_rect}}s.ImageURLView=d,d.__name__="ImageURLView";class m extends n.XYGlyph{constructor(e){super(e)}static init_ImageURL(){this.prototype.default_view=d,this.define((({Boolean:e,Int:t,Alpha:s})=>({url:[_.StringSpec,{field:"url"}],anchor:[c.Anchor,"top_left"],global_alpha:[s,1],angle:[_.AngleSpec,0],w:[_.NullDistanceSpec,null],h:[_.NullDistanceSpec,null],dilate:[e,!1],retry_attempts:[t,0],retry_timeout:[t,0]})))}}s.ImageURL=m,m.__name__="ImageURL",m.init_ImageURL()},
function _(i,e,t,s,o){s();const a=i(19);class n{constructor(i,e={}){this._image=new Image,this._finished=!1;const{attempts:t=1,timeout:s=1}=e;this.promise=new Promise(((o,n)=>{this._image.crossOrigin="anonymous";let r=0;this._image.onerror=()=>{if(++r==t){const s=`unable to load ${i} image after ${t} attempts`;if(a.logger.warn(s),null==this._image.crossOrigin)return void(null!=e.failed&&e.failed());a.logger.warn(`attempting to load ${i} without a cross origin policy`),this._image.crossOrigin=null,r=0}setTimeout((()=>this._image.src=i),s)},this._image.onload=()=>{this._finished=!0,null!=e.loaded&&e.loaded(this._image),o(this._image)},this._image.src=i}))}get finished(){return this._finished}get image(){if(this._finished)return this._image;throw new Error("not loaded yet")}}t.ImageLoader=n,n.__name__="ImageLoader"},
function _(t,s,e,i,n){i();const o=t(1),l=t(101),r=t(98),h=t(106),_=t(12),a=t(12),c=t(48),d=o.__importStar(t(107)),x=o.__importStar(t(18)),y=t(59),f=t(11);class g extends r.GlyphView{_project_data(){}_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._xs[n],o=this._ys[n];if(0==i.length||0==o.length){t.add_empty();continue}let l=1/0,r=-1/0,h=1/0,a=-1/0;for(let t=0,n=i.length;t<n;t++){const n=i[t][0],c=o[t][0];if(0!=n.length&&0!=c.length){const[t,i]=_.minmax(n),[o,d]=_.minmax(c);l=s(l,t),r=e(r,i),h=s(h,o),a=e(a,d)}}isFinite(l+r+h+a)?t.add(l,h,r,a):t.add_empty()}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:t,max:s}=Math,{data_size:e}=this,i=new l.SpatialIndex(e);for(let n=0;n<e;n++){const e=this._xs[n],o=this._ys[n];if(0==e.length||0==o.length){i.add_empty();continue}let l=1/0,r=-1/0,h=1/0,a=-1/0;for(let i=0,n=e.length;i<n;i++){const n=e[i],c=o[i];if(n.length>1&&c.length>1)for(let e=1,i=n.length;e<i;e++){const[i,o]=_.minmax(n[e]),[d,x]=_.minmax(c[e]);l=t(l,i),r=s(r,o),h=t(h,d),a=s(a,x)}}isFinite(l+r+h+a)?i.add(l,h,r,a):i.add_empty()}return i.finish(),i}_mask_data(){const{x_range:t,y_range:s}=this.renderer.plot_view.frame;return this.index.indices({x0:t.min,x1:t.max,y0:s.min,y1:s.max})}_inner_loop(t,s,e){t.beginPath();for(let i=0,n=s.length;i<n;i++)for(let n=0,o=s[i].length;n<o;n++){const o=s[i][n],l=e[i][n];for(let s=0,e=o.length;s<e;s++)0!=s?t.lineTo(o[s],l[s]):t.moveTo(o[s],l[s]);t.closePath()}}_render(t,s,e){if(this.visuals.fill.doit||this.visuals.line.doit){const{sxs:i,sys:n}=null!=e?e:this;for(const e of s){const s=i[e],o=n[e];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._inner_loop(t,s,o),t.fill("evenodd")),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(t,e),this._inner_loop(t,s,o),t.fill("evenodd")),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._inner_loop(t,s,o),t.stroke())}}}_hit_rect(t){const{sx0:s,sx1:e,sy0:i,sy1:n}=t,o=[s,e,e,s],l=[i,i,n,n],[r,h]=this.renderer.xscale.r_invert(s,e),[_,a]=this.renderer.yscale.r_invert(i,n),c=this.index.indices({x0:r,x1:h,y0:_,y1:a}),x=[];for(const t of c){const s=this.sxs[t],e=this.sys[t];let i=!0;for(let t=0,n=s.length;t<n;t++){for(let n=0,r=s[t][0].length;n<r;n++){const r=s[t][0][n],h=e[t][0][n];if(!d.point_in_poly(r,h,o,l)){i=!1;break}}if(!i)break}i&&x.push(t)}return new y.Selection({indices:x})}_hit_point(t){const{sx:s,sy:e}=t,i=this.renderer.xscale.invert(s),n=this.renderer.yscale.invert(e),o=this.index.indices({x0:i,y0:n,x1:i,y1:n}),l=this._hole_index.indices({x0:i,y0:n,x1:i,y1:n}),r=[];for(const t of o){const i=this.sxs[t],n=this.sys[t];for(let o=0,h=i.length;o<h;o++){const h=i[o].length;if(d.point_in_poly(s,e,i[o][0],n[o][0]))if(1==h)r.push(t);else if(l.get(t)){if(h>1){let l=!1;for(let t=1;t<h;t++){const r=i[o][t],h=n[o][t];if(d.point_in_poly(s,e,r,h)){l=!0;break}}l||r.push(t)}}else r.push(t)}}return new y.Selection({indices:r})}_get_snap_coord(t){return a.sum(t)/t.length}scenterxy(t,s,e){if(1==this.sxs[t].length){return[this._get_snap_coord(this.sxs[t][0][0]),this._get_snap_coord(this.sys[t][0][0])]}{const i=this.sxs[t],n=this.sys[t];for(let t=0,o=i.length;t<o;t++)if(d.point_in_poly(s,e,i[t][0],n[t][0])){return[this._get_snap_coord(i[t][0]),this._get_snap_coord(n[t][0])]}}f.unreachable()}map_data(){const t=this._xs.length;this.sxs=new Array(t),this.sys=new Array(t);for(let s=0;s<t;s++){const t=this._xs[s].length;this.sxs[s]=new Array(t),this.sys[s]=new Array(t);for(let e=0;e<t;e++){const t=this._xs[s][e].length;this.sxs[s][e]=new Array(t),this.sys[s][e]=new Array(t);for(let i=0;i<t;i++){const[t,n]=this.renderer.coordinates.map_to_screen(this._xs[s][e][i],this._ys[s][e][i]);this.sxs[s][e][i]=t,this.sys[s][e][i]=n}}}}draw_legend_for_index(t,s,e){h.generic_area_vector_legend(this.visuals,t,s,e)}}e.MultiPolygonsView=g,g.__name__="MultiPolygonsView";class p extends r.Glyph{constructor(t){super(t)}static init_MultiPolygons(){this.prototype.default_view=g,this.define((({})=>({xs:[x.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[x.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}))),this.mixins([c.LineVector,c.FillVector,c.HatchVector])}}e.MultiPolygons=p,p.__name__="MultiPolygons",p.init_MultiPolygons()},
function _(a,t,e,l,s){l();const _=a(287),i=a(12);class n extends _.EllipseOvalView{_map_data(){super._map_data(),i.mul(this.sw,.75)}}e.OvalView=n,n.__name__="OvalView";class v extends _.EllipseOval{constructor(a){super(a)}static init_Oval(){this.prototype.default_view=n}}e.Oval=v,v.__name__="Oval",v.init_Oval()},
function _(t,e,i,o,s){o();const r=t(1),_=t(290),d=r.__importStar(t(18));class n extends _.BoxView{scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}i.QuadView=n,n.__name__="QuadView";class a extends _.Box{constructor(t){super(t)}static init_Quad(){this.prototype.default_view=n,this.define((({})=>({right:[d.XCoordinateSpec,{field:"right"}],bottom:[d.YCoordinateSpec,{field:"bottom"}],left:[d.XCoordinateSpec,{field:"left"}],top:[d.YCoordinateSpec,{field:"top"}]})))}}i.Quad=a,a.__name__="Quad",a.init_Quad()},
function _(e,t,i,s,n){s();const a=e(1),c=e(48),o=e(65),r=e(98),_=e(106),d=a.__importStar(e(18));function l(e,t,i){if(t==(e+i)/2)return[e,i];{const s=(e-t)/(e-2*t+i),n=e*(1-s)**2+2*t*(1-s)*s+i*s**2;return[Math.min(e,i,n),Math.max(e,i,n)]}}class x extends r.GlyphView{_project_data(){o.inplace.project_xy(this._x0,this._y0),o.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{_x0:t,_x1:i,_y0:s,_y1:n,_cx:a,_cy:c,data_size:o}=this;for(let r=0;r<o;r++){const o=t[r],_=i[r],d=s[r],x=n[r],y=a[r],h=c[r];if(isNaN(o+_+d+x+y+h))e.add_empty();else{const[t,i]=l(o,y,_),[s,n]=l(d,h,x);e.add(t,s,i,n)}}}_render(e,t,i){if(this.visuals.line.doit){const{sx0:s,sy0:n,sx1:a,sy1:c,scx:o,scy:r}=null!=i?i:this;for(const i of t){const t=s[i],_=n[i],d=a[i],l=c[i],x=o[i],y=r[i];isNaN(t+_+d+l+x+y)||(e.beginPath(),e.moveTo(t,_),e.quadraticCurveTo(x,y,d,l),this.visuals.line.set_vectorize(e,i),e.stroke())}}}draw_legend_for_index(e,t,i){_.generic_line_vector_legend(this.visuals,e,t,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.QuadraticView=x,x.__name__="QuadraticView";class y extends r.Glyph{constructor(e){super(e)}static init_Quadratic(){this.prototype.default_view=x,this.define((({})=>({x0:[d.XCoordinateSpec,{field:"x0"}],y0:[d.YCoordinateSpec,{field:"y0"}],x1:[d.XCoordinateSpec,{field:"x1"}],y1:[d.YCoordinateSpec,{field:"y1"}],cx:[d.XCoordinateSpec,{field:"cx"}],cy:[d.YCoordinateSpec,{field:"cy"}]}))),this.mixins(c.LineVector)}}i.Quadratic=y,y.__name__="Quadratic",y.init_Quadratic()},
function _(e,t,s,i,n){i();const a=e(1),l=e(64),h=e(106),r=e(48),o=e(24),_=a.__importStar(e(18));class c extends l.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this.length):this.slength=o.to_screen(this.length);const{width:e,height:t}=this.renderer.plot_view.frame.bbox,s=2*(e+t),{slength:i}=this;for(let e=0,t=i.length;e<t;e++)0==i[e]&&(i[e]=s)}_render(e,t,s){const{sx:i,sy:n,slength:a,angle:l}=null!=s?s:this;if(this.visuals.line.doit)for(const s of t){const t=i[s],h=n[s],r=l.get(s),o=a[s];isNaN(t+h+r+o)||(e.translate(t,h),e.rotate(r),e.beginPath(),e.moveTo(0,0),e.lineTo(o,0),this.visuals.line.set_vectorize(e,s),e.stroke(),e.rotate(-r),e.translate(-t,-h))}}draw_legend_for_index(e,t,s){h.generic_line_vector_legend(this.visuals,e,t,s)}}s.RayView=c,c.__name__="RayView";class g extends l.XYGlyph{constructor(e){super(e)}static init_Ray(){this.prototype.default_view=c,this.mixins(r.LineVector),this.define((({})=>({length:[_.DistanceSpec,0],angle:[_.AngleSpec,0]})))}}s.Ray=g,g.__name__="Ray",g.init_Ray()},
function _(t,s,e,i,h){i();const r=t(288),n=t(106),a=t(24),o=t(12),l=t(59);class _ extends r.CenterRotatableView{_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this.width,this.renderer.xscale);else{this.sw=a.to_screen(this.width);const t=this.sx.length;this.sx0=new a.ScreenArray(t);for(let s=0;s<t;s++)this.sx0[s]=this.sx[s]-this.sw[s]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this.height,this.renderer.yscale);else{this.sh=a.to_screen(this.height);const t=this.sy.length;this.sy1=new a.ScreenArray(t);for(let s=0;s<t;s++)this.sy1[s]=this.sy[s]-this.sh[s]/2}const t=this.sw.length;this.ssemi_diag=new a.ScreenArray(t);for(let s=0;s<t;s++)this.ssemi_diag[s]=Math.sqrt(this.sw[s]/2*this.sw[s]/2+this.sh[s]/2*this.sh[s]/2)}_render(t,s,e){const{sx:i,sy:h,sx0:r,sy1:n,sw:a,sh:o,angle:l}=null!=e?e:this;for(const e of s){const s=i[e],_=h[e],c=r[e],d=n[e],f=a[e],y=o[e],g=l.get(e);isNaN(s+_+c+d+f+y+g)||0!=f&&0!=y&&(t.beginPath(),g?(t.translate(s,_),t.rotate(g),t.rect(-f/2,-y/2,f,y),t.rotate(-g),t.translate(-s,-_)):t.rect(c,d,f,y),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),t.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.stroke()))}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:s,sy:e}=t;const i=this.renderer.xscale.invert(s),h=this.renderer.yscale.invert(e),r=this.sx0.length,n=new a.ScreenArray(r);for(let t=0;t<r;t++)n[t]=this.sx0[t]+this.sw[t]/2;const _=new a.ScreenArray(r);for(let t=0;t<r;t++)_[t]=this.sy1[t]+this.sh[t]/2;const c=o.max(this._ddist(0,n,this.ssemi_diag)),d=o.max(this._ddist(1,_,this.ssemi_diag)),f=i-c,y=i+c,g=h-d,w=h+d;let x,u;const v=[];for(const t of this.index.indices({x0:f,x1:y,y0:g,y1:w})){const i=this.angle.get(t);if(i){const h=Math.sin(-i),r=Math.cos(-i),n=r*(s-this.sx[t])-h*(e-this.sy[t])+this.sx[t],a=h*(s-this.sx[t])+r*(e-this.sy[t])+this.sy[t];s=n,e=a,x=Math.abs(this.sx[t]-s)<=this.sw[t]/2,u=Math.abs(this.sy[t]-e)<=this.sh[t]/2}else{const i=s-this.sx0[t],h=e-this.sy1[t];x=0<=i&&i<=this.sw[t],u=0<=h&&h<=this.sh[t]}x&&u&&v.push(t)}return new l.Selection({indices:v})}_map_dist_corner_for_data_side_length(t,s,e){const i=t.length,h=new Float64Array(i),r=new Float64Array(i);for(let e=0;e<i;e++){const i=t[e],n=s.get(e)/2;h[e]=i-n,r[e]=i+n}const n=e.v_compute(h),a=e.v_compute(r),o=this.sdist(e,h,s,"edge",this.model.dilate);let l=n;for(let t=0;t<i;t++){const s=n[t],e=a[t];if(!isNaN(s+e)&&s!=e){l=s<e?n:a;break}}return[o,l]}_ddist(t,s,e){const i=a.infer_type(s,e),h=0==t?this.renderer.xscale:this.renderer.yscale,r=s,n=r.length,o=new i(n);for(let t=0;t<n;t++)o[t]=r[t]+e[t];const l=h.v_invert(r),_=h.v_invert(o),c=l.length,d=new i(c);for(let t=0;t<c;t++)d[t]=Math.abs(_[t]-l[t]);return d}draw_legend_for_index(t,s,e){n.generic_area_vector_legend(this.visuals,t,s,e)}}e.RectView=_,_.__name__="RectView";class c extends r.CenterRotatable{constructor(t){super(t)}static init_Rect(){this.prototype.default_view=_,this.define((({Boolean:t})=>({dilate:[t,!1]})))}}e.Rect=c,c.__name__="Rect",c.init_Rect()},
function _(e,t,r,s,i){s();const a=e(1),n=e(304),_=e(305),l=e(283),c=a.__importStar(e(18));class o extends n.MarkerView{_init_webgl(){const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e){const t=new Set(this.marker);if(1==t.size){const[r]=[...t];if(l.MarkerGL.is_supported(r)){const{glglyph:t}=this;if(null==t||t.marker_type!=r)return void(this.glglyph=new l.MarkerGL(e.gl,this,r))}}}delete this.glglyph}_set_data(e){super._set_data(e),this._init_webgl()}_render(e,t,r){const{sx:s,sy:i,size:a,angle:n,marker:l}=null!=r?r:this;for(const r of t){const t=s[r],c=i[r],o=a.get(r),g=n.get(r),h=l.get(r);if(isNaN(t+c+o+g)||null==h)continue;const d=o/2;e.beginPath(),e.translate(t,c),g&&e.rotate(g),_.marker_funcs[h](e,r,d,this.visuals),g&&e.rotate(-g),e.translate(-t,-c)}}draw_legend_for_index(e,{x0:t,x1:r,y0:s,y1:i},a){const n=a+1,_=this.marker.get(a),l=Object.assign(Object.assign({},this._get_legend_args({x0:t,x1:r,y0:s,y1:i},a)),{marker:new c.UniformScalar(_,n)});this._render(e,[a],l)}}r.ScatterView=o,o.__name__="ScatterView";class g extends n.Marker{constructor(e){super(e)}static init_Scatter(){this.prototype.default_view=o,this.define((()=>({marker:[c.MarkerSpec,{value:"circle"}]})))}}r.Scatter=g,g.__name__="Scatter",g.init_Scatter()},
function _(e,t,s,i,n){i();const r=e(1),a=e(64),c=e(48),_=r.__importStar(e(107)),o=r.__importStar(e(18)),h=e(9),l=e(59);class x extends a.XYGlyphView{_render(e,t,s){const{sx:i,sy:n,size:r,angle:a}=null!=s?s:this;for(const s of t){const t=i[s],c=n[s],_=r.get(s),o=a.get(s);if(isNaN(t+c+_+o))continue;const h=_/2;e.beginPath(),e.translate(t,c),o&&e.rotate(o),this._render_one(e,s,h,this.visuals),o&&e.rotate(-o),e.translate(-t,-c)}}_mask_data(){const{x_target:e,y_target:t}=this.renderer.plot_view.frame,s=e.widen(this.max_size).map((e=>this.renderer.xscale.invert(e))),i=t.widen(this.max_size).map((e=>this.renderer.yscale.invert(e)));return this.index.indices({x0:s.start,x1:s.end,y0:i.start,y1:i.end})}_hit_point(e){const{sx:t,sy:s}=e,{max_size:i}=this,{hit_dilation:n}=this.model,r=t-i*n,a=t+i*n,[c,_]=this.renderer.xscale.r_invert(r,a),o=s-i*n,h=s+i*n,[x,d]=this.renderer.yscale.r_invert(o,h),y=this.index.indices({x0:c,x1:_,y0:x,y1:d}),g=[];for(const e of y){const i=this.size.get(e)/2*n;Math.abs(this.sx[e]-t)<=i&&Math.abs(this.sy[e]-s)<=i&&g.push(e)}return new l.Selection({indices:g})}_hit_span(e){const{sx:t,sy:s}=e,i=this.bounds(),n=this.max_size/2;let r,a,c,_;if("h"==e.direction){c=i.y0,_=i.y1;const e=t-n,s=t+n;[r,a]=this.renderer.xscale.r_invert(e,s)}else{r=i.x0,a=i.x1;const e=s-n,t=s+n;[c,_]=this.renderer.yscale.r_invert(e,t)}const o=[...this.index.indices({x0:r,x1:a,y0:c,y1:_})];return new l.Selection({indices:o})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[r,a]=this.renderer.xscale.r_invert(t,s),[c,_]=this.renderer.yscale.r_invert(i,n),o=[...this.index.indices({x0:r,x1:a,y0:c,y1:_})];return new l.Selection({indices:o})}_hit_poly(e){const{sx:t,sy:s}=e,i=h.range(0,this.sx.length),n=[];for(let e=0,r=i.length;e<r;e++){const r=i[e];_.point_in_poly(this.sx[e],this.sy[e],t,s)&&n.push(r)}return new l.Selection({indices:n})}_get_legend_args({x0:e,x1:t,y0:s,y1:i},n){const r=n+1,a=new Array(r),c=new Array(r);a[n]=(e+t)/2,c[n]=(s+i)/2;const _=.4*Math.min(Math.abs(t-e),Math.abs(i-s));return{sx:a,sy:c,size:new o.UniformScalar(_,r),angle:new o.UniformScalar(0,r)}}draw_legend_for_index(e,{x0:t,x1:s,y0:i,y1:n},r){const a=this._get_legend_args({x0:t,x1:s,y0:i,y1:n},r);this._render(e,[r],a)}}s.MarkerView=x,x.__name__="MarkerView";class d extends a.XYGlyph{constructor(e){super(e)}static init_Marker(){this.mixins([c.LineVector,c.FillVector,c.HatchVector]),this.define((({Number:e})=>({size:[o.ScreenDistanceSpec,{value:4}],angle:[o.AngleSpec,0],hit_dilation:[e,1]})))}}s.Marker=d,d.__name__="Marker",d.init_Marker()},
function _(t,e,i,o,l){o();const n=Math.sqrt(3),c=Math.sqrt(5),r=(c+1)/4,s=Math.sqrt((5-c)/8),f=(c-1)/4,a=Math.sqrt((5+c)/8);function h(t,e){t.rotate(Math.PI/4),d(t,e),t.rotate(-Math.PI/4)}function v(t,e){const i=e*n,o=i/3;t.moveTo(-i/2,-o),t.lineTo(0,0),t.lineTo(i/2,-o),t.lineTo(0,0),t.lineTo(0,e)}function d(t,e){t.moveTo(0,e),t.lineTo(0,-e),t.moveTo(-e,0),t.lineTo(e,0)}function _(t,e){t.moveTo(0,e),t.lineTo(e/1.5,0),t.lineTo(0,-e),t.lineTo(-e/1.5,0),t.closePath()}function u(t,e){const i=e*n,o=i/3;t.moveTo(-e,o),t.lineTo(e,o),t.lineTo(0,o-i),t.closePath()}function z(t,e,i,o){t.arc(0,0,i,0,2*Math.PI,!1),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}function T(t,e,i,o){_(t,i),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}function k(t,e,i,o){!function(t,e){t.beginPath(),t.arc(0,0,e/4,0,2*Math.PI,!1),t.closePath()}(t,i),o.line.set_vectorize(t,e),t.fillStyle=t.strokeStyle,t.fill()}function P(t,e,i,o){!function(t,e){const i=e/2,o=n*i;t.moveTo(e,0),t.lineTo(i,-o),t.lineTo(-i,-o),t.lineTo(-e,0),t.lineTo(-i,o),t.lineTo(i,o),t.closePath()}(t,i),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}function m(t,e,i,o){const l=2*i;t.rect(-i,-i,l,l),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}function q(t,e,i,o){!function(t,e){const i=Math.sqrt(5-2*c)*e;t.moveTo(0,-e),t.lineTo(i*f,i*a-e),t.lineTo(i*(1+f),i*a-e),t.lineTo(i*(1+f-r),i*(a+s)-e),t.lineTo(i*(1+2*f-r),i*(2*a+s)-e),t.lineTo(0,2*i*a-e),t.lineTo(-i*(1+2*f-r),i*(2*a+s)-e),t.lineTo(-i*(1+f-r),i*(a+s)-e),t.lineTo(-i*(1+f),i*a-e),t.lineTo(-i*f,i*a-e),t.closePath()}(t,i),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}function M(t,e,i,o){u(t,i),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}i.marker_funcs={asterisk:function(t,e,i,o){d(t,i),h(t,i),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},circle:z,circle_cross:function(t,e,i,o){t.arc(0,0,i,0,2*Math.PI,!1),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),d(t,i),t.stroke())},circle_dot:function(t,e,i,o){z(t,e,i,o),k(t,e,i,o)},circle_y:function(t,e,i,o){t.arc(0,0,i,0,2*Math.PI,!1),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),v(t,i),t.stroke())},circle_x:function(t,e,i,o){t.arc(0,0,i,0,2*Math.PI,!1),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),h(t,i),t.stroke())},cross:function(t,e,i,o){d(t,i),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},diamond:T,diamond_dot:function(t,e,i,o){T(t,e,i,o),k(t,e,i,o)},diamond_cross:function(t,e,i,o){_(t,i),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.moveTo(0,i),t.lineTo(0,-i),t.moveTo(-i/1.5,0),t.lineTo(i/1.5,0),t.stroke())},dot:k,hex:P,hex_dot:function(t,e,i,o){P(t,e,i,o),k(t,e,i,o)},inverted_triangle:function(t,e,i,o){t.rotate(Math.PI),u(t,i),t.rotate(-Math.PI),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},plus:function(t,e,i,o){const l=3*i/8,n=[l,l,i,i,l,l,-l,-l,-i,-i,-l,-l],c=[i,l,l,-l,-l,-i,-i,-l,-l,l,l,i];t.beginPath();for(let e=0;e<12;e++)t.lineTo(n[e],c[e]);t.closePath(),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},square:m,square_cross:function(t,e,i,o){const l=2*i;t.rect(-i,-i,l,l),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),d(t,i),t.stroke())},square_dot:function(t,e,i,o){m(t,e,i,o),k(t,e,i,o)},square_pin:function(t,e,i,o){const l=3*i/8;t.moveTo(-i,-i),t.quadraticCurveTo(0,-l,i,-i),t.quadraticCurveTo(l,0,i,i),t.quadraticCurveTo(0,l,-i,i),t.quadraticCurveTo(-l,0,-i,-i),t.closePath(),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},square_x:function(t,e,i,o){const l=2*i;t.rect(-i,-i,l,l),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.moveTo(-i,i),t.lineTo(i,-i),t.moveTo(-i,-i),t.lineTo(i,i),t.stroke())},star:q,star_dot:function(t,e,i,o){q(t,e,i,o),k(t,e,i,o)},triangle:M,triangle_dot:function(t,e,i,o){M(t,e,i,o),k(t,e,i,o)},triangle_pin:function(t,e,i,o){const l=i*n,c=l/3,r=3*c/8;t.moveTo(-i,c),t.quadraticCurveTo(0,r,i,c),t.quadraticCurveTo(n*r/2,r/2,0,c-l),t.quadraticCurveTo(-n*r/2,r/2,-i,c),t.closePath(),o.fill.doit&&(o.fill.set_vectorize(t,e),t.fill()),o.hatch.doit&&(o.hatch.set_vectorize(t,e),t.fill()),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},dash:function(t,e,i,o){!function(t,e){t.moveTo(-e,0),t.lineTo(e,0)}(t,i),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},x:function(t,e,i,o){h(t,i),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())},y:function(t,e,i,o){v(t,i),o.line.doit&&(o.line.set_vectorize(t,e),t.stroke())}}},
function _(e,t,s,i,n){i();const r=e(1),_=r.__importStar(e(107)),o=r.__importStar(e(18)),h=e(48),a=e(65),c=e(98),d=e(106),x=e(59);class y extends c.GlyphView{_project_data(){a.inplace.project_xy(this._x0,this._y0),a.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{min:t,max:s}=Math,{_x0:i,_x1:n,_y0:r,_y1:_,data_size:o}=this;for(let h=0;h<o;h++){const o=i[h],a=n[h],c=r[h],d=_[h];isNaN(o+a+c+d)?e.add_empty():e.add(t(o,a),t(c,d),s(o,a),s(c,d))}}_render(e,t,s){if(this.visuals.line.doit){const{sx0:i,sy0:n,sx1:r,sy1:_}=null!=s?s:this;for(const s of t){const t=i[s],o=n[s],h=r[s],a=_[s];isNaN(t+o+h+a)||(e.beginPath(),e.moveTo(t,o),e.lineTo(h,a),this.visuals.line.set_vectorize(e,s),e.stroke())}}}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[n,r]=this.renderer.xscale.r_invert(t-2,t+2),[o,h]=this.renderer.yscale.r_invert(s-2,s+2),a=this.index.indices({x0:n,y0:o,x1:r,y1:h}),c=[];for(const e of a){const t=Math.max(2,this.line_width.get(e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},n={x:this.sx1[e],y:this.sy1[e]};_.dist_to_segment_squared(i,s,n)<t&&c.push(e)}return new x.Selection({indices:c})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,_,o;"v"==e.direction?(o=this.renderer.yscale.invert(n),[r,_]=[this._y0,this._y1]):(o=this.renderer.xscale.invert(i),[r,_]=[this._x0,this._x1]);const h=[],[a,c]=this.renderer.xscale.r_invert(t.start,t.end),[d,y]=this.renderer.yscale.r_invert(s.start,s.end),l=this.index.indices({x0:a,y0:d,x1:c,y1:y});for(const t of l){(r[t]<=o&&o<=_[t]||_[t]<=o&&o<=r[t])&&h.push(t);const s=1.5+this.line_width.get(t)/2;r[t]==_[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&h.push(t):Math.abs(this.sy0[t]-n)<=s&&h.push(t))}return new x.Selection({indices:h})}scenterxy(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]}draw_legend_for_index(e,t,s){d.generic_line_vector_legend(this.visuals,e,t,s)}}s.SegmentView=y,y.__name__="SegmentView";class l extends c.Glyph{constructor(e){super(e)}static init_Segment(){this.prototype.default_view=y,this.define((({})=>({x0:[o.XCoordinateSpec,{field:"x0"}],y0:[o.YCoordinateSpec,{field:"y0"}],x1:[o.XCoordinateSpec,{field:"x1"}],y1:[o.YCoordinateSpec,{field:"y1"}]}))),this.mixins(h.LineVector)}}s.Segment=l,l.__name__="Segment",l.init_Segment()},
function _(t,e,s,i,n){i();const _=t(1),l=t(64),o=_.__importStar(t(48)),a=t(308);class c extends l.XYGlyphView{_set_data(){const{tension:t,closed:e}=this.model;[this._xt,this._yt]=a.catmullrom_spline(this._x,this._y,20,t,e)}_map_data(){const{x_scale:t,y_scale:e}=this.renderer.coordinates;this.sxt=t.v_compute(this._xt),this.syt=e.v_compute(this._yt)}_render(t,e,s){const{sxt:i,syt:n}=null!=s?s:this;this.visuals.line.set_value(t);const _=i.length;for(let e=0;e<_;e++)0!=e?isNaN(i[e])||isNaN(n[e])?(t.stroke(),t.beginPath()):t.lineTo(i[e],n[e]):(t.beginPath(),t.moveTo(i[e],n[e]));t.stroke()}}s.SplineView=c,c.__name__="SplineView";class h extends l.XYGlyph{constructor(t){super(t)}static init_Spline(){this.prototype.default_view=c,this.mixins(o.LineScalar),this.define((({Boolean:t,Number:e})=>({tension:[e,.5],closed:[t,!1]})))}}s.Spline=h,h.__name__="Spline",h.init_Spline()},
function _(n,t,e,o,s){o();const c=n(24),l=n(11);e.catmullrom_spline=function(n,t,e=10,o=.5,s=!1){l.assert(n.length==t.length);const r=n.length,f=s?r+1:r,w=c.infer_type(n,t),i=new w(f+2),u=new w(f+2);i.set(n,1),u.set(t,1),s?(i[0]=n[r-1],u[0]=t[r-1],i[f]=n[0],u[f]=t[0],i[f+1]=n[1],u[f+1]=t[1]):(i[0]=n[0],u[0]=t[0],i[f+1]=n[r-1],u[f+1]=t[r-1]);const g=new w(4*(e+1));for(let n=0,t=0;n<=e;n++){const o=n/e,s=o**2,c=o*s;g[t++]=2*c-3*s+1,g[t++]=-2*c+3*s,g[t++]=c-2*s+o,g[t++]=c-s}const h=new w((f-1)*(e+1)),_=new w((f-1)*(e+1));for(let n=1,t=0;n<f;n++){const s=(i[n+1]-i[n-1])*o,c=(u[n+1]-u[n-1])*o,l=(i[n+2]-i[n])*o,r=(u[n+2]-u[n])*o;for(let o=0;o<=4*e;t++){const e=g[o++],f=g[o++],w=g[o++],a=g[o++];h[t]=e*i[n]+f*i[n+1]+w*s+a*l,_[t]=e*u[n]+f*u[n+1]+w*c+a*r}}return[h,_]}},
function _(e,t,i,n,s){n();const o=e(1),l=e(64),r=e(106),a=o.__importStar(e(48)),_=e(20);class c extends l.XYGlyphView{_render(e,t,i){const{sx:n,sy:s}=null!=i?i:this;let o=!1,l=null;this.visuals.line.set_value(e);const r=t.length;if(!(r<2)){e.beginPath(),e.moveTo(n[0],s[0]);for(const i of t){let t,r,a,_;switch(this.model.mode){case"before":[t,a]=[n[i-1],s[i]],[r,_]=[n[i],s[i]];break;case"after":[t,a]=[n[i],s[i-1]],[r,_]=[n[i],s[i]];break;case"center":{const e=(n[i-1]+n[i])/2;[t,a]=[e,s[i-1]],[r,_]=[e,s[i]];break}default:throw new Error("unexpected")}if(o){if(!isFinite(n[i]+s[i])){e.stroke(),e.beginPath(),o=!1,l=i;continue}null!=l&&i-l>1&&(e.stroke(),o=!1)}o?(e.lineTo(t,a),e.lineTo(r,_)):(e.beginPath(),e.moveTo(n[i],s[i]),o=!0),l=i}e.lineTo(n[r-1],s[r-1]),e.stroke()}}draw_legend_for_index(e,t,i){r.generic_line_scalar_legend(this.visuals,e,t)}}i.StepView=c,c.__name__="StepView";class d extends l.XYGlyph{constructor(e){super(e)}static init_Step(){this.prototype.default_view=c,this.mixins(a.LineScalar),this.define((()=>({mode:[_.StepMode,"before"]})))}}i.Step=d,d.__name__="Step",d.init_Step()},
function _(t,e,s,i,n){i();const o=t(1),_=t(64),h=t(48),l=o.__importStar(t(107)),r=o.__importStar(t(18)),a=t(143),c=t(11),x=t(59);class u extends _.XYGlyphView{_rotate_point(t,e,s,i,n){return[(t-s)*Math.cos(n)-(e-i)*Math.sin(n)+s,(t-s)*Math.sin(n)+(e-i)*Math.cos(n)+i]}_text_bounds(t,e,s,i){return[[t,t+s,t+s,t,t],[e,e,e-i,e-i,e]]}_render(t,e,s){const{sx:i,sy:n,x_offset:o,y_offset:_,angle:h,text:l}=null!=s?s:this;this._sys=[],this._sxs=[];for(const s of e){const e=this._sxs[s]=[],r=this._sys[s]=[],c=i[s],x=n[s],u=o.get(s),f=_.get(s),p=h.get(s),g=l.get(s);if(!isNaN(c+x+u+f+p)&&null!=g&&this.visuals.text.doit){const i=`${g}`;t.save(),t.translate(c+u,x+f),t.rotate(p),this.visuals.text.set_vectorize(t,s);const n=this.visuals.text.font_value(s),{height:o}=a.font_metrics(n),_=this.text_line_height.get(s)*o;if(-1==i.indexOf("\n")){t.fillText(i,0,0);const s=c+u,n=x+f,o=t.measureText(i).width,[h,l]=this._text_bounds(s,n,o,_);e.push(h),r.push(l)}else{const n=i.split("\n"),o=_*n.length,h=this.text_baseline.get(s);let l;switch(h){case"top":l=0;break;case"middle":l=-o/2+_/2;break;case"bottom":l=-o+_;break;default:l=0,console.warn(`'${h}' baseline not supported with multi line text`)}for(const s of n){t.fillText(s,0,l);const i=c+u,n=l+x+f,o=t.measureText(s).width,[h,a]=this._text_bounds(i,n,o,_);e.push(h),r.push(a),l+=_}}t.restore()}}}_hit_point(t){const{sx:e,sy:s}=t,i=[];for(let t=0;t<this._sxs.length;t++){const n=this._sxs[t],o=this._sys[t],_=n.length;for(let h=0,r=_;h<r;h++){const[r,a]=this._rotate_point(e,s,n[_-1][0],o[_-1][0],-this.angle.get(t));l.point_in_poly(r,a,n[h],o[h])&&i.push(t)}}return new x.Selection({indices:i})}scenterxy(t){const e=this._sxs[t],s=this._sys[t];c.assert(0!=e.length&&0!=s.length);const i=e[0][0],n=s[0][0],o=(e[0][2]+i)/2,_=(s[0][2]+n)/2,[h,l]=this._rotate_point(o,_,i,n,this.angle.get(t));return[h,l]}}s.TextView=u,u.__name__="TextView";class f extends _.XYGlyph{constructor(t){super(t)}static init_Text(){this.prototype.default_view=u,this.mixins(h.TextVector),this.define((({})=>({text:[r.NullStringSpec,{field:"text"}],angle:[r.AngleSpec,0],x_offset:[r.NumberSpec,0],y_offset:[r.NumberSpec,0]})))}}s.Text=f,f.__name__="Text",f.init_Text()},
function _(t,s,e,i,r){i();const h=t(1),o=t(290),a=t(24),n=h.__importStar(t(18));class _ extends o.BoxView{scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){const s=this.width.get(t)/2,e=this._x[t],i=this._top[t],r=this._bottom[t];return[e-s,e+s,Math.max(i,r),Math.min(i,r)]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new a.ScreenArray(t),this.sright=new a.ScreenArray(t);for(let s=0;s<t;s++)this.sleft[s]=this.sx[s]-this.sw[s]/2,this.sright[s]=this.sx[s]+this.sw[s]/2;this._clamp_viewport()}}e.VBarView=_,_.__name__="VBarView";class c extends o.Box{constructor(t){super(t)}static init_VBar(){this.prototype.default_view=_,this.define((({})=>({x:[n.XCoordinateSpec,{field:"x"}],bottom:[n.YCoordinateSpec,{value:0}],width:[n.NumberSpec,{value:1}],top:[n.YCoordinateSpec,{field:"top"}]})))}}e.VBar=c,c.__name__="VBar",c.init_VBar()},
function _(e,t,s,i,n){i();const r=e(1),a=e(64),l=e(106),c=e(48),d=e(24),h=e(20),o=r.__importStar(e(18)),_=e(10),u=e(59);class g extends a.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=d.to_screen(this.radius)}_render(e,t,s){const{sx:i,sy:n,sradius:r,start_angle:a,end_angle:l}=null!=s?s:this,c="anticlock"==this.model.direction;for(const s of t){const t=i[s],d=n[s],h=r[s],o=a.get(s),_=l.get(s);isNaN(t+d+h+o+_)||(e.beginPath(),e.arc(t,d,h,o,_,c),e.lineTo(t,d),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,s),e.fill()),this.visuals.hatch.doit&&(this.visuals.hatch.set_vectorize(e,s),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,s),e.stroke()))}}_hit_point(e){let t,s,i,n,r,a,l,c,d;const{sx:h,sy:o}=e,g=this.renderer.xscale.invert(h),p=this.renderer.yscale.invert(o),x=2*this.max_radius;"data"===this.model.properties.radius.units?(a=g-x,l=g+x,c=p-x,d=p+x):(s=h-x,i=h+x,[a,l]=this.renderer.xscale.r_invert(s,i),n=o-x,r=o+x,[c,d]=this.renderer.yscale.r_invert(n,r));const f=[];for(const e of this.index.indices({x0:a,x1:l,y0:c,y1:d})){const a=this.sradius[e]**2;[s,i]=this.renderer.xscale.r_compute(g,this._x[e]),[n,r]=this.renderer.yscale.r_compute(p,this._y[e]),t=(s-i)**2+(n-r)**2,t<=a&&f.push(e)}const v="anticlock"==this.model.direction,y=[];for(const e of f){const t=Math.atan2(o-this.sy[e],h-this.sx[e]);_.angle_between(-t,-this.start_angle.get(e),-this.end_angle.get(e),v)&&y.push(e)}return new u.Selection({indices:y})}draw_legend_for_index(e,t,s){l.generic_area_vector_legend(this.visuals,e,t,s)}scenterxy(e){const t=this.sradius[e]/2,s=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(s),this.sy[e]+t*Math.sin(s)]}}s.WedgeView=g,g.__name__="WedgeView";class p extends a.XYGlyph{constructor(e){super(e)}static init_Wedge(){this.prototype.default_view=g,this.mixins([c.LineVector,c.FillVector,c.HatchVector]),this.define((({})=>({direction:[h.Direction,"anticlock"],radius:[o.DistanceSpec,{field:"radius"}],start_angle:[o.AngleSpec,{field:"start_angle"}],end_angle:[o.AngleSpec,{field:"end_angle"}]})))}}s.Wedge=p,p.__name__="Wedge",p.init_Wedge()},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(126),r),e.__exportStar(t(125),r),e.__exportStar(t(314),r)},
function _(t,a,o,r,e){r();const n=t(125);class l extends n.LayoutProvider{constructor(t){super(t)}static init_StaticLayoutProvider(){this.define((({Number:t,Tuple:a,Dict:o})=>({graph_layout:[o(a(t,t)),{}]})))}get_node_coordinates(t){var a;const o=null!==(a=t.data.index)&&void 0!==a?a:[],r=o.length,e=new Float64Array(r),n=new Float64Array(r);for(let t=0;t<r;t++){const a=this.graph_layout[o[t]],[r,l]=null!=a?a:[NaN,NaN];e[t]=r,n[t]=l}return[e,n]}get_edge_coordinates(t){var a,o;const r=null!==(a=t.data.start)&&void 0!==a?a:[],e=null!==(o=t.data.end)&&void 0!==o?o:[],n=Math.min(r.length,e.length),l=[],i=[],u=null!=t.data.xs&&null!=t.data.ys;for(let a=0;a<n;a++){const o=null!=this.graph_layout[r[a]]&&null!=this.graph_layout[e[a]];if(u&&o)l.push(t.data.xs[a]),i.push(t.data.ys[a]);else{let t,n;o?(t=this.graph_layout[r[a]],n=this.graph_layout[e[a]]):(t=[NaN,NaN],n=[NaN,NaN]),l.push([t[0],n[0]]),i.push([t[1],n[1]])}}return[l,i]}}o.StaticLayoutProvider=l,l.__name__="StaticLayoutProvider",l.init_StaticLayoutProvider()},
function _(i,d,n,r,G){r(),G("Grid",i(316).Grid)},
function _(i,e,t,s,n){s();const r=i(1),o=i(162),d=i(164),l=i(165),_=r.__importStar(i(48)),a=i(8);class h extends d.GuideRendererView{_render(){const i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;const[e,t]=this.grid_coords("major",!1);for(let s=0;s<e.length-1;s++){if(s%2!=1)continue;const[n,r]=this.coordinates.map_to_screen(e[s],t[s]),[o,d]=this.coordinates.map_to_screen(e[s+1],t[s+1]);i.beginPath(),i.rect(n[0],r[0],o[1]-n[0],d[1]-r[0]),this.visuals.band_fill.doit&&(this.visuals.band_fill.set_value(i),i.fill()),this.visuals.band_hatch.doit&&(this.visuals.band_hatch.set_value(i),i.fill())}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,t]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,t)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,t]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,t)}_draw_grid_helper(i,e,t,s){e.set_value(i),i.beginPath();for(let e=0;e<t.length;e++){const[n,r]=this.coordinates.map_to_screen(t[e],s[e]);i.moveTo(Math.round(n[0]),Math.round(r[0]));for(let e=1;e<n.length;e++)i.lineTo(Math.round(n[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=(i+1)%2,{ranges:t}=this.coordinates;return[t[i],t[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,t=[i.min,i.max];let s,n;if(a.isArray(e))s=Math.min(e[0],e[1]),n=Math.max(e[0],e[1]),s<t[0]&&(s=t[0]),n>t[1]&&(n=t[1]);else{[s,n]=t;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([s,n]=i.computed_bounds)}return[s,n]}grid_coords(i,e=!0){const t=this.model.dimension,s=(t+1)%2,[n,r]=this.ranges();let[o,d]=this.computed_bounds();[o,d]=[Math.min(o,d),Math.max(o,d)];const l=[[],[]],_=this.model.get_ticker();if(null==_)return l;const a=_.get_ticks(o,d,n,r.min)[i],h=n.min,u=n.max,c=r.min,m=r.max;e||(a[0]!=h&&a.splice(0,0,h),a[a.length-1]!=u&&a.push(u));for(let i=0;i<a.length;i++){if((a[i]==h||a[i]==u)&&e)continue;const n=[],r=[],o=2;for(let e=0;e<o;e++){const t=c+(m-c)/(o-1)*e;n.push(a[i]),r.push(t)}l[t].push(n),l[s].push(r)}return l}}t.GridView=h,h.__name__="GridView";class u extends d.GuideRenderer{constructor(i){super(i)}static init_Grid(){this.prototype.default_view=h,this.mixins([["grid_",_.Line],["minor_grid_",_.Line],["band_",_.Fill],["band_",_.Hatch]]),this.define((({Number:i,Auto:e,Enum:t,Ref:s,Tuple:n,Or:r,Nullable:d})=>({bounds:[r(n(i,i),e),"auto"],dimension:[t(0,1),0],axis:[d(s(o.Axis)),null],ticker:[d(s(l.Ticker)),null]}))),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}t.Grid=u,u.__name__="Grid",u.init_Grid()},
function _(o,a,x,B,e){B(),e("Box",o(318).Box),e("Column",o(320).Column),e("GridBox",o(321).GridBox),e("HTMLBox",o(322).HTMLBox),e("LayoutDOM",o(319).LayoutDOM),e("Panel",o(323).Panel),e("Row",o(324).Row),e("Spacer",o(325).Spacer),e("Tabs",o(326).Tabs),e("WidgetBox",o(329).WidgetBox)},
function _(e,n,i,t,s){t();const o=e(319);class c extends o.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,(()=>this.rebuild()))}get child_models(){return this.model.children}}i.BoxView=c,c.__name__="BoxView";class r extends o.LayoutDOM{constructor(e){super(e)}static init_Box(){this.define((({Number:e,Array:n,Ref:i})=>({children:[n(i(o.LayoutDOM)),[]],spacing:[e,0]})))}}i.Box=r,r.__name__="Box",r.init_Box()},
function _(i,t,e,s,o){s();const l=i(53),n=i(20),h=i(43),a=i(19),r=i(8),_=i(22),d=i(122),c=i(240),u=i(221),m=i(44),p=i(249);class g extends c.DOMView{constructor(){super(...arguments),this._idle_notified=!1,this._offset_parent=null,this._viewport={}}initialize(){super.initialize(),this.el.style.position=this.is_root?"relative":"absolute",this._child_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await this.build_child_views()}remove(){for(const i of this.child_views)i.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.is_root&&(this._on_resize=()=>this.resize_layout(),window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((()=>{const i=this.el.offsetParent;this._offset_parent!=i&&(this._offset_parent=i,null!=i&&(this.compute_viewport(),this.invalidate_layout()))}),250));const i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible],(()=>this.invalidate_layout())),this.on_change([i.background,i.css_classes],(()=>this.invalidate_render()))}disconnect_signals(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),super.disconnect_signals()}css_classes(){return super.css_classes().concat(this.model.css_classes)}get child_views(){return this.child_models.map((i=>this._child_views.get(i)))}async build_child_views(){await d.build_views(this._child_views,this.child_models,{parent:this})}render(){super.render(),h.empty(this.el);const{background:i}=this.model;this.el.style.backgroundColor=null!=i?_.color2css(i):"",h.classes(this.el).clear().add(...this.css_classes());for(const i of this.child_views)this.el.appendChild(i.el),i.render()}update_layout(){for(const i of this.child_views)i.update_layout();this._update_layout()}update_position(){this.el.style.display=this.model.visible?"block":"none";const i=this.is_root?this.layout.sizing.margin:void 0;h.position(this.el,this.layout.bbox,i);for(const i of this.child_views)i.update_position()}after_layout(){for(const i of this.child_views)i.after_layout();this._has_finished=!0}compute_viewport(){this._viewport=this._viewport_size()}renderTo(i){i.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()}build(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this}async rebuild(){await this.build_child_views(),this.invalidate_render()}compute_layout(){const i=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),a.logger.debug(`layout computed in ${Date.now()-i} ms`),this.notify_finished()}resize_layout(){this.root.compute_viewport(),this.root.compute_layout()}invalidate_layout(){this.root.update_layout(),this.root.compute_layout()}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const i of this.child_views)if(!i.has_finished())return!1;return!0}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}_width_policy(){return null!=this.model.width?"fixed":"fit"}_height_policy(){return null!=this.model.height?"fixed":"fit"}box_sizing(){let{width_policy:i,height_policy:t,aspect_ratio:e}=this.model;"auto"==i&&(i=this._width_policy()),"auto"==t&&(t=this._height_policy());const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)i=t="fixed";else if("stretch_both"==s)i=t="max";else if("stretch_width"==s)i="max";else if("stretch_height"==s)t="max";else switch(null==e&&(e="auto"),s){case"scale_width":i="max",t="min";break;case"scale_height":i="min",t="max";break;case"scale_both":i="max",t="max"}const o={width_policy:i,height_policy:t},{min_width:l,min_height:n}=this.model;null!=l&&(o.min_width=l),null!=n&&(o.min_height=n);const{width:h,height:a}=this.model;null!=h&&(o.width=h),null!=a&&(o.height=a);const{max_width:_,max_height:d}=this.model;null!=_&&(o.max_width=_),null!=d&&(o.max_height=d),"auto"==e&&null!=h&&null!=a?o.aspect=h/a:r.isNumber(e)&&(o.aspect=e);const{margin:c}=this.model;if(null!=c)if(r.isNumber(c))o.margin={top:c,right:c,bottom:c,left:c};else if(2==c.length){const[i,t]=c;o.margin={top:i,right:t,bottom:i,left:t}}else{const[i,t,e,s]=c;o.margin={top:i,right:t,bottom:e,left:s}}o.visible=this.model.visible;const{align:u}=this.model;return r.isArray(u)?[o.halign,o.valign]=u:o.halign=o.valign=u,o}_viewport_size(){return h.undisplayed(this.el,(()=>{let i=this.el;for(;i=i.parentElement;){if(i.classList.contains(m.root))continue;if(i==document.body){const{margin:{left:i,right:t,top:e,bottom:s}}=h.extents(document.body);return{width:Math.ceil(document.documentElement.clientWidth-i-t),height:Math.ceil(document.documentElement.clientHeight-e-s)}}const{padding:{left:t,right:e,top:s,bottom:o}}=h.extents(i),{width:l,height:n}=i.getBoundingClientRect(),a=Math.ceil(l-t-e),r=Math.ceil(n-s-o);if(a>0||r>0)return{width:a>0?a:void 0,height:r>0?r:void 0}}return{}}))}export(i,t=!0){const e="png"==i?"canvas":"svg",s=new p.CanvasLayer(e,t),{width:o,height:l}=this.layout.bbox;s.resize(o,l);for(const e of this.child_views){const o=e.export(i,t),{x:l,y:n}=e.layout.bbox;s.ctx.drawImage(o.canvas,l,n)}return s}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box,children:this.child_views.map((i=>i.serializable_state()))})}}e.LayoutDOMView=g,g.__name__="LayoutDOMView";class f extends l.Model{constructor(i){super(i)}static init_LayoutDOM(){this.define((i=>{const{Boolean:t,Number:e,String:s,Auto:o,Color:l,Array:h,Tuple:a,Or:r,Null:_,Nullable:d}=i,c=a(e,e),m=a(e,e,e,e);return{width:[d(e),null],height:[d(e),null],min_width:[d(e),null],min_height:[d(e),null],max_width:[d(e),null],max_height:[d(e),null],margin:[d(r(e,c,m)),[0,0,0,0]],width_policy:[r(u.SizingPolicy,o),"auto"],height_policy:[r(u.SizingPolicy,o),"auto"],aspect_ratio:[r(e,o,_),null],sizing_mode:[d(n.SizingMode),null],visible:[t,!0],disabled:[t,!1],align:[r(n.Align,a(n.Align,n.Align)),"start"],background:[d(l),null],css_classes:[h(s),[]]}}))}}e.LayoutDOM=f,f.__name__="LayoutDOM",f.init_LayoutDOM()},
function _(t,s,i,o,n){o();const e=t(318),l=t(223);class u extends e.BoxView{_update_layout(){const t=this.child_views.map((t=>t.layout));this.layout=new l.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}}i.ColumnView=u,u.__name__="ColumnView";class a extends e.Box{constructor(t){super(t)}static init_Column(){this.prototype.default_view=u,this.define((({Any:t})=>({rows:[t,"auto"]})))}}i.Column=a,a.__name__="Column",a.init_Column()},
function _(t,s,i,o,e){o();const n=t(319),l=t(223);class a extends n.LayoutDOMView{connect_signals(){super.connect_signals();const{children:t,rows:s,cols:i,spacing:o}=this.model.properties;this.on_change([t,s,i,o],(()=>this.rebuild()))}get child_models(){return this.model.children.map((([t])=>t))}_update_layout(){this.layout=new l.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(const[t,s,i,o,e]of this.model.children){const n=this._child_views.get(t);this.layout.items.push({layout:n.layout,row:s,col:i,row_span:o,col_span:e})}this.layout.set_sizing(this.box_sizing())}}i.GridBoxView=a,a.__name__="GridBoxView";class r extends n.LayoutDOM{constructor(t){super(t)}static init_GridBox(){this.prototype.default_view=a,this.define((({Any:t,Int:s,Number:i,Tuple:o,Array:e,Ref:l,Or:a,Opt:r})=>({children:[e(o(l(n.LayoutDOM),s,s,r(s),r(s))),[]],rows:[t,"auto"],cols:[t,"auto"],spacing:[a(i,o(i,i)),0]})))}}i.GridBox=r,r.__name__="GridBox",r.init_GridBox()},
function _(t,e,o,s,n){s();const _=t(319),i=t(221);class a extends _.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new i.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())}}o.HTMLBoxView=a,a.__name__="HTMLBoxView";class u extends _.LayoutDOM{constructor(t){super(t)}}o.HTMLBox=u,u.__name__="HTMLBox"},
function _(e,n,t,i,l){i();const a=e(53),o=e(319);class s extends a.Model{constructor(e){super(e)}static init_Panel(){this.define((({Boolean:e,String:n,Ref:t})=>({title:[n,""],child:[t(o.LayoutDOM)],closable:[e,!1]})))}}t.Panel=s,s.__name__="Panel",s.init_Panel()},
function _(t,s,i,o,e){o();const n=t(318),a=t(223);class _ extends n.BoxView{_update_layout(){const t=this.child_views.map((t=>t.layout));this.layout=new a.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())}}i.RowView=_,_.__name__="RowView";class l extends n.Box{constructor(t){super(t)}static init_Row(){this.prototype.default_view=_,this.define((({Any:t})=>({cols:[t,"auto"]})))}}i.Row=l,l.__name__="Row",l.init_Row()},
function _(t,e,a,i,s){i();const _=t(319),c=t(221);class n extends _.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new c.LayoutItem,this.layout.set_sizing(this.box_sizing())}}a.SpacerView=n,n.__name__="SpacerView";class o extends _.LayoutDOM{constructor(t){super(t)}static init_Spacer(){this.prototype.default_view=n}}a.Spacer=o,o.__name__="Spacer",o.init_Spacer()},
function _(e,t,s,i,a){i();const l=e(1),h=e(221),o=e(43),c=e(9),d=e(20),r=e(319),n=e(323),_=l.__importStar(e(327)),p=_,b=l.__importStar(e(328)),u=b,m=l.__importStar(e(243)),v=m;class g extends r.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.tabs.change,(()=>this.rebuild())),this.connect(this.model.properties.active.change,(()=>this.on_active_change()))}styles(){return[...super.styles(),b.default,m.default,_.default]}get child_models(){return this.model.tabs.map((e=>e.child))}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:i}=this;this.header=new class extends h.ContentBox{_measure(e){const a=o.size(s),l=o.children(i).slice(0,3).map((e=>o.size(e))),{width:h,height:d}=super._measure(e);if(t){const t=a.width+c.sum(l.map((e=>e.width)));return{width:e.width!=1/0?e.width:t,height:d}}{const t=a.height+c.sum(l.map((e=>e.height)));return{width:h,height:e.height!=1/0?e.height:t}}}}(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});let a=1,l=1;switch(e){case"above":a-=1;break;case"below":a+=1;break;case"left":l-=1;break;case"right":l+=1}const d={layout:this.header,row:a,col:l},r=this.child_views.map((e=>({layout:e.layout,row:1,col:1})));this.layout=new h.Grid([d,...r]),this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.header_el.style.position="absolute",o.position(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=o.size(this.scroll_el),i=o.scroll_size(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=e-s.width+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",o.undisplay(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=e-s.height+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",o.undisplay(this.scroll_el))}const{child_views:a}=this;for(const e of a)o.hide(e.el);const l=a[this.model.active];null!=l&&o.show(l.el)}render(){super.render();const{active:e}=this.model,t=this.model.tabs_location,s="above"==t||"below"==t,i=this.model.tabs.map(((t,s)=>{const i=o.div({class:[p.tab,s==e?p.active:null]},t.title);if(i.addEventListener("click",(e=>{e.target==e.currentTarget&&this.change_active(s)})),t.closable){const e=o.div({class:p.close});e.addEventListener("click",(e=>{if(e.target==e.currentTarget){this.model.tabs=c.remove_at(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}})),i.appendChild(e)}return i}));this.headers_el=o.div({class:[p.headers]},i),this.wrapper_el=o.div({class:p.headers_wrapper},this.headers_el);const a=o.div({class:[u.btn,u.btn_default],disabled:""},o.div({class:[v.caret,p.left]})),l=o.div({class:[u.btn,u.btn_default]},o.div({class:[v.caret,p.right]}));let h=0;const d=e=>()=>{const t=this.model.tabs.length;h="left"==e?Math.max(h-1,0):Math.min(h+1,t-1),0==h?a.setAttribute("disabled",""):a.removeAttribute("disabled"),h==t-1?l.setAttribute("disabled",""):l.removeAttribute("disabled");const i=o.children(this.headers_el).slice(0,h).map((e=>e.getBoundingClientRect()));if(s){const e=-c.sum(i.map((e=>e.width)));this.headers_el.style.left=`${e}px`}else{const e=-c.sum(i.map((e=>e.height)));this.headers_el.style.top=`${e}px`}};a.addEventListener("click",d("left")),l.addEventListener("click",d("right")),this.scroll_el=o.div({class:u.btn_group},a,l),this.header_el=o.div({class:[p.tabs_header,p[t]]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)}change_active(e){e!=this.model.active&&(this.model.active=e)}on_active_change(){const e=this.model.active,t=o.children(this.headers_el);for(const e of t)e.classList.remove(p.active);t[e].classList.add(p.active);const{child_views:s}=this;for(const e of s)o.hide(e.el);o.show(s[e].el)}}s.TabsView=g,g.__name__="TabsView";class w extends r.LayoutDOM{constructor(e){super(e)}static init_Tabs(){this.prototype.default_view=g,this.define((({Int:e,Array:t,Ref:s})=>({tabs:[t(s(n.Panel)),[]],tabs_location:[d.Location,"above"],active:[e,0]})))}}s.Tabs=w,w.__name__="Tabs",w.init_Tabs()},
function _(e,r,b,o,t){o(),b.root="bk-root",b.tabs_header="bk-tabs-header",b.btn_group="bk-btn-group",b.btn="bk-btn",b.headers_wrapper="bk-headers-wrapper",b.above="bk-above",b.right="bk-right",b.below="bk-below",b.left="bk-left",b.headers="bk-headers",b.tab="bk-tab",b.active="bk-active",b.close="bk-close",b.default='.bk-root .bk-tabs-header{display:flex;display:-webkit-flex;flex-wrap:nowrap;-webkit-flex-wrap:nowrap;align-items:center;-webkit-align-items:center;overflow:hidden;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-tabs-header .bk-btn-group{height:auto;margin-right:5px;}.bk-root .bk-tabs-header .bk-btn-group > .bk-btn{flex-grow:0;-webkit-flex-grow:0;height:auto;padding:4px 4px;}.bk-root .bk-tabs-header .bk-headers-wrapper{flex-grow:1;-webkit-flex-grow:1;overflow:hidden;color:#666666;}.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper{border-bottom:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper{border-left:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper{border-top:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper{border-right:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-above,.bk-root .bk-tabs-header.bk-below{flex-direction:row;-webkit-flex-direction:row;}.bk-root .bk-tabs-header.bk-above .bk-headers,.bk-root .bk-tabs-header.bk-below .bk-headers{flex-direction:row;-webkit-flex-direction:row;}.bk-root .bk-tabs-header.bk-left,.bk-root .bk-tabs-header.bk-right{flex-direction:column;-webkit-flex-direction:column;}.bk-root .bk-tabs-header.bk-left .bk-headers,.bk-root .bk-tabs-header.bk-right .bk-headers{flex-direction:column;-webkit-flex-direction:column;}.bk-root .bk-tabs-header .bk-headers{position:relative;display:flex;display:-webkit-flex;flex-wrap:nowrap;-webkit-flex-wrap:nowrap;align-items:center;-webkit-align-items:center;}.bk-root .bk-tabs-header .bk-tab{padding:4px 8px;border:solid transparent;white-space:nowrap;cursor:pointer;}.bk-root .bk-tabs-header .bk-tab:hover{background-color:#f2f2f2;}.bk-root .bk-tabs-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-root .bk-tabs-header .bk-tab .bk-close{margin-left:10px;}.bk-root .bk-tabs-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:4px 4px 0 0;}.bk-root .bk-tabs-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 4px 4px 0;}.bk-root .bk-tabs-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 4px 4px;}.bk-root .bk-tabs-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:4px 0 0 4px;}.bk-root .bk-close{display:inline-block;width:10px;height:10px;vertical-align:middle;background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');}.bk-root .bk-close:hover{background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');}'},
function _(o,b,r,t,e){t(),r.root="bk-root",r.btn="bk-btn",r.active="bk-active",r.btn_default="bk-btn-default",r.btn_primary="bk-btn-primary",r.btn_success="bk-btn-success",r.btn_warning="bk-btn-warning",r.btn_danger="bk-btn-danger",r.btn_light="bk-btn-light",r.btn_group="bk-btn-group",r.dropdown_toggle="bk-dropdown-toggle",r.default=".bk-root .bk-btn{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:6px 12px;font-size:12px;border:1px solid transparent;border-radius:4px;outline:0;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-btn:hover,.bk-root .bk-btn:focus{text-decoration:none;}.bk-root .bk-btn:active,.bk-root .bk-btn.bk-active{background-image:none;box-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);}.bk-root .bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}.bk-root .bk-btn-default{color:#333;background-color:#fff;border-color:#ccc;}.bk-root .bk-btn-default:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-default.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-default[disabled],.bk-root .bk-btn-default[disabled]:hover,.bk-root .bk-btn-default[disabled]:focus,.bk-root .bk-btn-default[disabled]:active,.bk-root .bk-btn-default[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-primary{color:#fff;background-color:#428bca;border-color:#357ebd;}.bk-root .bk-btn-primary:hover{background-color:#3681c1;border-color:#2c699e;}.bk-root .bk-btn-primary.bk-active{background-color:#3276b1;border-color:#285e8e;}.bk-root .bk-btn-primary[disabled],.bk-root .bk-btn-primary[disabled]:hover,.bk-root .bk-btn-primary[disabled]:focus,.bk-root .bk-btn-primary[disabled]:active,.bk-root .bk-btn-primary[disabled].bk-active{background-color:#506f89;border-color:#357ebd;}.bk-root .bk-btn-success{color:#fff;background-color:#5cb85c;border-color:#4cae4c;}.bk-root .bk-btn-success:hover{background-color:#4eb24e;border-color:#409240;}.bk-root .bk-btn-success.bk-active{background-color:#47a447;border-color:#398439;}.bk-root .bk-btn-success[disabled],.bk-root .bk-btn-success[disabled]:hover,.bk-root .bk-btn-success[disabled]:focus,.bk-root .bk-btn-success[disabled]:active,.bk-root .bk-btn-success[disabled].bk-active{background-color:#667b66;border-color:#4cae4c;}.bk-root .bk-btn-warning{color:#fff;background-color:#f0ad4e;border-color:#eea236;}.bk-root .bk-btn-warning:hover{background-color:#eea43b;border-color:#e89014;}.bk-root .bk-btn-warning.bk-active{background-color:#ed9c28;border-color:#d58512;}.bk-root .bk-btn-warning[disabled],.bk-root .bk-btn-warning[disabled]:hover,.bk-root .bk-btn-warning[disabled]:focus,.bk-root .bk-btn-warning[disabled]:active,.bk-root .bk-btn-warning[disabled].bk-active{background-color:#c89143;border-color:#eea236;}.bk-root .bk-btn-danger{color:#fff;background-color:#d9534f;border-color:#d43f3a;}.bk-root .bk-btn-danger:hover{background-color:#d5433e;border-color:#bd2d29;}.bk-root .bk-btn-danger.bk-active{background-color:#d2322d;border-color:#ac2925;}.bk-root .bk-btn-danger[disabled],.bk-root .bk-btn-danger[disabled]:hover,.bk-root .bk-btn-danger[disabled]:focus,.bk-root .bk-btn-danger[disabled]:active,.bk-root .bk-btn-danger[disabled].bk-active{background-color:#a55350;border-color:#d43f3a;}.bk-root .bk-btn-light{color:#333;background-color:#fff;border-color:#ccc;border-color:transparent;}.bk-root .bk-btn-light:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-light.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-light[disabled],.bk-root .bk-btn-light[disabled]:hover,.bk-root .bk-btn-light[disabled]:focus,.bk-root .bk-btn-light[disabled]:active,.bk-root .bk-btn-light[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-group{height:100%;display:flex;display:-webkit-flex;flex-wrap:nowrap;-webkit-flex-wrap:nowrap;align-items:center;-webkit-align-items:center;flex-direction:row;-webkit-flex-direction:row;}.bk-root .bk-btn-group > .bk-btn{flex-grow:1;-webkit-flex-grow:1;}.bk-root .bk-btn-group > .bk-btn + .bk-btn{margin-left:-1px;}.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-root .bk-btn-group .bk-dropdown-toggle{flex:0 0 0;-webkit-flex:0 0 0;padding:6px 6px;}"},
function _(t,e,i,o,n){o();const _=t(320);class s extends _.ColumnView{}i.WidgetBoxView=s,s.__name__="WidgetBoxView";class d extends _.Column{constructor(t){super(t)}static init_WidgetBox(){this.prototype.default_view=s}}i.WidgetBox=d,d.__name__="WidgetBox",d.init_WidgetBox()},
function _(p,o,t,a,n){a(),n("MapOptions",p(331).MapOptions),n("GMapOptions",p(331).GMapOptions),n("GMapPlot",p(331).GMapPlot),n("Plot",p(332).Plot)},
function _(t,i,n,e,a){e();const s=t(332),o=t(53),p=t(156),_=t(337);a("GMapPlotView",_.GMapPlotView);class l extends o.Model{constructor(t){super(t)}static init_MapOptions(){this.define((({Int:t,Number:i})=>({lat:[i],lng:[i],zoom:[t,12]})))}}n.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();class r extends l{constructor(t){super(t)}static init_GMapOptions(){this.define((({Boolean:t,Int:i,String:n})=>({map_type:[n,"roadmap"],scale_control:[t,!1],styles:[n],tilt:[i,45]})))}}n.GMapOptions=r,r.__name__="GMapOptions",r.init_GMapOptions();class c extends s.Plot{constructor(t){super(t),this.use_map=!0}static init_GMapPlot(){this.prototype.default_view=_.GMapPlotView,this.define((({String:t,Ref:i})=>({map_options:[i(r)],api_key:[t],api_version:[t,"3.43"]}))),this.override({x_range:()=>new p.Range1d,y_range:()=>new p.Range1d})}}n.GMapPlot=c,c.__name__="GMapPlot",c.init_GMapPlot()},
function _(e,t,i,n,r){n();const o=e(1),a=o.__importStar(e(48)),s=o.__importStar(e(18)),l=e(15),_=e(20),h=e(9),c=e(13),d=e(8),u=e(319),g=e(163),p=e(316),f=e(40),b=e(138),w=e(218),m=e(235),y=e(105),v=e(146),x=e(130),A=e(41),R=e(62),S=e(61),P=e(159),D=e(333);r("PlotView",D.PlotView);class L extends u.LayoutDOM{constructor(e){super(e),this.use_map=!1}static init_Plot(){this.prototype.default_view=D.PlotView,this.mixins([["outline_",a.Line],["background_",a.Fill],["border_",a.Fill]]),this.define((({Boolean:e,Number:t,String:i,Array:n,Dict:r,Or:o,Ref:a,Null:l,Nullable:h})=>({toolbar:[a(m.Toolbar),()=>new m.Toolbar],toolbar_location:[h(_.Location),"right"],toolbar_sticky:[e,!0],plot_width:[s.Alias("width")],plot_height:[s.Alias("height")],frame_width:[h(t),null],frame_height:[h(t),null],title:[o(a(b.Title),i,l),()=>new b.Title({text:""})],title_location:[h(_.Location),"above"],above:[n(o(a(f.Annotation),a(g.Axis))),[]],below:[n(o(a(f.Annotation),a(g.Axis))),[]],left:[n(o(a(f.Annotation),a(g.Axis))),[]],right:[n(o(a(f.Annotation),a(g.Axis))),[]],center:[n(o(a(f.Annotation),a(p.Grid))),[]],renderers:[n(a(A.Renderer)),[]],x_range:[a(y.Range),()=>new P.DataRange1d],extra_x_ranges:[r(a(y.Range)),{}],y_range:[a(y.Range),()=>new P.DataRange1d],extra_y_ranges:[r(a(y.Range)),{}],x_scale:[a(v.Scale),()=>new w.LinearScale],y_scale:[a(v.Scale),()=>new w.LinearScale],lod_factor:[t,10],lod_interval:[t,300],lod_threshold:[h(t),2e3],lod_timeout:[t,500],hidpi:[e,!0],output_backend:[_.OutputBackend,"canvas"],min_border:[h(t),5],min_border_top:[h(t),null],min_border_left:[h(t),null],min_border_bottom:[h(t),null],min_border_right:[h(t),null],inner_width:[t,0],inner_height:[t,0],outer_width:[t,0],outer_height:[t,0],match_aspect:[e,!1],aspect_scale:[t,1],reset_policy:[_.ResetPolicy,"standard"]}))),this.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})}_doc_attached(){super._doc_attached(),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])}initialize(){super.initialize(),this.reset=new l.Signal0(this,"reset");for(const e of c.values(this.extra_x_ranges).concat(this.x_range)){let t=e.plots;d.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}for(const e of c.values(this.extra_y_ranges).concat(this.y_range)){let t=e.plots;d.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}}add_layout(e,t="center"){const i=this.properties[t].get_value();this.setv({[t]:[...i,e]})}remove_layout(e){const t=t=>{h.remove_by(t,(t=>t==e))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}get data_renderers(){return this.renderers.filter((e=>e instanceof R.DataRenderer))}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new x.ColumnDataSource,i={}){const n=new S.GlyphRenderer(Object.assign(Object.assign({},i),{data_source:t,glyph:e}));return this.add_renderers(n),n}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:i,right:n}=this;return h.concat([e,t,i,n])}}i.Plot=L,L.__name__="Plot",L.init_Plot()},
function _(e,t,i,s,a){s();const n=e(1),o=e(144),l=e(262),r=e(319),_=e(40),h=e(138),d=e(163),u=e(234),c=e(264),p=e(122),v=e(45),b=e(19),g=e(334),m=e(8),w=e(9),y=e(249),f=e(222),x=e(225),z=e(223),k=e(140),q=e(99),M=e(335),V=e(336),P=e(28);class R extends r.LayoutDOMView{constructor(){super(...arguments),this._outer_bbox=new q.BBox,this._inner_bbox=new q.BBox,this._needs_paint=!0,this._needs_layout=!1,this._invalidated_painters=new Set,this._invalidate_all=!0}get canvas(){return this.canvas_view}get state(){return this._state_manager}set invalidate_dataranges(e){this._range_manager.invalidate_dataranges=e}renderer_view(e){const t=this.renderer_views.get(e);if(null==t)for(const[,t]of this.renderer_views){const i=t.renderer_view(e);if(null!=i)return i}return t}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(e=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||e||this.request_paint("everything")}request_render(){this.request_paint("everything")}request_paint(e){this.invalidate_painters(e),this.schedule_paint()}invalidate_painters(e){if("everything"==e)this._invalidate_all=!0;else if(m.isArray(e))for(const t of e)this._invalidated_painters.add(t);else this._invalidated_painters.add(e)}schedule_paint(){if(!this.is_paused){const e=this.throttled_paint();this._ready=this._ready.then((()=>e))}}request_layout(){this._needs_layout=!0,this.request_paint("everything")}reset(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new c.Reset)}remove(){p.remove_views(this.renderer_views),p.remove_views(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.lod_started=!1,this.visuals=new v.Visuals(this),this._initial_state={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.renderer_views=new Map,this.tool_views=new Map,this.frame=new o.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this._range_manager=new M.RangeManager(this),this._state_manager=new V.StateManager(this,this._initial_state),this.throttled_paint=g.throttle((()=>this.repaint()),1e3/60);const{title_location:e,title:t}=this.model;null!=e&&null!=t&&(this._title=t instanceof h.Title?t:new h.Title({text:t}));const{toolbar_location:i,toolbar:s}=this.model;null!=i&&null!=s&&(this._toolbar=new u.ToolbarPanel({toolbar:s}),s.toolbar_location=i)}async lazy_initialize(){await super.lazy_initialize();const{hidpi:e,output_backend:t}=this.model,i=new l.Canvas({hidpi:e,output_backend:t});this.canvas_view=await p.build_view(i,{parent:this}),this.canvas_view.plot_views=[this],await this.build_renderer_views(),await this.build_tool_views(),this._range_manager.update_dataranges(),this.unpause(!0),b.logger.debug("PlotView initialized")}_width_policy(){return null==this.model.frame_width?super._width_policy():"min"}_height_policy(){return null==this.model.frame_height?super._height_policy():"min"}_update_layout(){var e,t,i,s,a;this.layout=new x.BorderLayout,this.layout.set_sizing(this.box_sizing());const n=w.copy(this.model.above),o=w.copy(this.model.below),l=w.copy(this.model.left),r=w.copy(this.model.right),d=e=>{switch(e){case"above":return n;case"below":return o;case"left":return l;case"right":return r}},{title_location:c,title:p}=this.model;null!=c&&null!=p&&d(c).push(this._title);const{toolbar_location:v,toolbar:b}=this.model;if(null!=v&&null!=b){const e=d(v);let t=!0;if(this.model.toolbar_sticky)for(let i=0;i<e.length;i++){const s=e[i];if(s instanceof h.Title){e[i]="above"==v||"below"==v?[s,this._toolbar]:[this._toolbar,s],t=!1;break}}t&&e.push(this._toolbar)}const g=(e,t)=>{var i;const s=this.renderer_view(t);return s.panel=new k.Panel(e),null===(i=s.update_layout)||void 0===i||i.call(s),s.layout},y=(e,t)=>{const i="above"==e||"below"==e,s=[];for(const a of t)if(m.isArray(a)){const t=a.map((t=>{const s=g(e,t);if(t instanceof u.ToolbarPanel){const e=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[e]:"min"}))}return s}));let n;i?(n=new z.Row(t),n.set_sizing({width_policy:"max",height_policy:"min"})):(n=new z.Column(t),n.set_sizing({width_policy:"min",height_policy:"max"})),n.absolute=!0,s.push(n)}else s.push(g(e,a));return s},q=null!==(e=this.model.min_border)&&void 0!==e?e:0;this.layout.min_border={left:null!==(t=this.model.min_border_left)&&void 0!==t?t:q,top:null!==(i=this.model.min_border_top)&&void 0!==i?i:q,right:null!==(s=this.model.min_border_right)&&void 0!==s?s:q,bottom:null!==(a=this.model.min_border_bottom)&&void 0!==a?a:q};const M=new f.NodeLayout,V=new f.VStack,P=new f.VStack,R=new f.HStack,O=new f.HStack;M.absolute=!0,V.absolute=!0,P.absolute=!0,R.absolute=!0,O.absolute=!0,M.children=this.model.center.filter((e=>e instanceof _.Annotation)).map((e=>{var t;const i=this.renderer_view(e);return null===(t=i.update_layout)||void 0===t||t.call(i),i.layout})).filter((e=>null!=e));const{frame_width:S,frame_height:j}=this.model;M.set_sizing(Object.assign(Object.assign({},null!=S?{width_policy:"fixed",width:S}:{width_policy:"fit"}),null!=j?{height_policy:"fixed",height:j}:{height_policy:"fit"})),M.on_resize((e=>this.frame.set_geometry(e))),V.children=w.reversed(y("above",n)),P.children=y("below",o),R.children=w.reversed(y("left",l)),O.children=y("right",r),V.set_sizing({width_policy:"fit",height_policy:"min"}),P.set_sizing({width_policy:"fit",height_policy:"min"}),R.set_sizing({width_policy:"min",height_policy:"fit"}),O.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.center_panel=M,this.layout.top_panel=V,this.layout.bottom_panel=P,this.layout.left_panel=R,this.layout.right_panel=O}get axis_views(){const e=[];for(const[,t]of this.renderer_views)t instanceof d.AxisView&&e.push(t);return e}set_toolbar_visibility(e){for(const t of this.visibility_callbacks)t(e)}update_range(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()}reset_range(){this.update_range(null)}get_selection(){const e=new Map;for(const t of this.model.data_renderers){const{selected:i}=t.selection_manager.source;e.set(t,i)}return e}update_selection(e){for(const t of this.model.data_renderers){const i=t.selection_manager.source;if(null!=e){const s=e.get(t);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_invalidate_layout(){(()=>{var e;for(const t of this.model.side_panels){const i=this.renderer_views.get(t);if(null===(e=i.layout)||void 0===e?void 0:e.has_size_changed())return this.invalidate_painters(i),!0}return!1})()&&this.root.compute_layout()}get_renderer_views(){return this.computed_renderers.map((e=>this.renderer_views.get(e)))}*_compute_renderers(){const{above:e,below:t,left:i,right:s,center:a,renderers:n}=this.model;yield*n,yield*e,yield*t,yield*i,yield*s,yield*a,null!=this._title&&(yield this._title),null!=this._toolbar&&(yield this._toolbar);for(const e of this.model.toolbar.tools)null!=e.overlay&&(yield e.overlay),yield*e.synthetic_renderers}async build_renderer_views(){this.computed_renderers=[...this._compute_renderers()],await p.build_views(this.renderer_views,this.computed_renderers,{parent:this})}async build_tool_views(){const e=this.model.toolbar.tools;(await p.build_views(this.tool_views,e,{parent:this})).map((e=>this.canvas_view.ui_event_bus.register_tool(e)))}connect_signals(){super.connect_signals();const{x_ranges:e,y_ranges:t}=this.frame;for(const[,t]of e)this.connect(t.change,(()=>{this._needs_layout=!0,this.request_paint("everything")}));for(const[,e]of t)this.connect(e.change,(()=>{this._needs_layout=!0,this.request_paint("everything")}));const{above:i,below:s,left:a,right:n,center:o,renderers:l}=this.model.properties;this.on_change([i,s,a,n,o,l],(async()=>await this.build_renderer_views())),this.connect(this.model.toolbar.properties.tools.change,(async()=>{await this.build_renderer_views(),await this.build_tool_views()})),this.connect(this.model.change,(()=>this.request_paint("everything"))),this.connect(this.model.reset,(()=>this.reset()))}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,e]of this.renderer_views)if(!e.has_finished())return!1;return!0}after_layout(){var e;super.after_layout();for(const[,t]of this.renderer_views)t instanceof _.AnnotationView&&(null===(e=t.after_layout)||void 0===e||e.call(t));if(this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){const{width:e,height:t}=this.layout.bbox;this.canvas_view.resize(e,t),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}const{inner_bbox:t}=this.layout;this._inner_bbox.equals(t)||(this._inner_bbox=t,this._needs_paint=!0),this._needs_paint&&this.paint()}repaint(){this._needs_layout&&this._invalidate_layout(),this.paint()}paint(){var e;if(this.is_paused||!this.model.visible)return;b.logger.trace(`PlotView.paint() for ${this.model.id}`);const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout((()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(),this.request_paint("everything")}),this.model.lod_timeout):t.interactive_stop()}this._range_manager.invalidate_dataranges&&(this._range_manager.update_dataranges(),this._invalidate_layout());let i=!1,s=!1;if(this._invalidate_all)i=!0,s=!0;else for(const e of this._invalidated_painters){const{level:t}=e.model;if("overlay"!=t?i=!0:s=!0,i&&s)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const a=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],{primary:n,overlays:o}=this.canvas_view;i&&(n.prepare(),this.canvas_view.prepare_webgl(a),this._map_hook(n.ctx,a),this._paint_empty(n.ctx,a),this._paint_outline(n.ctx,a),this._paint_levels(n.ctx,"image",a,!0),this._paint_levels(n.ctx,"underlay",a,!0),this._paint_levels(n.ctx,"glyph",a,!0),this._paint_levels(n.ctx,"guide",a,!1),this._paint_levels(n.ctx,"annotation",a,!1),n.finish()),(s||P.settings.wireframe)&&(o.prepare(),this._paint_levels(o.ctx,"overlay",a,!1),P.settings.wireframe&&this._paint_layout(o.ctx,this.layout),o.finish()),null==this._initial_state.range&&(this._initial_state.range=null!==(e=this._range_manager.compute_initial())&&void 0!==e?e:void 0),this._needs_paint=!1}_paint_levels(e,t,i,s){for(const a of this.computed_renderers){if(a.level!=t)continue;const n=this.renderer_views.get(a);e.save(),(s||n.needs_clip)&&(e.beginPath(),e.rect(...i),e.clip()),n.render(),e.restore(),n.has_webgl&&n.needs_webgl_blit&&this.canvas_view.blit_webgl(e)}}_paint_layout(e,t){const{x:i,y:s,width:a,height:n}=t.bbox;e.strokeStyle="blue",e.strokeRect(i,s,a,n);for(const a of t)e.save(),t.absolute||e.translate(i,s),this._paint_layout(e,a),e.restore()}_map_hook(e,t){}_paint_empty(e,t){const[i,s,a,n]=[0,0,this.layout.bbox.width,this.layout.bbox.height],[o,l,r,_]=t;this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(e),e.fillRect(i,s,a,n),e.clearRect(o,l,r,_)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fillRect(o,l,r,_))}_paint_outline(e,t){if(this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);let[i,s,a,n]=t;i+a==this.layout.bbox.width&&(a-=1),s+n==this.layout.bbox.height&&(n-=1),e.strokeRect(i,s,a,n),e.restore()}}to_blob(){return this.canvas_view.to_blob()}export(e,t=!0){const i="png"==e?"canvas":"svg",s=new y.CanvasLayer(i,t),{width:a,height:n}=this.layout.bbox;s.resize(a,n);const{canvas:o}=this.canvas_view.compose();return s.ctx.drawImage(o,0,0),s}serializable_state(){const e=super.serializable_state(),{children:t}=e,i=n.__rest(e,["children"]),s=this.get_renderer_views().map((e=>e.serializable_state())).filter((e=>null!=e.bbox));return Object.assign(Object.assign({},i),{children:[...null!=t?t:[],...s]})}}i.PlotView=R,R.__name__="PlotView"},
function _(t,n,e,o,u){o(),e.throttle=function(t,n){let e=null,o=0,u=!1;return function(){return new Promise(((r,i)=>{const l=function(){o=Date.now(),e=null,u=!1;try{t(),r()}catch(t){i(t)}},a=Date.now(),c=n-(a-o);c<=0&&!u?(null!=e&&clearTimeout(e),u=!0,requestAnimationFrame(l)):e||u?r():e=setTimeout((()=>requestAnimationFrame(l)),c)}))}}},
function _(t,n,e,s,a){s();const o=t(159),r=t(19);class l{constructor(t){this.parent=t,this.invalidate_dataranges=!0}get frame(){return this.parent.frame}update(t,n){const{x_ranges:e,y_ranges:s}=this.frame;if(null==t){for(const[,t]of e)t.reset();for(const[,t]of s)t.reset();this.update_dataranges()}else{const a=[];for(const[n,s]of e)a.push([s,t.xrs.get(n)]);for(const[n,e]of s)a.push([e,t.yrs.get(n)]);(null==n?void 0:n.scrolling)&&this._update_ranges_together(a),this._update_ranges_individually(a,n)}}reset(){this.update(null)}update_dataranges(){const t=new Map,n=new Map;let e=!1;for(const[,t]of this.frame.x_ranges)t instanceof o.DataRange1d&&"log"==t.scale_hint&&(e=!0);for(const[,t]of this.frame.y_ranges)t instanceof o.DataRange1d&&"log"==t.scale_hint&&(e=!0);for(const s of this.parent.model.data_renderers){const a=this.parent.renderer_view(s);if(null==a)continue;const o=a.glyph_view.bounds();if(null!=o&&t.set(s,o),e){const t=a.glyph_view.log_bounds();null!=t&&n.set(s,t)}}let s=!1,a=!1;const{width:l,height:i}=this.frame.bbox;let d;!1!==this.parent.model.match_aspect&&0!=l&&0!=i&&(d=1/this.parent.model.aspect_scale*(l/i));for(const[,e]of this.frame.x_ranges){if(e instanceof o.DataRange1d){const a="log"==e.scale_hint?n:t;e.update(a,0,this.parent.model,d),e.follow&&(s=!0)}null!=e.bounds&&(a=!0)}for(const[,e]of this.frame.y_ranges){if(e instanceof o.DataRange1d){const a="log"==e.scale_hint?n:t;e.update(a,1,this.parent.model,d),e.follow&&(s=!0)}null!=e.bounds&&(a=!0)}if(s&&a){r.logger.warn("Follow enabled so bounds are unset.");for(const[,t]of this.frame.x_ranges)t.bounds=null;for(const[,t]of this.frame.y_ranges)t.bounds=null}this.invalidate_dataranges=!1}compute_initial(){let t=!0;const{x_ranges:n,y_ranges:e}=this.frame,s=new Map,a=new Map;for(const[e,a]of n){const{start:n,end:o}=a;if(null==n||null==o||isNaN(n+o)){t=!1;break}s.set(e,{start:n,end:o})}if(t)for(const[n,s]of e){const{start:e,end:o}=s;if(null==e||null==o||isNaN(e+o)){t=!1;break}a.set(n,{start:e,end:o})}return t?{xrs:s,yrs:a}:(r.logger.warn("could not set initial ranges"),null)}_update_ranges_together(t){let n=1;for(const[e,s]of t)n=Math.min(n,this._get_weight_to_constrain_interval(e,s));if(n<1)for(const[e,s]of t)s.start=n*s.start+(1-n)*e.start,s.end=n*s.end+(1-n)*e.end}_update_ranges_individually(t,n){const e=!!(null==n?void 0:n.panning),s=!!(null==n?void 0:n.scrolling);let a=!1;for(const[n,o]of t){if(!s){const t=this._get_weight_to_constrain_interval(n,o);t<1&&(o.start=t*o.start+(1-t)*n.start,o.end=t*o.end+(1-t)*n.end)}if(null!=n.bounds&&"auto"!=n.bounds){const[t,r]=n.bounds,l=Math.abs(o.end-o.start);n.is_reversed?(null!=t&&t>=o.end&&(a=!0,o.end=t,(e||s)&&(o.start=t+l)),null!=r&&r<=o.start&&(a=!0,o.start=r,(e||s)&&(o.end=r-l))):(null!=t&&t>=o.start&&(a=!0,o.start=t,(e||s)&&(o.end=t+l)),null!=r&&r<=o.end&&(a=!0,o.end=r,(e||s)&&(o.start=r-l)))}}if(!(s&&a&&(null==n?void 0:n.maintain_focus)))for(const[n,e]of t)n.have_updated_interactively=!0,n.start==e.start&&n.end==e.end||n.setv(e)}_get_weight_to_constrain_interval(t,n){const{min_interval:e}=t;let{max_interval:s}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[n,e]=t.bounds;if(null!=n&&null!=e){const t=Math.abs(e-n);s=null!=s?Math.min(s,t):t}}let a=1;if(null!=e||null!=s){const o=Math.abs(t.end-t.start),r=Math.abs(n.end-n.start);null!=e&&e>0&&r<e&&(a=(o-e)/(o-r)),null!=s&&s>0&&r>s&&(a=(s-o)/(r-o)),a=Math.max(0,Math.min(1,a))}return a}}e.RangeManager=l,l.__name__="RangeManager"},
function _(t,i,s,e,n){e();const h=t(15);class a{constructor(t,i){this.parent=t,this.initial_state=i,this.changed=new h.Signal0(this.parent,"state_changed"),this.history=[],this.index=-1}_do_state_change(t){const i=null!=this.history[t]?this.history[t].state:this.initial_state;null!=i.range&&this.parent.update_range(i.range),null!=i.selection&&this.parent.update_selection(i.selection)}push(t,i){const{history:s,index:e}=this,n=null!=s[e]?s[e].state:{},h=Object.assign(Object.assign(Object.assign({},this.initial_state),n),i);this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:h}),this.index=this.history.length-1,this.changed.emit()}clear(){this.history=[],this.index=-1,this.changed.emit()}undo(){this.can_undo&&(this.index-=1,this._do_state_change(this.index),this.changed.emit())}redo(){this.can_redo&&(this.index+=1,this._do_state_change(this.index),this.changed.emit())}get can_undo(){return this.index>=0}get can_redo(){return this.index<this.history.length-1}}s.StateManager=a,a.__name__="StateManager"},
function _(t,e,s,o,i){o();const a=t(19),n=t(15),p=t(43),l=t(65),_=t(22),h=t(333),m=new n.Signal0({},"gmaps_ready");class d extends h.PlotView{initialize(){this.pause(),super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;if(this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s,!this.model.api_key){const t="https://developers.google.com/maps/documentation/javascript/get-api-key";a.logger.error(`api_key is required. See ${t} for more information on how to obtain your own.`)}if("undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback){const{api_key:t,api_version:e}=this.model;!function(t,e){window._bokeh_gmaps_callback=()=>m.emit();const s=encodeURIComponent,o=document.createElement("script");o.type="text/javascript",o.src=`https://maps.googleapis.com/maps/api/js?v=${s(e)}&key=${s(t)}&callback=_bokeh_gmaps_callback`,document.body.appendChild(o)}(t,e)}m.connect((()=>this.request_paint("everything")))}this.unpause()}remove(){p.remove(this.map_el),super.remove()}update_range(t,e){var s,o;if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null,e);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(null!==(s=t.sdx)&&void 0!==s?s:0,null!==(o=t.sdy)&&void 0!==o?o:0),super.update_range(t,e);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t,e);const s=t.factor<0?-1:1,o=this.map.getZoom(),i=o+s;if(i>=2){this.map.setZoom(i);const[t,e,,]=this._get_projected_bounds();e-t<0&&this.map.setZoom(o)}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map_el=p.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",(()=>this._set_bokeh_ranges())),t.event.addListener(this.map,"bounds_changed",(()=>this._set_bokeh_ranges())),t.event.addListenerOnce(this.map,"tilesloaded",(()=>this._render_finished())),this.connect(this.model.properties.map_options.change,(()=>this._update_options())),this.connect(this.model.map_options.properties.styles.change,(()=>this._update_styles())),this.connect(this.model.map_options.properties.lat.change,(()=>this._update_center("lat"))),this.connect(this.model.map_options.properties.lng.change,(()=>this._update_center("lng"))),this.connect(this.model.map_options.properties.zoom.change,(()=>this._update_zoom())),this.connect(this.model.map_options.properties.map_type.change,(()=>this._update_map_type())),this.connect(this.model.map_options.properties.scale_control.change,(()=>this._update_scale_control())),this.connect(this.model.map_options.properties.tilt.change,(()=>this._update_tilt()))}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,o]=this._get_latlon_bounds(),[i,a]=l.wgs84_mercator.compute(t,s),[n,p]=l.wgs84_mercator.compute(e,o);return[i,n,a,p]}_set_bokeh_ranges(){const[t,e,s,o]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:o})}_update_center(t){const e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_map_hook(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){const[t,s,o,i]=e;this.map_el.style.top=`${s}px`,this.map_el.style.left=`${t}px`,this.map_el.style.width=`${o}px`,this.map_el.style.height=`${i}px`}}_paint_empty(t,e){const s=this.layout.bbox.width,o=this.layout.bbox.height,[i,a,n,p]=e;t.clearRect(0,0,s,o),t.beginPath(),t.moveTo(0,0),t.lineTo(0,o),t.lineTo(s,o),t.lineTo(s,0),t.lineTo(0,0),t.moveTo(i,a),t.lineTo(i+n,a),t.lineTo(i+n,a+p),t.lineTo(i,a+p),t.lineTo(i,a),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=_.color2css(this.model.border_fill_color),t.fill())}}s.GMapPlotView=d,d.__name__="GMapPlotView"},
function _(t,_,n,o,r){o();t(1).__exportStar(t(169),n)},
function _(e,r,d,n,R){n(),R("GlyphRenderer",e(61).GlyphRenderer),R("GraphRenderer",e(123).GraphRenderer),R("GuideRenderer",e(164).GuideRenderer),R("Renderer",e(41).Renderer)},
function _(e,t,n,o,c){o();e(1).__exportStar(e(129),n),c("Selection",e(59).Selection)},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(342).ServerSentDataSource),r("AjaxDataSource",a(344).AjaxDataSource),r("ColumnDataSource",a(130).ColumnDataSource),r("ColumnarDataSource",a(57).ColumnarDataSource),r("CDSView",a(120).CDSView),r("DataSource",a(58).DataSource),r("GeoJSONDataSource",a(345).GeoJSONDataSource),r("WebDataSource",a(343).WebDataSource)},
function _(e,t,i,a,s){a();const n=e(343);class r extends n.WebDataSource{constructor(e){super(e),this.initialized=!1}setup(){if(!this.initialized){this.initialized=!0;new EventSource(this.data_url).onmessage=e=>{var t;this.load_data(JSON.parse(e.data),this.mode,null!==(t=this.max_size)&&void 0!==t?t:void 0)}}}}i.ServerSentDataSource=r,r.__name__="ServerSentDataSource"},
function _(t,e,a,n,s){n();const r=t(130),i=t(20);class l extends r.ColumnDataSource{constructor(t){super(t)}get_column(t){const e=this.data[t];return null!=e?e:[]}get_length(){var t;return null!==(t=super.get_length())&&void 0!==t?t:0}initialize(){super.initialize(),this.setup()}load_data(t,e,a){const{adapter:n}=this;let s;switch(s=null!=n?n.execute(this,{response:t}):t,e){case"replace":this.data=s;break;case"append":{const t=this.data;for(const e of this.columns()){const n=Array.from(t[e]),r=Array.from(s[e]),i=n.concat(r);s[e]=null!=a?i.slice(-a):i}this.data=s;break}}}static init_WebDataSource(){this.define((({Any:t,Int:e,String:a,Nullable:n})=>({max_size:[n(e),null],mode:[i.UpdateMode,"replace"],adapter:[n(t),null],data_url:[a]})))}}a.WebDataSource=l,l.__name__="WebDataSource",l.init_WebDataSource()},
function _(t,e,i,s,a){s();const n=t(343),r=t(20),o=t(19),l=t(13);class d extends n.WebDataSource{constructor(t){super(t),this.interval=null,this.initialized=!1}static init_AjaxDataSource(){this.define((({Boolean:t,Int:e,String:i,Dict:s,Nullable:a})=>({polling_interval:[a(e),null],content_type:[i,"application/json"],http_headers:[s(i),{}],method:[r.HTTPMethod,"POST"],if_modified:[t,!1]})))}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=null,i=!1){const s=this.prepare_request();s.addEventListener("load",(()=>this.do_load(s,t,null!=e?e:void 0))),s.addEventListener("error",(()=>this.do_error(s))),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const[i,s]of l.entries(e))t.setRequestHeader(i,s);return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){o.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=d,d.__name__="AjaxDataSource",d.init_AjaxDataSource()},
function _(e,t,o,r,n){r();const s=e(57),a=e(19),i=e(9),l=e(13);function c(e){return null!=e?e:NaN}const{hasOwnProperty:_}=Object.prototype;class g extends s.ColumnarDataSource{constructor(e){super(e)}static init_GeoJSONDataSource(){this.define((({String:e})=>({geojson:[e]}))),this.internal((({Dict:e,Arrayable:t})=>({data:[e(t),{}]})))}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,(()=>this._update_data()))}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return i.range(0,e).map((e=>[]))}_get_new_nan_array(e){return i.range(0,e).map((e=>NaN))}_add_properties(e,t,o,r){var n;const s=null!==(n=e.properties)&&void 0!==n?n:{};for(const[e,n]of l.entries(s))_.call(t,e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=c(n)}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=c(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"Polygon":{e.coordinates.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"MultiPoint":a.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const s=n.reduce(r);for(let e=0;e<s.length;e++){const[r,n,a]=s[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=c(a)}break}default:throw new Error(`Invalid GeoJSON geometry type: ${e.type}`)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=g,g.__name__="GeoJSONDataSource",g.init_GeoJSONDataSource()},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(347).BBoxTileSource),S("MercatorTileSource",e(348).MercatorTileSource),S("QUADKEYTileSource",e(351).QUADKEYTileSource),S("TileRenderer",e(352).TileRenderer),S("TileSource",e(349).TileSource),S("TMSTileSource",e(355).TMSTileSource),S("WMTSTileSource",e(353).WMTSTileSource)},
function _(e,t,r,i,o){i();const l=e(348);class n extends l.MercatorTileSource{constructor(e){super(e)}static init_BBoxTileSource(){this.define((({Boolean:e})=>({use_latlon:[e,!1]})))}get_image_url(e,t,r){const i=this.string_lookup_replace(this.url,this.extra_url_vars);let o,l,n,s;return this.use_latlon?[l,s,o,n]=this.get_tile_geographic_bounds(e,t,r):[l,s,o,n]=this.get_tile_meter_bounds(e,t,r),i.replace("{XMIN}",l.toString()).replace("{YMIN}",s.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",n.toString())}}r.BBoxTileSource=n,n.__name__="BBoxTileSource",n.init_BBoxTileSource()},
function _(t,e,i,_,s){_();const r=t(349),o=t(9),n=t(350);class l extends r.TileSource{constructor(t){super(t)}static init_MercatorTileSource(){this.define((({Boolean:t})=>({snap_to_zoom:[t,!1],wrap_around:[t,!0]}))),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})}initialize(){super.initialize(),this._resolutions=o.range(this.min_zoom,this.max_zoom+1).map((t=>this.get_resolution(t)))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;return[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,l]=n.meters_extent_to_geographic(_);return[s,r,o,l]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError(`Invalid Quadkey: ${t}`)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=l,l.__name__="MercatorTileSource",l.init_MercatorTileSource()},
function _(e,t,r,i,n){i();const l=e(53),s=e(13);class a extends l.Model{constructor(e){super(e)}static init_TileSource(){this.define((({Number:e,String:t,Dict:r,Nullable:i})=>({url:[t,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[r(t),{}],attribution:[t,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[i(e),null]})))}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._clear_cache()))}string_lookup_replace(e,t){let r=e;for(const[e,i]of s.entries(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map((e=>parseInt(e)));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,l]=t,s=(n-r)/2+r,a=(l-i)/2+i;e.sort((function(e,t){return Math.sqrt((s-e[0])**2+(a-e[1])**2)-Math.sqrt((s-t[0])**2+(a-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=a,a.__name__="TileSource",a.init_TileSource()},
function _(t,e,r,n,o){n();const c=t(65);function _(t,e){return c.wgs84_mercator.compute(t,e)}function g(t,e){return c.wgs84_mercator.invert(t,e)}r.geographic_to_meters=_,r.meters_to_geographic=g,r.geographic_extent_to_meters=function(t){const[e,r,n,o]=t,[c,g]=_(e,r),[i,u]=_(n,o);return[c,g,i,u]},r.meters_extent_to_geographic=function(t){const[e,r,n,o]=t,[c,_]=g(e,r),[i,u]=g(n,o);return[c,_,i,u]}},
function _(e,t,r,s,_){s();const o=e(348);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const s=this.string_lookup_replace(this.url,this.extra_url_vars),[_,o,c]=this.tms_to_wmts(e,t,r),i=this.tile_xyz_to_quadkey(_,o,c);return s.replace("{Q}",i)}}r.QUADKEYTileSource=c,c.__name__="QUADKEYTileSource"},
function _(t,e,i,s,_){s();const n=t(1),a=t(349),h=t(353),r=t(41),o=t(156),l=t(43),d=t(296),m=t(9),c=t(8),g=n.__importStar(t(354));class p extends r.RendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.tile_source.change,(()=>this.request_render()))}styles(){return[...super.styles(),g.default]}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&l.removeElement(this.attribution_el);const{attribution:t}=this.model.tile_source;if(c.isString(t)&&t.length>0){const{layout:e,frame:i}=this.plot_view,s=e.bbox.width-i.bbox.right,_=e.bbox.height-i.bbox.bottom,n=i.bbox.width;this.attribution_el=l.div({class:g.tile_attribution,style:{position:"absolute",right:`${s}px`,bottom:`${_}px`,"max-width":n-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=t,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}}_map_data(){this.initial_extent=this.get_extent();const t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof o.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof o.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()}_create_tile(t,e,i,s,_=!1){const[n,a,h]=this.model.tile_source.normalize_xyz(t,e,i),r={img:void 0,tile_coords:[t,e,i],normalized_coords:[n,a,h],quadkey:this.model.tile_source.tile_xyz_to_quadkey(t,e,i),cache_key:this.model.tile_source.tile_xyz_to_key(t,e,i),bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]},o=this.model.tile_source.get_image_url(n,a,h);new d.ImageLoader(o,{loaded:t=>{Object.assign(r,{img:t,loaded:!0}),_?(r.finished=!0,this.notify_finished()):this.request_render()},failed(){r.finished=!0}}),this.model.tile_source.tiles.set(r.cache_key,r),this._tiles.push(r)}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){const t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}}has_finished(){if(!super.has_finished())return!1;if(0===this._tiles.length)return!1;for(const t of this._tiles)if(!t.finished)return!1;return!0}_render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(t){const e=this.model.tile_source.tiles.get(t);if(null!=e&&e.loaded){const[[t],[i]]=this.coordinates.map_to_screen([e.bounds[0]],[e.bounds[3]]),[[s],[_]]=this.coordinates.map_to_screen([e.bounds[2]],[e.bounds[1]]),n=s-t,a=_-i,h=t,r=i,o=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,h,r,n,a),this.map_canvas.setImageSmoothingEnabled(o),e.finished=!0}}_set_rect(){const t=this.plot_model.outline_line_width,e=this.map_frame.bbox.left+t/2,i=this.map_frame.bbox.top+t/2,s=this.map_frame.bbox.width-t,_=this.map_frame.bbox.height-t;this.map_canvas.rect(e,i,s,_),this.map_canvas.clip()}_render_tiles(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const e of t)this._draw_tile(e);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:t}=this.model,e=this.get_extent(),i=this.map_frame.bbox.height,s=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(e,i,s),n=this.model.tile_source.get_tiles_by_extent(e,_);for(let e=0,i=Math.min(10,n.length);e<i;e++){const[i,s,_]=n[e],a=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const e of a){const[i,s,_,n]=e;t.tiles.has(t.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,n,!0)}}}_fetch_tiles(t){for(const e of t){const[t,i,s,_]=e;this._create_tile(t,i,s,_)}}_update(){const{tile_source:t}=this.model,{min_zoom:e}=t,{max_zoom:i}=t;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],n=this.map_frame.bbox.height,a=this.map_frame.bbox.width;let h=t.get_level_by_extent(s,n,a),r=!1;h<e?(s=this.extent,h=e,r=!0):h>i&&(s=this.extent,h=i,r=!0),r&&(this.x_range.setv({x_range:{start:s[0],end:s[2]}}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const o=t.get_tiles_by_extent(s,h),l=[],d=[],c=[],g=[];for(const e of o){const[i,s,n]=e,a=t.tile_xyz_to_key(i,s,n),h=t.tiles.get(a);if(null!=h&&h.loaded)d.push(a);else if(this.model.render_parents){const[e,a,h]=t.get_closest_parent_by_tile_xyz(i,s,n),r=t.tile_xyz_to_key(e,a,h),o=t.tiles.get(r);if(null!=o&&o.loaded&&!m.includes(c,r)&&c.push(r),_){const e=t.children_by_tile_xyz(i,s,n);for(const[i,s,_]of e){const e=t.tile_xyz_to_key(i,s,_);t.tiles.has(e)&&g.push(e)}}}null==h&&l.push(e)}this._render_tiles(c),this._render_tiles(g),this._render_tiles(d),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((()=>this._fetch_tiles(l)),65)}}i.TileRendererView=p,p.__name__="TileRendererView";class u extends r.Renderer{constructor(t){super(t)}static init_TileRenderer(){this.prototype.default_view=p,this.define((({Boolean:t,Number:e,Ref:i})=>({alpha:[e,1],smoothing:[t,!0],tile_source:[i(a.TileSource),()=>new h.WMTSTileSource],render_parents:[t,!0]}))),this.override({level:"image"})}}i.TileRenderer=u,u.__name__="TileRenderer",u.init_TileRenderer()},
function _(t,e,r,o,s){o();const c=t(348);class i extends c.MercatorTileSource{constructor(t){super(t)}get_image_url(t,e,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,i]=this.tms_to_wmts(t,e,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",i.toString())}}r.WMTSTileSource=i,i.__name__="WMTSTileSource"},
function _(t,o,i,b,r){b(),i.root="bk-root",i.tile_attribution="bk-tile-attribution",i.default=".bk-root .bk-tile-attribution a{color:black;}"},
function _(e,r,t,c,o){c();const i=e(348);class l extends i.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=l,l.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(357).CanvasTexture),r("ImageURLTexture",e(359).ImageURLTexture),r("Texture",e(358).Texture)},
function _(t,e,n,c,s){c();const a=t(358),i=t(34);class r extends a.Texture{constructor(t){super(t)}static init_CanvasTexture(){this.define((({String:t})=>({code:[t]})))}get func(){const t=i.use_strict(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){const c=document.createElement("canvas");c.width=e,c.height=e;const s=c.getContext("2d");return this.func.call(this,s,t,e,n),c}}n.CanvasTexture=r,r.__name__="CanvasTexture",r.init_CanvasTexture()},
function _(e,t,i,n,r){n();const s=e(53),u=e(20);class o extends s.Model{constructor(e){super(e)}static init_Texture(){this.define((()=>({repetition:[u.TextureRepetition,"repeat"]})))}}i.Texture=o,o.__name__="Texture",o.init_Texture()},
function _(e,t,i,r,n){r();const a=e(358),s=e(296);class u extends a.Texture{constructor(e){super(e)}static init_ImageURLTexture(){this.define((({String:e})=>({url:[e]})))}initialize(){super.initialize(),this._loader=new s.ImageLoader(this.url)}get_pattern(e,t,i){const{_loader:r}=this;return this._loader.finished?r.image:r.promise}}i.ImageURLTexture=u,u.__name__="ImageURLTexture",u.init_ImageURLTexture()},
function _(o,l,T,e,t){e(),t("ActionTool",o(251).ActionTool),t("CustomAction",o(361).CustomAction),t("HelpTool",o(252).HelpTool),t("RedoTool",o(362).RedoTool),t("ResetTool",o(363).ResetTool),t("SaveTool",o(364).SaveTool),t("UndoTool",o(365).UndoTool),t("ZoomInTool",o(366).ZoomInTool),t("ZoomOutTool",o(369).ZoomOutTool),t("ButtonTool",o(238).ButtonTool),t("EditTool",o(370).EditTool),t("BoxEditTool",o(371).BoxEditTool),t("FreehandDrawTool",o(372).FreehandDrawTool),t("PointDrawTool",o(373).PointDrawTool),t("PolyDrawTool",o(374).PolyDrawTool),t("PolyTool",o(375).PolyTool),t("PolyEditTool",o(376).PolyEditTool),t("BoxSelectTool",o(377).BoxSelectTool),t("BoxZoomTool",o(379).BoxZoomTool),t("GestureTool",o(237).GestureTool),t("LassoSelectTool",o(380).LassoSelectTool),t("LineEditTool",o(382).LineEditTool),t("PanTool",o(384).PanTool),t("PolySelectTool",o(381).PolySelectTool),t("RangeTool",o(385).RangeTool),t("SelectTool",o(378).SelectTool),t("TapTool",o(386).TapTool),t("WheelPanTool",o(387).WheelPanTool),t("WheelZoomTool",o(388).WheelZoomTool),t("CrosshairTool",o(389).CrosshairTool),t("CustomJSHover",o(390).CustomJSHover),t("HoverTool",o(391).HoverTool),t("InspectTool",o(247).InspectTool),t("Tool",o(236).Tool),t("ToolProxy",o(392).ToolProxy),t("Toolbar",o(235).Toolbar),t("ToolbarBase",o(248).ToolbarBase),t("ProxyToolbar",o(393).ProxyToolbar),t("ToolbarBox",o(393).ToolbarBox)},
function _(t,o,i,s,n){s();const e=t(251);class c extends e.ActionToolButtonView{css_classes(){return super.css_classes().concat("bk-toolbar-button-custom-action")}}i.CustomActionButtonView=c,c.__name__="CustomActionButtonView";class u extends e.ActionToolView{doit(){var t;null===(t=this.model.callback)||void 0===t||t.execute(this.model)}}i.CustomActionView=u,u.__name__="CustomActionView";class l extends e.ActionTool{constructor(t){super(t),this.tool_name="Custom Action",this.button_view=c}static init_CustomAction(){this.prototype.default_view=u,this.define((({Any:t,String:o,Nullable:i})=>({callback:[i(t)],icon:[o]}))),this.override({description:"Perform a Custom Action"})}}i.CustomAction=l,l.__name__="CustomAction",l.init_CustomAction()},
function _(o,e,t,i,s){i();const n=o(251),d=o(242);class l extends n.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_redo))}doit(){this.plot_view.state.redo()}}t.RedoToolView=l,l.__name__="RedoToolView";class _ extends n.ActionTool{constructor(o){super(o),this.tool_name="Redo",this.icon=d.tool_icon_redo}static init_RedoTool(){this.prototype.default_view=l,this.override({disabled:!0}),this.register_alias("redo",(()=>new _))}}t.RedoTool=_,_.__name__="RedoTool",_.init_RedoTool()},
function _(e,t,o,s,i){s();const _=e(251),n=e(242);class l extends _.ActionToolView{doit(){this.plot_view.reset()}}o.ResetToolView=l,l.__name__="ResetToolView";class c extends _.ActionTool{constructor(e){super(e),this.tool_name="Reset",this.icon=n.tool_icon_reset}static init_ResetTool(){this.prototype.default_view=l,this.register_alias("reset",(()=>new c))}}o.ResetTool=c,c.__name__="ResetTool",c.init_ResetTool()},
function _(o,e,t,a,i){a();const n=o(251),s=o(242);class c extends n.ActionToolView{async copy(){const o=await this.plot_view.to_blob(),e=new ClipboardItem({[o.type]:o});await navigator.clipboard.write([e])}async save(o){const e=await this.plot_view.to_blob(),t=document.createElement("a");t.href=URL.createObjectURL(e),t.download=o,t.target="_blank",t.dispatchEvent(new MouseEvent("click"))}doit(o="save"){switch(o){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}}}t.SaveToolView=c,c.__name__="SaveToolView";class l extends n.ActionTool{constructor(o){super(o),this.tool_name="Save",this.icon=s.tool_icon_save}static init_SaveTool(){this.prototype.default_view=c,this.register_alias("save",(()=>new l))}get menu(){return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:()=>"undefined"!=typeof ClipboardItem,handler:()=>{this.do.emit("copy")}}]}}t.SaveTool=l,l.__name__="SaveTool",l.init_SaveTool()},
function _(o,t,n,i,e){i();const s=o(251),d=o(242);class l extends s.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_undo))}doit(){this.plot_view.state.undo()}}n.UndoToolView=l,l.__name__="UndoToolView";class _ extends s.ActionTool{constructor(o){super(o),this.tool_name="Undo",this.icon=d.tool_icon_undo}static init_UndoTool(){this.prototype.default_view=l,this.override({disabled:!0}),this.register_alias("undo",(()=>new _))}}n.UndoTool=_,_.__name__="UndoTool",_.init_UndoTool()},
function _(o,i,n,s,e){s();const t=o(367),_=o(242);class m extends t.ZoomBaseToolView{}n.ZoomInToolView=m,m.__name__="ZoomInToolView";class l extends t.ZoomBaseTool{constructor(o){super(o),this.sign=1,this.tool_name="Zoom In",this.icon=_.tool_icon_zoom_in}static init_ZoomInTool(){this.prototype.default_view=m,this.register_alias("zoom_in",(()=>new l({dimensions:"both"}))),this.register_alias("xzoom_in",(()=>new l({dimensions:"width"}))),this.register_alias("yzoom_in",(()=>new l({dimensions:"height"})))}}n.ZoomInTool=l,l.__name__="ZoomInTool",l.init_ZoomInTool()},
function _(o,t,e,i,s){i();const n=o(251),l=o(20),a=o(368);class _ extends n.ActionToolView{doit(){var o;const t=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,s="height"==e||"both"==e,n=a.scale_range(t,this.model.sign*this.model.factor,i,s);this.plot_view.state.push("zoom_out",{range:n}),this.plot_view.update_range(n,{scrolling:!0}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model)}}e.ZoomBaseToolView=_,_.__name__="ZoomBaseToolView";class m extends n.ActionTool{constructor(o){super(o)}static init_ZoomBaseTool(){this.define((({Percent:o})=>({factor:[o,.1],dimensions:[l.Dimensions,"both"]})))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}e.ZoomBaseTool=m,m.__name__="ZoomBaseTool",m.init_ZoomBaseTool()},
function _(n,t,o,r,s){r();const c=n(10);function e(n,t,o){const[r,s]=[n.start,n.end],c=null!=o?o:(s+r)/2;return[r-(r-c)*t,s-(s-c)*t]}function a(n,[t,o]){const r=new Map;for(const[s,c]of n){const[n,e]=c.r_invert(t,o);r.set(s,{start:n,end:e})}return r}o.scale_highlow=e,o.get_info=a,o.scale_range=function(n,t,o=!0,r=!0,s){t=c.clamp(t,-.9,.9);const l=o?t:0,[u,i]=e(n.bbox.h_range,l,null!=s?s.x:void 0),_=a(n.x_scales,[u,i]),f=r?t:0,[g,x]=e(n.bbox.v_range,f,null!=s?s.y:void 0);return{xrs:_,yrs:a(n.y_scales,[g,x]),factor:t}}},
function _(o,t,i,s,e){s();const n=o(367),_=o(242);class m extends n.ZoomBaseToolView{}i.ZoomOutToolView=m,m.__name__="ZoomOutToolView";class l extends n.ZoomBaseTool{constructor(o){super(o),this.sign=-1,this.tool_name="Zoom Out",this.icon=_.tool_icon_zoom_out}static init_ZoomOutTool(){this.prototype.default_view=m,this.register_alias("zoom_out",(()=>new l({dimensions:"both"}))),this.register_alias("xzoom_out",(()=>new l({dimensions:"width"}))),this.register_alias("yzoom_out",(()=>new l({dimensions:"height"})))}}i.ZoomOutTool=l,l.__name__="ZoomOutTool",l.init_ZoomOutTool()},
function _(e,t,s,o,n){o();const i=e(9),r=e(8),c=e(11),_=e(61),a=e(237);class l extends a.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void c.unreachable():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,s){if(!this.plot_view.frame.bbox.contains(e,t))return null;const o=this.plot_view.renderer_view(s);if(null==o)return null;return[o.coordinates.x_scale.invert(e),o.coordinates.y_scale.invert(t)]}_delete_selected(e){const t=e.data_source,s=t.selected.indices;s.sort();for(const e of t.columns()){const o=t.get_array(e);for(let e=0;e<s.length;e++){const t=s[e];o.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const s=e.columns();if(t&&s.length)for(const o of s){let s=e.get_array(o);const n=s.length-t+1;n<1||(r.isArray(s)||(s=Array.from(s),e.data[o]=s),s.splice(0,n))}}_emit_cds_changes(e,t=!0,s=!0,o=!0){s&&e.selection_manager.clear(),t&&e.change.emit(),o&&(e.data=e.data,e.properties.data.change.emit())}_drag_points(e,t,s="both"){if(null==this._basepoint)return;const[o,n]=this._basepoint;for(const i of t){const t=this._map_drag(o,n,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==t)continue;const[c,_]=r,[a,l]=t,[d,u]=[c-a,_-l],h=i.glyph,m=i.data_source,[p,f]=[h.x.field,h.y.field];for(const e of m.selected.indices)!p||"width"!=s&&"both"!=s||(m.data[p][e]+=d),!f||"height"!=s&&"both"!=s||(m.data[f][e]+=u);m.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){for(const s of e.columns())i.includes(t,s)||e.get_array(s).push(this.model.empty_value)}_select_event(e,t,s){const o=this.plot_view.frame,{sx:n,sy:i}=e;if(!o.bbox.contains(n,i))return[];const r={type:"point",sx:n,sy:i},c=[];for(const e of s){const s=e.get_selection_manager(),o=e.data_source,n=this.plot_view.renderer_view(e);if(null!=n){s.select([n],r,!0,t)&&c.push(e),o.properties.selected.change.emit()}}return c}}s.EditToolView=l,l.__name__="EditToolView";class d extends a.GestureTool{constructor(e){super(e)}static init_EditTool(){this.define((({Unknown:e,String:t,Array:s,Ref:o})=>({custom_icon:[t],empty_value:[e],renderers:[s(o(_.GlyphRenderer)),[]]})))}get computed_icon(){var e;return null!==(e=this.custom_icon)&&void 0!==e?e:this.icon}}s.EditTool=d,d.__name__="EditTool",d.init_EditTool()},
function _(e,t,s,i,_){i();const o=e(43),n=e(20),a=e(370),d=e(242);class l extends a.EditToolView{_tap(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===o.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==o.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.renderer_view(n);if(null==a)return;const d=n.glyph,l=n.data_source,[r,h]=a.coordinates.x_scale.r_invert(e,t),[p,u]=a.coordinates.y_scale.r_invert(s,i),[c,m]=[(r+h)/2,(p+u)/2],[f,b]=[h-r,u-p],[x,y]=[d.x.field,d.y.field],[w,v]=[d.width.field,d.height.field];if(_)this._pop_glyphs(l,this.model.num_objects),x&&l.get_array(x).push(c),y&&l.get_array(y).push(m),w&&l.get_array(w).push(f),v&&l.get_array(v).push(b),this._pad_empty_columns(l,[x,y,w,v]);else{const e=l.data[x].length-1;x&&(l.data[x][e]=c),y&&(l.data[y][e]=m),w&&(l.data[w][e]=f),v&&(l.data[v][e]=b)}this._emit_cds_changes(l,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,i,_,o);if(null!=n){const[e,i]=n;this._set_extent(e,i,t,s)}}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=l,l.__name__="BoxEditToolView";class r extends a.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.icon=d.tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}static init_BoxEditTool(){this.prototype.default_view=l,this.define((({Int:e})=>({dimensions:[n.Dimensions,"both"],num_objects:[e,0]})))}}s.BoxEditTool=r,r.__name__="BoxEditTool",r.init_BoxEditTool()},
function _(e,t,a,s,r){s();const o=e(43),_=e(8),i=e(370),d=e(242);class n extends i.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[o,i]=r,d=s.data_source,n=s.glyph,[h,l]=[n.xs.field,n.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),h&&d.get_array(h).push([o]),l&&d.get_array(l).push([i]),this._pad_empty_columns(d,[h,l]);else if("add"==t){if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];_.isArray(t)||(t=Array.from(t),d.data[h][e]=t),t.push(o)}if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];_.isArray(t)||(t=Array.from(t),d.data[l][e]=t),t.push(i)}}this._emit_cds_changes(d,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===o.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=n,n.__name__="FreehandDrawToolView";class h extends i.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.icon=d.tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}static init_FreehandDrawTool(){this.prototype.default_view=n,this.define((({Int:e})=>({num_objects:[e,0]})))}}a.FreehandDrawTool=h,h.__name__="FreehandDrawTool",h.init_FreehandDrawTool()},
function _(e,t,s,o,i){o();const a=e(43),n=e(370),_=e(242);class r extends n.EditToolView{_tap(e){if(this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,t);if(null==s)return;const o=t.glyph,i=t.data_source,[a,n]=[o.x.field,o.y.field],[_,r]=s;this._pop_glyphs(i,this.model.num_objects),a&&i.get_array(a).push(_),n&&i.get_array(n).push(r),this._pad_empty_columns(i,[a,n]),i.change.emit(),i.data=i.data,i.properties.data.change.emit()}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===a.Keys.Backspace?this._delete_selected(t):e.keyCode==a.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}s.PointDrawToolView=r,r.__name__="PointDrawToolView";class d extends n.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.icon=_.tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}static init_PointDrawTool(){this.prototype.default_view=r,this.define((({Boolean:e,Int:t})=>({add:[e,!0],drag:[e,!0],num_objects:[t,0]})))}}s.PointDrawTool=d,d.__name__="PointDrawTool",d.init_PointDrawTool()},
function _(e,t,s,i,a){i();const o=e(43),r=e(8),n=e(375),_=e(242);class d extends n.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],a=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==a)return;const[o,n]=this._snap_to_vertex(e,...a),_=i.data_source,d=i.glyph,[l,h]=[d.xs.field,d.ys.field];if("new"==t)this._pop_glyphs(_,this.model.num_objects),l&&_.get_array(l).push([o,o]),h&&_.get_array(h).push([n,n]),this._pad_empty_columns(_,[l,h]);else if("edit"==t){if(l){const e=_.data[l][_.data[l].length-1];e[e.length-1]=o}if(h){const e=_.data[h][_.data[h].length-1];e[e.length-1]=n}}else if("add"==t){if(l){const e=_.data[l].length-1;let t=_.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=o,r.isArray(t)||(t=Array.from(t),_.data[l][e]=t),t.push(s)}if(h){const e=_.data[h].length-1;let t=_.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=n,r.isArray(t)||(t=Array.from(t),_.data[h][e]=t),t.push(s)}}this._emit_cds_changes(_,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],a=i.data_source,o=i.glyph,[r,n]=[o.xs.field,o.ys.field];if(r)for(const t of a.get_array(r))e.push(...t);if(n)for(const e of a.get_array(n))t.push(...e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,a]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(a){const e=t.data[a].length-1,s=t.get_array(a)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Backspace?this._delete_selected(t):e.keyCode==o.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const a=this._map_drag(t,s,i),o=this._map_drag(e.sx,e.sy,i);if(null==o||null==a)continue;const r=i.data_source,n=i.glyph,[_,d]=[n.xs.field,n.ys.field];if(!_&&!d)continue;const[l,h]=o,[c,g]=a,[f,p]=[l-c,h-g];for(const e of r.selected.indices){let t,s,i;_&&(s=r.data[_][e]),d?(i=r.data[d][e],t=i.length):t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=f),i&&(i[e]+=p)}r.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,(()=>this._show_vertices()))}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=d,d.__name__="PolyDrawToolView";class l extends n.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.icon=_.tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}static init_PolyDrawTool(){this.prototype.default_view=d,this.define((({Boolean:e,Int:t})=>({drag:[e,!0],num_objects:[t,0]})))}}s.PolyDrawTool=l,l.__name__="PolyDrawTool",l.init_PolyDrawTool()},
function _(e,t,r,o,s){o();const i=e(8),l=e(370);class _ extends l.EditToolView{_set_vertices(e,t){const r=this.model.vertex_renderer.glyph,o=this.model.vertex_renderer.data_source,[s,l]=[r.x.field,r.y.field];s&&(i.isArray(e)?o.data[s]=e:r.x={value:e}),l&&(i.isArray(t)?o.data[l]=t:r.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(this.model.vertex_renderer){const o=this._select_event(e,"replace",[this.model.vertex_renderer]),s=this.model.vertex_renderer.data_source,i=this.model.vertex_renderer.glyph,[l,_]=[i.x.field,i.y.field];if(o.length){const e=s.selected.indices[0];l&&(t=s.data[l][e]),_&&(r=s.data[_][e]),s.selection_manager.clear()}}return[t,r]}}r.PolyToolView=_,_.__name__="PolyToolView";class d extends l.EditTool{constructor(e){super(e)}static init_PolyTool(){this.define((({AnyRef:e})=>({vertex_renderer:[e()]})))}}r.PolyTool=d,d.__name__="PolyTool",d.init_PolyTool()},
function _(e,t,s,r,i){r();const _=e(43),d=e(8),n=e(375),l=e(242);class a extends n.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._cur_index=null}_doubletap(e){if(!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[s,r]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,s),l&&_.get_array(l).splice(e+1,0,r),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;const t=this.model.renderers[0],s=()=>this._update_vertices(t),r=null==t?void 0:t.data_source,i=this._select_event(e,"replace",this.model.renderers);if(!i.length)return this._set_vertices([],[]),this._selected_renderer=null,this._drawing=!1,this._cur_index=null,void(null!=r&&r.disconnect(r.properties.data.change,s));null!=r&&r.connect(r.properties.data.change,s),this._cur_index=i[0].data_source.selected.indices[0],this._update_vertices(i[0])}_update_vertices(e){const t=e.glyph,s=e.data_source,r=this._cur_index,[i,_]=[t.xs.field,t.ys.field];if(this._drawing)return;if(null==r&&(i||_))return;let n,l;i&&null!=r?(n=s.data[i][r],d.isArray(n)||(s.data[i][r]=n=Array.from(n))):n=t.xs.value,_&&null!=r?(l=s.data[_][r],d.isArray(l)||(s.data[_][r]=l=Array.from(l))):l=t.ys.value,this._selected_renderer=e,this._set_vertices(n,l)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer,s=t.data_source,r=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=s.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),s.selected.indices=n;const[l,a]=[r.x.field,r.y.field],c=n[0];l&&(s.data[l][c]=_),a&&(s.data[a][c]=d),s.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null==s)return;if(this._drawing&&this._selected_renderer){let[r,i]=s;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],a=_.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=a[0];if(_.selected.indices=[c+1],n){const e=_.get_array(n),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=_.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer,t=e.data_source,s=e.glyph,r=t.selected.indices[0],[i,_]=[s.x.field,s.y.field];i&&t.get_array(i).splice(r,1),_&&t.get_array(_).splice(r,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;t=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(const s of t)e.keyCode===_.Keys.Backspace?(this._delete_selected(s),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==_.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),s.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}s.PolyEditToolView=a,a.__name__="PolyEditToolView";class c extends n.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.icon=l.tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_PolyEditTool(){this.prototype.default_view=a}}s.PolyEditTool=c,c.__name__="PolyEditTool",c.init_PolyEditTool()},
function _(e,t,o,s,i){s();const l=e(378),n=e(136),_=e(20),c=e(242);class h extends l.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[i,l]=e;s=[t-(i-t),o-(l-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this.model.overlay.update({left:i[0],right:i[1],top:l[0],bottom:l[1]}),this.model.select_every_mousemove&&this._do_select(i,l,!1,this._select_mode(e))}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this._do_select(i,l,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.state.push("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],i,l="replace"){const n={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(n,i,l)}}o.BoxSelectToolView=h,h.__name__="BoxSelectToolView";const r=()=>new n.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class a extends l.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.icon=c.tool_icon_box_select,this.event_type="pan",this.default_order=30}static init_BoxSelectTool(){this.prototype.default_view=h,this.define((({Boolean:e,Ref:t})=>({dimensions:[_.Dimensions,"both"],select_every_mousemove:[e,!1],overlay:[t(n.BoxAnnotation),r],origin:[_.BoxOrigin,"corner"]}))),this.register_alias("box_select",(()=>new a)),this.register_alias("xbox_select",(()=>new a({dimensions:"width"}))),this.register_alias("ybox_select",(()=>new a({dimensions:"height"})))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}o.BoxSelectTool=a,a.__name__="BoxSelectTool",a.init_BoxSelectTool()},
function _(e,t,s,n,o){n();const r=e(237),c=e(61),i=e(123),l=e(62),a=e(161),_=e(20),d=e(43),h=e(264),p=e(15),u=e(11);class m extends r.GestureToolView{connect_signals(){super.connect_signals(),this.model.clear.connect((()=>this._clear()))}get computed_renderers(){const{renderers:e,names:t}=this.model,s=this.plot_model.data_renderers;return a.compute_renderers(e,s,t)}_computed_renderers_by_data_source(){var e;const t=new Map;for(const s of this.computed_renderers){let n;if(s instanceof c.GlyphRenderer)n=s.data_source;else{if(!(s instanceof i.GraphRenderer))continue;n=s.node_renderer.data_source}const o=null!==(e=t.get(n))&&void 0!==e?e:[];t.set(n,[...o,s])}return t}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void u.unreachable():this.model.mode}_keyup(e){e.keyCode==d.Keys.Esc&&this._clear()}_clear(){for(const e of this.computed_renderers)e.get_selection_manager().clear();const e=this.computed_renderers.map((e=>this.plot_view.renderer_view(e)));this.plot_view.request_paint(e)}_select(e,t,s){const n=this._computed_renderers_by_data_source();for(const[,o]of n){const n=o[0].get_selection_manager(),r=[];for(const e of o){const t=this.plot_view.renderer_view(e);null!=t&&r.push(t)}n.select(r,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{x_scale:s,y_scale:n}=this.plot_view.frame;let o;switch(e.type){case"point":{const{sx:t,sy:r}=e,c=s.invert(t),i=n.invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}case"span":{const{sx:t,sy:r}=e,c=s.invert(t),i=n.invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}case"rect":{const{sx0:t,sx1:r,sy0:c,sy1:i}=e,[l,a]=s.r_invert(t,r),[_,d]=n.r_invert(c,i);o=Object.assign(Object.assign({},e),{x0:l,y0:_,x1:a,y1:d});break}case"poly":{const{sx:t,sy:r}=e,c=s.v_invert(t),i=n.v_invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}}this.plot_model.trigger_event(new h.SelectionGeometry(o,t))}}s.SelectToolView=m,m.__name__="SelectToolView";class v extends r.GestureTool{constructor(e){super(e)}initialize(){super.initialize(),this.clear=new p.Signal0(this,"clear")}static init_SelectTool(){this.define((({String:e,Array:t,Ref:s,Or:n,Auto:o})=>({renderers:[n(t(s(l.DataRenderer)),o),"auto"],names:[t(e),[]],mode:[_.SelectionMode,"replace"]})))}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:()=>{this.clear.emit()}}]}}s.SelectTool=v,v.__name__="SelectTool",v.init_SelectTool()},
function _(t,o,e,s,i){s();const n=t(237),_=t(136),a=t(20),l=t(242);class r extends n.GestureToolView{_match_aspect(t,o,e){const s=e.bbox.aspect,i=e.bbox.h_range.end,n=e.bbox.h_range.start,_=e.bbox.v_range.end,a=e.bbox.v_range.start;let l=Math.abs(t[0]-o[0]),r=Math.abs(t[1]-o[1]);const h=0==r?0:l/r,[c]=h>=s?[1,h/s]:[s/h,1];let m,p,d,b;return t[0]<=o[0]?(m=t[0],p=t[0]+l*c,p>i&&(p=i)):(p=t[0],m=t[0]-l*c,m<n&&(m=n)),l=Math.abs(p-m),t[1]<=o[1]?(b=t[1],d=t[1]+l/s,d>_&&(d=_)):(d=t[1],b=t[1]-l/s,b<a&&(b=a)),r=Math.abs(d-b),t[0]<=o[0]?p=t[0]+s*r:m=t[0]-s*r,[[m,p],[b,d]]}_compute_limits(t){const o=this.plot_view.frame,e=this.model.dimensions;let s,i,n=this._base_point;if("center"==this.model.origin){const[o,e]=n,[s,i]=t;n=[o-(s-o),e-(i-e)]}return this.model.match_aspect&&"both"==e?[s,i]=this._match_aspect(n,t,o):[s,i]=this.model._get_dim_limits(n,t,o,e),[s,i]}_pan_start(t){this._base_point=[t.sx,t.sy]}_pan(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this.model.overlay.update({left:e[0],right:e[1],top:s[0],bottom:s[1]})}_pan_end(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this._update(e,s),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null}_update([t,o],[e,s]){if(Math.abs(o-t)<=5||Math.abs(s-e)<=5)return;const{x_scales:i,y_scales:n}=this.plot_view.frame,_=new Map;for(const[e,s]of i){const[i,n]=s.r_invert(t,o);_.set(e,{start:i,end:n})}const a=new Map;for(const[t,o]of n){const[i,n]=o.r_invert(e,s);a.set(t,{start:i,end:n})}const l={xrs:_,yrs:a};this.plot_view.state.push("box_zoom",{range:l}),this.plot_view.update_range(l)}}e.BoxZoomToolView=r,r.__name__="BoxZoomToolView";const h=()=>new _.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class c extends n.GestureTool{constructor(t){super(t),this.tool_name="Box Zoom",this.icon=l.tool_icon_box_zoom,this.event_type="pan",this.default_order=20}static init_BoxZoomTool(){this.prototype.default_view=r,this.define((({Boolean:t,Ref:o})=>({dimensions:[a.Dimensions,"both"],overlay:[o(_.BoxAnnotation),h],match_aspect:[t,!1],origin:[a.BoxOrigin,"corner"]}))),this.register_alias("box_zoom",(()=>new c({dimensions:"both"}))),this.register_alias("xbox_zoom",(()=>new c({dimensions:"width"}))),this.register_alias("ybox_zoom",(()=>new c({dimensions:"height"})))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}e.BoxZoomTool=c,c.__name__="BoxZoomTool",c.init_BoxZoomTool()},
function _(s,e,t,o,i){o();const l=s(378),_=s(231),a=s(381),c=s(43),n=s(242);class h extends l.SelectToolView{constructor(){super(...arguments),this.sxs=[],this.sys=[]}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._active_change()))}_active_change(){this.model.active||this._clear_overlay()}_keyup(s){s.keyCode==c.Keys.Enter&&this._clear_overlay()}_pan_start(s){this.sxs=[],this.sys=[];const{sx:e,sy:t}=s;this._append_overlay(e,t)}_pan(s){const[e,t]=this.plot_view.frame.bbox.clip(s.sx,s.sy);this._append_overlay(e,t),this.model.select_every_mousemove&&this._do_select(this.sxs,this.sys,!1,this._select_mode(s))}_pan_end(s){const{sxs:e,sys:t}=this;this._clear_overlay(),this._do_select(e,t,!0,this._select_mode(s)),this.plot_view.state.push("lasso_select",{selection:this.plot_view.get_selection()})}_append_overlay(s,e){const{sxs:t,sys:o}=this;t.push(s),o.push(e),this.model.overlay.update({xs:t,ys:o})}_clear_overlay(){this.sxs=[],this.sys=[],this.model.overlay.update({xs:this.sxs,ys:this.sys})}_do_select(s,e,t,o){const i={type:"poly",sx:s,sy:e};this._select(i,t,o)}}t.LassoSelectToolView=h,h.__name__="LassoSelectToolView";class r extends l.SelectTool{constructor(s){super(s),this.tool_name="Lasso Select",this.icon=n.tool_icon_lasso_select,this.event_type="pan",this.default_order=12}static init_LassoSelectTool(){this.prototype.default_view=h,this.define((({Boolean:s,Ref:e})=>({select_every_mousemove:[s,!0],overlay:[e(_.PolyAnnotation),a.DEFAULT_POLY_OVERLAY]}))),this.register_alias("lasso_select",(()=>new r))}}t.LassoSelectTool=r,r.__name__="LassoSelectTool",r.init_LassoSelectTool()},
function _(e,t,s,l,o){l();const i=e(378),a=e(231),_=e(43),c=e(9),n=e(242);class h extends i.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._active_change()))}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==_.Keys.Enter&&this._clear_data()}_doubletap(e){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.state.push("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))}_do_select(e,t,s,l){const o={type:"poly",sx:e,sy:t};this._select(o,s,l)}}s.PolySelectToolView=h,h.__name__="PolySelectToolView";s.DEFAULT_POLY_OVERLAY=()=>new a.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class y extends i.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.icon=n.tool_icon_polygon_select,this.event_type="tap",this.default_order=11}static init_PolySelectTool(){this.prototype.default_view=h,this.define((({Ref:e})=>({overlay:[e(a.PolyAnnotation),s.DEFAULT_POLY_OVERLAY]}))),this.register_alias("poly_select",(()=>new y))}}s.PolySelectTool=y,y.__name__="PolySelectTool",y.init_PolySelectTool()},
function _(e,t,i,s,n){s();const r=e(20),_=e(383),d=e(242);class o extends _.LineToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this.model.renderers;for(const i of t){1==this._select_event(e,"replace",[i]).length&&(this._selected_renderer=i)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[i,s]=[t.x.field,t.y.field],n=e.get_array(i),r=e.get_array(s);this._set_intersection(n,r)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&this._selected_renderer){const i=this._select_mode(e);if(0==this._select_event(e,i,[t]).length)return}const i=this._select_mode(e);this._select_event(e,i,[t]),this._select_event(e,i,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[i,s]=[e.x.field,e.y.field];if(i&&s){const e=t.data[i],n=t.data[s];this._selected_renderer.data_source.data[i]=e,this._selected_renderer.data_source.data[s]=n}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}i.LineEditToolView=o,o.__name__="LineEditToolView";class l extends _.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.icon=d.tool_icon_line_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_LineEditTool(){this.prototype.default_view=o,this.define((()=>({dimensions:[r.Dimensions,"both"]})))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}i.LineEditTool=l,l.__name__="LineEditTool",l.init_LineEditTool()},
function _(e,i,t,n,o){n();const s=e(8),_=e(370);class r extends _.EditToolView{_set_intersection(e,i){const t=this.model.intersection_renderer.glyph,n=this.model.intersection_renderer.data_source,[o,_]=[t.x.field,t.y.field];o&&(s.isArray(e)?n.data[o]=e:t.x={value:e}),_&&(s.isArray(i)?n.data[_]=i:t.y={value:i}),this._emit_cds_changes(n,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}t.LineToolView=r,r.__name__="LineToolView";class c extends _.EditTool{constructor(e){super(e)}static init_LineTool(){this.define((({AnyRef:e})=>({intersection_renderer:[e()]})))}}t.LineTool=c,c.__name__="LineTool",c.init_LineTool()},
function _(t,s,i,n,e){n();const o=t(1),a=t(237),_=t(20),h=o.__importStar(t(242));function l(t,s,i){const n=new Map;for(const[e,o]of t){const[t,a]=o.r_invert(s,i);n.set(e,{start:t,end:a})}return n}i.update_ranges=l;class r extends a.GestureToolView{_pan_start(t){var s;this.last_dx=0,this.last_dy=0;const{sx:i,sy:n}=t,e=this.plot_view.frame.bbox;if(!e.contains(i,n)){const t=e.h_range,s=e.v_range;(i<t.start||i>t.end)&&(this.v_axis_only=!0),(n<s.start||n>s.end)&&(this.h_axis_only=!0)}null===(s=this.model.document)||void 0===s||s.interactive_start(this.plot_model)}_pan(t){var s;this._update(t.deltaX,t.deltaY),null===(s=this.model.document)||void 0===s||s.interactive_start(this.plot_model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.state.push("pan",{range:this.pan_info})}_update(t,s){const i=this.plot_view.frame,n=t-this.last_dx,e=s-this.last_dy,o=i.bbox.h_range,a=o.start-n,_=o.end-n,h=i.bbox.v_range,r=h.start-e,d=h.end-e,p=this.model.dimensions;let c,m,u,x,v,y;"width"!=p&&"both"!=p||this.v_axis_only?(c=o.start,m=o.end,u=0):(c=a,m=_,u=-n),"height"!=p&&"both"!=p||this.h_axis_only?(x=h.start,v=h.end,y=0):(x=r,v=d,y=-e),this.last_dx=t,this.last_dy=s;const{x_scales:g,y_scales:w}=i,f=l(g,c,m),b=l(w,x,v);this.pan_info={xrs:f,yrs:b,sdx:u,sdy:y},this.plot_view.update_range(this.pan_info,{panning:!0})}}i.PanToolView=r,r.__name__="PanToolView";class d extends a.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}static init_PanTool(){this.prototype.default_view=r,this.define((()=>({dimensions:[_.Dimensions,"both",{on_update(t,s){switch(t){case"both":s.icon=h.tool_icon_pan;break;case"width":s.icon=h.tool_icon_xpan;break;case"height":s.icon=h.tool_icon_ypan}}}]}))),this.register_alias("pan",(()=>new d({dimensions:"both"}))),this.register_alias("xpan",(()=>new d({dimensions:"width"}))),this.register_alias("ypan",(()=>new d({dimensions:"height"})))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}i.PanTool=d,d.__name__="PanTool",d.init_PanTool()},
function _(t,e,i,s,n){s();const l=t(136),a=t(156),r=t(19),o=t(237),_=t(242);function h(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function d(t,e,i,s){if(null==e)return!1;const n=i.compute(e);return Math.abs(t-n)<s}function u(t,e,i,s,n){let l=!0;if(null!=n.left&&null!=n.right){const e=i.invert(t);(e<n.left||e>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const t=s.invert(e);(t<n.bottom||t>n.top)&&(l=!1)}return l}function c(t,e,i){let s=0;return t>=i.start&&t<=i.end&&(s+=1),e>=i.start&&e<=i.end&&(s+=1),s}function g(t,e,i,s){const n=e.compute(t),l=e.invert(n+i);return l>=s.start&&l<=s.end?l:t}function y(t,e,i){return t>e.start?(e.end=t,i):(e.end=e.start,e.start=t,h(i))}function f(t,e,i){return t<e.end?(e.start=t,i):(e.start=e.end,e.end=t,h(i))}function m(t,e,i,s){const[n,l]=e.r_compute(t.start,t.end),[a,r]=e.r_invert(n+i,l+i),o=c(t.start,t.end,s);c(a,r,s)>=o&&(t.start=a,t.end=r)}i.flip_side=h,i.is_near=d,i.is_inside=u,i.sides_inside=c,i.compute_value=g,i.update_range_end_side=y,i.update_range_start_side=f,i.update_range=m;class v extends o.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,(()=>this.model.update_overlay_from_ranges())),null!=this.model.y_range&&this.connect(this.model.y_range.change,(()=>this.model.update_overlay_from_ranges()))}_pan_start(t){this.last_dx=0,this.last_dy=0;const e=this.model.x_range,i=this.model.y_range,{frame:s}=this.plot_view,n=s.x_scale,a=s.y_scale,r=this.model.overlay,{left:o,right:_,top:h,bottom:c}=r,g=this.model.overlay.line_width+l.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(d(t.sx,o,n,g)?this.side=1:d(t.sx,_,n,g)?this.side=2:u(t.sx,t.sy,n,a,r)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&d(t.sy,c,a,g)&&(this.side=4),0==this.side&&d(t.sy,h,a,g)?this.side=5:u(t.sx,t.sy,n,a,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(t){const e=this.plot_view.frame,i=t.deltaX-this.last_dx,s=t.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=e.x_scale,r=e.y_scale;if(null!=n)if(3==this.side||7==this.side)m(n,a,i,e.x_range);else if(1==this.side){const t=g(n.start,a,i,e.x_range);this.side=f(t,n,this.side)}else if(2==this.side){const t=g(n.end,a,i,e.x_range);this.side=y(t,n,this.side)}if(null!=l)if(6==this.side||7==this.side)m(l,r,s,e.y_range);else if(4==this.side){const t=g(l.start,r,s,e.y_range);this.side=f(t,l,this.side)}else if(5==this.side){const t=g(l.end,r,s,e.y_range);this.side=y(t,l,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY}_pan_end(t){this.side=0}}i.RangeToolView=v,v.__name__="RangeToolView";const p=()=>new l.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class x extends o.GestureTool{constructor(t){super(t),this.tool_name="Range Tool",this.icon=_.tool_icon_range,this.event_type="pan",this.default_order=1}static init_RangeTool(){this.prototype.default_view=v,this.define((({Boolean:t,Ref:e,Nullable:i})=>({x_range:[i(e(a.Range1d)),null],x_interaction:[t,!0],y_range:[i(e(a.Range1d)),null],y_interaction:[t,!0],overlay:[e(l.BoxAnnotation),p]})))}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,r.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}}i.RangeTool=x,x.__name__="RangeTool",x.init_RangeTool()},
function _(e,t,s,o,i){o();const l=e(378),a=e(20),n=e(242);class c extends l.SelectToolView{_tap(e){"tap"==this.model.gesture&&this._handle_tap(e)}_doubletap(e){"doubletap"==this.model.gesture&&this._handle_tap(e)}_handle_tap(e){const{sx:t,sy:s}=e,o={type:"point",sx:t,sy:s};this._select(o,!0,this._select_mode(e))}_select(e,t,s){const{callback:o}=this.model;if("select"==this.model.behavior){const i=this._computed_renderers_by_data_source();for(const[,l]of i){const i=l[0].get_selection_manager(),a=l.map((e=>this.plot_view.renderer_view(e))).filter((e=>null!=e));if(i.select(a,e,t,s)&&null!=o){const t=a[0].coordinates.x_scale.invert(e.sx),s=a[0].coordinates.y_scale.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:t,y:s}),source:i.source};o.execute(this.model,l)}}this._emit_selection_event(e),this.plot_view.state.push("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=this.plot_view.renderer_view(t);if(null==s)continue;const i=t.get_selection_manager();if(i.inspect(s,e)&&null!=o){const t=s.coordinates.x_scale.invert(e.sx),l=s.coordinates.y_scale.invert(e.sy),a={geometries:Object.assign(Object.assign({},e),{x:t,y:l}),source:i.source};o.execute(this.model,a)}}}}s.TapToolView=c,c.__name__="TapToolView";class _ extends l.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.icon=n.tool_icon_tap_select,this.event_type="tap",this.default_order=10}static init_TapTool(){this.prototype.default_view=c,this.define((({Any:e,Enum:t,Nullable:s})=>({behavior:[a.TapBehavior,"select"],gesture:[t("tap","doubletap"),"tap"],callback:[s(e)]}))),this.register_alias("click",(()=>new _({behavior:"inspect"}))),this.register_alias("tap",(()=>new _)),this.register_alias("doubletap",(()=>new _({gesture:"doubletap"})))}}s.TapTool=_,_.__name__="TapTool",_.init_TapTool()},
function _(e,t,s,i,n){i();const o=e(237),a=e(20),l=e(242),_=e(384);class h extends o.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){var t;const{frame:s}=this.plot_view,i=s.bbox.h_range,n=s.bbox.v_range,[o,a]=[i.start,i.end],[l,h]=[n.start,n.end];let r,d,c,p;switch(this.model.dimension){case"height":{const t=Math.abs(h-l);r=o,d=a,c=l-t*e,p=h-t*e;break}case"width":{const t=Math.abs(a-o);r=o-t*e,d=a-t*e,c=l,p=h;break}}const{x_scales:m,y_scales:u}=s,w={xrs:_.update_ranges(m,r,d),yrs:_.update_ranges(u,c,p),factor:e};this.plot_view.state.push("wheel_pan",{range:w}),this.plot_view.update_range(w,{scrolling:!0}),null===(t=this.model.document)||void 0===t||t.interactive_start(this.plot_model)}}s.WheelPanToolView=h,h.__name__="WheelPanToolView";class r extends o.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.icon=l.tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}static init_WheelPanTool(){this.prototype.default_view=h,this.define((()=>({dimension:[a.Dimension,"width"]}))),this.internal((({Number:e})=>({speed:[e,.001]}))),this.register_alias("xwheel_pan",(()=>new r({dimension:"width"}))),this.register_alias("ywheel_pan",(()=>new r({dimension:"height"})))}get tooltip(){return this._get_dim_tooltip(this.dimension)}}s.WheelPanTool=r,r.__name__="WheelPanTool",r.init_WheelPanTool()},
function _(e,o,t,s,i){s();const l=e(237),n=e(368),h=e(20),_=e(27),a=e(242);class m extends l.GestureToolView{_pinch(e){const{sx:o,sy:t,scale:s,ctrlKey:i,shiftKey:l}=e;let n;n=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:o,sy:t,delta:n,ctrlKey:i,shiftKey:l})}_scroll(e){var o;const{frame:t}=this.plot_view,s=t.bbox.h_range,i=t.bbox.v_range,{sx:l,sy:h}=e,_=this.model.dimensions,a=("width"==_||"both"==_)&&s.start<l&&l<s.end,m=("height"==_||"both"==_)&&i.start<h&&h<i.end;if(!(a&&m||this.model.zoom_on_axis))return;const r=this.model.speed*e.delta,d=n.scale_range(t,r,a,m,{x:l,y:h});this.plot_view.state.push("wheel_zoom",{range:d});const{maintain_focus:c}=this.model;this.plot_view.update_range(d,{scrolling:!0,maintain_focus:c}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model)}}t.WheelZoomToolView=m,m.__name__="WheelZoomToolView";class r extends l.GestureTool{constructor(e){super(e),this.tool_name="Wheel Zoom",this.icon=a.tool_icon_wheel_zoom,this.event_type=_.is_mobile?"pinch":"scroll",this.default_order=10}static init_WheelZoomTool(){this.prototype.default_view=m,this.define((({Boolean:e,Number:o})=>({dimensions:[h.Dimensions,"both"],maintain_focus:[e,!0],zoom_on_axis:[e,!0],speed:[o,1/600]}))),this.register_alias("wheel_zoom",(()=>new r({dimensions:"both"}))),this.register_alias("xwheel_zoom",(()=>new r({dimensions:"width"}))),this.register_alias("ywheel_zoom",(()=>new r({dimensions:"height"})))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}t.WheelZoomTool=r,r.__name__="WheelZoomTool",r.init_WheelZoomTool()},
function _(i,s,t,o,e){o();const n=i(247),l=i(233),h=i(20),a=i(13),r=i(242);class _ extends n.InspectToolView{_move(i){if(!this.model.active)return;const{sx:s,sy:t}=i;this.plot_view.frame.bbox.contains(s,t)?this._update_spans(s,t):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,s){const t=this.model.dimensions;"width"!=t&&"both"!=t||(this.model.spans.width.location=s),"height"!=t&&"both"!=t||(this.model.spans.height.location=i)}}t.CrosshairToolView=_,_.__name__="CrosshairToolView";class c extends n.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.icon=r.tool_icon_crosshair}static init_CrosshairTool(){function i(i,s){return new l.Span({for_hover:!0,dimension:s,location_units:"screen",level:"overlay",line_color:i.line_color,line_width:i.line_width,line_alpha:i.line_alpha})}this.prototype.default_view=_,this.define((({Alpha:i,Number:s,Color:t})=>({dimensions:[h.Dimensions,"both"],line_color:[t,"black"],line_width:[s,1],line_alpha:[i,1]}))),this.internal((({Struct:s,Ref:t})=>({spans:[s({width:t(l.Span),height:t(l.Span)}),s=>({width:i(s,"width"),height:i(s,"height")})]}))),this.register_alias("crosshair",(()=>new c))}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get synthetic_renderers(){return a.values(this.spans)}}t.CrosshairTool=c,c.__name__="CrosshairTool",c.init_CrosshairTool()},
function _(t,e,s,o,r){o();const n=t(53),i=t(13),a=t(34);class u extends n.Model{constructor(t){super(t)}static init_CustomJSHover(){this.define((({Unknown:t,String:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))}get values(){return i.values(this.args)}_make_code(t,e,s,o){return new Function(...i.keys(this.args),t,e,s,a.use_strict(o))}format(t,e,s){return this._make_code("value","format","special_vars",this.code)(...this.values,t,e,s)}}s.CustomJSHover=u,u.__name__="CustomJSHover",u.init_CustomJSHover()},
function _(e,t,n,s,o){s();const i=e(1),r=e(247),l=e(390),a=e(254),c=e(61),_=e(123),d=e(62),p=e(63),h=e(127),u=i.__importStar(e(107)),m=e(182),y=e(43),f=e(22),x=e(13),v=e(245),w=e(8),g=e(122),b=e(20),k=e(242),C=e(15),S=e(161),T=i.__importStar(e(255));function $(e,t,n,s,o,i){const r={x:o[e],y:i[e]},l={x:o[e+1],y:i[e+1]};let a,c;if("span"==t.type)"h"==t.direction?(a=Math.abs(r.x-n),c=Math.abs(l.x-n)):(a=Math.abs(r.y-s),c=Math.abs(l.y-s));else{const e={x:n,y:s};a=u.dist_2_pts(r,e),c=u.dist_2_pts(l,e)}return a<c?[[r.x,r.y],e]:[[l.x,l.y],e+1]}function R(e,t,n){return[[e[n],t[n]],n]}n._nearest_line_hit=$,n._line_hit=R;class H extends r.InspectToolView{initialize(){super.initialize(),this._ttmodels=new Map,this._ttviews=new Map}async lazy_initialize(){await super.lazy_initialize(),await this._update_ttmodels()}remove(){g.remove_views(this._ttviews),super.remove()}connect_signals(){super.connect_signals();const e=this.plot_model.properties.renderers,{renderers:t,tooltips:n}=this.model.properties;this.on_change(n,(()=>delete this._template_el)),this.on_change([e,t,n],(async()=>await this._update_ttmodels()))}async _update_ttmodels(){const{_ttmodels:e,computed_renderers:t}=this;e.clear();const{tooltips:n}=this.model;if(null!=n)for(const t of this.computed_renderers){const s=new a.Tooltip({custom:w.isString(n)||w.isFunction(n),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t instanceof c.GlyphRenderer?e.set(t,s):t instanceof _.GraphRenderer&&(e.set(t.node_renderer,s),e.set(t.edge_renderer,s))}const s=await g.build_views(this._ttviews,[...e.values()],{parent:this.plot_view});for(const e of s)e.render();const o=[...function*(){for(const e of t)e instanceof c.GlyphRenderer?yield e:e instanceof _.GraphRenderer&&(yield e.node_renderer,yield e.edge_renderer)}()],i=this._slots.get(this._update);if(null!=i){const e=new Set(o.map((e=>e.data_source)));C.Signal.disconnect_receiver(this,i,e)}for(const e of o)this.connect(e.data_source.inspect,this._update)}get computed_renderers(){const{renderers:e,names:t}=this.model,n=this.plot_model.data_renderers;return S.compute_renderers(e,n,t)}get ttmodels(){return this._ttmodels}_clear(){this._inspect(1/0,1/0);for(const[,e]of this.ttmodels)e.clear()}_move(e){if(!this.model.active)return;const{sx:t,sy:n}=e;this.plot_view.frame.bbox.contains(t,n)?this._inspect(t,n):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let n;if("mouse"==this.model.mode)n={type:"point",sx:e,sy:t};else{n={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){const t=e.get_selection_manager(),s=this.plot_view.renderer_view(e);null!=s&&t.inspect(s,n)}this._emit_callback(n)}_update([e,{geometry:t}]){var n,s;if(!this.model.active)return;if("point"!=t.type&&"span"!=t.type)return;if(!(e instanceof c.GlyphRenderer))return;if("ignore"==this.model.muted_policy&&e.muted)return;const o=this.ttmodels.get(e);if(null==o)return;const i=e.get_selection_manager();let r=i.inspectors.get(e);if(r=e.view.convert_selection_to_subset(r),r.is_empty())return void o.clear();const l=i.source,a=this.plot_view.renderer_view(e);if(null==a)return;const{sx:_,sy:d}=t,u=a.coordinates.x_scale,m=a.coordinates.y_scale,f=u.invert(_),v=m.invert(d),{glyph:w}=a,g=[];if(w instanceof p.LineView)for(const n of r.line_indices){let s,o,i=w._x[n+1],a=w._y[n+1],c=n;switch(this.model.line_policy){case"interp":[i,a]=w.get_interpolation_hit(n,t),s=u.compute(i),o=m.compute(a);break;case"prev":[[s,o],c]=R(w.sx,w.sy,n);break;case"next":[[s,o],c]=R(w.sx,w.sy,n+1);break;case"nearest":[[s,o],c]=$(n,t,_,d,w.sx,w.sy),i=w._x[c],a=w._y[c];break;default:[s,o]=[_,d]}const p={index:c,x:f,y:v,sx:_,sy:d,data_x:i,data_y:a,rx:s,ry:o,indices:r.line_indices,name:e.name};g.push([s,o,this._render_tooltips(l,c,p)])}for(const t of r.image_indices){const n={index:t.index,x:f,y:v,sx:_,sy:d,name:e.name},s=this._render_tooltips(l,t,n);g.push([_,d,s])}for(const o of r.indices)if(w instanceof h.MultiLineView&&!x.isEmpty(r.multiline_indices))for(const n of r.multiline_indices[o.toString()]){let s,i,a,p=w._xs.get(o)[n],h=w._ys.get(o)[n],y=n;switch(this.model.line_policy){case"interp":[p,h]=w.get_interpolation_hit(o,n,t),s=u.compute(p),i=m.compute(h);break;case"prev":[[s,i],y]=R(w.sxs.get(o),w.sys.get(o),n);break;case"next":[[s,i],y]=R(w.sxs.get(o),w.sys.get(o),n+1);break;case"nearest":[[s,i],y]=$(n,t,_,d,w.sxs.get(o),w.sys.get(o)),p=w._xs.get(o)[y],h=w._ys.get(o)[y];break;default:throw new Error("shouldn't have happened")}a=e instanceof c.GlyphRenderer?e.view.convert_indices_from_subset([o])[0]:o;const x={index:a,x:f,y:v,sx:_,sy:d,data_x:p,data_y:h,segment_index:y,indices:r.multiline_indices,name:e.name};g.push([s,i,this._render_tooltips(l,a,x)])}else{const t=null===(n=w._x)||void 0===n?void 0:n[o],i=null===(s=w._y)||void 0===s?void 0:s[o];let a,p,h;if("snap_to_data"==this.model.point_policy){let e=w.get_anchor_point(this.model.anchor,o,[_,d]);if(null==e&&(e=w.get_anchor_point("center",o,[_,d]),null==e))continue;a=e.x,p=e.y}else[a,p]=[_,d];h=e instanceof c.GlyphRenderer?e.view.convert_indices_from_subset([o])[0]:o;const u={index:h,x:f,y:v,sx:_,sy:d,data_x:t,data_y:i,indices:r.indices,name:e.name};g.push([a,p,this._render_tooltips(l,h,u)])}if(0==g.length)o.clear();else{const{content:e}=o;y.empty(o.content);for(const[,,t]of g)null!=t&&e.appendChild(t);const[t,n]=g[g.length-1];o.setv({position:[t,n]},{check_eq:!1})}}_emit_callback(e){const{callback:t}=this.model;if(null!=t)for(const n of this.computed_renderers){if(!(n instanceof c.GlyphRenderer))continue;const s=this.plot_view.renderer_view(n);if(null==s)continue;const{x_scale:o,y_scale:i}=s.coordinates,r=o.invert(e.sx),l=i.invert(e.sy),a=n.data_source.inspected;t.execute(this.model,{geometry:Object.assign({x:r,y:l},e),renderer:n,index:a})}}_create_template(e){const t=y.div({style:{display:"table",borderSpacing:"2px"}});for(const[n]of e){const e=y.div({style:{display:"table-row"}});t.appendChild(e);const s=y.div({style:{display:"table-cell"},class:T.tooltip_row_label},0!=n.length?`${n}: `:"");e.appendChild(s);const o=y.span();o.dataset.value="";const i=y.span({class:T.tooltip_color_block}," ");i.dataset.swatch="",y.undisplay(i);const r=y.div({style:{display:"table-cell"},class:T.tooltip_row_value},o,i);e.appendChild(r)}return t}_render_template(e,t,n,s,o){const i=e.cloneNode(!0),r=i.querySelectorAll("[data-value]"),l=i.querySelectorAll("[data-swatch]"),a=/\$color(\[.*\])?:(\w*)/,c=/\$swatch:(\w*)/;for(const[[,e],i]of v.enumerate(t)){const t=e.match(c),_=e.match(a);if(null!=t||null!=_){if(null!=t){const[,e]=t,o=n.get_column(e);if(null==o)r[i].textContent=`${e} unknown`;else{const e=w.isNumber(s)?o[s]:null;null!=e&&(l[i].style.backgroundColor=f.color2css(e),y.display(l[i]))}}if(null!=_){const[,e="",t]=_,o=n.get_column(t);if(null==o){r[i].textContent=`${t} unknown`;continue}const a=e.indexOf("hex")>=0,c=e.indexOf("swatch")>=0,d=w.isNumber(s)?o[s]:null;if(null==d){r[i].textContent="(null)";continue}r[i].textContent=a?f.color2hex(d):f.color2css(d),c&&(l[i].style.backgroundColor=f.color2css(d),y.display(l[i]))}}else{const t=m.replace_placeholders(e.replace("$~","$data_"),n,s,this.model.formatters,o);if(w.isString(t))r[i].textContent=t;else for(const e of t)r[i].appendChild(e)}}return i}_render_tooltips(e,t,n){var s;const{tooltips:o}=this.model;if(w.isString(o)){const s=m.replace_placeholders({html:o},e,t,this.model.formatters,n);return y.div({},s)}if(w.isFunction(o))return o(e,n);if(null!=o){const i=null!==(s=this._template_el)&&void 0!==s?s:this._template_el=this._create_template(o);return this._render_template(i,o,e,t,n)}return null}}n.HoverToolView=H,H.__name__="HoverToolView";class M extends r.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.icon=k.tool_icon_hover}static init_HoverTool(){this.prototype.default_view=H,this.define((({Any:e,Boolean:t,String:n,Array:s,Tuple:o,Dict:i,Or:r,Ref:a,Function:c,Auto:_,Nullable:p})=>({tooltips:[p(r(n,s(o(n,n)),c())),[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[i(r(a(l.CustomJSHover),m.FormatterType)),{}],renderers:[r(s(a(d.DataRenderer)),_),"auto"],names:[s(n),[]],mode:[b.HoverMode,"mouse"],muted_policy:[b.MutedPolicy,"show"],point_policy:[b.PointPolicy,"snap_to_data"],line_policy:[b.LinePolicy,"nearest"],show_arrow:[t,!0],anchor:[b.Anchor,"center"],attachment:[b.TooltipAttachment,"horizontal"],callback:[p(e)]}))),this.register_alias("hover",(()=>new M))}}n.HoverTool=M,M.__name__="HoverTool",M.init_HoverTool()},
function _(t,o,e,n,i){n();const s=t(15),l=t(53),c=t(238),r=t(247),a=t(245);class u extends l.Model{constructor(t){super(t)}static init_ToolProxy(){this.define((({Boolean:t,Array:o,Ref:e})=>({tools:[o(e(c.ButtonTool)),[]],active:[t,!1],disabled:[t,!1]})))}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get icon(){return this.tools[0].computed_icon}get computed_icon(){return this.icon}get toggleable(){const t=this.tools[0];return t instanceof r.InspectTool&&t.toggleable}initialize(){super.initialize(),this.do=new s.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,(()=>this.doit())),this.connect(this.properties.active.change,(()=>this.set_active()));for(const t of this.tools)this.connect(t.properties.active.change,(()=>{this.active=t.active}))}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,n]of a.enumerate(t))if(null==e)o.push(null);else{const t=()=>{var t,o;for(const e of this.tools)null===(o=null===(t=e.menu)||void 0===t?void 0:t[n])||void 0===o||o.handler()};o.push(Object.assign(Object.assign({},e),{handler:t}))}return o}}e.ToolProxy=u,u.__name__="ToolProxy",u.init_ToolProxy()},
function _(o,t,s,i,e){i();const n=o(20),r=o(9),l=o(13),c=o(248),h=o(235),a=o(392),_=o(319),p=o(221);class f extends c.ToolbarBase{constructor(o){super(o)}static init_ProxyToolbar(){this.define((({Array:o,Ref:t})=>({toolbars:[o(t(h.Toolbar)),[]]})))}initialize(){super.initialize(),this._merge_tools()}_merge_tools(){this._proxied_tools=[];const o={},t={},s={},i=[],e=[];for(const o of this.help)r.includes(e,o.redirect)||(i.push(o),e.push(o.redirect));this._proxied_tools.push(...i),this.help=i;for(const[o,t]of l.entries(this.gestures)){o in s||(s[o]={});for(const i of t.tools)i.type in s[o]||(s[o][i.type]=[]),s[o][i.type].push(i)}for(const t of this.inspectors)t.type in o||(o[t.type]=[]),o[t.type].push(t);for(const o of this.actions)o.type in t||(t[o.type]=[]),t[o.type].push(o);const n=(o,t=!1)=>{const s=new a.ToolProxy({tools:o,active:t});return this._proxied_tools.push(s),s};for(const o of l.keys(s)){const t=this.gestures[o];t.tools=[];for(const i of l.keys(s[o])){const e=s[o][i];if(e.length>0)if("multi"==o)for(const o of e){const s=n([o]);t.tools.push(s),this.connect(s.properties.active.change,(()=>this._active_change(s)))}else{const o=n(e);t.tools.push(o),this.connect(o.properties.active.change,(()=>this._active_change(o)))}}}this.actions=[];for(const[o,s]of l.entries(t))if("CustomAction"==o)for(const o of s)this.actions.push(n([o]));else s.length>0&&this.actions.push(n(s));this.inspectors=[];for(const t of l.values(o))t.length>0&&this.inspectors.push(n(t,!0));for(const[o,t]of l.entries(this.gestures))0!=t.tools.length&&(t.tools=r.sort_by(t.tools,(o=>o.default_order)),"pinch"!=o&&"scroll"!=o&&"multi"!=o&&(t.tools[0].active=!0))}}s.ProxyToolbar=f,f.__name__="ProxyToolbar",f.init_ProxyToolbar();class u extends _.LayoutDOMView{initialize(){this.model.toolbar.toolbar_location=this.model.toolbar_location,super.initialize()}get child_models(){return[this.model.toolbar]}_update_layout(){this.layout=new p.ContentBox(this.child_views[0].el);const{toolbar:o}=this.model;o.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})}}s.ToolbarBoxView=u,u.__name__="ToolbarBoxView";class y extends _.LayoutDOM{constructor(o){super(o)}static init_ToolbarBox(){this.prototype.default_view=u,this.define((({Ref:o})=>({toolbar:[o(c.ToolbarBase)],toolbar_location:[n.Location,"right"]})))}}s.ToolbarBox=y,y.__name__="ToolbarBox",y.init_ToolbarBox()},
function _(e,n,r,t,o){t();const s=e(1),u=e(7),c=e(53),l=s.__importStar(e(21)),a=e(8),i=e(13);r.resolve_defs=function(e){var n,r,t,o;function s(e){return null!=e.module?`${e.module}.${e.name}`:e.name}function d(e){if(a.isString(e))switch(e){case"Any":return l.Any;case"Unknown":return l.Unknown;case"Boolean":return l.Boolean;case"Number":return l.Number;case"Int":return l.Int;case"String":return l.String;case"Null":return l.Null}else switch(e[0]){case"Nullable":{const[,n]=e;return l.Nullable(d(n))}case"Or":{const[,...n]=e;return l.Or(...n.map(d))}case"Tuple":{const[,n,...r]=e;return l.Tuple(d(n),...r.map(d))}case"Array":{const[,n]=e;return l.Array(d(n))}case"Struct":{const[,...n]=e,r=n.map((([e,n])=>[e,d(n)]));return l.Struct(i.to_object(r))}case"Dict":{const[,n]=e;return l.Dict(d(n))}case"Map":{const[,n,r]=e;return l.Map(d(n),d(r))}case"Enum":{const[,...n]=e;return l.Enum(...n)}case"Ref":{const[,n]=e,r=u.Models.get(s(n));if(null!=r)return l.Ref(r);throw new Error(`${s(n)} wasn't defined before referencing it`)}case"AnyRef":return l.AnyRef()}}for(const l of e){const e=(()=>{if(null==l.extends)return c.Model;{const e=u.Models.get(s(l.extends));if(null!=e)return e;throw new Error(`base model ${s(l.extends)} of ${s(l)} is not defined`)}})(),a=((o=class extends e{}).__name__=l.name,o.__module__=l.module,o);for(const e of null!==(n=l.properties)&&void 0!==n?n:[]){const n=d(null!==(r=e.kind)&&void 0!==r?r:"Unknown");a.define({[e.name]:[n,e.default]})}for(const e of null!==(t=l.overrides)&&void 0!==t?t:[])a.override({[e.name]:e.default});u.Models.register_models([a])}}},
function _(n,e,t,o,i){o();const d=n(5),c=n(240),s=n(122),a=n(43),l=n(396);t.index={},t.add_document_standalone=async function(n,e,o=[],i=!1){const u=new Map;async function f(i){let d;const f=n.roots().indexOf(i),r=o[f];null!=r?d=r:e.classList.contains(l.BOKEH_ROOT)?d=e:(d=a.div({class:l.BOKEH_ROOT}),e.appendChild(d));const w=await s.build_view(i,{parent:null});return w instanceof c.DOMView&&w.renderTo(d),u.set(i,w),t.index[i.id]=w,w}for(const e of n.roots())await f(e);return i&&(window.document.title=n.title()),n.on_change((n=>{n instanceof d.RootAddedEvent?f(n.model):n instanceof d.RootRemovedEvent?function(n){const e=u.get(n);null!=e&&(e.remove(),u.delete(n),delete t.index[n.id])}(n.model):i&&n instanceof d.TitleChangedEvent&&(window.document.title=n.title)})),[...u.values()]}},
function _(o,e,n,t,r){t();const l=o(43),d=o(44);function u(o){let e=document.getElementById(o);if(null==e)throw new Error(`Error rendering Bokeh model: could not find #${o} HTML tag`);if(!document.body.contains(e))throw new Error(`Error rendering Bokeh model: element #${o} must be under <body>`);if("SCRIPT"==e.tagName){const o=l.div({class:n.BOKEH_ROOT});l.replaceWith(e,o),e=o}return e}n.BOKEH_ROOT=d.root,n._resolve_element=function(o){const{elementid:e}=o;return null!=e?u(e):document.body},n._resolve_root_elements=function(o){const e=[];if(null!=o.root_ids&&null!=o.roots)for(const n of o.root_ids)e.push(u(o.roots[n]));return e}},
function _(n,o,t,s,e){s();const c=n(398),r=n(19),a=n(395);t._get_ws_url=function(n,o){let t,s="ws:";return"https:"==window.location.protocol&&(s="wss:"),null!=o?(t=document.createElement("a"),t.href=o):t=window.location,null!=n?"/"==n&&(n=""):n=t.pathname.replace(/\/+$/,""),s+"//"+t.host+n+"/ws"};const i={};t.add_document_from_session=async function(n,o,t,s=[],e=!1){const l=window.location.search.substr(1);let d;try{d=await function(n,o,t){const s=c.parse_token(o).session_id;n in i||(i[n]={});const e=i[n];return s in e||(e[s]=c.pull_session(n,o,t)),e[s]}(n,o,l)}catch(n){const t=c.parse_token(o).session_id;throw r.logger.error(`Failed to load Bokeh session ${t}: ${n}`),n}return a.add_document_standalone(d.document,t,s,e)}},
function _(e,s,n,t,o){t();const r=e(19),i=e(5),c=e(399),l=e(400),_=e(401);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let h=0;function a(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=a;class d{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,t=null){this.url=e,this.token=s,this.args_string=t,this._number=h++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new l.Receiver,this.id=a(s).session_id.split(".")[0],r.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=`${this.url}`;return null!=this.args_string&&this.args_string.length>0&&(e+=`?${this.args_string}`),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise(((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)}))}catch(e){throw r.logger.error(`websocket creation failed to url: ${this.url}`),r.logger.error(` - ${e}`),e}}close(){this.closed_permanently||(r.logger.debug(`Permanently closing websocket connection ${this._number}`),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,`close method called on ClientConnection ${this._number}`),this.session._connection_closed())}_schedule_reconnect(e){setTimeout((()=>{this.closed_permanently||r.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)}),e)}send(e){if(null==this.socket)throw new Error(`not connected so cannot send ${e}`);e.send(this.socket)}async send_with_reply(e){const s=await new Promise(((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)}));if("ERROR"===s.msgtype())throw new Error(`Error reply ${s.content.text}`);return s}async _pull_doc_json(){const e=c.Message.create("PULL-DOC-REQ",{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){var n;r.logger.debug(this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)r.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=i.Document.from_json(n),t=i.Document._compute_patch_since_json(n,s);if(t.events.length>0){r.logger.debug(`Sending ${t.events.length} changes from model construction back to server`);const e=c.Message.create("PATCH-DOC",{},t);this.send(e)}this.session=new _.ClientSession(this,s,this.id);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],r.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),r.logger.debug("Updated existing session with new pulled doc")}catch(e){null===(n=console.trace)||void 0===n||n.call(console,e),r.logger.error(`Failed to repull session ${e}`),s(e instanceof Error?e:`${e}`)}}_on_open(e,s){r.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&r.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(`${e}`)}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){r.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach((e=>e.reject("Disconnected"))),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){r.logger.debug(`Websocket error on socket ${this._number}`);const s="Could not open websocket";r.logger.error(`Failed to connect to Bokeh server: ${s}`),e(new Error(s))}_close_bad_protocol(e){r.logger.error(`Closing connection: ${e}`),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);n?(this._pending_replies.delete(s),n.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=d,d.__name__="ClientConnection",n.pull_session=function(e,s,n){return new d(e,s,n).connect()}},
function _(e,s,t,r,n){r();const i=e(34);class a{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this.buffers=new Map}static assemble(e,s,t){const r=JSON.parse(e),n=JSON.parse(s),i=JSON.parse(t);return new a(r,n,i)}assemble_buffer(e,s){const t=null!=this.header.num_buffers?this.header.num_buffers:0;if(t<=this.buffers.size)throw new Error(`too many buffers received, expecting ${t}`);const{id:r}=JSON.parse(e);this.buffers.set(r,s)}static create(e,s,t={}){const r=a.create_header(e);return new a(r,s,t)}static create_header(e){return{msgid:i.uniqueId(),msgtype:e}}complete(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)}send(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");const s=JSON.stringify(this.header),t=JSON.stringify(this.metadata),r=JSON.stringify(this.content);e.send(s),e.send(t),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=a,a.__name__="Message"},
function _(e,t,s,_,r){_();const i=e(399),h=e(8);class a{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(e){this._current_consumer(e)}_HEADER(e){this._assume_text(e),this.message=null,this._partial=null,this._fragments=[e],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(e){this._assume_text(e),this._fragments.push(e),this._current_consumer=this._CONTENT}_CONTENT(e){this._assume_text(e),this._fragments.push(e);const[t,s,_]=this._fragments.slice(0,3);this._partial=i.Message.assemble(t,s,_),this._check_complete()}_BUFFER_HEADER(e){this._assume_text(e),this._buf_header=e,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(e){this._assume_binary(e),this._partial.assemble_buffer(this._buf_header,e),this._check_complete()}_assume_text(e){if(!h.isString(e))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(e){if(!(e instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=a,a.__name__="Receiver"},
function _(e,t,n,s,o){s();const c=e(5),i=e(399),_=e(19);class r{constructor(e,t,n){this._connection=e,this.document=t,this.id=n,this._document_listener=e=>{this._document_changed(e)},this.document.on_change(this._document_listener,!0)}handle(e){const t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):_.logger.debug(`Doing nothing with message ${e.msgtype()}`)}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=i.Message.create("SERVER-INFO-REQ",{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){if(e.setter_id===this.id)return;const t=e instanceof c.DocumentEventBatch?e.events:[e],n=this.document.create_json_patch(t),s=i.Message.create("PATCH-DOC",{},n);this._connection.send(s)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers,this.id)}_handle_ok(e){_.logger.trace(`Unhandled OK reply to ${e.reqid()}`)}_handle_error(e){_.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}n.ClientSession=r,r.__name__="ClientSession"},
function _(e,o,t,n,r){n();const s=e(1),l=e(5),i=e(400),a=e(19),c=e(43),g=e(13),f=e(395),u=e(396),m=s.__importDefault(e(44)),p=s.__importDefault(e(253)),d=s.__importDefault(e(403));function _(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function b(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){a.logger.info(`Registering Jupyter comms for target ${e}`);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,(t=>{a.logger.info(`Registering Jupyter comms for target ${e}`);const n=new i.Receiver;t.on_msg(_.bind(o,n))}))}catch(e){a.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){a.logger.info(`Registering JupyterLab comms for target ${e}`);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,(t=>{a.logger.info(`Registering JupyterLab comms for target ${e}`);const n=new i.Receiver;t.onMsg=_.bind(o,n)}))}catch(e){a.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){a.logger.info(`Registering Google Colab comms for target ${e}`);const t=google.colab.kernel.comms;try{t.registerTarget(e,(async t=>{var n,r,l;a.logger.info(`Registering Google Colab comms for target ${e}`);const c=new i.Receiver;try{for(var g,f=s.__asyncValues(t.messages);!(g=await f.next()).done;){const e=g.value,t={data:e.data},n=[];for(const o of null!==(l=e.buffers)&&void 0!==l?l:[])n.push(new DataView(o));const r={content:t,buffers:n};_.bind(o)(c,r)}}catch(e){n={error:e}}finally{try{g&&!g.done&&(r=f.return)&&await r.call(f)}finally{if(n)throw n.error}}}))}catch(e){a.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}c.stylesheet.append(m.default),c.stylesheet.append(p.default),c.stylesheet.append(d.default),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=g.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=l.Document.from_json(g.values(e)[0]);for(const e of o){null!=e.notebook_comms_target&&b(e.notebook_comms_target,t);const o=u._resolve_element(e),n=u._resolve_root_elements(e);f.add_document_standalone(t,o,n)}}},
function _(t,o,r,e,d){e(),r.root="bk-root",r.tooltip="bk-tooltip",r.default=".rendered_html .bk-root .bk-tooltip table,.rendered_html .bk-root .bk-tooltip tr,.rendered_html .bk-root .bk-tooltip th,.rendered_html .bk-root .bk-tooltip td{border:none;padding:1px;}"},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(399),o),a.__exportStar(t(400),o)},
function _(e,t,n,s,o){function l(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}s(),n.results={},n.init=function(){l()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,l()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,l()}},
function _(e,t,o,n,l){n(),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",(()=>s.removeChild(t)));const n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));const l=document.createElement("pre");l.style.whiteSpace="unset",l.style.overflowX="auto",l.appendChild(document.createTextNode(e)),t.appendChild(o),t.appendChild(n),t.appendChild(l);const s=document.getElementsByTagName("body")[0];s.insertBefore(t,s.firstChild)}(e instanceof Error&&e.stack?e.stack:`${e}`),t)return;throw e}}},
], 0, {"main":0,"tslib":1,"index":2,"version":3,"embed/index":4,"document/index":5,"document/document":6,"base":7,"core/util/types":8,"core/util/array":9,"core/util/math":10,"core/util/assert":11,"core/util/arrayable":12,"core/util/object":13,"core/has_props":14,"core/signaling":15,"core/util/defer":16,"core/util/refs":17,"core/properties":18,"core/logging":19,"core/enums":20,"core/kinds":21,"core/util/color":22,"core/util/svg_colors":23,"core/types":24,"core/util/bitset":25,"core/util/eq":26,"core/util/platform":27,"core/settings":28,"core/util/ndarray":29,"core/serializer":30,"core/util/serialization":31,"core/util/buffer":32,"core/uniforms":33,"core/util/string":34,"document/events":35,"core/util/pretty":36,"core/util/cloneable":37,"models/index":38,"models/annotations/index":39,"models/annotations/annotation":40,"models/renderers/renderer":41,"core/view":42,"core/dom":43,"styles/root.css":44,"core/visuals/index":45,"core/visuals/line":46,"core/visuals/visual":47,"core/property_mixins":48,"core/visuals/fill":49,"core/visuals/text":50,"core/visuals/hatch":51,"core/visuals/patterns":52,"model":53,"models/canvas/coordinates":54,"models/annotations/arrow":55,"models/annotations/data_annotation":56,"models/sources/columnar_data_source":57,"models/sources/data_source":58,"models/selections/selection":59,"core/selection_manager":60,"models/renderers/glyph_renderer":61,"models/renderers/data_renderer":62,"models/glyphs/line":63,"models/glyphs/xy_glyph":64,"core/util/projections":65,"models/glyphs/glyph":98,"core/util/bbox":99,"core/util/ragged_array":100,"core/util/spatial":101,"models/ranges/factor_range":104,"models/ranges/range":105,"models/glyphs/utils":106,"core/hittest":107,"models/glyphs/webgl/line":108,"models/glyphs/webgl/utils/index":109,"models/glyphs/webgl/utils/program":110,"models/glyphs/webgl/utils/buffer":111,"models/glyphs/webgl/utils/texture":112,"models/glyphs/webgl/base":113,"models/glyphs/webgl/line.vert":114,"models/glyphs/webgl/line.frag":115,"models/glyphs/patch":116,"models/glyphs/harea":117,"models/glyphs/area":118,"models/glyphs/varea":119,"models/sources/cds_view":120,"models/filters/filter":121,"core/build_views":122,"models/renderers/graph_renderer":123,"models/expressions/expression":124,"models/graphs/layout_provider":125,"models/graphs/graph_hit_test_policy":126,"models/glyphs/multi_line":127,"models/glyphs/patches":128,"models/selections/interaction_policy":129,"models/sources/column_data_source":130,"core/util/typed_array":131,"core/util/set":132,"models/annotations/arrow_head":133,"models/annotations/band":134,"models/annotations/upper_lower":135,"models/annotations/box_annotation":136,"models/annotations/color_bar":137,"models/annotations/title":138,"models/annotations/text_annotation":139,"core/layout/side_panel":140,"core/layout/types":141,"core/layout/layoutable":142,"core/util/text":143,"models/canvas/cartesian_frame":144,"models/scales/categorical_scale":145,"models/scales/scale":146,"models/transforms/index":147,"models/transforms/customjs_transform":148,"models/transforms/transform":149,"models/transforms/dodge":150,"models/transforms/range_transform":151,"models/transforms/interpolator":152,"models/transforms/jitter":153,"models/transforms/linear_interpolator":154,"models/transforms/step_interpolator":155,"models/ranges/range1d":156,"models/scales/log_scale":157,"models/scales/continuous_scale":158,"models/ranges/data_range1d":159,"models/ranges/data_range":160,"models/util":161,"models/axes/index":162,"models/axes/axis":163,"models/renderers/guide_renderer":164,"models/tickers/ticker":165,"models/formatters/tick_formatter":166,"core/graphics":167,"core/util/affine":168,"models/policies/labeling":169,"models/axes/categorical_axis":170,"models/tickers/categorical_ticker":171,"models/formatters/categorical_tick_formatter":172,"models/axes/continuous_axis":173,"models/axes/datetime_axis":174,"models/axes/linear_axis":175,"models/formatters/basic_tick_formatter":176,"models/tickers/basic_ticker":177,"models/tickers/adaptive_ticker":178,"models/tickers/continuous_ticker":179,"models/formatters/datetime_tick_formatter":180,"core/util/templating":182,"models/tickers/datetime_ticker":185,"models/tickers/composite_ticker":186,"models/tickers/days_ticker":187,"models/tickers/single_interval_ticker":188,"models/tickers/util":189,"models/tickers/months_ticker":190,"models/tickers/years_ticker":191,"models/axes/log_axis":192,"models/formatters/log_tick_formatter":193,"models/tickers/log_ticker":194,"models/axes/mercator_axis":195,"models/formatters/mercator_tick_formatter":196,"models/tickers/mercator_ticker":197,"models/tickers/index":198,"models/tickers/fixed_ticker":199,"models/tickers/binned_ticker":200,"models/mappers/scanning_color_mapper":201,"models/mappers/continuous_color_mapper":202,"models/mappers/color_mapper":203,"models/mappers/mapper":204,"models/formatters/index":205,"models/formatters/func_tick_formatter":206,"models/formatters/numeral_tick_formatter":207,"models/formatters/printf_tick_formatter":208,"models/mappers/index":209,"models/mappers/categorical_color_mapper":210,"models/mappers/categorical_mapper":211,"models/mappers/categorical_marker_mapper":212,"models/mappers/categorical_pattern_mapper":213,"models/mappers/linear_color_mapper":214,"models/mappers/log_color_mapper":215,"models/mappers/eqhist_color_mapper":216,"models/scales/index":217,"models/scales/linear_scale":218,"models/scales/linear_interpolation_scale":219,"models/ranges/index":220,"core/layout/index":221,"core/layout/alignments":222,"core/layout/grid":223,"core/layout/html":224,"core/layout/border":225,"models/annotations/label":226,"models/annotations/label_set":227,"models/annotations/legend":228,"models/annotations/legend_item":229,"core/vectorization":230,"models/annotations/poly_annotation":231,"models/annotations/slope":232,"models/annotations/span":233,"models/annotations/toolbar_panel":234,"models/tools/toolbar":235,"models/tools/tool":236,"models/tools/gestures/gesture_tool":237,"models/tools/button_tool":238,"core/dom_view":240,"styles/toolbar.css":241,"styles/icons.css":242,"styles/menus.css":243,"core/util/menus":244,"core/util/iterator":245,"models/tools/on_off_button":246,"models/tools/inspectors/inspect_tool":247,"models/tools/toolbar_base":248,"core/util/canvas":249,"core/util/svg":250,"models/tools/actions/action_tool":251,"models/tools/actions/help_tool":252,"styles/logo.css":253,"models/annotations/tooltip":254,"styles/tooltips.css":255,"models/annotations/whisker":256,"models/callbacks/index":257,"models/callbacks/customjs":258,"models/callbacks/callback":259,"models/callbacks/open_url":260,"models/canvas/index":261,"models/canvas/canvas":262,"core/ui_events":263,"core/bokeh_events":264,"core/util/wheel":265,"models/expressions/index":266,"models/expressions/customjs_expr":267,"models/expressions/stack":268,"models/expressions/cumsum":269,"models/expressions/minimum":270,"models/expressions/maximum":271,"models/filters/index":272,"models/filters/boolean_filter":273,"models/filters/customjs_filter":274,"models/filters/group_filter":275,"models/filters/index_filter":276,"models/glyphs/index":277,"models/glyphs/annular_wedge":278,"models/glyphs/annulus":279,"models/glyphs/arc":280,"models/glyphs/bezier":281,"models/glyphs/circle":282,"models/glyphs/webgl/markers":283,"models/glyphs/webgl/markers.vert":284,"models/glyphs/webgl/markers.frag":285,"models/glyphs/ellipse":286,"models/glyphs/ellipse_oval":287,"models/glyphs/center_rotatable":288,"models/glyphs/hbar":289,"models/glyphs/box":290,"models/glyphs/hex_tile":291,"models/glyphs/image":292,"models/glyphs/image_base":293,"models/glyphs/image_rgba":294,"models/glyphs/image_url":295,"core/util/image":296,"models/glyphs/multi_polygons":297,"models/glyphs/oval":298,"models/glyphs/quad":299,"models/glyphs/quadratic":300,"models/glyphs/ray":301,"models/glyphs/rect":302,"models/glyphs/scatter":303,"models/glyphs/marker":304,"models/glyphs/defs":305,"models/glyphs/segment":306,"models/glyphs/spline":307,"core/util/interpolation":308,"models/glyphs/step":309,"models/glyphs/text":310,"models/glyphs/vbar":311,"models/glyphs/wedge":312,"models/graphs/index":313,"models/graphs/static_layout_provider":314,"models/grids/index":315,"models/grids/grid":316,"models/layouts/index":317,"models/layouts/box":318,"models/layouts/layout_dom":319,"models/layouts/column":320,"models/layouts/grid_box":321,"models/layouts/html_box":322,"models/layouts/panel":323,"models/layouts/row":324,"models/layouts/spacer":325,"models/layouts/tabs":326,"styles/tabs.css":327,"styles/buttons.css":328,"models/layouts/widget_box":329,"models/plots/index":330,"models/plots/gmap_plot":331,"models/plots/plot":332,"models/plots/plot_canvas":333,"core/util/throttle":334,"models/plots/range_manager":335,"models/plots/state_manager":336,"models/plots/gmap_plot_canvas":337,"models/policies/index":338,"models/renderers/index":339,"models/selections/index":340,"models/sources/index":341,"models/sources/server_sent_data_source":342,"models/sources/web_data_source":343,"models/sources/ajax_data_source":344,"models/sources/geojson_data_source":345,"models/tiles/index":346,"models/tiles/bbox_tile_source":347,"models/tiles/mercator_tile_source":348,"models/tiles/tile_source":349,"models/tiles/tile_utils":350,"models/tiles/quadkey_tile_source":351,"models/tiles/tile_renderer":352,"models/tiles/wmts_tile_source":353,"styles/tiles.css":354,"models/tiles/tms_tile_source":355,"models/textures/index":356,"models/textures/canvas_texture":357,"models/textures/texture":358,"models/textures/image_url_texture":359,"models/tools/index":360,"models/tools/actions/custom_action":361,"models/tools/actions/redo_tool":362,"models/tools/actions/reset_tool":363,"models/tools/actions/save_tool":364,"models/tools/actions/undo_tool":365,"models/tools/actions/zoom_in_tool":366,"models/tools/actions/zoom_base_tool":367,"core/util/zoom":368,"models/tools/actions/zoom_out_tool":369,"models/tools/edit/edit_tool":370,"models/tools/edit/box_edit_tool":371,"models/tools/edit/freehand_draw_tool":372,"models/tools/edit/point_draw_tool":373,"models/tools/edit/poly_draw_tool":374,"models/tools/edit/poly_tool":375,"models/tools/edit/poly_edit_tool":376,"models/tools/gestures/box_select_tool":377,"models/tools/gestures/select_tool":378,"models/tools/gestures/box_zoom_tool":379,"models/tools/gestures/lasso_select_tool":380,"models/tools/gestures/poly_select_tool":381,"models/tools/edit/line_edit_tool":382,"models/tools/edit/line_tool":383,"models/tools/gestures/pan_tool":384,"models/tools/gestures/range_tool":385,"models/tools/gestures/tap_tool":386,"models/tools/gestures/wheel_pan_tool":387,"models/tools/gestures/wheel_zoom_tool":388,"models/tools/inspectors/crosshair_tool":389,"models/tools/inspectors/customjs_hover":390,"models/tools/inspectors/hover_tool":391,"models/tools/tool_proxy":392,"models/tools/toolbar_box":393,"document/defs":394,"embed/standalone":395,"embed/dom":396,"embed/server":397,"client/connection":398,"protocol/message":399,"protocol/receiver":400,"client/session":401,"embed/notebook":402,"styles/notebook.css":403,"protocol/index":404,"testing":405,"safely":406}, {});});
