(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define gerbil/tools/gxpkg#main
    (lambda _args1762_
      (letrec* ((_install-cmd1764_
                 (std/getopt#command__%
                  '#f
                  '"install one or more packages"
                  'install
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to install"
                   absent-value
                   'pkg)))
                (_uninstall-cmd1765_
                 (std/getopt#command__%
                  '#f
                  '"uninstall one or more packages"
                  'uninstall
                  (std/getopt#flag__%__0
                   '#f
                   '"force uninstall even if there are orphaned dependencies"
                   'force
                   '"-f")
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to uninstall"
                   absent-value
                   'pkg)))
                (_update-cmd1766_
                 (std/getopt#command__%
                  '#f
                  '"update one or more packages"
                  'update
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to update; all for all packages"
                   absent-value
                   'pkg)))
                (_link-cmd1767_
                 (std/getopt#command__%
                  '#f
                  '"link a local development package"
                  'link
                  (std/getopt#argument__%
                   '#f
                   '"package to link"
                   absent-value
                   'pkg)
                  (std/getopt#argument__%
                   '#f
                   '"path to package source directory"
                   absent-value
                   'src)))
                (_unlink-cmd1768_
                 (std/getopt#command__%
                  '#f
                  '"unlink one or more local development packages"
                  'unlink
                  (std/getopt#flag__%__0
                   '#f
                   '"force unlink even if there are orphaned dependencies"
                   'force
                   '"-f")
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to unlink"
                   absent-value
                   'pkg)))
                (_build-cmd1769_
                 (std/getopt#command__%
                  '#f
                  '"rebuild one or more packages and their dependents"
                  'build
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to build; all for all packages"
                   absent-value
                   'pkg)))
                (_clean-cmd1770_
                 (std/getopt#command__%
                  '#f
                  '"clean compilation artefacts from one or more packages"
                  'clean
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to clean"
                   absent-value
                   'pkg)))
                (_list-cmd1771_
                 (std/getopt#command__% '#f '"list installed packages" 'list))
                (_retag-cmd1772_
                 (std/getopt#command__%
                  '#f
                  '"retag installed packages"
                  'retag))
                (_search-cmd1773_
                 (std/getopt#command__%
                  '#f
                  '"search the package directory"
                  'search
                  (std/getopt#rest-arguments__%
                   '#f
                   '"keywords to search for"
                   absent-value
                   'keywords)))
                (_help-cmd1774_
                 (std/getopt#command__%
                  '#f
                  '"display help; help <command> for command help"
                  'help
                  (std/getopt#optional-argument__%
                   '#f
                   absent-value
                   string->symbol
                   absent-value
                   'command)))
                (_gopt1775_
                 (std/getopt#getopt
                  _install-cmd1764_
                  _uninstall-cmd1765_
                  _update-cmd1766_
                  _link-cmd1767_
                  _unlink-cmd1768_
                  _build-cmd1769_
                  _clean-cmd1770_
                  _list-cmd1771_
                  _retag-cmd1772_
                  _search-cmd1773_
                  _help-cmd1774_)))
        (with-exception-catcher
         (lambda (_g17761778_)
           (if ((lambda (_$obj1781_)
                  (let ()
                    (declare (not safe))
                    (##structure-instance-of?
                     _$obj1781_
                     'std/getopt#getopt-error::t)))
                _g17761778_)
               (let ((_exn1784_ _g17761778_))
                 (std/getopt#getopt-display-help__%
                  _exn1784_
                  '"gxpkg"
                  (current-error-port))
                 (exit '1))
               (if '#t
                   (let ((_e1786_ _g17761778_))
                     (display-exception _e1786_ (current-error-port))
                     (exit '2))
                   (raise _g17761778_))))
         (lambda ()
           (let ((_g5919_ (std/getopt#getopt-parse _gopt1775_ _args1762_)))
             (begin
               (let ((_g5920_ (let ()
                                (declare (not safe))
                                (if (##values? _g5919_)
                                    (##vector-length _g5919_)
                                    1))))
                 (if (not (let () (declare (not safe)) (##fx= _g5920_ 2)))
                     (error "Context expects 2 values" _g5920_)))
               (let ((_cmd1789_
                      (let () (declare (not safe)) (##vector-ref _g5919_ 0)))
                     (_opt1790_
                      (let () (declare (not safe)) (##vector-ref _g5919_ 1))))
                 (let* ((_ht1792_ _opt1790_) (_$e2045_ _cmd1789_))
                   (if (eq? 'install _$e2045_)
                       (gerbil/tools/gxpkg#install-pkgs
                        (table-ref _ht1792_ 'pkg))
                       (if (eq? 'uninstall _$e2045_)
                           (gerbil/tools/gxpkg#uninstall-pkgs
                            (table-ref _ht1792_ 'pkg)
                            (table-ref _ht1792_ 'force '#f))
                           (if (eq? 'update _$e2045_)
                               (gerbil/tools/gxpkg#update-pkgs
                                (table-ref _ht1792_ 'pkg))
                               (if (eq? 'link _$e2045_)
                                   (gerbil/tools/gxpkg#pkg-link
                                    (table-ref _ht1792_ 'pkg)
                                    (table-ref _ht1792_ 'src))
                                   (if (eq? 'unlink _$e2045_)
                                       (gerbil/tools/gxpkg#unlink-pkgs
                                        (table-ref _ht1792_ 'pkg)
                                        (table-ref _ht1792_ 'force '#f))
                                       (if (eq? 'build _$e2045_)
                                           (gerbil/tools/gxpkg#build-pkgs
                                            (table-ref _ht1792_ 'pkg))
                                           (if (eq? 'clean _$e2045_)
                                               (gerbil/tools/gxpkg#clean-pkgs
                                                (table-ref _ht1792_ 'pkg))
                                               (if (eq? 'list _$e2045_)
                                                   (gerbil/tools/gxpkg#list-pkgs)
                                                   (if (eq? 'retag _$e2045_)
                                                       (gerbil/tools/gxpkg#pkg-retag)
                                                       (if (eq? 'search
                                                                _$e2045_)
                                                           (gerbil/tools/gxpkg#pkg-search
                                                            (table-ref
                                                             _ht1792_
                                                             'keywords))
                                                           (if (eq? 'help
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _$e2045_)
                       (std/getopt#getopt-display-help-topic__0
                        _gopt1775_
                        (table-ref _ht1792_ 'command '#f)
                        '"gxkpg")
                       '#!void))))))))))))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
  (define gerbil/tools/gxpkg#install-pkgs
    (lambda (_pkgs1718_)
      (if (let _lp1720_ ((_rest1723_ _pkgs1718_) (_result1725_ '#f))
            (let* ((_rest17271735_ _rest1723_)
                   (_else17291743_ (lambda () _result1725_))
                   (_K17311750_
                    (lambda (_rest1746_ _pkg1747_)
                      (if (gerbil/tools/gxpkg#pkg-install _pkg1747_)
                          (_lp1720_ _rest1746_ '#t)
                          (_lp1720_ _rest1746_ _result1725_)))))
              (if (let () (declare (not safe)) (##pair? _rest17271735_))
                  (let ((_hd17321753_
                         (let () (declare (not safe)) (##car _rest17271735_)))
                        (_tl17331755_
                         (let () (declare (not safe)) (##cdr _rest17271735_))))
                    (let* ((_pkg1758_ _hd17321753_) (_rest1760_ _tl17331755_))
                      (_K17311750_ _rest1760_ _pkg1758_)))
                  (_else17291743_))))
          (gerbil/tools/gxpkg#pkg-retag)
          '#!void)))
  (define gerbil/tools/gxpkg#uninstall-pkgs
    (lambda (_pkgs1673_ _force?1674_)
      (if (let _lp1676_ ((_rest1679_ _pkgs1673_) (_result1681_ '#f))
            (let* ((_rest16831691_ _rest1679_)
                   (_else16851699_ (lambda () _result1681_))
                   (_K16871706_
                    (lambda (_rest1702_ _pkg1703_)
                      (if (gerbil/tools/gxpkg#pkg-uninstall__%
                           _pkg1703_
                           _force?1674_)
                          (_lp1676_ _rest1702_ '#t)
                          (_lp1676_ _rest1702_ _result1681_)))))
              (if (let () (declare (not safe)) (##pair? _rest16831691_))
                  (let ((_hd16881709_
                         (let () (declare (not safe)) (##car _rest16831691_)))
                        (_tl16891711_
                         (let () (declare (not safe)) (##cdr _rest16831691_))))
                    (let* ((_pkg1714_ _hd16881709_) (_rest1716_ _tl16891711_))
                      (_K16871706_ _rest1716_ _pkg1714_)))
                  (_else16851699_))))
          (gerbil/tools/gxpkg#pkg-retag)
          '#!void)))
  (define gerbil/tools/gxpkg#update-pkgs
    (lambda (_pkgs1627_)
      (if (let _lp1629_ ((_rest1632_ _pkgs1627_) (_result1634_ '#f))
            (let* ((_rest16361644_ _rest1632_)
                   (_else16381652_ (lambda () _result1634_))
                   (_K16401659_
                    (lambda (_rest1655_ _pkg1656_)
                      (if (gerbil/tools/gxpkg#pkg-update _pkg1656_)
                          (_lp1629_ _rest1655_ '#t)
                          (_lp1629_ _rest1655_ _result1634_)))))
              (if (let () (declare (not safe)) (##pair? _rest16361644_))
                  (let ((_hd16411662_
                         (let () (declare (not safe)) (##car _rest16361644_)))
                        (_tl16421664_
                         (let () (declare (not safe)) (##cdr _rest16361644_))))
                    (let* ((_pkg1667_ _hd16411662_) (_rest1669_ _tl16421664_))
                      (_K16401659_ _rest1669_ _pkg1667_)))
                  (_else16381652_))))
          (begin
            (for-each
             (lambda (_pkg1671_)
               (if (equal? _pkg1671_ '"all")
                   (for-each
                    gerbil/tools/gxpkg#pkg-install-deps
                    (gerbil/tools/gxpkg#pkg-list))
                   (gerbil/tools/gxpkg#pkg-install-deps _pkg1671_)))
             _pkgs1627_)
            (for-each gerbil/tools/gxpkg#pkg-build _pkgs1627_)
            (gerbil/tools/gxpkg#pkg-retag))
          '#!void)))
  (define gerbil/tools/gxpkg#link-pkg
    (lambda (_pkg1624_ _src1625_)
      (gerbil/tools/gxpkg#pkg-link _pkg1624_ _src1625_)))
  (define gerbil/tools/gxpkg#unlink-pkgs
    (lambda (_pkgs1617_ _force?1618_)
      (for-each
       (lambda (_g16191621_)
         (gerbil/tools/gxpkg#pkg-unlink__% _g16191621_ _force?1618_))
       _pkgs1617_)))
  (define gerbil/tools/gxpkg#build-pkgs
    (lambda (_pkgs1615_) (for-each gerbil/tools/gxpkg#pkg-build _pkgs1615_)))
  (define gerbil/tools/gxpkg#clean-pkgs
    (lambda (_pkgs1613_) (for-each gerbil/tools/gxpkg#pkg-clean _pkgs1613_)))
  (define gerbil/tools/gxpkg#list-pkgs
    (lambda () (for-each displayln (gerbil/tools/gxpkg#pkg-list))))
  (define gerbil/tools/gxpkg#retag-pkgs
    (lambda () (gerbil/tools/gxpkg#pkg-retag)))
  (define gerbil/tools/gxpkg#search-pkgs
    (lambda (_keywords1609_) (gerbil/tools/gxpkg#pkg-search _keywords1609_)))
  (define gerbil/tools/gxpkg#+root-dir+ (getenv '"GERBIL_PATH" '"~/.gerbil"))
  (define gerbil/tools/gxpkg#+pkg-root-dir+
    (path-expand '"pkg" gerbil/tools/gxpkg#+root-dir+))
  (define gerbil/tools/gxpkg#+pkg-lib-dir+
    (path-expand '"lib" gerbil/tools/gxpkg#+root-dir+))
  (define gerbil/tools/gxpkg#+pkg-lib-static-dir+
    (path-expand '"static" gerbil/tools/gxpkg#+pkg-lib-dir+))
  (define gerbil/tools/gxpkg#+pkg-bin-dir+
    (path-expand '"bin" gerbil/tools/gxpkg#+root-dir+))
  (define gerbil/tools/gxpkg#pkg-root-dir
    (let ((_once1606_
           (make-promise
            (lambda ()
              (create-directory* gerbil/tools/gxpkg#+root-dir+)
              (create-directory* gerbil/tools/gxpkg#+pkg-root-dir+)
              (create-directory* gerbil/tools/gxpkg#+pkg-lib-dir+)
              (create-directory* gerbil/tools/gxpkg#+pkg-lib-static-dir+)
              (create-directory* gerbil/tools/gxpkg#+pkg-bin-dir+)))))
      (lambda () (force _once1606_) gerbil/tools/gxpkg#+pkg-root-dir+)))
  (define gerbil/tools/gxpkg#pkg-install
    (lambda (_pkg1593_)
      (letrec ((_git-clone-url1595_
                (lambda (_pkg1603_)
                  (string-append '"https://" _pkg1603_ '".git"))))
        (if (or (string-prefix? '"github.com/" _pkg1593_)
                (string-prefix? '"gitlab.com/" _pkg1593_)
                (string-prefix? '"bitbucket.org/" _pkg1593_))
            (gerbil/tools/gxpkg#pkg-install-git
             _pkg1593_
             (_git-clone-url1595_ _pkg1593_))
            (error '"Unknown package provider" _pkg1593_)))))
  (define gerbil/tools/gxpkg#pkg-install-git
    (lambda (_pkg1583_ _clone-url1584_)
      (let* ((_root1586_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest1588_ (path-expand _pkg1583_ _root1586_)))
        (if (file-exists? _dest1588_)
            '#f
            (let ((_path1591_ (path-directory _dest1588_)))
              (displayln '"... install " _pkg1583_)
              (create-directory* _path1591_)
              (std/misc/process#run-process__%
               '#f
               void
               absent-value
               absent-value
               _path1591_
               absent-value
               '#f
               absent-value
               absent-value
               absent-value
               (cons '"git"
                     (cons '"clone" (cons '"-q" (cons _clone-url1584_ '())))))
              (gerbil/tools/gxpkg#pkg-install-deps _pkg1583_)
              (gerbil/tools/gxpkg#pkg-build__0 _pkg1583_)
              '#t)))))
  (define gerbil/tools/gxpkg#pkg-install-deps
    (lambda (_pkg1576_)
      (let* ((_plist1578_ (gerbil/tools/gxpkg#pkg-plist _pkg1576_))
             (_deps1580_ (pgetq 'depend: _plist1578_ '())))
        (for-each gerbil/tools/gxpkg#pkg-install _deps1580_))))
  (define gerbil/tools/gxpkg#pkg-uninstall__%
    (lambda (_pkg1556_ _force?1557_)
      (let* ((_root1559_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest1561_ (path-expand _pkg1556_ _root1559_)))
        (if (file-exists? _dest1561_)
            (if (not (gerbil/tools/gxpkg#file-symbolic-link? _dest1561_))
                (begin
                  (if _force?1557_
                      '#!void
                      (let ((_deps1564_
                             (gerbil/tools/gxpkg#pkg-dependents__0 _pkg1556_)))
                        (if (null? _deps1564_)
                            '#!void
                            (error '"Refuse to uninstall package; orphaned dependencies"
                                   _deps1564_))))
                  (gerbil/tools/gxpkg#pkg-clean _pkg1556_)
                  (displayln '"... uninstall " _pkg1556_)
                  (std/misc/process#run-process__%
                   '#f
                   void
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   (cons '"rm"
                         (cons '"-rf" (cons (path-normalize _dest1561_) '()))))
                  '#t)
                '#f)
            '#f))))
  (define gerbil/tools/gxpkg#pkg-uninstall__0
    (lambda (_pkg1569_)
      (let ((_force?1571_ '#f))
        (gerbil/tools/gxpkg#pkg-uninstall__% _pkg1569_ _force?1571_))))
  (define gerbil/tools/gxpkg#pkg-uninstall
    (lambda _g5922_
      (let ((_g5921_ (let () (declare (not safe)) (##length _g5922_))))
        (cond ((let () (declare (not safe)) (##fx= _g5921_ 1))
               (apply gerbil/tools/gxpkg#pkg-uninstall__0 _g5922_))
              ((let () (declare (not safe)) (##fx= _g5921_ 2))
               (apply gerbil/tools/gxpkg#pkg-uninstall__% _g5922_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-uninstall
                _g5922_))))))
  (define gerbil/tools/gxpkg#pkg-update
    (lambda (_pkg1505_)
      (if (equal? _pkg1505_ '"all")
          (let _lp1507_ ((_rest1510_ (gerbil/tools/gxpkg#pkg-list))
                         (_result1512_ '#f))
            (let* ((_rest15141522_ _rest1510_)
                   (_else15161530_ (lambda () _result1512_))
                   (_K15181537_
                    (lambda (_rest1533_ _pkg1534_)
                      (if (gerbil/tools/gxpkg#pkg-update _pkg1534_)
                          (_lp1507_ _rest1533_ '#t)
                          (_lp1507_ _rest1533_ _result1512_)))))
              (if (let () (declare (not safe)) (##pair? _rest15141522_))
                  (let ((_hd15191540_
                         (let () (declare (not safe)) (##car _rest15141522_)))
                        (_tl15201542_
                         (let () (declare (not safe)) (##cdr _rest15141522_))))
                    (let* ((_pkg1545_ _hd15191540_) (_rest1547_ _tl15201542_))
                      (_K15181537_ _rest1547_ _pkg1545_)))
                  (_else15161530_))))
          (if (or (string-prefix? '"github.com/" _pkg1505_)
                  (string-prefix? '"gitlab.com/" _pkg1505_)
                  (string-prefix? '"bitbucket.org/" _pkg1505_))
              (gerbil/tools/gxpkg#pkg-update-git _pkg1505_)
              (error '"Unknown package provider" _pkg1505_)))))
  (define gerbil/tools/gxpkg#pkg-update-git
    (lambda (_pkg1493_)
      (let* ((_root1495_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest1497_ (path-expand _pkg1493_ _root1495_)))
        (if (file-exists? _dest1497_)
            '#!void
            (error '"Cannot update uknown package" _pkg1493_))
        (if (not (gerbil/tools/gxpkg#file-symbolic-link? _dest1497_))
            (begin
              (displayln '"... update " _pkg1493_)
              (let* ((_result1500_
                      (std/misc/process#run-process__%
                       '#f
                       absent-value
                       absent-value
                       absent-value
                       _dest1497_
                       absent-value
                       absent-value
                       absent-value
                       absent-value
                       absent-value
                       (cons '"git" (cons '"pull" '()))))
                     (_update?1502_
                      (not (equal? _result1500_ '"Already up-to-date.\n"))))
                _update?1502_))
            '#f))))
  (define gerbil/tools/gxpkg#pkg-link
    (lambda (_pkg1485_ _src1486_)
      (let* ((_root1488_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest1490_ (path-expand _pkg1485_ _root1488_)))
        (if (file-exists? _dest1490_)
            (error '"Cannot link package; destination already exists"
                   _pkg1485_
                   _dest1490_)
            '#!void)
        (create-directory* (path-directory _dest1490_))
        (create-symbolic-link _src1486_ _dest1490_))))
  (define gerbil/tools/gxpkg#pkg-unlink__%
    (lambda (_pkg1465_ _force?1466_)
      (let* ((_root1468_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest1470_ (path-expand _pkg1465_ _root1468_)))
        (if (file-exists? _dest1470_)
            (begin
              (if (gerbil/tools/gxpkg#file-symbolic-link? _dest1470_)
                  '#!void
                  (error '"Cannot unlink package; not a symbolic link"
                         _dest1470_))
              (if _force?1466_
                  '#!void
                  (let ((_deps1473_
                         (gerbil/tools/gxpkg#pkg-dependents__0 _pkg1465_)))
                    (if (null? _deps1473_)
                        '#!void
                        (error '"Refuse to unlink package; orphaned dependencies"
                               _deps1473_))))
              (gerbil/tools/gxpkg#pkg-clean _pkg1465_)
              (delete-file _dest1470_))
            '#!void))))
  (define gerbil/tools/gxpkg#pkg-unlink__0
    (lambda (_pkg1478_)
      (let ((_force?1480_ '#f))
        (gerbil/tools/gxpkg#pkg-unlink__% _pkg1478_ _force?1480_))))
  (define gerbil/tools/gxpkg#pkg-unlink
    (lambda _g5924_
      (let ((_g5923_ (let () (declare (not safe)) (##length _g5924_))))
        (cond ((let () (declare (not safe)) (##fx= _g5923_ 1))
               (apply gerbil/tools/gxpkg#pkg-unlink__0 _g5924_))
              ((let () (declare (not safe)) (##fx= _g5923_ 2))
               (apply gerbil/tools/gxpkg#pkg-unlink__% _g5924_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-unlink
                _g5924_))))))
  (define gerbil/tools/gxpkg#pkg-build__%
    (lambda (_pkg1423_ _dependents?1424_)
      (if (equal? _pkg1423_ '"all")
          (let* ((_pkgs1426_ (gerbil/tools/gxpkg#pkg-list))
                 (_deps1432_
                  (map (lambda (_g14271429_)
                         (gerbil/tools/gxpkg#pkg-dependents*__%
                          _g14271429_
                          _pkgs1426_))
                       _pkgs1426_))
                 (_pkgs+deps1434_ (map cons _pkgs1426_ _deps1432_))
                 (_sorted1439_
                  (std/sort#sort
                   _pkgs+deps1434_
                   (lambda (_pa1436_ _pb1437_)
                     (member (car _pb1437_) (cdr _pa1436_))))))
            (for-each
             (lambda (_g14411443_)
               (gerbil/tools/gxpkg#pkg-build__% _g14411443_ '#f))
             (map car _sorted1439_)))
          (let* ((_root1446_ (gerbil/tools/gxpkg#pkg-root-dir))
                 (_path1448_ (path-expand _pkg1423_ _root1446_))
                 (_g5925_ (if (file-exists? _path1448_)
                              '#!void
                              (error '"Cannot build unknown package"
                                     _pkg1423_)))
                 (_build.ss1451_
                  (gerbil/tools/gxpkg#pkg-build-script _pkg1423_)))
            (displayln '"... build " _pkg1423_)
            (std/misc/process#run-process__%
             '#f
             void
             absent-value
             absent-value
             _path1448_
             absent-value
             '#f
             absent-value
             absent-value
             absent-value
             (cons _build.ss1451_ (cons '"compile" '())))
            (if _dependents?1424_
                (for-each
                 gerbil/tools/gxpkg#pkg-build
                 (gerbil/tools/gxpkg#pkg-dependents__0 _pkg1423_))
                '#!void)))))
  (define gerbil/tools/gxpkg#pkg-build__0
    (lambda (_pkg1457_)
      (let ((_dependents?1459_ '#t))
        (gerbil/tools/gxpkg#pkg-build__% _pkg1457_ _dependents?1459_))))
  (define gerbil/tools/gxpkg#pkg-build
    (lambda _g5927_
      (let ((_g5926_ (let () (declare (not safe)) (##length _g5927_))))
        (cond ((let () (declare (not safe)) (##fx= _g5926_ 1))
               (apply gerbil/tools/gxpkg#pkg-build__0 _g5927_))
              ((let () (declare (not safe)) (##fx= _g5926_ 2))
               (apply gerbil/tools/gxpkg#pkg-build__% _g5927_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-build
                _g5927_))))))
  (define gerbil/tools/gxpkg#pkg-clean
    (lambda (_pkg1144_)
      (letrec* ((_gpath1146_ (getenv '"GERBIL_PATH" '"~/.gerbil"))
                (_libdir1147_ (path-expand '"lib" _gpath1146_))
                (_bindir1148_ (path-expand '"bin" _gpath1146_))
                (_clean-lib1149_
                 (lambda (_mod1381_)
                   (let* ((_modpath1383_ (path-expand _mod1381_ _libdir1147_))
                          (_moddir1385_ (path-directory _modpath1383_))
                          (_modname1387_ (path-strip-directory _modpath1383_))
                          (_mod-dot1389_ (string-append _modname1387_ '"."))
                          (_mod-us1391_ (string-append _modname1387_ '"__"))
                          (_mod-nested1393_
                           (string-append _modname1387_ '"$")))
                     (if (file-exists? _moddir1385_)
                         (for-each
                          (lambda (_file1396_)
                            (if (or (string-prefix? _mod-dot1389_ _file1396_)
                                    (string-prefix? _mod-us1391_ _file1396_)
                                    (string-prefix?
                                     _mod-nested1393_
                                     _file1396_))
                                (let ((_path1404_
                                       (path-expand _file1396_ _moddir1385_)))
                                  (delete-file _path1404_))
                                '#!void))
                          (directory-files _moddir1385_))
                         '#!void))
                   (let* ((_static-libdir1406_
                           (path-expand '"static" _libdir1147_))
                          (_static-modname1408_
                           (string-join (string-split _mod1381_ '#\/) '"__"))
                          (_mod-self1410_
                           (string-append _static-modname1408_ '".scm"))
                          (_mod-nested1412_
                           (string-append _static-modname1408_ '"$")))
                     (if (file-exists? _static-libdir1406_)
                         (for-each
                          (lambda (_file1415_)
                            (if (or (equal? _file1415_ _mod-self1410_)
                                    (string-prefix?
                                     _mod-nested1412_
                                     _file1415_))
                                (let ((_path1420_
                                       (path-expand
                                        _file1415_
                                        _static-libdir1406_)))
                                  (delete-file _path1420_))
                                '#!void))
                          (directory-files _static-libdir1406_))
                         '#!void))))
                (_clean-bin1150_
                 (lambda (_exe1377_)
                   (let ((_bin1379_ (path-expand _exe1377_ _bindir1148_)))
                     (if (file-exists? _bin1379_)
                         (delete-file _bin1379_)
                         '#!void))))
                (_clean-static-include1151_
                 (lambda (_file1370_)
                   (let* ((_filename1372_ (path-strip-directory _file1370_))
                          (_static-path1374_
                           (path-expand
                            _filename1372_
                            (path-expand '"static" _libdir1147_))))
                     (if (file-exists? _static-path1374_)
                         (delete-file _static-path1374_)
                         '#!void)))))
        (let* ((_root1153_ (gerbil/tools/gxpkg#pkg-root-dir))
               (_path1155_ (path-expand _pkg1144_ _root1153_))
               (_g5928_ (if (file-exists? _path1155_)
                            '#!void
                            (error '"Cannot clean unknown package" _pkg1144_)))
               (_build.ss1158_ (gerbil/tools/gxpkg#pkg-build-script _pkg1144_))
               (_build-spec1160_
                (std/misc/process#run-process__%
                 '#f
                 read
                 absent-value
                 absent-value
                 _path1155_
                 absent-value
                 absent-value
                 absent-value
                 absent-value
                 absent-value
                 (cons _build.ss1158_ (cons '"spec" '()))))
               (_plist1162_ (gerbil/tools/gxpkg#pkg-plist _pkg1144_))
               (_prefix1164_ (pgetq 'package: _plist1162_))
               (_prefix1166_
                (if _prefix1164_ (symbol->string _prefix1164_) '#f))
               (_with-prefix1170_
                (if _prefix1166_
                    (lambda (_mod1168_)
                      (string-append _prefix1166_ '"/" _mod1168_))
                    values)))
          (for-each
           (lambda (_e11721174_)
             (let* ((_g11761219_ _e11721174_)
                    (_E11851223_
                     (lambda () (error '"No clause matching" _g11761219_))))
               (let ((_K12171365_
                      (lambda (_modf1363_)
                        (_clean-lib1149_ (_with-prefix1170_ _modf1363_))))
                     (_K12121347_
                      (lambda (_modf1345_)
                        (_clean-lib1149_ (_with-prefix1170_ _modf1345_))))
                     (_K12071328_
                      (lambda (_modf1326_)
                        (_clean-lib1149_ (_with-prefix1170_ _modf1326_))))
                     (_K12021309_
                      (lambda (_modf1307_)
                        (_clean-lib1149_ (_with-prefix1170_ _modf1307_))))
                     (_K11971286_
                      (lambda (_opts1283_ _modf1284_)
                        (_clean-lib1149_ (_with-prefix1170_ _modf1284_))
                        (_clean-bin1150_ (pgetq 'bin: _opts1283_ _modf1284_))))
                     (_K11921262_
                      (lambda (_opts1259_ _modf1260_)
                        (_clean-lib1149_ (_with-prefix1170_ _modf1260_))
                        (_clean-bin1150_ (pgetq 'bin: _opts1259_ _modf1260_))))
                     (_K11871240_
                      (lambda (_file1238_)
                        (_clean-static-include1151_ _file1238_)))
                     (_K11861229_
                      (lambda (_unexpected1227_)
                        (displayln
                         '"Ignoring unexpected build artifact "
                         _unexpected1227_))))
                 (let ((_try-match11781360_
                        (lambda ()
                          (if (let ()
                                (declare (not safe))
                                (##pair? _g11761219_))
                              (let ((_tl12141352_
                                     (let ()
                                       (declare (not safe))
                                       (##cdr _g11761219_)))
                                    (_hd12131350_
                                     (let ()
                                       (declare (not safe))
                                       (##car _g11761219_))))
                                (if (let ()
                                      (declare (not safe))
                                      (##eq? _hd12131350_ 'gxc:))
                                    (if (let ()
                                          (declare (not safe))
                                          (##pair? _tl12141352_))
                                        (let* ((_hd12151355_
                                                (let ()
                                                  (declare (not safe))
                                                  (##car _tl12141352_)))
                                               (_modf1358_ _hd12151355_))
                                          (_K12121347_ _modf1358_))
                                        (let ((_unexpected1232_ _g11761219_))
                                          (_K11861229_ _unexpected1232_)))
                                    (if (let ()
                                          (declare (not safe))
                                          (##eq? _hd12131350_ 'gsc:))
                                        (if (let ()
                                              (declare (not safe))
                                              (##pair? _tl12141352_))
                                            (let* ((_hd12101336_
                                                    (let ()
                                                      (declare (not safe))
                                                      (##car _tl12141352_)))
                                                   (_modf1339_ _hd12101336_))
                                              (_K12071328_ _modf1339_))
                                            (let ((_unexpected1232_
                                                   _g11761219_))
                                              (_K11861229_ _unexpected1232_)))
                                        (if (let ()
                                              (declare (not safe))
                                              (##eq? _hd12131350_ 'ssi:))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##pair? _tl12141352_))
                                                (let* ((_hd12051317_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##car _tl12141352_)))
                                                       (_modf1320_
                                                        _hd12051317_))
                                                  (_K12021309_ _modf1320_))
                                                (let ((_unexpected1232_
                                                       _g11761219_))
                                                  (_K11861229_
                                                   _unexpected1232_)))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##eq? _hd12131350_ 'exe:))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##pair? _tl12141352_))
                                                    (let ((_tl12011296_
                                                           (let ()
                                                             (declare
                                                               (not safe))
                                                             (##cdr _tl12141352_)))
                                                          (_hd12001294_
                                                           (let ()
                                                             (declare
                                                               (not safe))
                                                             (##car _tl12141352_))))
                                                      (let ((_modf1299_
                                                             _hd12001294_)
                                                            (_opts1301_
                                                             _tl12011296_))
                                                        (_K11971286_
                                                         _opts1301_
                                                         _modf1299_)))
                                                    (let ((_unexpected1232_
                                                           _g11761219_))
                                                      (_K11861229_
                                                       _unexpected1232_)))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##eq? _hd12131350_
                                                             'static-exe:))
                                                    (if (let ()
                                                          (declare (not safe))
                                                          (##pair? _tl12141352_))
                                                        (let ((_tl11961272_
                                                               (let ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (declare (not safe))
                         (##cdr _tl12141352_)))
                      (_hd11951270_
                       (let () (declare (not safe)) (##car _tl12141352_))))
                  (let ((_modf1275_ _hd11951270_) (_opts1277_ _tl11961272_))
                    (_K11921262_ _opts1277_ _modf1275_)))
                (let ((_unexpected1232_ _g11761219_))
                  (_K11861229_ _unexpected1232_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (if (let ()
                                                          (declare (not safe))
                                                          (##eq? _hd12131350_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         'static-include:))
                (if (let () (declare (not safe)) (##pair? _tl12141352_))
                    (let ((_tl11911250_
                           (let () (declare (not safe)) (##cdr _tl12141352_)))
                          (_hd11901248_
                           (let () (declare (not safe)) (##car _tl12141352_))))
                      (if (let () (declare (not safe)) (##null? _tl11911250_))
                          (let ((_file1253_ _hd11901248_))
                            (_clean-static-include1151_ _file1253_))
                          (let ((_unexpected1232_ _g11761219_))
                            (_K11861229_ _unexpected1232_))))
                    (let ((_unexpected1232_ _g11761219_))
                      (_K11861229_ _unexpected1232_)))
                (let ((_unexpected1232_ _g11761219_))
                  (_K11861229_ _unexpected1232_)))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                              (let ((_unexpected1232_ _g11761219_))
                                (_K11861229_ _unexpected1232_))))))
                   (if (string? _g11761219_)
                       (let ((_modf1368_ _g11761219_))
                         (_K12171365_ _modf1368_))
                       (_try-match11781360_))))))
           _build-spec1160_)))))
  (define gerbil/tools/gxpkg#pkg-list
    (lambda ()
      (letrec* ((_root1076_ (gerbil/tools/gxpkg#pkg-root-dir))
                (_walk1077_
                 (lambda (_dir1132_ _pkgpath1133_)
                   (for-each
                    (lambda (_file1135_)
                      (let* ((_path1137_ (path-expand _file1135_ _dir1132_))
                             (_gerbil.pkg1139_
                              (path-expand '"gerbil.pkg" _path1137_))
                             (_pkgpath1141_
                              (if (string-empty? _pkgpath1133_)
                                  _file1135_
                                  (string-append
                                   _pkgpath1133_
                                   '"/"
                                   _file1135_))))
                        (if (file-exists? _gerbil.pkg1139_)
                            (std/coroutine#yield _pkgpath1141_)
                            (if (gerbil/tools/gxpkg#file-directory? _path1137_)
                                (_walk1077_ _path1137_ _pkgpath1141_)
                                '#!void))))
                    (directory-files _dir1132_)))))
        (let ((_iterable1101_ (lambda () (_walk1077_ _root1076_ '"")))
              (_iter-do1103_
               (lambda (_val1080_)
                 (let* ((_val10821087_ _val1080_)
                        (_E10841091_
                         (lambda ()
                           (error '"No clause matching" _val10821087_)))
                        (_K10851096_ (lambda (_pkg1094_) _pkg1094_))
                        (_pkg1099_ _val10821087_))
                   (_K10851096_ _pkg1099_)))))
          (if (pair? _iterable1101_)
              (map _iter-do1103_ _iterable1101_)
              (if (null? _iterable1101_)
                  '()
                  (let* ((_it1106_ (std/iter#iter _iterable1101_))
                         (_next!1109_
                          (let ()
                            (declare (not safe))
                            (##unchecked-structure-ref
                             _it1106_
                             '2
                             std/iter#iterator::t
                             '#f))))
                    (declare (not safe))
                    (let _lp1114_ ((_rval1117_ '()))
                      (let ((_val1120_ (_next!1109_ _it1106_)))
                        (if (eq? std/iter#iter-end _val1120_)
                            (begin
                              (let ((_$e1122_
                                     (##unchecked-structure-ref
                                      _it1106_
                                      '3
                                      std/iter#iterator::t
                                      '#f)))
                                (if _$e1122_
                                    ((lambda (_g11241126_)
                                       (_g11241126_ _it1106_))
                                     _$e1122_)
                                    '#!void))
                              (reverse _rval1117_))
                            (let ((_xval1129_ (_iter-do1103_ _val1120_)))
                              (_lp1114_
                               (cons _xval1129_ _rval1117_)))))))))))))
  (define gerbil/tools/gxpkg#pkg-retag
    (lambda ()
      (let* ((_root1068_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dirs1072_
              (filter (lambda (_file1070_)
                        (gerbil/tools/gxpkg#file-directory?
                         (path-expand _file1070_ _root1068_)))
                      (directory-files _root1068_))))
        (displayln '"... tagging packages")
        (std/misc/process#run-process__%
         '#f
         absent-value
         absent-value
         absent-value
         _root1068_
         absent-value
         absent-value
         absent-value
         absent-value
         absent-value
         (cons '"gxtags" _dirs1072_)))))
  (define gerbil/tools/gxpkg#pkg-search
    (lambda (_keywords939_)
      (letrec ((_search941_
                (lambda (_alst1007_)
                  (let _lp1009_ ((_rest1011_ _alst1007_) (_r1012_ '()))
                    (let* ((_rest10131023_ _rest1011_)
                           (_else10151031_ (lambda () (reverse _r1012_)))
                           (_K10171046_
                            (lambda (_rest1034_ _desc1035_ _pkg1036_ _hd1037_)
                              (if (andmap1 (lambda (_kw1039_)
                                             (let ((_rx1041_
                                                    (std/pregexp#pregexp
                                                     (string-append
                                                      '"(?i:"
                                                      _kw1039_
                                                      '")"))))
                                               (or (std/pregexp#pregexp-match
                                                    _rx1041_
                                                    _pkg1036_)
                                                   (std/pregexp#pregexp-match
                                                    _rx1041_
                                                    _desc1035_))))
                                           _keywords939_)
                                  (_lp1009_ _rest1034_ (cons _hd1037_ _r1012_))
                                  (_lp1009_ _rest1034_ _r1012_)))))
                      (if (let ()
                            (declare (not safe))
                            (##pair? _rest10131023_))
                          (let ((_hd10181049_
                                 (let ()
                                   (declare (not safe))
                                   (##car _rest10131023_)))
                                (_tl10191051_
                                 (let ()
                                   (declare (not safe))
                                   (##cdr _rest10131023_))))
                            (let ((_hd1054_ _hd10181049_))
                              (if (let ()
                                    (declare (not safe))
                                    (##pair? _hd10181049_))
                                  (let ((_hd10201056_
                                         (let ()
                                           (declare (not safe))
                                           (##car _hd10181049_)))
                                        (_tl10211058_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _hd10181049_))))
                                    (let* ((_pkg1061_ _hd10201056_)
                                           (_desc1063_ _tl10211058_)
                                           (_rest1065_ _tl10191051_))
                                      (_K10171046_
                                       _rest1065_
                                       _desc1063_
                                       _pkg1061_
                                       _hd1054_)))
                                  (_else10151031_))))
                          (_else10151031_))))))
               (_display-pkgs942_
                (lambda (_alst948_)
                  (let ((_iterable981_ _alst948_)
                        (_iter-do983_
                         (lambda (_val950_)
                           (let* ((_val952959_ _val950_)
                                  (_E954963_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _val952959_)))
                                  (_K955969_
                                   (lambda (_desc966_ _pkg967_)
                                     (displayln _pkg967_ '": " _desc966_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##pair? _val952959_))
                                 (let ((_hd956972_
                                        (let ()
                                          (declare (not safe))
                                          (##car _val952959_)))
                                       (_tl957974_
                                        (let ()
                                          (declare (not safe))
                                          (##cdr _val952959_))))
                                   (let* ((_pkg977_ _hd956972_)
                                          (_desc979_ _tl957974_))
                                     (_K955969_ _desc979_ _pkg977_)))
                                 (_E954963_))))))
                    (if (pair? _iterable981_)
                        (for-each _iter-do983_ _iterable981_)
                        (if (null? _iterable981_)
                            '#!void
                            (let* ((_it986_ (std/iter#iter _iterable981_))
                                   (_next!989_
                                    (let ()
                                      (declare (not safe))
                                      (##unchecked-structure-ref
                                       _it986_
                                       '2
                                       std/iter#iterator::t
                                       '#f))))
                              (declare (not safe))
                              (begin
                                (let _lp994_ ()
                                  (let ((_val998_ (_next!989_ _it986_)))
                                    (if (eq? std/iter#iter-end _val998_)
                                        '#!void
                                        (begin
                                          (_iter-do983_ _val998_)
                                          (_lp994_)))))
                                (let ((_$e1000_
                                       (##unchecked-structure-ref
                                        _it986_
                                        '3
                                        std/iter#iterator::t
                                        '#f)))
                                  (if _$e1000_
                                      ((lambda (_g10021004_)
                                         (_g10021004_ _it986_))
                                       _$e1000_)
                                      '#!void))
                                '#!void))))))))
        (let ((_alst944_ (gerbil/tools/gxpkg#pkg-directory-list)))
          (if (null? _keywords939_)
              (_display-pkgs942_ _alst944_)
              (let ((_matches946_ (_search941_ _alst944_)))
                (_display-pkgs942_ _matches946_)))))))
  (define gerbil/tools/gxpkg#+pkg-directory+
    '"https://raw.githubusercontent.com/vyzo/gerbil-directory/master/README.md")
  (define gerbil/tools/gxpkg#pkg-directory-list
    (lambda ()
      (let* ((_txt801_
              (std/net/request#request-text
               (std/net/request#http-get__%
                '#f
                absent-value
                absent-value
                absent-value
                absent-value
                absent-value
                gerbil/tools/gxpkg#+pkg-directory+)))
             (_lines803_ (string-split _txt801_ '#\newline)))
        (let _lp806_ ((_rest808_ _lines803_))
          (let* ((_rest809816_ _rest808_)
                 (_E811820_
                  (lambda () (error '"No clause matching" _rest809816_)))
                 (_K812927_
                  (lambda (_rest823_ _hd824_)
                    (if (equal? _hd824_ '"<!-- begin-pkg -->")
                        (let _lp2826_ ((_rest828_ (cddr _rest823_))
                                       (_pkgs829_ '()))
                          (let* ((_rest830837_ _rest828_)
                                 (_E832841_
                                  (lambda ()
                                    (error '"No clause matching"
                                           _rest830837_)))
                                 (_K833915_
                                  (lambda (_rest844_ _hd845_)
                                    (if (equal? _hd845_ '"<!-- end-pkg -->")
                                        (reverse _pkgs829_)
                                        (let* ((_g846857_
                                                (string-split _hd845_ '#\|))
                                               (_E848861_
                                                (lambda ()
                                                  (error '"No clause matching"
                                                         _g846857_)))
                                               (_K849897_
                                                (lambda (_pkg-desc864_
                                                         _pkg-link865_)
                                                  (let* ((_g866875_
                                                          (std/pregexp#pregexp-match
                                                           '"\\[([^]]+)\\]"
                                                           _pkg-link865_))
                                                         (_E868879_
                                                          (lambda ()
                                                            (error '"No clause matching"
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _g866875_)))
                 (_K869884_
                  (lambda (_pkg882_)
                    (_lp2826_
                     _rest844_
                     (cons (cons _pkg882_
                                 (std/srfi/13#string-trim__0 _pkg-desc864_))
                           _pkgs829_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (if (let ()
                                                          (declare (not safe))
                                                          (##pair? _g866875_))
                                                        (let ((_tl871887_
                                                               (let ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (declare (not safe))
                         (##cdr _g866875_))))
                  (if (let () (declare (not safe)) (##pair? _tl871887_))
                      (let ((_hd872890_
                             (let () (declare (not safe)) (##car _tl871887_)))
                            (_tl873892_
                             (let () (declare (not safe)) (##cdr _tl871887_))))
                        (let ((_pkg895_ _hd872890_))
                          (if (let ()
                                (declare (not safe))
                                (##null? _tl873892_))
                              (_K869884_ _pkg895_)
                              (_E868879_))))
                      (_E868879_)))
                (_E868879_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                          (if (let ()
                                                (declare (not safe))
                                                (##pair? _g846857_))
                                              (let ((_tl851900_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##cdr _g846857_))))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##pair? _tl851900_))
                                                    (let ((_hd852903_
                                                           (let ()
                                                             (declare
                                                               (not safe))
                                                             (##car _tl851900_)))
                                                          (_tl853905_
                                                           (let ()
                                                             (declare
                                                               (not safe))
                                                             (##cdr _tl851900_))))
                                                      (let ((_pkg-link908_
                                                             _hd852903_))
                                                        (if (let ()
                                                              (declare
                                                                (not safe))
                                                              (##pair? _tl853905_))
                                                            (let* ((_hd854910_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            (let () (declare (not safe)) (##car _tl853905_)))
                           (_pkg-desc913_ _hd854910_))
                      (_K849897_ _pkg-desc913_ _pkg-link908_))
                    (_E848861_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (_E848861_)))
                                              (_E848861_)))))))
                            (if (let ()
                                  (declare (not safe))
                                  (##pair? _rest830837_))
                                (let ((_hd834918_
                                       (let ()
                                         (declare (not safe))
                                         (##car _rest830837_)))
                                      (_tl835920_
                                       (let ()
                                         (declare (not safe))
                                         (##cdr _rest830837_))))
                                  (let* ((_hd923_ _hd834918_)
                                         (_rest925_ _tl835920_))
                                    (_K833915_ _rest925_ _hd923_)))
                                (_E832841_))))
                        (_lp806_ _rest823_)))))
            (if (let () (declare (not safe)) (##pair? _rest809816_))
                (let ((_hd813930_
                       (let () (declare (not safe)) (##car _rest809816_)))
                      (_tl814932_
                       (let () (declare (not safe)) (##cdr _rest809816_))))
                  (let* ((_hd935_ _hd813930_) (_rest937_ _tl814932_))
                    (_K812927_ _rest937_ _hd935_)))
                (_E811820_)))))))
  (define gerbil/tools/gxpkg#+pkg-plist+ (make-table))
  (define gerbil/tools/gxpkg#pkg-plist
    (lambda (_pkg783_)
      (let ((_$e785_ (table-ref gerbil/tools/gxpkg#+pkg-plist+ _pkg783_ '#f)))
        (if _$e785_
            (values _$e785_)
            (let* ((_root788_ (gerbil/tools/gxpkg#pkg-root-dir))
                   (_path790_ (path-expand _pkg783_ _root788_))
                   (_gerbil.pkg792_ (path-expand '"gerbil.pkg" _path790_))
                   (_g5929_ (if (file-exists? _gerbil.pkg792_)
                                '#!void
                                (error '"Bad package; missing gerbil.pkg"
                                       _pkg783_)))
                   (_plist795_ (call-with-input-file _gerbil.pkg792_ read))
                   (_plist797_ (if (eof-object? _plist795_) '() _plist795_)))
              (table-set! gerbil/tools/gxpkg#+pkg-plist+ _pkg783_ _plist797_)
              _plist797_)))))
  (define gerbil/tools/gxpkg#pkg-build-script
    (lambda (_pkg767_)
      (let* ((_root769_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_path771_ (path-expand _pkg767_ _root769_))
             (_plist773_ (gerbil/tools/gxpkg#pkg-plist _pkg767_))
             (_build775_ (pgetq 'build: _plist773_))
             (_build.ss780_
              (path-expand
               (let ((_$e777_ _build775_)) (if _$e777_ _$e777_ '"build.ss"))
               _path771_)))
        (if (file-exists? _build.ss780_)
            '#!void
            (error '"Bad package; missing build script"
                   _pkg767_
                   _build.ss780_))
        (path-normalize _build.ss780_))))
  (define gerbil/tools/gxpkg#pkg-dependents__%
    (lambda (_pkg745_ _pkgs746_)
      (letrec ((_dependent748_
                (lambda (_xpkg750_)
                  (let* ((_plist752_ (gerbil/tools/gxpkg#pkg-plist _xpkg750_))
                         (_deps754_ (pgetq 'depend: _plist752_ '())))
                    (if (member _pkg745_ _deps754_) _xpkg750_ '#f)))))
        (filter-map1 _dependent748_ _pkgs746_))))
  (define gerbil/tools/gxpkg#pkg-dependents__0
    (lambda (_pkg760_)
      (let ((_pkgs762_ (gerbil/tools/gxpkg#pkg-list)))
        (gerbil/tools/gxpkg#pkg-dependents__% _pkg760_ _pkgs762_))))
  (define gerbil/tools/gxpkg#pkg-dependents
    (lambda _g5931_
      (let ((_g5930_ (let () (declare (not safe)) (##length _g5931_))))
        (cond ((let () (declare (not safe)) (##fx= _g5930_ 1))
               (apply gerbil/tools/gxpkg#pkg-dependents__0 _g5931_))
              ((let () (declare (not safe)) (##fx= _g5930_ 2))
               (apply gerbil/tools/gxpkg#pkg-dependents__% _g5931_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-dependents
                _g5931_))))))
  (define gerbil/tools/gxpkg#pkg-dependents*__%
    (lambda (_pkg689_ _pkgs690_)
      (let ((_deps692_
             (gerbil/tools/gxpkg#pkg-dependents__% _pkg689_ _pkgs690_)))
        (let _lp694_ ((_rest696_ _deps692_) (_r697_ '()))
          (let* ((_rest698706_ _rest696_)
                 (_else700714_ (lambda () _r697_))
                 (_K702722_
                  (lambda (_rest717_ _pkg718_)
                    (if (member _pkg718_ _r697_)
                        (_lp694_ _rest717_ _r697_)
                        (let ((_deps720_
                               (gerbil/tools/gxpkg#pkg-dependents__%
                                _pkg718_
                                _pkgs690_)))
                          (_lp694_ (foldl1 cons _rest717_ _deps720_)
                                   (cons _pkg718_ _r697_)))))))
            (if (let () (declare (not safe)) (##pair? _rest698706_))
                (let ((_hd703725_
                       (let () (declare (not safe)) (##car _rest698706_)))
                      (_tl704727_
                       (let () (declare (not safe)) (##cdr _rest698706_))))
                  (let* ((_pkg730_ _hd703725_) (_rest732_ _tl704727_))
                    (_K702722_ _rest732_ _pkg730_)))
                (_else700714_)))))))
  (define gerbil/tools/gxpkg#pkg-dependents*__0
    (lambda (_pkg737_)
      (let ((_pkgs739_ (gerbil/tools/gxpkg#pkg-list)))
        (gerbil/tools/gxpkg#pkg-dependents*__% _pkg737_ _pkgs739_))))
  (define gerbil/tools/gxpkg#pkg-dependents*
    (lambda _g5933_
      (let ((_g5932_ (let () (declare (not safe)) (##length _g5933_))))
        (cond ((let () (declare (not safe)) (##fx= _g5932_ 1))
               (apply gerbil/tools/gxpkg#pkg-dependents*__0 _g5933_))
              ((let () (declare (not safe)) (##fx= _g5932_ 2))
               (apply gerbil/tools/gxpkg#pkg-dependents*__% _g5933_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-dependents*
                _g5933_))))))
  (define gerbil/tools/gxpkg#file-directory?
    (lambda (_path686_) (eq? (file-type _path686_) 'directory)))
  (define gerbil/tools/gxpkg#file-symbolic-link?
    (lambda (_path684_)
      (eq? (file-info-type (file-info _path684_ '#f)) 'symbolic-link))))
