/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.sqlite.JDBC;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.utils.XmlUtils;

public class SpiderSVNEntriesParser
extends SpiderParser {
    private static final Pattern svnSQLiteFormatPattern = Pattern.compile("^SQLite format ");
    private static final Pattern svnXMLFormatPattern = Pattern.compile("<wc-entries");
    private static final Pattern svnTextFormatFileOrDirectoryPattern = Pattern.compile("^(file|dir)$");
    private static final Pattern svnRepoLocationPattern = Pattern.compile("^(http://|https://)", 2);
    private SpiderParam params;
    private static DocumentBuilder dBuilder;
    private Pattern SVN_ENTRIES_FILE_PATTERN = Pattern.compile("/\\.svn/entries$|/\\.svn/wc.db$");

    public SpiderSVNEntriesParser(SpiderParam params) {
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        String[] lines;
        if (message == null) return false;
        if (!this.params.isParseSVNEntries()) {
            return false;
        }
        log.debug((Object)"Parsing an SVN resource...");
        String content = message.getResponseBody().toString();
        String baseURL = message.getRequestHeader().getURI().toString();
        Matcher svnSQLiteFormatMatcher = svnSQLiteFormatPattern.matcher(content);
        Matcher svnXMLFormatMatcher = svnXMLFormatPattern.matcher(content);
        if (svnSQLiteFormatMatcher.find()) {
            try {
                File tempSqliteFile = File.createTempFile("sqlite", null);
                tempSqliteFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tempSqliteFile);
                ((OutputStream)fos).write(message.getResponseBody().getBytes());
                ((OutputStream)fos).close();
                if (log.isDebugEnabled()) {
                    JDBC jdbcDriver = new JDBC();
                    log.debug((Object)("Created a temporary SQLite database file '" + tempSqliteFile + "'"));
                    log.debug((Object)("SQLite JDBC Driver is version " + jdbcDriver.getMajorVersion() + "." + jdbcDriver.getMinorVersion()));
                }
                Class.forName("org.sqlite.JDBC");
                String sqliteConnectionUrl = "jdbc:sqlite:" + tempSqliteFile.getAbsolutePath();
                try (Connection conn = DriverManager.getConnection(sqliteConnectionUrl);){
                    if (conn == null) throw new SQLException("Could not open a JDBC connection to SQLite file " + tempSqliteFile.getAbsolutePath());
                    Statement stmt = null;
                    ResultSet rsSVNWCFormat = null;
                    ResultSet rsNodes = null;
                    ResultSet rsRepo = null;
                    try {
                        stmt = conn.createStatement();
                        rsSVNWCFormat = stmt.executeQuery("pragma USER_VERSION");
                        int svnFormat = 0;
                        if (rsSVNWCFormat.next()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Got a row from 'pragma USER_VERSION'");
                            }
                            svnFormat = rsSVNWCFormat.getInt(1);
                        }
                        if (svnFormat < 29) {
                            throw new Exception("The SVN Working Copy Format of the SQLite database should be >= 29. We found " + svnFormat);
                        }
                        if (svnFormat > 31) {
                            throw new Exception("SVN Working Copy Format " + svnFormat + " is not supported at this time.  We support up to and including format 31 (~ SVN 1.8.5)");
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Internal SVN Working Copy Format for " + tempSqliteFile + " is " + svnFormat));
                            log.debug((Object)"Refer to http://svn.apache.org/repos/asf/subversion/trunk/subversion/libsvn_wc/wc.h for more details!");
                        }
                        switch (svnFormat) {
                            case 29: 
                            case 30: 
                            case 31: {
                                rsNodes = stmt.executeQuery("select kind,local_relpath,'pristine/'||substr(checksum,7,2) || \"/\" || substr(checksum,7)|| \".svn-base\" from nodes order by wc_id");
                                break;
                            }
                        }
                        if (rsNodes == null) {
                            log.error((Object)"There was a problem parsing the resource. rsNodes should not be null.");
                            boolean bl = false;
                            return bl;
                        }
                        while (rsNodes.next()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Got a Node from the SVN wc.db file (format " + svnFormat + ")"));
                            }
                            String kind = rsNodes.getString(1);
                            String filename = rsNodes.getString(2);
                            String svn_filename = rsNodes.getString(3);
                            if (filename == null || filename.length() <= 0) continue;
                            log.debug((Object)"Found a file/directory name in the (SQLite based) SVN wc.db file");
                            this.processURL(message, depth, "../" + filename + (kind.equals("dir") ? "/" : ""), baseURL);
                            if (kind.equals("dir")) {
                                this.processURL(message, depth, "../" + filename + "/.svn/wc.db", baseURL);
                            }
                            if (!kind.equals("file") || svn_filename == null || svn_filename.length() <= 0) continue;
                            this.processURL(message, depth, svn_filename, baseURL);
                        }
                        rsRepo = stmt.executeQuery("select root from REPOSITORY order by id");
                        while (rsRepo.next()) {
                            Matcher repoMatcher;
                            String repos_path;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Got a potential Repository from the SVN wc.db file (format " + svnFormat + ")"));
                            }
                            if ((repos_path = rsRepo.getString(1)) == null || repos_path.length() <= 0 || !(repoMatcher = svnRepoLocationPattern.matcher(repos_path)).find()) continue;
                            log.debug((Object)"Found an SVN repository location in the (SQLite based) SVN wc.db file");
                            this.processURL(message, depth, repos_path + "/", baseURL);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error executing SQL on temporary SVN SQLite database '" + sqliteConnectionUrl + "': " + e));
                        return true;
                    }
                    finally {
                        if (rsRepo != null) {
                            rsRepo.close();
                        }
                        if (rsNodes != null) {
                            rsNodes.close();
                        }
                        if (rsSVNWCFormat != null) {
                            rsSVNWCFormat.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error parsing temporary SVN SQLite database " + sqliteConnectionUrl));
                    return true;
                }
                finally {
                    tempSqliteFile.delete();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                log.error((Object)("An error occurred trying to set up to parse the SQLite based file: " + e));
                return true;
            }
        }
        if (svnXMLFormatMatcher.find()) {
            Document doc;
            try {
                doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(content.getBytes("utf-8"))));
            }
            catch (IOException | SAXException e) {
                log.error((Object)("An error occurred trying to parse the XML based .svn/entries file: " + e));
                return true;
            }
            NodeList nodelist = doc.getElementsByTagName("entry");
            int i = 0;
            while (i < nodelist.getLength()) {
                Matcher urlMatcher;
                Matcher repoMatcher;
                Node svnEntryNode = nodelist.item(i);
                String svnEntryName = ((Element)svnEntryNode).getAttribute("name");
                String svnEntryKind = ((Element)svnEntryNode).getAttribute("kind");
                String svnEntryUrl = ((Element)svnEntryNode).getAttribute("url");
                String svnEntryCopyFromUrl = ((Element)svnEntryNode).getAttribute("copyfrom-url");
                if (svnEntryName != null && svnEntryName.length() > 0) {
                    log.debug((Object)"Found a file/directory name in the (XML based) SVN < 1.4 entries file");
                    this.processURL(message, depth, "../" + svnEntryName + (svnEntryKind.equals("dir") ? "/" : ""), baseURL);
                    if (svnEntryKind.equals("file")) {
                        this.processURL(message, depth, "text-base/" + svnEntryName + ".svn-base", baseURL);
                    }
                    if (svnEntryKind.equals("dir")) {
                        this.processURL(message, depth, "../" + svnEntryName + "/.svn/entries", baseURL);
                    }
                }
                if (svnEntryName != null && svnEntryName.length() == 0 && svnEntryKind.equals("dir") && (repoMatcher = svnRepoLocationPattern.matcher(svnEntryUrl)).find()) {
                    log.debug((Object)"Found an SVN repository location in the (XML based) SVN < 1.4 entries file");
                    this.processURL(message, depth, svnEntryUrl + "/", baseURL);
                }
                if ((urlMatcher = svnRepoLocationPattern.matcher(svnEntryCopyFromUrl)).find()) {
                    log.debug((Object)"Found an SVN URL in the (XML based) SVN < 1.4 entries file");
                    this.processURL(message, depth, svnEntryCopyFromUrl, baseURL);
                }
                ++i;
            }
            return true;
        }
        String previousline = null;
        String[] stringArray = lines = content.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line;
            block64: {
                block65: {
                    line = stringArray[n2];
                    if (line.length() <= 0) break block64;
                    Matcher matcher = svnTextFormatFileOrDirectoryPattern.matcher(line);
                    if (!matcher.find()) break block65;
                    String filetype = matcher.group(0);
                    if (previousline != null && previousline.length() > 0) {
                        log.debug((Object)"Found a file/directory name in the (text based) SVN 1.4/1.5/1.6 SVN entries file");
                        this.processURL(message, depth, "../" + previousline + (filetype.equals("dir") ? "/" : ""), baseURL);
                        if (filetype.equals("file")) {
                            this.processURL(message, depth, "text-base/" + previousline + ".svn-base", baseURL);
                        }
                        if (filetype.equals("dir")) {
                            this.processURL(message, depth, "../" + previousline + "/.svn/entries", baseURL);
                        }
                    }
                    break block64;
                }
                Matcher repoMatcher = svnRepoLocationPattern.matcher(line);
                if (repoMatcher.find()) {
                    log.debug((Object)"Found an SVN repository location in the (text based) 1.4/1.5/1.6 SVN entries file");
                    this.processURL(message, depth, line + "/", baseURL);
                }
            }
            previousline = line;
            ++n2;
        }
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        Matcher matcher = this.SVN_ENTRIES_FILE_PATTERN.matcher(path);
        return matcher.find();
    }

    static {
        try {
            dBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
        }
    }
}

