/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class WatchProtocolDecoder
extends BaseProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchProtocolDecoder.class);
    private static final Pattern PATTERN_POSITION = new PatternBuilder().number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([AV]),").number(" *(-?d+.d+),").expression("([NS]),").number(" *(-?d+.d+),").expression("([EW])?,").number("(d+.?d*),").number("(d+.?d*),").number("(-?d+.?d*),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("d+,").number("(x+),").expression("(.*)").compile();
    private boolean hasIndex;
    private String manufacturer;

    public WatchProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, String id, String index, String content) {
        if (channel != null) {
            String response = index != null ? String.format("[%s*%s*%s*%04x*%s]", this.manufacturer, id, index, content.length(), content) : String.format("[%s*%s*%04x*%s]", this.manufacturer, id, content.length(), content);
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)response, (Charset)StandardCharsets.US_ASCII);
            channel.writeAndFlush((Object)new NetworkMessage(buf, channel.remoteAddress()));
        }
    }

    private String decodeAlarm(int status) {
        if (BitUtil.check(status, 0)) {
            return "lowBattery";
        }
        if (BitUtil.check(status, 1)) {
            return "geofenceExit";
        }
        if (BitUtil.check(status, 2)) {
            return "geofenceEnter";
        }
        if (BitUtil.check(status, 3)) {
            return "overspeed";
        }
        if (BitUtil.check(status, 16)) {
            return "sos";
        }
        if (BitUtil.check(status, 17)) {
            return "lowBattery";
        }
        if (BitUtil.check(status, 18)) {
            return "geofenceExit";
        }
        if (BitUtil.check(status, 19)) {
            return "geofenceEnter";
        }
        if (BitUtil.check(status, 20)) {
            return "removing";
        }
        if (BitUtil.check(status, 21)) {
            return "fallDown";
        }
        return null;
    }

    private Position decodePosition(DeviceSession deviceSession, String data) {
        Parser parser = new Parser(PATTERN_POSITION, data);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.set("rssi", parser.nextInt(0));
        position.set("batteryLevel", parser.nextInt(0));
        position.set("steps", parser.nextInt(0));
        int status = parser.nextHexInt(0);
        position.set("alarm", this.decodeAlarm(status));
        if (BitUtil.check(status, 4)) {
            position.set("motion", true);
        }
        String[] values = parser.next().split(",");
        int index = 0;
        Network network = new Network();
        int cellCount = Integer.parseInt(values[index++]);
        int n = ++index;
        int mcc = Integer.parseInt(values[n]);
        int n2 = ++index;
        ++index;
        int mnc = Integer.parseInt(values[n2]);
        for (int i = 0; i < cellCount; ++i) {
            network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(values[index++]), Integer.parseInt(values[index++]), Integer.parseInt(values[index++])));
        }
        if (index < values.length && !values[index].isEmpty()) {
            int wifiCount = Integer.parseInt(values[index++]);
            for (int i = 0; i < wifiCount; ++i) {
                int n3 = ++index;
                int n4 = ++index;
                ++index;
                network.addWifiAccessPoint(WifiAccessPoint.from(values[n3], Integer.parseInt(values[n4])));
            }
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        return position;
    }

    public boolean getHasIndex() {
        return this.hasIndex;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(1);
        this.manufacturer = buf.readSlice(2).toString(StandardCharsets.US_ASCII);
        buf.skipBytes(1);
        int idIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)42);
        String id = buf.readSlice(idIndex - buf.readerIndex()).toString(StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        buf.skipBytes(1);
        String index = null;
        int contentIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)42);
        if (contentIndex + 5 < buf.writerIndex() && buf.getByte(contentIndex + 5) == 42 && buf.toString(contentIndex + 1, 4, StandardCharsets.US_ASCII).matches("\\p{XDigit}+")) {
            int indexLength = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)42) - buf.readerIndex();
            this.hasIndex = true;
            index = buf.readSlice(indexLength).toString(StandardCharsets.US_ASCII);
            buf.skipBytes(1);
        }
        buf.skipBytes(4);
        buf.skipBytes(1);
        buf.writerIndex(buf.writerIndex() - 1);
        contentIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
        if (contentIndex < 0) {
            contentIndex = buf.writerIndex();
        }
        String type = buf.readSlice(contentIndex - buf.readerIndex()).toString(StandardCharsets.US_ASCII);
        if (contentIndex < buf.writerIndex()) {
            buf.readerIndex(contentIndex + 1);
        }
        if (type.equals("INIT")) {
            this.sendResponse(channel, id, index, "INIT,1");
        } else if (type.equals("LK")) {
            String[] values;
            this.sendResponse(channel, id, index, "LK");
            if (buf.isReadable() && (values = buf.toString(StandardCharsets.US_ASCII).split(",")).length >= 3) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                position.set("batteryLevel", Integer.parseInt(values[2]));
                return position;
            }
        } else {
            if (type.startsWith("UD") || type.startsWith("AL") || type.startsWith("WT")) {
                Position position = this.decodePosition(deviceSession, buf.toString(StandardCharsets.US_ASCII));
                if (type.equals("AL")) {
                    if (position != null) {
                        position.set("alarm", "sos");
                    }
                    this.sendResponse(channel, id, index, "AL");
                }
                return position;
            }
            if (type.equals("TKQ") || type.equals("TKQ2")) {
                this.sendResponse(channel, id, index, type);
            } else if (type.equalsIgnoreCase("PULSE") || type.equalsIgnoreCase("HEART") || type.equalsIgnoreCase("BLOOD") || type.equalsIgnoreCase("BPHRT")) {
                if (buf.isReadable()) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, new Date());
                    String[] values = buf.toString(StandardCharsets.US_ASCII).split(",");
                    int valueIndex = 0;
                    if (type.equalsIgnoreCase("BPHRT") || type.equalsIgnoreCase("BLOOD")) {
                        position.set("pressureHigh", values[valueIndex++]);
                        position.set("pressureLow", values[valueIndex++]);
                    }
                    if (valueIndex <= values.length - 1) {
                        position.set("heartRate", Integer.parseInt(values[valueIndex]));
                    }
                    return position;
                }
            } else {
                if (type.equals("img")) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, null);
                    int timeIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
                    buf.readerIndex(timeIndex + 12 + 2);
                    position.set("image", Context.getMediaManager().writeFile(id, buf, "jpg"));
                    return position;
                }
                if (type.equals("TK")) {
                    if (buf.readableBytes() == 1) {
                        byte result = buf.readByte();
                        if (result != 49) {
                            LOGGER.warn(type + "," + result);
                        }
                        return null;
                    }
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, null);
                    position.set("audio", Context.getMediaManager().writeFile(id, buf, "amr"));
                    return position;
                }
            }
        }
        return null;
    }
}

