/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u & (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(0u, 0u, 0u, 0u)
 * (0u & (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(0u, 0u, 0u, 0u)
 * (6u & (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4u, 6u, 0u, 4u)
 * (6u & (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(6u, 6u, 0u, 4u)
 * (12u & (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(12u, 4u, 8u, 4u)
 * (12u & (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4u, 4u, 8u, 4u)
 * (32u & (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(32u, 32u, 32u, 32u)
 * (32u & (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(32u, 0u, 32u, 32u)
 * (74u & (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(8u, 2u, 8u, 0u)
 * (74u & (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(66u, 66u, 72u, 0u)
 */
#version 130

void main()
{
  float[all(equal((0u & (~ uvec4(66u, 72u, 87u, 75u))), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((0u & (~ uvec4(24u, 40u, 23u, 74u))), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array1;
  float[all(equal((6u & (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4u, 6u, 0u, 4u))) ? 1 : -1] array2;
  float[all(equal((6u & (~ uvec4(24u, 40u, 23u, 74u))), uvec4(6u, 6u, 0u, 4u))) ? 1 : -1] array3;
  float[all(equal((12u & (~ uvec4(66u, 72u, 87u, 75u))), uvec4(12u, 4u, 8u, 4u))) ? 1 : -1] array4;
  float[all(equal((12u & (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4u, 4u, 8u, 4u))) ? 1 : -1] array5;
  float[all(equal((32u & (~ uvec4(66u, 72u, 87u, 75u))), uvec4(32u, 32u, 32u, 32u))) ? 1 : -1] array6;
  float[all(equal((32u & (~ uvec4(24u, 40u, 23u, 74u))), uvec4(32u, 0u, 32u, 32u))) ? 1 : -1] array7;
  float[all(equal((74u & (~ uvec4(66u, 72u, 87u, 75u))), uvec4(8u, 2u, 8u, 0u))) ? 1 : -1] array8;
  float[all(equal((74u & (~ uvec4(24u, 40u, 23u, 74u))), uvec4(66u, 66u, 72u, 0u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
