/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.Output;
import co.elastic.logstash.api.Plugin;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.plugins.PluginValidator;
import org.logstash.plugins.discovery.PluginRegistry;

public final class PluginLookup {
    private static final IRubyObject RUBY_REGISTRY = RubyUtil.RUBY.executeScript("require 'logstash/plugins/registry'\nrequire 'logstash/plugin'\nLogStash::Plugin", "");

    private PluginLookup() {
    }

    public static PluginClass lookup(PluginType type, String name) {
        IRubyObject resolvedClass;
        final Class<?> javaClass = PluginRegistry.getPluginClass(type, name);
        if (javaClass != null) {
            if (!PluginValidator.validatePlugin(type, javaClass)) {
                throw new IllegalStateException("Java plugin '" + name + "' is incompatible with the current Logstash plugin API");
            }
            return new PluginClass(){

                @Override
                public PluginLanguage language() {
                    return PluginLanguage.JAVA;
                }

                @Override
                public Object klass() {
                    return javaClass;
                }
            };
        }
        IRubyObject klass = RUBY_REGISTRY.callMethod(RubyUtil.RUBY.getCurrentContext(), "lookup", new IRubyObject[]{type.rubyLabel(), RubyUtil.RUBY.newString(name)});
        final PluginLanguage language = klass instanceof RubyClass ? PluginLanguage.RUBY : PluginLanguage.JAVA;
        klass = klass instanceof JavaProxy ? ((JavaProxy)klass).getObject() : klass;
        Object object = resolvedClass = klass instanceof JavaClass ? ((JavaClass)klass).javaClass() : klass;
        if (language == PluginLanguage.JAVA && !PluginValidator.validatePlugin(type, (Class)resolvedClass)) {
            throw new IllegalStateException("Java plugin '" + name + "' is incompatible with the current Logstash plugin API");
        }
        return new PluginClass(){

            @Override
            public PluginLanguage language() {
                return language;
            }

            @Override
            public Object klass() {
                return resolvedClass;
            }
        };
    }

    public static enum PluginType {
        INPUT("input", "inputs", Input.class),
        FILTER("filter", "filters", Filter.class),
        OUTPUT("output", "outputs", Output.class),
        CODEC("codec", "codecs", Codec.class);

        private final RubyString rubyLabel;
        private final String metricNamespace;
        private final Class<? extends Plugin> pluginClass;

        private PluginType(String label, String metricNamespace, Class<? extends Plugin> pluginClass) {
            this.rubyLabel = RubyUtil.RUBY.newString(label);
            this.metricNamespace = metricNamespace;
            this.pluginClass = pluginClass;
        }

        public RubyString rubyLabel() {
            return this.rubyLabel;
        }

        public String metricNamespace() {
            return this.metricNamespace;
        }

        public Class<? extends Plugin> pluginClass() {
            return this.pluginClass;
        }

        public static PluginType getTypeByPlugin(Plugin plugin) {
            for (PluginType type : PluginType.values()) {
                if (!type.pluginClass().isInstance(plugin)) continue;
                return type;
            }
            String allowedPluginTypes = Stream.of(PluginType.values()).map(t -> t.pluginClass().getName()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Plugin [%s] does not extend one of: %s", plugin.getName(), allowedPluginTypes));
        }
    }

    public static enum PluginLanguage {
        JAVA,
        RUBY;

    }

    public static interface PluginClass {
        public PluginLanguage language();

        public Object klass();

        default public String toReadableString() {
            return String.format("Plugin class [%s], language [%s]", new Object[]{this.klass(), this.language()});
        }
    }
}

