/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.text.Format;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

public class StringUtils {
    private static final String TRUE = "true";
    private static final String YES = "yes";
    private static final String ON = "on";

    private StringUtils() {
    }

    public static boolean startsWithIgnoreCase(String base, String start) {
        if (base.length() < start.length()) {
            return false;
        }
        return base.regionMatches(true, 0, start, 0, start.length());
    }

    public static boolean endsWithIgnoreCase(String base, String end) {
        if (base.length() < end.length()) {
            return false;
        }
        return base.regionMatches(true, base.length() - end.length(), end, 0, end.length());
    }

    public static String getLineSeparator() {
        try {
            return System.getProperty("line.separator", "\n");
        }
        catch (Exception e) {
            return "\n";
        }
    }

    public static String[] split(String string) {
        return StringUtils.split(string, " \t\n\r\f");
    }

    public static String[] split(String string, String separator) {
        if (separator == null) {
            throw new NullPointerException("Separator characters must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("String to be split must not be null.");
        }
        StringTokenizer strtok = new StringTokenizer(string, separator, false);
        String[] tokens = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String token;
            tokens[i] = token = strtok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String[] split(String string, String separator, String quate) {
        CSVTokenizer strtok = new CSVTokenizer(string, separator, quate, false);
        String[] tokens = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (token.length() <= 0) continue;
            tokens[i] = token;
            ++i;
        }
        if (i == tokens.length) {
            return tokens;
        }
        String[] retval = new String[i];
        System.arraycopy(tokens, 0, retval, 0, i);
        return retval;
    }

    public static String[] splitCSV(String string, String separator) {
        return StringUtils.splitCSV(string, separator, null);
    }

    public static String[] splitCSV(String string, String separator, String quate) {
        CSVTokenizer strtok = new CSVTokenizer(string, separator, quate, false);
        String[] tokens = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String token;
            tokens[i] = token = strtok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String makeUniqueName(String[] knownNames, String pattern) {
        HashSet<String> knownNamesSet = new HashSet<String>(knownNames.length);
        for (int i = 0; i < knownNames.length; ++i) {
            String name = knownNames[i];
            knownNamesSet.add(name);
        }
        MessageFormat message = new MessageFormat(pattern);
        Object[] objects = new Object[]{""};
        String plain = message.format(objects);
        if (!knownNamesSet.contains(plain)) {
            return plain;
        }
        Format[] formats = message.getFormats();
        if (formats.length == 0) {
            return null;
        }
        for (int count = 1; count < 2000000; ++count) {
            objects[0] = String.valueOf(count);
            String testFile = message.format(objects);
            if (knownNamesSet.contains(testFile)) continue;
            return testFile;
        }
        return null;
    }

    public static String[] merge(String[] first, String[] second) {
        int i;
        if (first.length == 0) {
            return (String[])second.clone();
        }
        if (second.length == 0) {
            return (String[])first.clone();
        }
        HashSet<String> total = new HashSet<String>(first.length + second.length);
        for (i = 0; i < first.length; ++i) {
            total.add(first[i]);
        }
        for (i = 0; i < second.length; ++i) {
            total.add(second[i]);
        }
        return total.toArray(new String[total.size()]);
    }

    public static boolean toBoolean(String source) {
        return StringUtils.toBoolean(source, false);
    }

    public static boolean toBoolean(String source, boolean nullDefault) {
        if (source == null) {
            return nullDefault;
        }
        return TRUE.equals(source = source.trim().toLowerCase()) || YES.equals(source) || ON.equals(source);
    }

    public static boolean isEmpty(String source) {
        return StringUtils.isEmpty(source, true);
    }

    public static boolean isEmpty(String source, boolean trim) {
        if (source == null) {
            return true;
        }
        if (source.length() == 0) {
            return true;
        }
        if (!trim) {
            return false;
        }
        char[] chars = source.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equalsIgnoreCase(s2);
    }
}

