"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_deselected_data_series_1 = require("../../../../state/selectors/get_deselected_data_series");
var get_color_scale_1 = require("./get_color_scale");
var heatmap_spec_1 = require("./heatmap_spec");
exports.computeLegendSelector = re_reselect_1.default([heatmap_spec_1.getSpecOrNull, get_color_scale_1.getColorScale, get_deselected_data_series_1.getDeselectedSeriesSelector], function (spec, colorScale, deselectedDataSeries) {
    var legendItems = [];
    if (colorScale === null || spec === null) {
        return legendItems;
    }
    return colorScale.ticks.map(function (tick) {
        var color = colorScale.config(tick);
        var seriesIdentifier = {
            key: String(tick),
            specId: String(tick),
        };
        return {
            color: color,
            label: "> " + tick,
            seriesIdentifier: seriesIdentifier,
            isSeriesHidden: deselectedDataSeries.some(function (dataSeries) { return dataSeries.key === seriesIdentifier.key; }),
            isToggleable: true,
        };
    });
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_legend.js.map