/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Map;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.ACKSender;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.MessageReceiver;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Log;

class InboundMessageFragments {
    private final RouterContext _context;
    private final Log _log;
    private DecayingBloomFilter _recentlyCompletedMessages;
    private final OutboundMessageFragments _outbound;
    private final UDPTransport _transport;
    private final ACKSender _ackSender;
    private final MessageReceiver _messageReceiver;
    private volatile boolean _alive;
    private static final int DECAY_PERIOD = 10000;

    public InboundMessageFragments(RouterContext ctx, OutboundMessageFragments outbound, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageFragments.class);
        this._outbound = outbound;
        this._transport = transport;
        this._ackSender = new ACKSender(this._context, this._transport);
        this._messageReceiver = new MessageReceiver(this._context, this._transport);
        this._context.statManager().createRateStat("udp.receivedCompleteTime", "How long it takes to receive a full message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivedCompleteFragments", "How many fragments go in a fully received message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivedACKs", "How many messages were ACKed at a time", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignoreRecentDuplicate", "Take note that we received a packet for a recently completed message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePiggyback", "How many acks were included in a packet with data fragments (time == # data fragments)", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._alive = true;
        this._recentlyCompletedMessages = new DecayingHashSet(this._context, 10000, 4, "UDPIMF");
        this._ackSender.startup();
        this._messageReceiver.startup();
    }

    public synchronized void shutdown() {
        this._alive = false;
        if (this._recentlyCompletedMessages != null) {
            this._recentlyCompletedMessages.stopDecaying();
        }
        this._recentlyCompletedMessages = null;
        this._ackSender.shutdown();
        this._messageReceiver.shutdown();
    }

    public boolean isAlive() {
        return this._alive;
    }

    public void receiveData(PeerState from, UDPPacketReader.DataReader data) {
        block4: {
            try {
                this.rcvData(from, data);
            }
            catch (DataFormatException dfe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bad pkt from: " + from, dfe);
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Bad pkt from: " + from, ioobe);
            }
        }
    }

    private void rcvData(PeerState from, UDPPacketReader.DataReader data) throws DataFormatException {
        int fragmentsIncluded = this.receiveMessages(from, data);
        int acksIncluded = this.receiveACKs(from, data);
        from.packetReceived(data.getPacketSize());
        if (fragmentsIncluded > 0 && acksIncluded > 0) {
            this._context.statManager().addRateData("udp.receivePiggyback", acksIncluded, fragmentsIncluded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveMessages(PeerState from, UDPPacketReader.DataReader data) throws DataFormatException {
        int fragments = data.readFragmentCount();
        if (fragments <= 0) {
            return fragments;
        }
        Hash fromPeer = from.getRemotePeer();
        Map<Long, InboundMessageState> messages = from.getInboundMessages();
        for (int i = 0; i < fragments; ++i) {
            boolean fragmentOK;
            InboundMessageState state;
            long mid = data.readMessageId(i);
            Long messageId = mid;
            if (this._recentlyCompletedMessages.isKnown(mid)) {
                if (data.readMessageFragmentNum(i) != 0) continue;
                this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
                from.messageFullyReceived(messageId, -1);
                this._ackSender.ackPeer(from);
                if (this._log.shouldLog(20)) {
                    this._log.info("Message received is a dup: " + mid + " dups: " + this._recentlyCompletedMessages.getCurrentDuplicateCount() + " out of " + this._recentlyCompletedMessages.getInsertedCount());
                }
                this._context.messageHistory().droppedInboundMessage(mid, from.getRemotePeer(), "dup");
                continue;
            }
            boolean messageComplete = false;
            boolean messageExpired = false;
            boolean partialACK = false;
            Map<Long, InboundMessageState> map = messages;
            synchronized (map) {
                boolean isNew = false;
                state = messages.get(messageId);
                if (state == null) {
                    state = new InboundMessageState(this._context, mid, fromPeer, data, i);
                    isNew = true;
                    fragmentOK = true;
                } else {
                    fragmentOK = state.receiveFragment(data, i);
                }
                if (state.isComplete()) {
                    messageComplete = true;
                    if (!isNew) {
                        messages.remove(messageId);
                    }
                } else if (state.isExpired()) {
                    messageExpired = true;
                    if (!isNew) {
                        messages.remove(messageId);
                    }
                } else {
                    partialACK = true;
                    if (isNew) {
                        messages.put(messageId, state);
                    }
                }
            }
            if (messageComplete) {
                this._recentlyCompletedMessages.add(mid);
                from.messageFullyReceived(messageId, state.getCompleteSize());
                this._ackSender.ackPeer(from);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Message received completely!  " + state);
                }
                this._context.statManager().addRateData("udp.receivedCompleteTime", state.getLifetime(), state.getLifetime());
                if (state.getFragmentCount() > 0) {
                    this._context.statManager().addRateData("udp.receivedCompleteFragments", state.getFragmentCount(), state.getLifetime());
                }
                this._messageReceiver.receiveMessage(state);
            } else if (messageExpired) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Message expired while only being partially read: " + state);
                }
                this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "expired while partially read: " + state.toString());
                state.releaseResources();
            } else if (partialACK) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Queueing up a partial ACK for peer: " + from + " for " + state);
                }
                from.messagePartiallyReceived();
                this._ackSender.ackPeer(from);
            }
            if (!fragmentOK) break;
        }
        from.expireInboundMessages();
        return fragments;
    }

    private int receiveACKs(PeerState from, UDPPacketReader.DataReader data) throws DataFormatException {
        boolean retx;
        ACKBitfield[] bitfields;
        int i;
        int rv = 0;
        boolean newAck = false;
        ModifiableLong highestSeqNumAcked = new ModifiableLong(-1L);
        if (data.readACKsIncluded()) {
            int ackCount = data.readACKCount();
            if (ackCount > 0) {
                rv += ackCount;
                this._context.statManager().addRateData("udp.receivedACKs", ackCount);
                for (i = 0; i < ackCount; ++i) {
                    long id = data.readACK(i);
                    if (!from.acked(id, highestSeqNumAcked)) continue;
                    if (this._log.shouldLog(10)) {
                        this._log.debug("First full ACK of message " + id + " received from " + from.getRemotePeer());
                    }
                    newAck = true;
                }
            } else {
                this._log.error("Received ACKs with no acks?! " + data);
            }
        }
        if (data.readACKBitfieldsIncluded() && (bitfields = data.readACKBitfields()) != null) {
            rv += bitfields.length;
            for (i = 0; i < bitfields.length; ++i) {
                if (!from.acked(bitfields[i], highestSeqNumAcked)) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Partial ACK received: " + bitfields[i] + " from " + from.getRemotePeer());
                }
                newAck = true;
            }
        }
        if (data.readECN()) {
            from.ECNReceived();
        } else {
            from.dataReceived();
        }
        long highest = highestSeqNumAcked.value;
        if (highest >= 0L && (retx = from.highestSeqNumAcked(highest))) {
            newAck = true;
        }
        return rv;
    }

    public static class ModifiableLong {
        public long value;

        public ModifiableLong(long val) {
            this.value = val;
        }
    }
}

