/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class EepHead
extends EepGet {
    static final OutputStream _dummyStream = new ByteArrayOutputStream(0);

    public EepHead(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String url) {
        super(ctx, true, proxyHost, proxyPort, numRetries, -1L, -1L, null, _dummyStream, url, true, null, null);
    }

    public static void main(String[] args) {
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        int numRetries = 0;
        int inactivityTimeout = 60000;
        String username = null;
        String password = null;
        boolean error = false;
        Getopt g = new Getopt("eephead", args, "p:cn:t:u:x:");
        try {
            int c;
            block12: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 112: {
                        String s = g.getOptarg();
                        int colon = s.indexOf(58);
                        if (colon >= 0) {
                            proxyHost = s.substring(0, colon);
                            String port = s.substring(colon + 1);
                            proxyPort = Integer.parseInt(port);
                            continue block12;
                        }
                        proxyHost = s;
                        continue block12;
                    }
                    case 99: {
                        proxyHost = "";
                        proxyPort = 0;
                        continue block12;
                    }
                    case 110: {
                        numRetries = Integer.parseInt(g.getOptarg());
                        continue block12;
                    }
                    case 116: {
                        inactivityTimeout = 1000 * Integer.parseInt(g.getOptarg());
                        continue block12;
                    }
                    case 117: {
                        username = g.getOptarg();
                        continue block12;
                    }
                    case 120: {
                        password = g.getOptarg();
                        continue block12;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            EepHead.usage();
            System.exit(1);
        }
        String url = args[g.getOptind()];
        EepHead get = new EepHead(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, numRetries, url);
        if (username != null) {
            if (password == null) {
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        System.err.print("Proxy password: ");
                        password = r.readLine();
                        if (password != null) continue;
                        throw new IOException();
                    } while ((password = password.trim()).length() <= 0);
                }
                catch (IOException ioe) {
                    System.exit(1);
                }
            }
            get.addAuthorization(username, password);
        }
        if (get.fetch(45000L, -1L, inactivityTimeout)) {
            String x = get.getContentType();
            if (x != null) {
                System.err.println("Content-Type: " + x);
            }
            System.err.println("Content-Length: " + get.getContentLength());
            x = get.getLastModified();
            if (x != null) {
                System.err.println("Last-Modified: " + x);
            }
            if ((x = get.getETag()) != null) {
                System.err.println("Etag: " + x);
            }
        } else {
            System.err.println("Failed " + url);
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("EepHead [-p 127.0.0.1[:4444]] [-c]\n        [-n #retries] (default 0)\n        [-t timeout]  (default 60 sec)\n        [-u username] [-x password] url\n        (use -c or -p :0 for no proxy)");
    }

    @Override
    protected void doFetch(SocketTimeout timeout) throws IOException {
        this._aborted = false;
        this.readHeaders();
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(60000L);
            }
        }
        if (this._redirectLocation != null) {
            try {
                if (this._redirectLocation.startsWith("http://")) {
                    this._actualURL = this._redirectLocation;
                } else {
                    URI url = new URI(this._actualURL);
                    String host = url.getHost();
                    if (host == null) {
                        throw new MalformedURLException("Redirected to invalid URL");
                    }
                    int port = url.getPort();
                    if (port < 0) {
                        port = 80;
                    }
                    this._actualURL = this._redirectLocation.startsWith("/") ? "http://" + host + ":" + port + this._redirectLocation : "http://" + host + ":" + port + "/" + this._redirectLocation;
                }
            }
            catch (URISyntaxException use) {
                MalformedURLException ioe = new MalformedURLException("Redirected to invalid URL");
                ioe.initCause(use);
                throw ioe;
            }
            EepGet.AuthState as = this._authState;
            if (this._responseCode == 407) {
                if (!this._shouldProxy) {
                    throw new IOException("Proxy auth response from non-proxy");
                }
                if (as == null) {
                    throw new IOException("Proxy requires authentication");
                }
                if (as.authSent) {
                    throw new IOException("Proxy authentication failed");
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Adding auth");
                }
            } else {
                ++this._redirects;
                if (this._redirects > 5) {
                    throw new IOException("Too many redirects: to " + this._redirectLocation);
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Redirecting to " + this._redirectLocation);
                }
                if (as != null) {
                    as.authSent = false;
                }
            }
            this._bytesRemaining = -1L;
            this._redirectLocation = null;
            this._etag = null;
            this._lastModified = null;
            this._contentType = null;
            this._encodingChunked = false;
            this.sendRequest(timeout);
            this.doFetch(timeout);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely");
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        timeout.cancel();
        if (this._transferFailed) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, 0L, 0L, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(0L, 0L, 0L, this._url, "dummy", false);
            }
        }
    }

    @Override
    protected String getRequest() throws IOException {
        String urlToSend;
        URI url;
        StringBuilder buf = new StringBuilder(512);
        try {
            url = new URI(this._actualURL);
        }
        catch (URISyntaxException use) {
            MalformedURLException ioe = new MalformedURLException("Bad URL");
            ioe.initCause(use);
            throw ioe;
        }
        String host = url.getHost();
        if (host == null) {
            throw new MalformedURLException("Bad URL");
        }
        int port = url.getPort();
        String path = url.getRawPath();
        String query = url.getRawQuery();
        if (this._log.shouldLog(10)) {
            this._log.debug("Requesting " + this._actualURL);
        }
        if (this._shouldProxy) {
            urlToSend = this._actualURL;
            if (!(path != null && path.length() > 0 || query != null && query.length() > 0)) {
                urlToSend = urlToSend + "/";
            }
        } else {
            urlToSend = path;
            if (urlToSend == null || urlToSend.length() <= 0) {
                urlToSend = "/";
            }
            if (query != null) {
                urlToSend = urlToSend + '?' + query;
            }
        }
        buf.append("HEAD ").append(urlToSend).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(host);
        if (port >= 0) {
            buf.append(':').append(port);
        }
        buf.append("\r\n");
        buf.append("Accept-Encoding: \r\n");
        buf.append("User-Agent: Wget/1.11.4\r\n");
        if (this._authState != null && this._shouldProxy && this._authState.authMode != EepGet.AUTH_MODE.NONE) {
            buf.append("Proxy-Authorization: ");
            buf.append(this._authState.getAuthHeader("HEAD", urlToSend));
            buf.append("\r\n");
        }
        buf.append("Connection: close\r\n\r\n");
        if (this._log.shouldLog(10)) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }

    public long getContentLength() {
        return this._bytesRemaining;
    }
}

