/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap<K, V>
implements Map<K, V> {
    private HashMap<K, WeakValueRef<K, V>> hashMap;
    private ReferenceQueue<V> refQueue;

    public WeakValueHashMap() {
        this.hashMap = new HashMap();
        this.refQueue = new ReferenceQueue();
    }

    public WeakValueHashMap(int initialSize) {
        this.hashMap = new HashMap(initialSize);
        this.refQueue = new ReferenceQueue();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValueRef<K, V> ref = new WeakValueRef<K, V>(key, value, this.refQueue);
        WeakValueRef<K, V> oldRef = this.hashMap.put(key, ref);
        if (oldRef != null) {
            return (V)oldRef.get();
        }
        return null;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        WeakValueRef<K, V> ref = this.hashMap.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hashMap.size();
    }

    @Override
    public void clear() {
        this.hashMap.clear();
        this.refQueue = new ReferenceQueue();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.hashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.hashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (WeakValueRef<K, V> ref : this.hashMap.values()) {
            if (!value.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        ArrayList list = new ArrayList(this.hashMap.size());
        for (WeakValueRef<K, V> ref : this.hashMap.values()) {
            Object value = ref.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> list = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<K, WeakValueRef<K, V>>> entrySet = this.hashMap.entrySet();
        for (Map.Entry<K, WeakValueRef<K, V>> next : entrySet) {
            WeakValueRef<K, V> valueRef = next.getValue();
            Object value = valueRef.get();
            if (value == null) continue;
            list.add(new GeneratedEntry(next.getKey(), value));
        }
        return list;
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.hashMap.keySet();
    }

    @Override
    public V remove(Object key) {
        WeakValueRef<K, V> ref = this.hashMap.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    private void processQueue() {
        WeakValueRef ref;
        while ((ref = (WeakValueRef)this.refQueue.poll()) != null) {
            this.hashMap.remove(ref.key);
        }
    }

    static class WeakValueRef<K, V>
    extends WeakReference<V> {
        K key;

        WeakValueRef(K key, V value, ReferenceQueue<V> refQueue) {
            super(value, refQueue);
            this.key = key;
        }
    }

    class GeneratedEntry
    implements Map.Entry<K, V> {
        K key;
        V value;

        GeneratedEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            return WeakValueHashMap.this.put(this.key, value);
        }
    }
}

