/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.prop.PropertySet;

public class PropertySetIndexRangeIterator
implements IndexRangeIterator {
    LongIterator longIt;
    IndexRange indexRange;

    public PropertySetIndexRangeIterator(PropertySet set, long start) {
        this.longIt = set.getPropertyIterator(start + 1L);
        this.indexRange = this.longIt.hasNext() ? new IndexRange(start, this.longIt.next() - 1L) : new IndexRange(start, Long.MAX_VALUE);
    }

    @Override
    public boolean hasNext() {
        return this.indexRange != null;
    }

    @Override
    public IndexRange next() {
        IndexRange temp = this.indexRange;
        this.getNextIndexRange();
        return temp;
    }

    private void getNextIndexRange() {
        if (this.indexRange == null) {
            return;
        }
        long oldEnd = this.indexRange.getEnd();
        if (oldEnd == Long.MAX_VALUE) {
            this.indexRange = null;
            return;
        }
        if (this.longIt.hasNext()) {
            this.indexRange = new IndexRange(oldEnd + 1L, this.longIt.next() - 1L);
            return;
        }
        this.indexRange = new IndexRange(oldEnd + 1L, Long.MAX_VALUE);
    }
}

