/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedColor;
import ghidra.framework.options.WrappedCustomOption;
import ghidra.framework.options.WrappedDate;
import ghidra.framework.options.WrappedFile;
import ghidra.framework.options.WrappedFont;
import ghidra.framework.options.WrappedKeyStroke;
import ghidra.framework.options.WrappedOption;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Content;
import org.jdom.Element;

public class ToolOptions
extends AbstractOptions {
    public static final Set<Class<?>> PRIMITIVE_CLASSES = ToolOptions.buildPrimitiveClassSet();
    public static final Set<Class<?>> WRAPPABLE_CLASSES = ToolOptions.buildWrappableClassSet();
    public static final String XML_ELEMENT_NAME = "CATEGORY";

    private static Set<Class<?>> buildPrimitiveClassSet() {
        HashSet set = new HashSet();
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Boolean.class);
        set.add(String.class);
        return set;
    }

    private static Set<Class<?>> buildWrappableClassSet() {
        HashSet set = new HashSet();
        set.add(Color.class);
        set.add(Font.class);
        set.add(KeyStroke.class);
        set.add(File.class);
        return set;
    }

    public ToolOptions(String name) {
        super(name);
    }

    public ToolOptions copy() {
        return new ToolOptions(this.getXmlRoot(true));
    }

    public ToolOptions(Element root) {
        this(root.getAttributeValue("NAME"));
        Option option;
        SaveState saveState = new SaveState(root);
        for (String optionName : saveState.getNames()) {
            Object object = saveState.getObject(optionName);
            option = this.createUnregisteredOption(optionName, OptionType.getOptionType(object), null);
            option.doSetCurrentValue(object);
            this.valueMap.put(optionName, option);
        }
        Iterator iter = root.getChildren("WRAPPED_OPTION").iterator();
        while (iter.hasNext()) {
            try {
                Element elem = (Element)iter.next();
                String optionName = elem.getAttributeValue("NAME");
                Class<?> c = Class.forName(elem.getAttributeValue("CLASS"));
                WrappedOption wo = (WrappedOption)c.newInstance();
                wo.readState(new SaveState(elem));
                option = this.createUnregisteredOption(optionName, wo.getOptionType(), null);
                option.doSetCurrentValue(wo.getObject());
                this.valueMap.put(optionName, option);
            }
            catch (Exception exc) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    public Element getXmlRoot(boolean includeDefaultBindings) {
        SaveState saveState = new SaveState(XML_ELEMENT_NAME);
        for (String optionName : this.valueMap.keySet()) {
            Object value;
            Option optionValue = (Option)this.valueMap.get(optionName);
            if (!includeDefaultBindings && optionValue.isDefault() || !this.isSupportedBySaveState(value = optionValue.getValue(null))) continue;
            saveState.putObject(optionName, value);
        }
        Element root = saveState.saveToXml();
        root.setAttribute("NAME", this.name);
        for (String optionName : this.valueMap.keySet()) {
            Object value;
            Option optionValue = (Option)this.valueMap.get(optionName);
            if (!includeDefaultBindings && optionValue.isDefault() || (value = optionValue.getValue(null)) == null || this.isSupportedBySaveState(value)) continue;
            WrappedOption wrappedOption = this.wrapOption(value);
            SaveState ss = new SaveState("WRAPPED_OPTION");
            wrappedOption.writeState(ss);
            Element elem = ss.saveToXml();
            elem.setAttribute("NAME", optionName);
            elem.setAttribute("CLASS", wrappedOption.getClass().getName());
            root.addContent((Content)elem);
        }
        return root;
    }

    private boolean isSupportedBySaveState(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Enum) {
            return true;
        }
        if (obj instanceof byte[]) {
            return true;
        }
        return PRIMITIVE_CLASSES.contains(obj.getClass());
    }

    private WrappedOption wrapOption(Object value) {
        if (value instanceof CustomOption) {
            return new WrappedCustomOption((CustomOption)value);
        }
        if (value instanceof Color) {
            return new WrappedColor((Color)value);
        }
        if (value instanceof Font) {
            return new WrappedFont((Font)value);
        }
        if (value instanceof KeyStroke) {
            return new WrappedKeyStroke((KeyStroke)value);
        }
        if (value instanceof File) {
            return new WrappedFile((File)value);
        }
        if (value instanceof Date) {
            return new WrappedDate((Date)value);
        }
        throw new AssertException("Attempted to wrap object of unexpected class type: " + value.getClass());
    }

    public void addOptionsChangeListener(OptionsChangeListener l) {
        this.listeners.add(l);
    }

    public void takeListeners(ToolOptions oldOptions) {
        this.listeners = oldOptions.listeners;
        oldOptions.listeners = null;
    }

    public void removeOptionsChangeListener(OptionsChangeListener l) {
        this.listeners.remove(l);
    }

    public void removeUnusedOptions() {
        ArrayList optionNames = new ArrayList(this.valueMap.keySet());
        for (String optionName : optionNames) {
            Option optionState = (Option)this.valueMap.get(optionName);
            if (optionState.isRegistered()) continue;
            this.removeOption(optionName);
        }
    }

    public void copyOptions(Options newOptions) {
        List<String> optionNames = newOptions.getOptionNames();
        for (String optionName : optionNames) {
            Object value = newOptions.getObject(optionName, null);
            if (value == null) continue;
            this.putObject(optionName, value);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolOptions other = (ToolOptions)obj;
        if (!SystemUtilities.isEqual((Object)this.name, (Object)other.name)) {
            return false;
        }
        List<String> optionNames = this.getOptionNames();
        List<String> otherOptionNames = other.getOptionNames();
        if (optionNames.size() != otherOptionNames.size()) {
            return false;
        }
        Object dummy = new Object();
        for (String string : optionNames) {
            Object otherValue;
            Object myValue = this.getObject(string, dummy);
            if (SystemUtilities.isEqual((Object)myValue, (Object)(otherValue = other.getObject(string, dummy)))) continue;
            return false;
        }
        return true;
    }

    public void validateOptions() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        Set keySet = this.valueMap.keySet();
        for (String propertyName : keySet) {
            Option optionState = (Option)this.valueMap.get(propertyName);
            if (optionState.isRegistered()) continue;
            Msg.warn((Object)this, (Object)("Unregistered property \"" + propertyName + "\" in Options \"" + this.name + "\"\n     " + optionState.getInceptionInformation()));
        }
    }

    public void registerOptions(ToolOptions oldOptions) {
        Set optionNameSet = oldOptions.valueMap.keySet();
        for (String optionName : optionNameSet) {
            Option option = (Option)oldOptions.valueMap.get(optionName);
            if (!option.isRegistered()) continue;
            this.registerOption(optionName, option.getOptionType(), option.getDefaultValue(), option.getHelpLocation(), option.getDescription());
        }
    }

    @Override
    protected Option createRegisteredOption(String optionName, OptionType type, String description, HelpLocation help, Object defaultValue, PropertyEditor editor) {
        return new ToolOption(optionName, type, description, help, defaultValue, true, editor);
    }

    @Override
    protected Option createUnregisteredOption(String optionName, OptionType type, Object defaultValue) {
        return new ToolOption(optionName, type, null, null, defaultValue, false, null);
    }

    @Override
    protected boolean notifyOptionChanged(String optionName, Object oldValue, Object newValue) {
        NotifyListenersRunnable runnable = new NotifyListenersRunnable(optionName, oldValue, newValue);
        SystemUtilities.runSwingNow((Runnable)runnable);
        return !runnable.wasVetoed();
    }

    private static class ToolOption
    extends Option {
        private Object currentValue;

        ToolOption(String name, OptionType type, String description, HelpLocation helpLocation, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
            super(name, type, description, helpLocation, defaultValue, isRegistered, editor);
        }

        @Override
        public Object getCurrentValue() {
            return this.currentValue;
        }

        @Override
        public void doSetCurrentValue(Object value) {
            this.currentValue = value;
        }
    }

    private class NotifyListenersRunnable
    implements Runnable {
        private String optionName;
        private Object oldValue;
        private Object newValue;
        private boolean vetoed;

        NotifyListenersRunnable(String optionName, Object oldValue, Object newValue) {
            this.optionName = optionName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            ArrayList<OptionsChangeListener> notifiedListeners = new ArrayList<OptionsChangeListener>();
            try {
                for (OptionsChangeListener listener : ToolOptions.this.listeners) {
                    listener.optionsChanged(ToolOptions.this, this.optionName, this.oldValue, this.newValue);
                    notifiedListeners.add(listener);
                }
            }
            catch (OptionsVetoException e) {
                this.vetoed = true;
                for (OptionsChangeListener notifiedListener : notifiedListeners) {
                    notifiedListener.optionsChanged(ToolOptions.this, this.optionName, this.newValue, this.oldValue);
                }
            }
        }

        public boolean wasVetoed() {
            return this.vetoed;
        }
    }
}

