/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.Application;
import ghidra.framework.ApplicationIdentifier;
import ghidra.framework.preferences.Preferences;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GenericRunInfo {
    public static final String TEST_DIRECTORY_SUFFIX = "-Test";

    private static List<File> getUserSettingsDirsByTime() {
        File userDataDirectory = Application.getUserSettingsDirectory();
        File userDataDirParentFile = userDataDirectory.getParentFile();
        List<File> applicationDirectories = GenericRunInfo.collectAllApplicationDirectories(userDataDirParentFile);
        Comparator userDirModifyComparator = (f1, f2) -> {
            long modify2;
            File prefs1 = new File((File)f1, "preferences");
            File prefs2 = new File((File)f2, "preferences");
            if (!prefs1.exists() || !prefs2.exists()) {
                if (!prefs1.exists()) {
                    if (!prefs2.exists()) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
            long modify1 = prefs1.lastModified();
            if (modify1 == (modify2 = prefs2.lastModified())) {
                return f1.getName().compareTo(f2.getName());
            }
            return modify1 < modify2 ? 1 : -1;
        };
        Collections.sort(applicationDirectories, userDirModifyComparator);
        return applicationDirectories;
    }

    private static List<File> collectAllApplicationDirectories(File dataDirectoryParentDir) {
        FileFilter userDirFilter = f -> {
            String name = f.getName();
            Application.getName();
            String userSettingsDirPrefix = "." + Application.getName().replaceAll("\\s", "").toLowerCase();
            return f.isDirectory() && name.startsWith(userSettingsDirPrefix) && !name.endsWith(TEST_DIRECTORY_SUFFIX);
        };
        File[] currentStyleUserDirs = dataDirectoryParentDir.listFiles(userDirFilter);
        File userHomeDir = dataDirectoryParentDir.getParentFile();
        if (userHomeDir == null) {
            throw new IllegalArgumentException("Must specify an absolute path; found instead: " + dataDirectoryParentDir);
        }
        File[] oldStyleUserDirs = userHomeDir.listFiles(userDirFilter);
        ArrayList<File> allDirs = new ArrayList<File>();
        if (currentStyleUserDirs != null) {
            for (File file : currentStyleUserDirs) {
                allDirs.add(file);
            }
        }
        if (oldStyleUserDirs != null) {
            for (File file : oldStyleUserDirs) {
                allDirs.add(file);
            }
        }
        return allDirs;
    }

    public static File getPreviousApplicationSettingsFile(String filename) {
        List<File> settingsDirs = GenericRunInfo.getPreviousApplicationSettingsDirsByTime();
        for (File dir : settingsDirs) {
            String altFilePath;
            File file;
            String dirPath = dir.getPath();
            if (dirPath.endsWith("Test") || !(file = new File(altFilePath = dirPath + File.separatorChar + filename)).exists()) continue;
            return file;
        }
        return null;
    }

    public static List<File> getPreviousApplicationSettingsDirsByTime() {
        ArrayList<File> applicationSettiingsDirs = new ArrayList<File>();
        ApplicationIdentifier myIdentifier = new ApplicationIdentifier(Application.getApplicationLayout().getApplicationProperties());
        for (File dir : GenericRunInfo.getUserSettingsDirsByTime()) {
            String dirName = dir.getName();
            if (dirName.equals(Application.getUserSettingsDirectory().getName())) continue;
            if (dirName.startsWith(".")) {
                dirName = dirName.substring(1);
            }
            try {
                if (!new ApplicationIdentifier(dirName).getApplicationReleaseName().equals(myIdentifier.getApplicationReleaseName())) continue;
                applicationSettiingsDirs.add(dir);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return applicationSettiingsDirs;
    }

    public static String getProjectsDirPath() {
        String path = Preferences.getProperty("ProjectDirectory", null, true);
        if (path != null && new File(path).isDirectory()) {
            return path;
        }
        return System.getProperty("user.home");
    }

    public static void setProjectsDirPath(String path) {
        if (path != null && new File(path).isDirectory()) {
            Preferences.setProperty("ProjectDirectory", path);
        }
    }
}

