/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sparseimage.SparseHeader;
import ghidra.file.formats.sparseimage.SparseImageFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryWithFile;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class SparseImageFileSystemFactory
implements GFileSystemFactoryWithFile<SparseImageFileSystem>,
GFileSystemProbeFull {
    public SparseImageFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        return new SparseImageFileSystem(targetFSRL, containerFSRL, fsService, monitor);
    }

    public boolean probe(FSRL containerFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        BinaryReader reader = new BinaryReader(byteProvider, true);
        SparseHeader header = new SparseHeader(reader);
        return header.getMagic() == -316211398;
    }
}

