/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.util.UndefinedFunction;

public class EditDataTypeAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public EditDataTypeAction(PluginTool tool, DecompilerController controller) {
        super("EditDataType");
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Edit Data Type"}, "Decompile"));
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return context instanceof DecompilerActionContext;
    }

    private boolean hasCustomEditorForBaseDataType(DataType dataType) {
        DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)dataType);
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        return baseDataType != null && service.isEditable(baseDataType);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = this.controller.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        DataType dataType = DecompilerUtils.getDataType(context);
        if (dataType == null) {
            return false;
        }
        return this.hasCustomEditorForBaseDataType(dataType);
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DataType dataType = DecompilerUtils.getDataType(context);
        DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)dataType);
        DataTypeManager dataTypeManager = context.getProgram().getDataTypeManager();
        DataTypeManager baseDtDTM = baseDataType.getDataTypeManager();
        if (baseDtDTM != dataTypeManager) {
            baseDataType = baseDataType.clone(dataTypeManager);
        }
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        service.edit(baseDataType);
    }
}

