/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.internal.InProgressGTreeNode;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

abstract class CoreGTreeNode
implements GTreeNode {
    private static InProgressGTreeNode IN_PROGRESS_NODE = new InProgressGTreeNode();
    private static List<GTreeNode> IN_PROGRESS_CHILDREN = Collections.unmodifiableList(Arrays.asList(IN_PROGRESS_NODE));
    private GTreeNode parent;
    private List<GTreeNode> allChildrenList = null;
    private List<GTreeNode> activeChildrenList = null;

    CoreGTreeNode() {
    }

    @Override
    public synchronized GTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void dispose() {
        this.parent = null;
        if (this.allChildrenList == null) {
            return;
        }
        for (GTreeNode node : this.allChildrenList) {
            node.dispose();
        }
        this.allChildrenList = null;
        this.activeChildrenList = null;
    }

    @Override
    public synchronized boolean isInProgress() {
        return this.activeChildrenList == IN_PROGRESS_CHILDREN;
    }

    protected void setInProgress() {
        this.doSetActiveChildren(IN_PROGRESS_CHILDREN);
    }

    public synchronized boolean isChildrenLoadedOrInProgress() {
        return this.activeChildrenList != null;
    }

    protected synchronized boolean isChildrenLoaded() {
        return this.allChildrenList != null;
    }

    protected synchronized int doGetChildCount() {
        if (this.activeChildrenList != null) {
            return this.activeChildrenList.size();
        }
        return 0;
    }

    protected synchronized int doGetAllChildCount() {
        if (this.allChildrenList != null) {
            return this.allChildrenList.size();
        }
        return 0;
    }

    protected synchronized List<GTreeNode> doGetAllChildren() {
        if (this.allChildrenList == null) {
            return Collections.emptyList();
        }
        return new ArrayList<GTreeNode>(this.allChildrenList);
    }

    protected synchronized List<GTreeNode> doGetActiveChildren() {
        if (this.activeChildrenList == null) {
            return Collections.emptyList();
        }
        return new ArrayList<GTreeNode>(this.activeChildrenList);
    }

    protected synchronized GTreeNode doGetChild(int index) {
        if (this.activeChildrenList == null) {
            return null;
        }
        if (index < 0 || index >= this.activeChildrenList.size()) {
            return null;
        }
        return this.activeChildrenList.get(index);
    }

    protected synchronized int doGetIndexOfChild(GTreeNode node) {
        if (this.activeChildrenList == null) {
            return -1;
        }
        return this.activeChildrenList.indexOf(node);
    }

    protected synchronized int doGetIndexOfChild(GTreeNode node, List<GTreeNode> children) {
        if (children == null) {
            return -1;
        }
        return children.indexOf(node);
    }

    protected void doAddNode(final int index, final GTreeNode child) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.swingAddNode(index, child);
            return;
        }
        SystemUtilities.runSwingNow((Runnable)new Runnable(){

            @Override
            public void run() {
                CoreGTreeNode.this.swingAddNode(index, child);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swingAddNode(int index, GTreeNode child) {
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            if (this.allChildrenList == null) {
                this.allChildrenList = new ArrayList<GTreeNode>();
                this.activeChildrenList = this.allChildrenList;
            }
            if (this.allChildrenList.contains(child)) {
                return;
            }
            ((CoreGTreeNode)child).parent = this;
            if (index < 0 || index >= this.allChildrenList.size()) {
                index = this.allChildrenList.size();
            }
            this.allChildrenList.add(index, child);
        }
        this.fireNodeAdded(this, child);
    }

    @Override
    public void removeNode(final GTreeNode node) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.swingRemoveNode(node);
            return;
        }
        SystemUtilities.runSwingNow((Runnable)new Runnable(){

            @Override
            public void run() {
                CoreGTreeNode.this.swingRemoveNode(node);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swingRemoveNode(GTreeNode node) {
        int index;
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            ((CoreGTreeNode)node).parent = null;
            if (this.activeChildrenList == null) {
                return;
            }
            index = this.activeChildrenList.indexOf(node);
            if (index >= 0) {
                this.activeChildrenList.remove(index);
            }
            if (this.allChildrenList != this.activeChildrenList && this.allChildrenList != null) {
                this.allChildrenList.remove(node);
            }
        }
        if (index >= 0) {
            this.fireNodeRemoved(this, node, index);
        }
    }

    protected void doSetChildren(final List<GTreeNode> childList, final boolean notify) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.swingSetChildren(childList, notify, false);
            return;
        }
        SystemUtilities.runSwingNow((Runnable)new Runnable(){

            @Override
            public void run() {
                CoreGTreeNode.this.swingSetChildren(childList, notify, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swingSetChildren(List<GTreeNode> childList, boolean notify, boolean onlyIfInProgress) {
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            if (childList == null) {
                this.allChildrenList = null;
                this.activeChildrenList = null;
            } else {
                if (onlyIfInProgress && !this.isInProgress()) {
                    return;
                }
                for (GTreeNode child : childList) {
                    ((CoreGTreeNode)child).parent = this;
                }
                this.allChildrenList = new ArrayList<GTreeNode>(childList);
                this.activeChildrenList = this.allChildrenList;
            }
        }
        if (notify) {
            this.notifyNodeStructureChanged(this);
        }
    }

    protected void doSetActiveChildren(final List<GTreeNode> childList) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.swingSetActiveChilren(childList);
            return;
        }
        SystemUtilities.runSwingNow((Runnable)new Runnable(){

            @Override
            public void run() {
                CoreGTreeNode.this.swingSetActiveChilren(childList);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swingSetActiveChilren(List<GTreeNode> childList) {
        CoreGTreeNode coreGTreeNode = this;
        synchronized (coreGTreeNode) {
            this.activeChildrenList = childList;
        }
        this.notifyNodeStructureChanged(this);
    }

    protected void doResetActiveChildren() {
        this.doSetActiveChildren(this.allChildrenList);
    }

    @Override
    public void fireNodeChanged(final GTreeNode parentNode, final GTreeNode node) {
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CoreGTreeNode.this.notifyNodeChanged(parentNode, node);
            }
        });
    }

    private void notifyNodeChanged(GTreeNode parentNode, GTreeNode node) {
        if (this.isAnyAncestorInProgress()) {
            return;
        }
        GTree tree = this.getTree();
        if (this.isInValidTree(tree)) {
            tree.getModel().fireNodeDataChanged(parentNode, node);
        }
    }

    private boolean isInValidTree(GTree tree) {
        return tree != null && !tree.isDisposed();
    }

    @Override
    public void fireNodeStructureChanged(final GTreeNode node) {
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CoreGTreeNode.this.notifyNodeStructureChanged(node);
            }
        });
    }

    private void notifyNodeStructureChanged(GTreeNode node) {
        if (this.isAnyAncestorInProgress()) {
            return;
        }
        GTree tree = this.getTree();
        if (this.isInValidTree(tree)) {
            tree.getModel().fireNodeStructureChanged(node);
        }
    }

    private void fireNodeAdded(GTreeNode parentNode, GTreeNode newNode) {
        GTree tree;
        if (!this.isAnyAncestorInProgress() && this.isInValidTree(tree = this.getTree())) {
            tree.getModel().fireNodeAdded(parentNode, newNode);
        }
    }

    private void fireNodeRemoved(GTreeNode parentNode, GTreeNode removedNode, int deletedChildIndex) {
        GTree tree;
        if (!this.isAnyAncestorInProgress() && this.isInValidTree(tree = this.getTree())) {
            tree.getModel().fireNodeRemoved(parentNode, removedNode, deletedChildIndex);
        }
    }

    private boolean isAnyAncestorInProgress() {
        for (GTreeNode node = this; node != null; node = node.getParent()) {
            if (!node.isInProgress()) continue;
            return true;
        }
        return false;
    }
}

