/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import java.awt.Toolkit;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NumberFormatter;

public class IntegerFormatter
extends NumberFormatter {
    private DocumentFilter myDocumentFilter = null;

    public IntegerFormatter() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setParseIntegerOnly(true);
        this.setFormat(numberFormat);
        this.setValueClass(Integer.class);
        this.setAllowsInvalid(true);
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        if (this.myDocumentFilter == null) {
            this.myDocumentFilter = this.createDocumentFilter();
        }
        return this.myDocumentFilter;
    }

    protected DocumentFilter createDocumentFilter() {
        return new PosiviteValueIntegerDocumentFilterWrapper(this.getFormat(), this.getOriginalDocumentFilter());
    }

    protected DocumentFilter getOriginalDocumentFilter() {
        return super.getDocumentFilter();
    }

    protected static class PosiviteValueIntegerDocumentFilterWrapper
    extends DocumentFilter {
        protected final DocumentFilter wrappedFilter;
        protected final Format format;

        PosiviteValueIntegerDocumentFilterWrapper(Format format, DocumentFilter wrappedFilter) {
            this.format = format;
            this.wrappedFilter = wrappedFilter;
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            StringBuilder buildy = new StringBuilder();
            Document document = fb.getDocument();
            buildy.append(document.getText(0, document.getLength()));
            buildy.delete(offset, offset + length);
            if (!this.isValidText(buildy.toString())) {
                this.warn();
                return;
            }
            this.wrappedFilter.remove(fb, offset, length);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            StringBuilder buildy = new StringBuilder();
            Document document = fb.getDocument();
            buildy.append(document.getText(0, document.getLength()));
            buildy.insert(offset, string);
            if (!this.isValidText(buildy.toString())) {
                this.warn();
                return;
            }
            this.wrappedFilter.insertString(fb, offset, string, attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
            StringBuilder buildy = new StringBuilder();
            Document document = fb.getDocument();
            buildy.append(document.getText(0, document.getLength()));
            buildy.replace(offset, offset + length, text);
            if (!this.isValidText(buildy.toString())) {
                this.warn();
                return;
            }
            this.wrappedFilter.replace(fb, offset, length, text, attr);
        }

        protected boolean isValidText(String text) {
            if (text.indexOf(45) != -1) {
                return false;
            }
            if ("".equals(text)) {
                return true;
            }
            if (this.containsNonNumericCharacters(text)) {
                return false;
            }
            Number number = this.parseText(text);
            if (number == null) {
                return false;
            }
            Long longValue = number.longValue();
            return longValue.compareTo(0L) >= 0;
        }

        private boolean containsNonNumericCharacters(String text) {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                char theChar = text.charAt(i);
                if (this.isDigit(theChar)) continue;
                return true;
            }
            return false;
        }

        protected boolean isDigit(char character) {
            return Character.isDigit(character);
        }

        protected Number parseText(String text) {
            try {
                Object parseObject = this.format.parseObject(text);
                if (!(parseObject instanceof Number)) {
                    return null;
                }
                return (Number)parseObject;
            }
            catch (ParseException pe) {
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        private void warn() {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

