/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import java.math.BigInteger;

public class FieldSelectionHelper {
    public static boolean isStringSelection(FieldSelection selection) {
        if (selection.getNumRanges() != 1) {
            return false;
        }
        FieldRange fieldRange = selection.getFieldRange(0);
        FieldLocation start = fieldRange.getStart();
        FieldLocation end = fieldRange.getEnd();
        return start.getIndex().equals(end.getIndex()) && start.fieldNum == end.fieldNum;
    }

    public static String getFieldSelectionText(FieldSelection selection, FieldPanel panel) {
        if (!FieldSelectionHelper.isStringSelection(selection)) {
            return null;
        }
        return FieldSelectionHelper.getTextForField(selection.getFieldRange(0), panel);
    }

    public static String getAllSelectedText(FieldSelection selection, FieldPanel panel) {
        StringBuffer buffy = new StringBuffer();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange fieldRange = selection.getFieldRange(i);
            buffy.append(FieldSelectionHelper.getTextForRange(fieldRange, panel));
            if (i == numRanges - 1) continue;
            buffy.append(' ');
        }
        return buffy.toString().trim();
    }

    private static String getTextForField(FieldRange fieldRange, FieldPanel panel) {
        FieldLocation startLoc = fieldRange.getStart();
        BigInteger index = startLoc.getIndex();
        int fieldNum = startLoc.fieldNum;
        int startRow = startLoc.row;
        int startCol = startLoc.col;
        FieldLocation endLoc = fieldRange.getEnd();
        int endRow = endLoc.row;
        int endCol = endLoc.col;
        Layout layout = panel.getLayoutModel().getLayout(index);
        if (layout == null) {
            return null;
        }
        Field field = layout.getField(fieldNum);
        if (field == null) {
            return null;
        }
        String text = field.getText();
        if (text == null) {
            return null;
        }
        int startPos = field.screenLocationToTextOffset(startRow, startCol);
        int endPos = field.screenLocationToTextOffset(endRow, endCol);
        if (startPos < 0 || startPos >= text.length() || endPos < 0 || endPos > text.length()) {
            return null;
        }
        return text.substring(startPos, endPos);
    }

    private static String getTextForRange(FieldRange fieldRange, FieldPanel panel) {
        FieldLocation startLoc = fieldRange.getStart();
        FieldLocation endLoc = fieldRange.getEnd();
        BigInteger startIndex = startLoc.getIndex();
        int startFieldNumber = startLoc.fieldNum;
        BigInteger endIndex = endLoc.getIndex();
        StringBuffer buffy = new StringBuffer();
        BigInteger i = startIndex;
        while (i.compareTo(endIndex) <= 0) {
            Layout layout = panel.getLayoutModel().getLayout(i);
            String text = null;
            text = i.equals(startIndex) ? (i.equals(endIndex) ? FieldSelectionHelper.getTextForFieldsInLayout(layout, fieldRange, startFieldNumber, endLoc.getFieldNum()) : FieldSelectionHelper.getTextForFieldsInLayout(layout, fieldRange, startFieldNumber, layout.getNumFields())) : (!i.equals(endIndex) ? FieldSelectionHelper.getTextForFieldsInLayout(layout, fieldRange, 0, layout.getNumFields()) : FieldSelectionHelper.getTextForFieldsInLayout(layout, fieldRange, 0, endLoc.getFieldNum()));
            buffy.append(text);
            if (!i.equals(endIndex)) {
                buffy.append(' ');
            }
            i = i.add(BigInteger.ONE);
        }
        return buffy.toString();
    }

    private static String getTextForFieldsInLayout(Layout layout, FieldRange fieldRange, int startFieldNumber, int endFieldNumber) {
        StringBuffer buffy = new StringBuffer();
        for (int i = startFieldNumber; i < endFieldNumber; ++i) {
            Field field = layout.getField(i);
            buffy.append(field.getTextWithLineSeparators());
            if (i == endFieldNumber - 1) continue;
            buffy.append(' ');
        }
        return buffy.toString();
    }
}

