/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToggleDockingAction;
import docking.menu.DockingMenuItemUI;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDHtmlLabel;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;
import resources.ResourceManager;

public class MultipleActionDockingToolbarButton
extends EmptyBorderButton {
    private Icon primaryIcon;
    private Icon disabledIcon;
    private static int ARROW_WIDTH = 4;
    private static int ARROW_HEIGHT = 2;
    private static int ARROW_PADDING = 4;
    private PopupMouseListener popupListener;
    private Shape popupContext;
    private final MultiActionDockingActionIf multipleAction;
    private boolean iconBorderEnabled = true;
    private boolean entireButtonShowsPopupMenu;

    public MultipleActionDockingToolbarButton(MultiActionDockingActionIf action) {
        this.multipleAction = action;
        this.installMouseListeners();
        this.setIcon(ResourceManager.loadImage((String)"images/core.png"));
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (this.primaryIcon != null) {
            this.initIcons();
        }
    }

    @Override
    public void setIcon(Icon icon) {
        this.primaryIcon = Objects.requireNonNull(icon);
        this.initIcons();
    }

    @Override
    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setPerformActionOnButtonClick(boolean performActionOnButtonClick) {
        this.entireButtonShowsPopupMenu = !performActionOnButtonClick;
        this.iconBorderEnabled = performActionOnButtonClick;
        this.popupContext = this.createPopupContext();
    }

    @Override
    protected void paintBorder(Graphics g) {
        Border buttonBorder = this.getBorder();
        if (buttonBorder == null) {
            return;
        }
        Insets borderInsets = buttonBorder.getBorderInsets(this);
        int leftIconWidth = this.primaryIcon.getIconWidth() + (borderInsets.left + borderInsets.right);
        if (this.iconBorderEnabled) {
            buttonBorder.paintBorder(this, g, 0, 0, leftIconWidth, this.getHeight());
        }
        int rightButtonWidth = ARROW_WIDTH + ARROW_PADDING + (borderInsets.left + borderInsets.right);
        buttonBorder.paintBorder(this, g, leftIconWidth, 0, rightButtonWidth, this.getHeight());
    }

    private void initIcons() {
        Icon newIcon = this.createImageIcon();
        this.disabledIcon = ResourceManager.getDisabledIcon((Icon)newIcon);
        super.setIcon(newIcon);
        this.popupContext = this.createPopupContext();
    }

    private void installMouseListeners() {
        MouseListener[] mouseListeners;
        for (MouseListener mouseListener : mouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        this.popupListener = new PopupMouseListener(mouseListeners);
        this.addMouseListener(this.popupListener);
    }

    private Icon createImageIcon() {
        Insets insets = this.getInsets();
        return new IconWithDropDownArrow(this.primaryIcon, this.primaryIcon.getIconWidth() + ARROW_WIDTH + ARROW_PADDING + (insets.right + insets.left), this.primaryIcon.getIconHeight(), insets);
    }

    private Shape createPopupContext() {
        if (this.entireButtonShowsPopupMenu) {
            return new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        Border buttonBorder = this.getBorder();
        Insets borderInsets = buttonBorder == null ? new Insets(0, 0, 0, 0) : buttonBorder.getBorderInsets(this);
        int leftIconWidth = this.primaryIcon.getIconWidth() + (borderInsets.left + borderInsets.right);
        int rightButtonWidth = ARROW_WIDTH + ARROW_PADDING + (borderInsets.left + borderInsets.right);
        int height = this.getIcon().getIconHeight() + borderInsets.top + borderInsets.bottom;
        return new Rectangle(leftIconWidth, 0, rightButtonWidth, height);
    }

    private ActionContext getActionContext() {
        ComponentProvider provider = this.getComponentProvider();
        ActionContext context = provider == null ? null : provider.getActionContext(null);
        ActionContext actionContext = context == null ? new ActionContext() : context;
        return actionContext;
    }

    private ComponentProvider getComponentProvider() {
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        if (manager == null) {
            return null;
        }
        return manager.getActiveComponentProvider();
    }

    JPopupMenu showPopup(PopupMenuListener listener) {
        JPopupMenu menu = new JPopupMenu();
        List<DockingActionIf> actionList = this.multipleAction.getActionList(this.getActionContext());
        for (DockingActionIf dockingAction : actionList) {
            String[] menuPath = dockingAction.getMenuBarData().getMenuPath();
            String name = menuPath[menuPath.length - 1];
            if (!dockingAction.isEnabled()) {
                String description = dockingAction.getDescription();
                ProgramNameSeparator separator = new ProgramNameSeparator(name, description);
                menu.add(separator);
                continue;
            }
            JMenuItem item = dockingAction.createMenuItem(false);
            item.setUI((DockingMenuItemUI)DockingMenuItemUI.createUI(item));
            DockingActionIf delegateAction = dockingAction;
            item.addActionListener(e -> {
                ActionContext context = this.getActionContext();
                context.setSourceObject(e.getSource());
                if (delegateAction instanceof ToggleDockingAction) {
                    ToggleDockingAction toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingAction)delegateAction).isSelected());
                }
                delegateAction.actionPerformed(context);
            });
            ButtonModel itemButtonModel = item.getModel();
            itemButtonModel.addChangeListener(new HoverChangeListener(delegateAction));
            menu.add(item);
        }
        if (listener != null) {
            menu.addPopupMenuListener(listener);
        }
        Point p = this.getPopupPoint();
        menu.show(this, p.x, p.y);
        return menu;
    }

    public Point getPopupPoint() {
        Rectangle bounds = this.getBounds();
        return new Point(0, bounds.y + bounds.height);
    }

    private static class ProgramNameSeparator
    extends JSeparator {
        private final int EMTPY_SEPARATOR_HEIGHT = 10;
        private final int TEXT_SEPARATOR_HEIGHT = 32;
        private JLabel renderer = new GDHtmlLabel();
        private int separatorHeight = 10;

        private ProgramNameSeparator(String name, String description) {
            this.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
            this.renderer.setText(name);
            DockingUtils.setTransparent(this.renderer);
            this.renderer.setHorizontalAlignment(0);
            this.renderer.setVisible(true);
            if (!StringUtils.isBlank((CharSequence)name)) {
                this.separatorHeight = 32;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            int pad = 10;
            int center = this.separatorHeight >> 1;
            int x = 0 + pad;
            int y = center;
            int w = d.width - pad;
            g.setColor(this.getForeground());
            g.drawLine(x, y, w, y);
            g.setColor(this.getBackground());
            g.drawLine(x, y + 1, w, y + 1);
            this.renderer.setSize(this.getSize());
            this.renderer.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, this.separatorHeight);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, this.separatorHeight);
        }
    }

    private class HoverChangeListener
    implements ChangeListener {
        private final DockingActionIf delegateAction;

        public HoverChangeListener(DockingActionIf delegateAction) {
            this.delegateAction = delegateAction;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (!(source instanceof ButtonModel)) {
                return;
            }
            ButtonModel buttonModel = (ButtonModel)source;
            if (buttonModel.isArmed()) {
                DockingWindowManager.setMouseOverAction(this.delegateAction);
            } else {
                DockingWindowManager.setMouseOverAction(null);
            }
        }
    }

    private class PopupMouseListener
    extends MouseAdapter
    implements PopupMenuListener {
        private final MouseListener[] parentListeners;
        private JPopupMenu popupMenu;
        private long actionID = 0L;

        public PopupMouseListener(MouseListener[] parentListeners) {
            this.parentListeners = parentListeners;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.popupIsShowing() && e.getClickCount() == 1) {
                this.popupMenu.setVisible(false);
                return;
            }
            long eventTime = System.currentTimeMillis();
            if (this.actionID == eventTime) {
                return;
            }
            Point clickPoint = e.getPoint();
            if (MultipleActionDockingToolbarButton.this.isEnabled() && MultipleActionDockingToolbarButton.this.popupContext.contains(clickPoint)) {
                SystemUtilities.runSwingLater(() -> {
                    this.popupMenu = MultipleActionDockingToolbarButton.this.showPopup(this);
                });
                e.consume();
                MultipleActionDockingToolbarButton.this.model.setPressed(false);
                MultipleActionDockingToolbarButton.this.model.setArmed(false);
                MultipleActionDockingToolbarButton.this.model.setRollover(false);
                MultipleActionDockingToolbarButton.this.clearBorder();
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mousePressed(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.popupIsShowing()) {
                e.consume();
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseClicked(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.popupIsShowing()) {
                e.consume();
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.popupIsShowing()) {
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.popupIsShowing()) {
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseExited(e);
            }
        }

        private boolean popupIsShowing() {
            return this.popupMenu != null && this.popupMenu.isVisible();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.actionID = System.currentTimeMillis();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private class IconWithDropDownArrow
    implements Icon {
        private int width;
        private int height;
        private Insets insets;
        private Icon baseIcon;

        IconWithDropDownArrow(Icon baseIcon, int width, int height, Insets insets) {
            this.baseIcon = baseIcon;
            this.width = width;
            this.height = height;
            this.insets = insets;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int arrowStartY;
            this.baseIcon.paintIcon(c, g, x, y);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            g.setColor(Color.BLACK);
            int iconWidth = this.baseIcon.getIconWidth();
            int iconHeight = this.baseIcon.getIconHeight();
            int insetsPadding = this.insets.left + this.insets.right;
            int leftSidePadding = ARROW_PADDING / 2;
            int oddSizeOffset = 0;
            if (ARROW_WIDTH % 2 == 0) {
                oddSizeOffset = 1;
            }
            int paintArrowXOffset = x + iconWidth + insetsPadding + (leftSidePadding -= oddSizeOffset);
            int paintArrowYOffset = y + iconHeight / 2 - ARROW_HEIGHT;
            int arrowStartX = paintArrowXOffset;
            int arrowEndX = paintArrowXOffset + ARROW_WIDTH;
            int arrowMiddleX = paintArrowXOffset + ARROW_WIDTH / 2;
            int arrowEndY = arrowStartY = paintArrowYOffset;
            int arrowMiddleY = arrowStartY + ARROW_HEIGHT;
            int[] xPoints = new int[]{arrowStartX, arrowEndX, arrowMiddleX};
            int[] yPoints = new int[]{arrowStartY, arrowEndY, arrowMiddleY};
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.drawPolygon(xPoints, yPoints, 3);
            graphics2D.fillPolygon(xPoints, yPoints, 3);
        }
    }
}

