/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectDataTreeContextAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.ProjectDataTreeActionContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class ProjectDataSelectAction
extends ProjectDataTreeContextAction {
    public ProjectDataSelectAction(String owner, String group) {
        super("Select All", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Select Children"}, group));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataTreeActionContext context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        GTreeNode node = (GTreeNode)paths[0].getLastPathComponent();
        this.selectAllChildren(tree, node);
    }

    @Override
    public boolean isAddToPopup(ProjectDataTreeActionContext context) {
        return context.getFolderCount() == 1 && context.getFileCount() == 0;
    }

    private void selectAllChildren(DataTree tree, GTreeNode node) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        this.getAllTreePaths(node, paths);
        tree.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
    }

    private void getAllTreePaths(GTreeNode node, List<TreePath> paths) {
        paths.add(node.getTreePath());
        List children = node.getChildren();
        for (GTreeNode child : children) {
            this.getAllTreePaths(child, paths);
        }
    }
}

