/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import docking.DockingUtils;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphScalingControl;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.options.VisualGraphOptions;
import java.awt.event.MouseEvent;

public class VisualGraphScalingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends ScalingGraphMousePlugin
implements VisualGraphMousePlugin<V, E> {
    public VisualGraphScalingGraphMousePlugin() {
        super((ScalingControl)new VisualGraphScalingControl(), 0, 0.9090909f, 1.1f);
        this.setZoomAtMouse(true);
    }

    public boolean checkModifiers(MouseEvent e) {
        return this.isZoomModifiers(e);
    }

    private boolean isZoomModifiers(MouseEvent e) {
        GraphViewer viewer = this.getGraphViewer(e);
        if (viewer == null) {
            return false;
        }
        VisualGraphOptions options = viewer.getOptions();
        boolean scrollWheelPans = options.getScrollWheelPans();
        int scrollWheelModifierToggle = DockingUtils.CONTROL_KEY_MODIFIER_MASK_DEPRECATED;
        int eventModifiers = e.getModifiers();
        if (scrollWheelPans) {
            return (scrollWheelModifierToggle & eventModifiers) == scrollWheelModifierToggle;
        }
        return (scrollWheelModifierToggle & eventModifiers) != scrollWheelModifierToggle;
    }
}

