/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.app.plugin.core.analysis.AnalysisState;
import ghidra.app.plugin.core.analysis.AnalysisStateInfo;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.JavaClassUtil;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.HashMap;

public class ClassFileAnalysisState
implements AnalysisState {
    private Program program;
    private ClassFileJava classFile;
    private UniqueAddressFactory uniqueFactory;
    private HashMap<Address, MethodInfoJava> methodMap;

    public ClassFileAnalysisState(Program program) throws IOException {
        this.program = program;
        AddressFactory factory = program.getAddressFactory();
        AddressSpace space = factory.getAddressSpace("constantPool");
        if (space == null) {
            throw new IllegalStateException("Not a valid class file");
        }
        Memory memory = program.getMemory();
        MemoryByteProvider provider = new MemoryByteProvider(memory, space);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, false);
        this.classFile = new ClassFileJava(reader);
        this.uniqueFactory = new UniqueAddressFactory(program.getAddressFactory(), program.getLanguage());
    }

    public ClassFileJava getClassFile() {
        return this.classFile;
    }

    public MethodInfoJava getMethodInfo(Address addr) {
        if (this.methodMap == null) {
            try {
                this.buildMethodMap();
            }
            catch (MemoryAccessException e) {
                Msg.error((Object)this, (Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.methodMap.get(addr);
    }

    public Address getNextUniqueAddress() {
        return this.uniqueFactory.getNextUniqueAddress();
    }

    private void buildMethodMap() throws MemoryAccessException {
        this.methodMap = new HashMap();
        MethodInfoJava[] methods = this.classFile.getMethods();
        Memory memory = this.program.getMemory();
        AddressSpace defaultAddressSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        int max = methods.length;
        for (int i = 0; i < max; ++i) {
            Address methodIndexAddress = JavaClassUtil.toLookupAddress(this.program, i);
            int offset = memory.getInt(methodIndexAddress);
            Address methodStart = defaultAddressSpace.getAddress((long)offset);
            this.methodMap.put(methodStart, methods[i]);
        }
    }

    public static ClassFileAnalysisState getState(Program program) throws IOException {
        ClassFileAnalysisState analysisState = (ClassFileAnalysisState)AnalysisStateInfo.getAnalysisState((Program)program, ClassFileAnalysisState.class);
        if (analysisState == null) {
            analysisState = new ClassFileAnalysisState(program);
            AnalysisStateInfo.putAnalysisState((Program)program, (AnalysisState)analysisState);
        }
        return analysisState;
    }
}

