/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.Component;

public class OpenVersionTrackingSessionAction
extends DockingAction {
    private final VTController controller;

    public OpenVersionTrackingSessionAction(VTController controller) {
        super("Open Session", VTPlugin.OWNER);
        this.controller = controller;
        String[] menuPath = new String[]{"&File", "Open Session..."};
        this.setMenuBarData(new MenuData(menuPath, "AAA"));
        this.setDescription("Opens a Version Tracking Session");
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Open_Session"));
    }

    public void actionPerformed(ActionContext context) {
        PluginTool tool = this.controller.getTool();
        DataTreeDialog dialog = new DataTreeDialog((Component)tool.getToolFrame(), "Open Version Tracking Session", 0, (DomainFileFilter)new VTDomainFileFilter());
        tool.showDialog((DialogComponentProvider)dialog);
        if (!dialog.wasCancelled()) {
            DomainFile domainFile = dialog.getDomainFile();
            this.controller.openVersionTrackingSession(domainFile);
        }
    }

    class VTDomainFileFilter
    implements DomainFileFilter {
        VTDomainFileFilter() {
        }

        public boolean accept(DomainFile f) {
            Class c = f.getDomainObjectClass();
            return VTSession.class.isAssignableFrom(c);
        }
    }
}

