/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public interface GIconProvider {
    public Icon getIcon(GFile var1, TaskMonitor var2) throws IOException, CancelledException;

    public static Icon getIconForFile(GFile file, TaskMonitor monitor) throws CancelledException {
        try {
            GFileSystem fs = file.getFilesystem();
            if (fs instanceof GIconProvider) {
                return ((GIconProvider)((Object)fs)).getIcon(file, monitor);
            }
            File data = FileSystemService.getInstance().getFile(file.getFSRL(), monitor);
            try {
                BufferedImage image = ImageIO.read(data);
                if (image == null) {
                    return null;
                }
                return new ImageIcon(image);
            }
            catch (Exception e) {
                Msg.error(GIconProvider.class, (Object)("Exception while reading image " + file.getName()), (Throwable)e);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

