/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionCallFixupFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;

public class FunctionCallFixupFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Function Call-Fixup";
    private Color fixupColor;
    private Color literalColor;

    public FunctionCallFixupFieldFactory() {
        super(FIELD_NAME);
    }

    public FunctionCallFixupFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.literalColor = displayOptions.getColor(OptionsGui.SEPARATOR.getColorOptionName(), OptionsGui.SEPARATOR.getDefaultColor());
        this.fixupColor = displayOptions.getColor(OptionsGui.FUN_CALL_FIXUP.getColorOptionName(), OptionsGui.FUN_CALL_FIXUP.getDefaultColor());
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        this.literalColor = options.getColor(OptionsGui.FUN_CALL_FIXUP.getColorOptionName(), OptionsGui.FUN_CALL_FIXUP.getDefaultColor());
        this.fixupColor = options.getColor(OptionsGui.FUN_CALL_FIXUP.getColorOptionName(), OptionsGui.FUN_CALL_FIXUP.getDefaultColor());
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Function)) {
            return null;
        }
        Function f = (Function)obj;
        String callFixupStr = f.getCallFixup();
        if (callFixupStr == null) {
            return null;
        }
        ArrayList<TextFieldElement> textElements = new ArrayList<TextFieldElement>();
        int elementIndex = 0;
        AttributedString as = new AttributedString("Call-Fixup: ", this.literalColor, this.getMetrics());
        textElements.add(new TextFieldElement(as, elementIndex++, 0));
        as = new AttributedString(callFixupStr, this.fixupColor, this.getMetrics());
        textElements.add(new TextFieldElement(as, elementIndex++, 0));
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)new CompositeFieldElement(textElements), this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj proxy = bf.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Function function = functionProxy.getObject();
            return new FunctionCallFixupFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), function.getCallFixup(), col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof FunctionCallFixupFieldLocation) {
            FunctionCallFixupFieldLocation callFixupLoc = (FunctionCallFixupFieldLocation)loc;
            return new FieldLocation(index, fieldNum, 0, callFixupLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new FunctionCallFixupFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.FUN_CALL_FIXUP.getDefaultColor();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
    }
}

