/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.IntelHexRecord;

public class IntelHexRecordReader {
    private static final int RECORD_MARK_START = 0;
    private static final int RECORD_MARK_END = 1;
    private static final int RECORD_LENGTH_START = 1;
    private static final int RECORD_LENGTH_END = 3;
    private static final int LOAD_OFFSET_START = 3;
    private static final int LOAD_OFFSET_END = 7;
    private static final int RECORD_TYPE_START = 7;
    private static final int RECORD_TYPE_END = 9;
    private static final int DATA_START = 9;
    private static final int CHECKSUM_LENGTH = 2;

    public static IntelHexRecord readRecord(String line) {
        int checksum;
        int data_end;
        int recordType;
        int loadOffset;
        int recordLength;
        if ((line = line.replaceAll("\\s+", "")).length() < 11) {
            throw new IllegalArgumentException("line too short to contain record");
        }
        String recordMark = line.substring(0, 1);
        if (!":".equals(recordMark)) {
            throw new IllegalArgumentException("line does not start with record mark (:)");
        }
        String recordLengthString = line.substring(1, 3);
        try {
            recordLength = Integer.parseInt(recordLengthString, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("error parsing record length: " + e.getMessage());
        }
        String loadOffsetString = line.substring(3, 7);
        try {
            loadOffset = Integer.parseInt(loadOffsetString, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("error parsing load offset: " + e.getMessage());
        }
        String recordTypeString = line.substring(7, 9);
        try {
            recordType = Integer.parseInt(recordTypeString, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("error parsing record type: " + e.getMessage());
        }
        int checksum_start = data_end = 9 + recordLength * 2;
        int checksum_end = checksum_start + 2;
        if (line.length() != checksum_end) {
            throw new IllegalArgumentException("line invalid length to contain record with record length " + recordLength);
        }
        String dataString = line.substring(9, data_end);
        byte[] data = IntelHexRecordReader.convertData(dataString);
        String checksumString = line.substring(checksum_start, checksum_end);
        try {
            checksum = Integer.parseInt(checksumString, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("error parsing checksum: " + e.getMessage());
        }
        return new IntelHexRecord(recordLength, loadOffset, recordType, data, checksum);
    }

    private static byte[] convertData(String dataString) {
        if (dataString.length() % 2 == 1) {
            throw new IllegalArgumentException("internal error - data string of odd length");
        }
        byte[] result = new byte[dataString.length() / 2];
        int ii = 0;
        int jj = 0;
        while (ii < dataString.length()) {
            int b;
            String bString = dataString.substring(ii, ii + 2);
            try {
                b = Integer.parseInt(bString, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("error parsing data byte: " + e.getMessage());
            }
            result[jj] = (byte)b;
            ii += 2;
            ++jj;
        }
        return result;
    }
}

