/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;

public class DemangledThunk
extends DemangledObject {
    private DemangledFunction thunkedFunctionObject;
    private String signaturePrefix;
    private boolean covariantReturnThunk = false;

    public DemangledThunk(DemangledFunction thunkedFunctionObject) {
        this.thunkedFunctionObject = thunkedFunctionObject;
        this.namespace = thunkedFunctionObject.getNamespace();
        this.setName(thunkedFunctionObject.getName());
    }

    public void setCovariantReturnThunk() {
        this.covariantReturnThunk = true;
    }

    public void setSignaturePrefix(String prefix) {
        this.signaturePrefix = prefix;
    }

    @Override
    public String getSignature(boolean format) {
        String refSignature = this.thunkedFunctionObject.getSignature(format);
        return (this.signaturePrefix != null ? this.signaturePrefix : "thunk ") + refSignature;
    }

    @Override
    protected boolean isAlreadyDemangled(Program program, Address address) {
        Function f = program.getListing().getFunctionAt(address);
        if (f == null) {
            return false;
        }
        if (f.getSymbol().getSource() == SourceType.USER_DEFINED) {
            return true;
        }
        if (!f.isThunk()) {
            return false;
        }
        return super.isAlreadyDemangled(program, address);
    }

    @Override
    public boolean applyTo(Program program, Address thunkAddress, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        Symbol s;
        if (this.isAlreadyDemangled(program, thunkAddress)) {
            return true;
        }
        if (!super.applyTo(program, thunkAddress, options, monitor)) {
            return false;
        }
        Function thunkedFunction = this.findThunkedFunction(program, thunkAddress, options, monitor);
        if (this.covariantReturnThunk) {
            return this.thunkedFunctionObject.applyTo(program, thunkAddress, options, monitor);
        }
        Function function = this.createPreThunkFunction(program, thunkAddress, options.doDisassembly(), monitor);
        if (function == null) {
            return false;
        }
        while (function.getSymbol().getSource() == SourceType.DEFAULT && function.isThunk()) {
            function = function.getThunkedFunction(false);
        }
        if (thunkedFunction != null && this.originalMangled.equals(function.getName()) && !function.isThunk()) {
            function.setThunkedFunction(thunkedFunction);
        }
        return (s = this.applyDemangledName(thunkAddress, function.isThunk(), false, program)) != null;
    }

    private Function createPreThunkFunction(Program prog, Address addr, boolean doDisassembly, TaskMonitor monitor) {
        AddressSetView execSet;
        Listing listing = prog.getListing();
        Function func = listing.getFunctionAt(addr);
        if (func != null) {
            return func;
        }
        if (doDisassembly && (execSet = prog.getMemory().getExecuteSet()).contains(addr)) {
            DisassembleCommand cmd = new DisassembleCommand(addr, null, true);
            cmd.applyTo((DomainObject)prog, monitor);
        }
        AddressSet body = new AddressSet();
        Instruction instr = listing.getInstructionAt(addr);
        while (instr != null) {
            InstructionContext instructionContext = instr.getInstructionContext();
            Address fallThru = instructionContext.getAddress().add((long)instr.getPrototype().getFallThroughOffset(instructionContext));
            Address maxAddr = fallThru.previous();
            if (maxAddr.compareTo((Object)instr.getMinAddress()) < 0) {
                maxAddr = instr.getMaxAddress();
            }
            body.add(instr.getMinAddress(), maxAddr);
            if (!instr.getFlowType().hasFallthrough()) break;
            instr = listing.getInstructionAt(fallThru);
        }
        if (body.isEmpty()) {
            body.add(addr);
        }
        CreateFunctionCmd cmd = new CreateFunctionCmd(null, addr, (AddressSetView)body, SourceType.DEFAULT);
        cmd.applyTo((DomainObject)prog, monitor);
        return listing.getFunctionAt(addr);
    }

    private Function findThunkedFunction(Program program, Address thunkAddress, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        Address thunkedAddr;
        MemoryBlock block = program.getMemory().getBlock(thunkAddress);
        if (block == null) {
            return null;
        }
        Symbol s = SymbolUtilities.getExpectedLabelOrFunctionSymbol((Program)program, (String)this.thunkedFunctionObject.originalMangled, err -> Msg.warn((Object)this, (Object)err));
        if (s == null && (thunkedAddr = CreateThunkFunctionCmd.getThunkedAddr(program, thunkAddress, false)) != null) {
            s = program.getSymbolTable().getPrimarySymbol(thunkedAddr);
        }
        if (s == null || !block.contains(s.getAddress())) {
            return null;
        }
        Address addr = s.getAddress();
        DemanglerOptions subOptions = new DemanglerOptions(options);
        subOptions.setApplySignature(true);
        this.thunkedFunctionObject.applyTo(program, addr, subOptions, monitor);
        return program.getFunctionManager().getFunctionAt(addr);
    }
}

