/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.util.Msg;

public class PrimitiveTypeListing {
    public static final short T_NOTYPE = 0;
    public static final short T_ABS = 1;
    public static final short T_SEGMENT = 2;
    public static final short T_VOID = 3;
    public static final short T_PVOID = 259;
    public static final short T_PFOID = 515;
    public static final short T_PHVOID = 771;
    public static final short T_32PVOID = 1027;
    public static final short T_32PFVOID = 1283;
    public static final short T_CURRENCY = 4;
    public static final short T_NBASICSTR = 5;
    public static final short T_FBASICSTR = 6;
    public static final short T_NOTTRANS = 7;
    public static final short T_BIT = 96;
    public static final short T_PASCHAR = 97;
    public static final short T_CHAR = 16;
    public static final short T_UCHAR = 32;
    public static final short T_PCHAR = 272;
    public static final short T_PUCHAR = 288;
    public static final short T_PFCHAR = 528;
    public static final short T_PFUCHAR = 544;
    public static final short T_PHCHAR = 784;
    public static final short T_PHUCHAR = 800;
    public static final short T_32PCHAR = 1040;
    public static final short T_32PUCHAR = 1056;
    public static final short T_32PFCHAR = 1296;
    public static final short T_32PFUCHAR = 1312;
    public static final short T_RCHAR = 112;
    public static final short T_PRCHAR = 368;
    public static final short T_PFRCHAR = 624;
    public static final short T_PHRCHAR = 880;
    public static final short T_32PRCHAR = 1136;
    public static final short T_32PFRCHAR = 1392;
    public static final short T_WCHAR = 113;
    public static final short T_PWCHAR = 369;
    public static final short T_PFWCHAR = 625;
    public static final short T_PHWCHAR = 881;
    public static final short T_32PWCHAR = 1137;
    public static final short T_32PFWCHAR = 1393;
    public static final short T_INT2 = 114;
    public static final short T_UINT2 = 115;
    public static final short T_PINT2 = 370;
    public static final short T_PUINT2 = 371;
    public static final short T_PFINT2 = 626;
    public static final short T_PFUINT2 = 627;
    public static final short T_PHINT2 = 882;
    public static final short T_PHUINT2 = 883;
    public static final short T_32PINT2 = 1138;
    public static final short T_32PUINT2 = 1139;
    public static final short T_32PFINT2 = 1394;
    public static final short T_32PFUINT2 = 1395;
    public static final short T_SHORT = 17;
    public static final short T_USHORT = 33;
    public static final short T_PSHORT = 273;
    public static final short T_PUSHORT = 289;
    public static final short T_PFSHORT = 529;
    public static final short T_PFUSHORT = 545;
    public static final short T_PHSHORT = 785;
    public static final short T_PHUSHORT = 801;
    public static final short T_32PSHORT = 1041;
    public static final short T_32PUSHORT = 1057;
    public static final short T_32PFSHORT = 1297;
    public static final short T_32PFUSHORT = 1313;
    public static final short T_INT4 = 116;
    public static final short T_UINT4 = 117;
    public static final short T_PINT4 = 372;
    public static final short T_PUINT4 = 373;
    public static final short T_PFINT4 = 628;
    public static final short T_PFUINT4 = 629;
    public static final short T_PHINT4 = 884;
    public static final short T_PHUINT4 = 885;
    public static final short T_32PINT4 = 1140;
    public static final short T_32PUINT4 = 1141;
    public static final short T_32PFINT4 = 1396;
    public static final short T_32PFUINT4 = 1397;
    public static final short T_LONG = 18;
    public static final short T_ULONG = 34;
    public static final short T_PLONG = 274;
    public static final short T_PULONG = 290;
    public static final short T_PFLONG = 530;
    public static final short T_PFULONG = 546;
    public static final short T_PHLONG = 786;
    public static final short T_PHULONG = 802;
    public static final short T_32PLONG = 1042;
    public static final short T_32PULONG = 1058;
    public static final short T_P2PFLONG = 1298;
    public static final short T_32PFULONG = 1314;
    public static final short T_INT8 = 118;
    public static final short T_UINT8 = 119;
    public static final short T_PINT8 = 374;
    public static final short T_PUINT8 = 375;
    public static final short T_PFINT8 = 630;
    public static final short T_PFUINT8 = 631;
    public static final short T_PHINT8 = 886;
    public static final short T_PHUINT8 = 887;
    public static final short T_32PINT8 = 1142;
    public static final short T_32PUINT8 = 1143;
    public static final short T_32PFINT8 = 1398;
    public static final short T_32PFUINT8 = 1399;
    public static final short T_QUAD = 19;
    public static final short T_UQUAD = 35;
    public static final short T_PQUAD = 275;
    public static final short T_PUQUAD = 291;
    public static final short T_PFQUAD = 531;
    public static final short T_PFUQUAD = 547;
    public static final short T_PHQUAD = 787;
    public static final short T_PHUQUAD = 803;
    public static final short T_32PQUAD = 1043;
    public static final short T_32PUQUAD = 1059;
    public static final short T_32PFQUAD = 1299;
    public static final short T_32PFUQUAD = 1315;
    public static final short T_REAL32 = 64;
    public static final short T_PREAL32 = 320;
    public static final short T_PFREAL32 = 576;
    public static final short T_PHREAL32 = 832;
    public static final short T_32PREAL32 = 1088;
    public static final short T_32PFREAL32 = 1344;
    public static final short T_REAL64 = 65;
    public static final short T_PREAL64 = 321;
    public static final short T_PFREAL64 = 577;
    public static final short T_PHREAL64 = 833;
    public static final short T_32PREAL64 = 1089;
    public static final short T_32PFREAL64 = 1345;
    public static final short T_CPLX32 = 80;
    public static final short T_PCPLX32 = 336;
    public static final short T_PFCPLX32 = 592;
    public static final short T_PHCPLX32 = 848;
    public static final short T_32PCPLX32 = 1104;
    public static final short T_32PFCPLX32 = 1360;
    public static final short T_CPLX64 = 81;
    public static final short T_PCPLX64 = 337;
    public static final short T_PFCPLX64 = 593;
    public static final short T_PHCPLX64 = 849;
    public static final short T_32PCPLX64 = 1105;
    public static final short T_32PFCPLX64 = 1361;
    public static final short T_BOOL08 = 48;
    public static final short T_BOOL16 = 49;
    public static final short T_BOOL32 = 50;
    public static final short T_BOOL64 = 51;
    public static final short T_PBOOL08 = 304;
    public static final short T_PBOOL16 = 305;
    public static final short T_PBOOL32 = 306;
    public static final short T_PBOOL64 = 307;
    public static final short T_PFBOOL08 = 560;
    public static final short T_PFBOOL16 = 561;
    public static final short T_PFBOOL32 = 562;
    public static final short T_PFBOOL64 = 563;
    public static final short T_PHBOOL08 = 816;
    public static final short T_PHBOOL16 = 817;
    public static final short T_PHBOOL32 = 818;
    public static final short T_PHBOOL64 = 819;
    public static final short T_32PBOOL08 = 1072;
    public static final short T_32PBOOL16 = 1073;
    public static final short T_32PBOOL32 = 1074;
    public static final short T_32PBOOL64 = 1075;
    public static final short T_32PFBOOL08 = 1328;
    public static final short T_32PFBOOL16 = 1329;
    public static final short T_32PFBOOL32 = 1330;
    public static final short T_32PFBOOL64 = 1331;
    public static final short T_HINSTANCE = 4349;

    public static DataType getDataType(short type) {
        switch (type) {
            case 17: 
            case 33: {
                return new WordDataType();
            }
            case 273: 
            case 289: 
            case 529: 
            case 545: 
            case 785: 
            case 801: 
            case 1041: 
            case 1057: 
            case 1297: 
            case 1313: {
                return new Pointer32DataType((DataType)new WordDataType());
            }
            case 118: 
            case 119: {
                return new QWordDataType();
            }
            case 374: 
            case 375: 
            case 630: 
            case 631: 
            case 886: 
            case 887: 
            case 1142: 
            case 1143: 
            case 1398: 
            case 1399: {
                return new Pointer32DataType((DataType)new QWordDataType());
            }
            case 116: 
            case 117: {
                return new DWordDataType();
            }
            case 372: 
            case 373: 
            case 628: 
            case 629: 
            case 884: 
            case 885: 
            case 1140: 
            case 1141: 
            case 1396: 
            case 1397: {
                return new Pointer32DataType((DataType)new DWordDataType());
            }
            case 18: 
            case 34: {
                return new DWordDataType();
            }
            case 274: 
            case 290: 
            case 530: 
            case 546: 
            case 786: 
            case 802: 
            case 1042: 
            case 1058: 
            case 1298: 
            case 1314: {
                return new Pointer32DataType((DataType)new DWordDataType());
            }
            case 19: 
            case 35: {
                return new QWordDataType();
            }
            case 275: 
            case 291: 
            case 531: 
            case 547: 
            case 787: 
            case 803: 
            case 1043: 
            case 1059: 
            case 1299: 
            case 1315: {
                return new Pointer32DataType((DataType)new QWordDataType());
            }
            case 64: 
            case 320: {
                return new FloatDataType();
            }
            case 576: 
            case 832: 
            case 1088: 
            case 1344: {
                return new Pointer32DataType((DataType)new FloatDataType());
            }
            case 65: 
            case 321: {
                return new DoubleDataType();
            }
            case 577: 
            case 833: 
            case 1089: 
            case 1345: {
                return new Pointer32DataType((DataType)new DoubleDataType());
            }
            case 1027: {
                return new TypedefDataType("VOID", (DataType)new Pointer32DataType());
            }
            case 48: {
                return new TypedefDataType("bool08", (DataType)new ByteDataType());
            }
            case 49: {
                return new TypedefDataType("bool16", (DataType)new WordDataType());
            }
            case 50: {
                return new TypedefDataType("bool32", (DataType)new DWordDataType());
            }
            case 51: {
                return new TypedefDataType("bool32", (DataType)new QWordDataType());
            }
            case 4349: {
                return new TypedefDataType("HINSTANCE", (DataType)new Pointer32DataType());
            }
            case 16: 
            case 32: {
                return new CharDataType();
            }
            case 272: 
            case 288: 
            case 528: 
            case 544: 
            case 784: 
            case 800: 
            case 1040: 
            case 1056: 
            case 1296: 
            case 1312: {
                return new Pointer32DataType((DataType)new CharDataType());
            }
            case 112: {
                return new CharDataType();
            }
            case 368: 
            case 624: 
            case 880: 
            case 1136: 
            case 1392: {
                return new Pointer32DataType((DataType)new CharDataType());
            }
            case 113: {
                return new UnicodeDataType();
            }
            case 369: 
            case 625: 
            case 881: 
            case 1137: 
            case 1393: {
                return new Pointer32DataType((DataType)new UnicodeDataType());
            }
        }
        Msg.warn(PrimitiveTypeListing.class, (Object)("PrimitiveTypeListing: unrecognized  data type [] - 0x" + Integer.toHexString(type)));
        return DataType.DEFAULT;
    }
}

