/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.dataArchiveUtilities;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.prototype.dataArchiveUtilities.ComplexName;
import ghidra.app.util.xml.DataTypesXmlMgr;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

@PluginInfo(status=PluginStatus.STABLE, packageName="Miscellaneous", category="Code Viewer", shortDescription="Convert data archives", description="This plugin allows the user to convert GSL-generated archives back and forth to Ghidra data archives.")
public class ArchiveConverterPlugin
extends ProgramPlugin {
    private static final String IMPORT_EXPORT_GROUP = "Import/Export";
    static final String CONVERT_DATA = "Convert GSL- to data-archive";
    static final String GSL_ARCHIVE_DIR = "GSL Archive Directory";
    static final String GDT_ARCHIVE_DIR = "GDT Archive Directory";
    static final String ALIGNMENT_TAG = "added for alignment";
    static final String WRITE_GSL = "Write data-archive in GSL Format";
    private GhidraFileChooser fileChooser;
    private TypedefDataType dataUI;
    private Hashtable<String, DataType> dataTypes = new Hashtable();
    static final String NO_NAMESPACE = "/";
    final int SIZE_X = 8;
    final int ALIGNMENT = 32;

    public ArchiveConverterPlugin(PluginTool plugintool) {
        super(plugintool, false, false);
        this.createActions();
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    public void dispose() {
        super.dispose();
    }

    private void createActions() {
        DockingAction parseAction = new DockingAction(CONVERT_DATA, this.getName()){

            public void actionPerformed(ActionContext context) {
                File gslArchive = ArchiveConverterPlugin.this.chooseFile(ArchiveConverterPlugin.this.tool.getToolFrame(), "Select GSL archive", ArchiveConverterPlugin.GSL_ARCHIVE_DIR, "gsl");
                new TaskLauncher((Task)new GSLParserTask(ArchiveConverterPlugin.this.tool, gslArchive), (Component)ArchiveConverterPlugin.this.tool.getToolFrame());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getContextObject() instanceof ListingActionContext;
            }
        };
        String[] menuPath = new String[]{"&File", "Parse GSL Archive..."};
        parseAction.setMenuBarData(new MenuData(menuPath, IMPORT_EXPORT_GROUP));
        parseAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)parseAction);
        DockingAction writeGslAction = new DockingAction(WRITE_GSL, this.getName()){

            public void actionPerformed(ActionContext context) {
                File gslInfile = ArchiveConverterPlugin.this.chooseFile(ArchiveConverterPlugin.this.tool.getToolFrame(), "Select input file", ArchiveConverterPlugin.GDT_ARCHIVE_DIR, ".gdt");
                File gslOutfile = ArchiveConverterPlugin.this.chooseFile(ArchiveConverterPlugin.this.tool.getToolFrame(), "Select output file", ArchiveConverterPlugin.GSL_ARCHIVE_DIR, "gsl");
                new TaskLauncher((Task)new GSLWriterTask(ArchiveConverterPlugin.this.tool, gslInfile, gslOutfile), (Component)ArchiveConverterPlugin.this.tool.getToolFrame());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getContextObject() instanceof ListingActionContext;
            }
        };
        String[] menuPath2 = new String[]{"&File", "Write GSL Archive..."};
        writeGslAction.setMenuBarData(new MenuData(menuPath2, IMPORT_EXPORT_GROUP));
        writeGslAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)writeGslAction);
    }

    private DataType parseLine(FileDataTypeManager dtMgr, String line) {
        int index;
        Object dt = null;
        while ((index = ((String)line).indexOf("$$")) >= 0) {
            line = ((String)line).substring(0, index + 1) + "noname" + ((String)line).substring(index + 1);
        }
        while ((index = ((String)line).indexOf("//")) >= 0) {
            line = ((String)line).substring(0, index) + ((String)line).substring(index + 1);
        }
        StringTokenizer tokenizer = new StringTokenizer((String)line, "$");
        String fieldId = tokenizer.nextToken();
        String complexName = tokenizer.nextToken();
        ComplexName cName = new ComplexName(complexName);
        String myName = cName.getName();
        if (fieldId.compareToIgnoreCase("STRUCT") == 0 || fieldId.compareToIgnoreCase("UNION") == 0) {
            tokenizer.nextToken();
            tokenizer.nextToken();
            dt = fieldId.compareToIgnoreCase("STRUCT") == 0 ? new StructureDataType(cName.getCategoryPath(), myName, 0) : new UnionDataType(cName.getCategoryPath(), myName);
            this.addDataType(dtMgr, this.dataTypes, (DataType)dt);
            int lastOffset = dt.getLength();
            while (tokenizer.hasMoreElements()) {
                String fieldName = tokenizer.nextToken();
                String fieldType = tokenizer.nextToken();
                String fieldOffset = tokenizer.nextToken();
                String fieldSize = tokenizer.nextToken();
                String fieldAlign = tokenizer.nextToken();
                int align = this.valueOf(fieldAlign);
                int fSize = this.valueOf(fieldSize);
                int fOff = this.valueOf(fieldOffset);
                ComplexName fType = new ComplexName(fieldType);
                DataType member = fType.getDataType(dtMgr, this.dataTypes);
                try {
                    if (member == null || member.getLength() < 0) {
                        member = this.genUIData(dtMgr, fType, fOff - dt.getLength());
                        fSize = member.getLength();
                    }
                    if (member.getLength() == 0 && !tokenizer.hasMoreElements()) {
                        fType.count = 1;
                        member = fType.getDataType(dtMgr, this.dataTypes);
                        fSize = member.getLength();
                    }
                    if (dt instanceof Structure && (fOff < dt.getLength() || fOff >= dt.getLength() && fSize < member.getLength())) {
                        if (fOff >= dt.getLength()) {
                            lastOffset = dt.getLength();
                            ((StructureDataType)dt).add(member, member.getLength(), "_bit_fields_" + dt.getLength(), "");
                        }
                        DataTypeComponent dtc = ((StructureDataType)dt).getComponentAt(lastOffset);
                        Object comment = dtc.getComment();
                        comment = (String)comment + " " + fieldName + "(" + fieldSize + ")";
                        dtc.setComment((String)comment);
                        if (fSize < member.getLength()) {
                            Msg.debug((Object)((Object)this), (Object)("Dropping bitfield=[" + fieldName + "] type=[" + member.getName() + "] in " + myName));
                            continue;
                        }
                        Msg.debug((Object)((Object)this), (Object)("Dropping  element=[" + fieldName + "] type=[" + member.getName() + "] in " + myName));
                        continue;
                    }
                    if (align > 4) {
                        align = 4;
                    }
                    int mod = align == 0 ? 0 : dt.getLength() % align;
                    ArrayDataType modDt = null;
                    if (mod != 0) {
                        modDt = new ArrayDataType((DataType)new ByteDataType(), align - mod, 1);
                    }
                    if (member.getLength() > 0) {
                        lastOffset = dt.getLength();
                        if (modDt != null) {
                            ((CompositeDataTypeImpl)dt).add((DataType)modDt, modDt.getLength(), "_fill_" + dt.getLength(), ALIGNMENT_TAG);
                        }
                        ((CompositeDataTypeImpl)dt).add(member, member.getLength(), fieldName, "");
                        continue;
                    }
                    Msg.debug((Object)((Object)this), (Object)("Dropping mid-structure zero length element=[" + fieldName + "] type=[" + member.getName() + "] in " + myName));
                }
                catch (Exception e) {
                    Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
        } else if (fieldId.compareToIgnoreCase("FUNCTION") == 0) {
            dt = new FunctionDefinitionDataType(cName.getCategoryPath(), cName.getName());
            String retVal = tokenizer.nextToken();
            ComplexName rvName = new ComplexName(retVal);
            DataType rvDt = rvName.getDataType(dtMgr, this.dataTypes);
            if (rvDt == null) {
                rvDt = this.genUIData(dtMgr, rvName, 4);
            }
            dt.setReturnType(rvDt);
            ArrayList<ParameterDefinitionImpl> parameters = new ArrayList<ParameterDefinitionImpl>();
            index = 0;
            while (tokenizer.hasMoreElements()) {
                String fieldName = tokenizer.nextToken();
                String fieldType = tokenizer.nextToken();
                ComplexName fType = new ComplexName(fieldType);
                DataType parameter = fType.getDataType(dtMgr, this.dataTypes);
                if (parameter == null) {
                    parameter = this.genUIData(dtMgr, fType, 4);
                }
                parameters.add(new ParameterDefinitionImpl(fieldName, parameter, ""));
                ++index;
            }
            if (index > 0) {
                ParameterDefinition[] parms = new ParameterDefinition[parameters.size()];
                parameters.toArray(parms);
                dt.setArguments(parms);
            }
        } else if (fieldId.compareToIgnoreCase("TYPEDEF") == 0) {
            String newName = tokenizer.nextToken();
            try {
                DataType baseType = cName.getDataType(dtMgr, this.dataTypes);
                if (baseType == null) {
                    baseType = this.genUIData(dtMgr, cName, 4);
                }
                ComplexName cNewName = new ComplexName(newName);
                dt = new TypedefDataType(cNewName.getCategoryPath(), newName, baseType);
            }
            catch (Exception e) {
                Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        } else if (fieldId.compareToIgnoreCase("ENUM") == 0) {
            ArrayList<String> fNames = new ArrayList<String>();
            ArrayList<String> fValues = new ArrayList<String>();
            while (tokenizer.hasMoreElements()) {
                fNames.add(tokenizer.nextToken());
                fValues.add(tokenizer.nextToken());
            }
            dt = new EnumDataType(cName.getCategoryPath(), cName.getName(), fNames.size(), null);
            for (int i = 0; i < fNames.size(); ++i) {
                ((EnumDataType)dt).add((String)fNames.get(i), new Long((String)fValues.get(i)).longValue());
            }
        } else if (fieldId.compareToIgnoreCase("SYMBOL") != 0) {
            Msg.warn((Object)((Object)this), (Object)("What is this? " + fieldId));
        }
        return dt;
    }

    private void searchForErrors(FileDataTypeManager dtMgr) {
        try {
            Iterator dts = dtMgr.getAllDataTypes();
            while (dts.hasNext()) {
                DataType base;
                DataType dti = (DataType)dts.next();
                if (dti.getDisplayName().indexOf("%") >= 0) {
                    Msg.warn((Object)((Object)this), (Object)("Misprocessed data type: " + dti.getDisplayName()));
                }
                if (!(dti instanceof TypeDef) || !((base = ((TypeDef)dti).getBaseDataType()) instanceof Pointer) || !(base = ((Pointer)base).getDataType()).isEquivalent((DataType)this.dataUI)) continue;
                Msg.warn((Object)((Object)this), (Object)("Data type (" + dti.getDisplayName() + ") not found."));
            }
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public DataType genUIData(FileDataTypeManager dtMgr, ComplexName cName, int len) {
        TypedefDataType dt = new TypedefDataType(cName.getCategoryPath(), cName.getName(), (DataType)new ArrayDataType((DataType)new ByteDataType(), len, 1));
        this.addDataType(dtMgr, this.dataTypes, (DataType)dt);
        return dt;
    }

    int valueOf(String intString) {
        return new Integer(intString) / 8;
    }

    private void addPrimitives(FileDataTypeManager dtMgr) {
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("char", (DataType)new ByteDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("signed char", (DataType)new ByteDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("unsigned char", (DataType)new ByteDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("short", (DataType)new WordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("short int", (DataType)new WordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("short signed int", (DataType)new WordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("short unsigned int", (DataType)new WordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("int", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long int", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("signed int", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("unsigned int", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long signed int", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long unsigned int", (DataType)new DWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long long int", (DataType)new QWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long long signed int", (DataType)new QWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("long long unsigned int", (DataType)new QWordDataType()));
        this.addDataType(dtMgr, this.dataTypes, (DataType)new TypedefDataType("void", (DataType)new VoidDataType()));
        this.dataUI = new TypedefDataType("U/I", (DataType)new DWordDataType());
        this.addDataType(dtMgr, this.dataTypes, (DataType)this.dataUI);
    }

    private void addDataType(FileDataTypeManager dtMgr, Hashtable<String, DataType> myDataTypes, DataType dt) {
        DataType type = dtMgr.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
        myDataTypes.put(type.getCategoryPath() + type.getName(), type);
    }

    private File chooseFile(Component parent, String title, String propertyName, String fileType) {
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser(parent);
        }
        this.fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(fileType, fileType.toUpperCase() + " files (." + fileType + ")"));
        this.fileChooser.setTitle(title);
        File directory = new File(Preferences.getProperty((String)propertyName, (String)System.getProperty("user.home"), (boolean)true));
        this.fileChooser.setCurrentDirectory(directory);
        this.fileChooser.setSelectedFile(directory);
        File file = this.fileChooser.getSelectedFile();
        if (file != null) {
            Preferences.setProperty((String)propertyName, (String)file.getAbsolutePath());
        }
        return file;
    }

    private void writeAsGsl(File file, DataTypeManager dtMgr, TaskMonitor monitor) {
        String out = "";
        int count = 0;
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Iterator it = dtMgr.getAllDataTypes();
            while (it.hasNext()) {
                DataType dt = (DataType)it.next();
                out = "";
                if (dt instanceof Composite) {
                    out = this.writeComposite(stream, dt);
                } else if (dt instanceof TypeDef) {
                    out = this.writeTypeDef(stream, (TypeDef)dt);
                } else if (dt instanceof FunctionDefinition) {
                    out = this.writeFunctionDefinition(stream, (FunctionDefinition)dt);
                } else if (dt instanceof Enum) {
                    out = this.writeEnum(stream, (Enum)dt);
                } else {
                    Msg.debug((Object)((Object)this), (Object)"Something went wrong while printing GSL output...");
                }
                if (out != "") {
                    stream.write(out.getBytes());
                }
                if (count % 100 == 0) {
                    monitor.setProgress((long)count);
                }
                ++count;
            }
            stream.close();
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private String writeComposite(FileOutputStream stream, DataType dt) {
        Object out = dt instanceof Structure ? "STRUCT$" : "UNION$";
        DataTypeComponent[] components = ((Composite)dt).getComponents();
        out = (String)out + new NameComplex(dt).getGSLName() + "$";
        out = (String)out + 8 * dt.getLength() + "$";
        out = (String)out + "32";
        for (DataTypeComponent component : components) {
            String comment = component.getComment();
            if (comment == null || comment.compareTo(ALIGNMENT_TAG) == 0) continue;
            NameComplex cComp = new NameComplex(component.getDataType());
            out = (String)out + "$";
            out = (String)out + component.getFieldName() + "$";
            out = (String)out + cComp.getGSLName() + "$";
            out = (String)out + 8 * component.getOffset() + "$";
            out = (String)out + 8 * component.getLength() + "$";
            out = component.getDataType() instanceof Composite ? (String)out + "32" : (String)out + 8 * cComp.getBaseTypeSize();
        }
        out = (String)out + "\n";
        return out;
    }

    private String writeTypeDef(FileOutputStream stream, TypeDef def) {
        DataType dt = def.getDataType();
        Object out = "TYPEDEF$";
        out = (String)out + new NameComplex(dt).getGSLName() + "$";
        out = (String)out + new NameComplex((DataType)def).getGSLName() + "\n";
        return out;
    }

    private String writeEnum(FileOutputStream stream, Enum enuum) {
        Object out = "ENUM$";
        String[] names = enuum.getNames();
        long[] values = enuum.getValues();
        out = (String)out + new NameComplex((DataType)enuum).getGSLName();
        for (int i = 0; i < names.length; ++i) {
            out = (String)out + "$";
            out = (String)out + names[i] + "$";
            out = (String)out + values[i];
        }
        out = (String)out + "\n";
        return out;
    }

    private String writeFunctionDefinition(FileOutputStream stream, FunctionDefinition fn) {
        Object out = "FUNCTION$";
        ParameterDefinition[] parameters = fn.getArguments();
        DataType ret = fn.getReturnType();
        out = (String)out + new NameComplex((DataType)fn).getGSLName() + "$";
        out = (String)out + new NameComplex(ret).getGSLName();
        for (ParameterDefinition parameter : parameters) {
            NameComplex cParm = new NameComplex(parameter.getDataType());
            out = (String)out + "$";
            String pName = parameter.getName();
            out = (String)out + (pName.compareToIgnoreCase(" ") == 0 ? "" : pName);
            out = (String)out + "$";
            out = (String)out + cParm.getGSLName();
        }
        out = (String)out + "\n";
        return out;
    }

    public class NameComplex {
        DataType dt;
        String myName;
        String dtNamespace;
        int baseTypeSize;

        public NameComplex(DataType dt) {
            this.dt = dt;
            this.dtNamespace = dt.getCategoryPath().getPath();
            DataType base = dt;
            boolean shouldDescend = false;
            this.myName = "";
            if (dt instanceof Pointer) {
                this.myName = "Pointer%";
                base = ((Pointer)dt).getDataType();
                shouldDescend = true;
            } else if (dt instanceof Array) {
                Array array = (Array)dt;
                this.myName = "Array%" + array.getNumElements() + "%" + 8 * array.getLength() + "%";
                base = array.getDataType();
                shouldDescend = true;
            }
            if (shouldDescend) {
                NameComplex cName = new NameComplex(base);
                this.myName = this.myName + cName.getGSLName();
                this.baseTypeSize = dt instanceof Pointer ? dt.getLength() : cName.getBaseTypeSize();
            } else {
                if (this.dtNamespace.compareToIgnoreCase(ArchiveConverterPlugin.NO_NAMESPACE) != 0) {
                    this.myName = this.myName + this.dtNamespace + ":";
                }
                this.myName = this.myName + dt.getName();
                this.baseTypeSize = dt.getLength();
            }
        }

        public String getGSLName() {
            return this.myName;
        }

        public int getBaseTypeSize() {
            return this.baseTypeSize;
        }
    }

    private class GSLWriterTask
    extends Task {
        File gslInfile;
        File gslOutfile;

        public GSLWriterTask(PluginTool tool, File gslInfile, File gslOutfile) {
            super("GSL Archive Writer", true, false, false);
            this.gslInfile = gslInfile;
            this.gslOutfile = gslOutfile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            if (this.gslInfile != null) {
                FileDataTypeManager dtMgr = null;
                try {
                    dtMgr = FileDataTypeManager.openFileArchive((File)this.gslInfile, (boolean)false);
                }
                catch (Exception e) {
                    Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                if (dtMgr != null) {
                    try {
                        monitor.setMessage("Writing " + this.gslOutfile.getName());
                        ArchiveConverterPlugin.this.writeAsGsl(this.gslOutfile, (DataTypeManager)dtMgr, monitor);
                    }
                    finally {
                        dtMgr.close();
                    }
                }
            }
        }
    }

    private class GSLParserTask
    extends Task {
        PluginTool myTool;
        File gslArchive;

        public GSLParserTask(PluginTool tool, File gslArchive) {
            super("GSL Archive Parser", true, true, false);
            this.gslArchive = gslArchive;
            this.myTool = tool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            block15: {
                int lineCount = 0;
                try {
                    if (this.gslArchive == null) break block15;
                    String gslName = this.gslArchive.getName();
                    String gslNameWithPath = this.gslArchive.getAbsolutePath();
                    monitor.setMessage("Parsing " + gslName);
                    FileDataTypeManager dtMgr = FileDataTypeManager.createFileArchive((File)new File(gslNameWithPath + ".gdt"));
                    int id = dtMgr.startTransaction("process archive");
                    try {
                        String line;
                        ArchiveConverterPlugin.this.addPrimitives(dtMgr);
                        BufferedReader reader = new BufferedReader(new FileReader(this.gslArchive));
                        while (reader.readLine() != null) {
                            ++lineCount;
                        }
                        reader.close();
                        monitor.initialize((long)lineCount);
                        reader = new BufferedReader(new FileReader(this.gslArchive));
                        lineCount = 0;
                        DataType dt = null;
                        while ((line = reader.readLine()) != null && !monitor.isCancelled()) {
                            try {
                                dt = ArchiveConverterPlugin.this.parseLine(dtMgr, line);
                                if (dt != null) {
                                    ArchiveConverterPlugin.this.addDataType(dtMgr, ArchiveConverterPlugin.this.dataTypes, dt);
                                }
                                if (lineCount % 100 == 0) {
                                    monitor.setProgress((long)lineCount);
                                }
                                ++lineCount;
                            }
                            catch (Exception e) {
                                Msg.error((Object)((Object)this), (Object)("Error in " + ArchiveConverterPlugin.this.name + " at line " + lineCount + " of " + this.gslArchive.getName() + "...possibly an attempt to redefine a Ghidra primitive"), (Throwable)e);
                            }
                        }
                        reader.close();
                    }
                    finally {
                        dtMgr.endTransaction(id, true);
                    }
                    monitor.setMessage("Checking for parser errors");
                    ArchiveConverterPlugin.this.searchForErrors(dtMgr);
                    monitor.setMessage("Writing XML file");
                    try {
                        DataTypesXmlMgr.writeAsXMLForDebug((DataTypeManager)dtMgr, gslNameWithPath);
                    }
                    catch (Exception e) {
                        Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    }
                    try {
                        dtMgr.save();
                    }
                    catch (Exception e) {
                        Msg.showError((Object)((Object)this), (Component)this.myTool.getToolFrame(), (String)"GSL Archive Parser", (Object)(gslNameWithPath + ".gdt already exists - not overwritten"), (Throwable)e);
                    }
                    dtMgr.close();
                }
                catch (Exception e) {
                    Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

