/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDACallSiteRecord;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAHeader;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LSDACallSiteTable
extends GccAnalysisClass {
    private AddressRange bounds;
    private Address nextAddress;
    private RegionDescriptor region;
    private List<LSDACallSiteRecord> records = new ArrayList<LSDACallSiteRecord>();

    public LSDACallSiteTable(TaskMonitor monitor, Program program, RegionDescriptor region) {
        super(monitor, program);
        this.region = region;
    }

    public void create(Address addr) throws MemoryAccessException {
        LSDACallSiteRecord rec;
        this.records.clear();
        if (addr == null || this.monitor.isCancelled()) {
            return;
        }
        LSDAHeader header = this.region.getLSDATable().getHeader();
        if (header.getCallSiteTableLength() <= 0) {
            return;
        }
        Address baseAddr = addr;
        this.monitor.setMessage("Creating GCC LSDA Call Site Table ");
        SetCommentCmd commentCmd = new SetCommentCmd(baseAddr, 3, "(LSDA) Call Site Table");
        commentCmd.applyTo((DomainObject)this.program);
        Address limit = baseAddr.add((long)(header.getCallSiteTableLength() - 1));
        DwarfEHDecoder callSiteDecoder = DwarfDecoderFactory.getDecoder(header.getCallSiteTableEncoding());
        long remain = limit.subtract(addr);
        do {
            rec = new LSDACallSiteRecord(this.monitor, this.program, this.region);
            rec.create(addr, callSiteDecoder);
            this.verifyCallSiteRecord(rec);
            this.records.add(rec);
        } while ((remain = limit.subtract(addr = rec.getNextAddress())) > 0L);
        this.bounds = new AddressRangeImpl(baseAddr, baseAddr.add((long)header.getCallSiteTableLength()));
        this.nextAddress = addr;
    }

    Address getTableEndAddress() {
        return this.bounds.getMaxAddress();
    }

    Address getNextAddress() {
        return this.nextAddress;
    }

    public List<LSDACallSiteRecord> getCallSiteRecords() {
        return Collections.unmodifiableList(this.records);
    }

    private static boolean contains(AddressRange container, AddressRange child) {
        return container.getMinAddress().compareTo((Object)child.getMinAddress()) <= 0 && container.getMaxAddress().compareTo((Object)child.getMaxAddress()) >= 0;
    }

    private void verifyCallSiteRecord(LSDACallSiteRecord rec) {
        AddressRange body = this.region.getRange();
        boolean containsCallSite = LSDACallSiteTable.contains(body, rec.getCallSite());
        boolean containsLandingPad = body.contains(rec.getLandingPad());
        if (containsCallSite && containsLandingPad) {
            return;
        }
        if (!containsCallSite) {
            Msg.error((Object)this, (Object)"Function body does not fully contain the call site area");
        }
        if (!containsLandingPad) {
            Msg.error((Object)this, (Object)"Function body does not contain the landing pad");
        }
    }
}

