/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.dbtable;

import db.BinaryField;
import db.BooleanField;
import db.ByteField;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.debug.dbtable.AbstractColumnAdapter;
import ghidra.app.plugin.debug.dbtable.BinaryColumnAdapter;
import ghidra.app.plugin.debug.dbtable.BooleanColumnAdapter;
import ghidra.app.plugin.debug.dbtable.ByteColumnAdapter;
import ghidra.app.plugin.debug.dbtable.IntegerColumnAdapter;
import ghidra.app.plugin.debug.dbtable.LongColumnAdapter;
import ghidra.app.plugin.debug.dbtable.ShortColumnAdapter;
import ghidra.app.plugin.debug.dbtable.StringColumnAdapter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DbSmallTableModel
extends AbstractSortedTableModel<Record> {
    private Table table;
    private Schema schema;
    private List<AbstractColumnAdapter> columns = new ArrayList<AbstractColumnAdapter>();
    private List<Record> records;

    public DbSmallTableModel(Table table) {
        this.table = table;
        this.schema = table.getSchema();
        this.records = new ArrayList<Record>(table.getRecordCount());
        this.columns.add(this.getColumn(this.schema.getKeyFieldClass()));
        Class[] classes = this.schema.getFieldClasses();
        int fieldCount = this.schema.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            this.columns.add(this.getColumn(classes[i]));
        }
        try {
            RecordIterator it = table.iterator();
            while (it.hasNext()) {
                this.records.add(it.next());
            }
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private AbstractColumnAdapter getColumn(Class<?> c) {
        if (c == ByteField.class) {
            return new ByteColumnAdapter();
        }
        if (c == BooleanField.class) {
            return new BooleanColumnAdapter();
        }
        if (c == ShortField.class) {
            return new ShortColumnAdapter();
        }
        if (c == IntField.class) {
            return new IntegerColumnAdapter();
        }
        if (c == LongField.class) {
            return new LongColumnAdapter();
        }
        if (c == StringField.class) {
            return new StringColumnAdapter();
        }
        if (c == BinaryField.class) {
            return new BinaryColumnAdapter();
        }
        throw new AssertException("New, unexpected DB column class type: " + c);
    }

    public String getName() {
        return "DB Small Table";
    }

    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getValueClass();
    }

    public int getColumnCount() {
        return this.schema.getFieldCount() + 1;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.schema.getKeyName();
        }
        --columnIndex;
        int[] indexCols = this.table.getIndexedColumns();
        boolean isIndexed = false;
        for (int indexCol : indexCols) {
            if (indexCol != columnIndex) continue;
            isIndexed = true;
            break;
        }
        return this.schema.getFieldNames()[columnIndex] + (isIndexed ? "*" : "");
    }

    public int getRowCount() {
        return this.table.getRecordCount();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getColumnValueForRow(Record rec, int columnIndex) {
        if (columnIndex == 0) {
            return this.columns.get(columnIndex).getKeyValue(rec);
        }
        int dbColumn = columnIndex - 1;
        return this.columns.get(columnIndex).getValue(rec, dbColumn);
    }

    public List<Record> getModelData() {
        return this.records;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }
}

