/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.util.MarkerLocation;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class PointMarkerSet
extends MarkerSetImpl {
    private Image image;
    private ImageObserver imageObserver;
    private Color fillColor;

    PointMarkerSet(MarkerManager navigationManager, String name, String desc, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color markerColor, ImageIcon icon, boolean isPreferred) {
        super(navigationManager, name, desc, priority, showMarkers, showNavigation, colorBackground, markerColor, isPreferred);
        if (icon == null) {
            icon = ResourceManager.loadImage((String)"images/warning.png");
        }
        icon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16, (int)4);
        this.image = icon.getImage();
        this.imageObserver = icon.getImageObserver();
        if (markerColor != null) {
            this.fillColor = PointMarkerSet.getFillColor(markerColor);
        }
    }

    PointMarkerSet(MarkerManager navigationManager, String name, String desc, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color markerColor, ImageIcon icon) {
        this(navigationManager, name, desc, priority, showMarkers, showNavigation, colorBackground, markerColor, icon, true);
    }

    @Override
    protected void doPaintMarkers(Graphics g, VerticalPixelAddressMap pixmap, int index, AddressIndexMap map, List<Integer> layouts) {
        if (layouts == null) {
            return;
        }
        for (int i : layouts) {
            ImageIcon icon;
            int yStart = pixmap.getMarkPosition(i);
            Image curImage = this.image;
            if (this.listener != null && (icon = this.listener.getIcon(new MarkerLocation(this, pixmap.getLayoutAddress(i), 0, yStart))) != null) {
                curImage = icon.getImage();
            }
            g.drawImage(curImage, 0, yStart, this.imageObserver);
        }
    }

    @Override
    protected void doPaintNavigation(Graphics g, int height, int width, SortedRangeList rangeList) {
        if (rangeList == null) {
            return;
        }
        g.setColor(this.markerColor);
        for (Range range : rangeList) {
            int endY = range.max;
            int startY = range.min;
            if ((endY - startY) % 2 != 0) {
                // empty if block
            }
            for (int y = --endY; y >= startY; y -= 2) {
                int paintY = Math.min(height - 4, y);
                g.setColor(this.fillColor);
                g.fillRect(0, paintY, width - 7, 4);
                g.setColor(this.markerColor);
                g.drawRect(0, paintY, width - 7, 4);
            }
        }
    }

    @Override
    public ImageIcon getNavIcon() {
        BufferedImage bufferedImage = new BufferedImage(14, 14, 2);
        Graphics2D g = bufferedImage.createGraphics();
        int height = 4;
        int width = 2 * height;
        int x = (14 - width) / 2;
        int y = (14 - height) / 2;
        g.setColor(this.markerColor);
        g.fillRect(x - 1, y - 1, width + 2, height + 2);
        g.setColor(this.fillColor);
        g.fillRect(x, y, width, height);
        return ResourceManager.getImageIconFromImage((String)"Point Marker Set Nav Icon", (Image)bufferedImage);
    }
}

