/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.util.AddEditDialog;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

class EditNameAction
extends ListingContextAction {
    FunctionPlugin functionPlugin;
    private boolean isFunction;

    EditNameAction(boolean isFunction, FunctionPlugin plugin) {
        super(isFunction ? "Rename Function" : "Rename Variable", plugin.getName());
        this.functionPlugin = plugin;
        this.isFunction = isFunction;
        this.setKeyBindingData(new KeyBindingData(76, 0));
        if (isFunction) {
            this.setPopupMenuPath("Function", "Function", "Function");
            this.setHelpLocation(new HelpLocation(this.functionPlugin.getName(), "Rename_Function"));
        } else {
            this.setPopupMenuPath("Variable", "Function Variables", "FunctionVariable");
            this.setHelpLocation(new HelpLocation(this.functionPlugin.getName(), "Rename_Variable"));
        }
    }

    private void setPopupMenuPath(String itemName, String pullright, String group) {
        this.setPopupMenuData(new MenuData(new String[]{pullright, "Rename " + itemName + "..."}, null, group));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function;
        ProgramLocation loc = context.getLocation();
        Program program = context.getProgram();
        if (loc instanceof FunctionSignatureFieldLocation) {
            Function function2 = this.functionPlugin.getFunction(context);
            if (function2 != null) {
                AddEditDialog dialog = new AddEditDialog("Edit Function Name", this.functionPlugin.getTool());
                dialog.editLabel(function2.getSymbol(), program);
            }
        } else if (loc instanceof VariableLocation) {
            Variable variable = ((VariableLocation)loc).getVariable();
            Symbol s = variable.getSymbol();
            if (s == null) {
                Msg.showError((Object)((Object)this), null, (String)"Edit Failed", (Object)"Variable may not be modified");
                return;
            }
            AddEditDialog dialog = new AddEditDialog("Edit Variable Name", this.functionPlugin.getTool());
            dialog.editLabel(s, program);
        } else if (loc instanceof OperandFieldLocation && (function = this.functionPlugin.getFunctionInOperandField(program, (OperandFieldLocation)loc)) != null) {
            AddEditDialog dialog = new AddEditDialog("Edit Function Name", this.functionPlugin.getTool());
            dialog.editLabel(function.getSymbol(), program);
        }
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation loc = context.getLocation();
        if (!this.isFunction && loc instanceof VariableLocation) {
            Variable variable = ((VariableLocation)loc).getVariable();
            if (variable.getSymbol() == null) {
                return false;
            }
            this.setPopupMenuPath(variable instanceof Parameter ? "Parameter" : "Local Variable", "Function Variables", "FunctionVariable");
            return true;
        }
        if (this.isFunction && loc instanceof FunctionSignatureFieldLocation) {
            return true;
        }
        if (this.isFunction && loc instanceof OperandFieldLocation) {
            Function function = this.functionPlugin.getFunctionInOperandField(context.getProgram(), (OperandFieldLocation)loc);
            return function != null && !function.isExternal();
        }
        return false;
    }
}

