/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class FindBaseDataTypeAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public FindBaseDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Show Base Data Type", plugin.getName());
        this.plugin = plugin;
        String menuGroup = "ZVeryLast";
        this.setPopupMenuData(new MenuData(new String[]{"Show Base Data Type"}, null, menuGroup));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dtNode = (DataTypeNode)node;
        DataType dt = dtNode.getDataType();
        return dt instanceof TypeDef || dt instanceof Array || dt instanceof Pointer;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        DataTypeNode dataTypeNode = (DataTypeNode)selectionPaths[0].getLastPathComponent();
        DataType baseDataType = DataTypeUtils.getBaseDataType(dataTypeNode.getDataType());
        PluginTool tool = this.plugin.getTool();
        DataTypeManagerService service = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        SwingUtilities.invokeLater(() -> service.setDataTypeSelected(baseDataType));
    }
}

